"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isCompleteHandler = exports.onEventHandler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
async function onEventHandler(event) {
    console.log('Event: %j', event);
    /**
     * Process only Create and Delete requests. We shouldn't receive any
     * update request and in case we do there is nothing to update.
     */
    if (event.RequestType === 'Create' || event.RequestType === 'Delete') {
        const dynamodb = new aws_sdk_1.DynamoDB();
        const data = await dynamodb.updateTable({
            TableName: event.ResourceProperties.TableName,
            ReplicaUpdates: [
                {
                    [event.RequestType]: {
                        RegionName: event.ResourceProperties.Region,
                    },
                },
            ],
        }).promise();
        console.log('Update table: %j', data);
    }
    return { PhysicalResourceId: event.ResourceProperties.Region };
}
exports.onEventHandler = onEventHandler;
async function isCompleteHandler(event) {
    var _a, _b, _c;
    console.log('Event: %j', event);
    const dynamodb = new aws_sdk_1.DynamoDB();
    const data = await dynamodb.describeTable({
        TableName: event.ResourceProperties.TableName,
    }).promise();
    console.log('Describe table: %j', data);
    const tableActive = !!(((_a = data.Table) === null || _a === void 0 ? void 0 : _a.TableStatus) === 'ACTIVE');
    const replicas = (_c = (_b = data.Table) === null || _b === void 0 ? void 0 : _b.Replicas) !== null && _c !== void 0 ? _c : [];
    const regionReplica = replicas.find(r => r.RegionName === event.ResourceProperties.Region);
    const replicaActive = !!((regionReplica === null || regionReplica === void 0 ? void 0 : regionReplica.ReplicaStatus) === 'ACTIVE');
    switch (event.RequestType) {
        case 'Create':
        case 'Update':
            // Complete when replica is reported as ACTIVE
            return { IsComplete: tableActive && replicaActive };
        case 'Delete':
            // Complete when replica is gone
            return { IsComplete: tableActive && regionReplica === undefined };
    }
}
exports.isCompleteHandler = isCompleteHandler;
//# sourceMappingURL=data:application/json;base64,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