"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(props) {
        this.props = props;
        this.origin = props.origin;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.origin.id,
            allowedMethods: (_b = (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods) !== null && _b !== void 0 ? _b : undefined,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            viewerProtocolPolicy: distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
            lambdaFunctionAssociations: this.props.edgeLambdas
                ? this.props.edgeLambdas.map(edgeLambda => {
                    if (edgeLambda.functionVersion.version === '$LATEST') {
                        throw new Error('$LATEST function version cannot be used for Lambda@Edge');
                    }
                    return {
                        lambdaFunctionArn: edgeLambda.functionVersion.functionArn,
                        eventType: edgeLambda.eventType.toString(),
                    };
                })
                : undefined,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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