"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Origin = void 0;
const cloudfront = require("../../aws-cloudfront"); // Automatically re-written from '@aws-cdk/aws-cloudfront'
/**
 * An Origin that is backed by an S3 bucket.
 *
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 *
 * @experimental
 */
class S3Origin extends cloudfront.Origin {
    constructor(bucket, props = {}) {
        let proxyOrigin;
        if (bucket.isWebsite) {
            proxyOrigin = new cloudfront.HttpOrigin(bucket.bucketWebsiteDomainName, {
                protocolPolicy: cloudfront.OriginProtocolPolicy.HTTP_ONLY,
                ...props,
            });
        }
        else {
            proxyOrigin = new cloudfront.S3Origin({
                bucket,
                ...props,
            });
        }
        super(proxyOrigin.domainName);
        this.origin = proxyOrigin;
    }
    get id() {
        return this.origin.id;
    }
    bind(scope, options) {
        this.origin.bind(scope, options);
    }
    renderOrigin() {
        return this.origin.renderOrigin();
    }
}
exports.S3Origin = S3Origin;
//# sourceMappingURL=data:application/json;base64,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