import sys
import typing
import bpy.context
import mathutils
import bl_ui.space_view3d_toolbar
import bl_operators.view3d
import bl_ui.properties_data_shaderfx
import bl_ui.properties_render
import bl_ui.space_info
import bl_ui.properties_data_lightprobe
import bl_ui.properties_texture
import bl_ui.properties_grease_pencil_common
import bl_ui.space_statusbar
import bl_ui.space_spreadsheet
import bl_ui.space_sequencer
import bl_ui.space_dopesheet
import bl_ui.space_filebrowser
import bl_ui.properties_physics_rigidbody
import bl_ui.properties_freestyle
import bl_ui.space_view3d
import bl_ui.properties_collection
import bl_ui.properties_data_speaker
import bl_ui.properties_particle
import bl_ui.properties_data_lattice
import bl_ui.properties_mask_common
import bl_ui.properties_object
import bl_operators.node
import bl_ui.properties_world
import bl_ui.properties_data_armature
import bl_ui.properties_data_modifier
import bl_ui.space_toolsystem_common
import bl_operators.anim
import bl_ui.properties_physics_common
import bl_ui.properties_physics_dynamicpaint
import bl_operators.assets
import bl_ui.space_nla
import bl_ui.space_properties
import bl_ui.properties_view_layer
import bl_ui.properties_physics_fluid
import bl_operators.freestyle
import bl_ui.space_topbar
import bl_ui.properties_data_light
import bl_ui.space_clip
import bl_ui.properties_data_volume
import bl_ui.space_toolsystem_toolbar
import bl_ui.properties_paint_common
import bl_operators.spreadsheet
import bl_ui.properties_physics_rigidbody_constraint
import bl_ui.properties_physics_softbody
import bl_ui.properties_data_mesh
import bl_ui.properties_constraint
import bl_operators.userpref
import bl_ui.space_graph
import bl_ui.space_time
import bl_ui.space_text
import bl_ui.space_console
import bl_ui.properties_data_bone
import bl_ui.properties_data_empty
import bl_ui.properties_data_camera
import bl_ui.properties_physics_field
import bl_ui.properties_scene
import bl_ui.properties_data_pointcloud
import bl_operators.wm
import bl_ui.properties_material_gpencil
import bl_ui.space_userpref
import bl_ui.properties_data_gpencil
import bl_ui.properties_physics_cloth
import bl_ui.space_node
import bl_operators.presets
import bl_ui.properties_data_hair
import bl_ui.space_outliner
import bl_operators.object
import bl_ui.properties_material
import bl_ui.space_image
import bl_ui.properties_data_curve
import bl_operators.clip
import bl_operators.file
import bl_operators.constraint
import bl_ui
import bl_ui.properties_output
import bl_ui.properties_workspace
import bl_ui.properties_data_metaball


class bpy_prop_collection:
    ''' built-in class used for all collections.
    '''

    def find(self, key: str) -> int:
        ''' Returns the index of a key in a collection or -1 when not found (matches Python's string find function of the same name).

        :param key: The identifier for the collection member.
        :type key: str
        :rtype: int
        :return: index of the key.
        '''
        pass

    def foreach_get(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! Multi-dimensional arrays (like array of vectors) will be flattened into seq.

        '''
        pass

    def foreach_set(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

        '''
        pass

    def get(self, key: str, default=None):
        ''' Returns the value of the item assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The identifier for the collection member.
        :type key: str
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: 
        '''
        pass

    def items(self) -> list:
        ''' Return the identifiers of collection members (matching Python's dict.items() functionality).

        :rtype: list
        :return: (key, value) pairs for each member of this collection.
        '''
        pass

    def keys(self) -> list:
        ''' Return the identifiers of collection members (matching Python's dict.keys() functionality).

        :rtype: list
        :return: the identifiers for each member of this collection.
        '''
        pass

    def values(self) -> list:
        ''' Return the values of collection (matching Python's dict.values() functionality).

        :rtype: list
        :return: the members of this collection.
        '''
        pass


class bpy_struct:
    ''' built-in base class for all classes in bpy.types.
    '''

    id_data = None
    ''' The bpy.types.ID object this datablock is from or None, (not available for all data types)'''

    def as_pointer(self) -> int:
        ''' Returns the memory address which holds a pointer to Blender's internal data

        :rtype: int
        :return: int (memory address).
        '''
        pass

    def driver_add(self, path: str, index: int = -1) -> typing.List['FCurve']:
        ''' Adds driver(s) to the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: str
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: int
        :rtype: typing.List['FCurve']
        :return: The driver(s) added.
        '''
        pass

    def driver_remove(self, path: str, index: int = -1) -> bool:
        ''' Remove driver(s) from the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: str
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: int
        :rtype: bool
        :return: Success of driver removal.
        '''
        pass

    def get(self, key: str, default=None):
        ''' Returns the value of the custom property assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The key associated with the custom property.
        :type key: str
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: 
        '''
        pass

    def is_property_hidden(self, property) -> bool:
        ''' Check if a property is hidden.

        :rtype: bool
        :return: True when the property is hidden.
        '''
        pass

    def is_property_overridable_library(self, property) -> bool:
        ''' Check if a property is overridable.

        :rtype: bool
        :return: True when the property is overridable.
        '''
        pass

    def is_property_readonly(self, property) -> bool:
        ''' Check if a property is readonly.

        :rtype: bool
        :return: True when the property is readonly (not writable).
        '''
        pass

    def is_property_set(self, property, ghost: bool = True) -> bool:
        ''' Check if a property is set, use for testing operator properties.

        :param ghost: Used for operators that re-run with previous settings. In this case the property is not marked as set, yet the value from the previous execution is used. In rare cases you may want to set this option to false.
        :type ghost: bool
        :rtype: bool
        :return: True when the property has been set.
        '''
        pass

    def items(self) -> list:
        ''' Returns the items of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: list
        :return: custom property key, value pairs.
        '''
        pass

    def keyframe_delete(self,
                        data_path: str,
                        index: int = -1,
                        frame: float = 'bpy.context.scene.frame_current',
                        group: str = "") -> bool:
        ''' Remove a keyframe from this properties fcurve.

        :param data_path: path to the property to remove a key, analogous to the fcurve's data path.
        :type data_path: str
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array.
        :type index: int
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame.
        :type frame: float
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: str
        :rtype: bool
        :return: Success of keyframe deletion.
        '''
        pass

    def keyframe_insert(self,
                        data_path: str,
                        index: int = -1,
                        frame: float = 'bpy.context.scene.frame_current',
                        group: str = "",
                        options='set()') -> bool:
        ''' Insert a keyframe on the property given, adding fcurves and animation data when necessary. This is the most simple example of inserting a keyframe from python. Note that when keying data paths which contain nested properties this must be done from the ID subclass, in this case the Armature rather than the bone.

        :param data_path: path to the property to key, analogous to the fcurve's data path.
        :type data_path: str
        :param index: array index of the property to key. Defaults to -1 which will key all indices or a single channel if the property is not an array.
        :type index: int
        :param frame: The frame on which the keyframe is inserted, defaulting to the current frame.
        :type frame: float
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: str
        :param flag: 
        :type flag: set
        :param options: 
        :type options: 
        :rtype: bool
        :return: Success of keyframe insertion.
        '''
        pass

    def keys(self) -> list:
        ''' Returns the keys of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: list
        :return: custom property keys.
        '''
        pass

    def path_from_id(self, property: str = "") -> str:
        ''' Returns the data path from the ID to this object (string).

        :param property: Optional property name which can be used if the path is to a property of this object.
        :type property: str
        :rtype: str
        :return: bpy.types.bpy_struct.id_data to this struct and property (when given).
        '''
        pass

    def path_resolve(self, path: str, coerce: bool = True):
        ''' Returns the property from the path, raise an exception when not found.

        :param path: path which this property resolves.
        :type path: str
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: bool
        '''
        pass

    def pop(self, key: str, default=None):
        ''' Remove and return the value of the custom property assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The key associated with the custom property.
        :type key: str
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: 
        '''
        pass

    def property_overridable_library_set(self, property, overridable) -> bool:
        ''' Define a property as overridable or not (only for custom properties!).

        :rtype: bool
        :return: True when the overridable status of the property was successfully set.
        '''
        pass

    def property_unset(self, property):
        ''' Unset a property, will use default value afterward.

        '''
        pass

    def type_recast(self) -> 'bpy_struct':
        ''' Return a new instance, this is needed because types such as textures can be changed at runtime.

        :rtype: 'bpy_struct'
        :return: a new instance of this object with the type initialized again.
        '''
        pass

    def values(self) -> list:
        ''' Returns the values of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: list
        :return: custom property values.
        '''
        pass


class AOV(bpy_struct):
    is_valid: bool = None
    ''' Is the name of the AOV conflicting

    :type: bool
    '''

    name: str = None
    ''' Name of the AOV

    :type: str
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the AOV

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AOVs(bpy_struct):
    ''' Collection of AOVs
    '''

    def add(self) -> 'AOV':
        ''' add

        :rtype: 'AOV'
        :return: Newly created AOV
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ActionFCurves(bpy_struct):
    ''' Collection of action F-Curves
    '''

    def new(self, data_path: str, index: int = 0,
            action_group: str = "") -> 'FCurve':
        ''' Add an F-Curve to the action

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: str
        :param index: Index, Array index
        :type index: int
        :param action_group: Action Group, Acton group to add this F-Curve into
        :type action_group: str
        :rtype: 'FCurve'
        :return: Newly created F-Curve
        '''
        pass

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        ''' Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the action.

        :param data_path: Data Path, F-Curve data path
        :type data_path: str
        :param index: Index, Array index
        :type index: int
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass

    def remove(self, fcurve: 'FCurve'):
        ''' Remove action group

        :param fcurve: F-Curve to remove
        :type fcurve: 'FCurve'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ActionGroup(bpy_struct):
    ''' Groups of F-Curves
    '''

    channels: typing.Union[typing.Dict[str, 'FCurve'], typing.
                           List['FCurve'], 'bpy_prop_collection'] = None
    ''' F-Curves in this group

    :type: typing.Union[typing.Dict[str, 'FCurve'], typing.List['FCurve'], 'bpy_prop_collection']
    '''

    color_set: typing.Union[str, int] = None
    ''' Custom color set to use

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    ''' Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: bool = None
    ''' Color set is user-defined instead of a fixed theme color set

    :type: bool
    '''

    lock: bool = None
    ''' Action group is locked

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    select: bool = None
    ''' Action group is selected

    :type: bool
    '''

    show_expanded: bool = None
    ''' Action group is expanded except in graph editor

    :type: bool
    '''

    show_expanded_graph: bool = None
    ''' Action group is expanded in graph editor

    :type: bool
    '''

    use_pin: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ActionGroups(bpy_struct):
    ''' Collection of action groups
    '''

    def new(self, name: str) -> 'ActionGroup':
        ''' Create a new action group and add it to the action

        :param name: New name for the action group
        :type name: str
        :rtype: 'ActionGroup'
        :return: Newly created action group
        '''
        pass

    def remove(self, action_group: 'ActionGroup'):
        ''' Remove action group

        :param action_group: Action group to remove
        :type action_group: 'ActionGroup'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ActionPoseMarkers(bpy_struct):
    ''' Collection of timeline markers
    '''

    active: 'TimelineMarker' = None
    ''' Active pose marker for this action

    :type: 'TimelineMarker'
    '''

    active_index: int = None
    ''' Index of active pose marker

    :type: int
    '''

    def new(self, name: str) -> 'TimelineMarker':
        ''' Add a pose marker to the action

        :param name: New name for the marker (not unique)
        :type name: str
        :rtype: 'TimelineMarker'
        :return: Newly created marker
        '''
        pass

    def remove(self, marker: 'TimelineMarker'):
        ''' Remove a timeline marker

        :param marker: Timeline marker to remove
        :type marker: 'TimelineMarker'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Addon(bpy_struct):
    ''' Python add-ons to be loaded automatically
    '''

    module: str = None
    ''' Module name

    :type: str
    '''

    preferences: 'AddonPreferences' = None
    ''' 

    :type: 'AddonPreferences'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AddonPreferences(bpy_struct):
    bl_idname: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Addons(bpy_struct):
    ''' Collection of add-ons
    '''

    @classmethod
    def new(cls) -> 'Addon':
        ''' Add a new add-on

        :rtype: 'Addon'
        :return: Add-on data
        '''
        pass

    @classmethod
    def remove(cls, addon: 'Addon'):
        ''' Remove add-on

        :param addon: Add-on to remove
        :type addon: 'Addon'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AlembicObjectPath(bpy_struct):
    ''' Path of an object inside of an Alembic archive
    '''

    path: str = None
    ''' Object path

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AlembicObjectPaths(bpy_struct):
    ''' Collection of object paths
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AnimData(bpy_struct):
    ''' Animation data for data-block
    '''

    action: 'Action' = None
    ''' Active Action for this data-block

    :type: 'Action'
    '''

    action_blend_type: typing.Union[str, int] = None
    ''' Method used for combining Active Action's result with result of NLA stack * REPLACE Replace, The strip values replace the accumulated results by amount specified by influence. * COMBINE Combine, The strip values are combined with accumulated results by appropriately using addition, multiplication, or quaternion math, based on channel type. * ADD Add, Weighted result of strip is added to the accumulated results. * SUBTRACT Subtract, Weighted result of strip is removed from the accumulated results. * MULTIPLY Multiply, Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    action_extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the Active Action's range (when evaluating with NLA) * NOTHING Nothing, Strip has no influence past its extents. * HOLD Hold, Hold the first frame if no previous strips in track, and always hold last frame. * HOLD_FORWARD Hold Forward, Only hold last frame.

    :type: typing.Union[str, int]
    '''

    action_influence: float = None
    ''' Amount the Active Action contributes to the result of the NLA stack

    :type: float
    '''

    drivers: typing.Union[typing.Dict[str, 'FCurve'], typing.List['FCurve'],
                          'bpy_prop_collection', 'AnimDataDrivers'] = None
    ''' The Drivers/Expressions for this data-block

    :type: typing.Union[typing.Dict[str, 'FCurve'], typing.List['FCurve'], 'bpy_prop_collection', 'AnimDataDrivers']
    '''

    nla_tracks: typing.Union[typing.Dict[str, 'NlaTrack'], typing.
                             List['NlaTrack'], 'bpy_prop_collection',
                             'NlaTracks'] = None
    ''' NLA Tracks (i.e. Animation Layers)

    :type: typing.Union[typing.Dict[str, 'NlaTrack'], typing.List['NlaTrack'], 'bpy_prop_collection', 'NlaTracks']
    '''

    use_nla: bool = None
    ''' NLA stack is evaluated when evaluating this block

    :type: bool
    '''

    use_pin: bool = None
    ''' 

    :type: bool
    '''

    use_tweak_mode: bool = None
    ''' Whether to enable or disable tweak mode in NLA

    :type: bool
    '''

    def nla_tweak_strip_time_to_scene(self, frame: float,
                                      invert: bool = False) -> float:
        ''' Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking.

        :param frame: Input time
        :type frame: float
        :param invert: Invert, Convert scene time to action time
        :type invert: bool
        :rtype: float
        :return: Converted time
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AnimDataDrivers(bpy_struct):
    ''' Collection of Driver F-Curves
    '''

    def new(self, data_path: str, index: int = 0) -> 'FCurve':
        ''' new

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: str
        :param index: Index, Array index
        :type index: int
        :rtype: 'FCurve'
        :return: Newly Driver F-Curve
        '''
        pass

    def remove(self, driver: 'FCurve'):
        ''' remove

        :param driver: 
        :type driver: 'FCurve'
        '''
        pass

    def from_existing(self, src_driver: 'FCurve' = None) -> 'FCurve':
        ''' Add a new driver given an existing one

        :param src_driver: Existing Driver F-Curve to use as template for a new one
        :type src_driver: 'FCurve'
        :rtype: 'FCurve'
        :return: New Driver F-Curve
        '''
        pass

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        ''' Find a driver F-Curve. Note that this function performs a linear scan of all driver F-Curves.

        :param data_path: Data Path, F-Curve data path
        :type data_path: str
        :param index: Index, Array index
        :type index: int
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AnimViz(bpy_struct):
    ''' Settings for the visualization of motion
    '''

    motion_path: 'AnimVizMotionPaths' = None
    ''' Motion Path settings for visualization

    :type: 'AnimVizMotionPaths'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AnimVizMotionPaths(bpy_struct):
    ''' Motion Path settings for animation visualization
    '''

    bake_location: typing.Union[str, int] = None
    ''' When calculating Bone Paths, use Head or Tips * HEADS Heads, Calculate bone paths from heads. * TAILS Tails, Calculate bone paths from tails.

    :type: typing.Union[str, int]
    '''

    frame_after: int = None
    ''' Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_before: int = None
    ''' Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_end: int = None
    ''' End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    '''

    has_motion_paths: bool = None
    ''' Are there any bone paths that will need updating (read-only)

    :type: bool
    '''

    show_frame_numbers: bool = None
    ''' Show frame numbers on Motion Paths

    :type: bool
    '''

    show_keyframe_action_all: bool = None
    ''' For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    '''

    show_keyframe_highlight: bool = None
    ''' Emphasize position of keyframes on Motion Paths

    :type: bool
    '''

    show_keyframe_numbers: bool = None
    ''' Show frame numbers of Keyframes on Motion Paths

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of range to show for Motion Paths * CURRENT_FRAME Around Frame, Display Paths of poses within a fixed number of frames around the current frame. * RANGE In Range, Display Paths of poses within specified range.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AnyType(bpy_struct):
    ''' RNA type used for pointers to any possible data
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Area(bpy_struct):
    ''' Area in a subdivided screen, containing an editor
    '''

    height: int = None
    ''' Area height

    :type: int
    '''

    regions: typing.Union[typing.Dict[str, 'Region'], typing.
                          List['Region'], 'bpy_prop_collection'] = None
    ''' Regions this area is subdivided in

    :type: typing.Union[typing.Dict[str, 'Region'], typing.List['Region'], 'bpy_prop_collection']
    '''

    show_menus: bool = None
    ''' Show menus in the header

    :type: bool
    '''

    spaces: typing.Union[typing.Dict[str, 'Space'], typing.List['Space'],
                         'bpy_prop_collection', 'AreaSpaces'] = None
    ''' Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: typing.Union[typing.Dict[str, 'Space'], typing.List['Space'], 'bpy_prop_collection', 'AreaSpaces']
    '''

    type: typing.Union[str, int] = None
    ''' Current editor type for this area * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    ui_type: typing.Union[str, int] = None
    ''' Current editor type for this area

    :type: typing.Union[str, int]
    '''

    width: int = None
    ''' Area width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the area

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the area

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass

    def header_text_set(self, text: str):
        ''' Set the header status text

        :param text: Text, New string for the header, None clears the text
        :type text: str
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AreaSpaces(bpy_struct):
    ''' Collection of spaces
    '''

    active: 'Space' = None
    ''' Space currently being displayed in this area

    :type: 'Space'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ArmatureBones(bpy_struct):
    ''' Collection of armature bones
    '''

    active: 'Bone' = None
    ''' Armature's active bone

    :type: 'Bone'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ArmatureConstraintTargets(bpy_struct):
    ''' Collection of target bones and weights
    '''

    def new(self) -> 'ConstraintTargetBone':
        ''' Add a new target to the constraint

        :rtype: 'ConstraintTargetBone'
        :return: New target bone
        '''
        pass

    def remove(self, target: 'ConstraintTargetBone'):
        ''' Delete target from the constraint

        :param target: Target to remove
        :type target: 'ConstraintTargetBone'
        '''
        pass

    def clear(self):
        ''' Delete all targets from object

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ArmatureEditBones(bpy_struct):
    ''' Collection of armature edit bones
    '''

    active: 'EditBone' = None
    ''' Armatures active edit bone

    :type: 'EditBone'
    '''

    def new(self, name: str) -> 'EditBone':
        ''' Add a new bone

        :param name: New name for the bone
        :type name: str
        :rtype: 'EditBone'
        :return: Newly created edit bone
        '''
        pass

    def remove(self, bone: 'EditBone'):
        ''' Remove an existing bone from the armature

        :param bone: EditBone to remove
        :type bone: 'EditBone'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AssetMetaData(bpy_struct):
    ''' Additional data stored for an asset data-block
    '''

    active_tag: int = None
    ''' Index of the tag set for editing

    :type: int
    '''

    description: str = None
    ''' A description of the asset to be displayed for the user

    :type: str
    '''

    tags: typing.Union[typing.Dict[str, 'AssetTag'], typing.List['AssetTag'],
                       'bpy_prop_collection', 'AssetTags'] = None
    ''' Custom tags (name tokens) for the asset, used for filtering and general asset management

    :type: typing.Union[typing.Dict[str, 'AssetTag'], typing.List['AssetTag'], 'bpy_prop_collection', 'AssetTags']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AssetTag(bpy_struct):
    ''' User defined tag (name token)
    '''

    name: str = None
    ''' The identifier that makes up this tag

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AssetTags(bpy_struct):
    ''' Collection of custom asset tags
    '''

    def new(self, name: str, skip_if_exists: bool = False) -> 'AssetTag':
        ''' Add a new tag to this asset

        :param name: Name
        :type name: str
        :param skip_if_exists: Skip if Exists, Do not add a new tag if one of the same type already exists
        :type skip_if_exists: bool
        :rtype: 'AssetTag'
        :return: New tag
        '''
        pass

    def remove(self, tag: 'AssetTag'):
        ''' Remove an existing tag from this asset

        :param tag: Removed tag
        :type tag: 'AssetTag'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Attribute(bpy_struct):
    ''' Geometry attribute
    '''

    data_type: typing.Union[str, int] = None
    ''' Type of data stored in attribute * FLOAT Float, Floating-point value. * INT Integer, 32-bit integer. * FLOAT_VECTOR Vector, 3D vector with floating-point values. * FLOAT_COLOR Color, RGBA color with floating-point precisions. * BYTE_COLOR Byte Color, RGBA color with 8-bit precision. * STRING String, Text string. * BOOLEAN Boolean, True or false. * FLOAT2 2D Vector, 2D vector with floating-point values.

    :type: typing.Union[str, int]
    '''

    domain: typing.Union[str, int] = None
    ''' Domain of the Attribute * POINT Point, Attribute on point. * EDGE Edge, Attribute on mesh edge. * FACE Face, Attribute on mesh faces. * CORNER Face Corner, Attribute on mesh face corner. * CURVE Curve, Attribute on hair curve.

    :type: typing.Union[str, int]
    '''

    name: str = None
    ''' Name of the Attribute

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class AttributeGroup(bpy_struct):
    ''' Group of geometry attributes
    '''

    active: 'Attribute' = None
    ''' Active attribute

    :type: 'Attribute'
    '''

    active_index: int = None
    ''' 

    :type: int
    '''

    def new(self, name: str, type: typing.Union[str, int],
            domain: typing.Union[str, int]) -> 'Attribute':
        ''' Add an attribute

        :param name: Attribute name
        :type name: str
        :param type: Type, Attribute type * FLOAT Float, Floating-point value. * INT Integer, 32-bit integer. * FLOAT_VECTOR Vector, 3D vector with floating-point values. * FLOAT_COLOR Color, RGBA color with floating-point precisions. * BYTE_COLOR Byte Color, RGBA color with 8-bit precision. * STRING String, Text string. * BOOLEAN Boolean, True or false. * FLOAT2 2D Vector, 2D vector with floating-point values.
        :type type: typing.Union[str, int]
        :param domain: Domain, Type of element that attribute is stored on * POINT Point, Attribute on point. * EDGE Edge, Attribute on mesh edge. * FACE Face, Attribute on mesh faces. * CORNER Face Corner, Attribute on mesh face corner. * CURVE Curve, Attribute on hair curve.
        :type domain: typing.Union[str, int]
        :rtype: 'Attribute'
        :return: New geometry attribute
        '''
        pass

    def remove(self, attribute: 'Attribute'):
        ''' Remove an attribute

        :param attribute: Geometry Attribute
        :type attribute: 'Attribute'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BakeSettings(bpy_struct):
    ''' Bake data for a Scene data-block
    '''

    cage_extrusion: float = None
    ''' Inflate the active object by the specified distance for baking. This helps matching to points nearer to the outside of the selected object meshes

    :type: float
    '''

    cage_object: 'Object' = None
    ''' Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: 'Object'
    '''

    filepath: str = None
    ''' Image filepath to use when saving externally

    :type: str
    '''

    height: int = None
    ''' Vertical dimension of the baking map

    :type: int
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    max_ray_distance: float = None
    ''' The maximum ray distance for matching points between the active and selected objects. If zero, there is no limit

    :type: float
    '''

    normal_b: typing.Union[str, int] = None
    ''' Axis to bake in blue channel

    :type: typing.Union[str, int]
    '''

    normal_g: typing.Union[str, int] = None
    ''' Axis to bake in green channel

    :type: typing.Union[str, int]
    '''

    normal_r: typing.Union[str, int] = None
    ''' Axis to bake in red channel

    :type: typing.Union[str, int]
    '''

    normal_space: typing.Union[str, int] = None
    ''' Choose normal space for baking * OBJECT Object, Bake the normals in object space. * TANGENT Tangent, Bake the normals in tangent space.

    :type: typing.Union[str, int]
    '''

    pass_filter: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Passes to include in the active baking pass

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    save_mode: typing.Union[str, int] = None
    ''' Where to save baked image textures * INTERNAL Internal, Save the baking map in an internal image data-block. * EXTERNAL External, Save the baking map in an external file.

    :type: typing.Union[str, int]
    '''

    target: typing.Union[str, int] = None
    ''' Where to output the baked map * IMAGE_TEXTURES Image Textures, Bake to image data-blocks associated with active image texture nodes in materials. * VERTEX_COLORS Vertex Colors, Bake to active vertex color layer on meshes.

    :type: typing.Union[str, int]
    '''

    use_automatic_name: bool = None
    ''' Automatically name the output file with the pass type (external only)

    :type: bool
    '''

    use_cage: bool = None
    ''' Cast rays to active object from a cage

    :type: bool
    '''

    use_clear: bool = None
    ''' Clear Images before baking (internal only)

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    ''' Add ambient occlusion contribution

    :type: bool
    '''

    use_pass_color: bool = None
    ''' Color the pass

    :type: bool
    '''

    use_pass_diffuse: bool = None
    ''' Add diffuse contribution

    :type: bool
    '''

    use_pass_direct: bool = None
    ''' Add direct lighting contribution

    :type: bool
    '''

    use_pass_emit: bool = None
    ''' Add emission contribution

    :type: bool
    '''

    use_pass_glossy: bool = None
    ''' Add glossy contribution

    :type: bool
    '''

    use_pass_indirect: bool = None
    ''' Add indirect lighting contribution

    :type: bool
    '''

    use_pass_transmission: bool = None
    ''' Add transmission contribution

    :type: bool
    '''

    use_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_split_materials: bool = None
    ''' Split external images per material (external only)

    :type: bool
    '''

    width: int = None
    ''' Horizontal dimension of the baking map

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BezierSplinePoint(bpy_struct):
    ''' Bezier curve point with two handles
    '''

    co: typing.List[float] = None
    ''' Coordinates of the control point

    :type: typing.List[float]
    '''

    handle_left: typing.List[float] = None
    ''' Coordinates of the first handle

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    ''' Coordinates of the second handle

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Handle 1 selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Handle 2 selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendData(bpy_struct):
    ''' Main data structure representing a .blend file and all its data-blocks
    '''

    actions: typing.Union[typing.Dict[str, 'Action'], typing.List['Action'],
                          'bpy_prop_collection', 'BlendDataActions'] = None
    ''' Action data-blocks

    :type: typing.Union[typing.Dict[str, 'Action'], typing.List['Action'], 'bpy_prop_collection', 'BlendDataActions']
    '''

    armatures: typing.Union[typing.Dict[str, 'Armature'], typing.
                            List['Armature'], 'bpy_prop_collection',
                            'BlendDataArmatures'] = None
    ''' Armature data-blocks

    :type: typing.Union[typing.Dict[str, 'Armature'], typing.List['Armature'], 'bpy_prop_collection', 'BlendDataArmatures']
    '''

    brushes: typing.Union[typing.Dict[str, 'Brush'], typing.List['Brush'],
                          'bpy_prop_collection', 'BlendDataBrushes'] = None
    ''' Brush data-blocks

    :type: typing.Union[typing.Dict[str, 'Brush'], typing.List['Brush'], 'bpy_prop_collection', 'BlendDataBrushes']
    '''

    cache_files: typing.Union[typing.Dict[str, 'CacheFile'], typing.
                              List['CacheFile'], 'bpy_prop_collection',
                              'BlendDataCacheFiles'] = None
    ''' Cache Files data-blocks

    :type: typing.Union[typing.Dict[str, 'CacheFile'], typing.List['CacheFile'], 'bpy_prop_collection', 'BlendDataCacheFiles']
    '''

    cameras: typing.Union[typing.Dict[str, 'Camera'], typing.List['Camera'],
                          'bpy_prop_collection', 'BlendDataCameras'] = None
    ''' Camera data-blocks

    :type: typing.Union[typing.Dict[str, 'Camera'], typing.List['Camera'], 'bpy_prop_collection', 'BlendDataCameras']
    '''

    collections: typing.Union[typing.Dict[str, 'Collection'], typing.
                              List['Collection'], 'bpy_prop_collection',
                              'BlendDataCollections'] = None
    ''' Collection data-blocks

    :type: typing.Union[typing.Dict[str, 'Collection'], typing.List['Collection'], 'bpy_prop_collection', 'BlendDataCollections']
    '''

    curves: typing.Union[typing.Dict[str, 'Curve'], typing.List['Curve'],
                         'bpy_prop_collection', 'BlendDataCurves'] = None
    ''' Curve data-blocks

    :type: typing.Union[typing.Dict[str, 'Curve'], typing.List['Curve'], 'bpy_prop_collection', 'BlendDataCurves']
    '''

    filepath: str = None
    ''' Path to the .blend file

    :type: str
    '''

    fonts: typing.Union[typing.Dict[str, 'VectorFont'], typing.
                        List['VectorFont'], 'bpy_prop_collection',
                        'BlendDataFonts'] = None
    ''' Vector font data-blocks

    :type: typing.Union[typing.Dict[str, 'VectorFont'], typing.List['VectorFont'], 'bpy_prop_collection', 'BlendDataFonts']
    '''

    grease_pencils: typing.Union[typing.Dict[str, 'GreasePencil'], typing.
                                 List['GreasePencil'], 'bpy_prop_collection',
                                 'BlendDataGreasePencils'] = None
    ''' Grease Pencil data-blocks

    :type: typing.Union[typing.Dict[str, 'GreasePencil'], typing.List['GreasePencil'], 'bpy_prop_collection', 'BlendDataGreasePencils']
    '''

    images: typing.Union[typing.Dict[str, 'Image'], typing.List['Image'],
                         'bpy_prop_collection', 'BlendDataImages'] = None
    ''' Image data-blocks

    :type: typing.Union[typing.Dict[str, 'Image'], typing.List['Image'], 'bpy_prop_collection', 'BlendDataImages']
    '''

    is_dirty: bool = None
    ''' Have recent edits been saved to disk

    :type: bool
    '''

    is_saved: bool = None
    ''' Has the current session been saved to disk as a .blend file

    :type: bool
    '''

    lattices: typing.Union[typing.Dict[str, 'Lattice'], typing.List['Lattice'],
                           'bpy_prop_collection', 'BlendDataLattices'] = None
    ''' Lattice data-blocks

    :type: typing.Union[typing.Dict[str, 'Lattice'], typing.List['Lattice'], 'bpy_prop_collection', 'BlendDataLattices']
    '''

    libraries: typing.Union[typing.Dict[str, 'Library'], typing.
                            List['Library'], 'bpy_prop_collection',
                            'BlendDataLibraries'] = None
    ''' Library data-blocks

    :type: typing.Union[typing.Dict[str, 'Library'], typing.List['Library'], 'bpy_prop_collection', 'BlendDataLibraries']
    '''

    lightprobes: typing.Union[typing.Dict[str, 'LightProbe'], typing.
                              List['LightProbe'], 'bpy_prop_collection',
                              'BlendDataProbes'] = None
    ''' Light Probe data-blocks

    :type: typing.Union[typing.Dict[str, 'LightProbe'], typing.List['LightProbe'], 'bpy_prop_collection', 'BlendDataProbes']
    '''

    lights: typing.Union[typing.Dict[str, 'Light'], typing.List['Light'],
                         'bpy_prop_collection', 'BlendDataLights'] = None
    ''' Light data-blocks

    :type: typing.Union[typing.Dict[str, 'Light'], typing.List['Light'], 'bpy_prop_collection', 'BlendDataLights']
    '''

    linestyles: typing.Union[typing.Dict[str, 'FreestyleLineStyle'], typing.
                             List['FreestyleLineStyle'], 'bpy_prop_collection',
                             'BlendDataLineStyles'] = None
    ''' Line Style data-blocks

    :type: typing.Union[typing.Dict[str, 'FreestyleLineStyle'], typing.List['FreestyleLineStyle'], 'bpy_prop_collection', 'BlendDataLineStyles']
    '''

    masks: typing.Union[typing.Dict[str, 'Mask'], typing.List['Mask'],
                        'bpy_prop_collection', 'BlendDataMasks'] = None
    ''' Masks data-blocks

    :type: typing.Union[typing.Dict[str, 'Mask'], typing.List['Mask'], 'bpy_prop_collection', 'BlendDataMasks']
    '''

    materials: typing.Union[typing.Dict[str, 'Material'], typing.
                            List['Material'], 'bpy_prop_collection',
                            'BlendDataMaterials'] = None
    ''' Material data-blocks

    :type: typing.Union[typing.Dict[str, 'Material'], typing.List['Material'], 'bpy_prop_collection', 'BlendDataMaterials']
    '''

    meshes: typing.Union[typing.Dict[str, 'Mesh'], typing.List['Mesh'],
                         'bpy_prop_collection', 'BlendDataMeshes'] = None
    ''' Mesh data-blocks

    :type: typing.Union[typing.Dict[str, 'Mesh'], typing.List['Mesh'], 'bpy_prop_collection', 'BlendDataMeshes']
    '''

    metaballs: typing.Union[typing.Dict[str, 'MetaBall'], typing.
                            List['MetaBall'], 'bpy_prop_collection',
                            'BlendDataMetaBalls'] = None
    ''' Metaball data-blocks

    :type: typing.Union[typing.Dict[str, 'MetaBall'], typing.List['MetaBall'], 'bpy_prop_collection', 'BlendDataMetaBalls']
    '''

    movieclips: typing.Union[typing.Dict[str, 'MovieClip'], typing.
                             List['MovieClip'], 'bpy_prop_collection',
                             'BlendDataMovieClips'] = None
    ''' Movie Clip data-blocks

    :type: typing.Union[typing.Dict[str, 'MovieClip'], typing.List['MovieClip'], 'bpy_prop_collection', 'BlendDataMovieClips']
    '''

    node_groups: typing.Union[typing.Dict[str, 'NodeTree'], typing.
                              List['NodeTree'], 'bpy_prop_collection',
                              'BlendDataNodeTrees'] = None
    ''' Node group data-blocks

    :type: typing.Union[typing.Dict[str, 'NodeTree'], typing.List['NodeTree'], 'bpy_prop_collection', 'BlendDataNodeTrees']
    '''

    objects: typing.Union[typing.Dict[str, 'Object'], typing.List['Object'],
                          'bpy_prop_collection', 'BlendDataObjects'] = None
    ''' Object data-blocks

    :type: typing.Union[typing.Dict[str, 'Object'], typing.List['Object'], 'bpy_prop_collection', 'BlendDataObjects']
    '''

    paint_curves: typing.Union[typing.Dict[str, 'PaintCurve'], typing.
                               List['PaintCurve'], 'bpy_prop_collection',
                               'BlendDataPaintCurves'] = None
    ''' Paint Curves data-blocks

    :type: typing.Union[typing.Dict[str, 'PaintCurve'], typing.List['PaintCurve'], 'bpy_prop_collection', 'BlendDataPaintCurves']
    '''

    palettes: typing.Union[typing.Dict[str, 'Palette'], typing.List['Palette'],
                           'bpy_prop_collection', 'BlendDataPalettes'] = None
    ''' Palette data-blocks

    :type: typing.Union[typing.Dict[str, 'Palette'], typing.List['Palette'], 'bpy_prop_collection', 'BlendDataPalettes']
    '''

    particles: typing.Union[typing.Dict[str, 'ParticleSettings'], typing.
                            List['ParticleSettings'], 'bpy_prop_collection',
                            'BlendDataParticles'] = None
    ''' Particle data-blocks

    :type: typing.Union[typing.Dict[str, 'ParticleSettings'], typing.List['ParticleSettings'], 'bpy_prop_collection', 'BlendDataParticles']
    '''

    scenes: typing.Union[typing.Dict[str, 'Scene'], typing.List['Scene'],
                         'bpy_prop_collection', 'BlendDataScenes'] = None
    ''' Scene data-blocks

    :type: typing.Union[typing.Dict[str, 'Scene'], typing.List['Scene'], 'bpy_prop_collection', 'BlendDataScenes']
    '''

    screens: typing.Union[typing.Dict[str, 'Screen'], typing.List['Screen'],
                          'bpy_prop_collection', 'BlendDataScreens'] = None
    ''' Screen data-blocks

    :type: typing.Union[typing.Dict[str, 'Screen'], typing.List['Screen'], 'bpy_prop_collection', 'BlendDataScreens']
    '''

    shape_keys: typing.Union[typing.Dict[str, 'Key'], typing.
                             List['Key'], 'bpy_prop_collection'] = None
    ''' Shape Key data-blocks

    :type: typing.Union[typing.Dict[str, 'Key'], typing.List['Key'], 'bpy_prop_collection']
    '''

    sounds: typing.Union[typing.Dict[str, 'Sound'], typing.List['Sound'],
                         'bpy_prop_collection', 'BlendDataSounds'] = None
    ''' Sound data-blocks

    :type: typing.Union[typing.Dict[str, 'Sound'], typing.List['Sound'], 'bpy_prop_collection', 'BlendDataSounds']
    '''

    speakers: typing.Union[typing.Dict[str, 'Speaker'], typing.List['Speaker'],
                           'bpy_prop_collection', 'BlendDataSpeakers'] = None
    ''' Speaker data-blocks

    :type: typing.Union[typing.Dict[str, 'Speaker'], typing.List['Speaker'], 'bpy_prop_collection', 'BlendDataSpeakers']
    '''

    texts: typing.Union[typing.Dict[str, 'Text'], typing.List['Text'],
                        'bpy_prop_collection', 'BlendDataTexts'] = None
    ''' Text data-blocks

    :type: typing.Union[typing.Dict[str, 'Text'], typing.List['Text'], 'bpy_prop_collection', 'BlendDataTexts']
    '''

    textures: typing.Union[typing.Dict[str, 'Texture'], typing.List['Texture'],
                           'bpy_prop_collection', 'BlendDataTextures'] = None
    ''' Texture data-blocks

    :type: typing.Union[typing.Dict[str, 'Texture'], typing.List['Texture'], 'bpy_prop_collection', 'BlendDataTextures']
    '''

    use_autopack: bool = None
    ''' Automatically pack all external data into .blend file

    :type: bool
    '''

    version: typing.List[int] = None
    ''' File format version the .blend file was saved with

    :type: typing.List[int]
    '''

    volumes: typing.Union[typing.Dict[str, 'Volume'], typing.List['Volume'],
                          'bpy_prop_collection', 'BlendDataVolumes'] = None
    ''' Volume data-blocks

    :type: typing.Union[typing.Dict[str, 'Volume'], typing.List['Volume'], 'bpy_prop_collection', 'BlendDataVolumes']
    '''

    window_managers: typing.Union[typing.Dict[str, 'WindowManager'], typing.
                                  List['WindowManager'], 'bpy_prop_collection',
                                  'BlendDataWindowManagers'] = None
    ''' Window manager data-blocks

    :type: typing.Union[typing.Dict[str, 'WindowManager'], typing.List['WindowManager'], 'bpy_prop_collection', 'BlendDataWindowManagers']
    '''

    workspaces: typing.Union[typing.Dict[str, 'WorkSpace'], typing.
                             List['WorkSpace'], 'bpy_prop_collection',
                             'BlendDataWorkSpaces'] = None
    ''' Workspace data-blocks

    :type: typing.Union[typing.Dict[str, 'WorkSpace'], typing.List['WorkSpace'], 'bpy_prop_collection', 'BlendDataWorkSpaces']
    '''

    worlds: typing.Union[typing.Dict[str, 'World'], typing.List['World'],
                         'bpy_prop_collection', 'BlendDataWorlds'] = None
    ''' World data-blocks

    :type: typing.Union[typing.Dict[str, 'World'], typing.List['World'], 'bpy_prop_collection', 'BlendDataWorlds']
    '''

    def batch_remove(self, ids=()):
        ''' Remove (delete) several IDs at once. WARNING: Considered experimental feature currently. Note that this function is quicker than individual calls to :func: remove() (from bpy.types.BlendData ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes...).

        :param subset: 
        :type subset: list
        :param ids: 
        :type ids: 
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass

    def orphans_purge(self):
        ''' Remove (delete) all IDs with no user.

        :param do_local_ids: Include unused local IDs in the deletion, defaults to True
        :type do_local_ids: bool
        :param do_linked_ids: Include unused linked IDs in the deletion, defaults to True
        :type do_linked_ids: bool
        :param do_recursive: Recursively check for unused IDs, ensuring no orphaned one remain after a single run of that function, defaults to False
        :type do_recursive: bool
        '''
        pass

    def temp_data(self, filepath: str = None) -> 'BlendData':
        ''' A context manager that temporarily creates blender file data.

        :param filepath: The file path for the newly temporary data. When None, the path of the currently open file is used.
        :type filepath: str
        :rtype: 'BlendData'
        :return: Blend file data which is freed once the context exists.
        '''
        pass

    def user_map(self, subset: list, key_types: set, value_types: set) -> dict:
        ''' Returns a mapping of all ID data-blocks in current bpy.data to a set of all datablocks using them. For list of valid set members for key_types & value_types, see: bpy.types.KeyingSetPath.id_type .

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: list
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: set
        :param value_types: Filter the values in the set by ID types.
        :type value_types: set
        :rtype: dict
        :return: bpy.types.ID instances, with sets of ID's as their values.
        '''
        pass


class BlendDataActions(bpy_struct):
    ''' Collection of actions
    '''

    def new(self, name: str) -> 'Action':
        ''' Add a new action to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Action'
        :return: New action data-block
        '''
        pass

    def remove(self,
               action: 'Action',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove an action from the current blendfile

        :param action: Action to remove
        :type action: 'Action'
        :param do_unlink: Unlink all usages of this action before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this action
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this action
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataArmatures(bpy_struct):
    ''' Collection of armatures
    '''

    def new(self, name: str) -> 'Armature':
        ''' Add a new armature to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Armature'
        :return: New armature data-block
        '''
        pass

    def remove(self,
               armature: 'Armature',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove an armature from the current blendfile

        :param armature: Armature to remove
        :type armature: 'Armature'
        :param do_unlink: Unlink all usages of this armature before deleting it (WARNING: will also delete objects instancing that armature data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this armature data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this armature data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataBrushes(bpy_struct):
    ''' Collection of brushes
    '''

    def new(self, name: str,
            mode: typing.Union[str, int] = 'TEXTURE_PAINT') -> 'Brush':
        ''' Add a new brush to the main database

        :param name: New name for the data-block
        :type name: str
        :param mode: Paint Mode for the new brush * OBJECT Object Mode. * EDIT Edit Mode. * POSE Pose Mode. * SCULPT Sculpt Mode. * VERTEX_PAINT Vertex Paint. * WEIGHT_PAINT Weight Paint. * TEXTURE_PAINT Texture Paint. * PARTICLE_EDIT Particle Edit. * EDIT_GPENCIL Edit Mode, Edit Grease Pencil Strokes. * SCULPT_GPENCIL Sculpt Mode, Sculpt Grease Pencil Strokes. * PAINT_GPENCIL Draw, Paint Grease Pencil Strokes. * WEIGHT_GPENCIL Weight Paint, Grease Pencil Weight Paint Strokes. * VERTEX_GPENCIL Vertex Paint, Grease Pencil Vertex Paint Strokes.
        :type mode: typing.Union[str, int]
        :rtype: 'Brush'
        :return: New brush data-block
        '''
        pass

    def remove(self,
               brush: 'Brush',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a brush from the current blendfile

        :param brush: Brush to remove
        :type brush: 'Brush'
        :param do_unlink: Unlink all usages of this brush before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this brush
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this brush
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def create_gpencil_data(self, brush: 'Brush'):
        ''' Add grease pencil brush settings

        :param brush: Brush
        :type brush: 'Brush'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataCacheFiles(bpy_struct):
    ''' Collection of cache files
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataCameras(bpy_struct):
    ''' Collection of cameras
    '''

    def new(self, name: str) -> 'Camera':
        ''' Add a new camera to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Camera'
        :return: New camera data-block
        '''
        pass

    def remove(self,
               camera: 'Camera',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a camera from the current blendfile

        :param camera: Camera to remove
        :type camera: 'Camera'
        :param do_unlink: Unlink all usages of this camera before deleting it (WARNING: will also delete objects instancing that camera data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this camera
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this camera
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataCollections(bpy_struct):
    ''' Collection of collections
    '''

    def new(self, name: str) -> 'Collection':
        ''' Add a new collection to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Collection'
        :return: New collection data-block
        '''
        pass

    def remove(self,
               collection: 'Collection',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a collection from the current blendfile

        :param collection: Collection to remove
        :type collection: 'Collection'
        :param do_unlink: Unlink all usages of this collection before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this collection
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this collection
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataCurves(bpy_struct):
    ''' Collection of curves
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Curve':
        ''' Add a new curve to the main database

        :param name: New name for the data-block
        :type name: str
        :param type: Type, The type of curve to add
        :type type: typing.Union[str, int]
        :rtype: 'Curve'
        :return: New curve data-block
        '''
        pass

    def remove(self,
               curve: 'Curve',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a curve from the current blendfile

        :param curve: Curve to remove
        :type curve: 'Curve'
        :param do_unlink: Unlink all usages of this curve before deleting it (WARNING: will also delete objects instancing that curve data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this curve data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this curve data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataFonts(bpy_struct):
    ''' Collection of fonts
    '''

    def load(self, filepath: str,
             check_existing: bool = False) -> 'VectorFont':
        ''' Load a new font into the main database

        :param filepath: path of the font to load
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: bool
        :rtype: 'VectorFont'
        :return: New font data-block
        '''
        pass

    def remove(self,
               vfont: 'VectorFont',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a font from the current blendfile

        :param vfont: Font to remove
        :type vfont: 'VectorFont'
        :param do_unlink: Unlink all usages of this font before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this font
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this font
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataGreasePencils(bpy_struct):
    ''' Collection of grease pencils
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'GreasePencil':
        ''' Add a new grease pencil datablock to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'GreasePencil'
        :return: New grease pencil data-block
        '''
        pass

    def remove(self,
               grease_pencil: 'GreasePencil',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a grease pencil instance from the current blendfile

        :param grease_pencil: Grease Pencil to remove
        :type grease_pencil: 'GreasePencil'
        :param do_unlink: Unlink all usages of this grease pencil before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this grease pencil
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this grease pencil
        :type do_ui_user: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataImages(bpy_struct):
    ''' Collection of images
    '''

    def new(self,
            name: str,
            width: int,
            height: int,
            alpha: bool = False,
            float_buffer: bool = False,
            stereo3d: bool = False,
            is_data: bool = False,
            tiled: bool = False) -> 'Image':
        ''' Add a new image to the main database

        :param name: New name for the data-block
        :type name: str
        :param width: Width of the image
        :type width: int
        :param height: Height of the image
        :type height: int
        :param alpha: Alpha, Use alpha channel
        :type alpha: bool
        :param float_buffer: Float Buffer, Create an image with floating-point color
        :type float_buffer: bool
        :param stereo3d: Stereo 3D, Create left and right views
        :type stereo3d: bool
        :param is_data: Is Data, Create image with non-color data color space
        :type is_data: bool
        :param tiled: Tiled, Create a tiled image
        :type tiled: bool
        :rtype: 'Image'
        :return: New image data-block
        '''
        pass

    def load(self, filepath: str, check_existing: bool = False) -> 'Image':
        ''' Load a new image into the main database

        :param filepath: Path of the file to load
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: bool
        :rtype: 'Image'
        :return: New image data-block
        '''
        pass

    def remove(self,
               image: 'Image',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove an image from the current blendfile

        :param image: Image to remove
        :type image: 'Image'
        :param do_unlink: Unlink all usages of this image before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this image
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this image
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataLattices(bpy_struct):
    ''' Collection of lattices
    '''

    def new(self, name: str) -> 'Lattice':
        ''' Add a new lattice to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Lattice'
        :return: New lattice data-block
        '''
        pass

    def remove(self,
               lattice: 'Lattice',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a lattice from the current blendfile

        :param lattice: Lattice to remove
        :type lattice: 'Lattice'
        :param do_unlink: Unlink all usages of this lattice before deleting it (WARNING: will also delete objects instancing that lattice data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this lattice data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this lattice data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataLibraries(bpy_struct):
    ''' Collection of libraries
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def remove(self,
               library: 'Library',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a library from the current blendfile

        :param library: Library to remove
        :type library: 'Library'
        :param do_unlink: Unlink all usages of this library before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this library
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this library
        :type do_ui_user: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataLights(bpy_struct):
    ''' Collection of lights
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Light':
        ''' Add a new light to the main database

        :param name: New name for the data-block
        :type name: str
        :param type: Type, The type of light to add * POINT Point, Omnidirectional point light source. * SUN Sun, Constant direction parallel ray light source. * SPOT Spot, Directional cone light source. * AREA Area, Directional area light source.
        :type type: typing.Union[str, int]
        :rtype: 'Light'
        :return: New light data-block
        '''
        pass

    def remove(self,
               light: 'Light',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a light from the current blendfile

        :param light: Light to remove
        :type light: 'Light'
        :param do_unlink: Unlink all usages of this light before deleting it (WARNING: will also delete objects instancing that light data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this light data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this light data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataLineStyles(bpy_struct):
    ''' Collection of line styles
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'FreestyleLineStyle':
        ''' Add a new line style instance to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'FreestyleLineStyle'
        :return: New line style data-block
        '''
        pass

    def remove(self,
               linestyle: 'FreestyleLineStyle',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a line style instance from the current blendfile

        :param linestyle: Line style to remove
        :type linestyle: 'FreestyleLineStyle'
        :param do_unlink: Unlink all usages of this line style before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this line style
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this line style
        :type do_ui_user: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataMasks(bpy_struct):
    ''' Collection of masks
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'Mask':
        ''' Add a new mask with a given name to the main database

        :param name: Mask, Name of new mask data-block
        :type name: str
        :rtype: 'Mask'
        :return: New mask data-block
        '''
        pass

    def remove(self,
               mask: 'Mask',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a mask from the current blendfile

        :param mask: Mask to remove
        :type mask: 'Mask'
        :param do_unlink: Unlink all usages of this mask before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this mask
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this mask
        :type do_ui_user: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataMaterials(bpy_struct):
    ''' Collection of materials
    '''

    def new(self, name: str) -> 'Material':
        ''' Add a new material to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Material'
        :return: New material data-block
        '''
        pass

    def create_gpencil_data(self, material: 'Material'):
        ''' Add grease pencil material settings

        :param material: Material
        :type material: 'Material'
        '''
        pass

    def remove_gpencil_data(self, material: 'Material'):
        ''' Remove grease pencil material settings

        :param material: Material
        :type material: 'Material'
        '''
        pass

    def remove(self,
               material: 'Material',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a material from the current blendfile

        :param material: Material to remove
        :type material: 'Material'
        :param do_unlink: Unlink all usages of this material before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this material
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this material
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataMeshes(bpy_struct):
    ''' Collection of meshes
    '''

    def new(self, name: str) -> 'Mesh':
        ''' Add a new mesh to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Mesh'
        :return: New mesh data-block
        '''
        pass

    def new_from_object(self,
                        object: 'Object',
                        preserve_all_data_layers: bool = False,
                        depsgraph: 'Depsgraph' = None) -> 'Mesh':
        ''' Add a new mesh created from given object (undeformed geometry if object is original, and final evaluated geometry, with all modifiers etc., if object is evaluated)

        :param object: Object to create mesh from
        :type object: 'Object'
        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance
        :type preserve_all_data_layers: bool
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true
        :type depsgraph: 'Depsgraph'
        :rtype: 'Mesh'
        :return: Mesh created from object, remove it if it is only used for export
        '''
        pass

    def remove(self,
               mesh: 'Mesh',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a mesh from the current blendfile

        :param mesh: Mesh to remove
        :type mesh: 'Mesh'
        :param do_unlink: Unlink all usages of this mesh before deleting it (WARNING: will also delete objects instancing that mesh data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this mesh data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this mesh data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataMetaBalls(bpy_struct):
    ''' Collection of metaballs
    '''

    def new(self, name: str) -> 'MetaBall':
        ''' Add a new metaball to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'MetaBall'
        :return: New metaball data-block
        '''
        pass

    def remove(self,
               metaball: 'MetaBall',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a metaball from the current blendfile

        :param metaball: Metaball to remove
        :type metaball: 'MetaBall'
        :param do_unlink: Unlink all usages of this metaball before deleting it (WARNING: will also delete objects instancing that metaball data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this metaball data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this metaball data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataMovieClips(bpy_struct):
    ''' Collection of movie clips
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    def remove(self,
               clip: 'MovieClip',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a movie clip from the current blendfile.

        :param clip: Movie clip to remove
        :type clip: 'MovieClip'
        :param do_unlink: Unlink all usages of this movie clip before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this movie clip
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this movie clip
        :type do_ui_user: bool
        '''
        pass

    def load(self, filepath: str, check_existing: bool = False) -> 'MovieClip':
        ''' Add a new movie clip to the main database from a file (while check_existing is disabled for consistency with other load functions, behavior with multiple movie-clips using the same file may incorrectly generate proxies)

        :param filepath: path for the data-block
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: bool
        :rtype: 'MovieClip'
        :return: New movie clip data-block
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataNodeTrees(bpy_struct):
    ''' Collection of node trees
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'NodeTree':
        ''' Add a new node tree to the main database

        :param name: New name for the data-block
        :type name: str
        :param type: Type, The type of node_group to add
        :type type: typing.Union[str, int]
        :rtype: 'NodeTree'
        :return: New node tree data-block
        '''
        pass

    def remove(self,
               tree: 'NodeTree',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a node tree from the current blendfile

        :param tree: Node tree to remove
        :type tree: 'NodeTree'
        :param do_unlink: Unlink all usages of this node tree before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this node tree
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this node tree
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataObjects(bpy_struct):
    ''' Collection of objects
    '''

    def new(self, name: str, object_data: 'ID') -> 'Object':
        ''' Add a new object to the main database

        :param name: New name for the data-block
        :type name: str
        :param object_data: Object data or None for an empty object
        :type object_data: 'ID'
        :rtype: 'Object'
        :return: New object data-block
        '''
        pass

    def remove(self,
               object: 'Object',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove an object from the current blendfile

        :param object: Object to remove
        :type object: 'Object'
        :param do_unlink: Unlink all usages of this object before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this object
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this object
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataPaintCurves(bpy_struct):
    ''' Collection of paint curves
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataPalettes(bpy_struct):
    ''' Collection of palettes
    '''

    def new(self, name: str) -> 'Palette':
        ''' Add a new palette to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Palette'
        :return: New palette data-block
        '''
        pass

    def remove(self,
               palette: 'Palette',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a palette from the current blendfile

        :param palette: Palette to remove
        :type palette: 'Palette'
        :param do_unlink: Unlink all usages of this palette before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this palette
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this palette
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataParticles(bpy_struct):
    ''' Collection of particle settings
    '''

    def new(self, name: str) -> 'ParticleSettings':
        ''' Add a new particle settings instance to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'ParticleSettings'
        :return: New particle settings data-block
        '''
        pass

    def remove(self,
               particle: 'ParticleSettings',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a particle settings instance from the current blendfile

        :param particle: Particle Settings to remove
        :type particle: 'ParticleSettings'
        :param do_unlink: Unlink all usages of those particle settings before deleting them
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this particle settings
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this particle settings
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataProbes(bpy_struct):
    ''' Collection of light probes
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'LightProbe':
        ''' Add a new light probe to the main database

        :param name: New name for the data-block
        :type name: str
        :param type: Type, The type of light probe to add
        :type type: typing.Union[str, int]
        :rtype: 'LightProbe'
        :return: New light probe data-block
        '''
        pass

    def remove(self,
               lightprobe: 'LightProbe',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a light probe from the current blendfile

        :param lightprobe: Light probe to remove
        :type lightprobe: 'LightProbe'
        :param do_unlink: Unlink all usages of this light probe before deleting it (WARNING: will also delete objects instancing that light probe data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this light probe
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this light probe
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataScenes(bpy_struct):
    ''' Collection of scenes
    '''

    def new(self, name: str) -> 'Scene':
        ''' Add a new scene to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Scene'
        :return: New scene data-block
        '''
        pass

    def remove(self, scene: 'Scene', do_unlink: bool = True):
        ''' Remove a scene from the current blendfile

        :param scene: Scene to remove
        :type scene: 'Scene'
        :param do_unlink: Unlink all usages of this scene before deleting it
        :type do_unlink: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataScreens(bpy_struct):
    ''' Collection of screens
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataSounds(bpy_struct):
    ''' Collection of sounds
    '''

    def load(self, filepath: str, check_existing: bool = False) -> 'Sound':
        ''' Add a new sound to the main database from a file

        :param filepath: path for the data-block
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: bool
        :rtype: 'Sound'
        :return: New text data-block
        '''
        pass

    def remove(self,
               sound: 'Sound',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a sound from the current blendfile

        :param sound: Sound to remove
        :type sound: 'Sound'
        :param do_unlink: Unlink all usages of this sound before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this sound
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this sound
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataSpeakers(bpy_struct):
    ''' Collection of speakers
    '''

    def new(self, name: str) -> 'Speaker':
        ''' Add a new speaker to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Speaker'
        :return: New speaker data-block
        '''
        pass

    def remove(self,
               speaker: 'Speaker',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a speaker from the current blendfile

        :param speaker: Speaker to remove
        :type speaker: 'Speaker'
        :param do_unlink: Unlink all usages of this speaker before deleting it (WARNING: will also delete objects instancing that speaker data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this speaker data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this speaker data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataTexts(bpy_struct):
    ''' Collection of texts
    '''

    def new(self, name: str) -> 'Text':
        ''' Add a new text to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Text'
        :return: New text data-block
        '''
        pass

    def remove(self,
               text: 'Text',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a text from the current blendfile

        :param text: Text to remove
        :type text: 'Text'
        :param do_unlink: Unlink all usages of this text before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this text
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this text
        :type do_ui_user: bool
        '''
        pass

    def load(self, filepath: str, internal: bool = False) -> 'Text':
        ''' Add a new text to the main database from a file

        :param filepath: path for the data-block
        :type filepath: str
        :param internal: Make internal, Make text file internal after loading
        :type internal: bool
        :rtype: 'Text'
        :return: New text data-block
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataTextures(bpy_struct):
    ''' Collection of textures
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Texture':
        ''' Add a new texture to the main database

        :param name: New name for the data-block
        :type name: str
        :param type: Type, The type of texture to add * NONE None. * BLEND Blend, Procedural - create a ramp texture. * CLOUDS Clouds, Procedural - create a cloud-like fractal noise texture. * DISTORTED_NOISE Distorted Noise, Procedural - noise texture distorted by two noise algorithms. * IMAGE Image or Movie, Allow for images or movies to be used as textures. * MAGIC Magic, Procedural - color texture based on trigonometric functions. * MARBLE Marble, Procedural - marble-like noise texture with wave generated bands. * MUSGRAVE Musgrave, Procedural - highly flexible fractal noise texture. * NOISE Noise, Procedural - random noise, gives a different result every time, for every frame, for every pixel. * STUCCI Stucci, Procedural - create a fractal noise texture. * VORONOI Voronoi, Procedural - create cell-like patterns based on Worley noise. * WOOD Wood, Procedural - wave generated bands or rings, with optional noise.
        :type type: typing.Union[str, int]
        :rtype: 'Texture'
        :return: New texture data-block
        '''
        pass

    def remove(self,
               texture: 'Texture',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a texture from the current blendfile

        :param texture: Texture to remove
        :type texture: 'Texture'
        :param do_unlink: Unlink all usages of this texture before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this texture
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this texture
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataVolumes(bpy_struct):
    ''' Collection of volumes
    '''

    def new(self, name: str) -> 'Volume':
        ''' Add a new volume to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'Volume'
        :return: New volume data-block
        '''
        pass

    def remove(self,
               volume: 'Volume',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a volume from the current blendfile

        :param volume: Volume to remove
        :type volume: 'Volume'
        :param do_unlink: Unlink all usages of this volume before deleting it (WARNING: will also delete objects instancing that volume data)
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this volume data
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this volume data
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataWindowManagers(bpy_struct):
    ''' Collection of window managers
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataWorkSpaces(bpy_struct):
    ''' Collection of workspaces
    '''

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlendDataWorlds(bpy_struct):
    ''' Collection of worlds
    '''

    def new(self, name: str) -> 'World':
        ''' Add a new world to the main database

        :param name: New name for the data-block
        :type name: str
        :rtype: 'World'
        :return: New world data-block
        '''
        pass

    def remove(self,
               world: 'World',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        ''' Remove a world from the current blendfile

        :param world: World to remove
        :type world: 'World'
        :param do_unlink: Unlink all usages of this world before deleting it
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this world
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this world
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        ''' tag

        :param value: Value
        :type value: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BlenderRNA(bpy_struct):
    ''' Blender RNA structure definitions
    '''

    structs: typing.Union[typing.Dict[str, 'Struct'], typing.
                          List['Struct'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'Struct'], typing.List['Struct'], 'bpy_prop_collection']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoidRule(bpy_struct):
    name: str = None
    ''' Boid rule name

    :type: str
    '''

    type: typing.Union[str, int] = None
    ''' * GOAL Goal, Go to assigned object or loudest assigned signal source. * AVOID Avoid, Get away from assigned object or loudest assigned signal source. * AVOID_COLLISION Avoid Collision, Maneuver to avoid collisions with other boids and deflector objects in near future. * SEPARATE Separate, Keep from going through other boids. * FLOCK Flock, Move to center of neighbors and match their velocity. * FOLLOW_LEADER Follow Leader, Follow a boid or assigned object. * AVERAGE_SPEED Average Speed, Maintain speed, flight level or wander. * FIGHT Fight, Go to closest enemy and attack when in range.

    :type: typing.Union[str, int]
    '''

    use_in_air: bool = None
    ''' Use rule when boid is flying

    :type: bool
    '''

    use_on_land: bool = None
    ''' Use rule when boid is on land

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoidSettings(bpy_struct):
    ''' Settings for boid physics
    '''

    accuracy: float = None
    ''' Accuracy of attack

    :type: float
    '''

    active_boid_state: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_state_index: int = None
    ''' 

    :type: int
    '''

    aggression: float = None
    ''' Boid will fight this times stronger enemy

    :type: float
    '''

    air_acc_max: float = None
    ''' Maximum acceleration in air (relative to maximum speed)

    :type: float
    '''

    air_ave_max: float = None
    ''' Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    '''

    air_personal_space: float = None
    ''' Radius of boids personal space in air (% of particle size)

    :type: float
    '''

    air_speed_max: float = None
    ''' Maximum speed in air

    :type: float
    '''

    air_speed_min: float = None
    ''' Minimum speed in air (relative to maximum speed)

    :type: float
    '''

    bank: float = None
    ''' Amount of rotation around velocity vector on turns

    :type: float
    '''

    health: float = None
    ''' Initial boid health when born

    :type: float
    '''

    height: float = None
    ''' Boid height relative to particle size

    :type: float
    '''

    land_acc_max: float = None
    ''' Maximum acceleration on land (relative to maximum speed)

    :type: float
    '''

    land_ave_max: float = None
    ''' Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    '''

    land_jump_speed: float = None
    ''' Maximum speed for jumping

    :type: float
    '''

    land_personal_space: float = None
    ''' Radius of boids personal space on land (% of particle size)

    :type: float
    '''

    land_smooth: float = None
    ''' How smoothly the boids land

    :type: float
    '''

    land_speed_max: float = None
    ''' Maximum speed on land

    :type: float
    '''

    land_stick_force: float = None
    ''' How strong a force must be to start effecting a boid on land

    :type: float
    '''

    pitch: float = None
    ''' Amount of rotation around side vector

    :type: float
    '''

    range: float = None
    ''' Maximum distance from which a boid can attack

    :type: float
    '''

    states: typing.Union[typing.Dict[str, 'BoidState'], typing.
                         List['BoidState'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'BoidState'], typing.List['BoidState'], 'bpy_prop_collection']
    '''

    strength: float = None
    ''' Maximum caused damage on attack per second

    :type: float
    '''

    use_climb: bool = None
    ''' Allow boids to climb goal objects

    :type: bool
    '''

    use_flight: bool = None
    ''' Allow boids to move in air

    :type: bool
    '''

    use_land: bool = None
    ''' Allow boids to move on land

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoidState(bpy_struct):
    ''' Boid state for boid physics
    '''

    active_boid_rule: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_rule_index: int = None
    ''' 

    :type: int
    '''

    falloff: float = None
    ''' 

    :type: float
    '''

    name: str = None
    ''' Boid state name

    :type: str
    '''

    rule_fuzzy: float = None
    ''' 

    :type: float
    '''

    rules: typing.Union[typing.Dict[str, 'BoidRule'], typing.
                        List['BoidRule'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'BoidRule'], typing.List['BoidRule'], 'bpy_prop_collection']
    '''

    ruleset_type: typing.Union[str, int] = None
    ''' How the rules in the list are evaluated * FUZZY Fuzzy, Rules are gone through top to bottom (only the first rule which effect is above fuzziness threshold is evaluated). * RANDOM Random, A random rule is selected for each boid. * AVERAGE Average, All rules are averaged.

    :type: typing.Union[str, int]
    '''

    volume: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Bone(bpy_struct):
    ''' Bone in an Armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'Bone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'Bone'
    '''

    bbone_custom_handle_start: 'Bone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'Bone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    ''' Selects how the end handle of the B-Bone is computed * AUTO Automatic, Use connected parent and children to compute the handle. * ABSOLUTE Absolute, Use the position of the specified bone to compute the handle. * RELATIVE Relative, Use the offset of the specified bone from rest pose to compute the handle. * TANGENT Tangent, Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    ''' Selects how the start handle of the B-Bone is computed * AUTO Automatic, Use connected parent and children to compute the handle. * ABSOLUTE Absolute, Use the position of the specified bone to compute the handle. * RELATIVE Relative, Use the offset of the specified bone from rest pose to compute the handle. * TANGENT Tangent, Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scaleinx: float = None
    ''' X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleiny: float = None
    ''' Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleoutx: float = None
    ''' X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleouty: float = None
    ''' Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    children: typing.Union[typing.Dict[str, 'Bone'], typing.
                           List['Bone'], 'bpy_prop_collection'] = None
    ''' Bones which are children of this bone

    :type: typing.Union[typing.Dict[str, 'Bone'], typing.List['Bone'], 'bpy_prop_collection']
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: typing.List[float] = None
    ''' Location of head end of the bone relative to its parent

    :type: typing.List[float]
    '''

    head_local: typing.List[float] = None
    ''' Location of head end of the bone relative to armature

    :type: typing.List[float]
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    ''' Specifies how the bone inherits scaling from the parent bone * FULL Full, Inherit all effects of parent scaling. * FIX_SHEAR Fix Shear, Inherit scaling, but remove shearing of the child in the rest orientation. * ALIGNED Aligned, Rotate non-uniform parent scaling to align with the child, applying parent X scale to child X axis, and so forth. * AVERAGE Average, Inherit uniform scaling representing the overall change in the volume of the parent. * NONE None, Completely ignore parent scaling. * NONE_LEGACY None (Legacy), Ignore parent scaling without compensating for parent shear. Replicates the effect of disabling the original Inherit Scale checkbox.

    :type: typing.Union[str, int]
    '''

    layers: typing.List[bool] = None
    ''' Layers bone exists in

    :type: typing.List[bool]
    '''

    length: float = None
    ''' Length of the bone

    :type: float
    '''

    matrix: typing.List[float] = None
    ''' 3x3 bone matrix

    :type: typing.List[float]
    '''

    matrix_local: typing.List[float] = None
    ''' 4x4 bone matrix relative to armature

    :type: typing.List[float]
    '''

    name: str = None
    ''' 

    :type: str
    '''

    parent: 'Bone' = None
    ''' Parent bone (in same Armature)

    :type: 'Bone'
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: typing.List[float] = None
    ''' Location of tail end of the bone relative to its parent

    :type: typing.List[float]
    '''

    tail_local: typing.List[float] = None
    ''' Location of tail end of the bone relative to armature

    :type: typing.List[float]
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: bool = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_inherit_scale: bool = None
    ''' DEPRECATED: Bone inherits scaling from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes O(len(bones)**2) time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(self, point: typing.List[float]) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.List[float]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def convert_local_to_pose(
            self,
            matrix: typing.List[float],
            matrix_local: typing.List[float],
            parent_matrix: typing.List[float] = ((0.0, 0.0, 0.0,
                                                  0.0), (0.0, 0.0, 0.0, 0.0),
                                                 (0.0, 0.0, 0.0,
                                                  0.0), (0.0, 0.0, 0.0, 0.0)),
            parent_matrix_local: typing.List[float] = ((0.0, 0.0, 0.0, 0.0),
                                                       (0.0, 0.0, 0.0, 0.0),
                                                       (0.0, 0.0, 0.0,
                                                        0.0), (0.0, 0.0, 0.0,
                                                               0.0)),
            invert: bool = False) -> typing.List[float]:
        ''' Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent.

        :param matrix: The matrix to transform
        :type matrix: typing.List[float]
        :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local)
        :type matrix_local: typing.List[float]
        :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix)
        :type parent_matrix: typing.List[float]
        :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local)
        :type parent_matrix_local: typing.List[float]
        :param invert: Convert from Pose to Local space
        :type invert: bool
        :rtype: typing.List[float]
        :return: The transformed matrix
        '''
        pass

    @classmethod
    def MatrixFromAxisRoll(cls, axis: typing.List[float],
                           roll: float) -> typing.List[float]:
        ''' Convert the axis + roll representation to a matrix

        :param axis: The main axis of the bone (tail - head)
        :type axis: typing.List[float]
        :param roll: The roll of the bone
        :type roll: float
        :rtype: typing.List[float]
        :return: The resulting orientation matrix
        '''
        pass

    @classmethod
    def AxisRollFromMatrix(cls,
                           matrix: typing.List[float],
                           axis: typing.List[float] = (0.0, 0.0, 0.0)):
        ''' Convert a rotational matrix to the axis + roll representation. Note that the resulting value of the roll may not be as expected if the matrix has shear or negative determinant.

        :param matrix: The orientation matrix of the bone
        :type matrix: typing.List[float]
        :param axis: The optional override for the axis (finds closest approximation for the matrix)
        :type axis: typing.List[float]
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoneGroup(bpy_struct):
    ''' Groups of Pose Channels (Bones)
    '''

    color_set: typing.Union[str, int] = None
    ''' Custom color set to use

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    ''' Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: bool = None
    ''' Color set is user-defined instead of a fixed theme color set

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoneGroups(bpy_struct):
    ''' Collection of bone groups
    '''

    active: 'BoneGroup' = None
    ''' Active bone group for this pose

    :type: 'BoneGroup'
    '''

    active_index: int = None
    ''' Active index in bone groups array

    :type: int
    '''

    def new(self, name: str = "Group") -> 'BoneGroup':
        ''' Add a new bone group to the object

        :param name: Name of the new group
        :type name: str
        :rtype: 'BoneGroup'
        :return: New bone group
        '''
        pass

    def remove(self, group: 'BoneGroup'):
        ''' Remove a bone group from this object

        :param group: Removed bone group
        :type group: 'BoneGroup'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BoolAttributeValue(bpy_struct):
    ''' Bool value in geometry attribute
    '''

    value: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilities(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_overlay: bool = None
    ''' 

    :type: bool
    '''

    has_random_texture_angle: bool = None
    ''' 

    :type: bool
    '''

    has_smooth_stroke: bool = None
    ''' 

    :type: bool
    '''

    has_spacing: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesImagePaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_accumulate: bool = None
    ''' 

    :type: bool
    '''

    has_color: bool = None
    ''' 

    :type: bool
    '''

    has_radius: bool = None
    ''' 

    :type: bool
    '''

    has_space_attenuation: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesSculpt(bpy_struct):
    ''' Read-only indications of which brush operations are supported by the current sculpt tool
    '''

    has_accumulate: bool = None
    ''' 

    :type: bool
    '''

    has_auto_smooth: bool = None
    ''' 

    :type: bool
    '''

    has_color: bool = None
    ''' 

    :type: bool
    '''

    has_direction: bool = None
    ''' 

    :type: bool
    '''

    has_gravity: bool = None
    ''' 

    :type: bool
    '''

    has_height: bool = None
    ''' 

    :type: bool
    '''

    has_jitter: bool = None
    ''' 

    :type: bool
    '''

    has_normal_weight: bool = None
    ''' 

    :type: bool
    '''

    has_persistence: bool = None
    ''' 

    :type: bool
    '''

    has_pinch_factor: bool = None
    ''' 

    :type: bool
    '''

    has_plane_offset: bool = None
    ''' 

    :type: bool
    '''

    has_rake_factor: bool = None
    ''' 

    :type: bool
    '''

    has_random_texture_angle: bool = None
    ''' 

    :type: bool
    '''

    has_sculpt_plane: bool = None
    ''' 

    :type: bool
    '''

    has_secondary_color: bool = None
    ''' 

    :type: bool
    '''

    has_smooth_stroke: bool = None
    ''' 

    :type: bool
    '''

    has_space_attenuation: bool = None
    ''' 

    :type: bool
    '''

    has_strength_pressure: bool = None
    ''' 

    :type: bool
    '''

    has_tilt: bool = None
    ''' 

    :type: bool
    '''

    has_topology_rake: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesVertexPaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_color: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesWeightPaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_weight: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class BrushGpencilSettings(bpy_struct):
    ''' Settings for grease pencil brush
    '''

    active_smooth_factor: float = None
    ''' Amount of smoothing while drawing

    :type: float
    '''

    angle: float = None
    ''' Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    '''

    angle_factor: float = None
    ''' Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    '''

    aspect: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    brush_draw_mode: typing.Union[str, int] = None
    ''' Preselected mode when using this brush * ACTIVE Active, Use current mode. * MATERIAL Material, Use always material mode. * VERTEXCOLOR Vertex Color, Use always Vertex Color mode.

    :type: typing.Union[str, int]
    '''

    curve_jitter: 'CurveMapping' = None
    ''' Curve used for the jitter effect

    :type: 'CurveMapping'
    '''

    curve_random_hue: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_pressure: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_saturation: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_strength: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_uv: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_value: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_sensitivity: 'CurveMapping' = None
    ''' Curve used for the sensitivity

    :type: 'CurveMapping'
    '''

    curve_strength: 'CurveMapping' = None
    ''' Curve used for the strength

    :type: 'CurveMapping'
    '''

    direction: typing.Union[str, int] = None
    ''' * ADD Add, Add effect of brush. * SUBTRACT Subtract, Subtract effect of brush.

    :type: typing.Union[str, int]
    '''

    eraser_mode: typing.Union[str, int] = None
    ''' Eraser Mode * SOFT Dissolve, Erase strokes, fading their points strength and thickness. * HARD Point, Erase stroke points. * STROKE Stroke, Erase entire strokes.

    :type: typing.Union[str, int]
    '''

    eraser_strength_factor: float = None
    ''' Amount of erasing for strength

    :type: float
    '''

    eraser_thickness_factor: float = None
    ''' Amount of erasing for thickness

    :type: float
    '''

    extend_stroke_factor: float = None
    ''' Strokes end extension for closing gaps, use zero to disable

    :type: float
    '''

    fill_direction: typing.Union[str, int] = None
    ''' Direction of the fill * NORMAL Normal, Fill internal area. * INVERT Inverted, Fill inverted area.

    :type: typing.Union[str, int]
    '''

    fill_draw_mode: typing.Union[str, int] = None
    ''' Mode to draw boundary limits * BOTH All, Use both visible strokes and edit lines as fill boundary limits. * STROKE Strokes, Use visible strokes as fill boundary limits. * CONTROL Edit Lines, Use edit lines as fill boundary limits.

    :type: typing.Union[str, int]
    '''

    fill_factor: float = None
    ''' Factor for fill boundary accuracy, higher values are more accurate but slower

    :type: float
    '''

    fill_layer_mode: typing.Union[str, int] = None
    ''' Layers used as boundaries * VISIBLE Visible, Visible layers. * ACTIVE Active, Only active layer. * ABOVE Layer Above, Layer above active. * BELOW Layer Below, Layer below active. * ALL_ABOVE All Above, All layers above active. * ALL_BELOW All Below, All layers below active.

    :type: typing.Union[str, int]
    '''

    fill_leak: int = None
    ''' Size in pixels to consider the leak closed

    :type: int
    '''

    fill_simplify_level: int = None
    ''' Number of simplify steps (large values reduce fill accuracy)

    :type: int
    '''

    fill_threshold: float = None
    ''' Threshold to consider color transparent for filling

    :type: float
    '''

    gpencil_paint_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_sculpt_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_vertex_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_weight_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    hardness: float = None
    ''' Gradient from the center of Dot and Box strokes (set to 1 for a solid stroke)

    :type: float
    '''

    input_samples: int = None
    ''' Generate intermediate points for very fast mouse movements. Set to 0 to disable

    :type: int
    '''

    material: 'Material' = None
    ''' Material used for strokes drawn using this brush

    :type: 'Material'
    '''

    pen_jitter: float = None
    ''' Jitter factor for new strokes

    :type: float
    '''

    pen_smooth_factor: float = None
    ''' Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise

    :type: float
    '''

    pen_smooth_steps: int = None
    ''' Number of times to smooth newly created strokes

    :type: int
    '''

    pen_strength: float = None
    ''' Color strength for new strokes (affect alpha factor of color)

    :type: float
    '''

    pen_subdivision_steps: int = None
    ''' Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    '''

    pin_draw_mode: bool = None
    ''' Pin the mode to the brush

    :type: bool
    '''

    random_hue_factor: float = None
    ''' Random factor to modify original hue

    :type: float
    '''

    random_pressure: float = None
    ''' Randomness factor for pressure in new strokes

    :type: float
    '''

    random_saturation_factor: float = None
    ''' Random factor to modify original saturation

    :type: float
    '''

    random_strength: float = None
    ''' Randomness factor strength in new strokes

    :type: float
    '''

    random_value_factor: float = None
    ''' Random factor to modify original value

    :type: float
    '''

    show_fill: bool = None
    ''' Show transparent lines to use as boundary for filling

    :type: bool
    '''

    show_fill_boundary: bool = None
    ''' Show help lines for filling to see boundaries

    :type: bool
    '''

    show_fill_extend: bool = None
    ''' Show help lines for stroke extension

    :type: bool
    '''

    show_lasso: bool = None
    ''' Do not display fill color while drawing the stroke

    :type: bool
    '''

    simplify_factor: float = None
    ''' Factor of Simplify using adaptive algorithm

    :type: float
    '''

    use_default_eraser: bool = None
    ''' Use this brush when enable eraser with fast switch key

    :type: bool
    '''

    use_edit_position: bool = None
    ''' The brush affects the position of the point

    :type: bool
    '''

    use_edit_pressure: bool = None
    ''' Affect pressure values as well when smoothing strokes

    :type: bool
    '''

    use_edit_strength: bool = None
    ''' The brush affects the color strength of the point

    :type: bool
    '''

    use_edit_thickness: bool = None
    ''' The brush affects the thickness of the point

    :type: bool
    '''

    use_edit_uv: bool = None
    ''' The brush affects the UV rotation of the point

    :type: bool
    '''

    use_fill_limit: bool = None
    ''' Fill only visible areas in viewport

    :type: bool
    '''

    use_jitter_pressure: bool = None
    ''' Use tablet pressure for jitter

    :type: bool
    '''

    use_material_pin: bool = None
    ''' Keep material assigned to brush

    :type: bool
    '''

    use_occlude_eraser: bool = None
    ''' Erase only strokes visible and not occluded

    :type: bool
    '''

    use_pressure: bool = None
    ''' Use tablet pressure

    :type: bool
    '''

    use_random_press_hue: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_radius: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_sat: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_strength: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_uv: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_val: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_settings_postprocess: bool = None
    ''' Additional post processing options for new strokes

    :type: bool
    '''

    use_settings_random: bool = None
    ''' Random brush settings

    :type: bool
    '''

    use_settings_stabilizer: bool = None
    ''' Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing

    :type: bool
    '''

    use_strength_pressure: bool = None
    ''' Use tablet pressure for color strength

    :type: bool
    '''

    use_stroke_random_hue: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_radius: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_sat: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_strength: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_uv: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_val: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_trim: bool = None
    ''' Trim intersecting stroke ends

    :type: bool
    '''

    uv_random: float = None
    ''' Random factor for autogenerated UV rotation

    :type: float
    '''

    vertex_color_factor: float = None
    ''' Factor used to mix vertex color to get final color

    :type: float
    '''

    vertex_mode: typing.Union[str, int] = None
    ''' Defines how vertex color affect to the strokes * STROKE Stroke, Vertex Color affects to Stroke only. * FILL Fill, Vertex Color affects to Fill only. * BOTH Stroke and Fill, Vertex Color affects to Stroke and Fill.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ByteColorAttributeValue(bpy_struct):
    ''' Color value in geometry attribute
    '''

    color: typing.List[float] = None
    ''' RGBA color in scene linear color space

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CameraBackgroundImage(bpy_struct):
    ''' Image and settings for display in the 3D View background
    '''

    alpha: float = None
    ''' Image opacity to blend the image against the background color

    :type: float
    '''

    clip: 'MovieClip' = None
    ''' Movie clip displayed and edited in this space

    :type: 'MovieClip'
    '''

    clip_user: 'MovieClipUser' = None
    ''' Parameters defining which frame of the movie clip is displayed

    :type: 'MovieClipUser'
    '''

    display_depth: typing.Union[str, int] = None
    ''' Display under or over everything

    :type: typing.Union[str, int]
    '''

    frame_method: typing.Union[str, int] = None
    ''' How the image fits in the camera frame

    :type: typing.Union[str, int]
    '''

    image: 'Image' = None
    ''' Image displayed and edited in this space

    :type: 'Image'
    '''

    image_user: 'ImageUser' = None
    ''' Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    '''

    offset: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    rotation: float = None
    ''' Rotation for the background image (ortho view only)

    :type: float
    '''

    scale: float = None
    ''' Scale the background image

    :type: float
    '''

    show_background_image: bool = None
    ''' Show this image as background

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show the expanded in the user interface

    :type: bool
    '''

    show_on_foreground: bool = None
    ''' Show this image in front of objects in viewport

    :type: bool
    '''

    source: typing.Union[str, int] = None
    ''' Data source used for background

    :type: typing.Union[str, int]
    '''

    use_camera_clip: bool = None
    ''' Use movie clip from active scene camera

    :type: bool
    '''

    use_flip_x: bool = None
    ''' Flip the background image horizontally

    :type: bool
    '''

    use_flip_y: bool = None
    ''' Flip the background image vertically

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CameraBackgroundImages(bpy_struct):
    ''' Collection of background images
    '''

    def new(self) -> 'CameraBackgroundImage':
        ''' Add new background image

        :rtype: 'CameraBackgroundImage'
        :return: Image displayed as viewport background
        '''
        pass

    def remove(self, image: 'CameraBackgroundImage'):
        ''' Remove background image

        :param image: Image displayed as viewport background
        :type image: 'CameraBackgroundImage'
        '''
        pass

    def clear(self):
        ''' Remove all background images

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CameraDOFSettings(bpy_struct):
    ''' Depth of Field settings
    '''

    aperture_blades: int = None
    ''' Number of blades in aperture for polygonal bokeh (at least 3)

    :type: int
    '''

    aperture_fstop: float = None
    ''' F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image)

    :type: float
    '''

    aperture_ratio: float = None
    ''' Distortion to simulate anamorphic lens bokeh

    :type: float
    '''

    aperture_rotation: float = None
    ''' Rotation of blades in aperture

    :type: float
    '''

    focus_distance: float = None
    ''' Distance to the focus point for depth of field

    :type: float
    '''

    focus_object: 'Object' = None
    ''' Use this object to define the depth of field focal point

    :type: 'Object'
    '''

    use_dof: bool = None
    ''' Use Depth of Field

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CameraStereoData(bpy_struct):
    ''' Stereoscopy settings for a Camera data-block
    '''

    convergence_distance: float = None
    ''' The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    '''

    convergence_mode: typing.Union[str, int] = None
    ''' * OFFAXIS Off-Axis, Off-axis frustums converging in a plane. * PARALLEL Parallel, Parallel cameras with no convergence. * TOE Toe-in, Rotated cameras, looking at the convergence distance.

    :type: typing.Union[str, int]
    '''

    interocular_distance: float = None
    ''' Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    '''

    pivot: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    pole_merge_angle_from: float = None
    ''' Angle at which interocular distance starts to fade to 0

    :type: float
    '''

    pole_merge_angle_to: float = None
    ''' Angle at which interocular distance is 0

    :type: float
    '''

    use_pole_merge: bool = None
    ''' Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    '''

    use_spherical_stereo: bool = None
    ''' Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ChannelDriverVariables(bpy_struct):
    ''' Collection of channel driver Variables
    '''

    def new(self) -> 'DriverVariable':
        ''' Add a new variable for the driver

        :rtype: 'DriverVariable'
        :return: Newly created Driver Variable
        '''
        pass

    def remove(self, variable: 'DriverVariable'):
        ''' Remove an existing variable from the driver

        :param variable: Variable to remove from the driver
        :type variable: 'DriverVariable'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ChildParticle(bpy_struct):
    ''' Child particle interpolated from simulated or edited particles
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ClothCollisionSettings(bpy_struct):
    ''' Cloth simulation settings for self collision and collision with other objects
    '''

    collection: 'Collection' = None
    ''' Limit colliders to this Collection

    :type: 'Collection'
    '''

    collision_quality: int = None
    ''' How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    '''

    damping: float = None
    ''' Amount of velocity lost on collision

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance between collision objects before collision response takes effect

    :type: float
    '''

    friction: float = None
    ''' Friction force if a collision happened (higher = less movement)

    :type: float
    '''

    impulse_clamp: float = None
    ''' Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    '''

    self_distance_min: float = None
    ''' Minimum distance between cloth faces before collision response takes effect

    :type: float
    '''

    self_friction: float = None
    ''' Friction with self contact

    :type: float
    '''

    self_impulse_clamp: float = None
    ''' Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    '''

    use_collision: bool = None
    ''' Enable collisions with other objects

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable self collisions

    :type: bool
    '''

    vertex_group_object_collisions: str = None
    ''' Triangles with all vertices in this group are not used during object collisions

    :type: str
    '''

    vertex_group_self_collisions: str = None
    ''' Triangles with all vertices in this group are not used during self collisions

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ClothSettings(bpy_struct):
    ''' Cloth simulation settings for an object
    '''

    air_damping: float = None
    ''' Air has normally some thickness which slows falling things down

    :type: float
    '''

    bending_damping: float = None
    ''' Amount of damping in bending behavior

    :type: float
    '''

    bending_model: typing.Union[str, int] = None
    ''' Physical model for simulating bending forces * ANGULAR Angular, Cloth model with angular bending springs. * LINEAR Linear, Cloth model with linear bending springs (legacy).

    :type: typing.Union[str, int]
    '''

    bending_stiffness: float = None
    ''' How much the material resists bending

    :type: float
    '''

    bending_stiffness_max: float = None
    ''' Maximum bending stiffness value

    :type: float
    '''

    collider_friction: float = None
    ''' 

    :type: float
    '''

    compression_damping: float = None
    ''' Amount of damping in compression behavior

    :type: float
    '''

    compression_stiffness: float = None
    ''' How much the material resists compression

    :type: float
    '''

    compression_stiffness_max: float = None
    ''' Maximum compression stiffness value

    :type: float
    '''

    density_strength: float = None
    ''' Influence of target density on the simulation

    :type: float
    '''

    density_target: float = None
    ''' Maximum density of hair

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    fluid_density: float = None
    ''' Density (kg/l) of the fluid contained inside the object, used to create a hydrostatic pressure gradient simulating the weight of the internal fluid, or buoyancy from the surrounding fluid if negative

    :type: float
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: typing.List[float] = None
    ''' Gravity or external force vector

    :type: typing.List[float]
    '''

    internal_compression_stiffness: float = None
    ''' How much the material resists compression

    :type: float
    '''

    internal_compression_stiffness_max: float = None
    ''' Maximum compression stiffness value

    :type: float
    '''

    internal_friction: float = None
    ''' 

    :type: float
    '''

    internal_spring_max_diversion: float = None
    ''' How much the rays used to connect the internal points can diverge from the vertex normal

    :type: float
    '''

    internal_spring_max_length: float = None
    ''' The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit

    :type: float
    '''

    internal_spring_normal_check: bool = None
    ''' Require the points the internal springs connect to have opposite normal directions

    :type: bool
    '''

    internal_tension_stiffness: float = None
    ''' How much the material resists stretching

    :type: float
    '''

    internal_tension_stiffness_max: float = None
    ''' Maximum tension stiffness value

    :type: float
    '''

    mass: float = None
    ''' The mass of each vertex on the cloth material

    :type: float
    '''

    pin_stiffness: float = None
    ''' Pin (vertex target position) spring stiffness

    :type: float
    '''

    pressure_factor: float = None
    ''' Ambient pressure (kPa) that balances out between the inside and outside of the object when it has the target volume

    :type: float
    '''

    quality: int = None
    ''' Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    '''

    rest_shape_key: 'ShapeKey' = None
    ''' Shape key to use the rest spring lengths from

    :type: 'ShapeKey'
    '''

    sewing_force_max: float = None
    ''' Maximum sewing force

    :type: float
    '''

    shear_damping: float = None
    ''' Amount of damping in shearing behavior

    :type: float
    '''

    shear_stiffness: float = None
    ''' How much the material resists shearing

    :type: float
    '''

    shear_stiffness_max: float = None
    ''' Maximum shear scaling value

    :type: float
    '''

    shrink_max: float = None
    ''' Max amount to shrink cloth by

    :type: float
    '''

    shrink_min: float = None
    ''' Factor by which to shrink cloth

    :type: float
    '''

    target_volume: float = None
    ''' The mesh volume where the inner/outer pressure will be the same. If set to zero the change in volume will not affect pressure

    :type: float
    '''

    tension_damping: float = None
    ''' Amount of damping in stretching behavior

    :type: float
    '''

    tension_stiffness: float = None
    ''' How much the material resists stretching

    :type: float
    '''

    tension_stiffness_max: float = None
    ''' Maximum tension stiffness value

    :type: float
    '''

    time_scale: float = None
    ''' Cloth speed is multiplied by this value

    :type: float
    '''

    uniform_pressure_force: float = None
    ''' The uniform pressure that is constantly applied to the mesh, in units of Pressure Scale. Can be negative

    :type: float
    '''

    use_dynamic_mesh: bool = None
    ''' Make simulation respect deformations in the base mesh

    :type: bool
    '''

    use_internal_springs: bool = None
    ''' Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh

    :type: bool
    '''

    use_pressure: bool = None
    ''' Simulate pressure inside a closed cloth mesh

    :type: bool
    '''

    use_pressure_volume: bool = None
    ''' Use the Target Volume parameter as the initial volume, instead of calculating it from the mesh itself

    :type: bool
    '''

    use_sewing_springs: bool = None
    ''' Pulls loose edges together

    :type: bool
    '''

    vertex_group_bending: str = None
    ''' Vertex group for fine control over bending stiffness

    :type: str
    '''

    vertex_group_intern: str = None
    ''' Vertex group for fine control over the internal spring stiffness

    :type: str
    '''

    vertex_group_mass: str = None
    ''' Vertex Group for pinning of vertices

    :type: str
    '''

    vertex_group_pressure: str = None
    ''' Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation

    :type: str
    '''

    vertex_group_shear_stiffness: str = None
    ''' Vertex group for fine control over shear stiffness

    :type: str
    '''

    vertex_group_shrink: str = None
    ''' Vertex Group for shrinking cloth

    :type: str
    '''

    vertex_group_structural_stiffness: str = None
    ''' Vertex group for fine control over structural stiffness

    :type: str
    '''

    voxel_cell_size: float = None
    ''' Size of the voxel grid cells for interaction effects

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ClothSolverResult(bpy_struct):
    ''' Result of cloth solver iteration
    '''

    avg_error: float = None
    ''' Average error during substeps

    :type: float
    '''

    avg_iterations: float = None
    ''' Average iterations during substeps

    :type: float
    '''

    max_error: float = None
    ''' Maximum error during substeps

    :type: float
    '''

    max_iterations: int = None
    ''' Maximum iterations during substeps

    :type: int
    '''

    min_error: float = None
    ''' Minimum error during substeps

    :type: float
    '''

    min_iterations: int = None
    ''' Minimum iterations during substeps

    :type: int
    '''

    status: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Status of the solver iteration * SUCCESS Success, Computation was successful. * NUMERICAL_ISSUE Numerical Issue, The provided data did not satisfy the prerequisites. * NO_CONVERGENCE No Convergence, Iterative procedure did not converge. * INVALID_INPUT Invalid Input, The inputs are invalid, or the algorithm has been improperly called.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CollectionChildren(bpy_struct):
    ''' Collection of child collections
    '''

    def link(self, child: 'Collection'):
        ''' Add this collection as child of this collection

        :param child: Collection to add
        :type child: 'Collection'
        '''
        pass

    def unlink(self, child: 'Collection'):
        ''' Remove this child collection from a collection

        :param child: Collection to remove
        :type child: 'Collection'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CollectionObjects(bpy_struct):
    ''' Collection of collection objects
    '''

    def link(self, object: 'Object'):
        ''' Add this object to a collection

        :param object: Object to add
        :type object: 'Object'
        '''
        pass

    def unlink(self, object: 'Object'):
        ''' Remove this object from a collection

        :param object: Object to remove
        :type object: 'Object'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CollisionSettings(bpy_struct):
    ''' Collision settings for object in physics simulation
    '''

    absorption: float = None
    ''' How much of effector force gets lost during collision with this object (in percent)

    :type: float
    '''

    cloth_friction: float = None
    ''' Friction for cloth collisions

    :type: float
    '''

    damping: float = None
    ''' Amount of damping during collision

    :type: float
    '''

    damping_factor: float = None
    ''' Amount of damping during particle collision

    :type: float
    '''

    damping_random: float = None
    ''' Random variation of damping

    :type: float
    '''

    friction_factor: float = None
    ''' Amount of friction during particle collision

    :type: float
    '''

    friction_random: float = None
    ''' Random variation of friction

    :type: float
    '''

    permeability: float = None
    ''' Chance that the particle will pass through the mesh

    :type: float
    '''

    stickiness: float = None
    ''' Amount of stickiness to surface collision

    :type: float
    '''

    thickness_inner: float = None
    ''' Inner face thickness (only used by softbodies)

    :type: float
    '''

    thickness_outer: float = None
    ''' Outer face thickness

    :type: float
    '''

    use: bool = None
    ''' Enable this objects as a collider for physics systems

    :type: bool
    '''

    use_culling: bool = None
    ''' Cloth collision acts with respect to the collider normals (improves penetration recovery)

    :type: bool
    '''

    use_normal: bool = None
    ''' Cloth collision impulses act in the direction of the collider normals (more reliable in some cases)

    :type: bool
    '''

    use_particle_kill: bool = None
    ''' Kill collided particles

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorManagedDisplaySettings(bpy_struct):
    ''' Color management specific to display device
    '''

    display_device: typing.Union[str, int] = None
    ''' Display device name

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorManagedInputColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    is_data: bool = None
    ''' Treat image as non-color data without color management, like normal or displacement maps

    :type: bool
    '''

    name: typing.Union[str, int] = None
    ''' Color space in the image file, to convert to and from when saving and loading the image * Filmic Log Filmic Log, Log based filmic shaper with 16.5 stops of latitude, and 25 stops of dynamic range. * Linear Linear, Rec. 709 (Full Range), Blender native linear space. * Linear ACES Linear ACES, ACES linear space. * Non-Color Non-Color, Color space used for images which contains non-color data (i,e, normal maps). * Raw Raw. * sRGB sRGB, Standard RGB Display Space. * XYZ XYZ.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorManagedSequencerColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    name: typing.Union[str, int] = None
    ''' Color space that the sequencer operates in * Filmic Log Filmic Log, Log based filmic shaper with 16.5 stops of latitude, and 25 stops of dynamic range. * Linear Linear, Rec. 709 (Full Range), Blender native linear space. * Linear ACES Linear ACES, ACES linear space. * Non-Color Non-Color, Color space used for images which contains non-color data (i,e, normal maps). * Raw Raw. * sRGB sRGB, Standard RGB Display Space. * XYZ XYZ.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorManagedViewSettings(bpy_struct):
    ''' Color management settings used for displaying images on the display
    '''

    curve_mapping: 'CurveMapping' = None
    ''' Color curve mapping applied before display transform

    :type: 'CurveMapping'
    '''

    exposure: float = None
    ''' Exposure (stops) applied before display transform

    :type: float
    '''

    gamma: float = None
    ''' Amount of gamma modification applied after display transform

    :type: float
    '''

    look: typing.Union[str, int] = None
    ''' Additional transform applied before view transform for artistic needs * NONE None, Do not modify image in an artistic manner.

    :type: typing.Union[str, int]
    '''

    use_curve_mapping: bool = None
    ''' Use RGB curved for pre-display transformation

    :type: bool
    '''

    view_transform: typing.Union[str, int] = None
    ''' View used when converting image to a display space * NONE None, Do not perform any color transform on display, use old non-color managed technique for display.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorMapping(bpy_struct):
    ''' Color mapping settings
    '''

    blend_color: typing.List[float] = None
    ''' Blend color to mix with texture output color

    :type: typing.List[float]
    '''

    blend_factor: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to mix with texture output color

    :type: typing.Union[str, int]
    '''

    brightness: float = None
    ''' Adjust the brightness of the texture

    :type: float
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    contrast: float = None
    ''' Adjust the contrast of the texture

    :type: float
    '''

    saturation: float = None
    ''' Adjust the saturation of colors in the texture

    :type: float
    '''

    use_color_ramp: bool = None
    ''' Toggle color ramp operations

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorRamp(bpy_struct):
    ''' Color ramp mapping a scalar value to a color
    '''

    color_mode: typing.Union[str, int] = None
    ''' Set color mode to use for interpolation

    :type: typing.Union[str, int]
    '''

    elements: typing.Union[typing.Dict[str, 'ColorRampElement'], typing.
                           List['ColorRampElement'], 'bpy_prop_collection',
                           'ColorRampElements'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ColorRampElement'], typing.List['ColorRampElement'], 'bpy_prop_collection', 'ColorRampElements']
    '''

    hue_interpolation: typing.Union[str, int] = None
    ''' Set color interpolation

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Set interpolation between color stops

    :type: typing.Union[str, int]
    '''

    def evaluate(self, position: float) -> typing.List[float]:
        ''' Evaluate ColorRamp

        :param position: Position, Evaluate ColorRamp at position
        :type position: float
        :rtype: typing.List[float]
        :return: Color, Color at given position
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorRampElement(bpy_struct):
    ''' Element defining a color at a position in the color ramp
    '''

    alpha: float = None
    ''' Set alpha of selected color stop

    :type: float
    '''

    color: typing.List[float] = None
    ''' Set color of selected color stop

    :type: typing.List[float]
    '''

    position: float = None
    ''' Set position of selected color stop

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ColorRampElements(bpy_struct):
    ''' Collection of Color Ramp Elements
    '''

    def new(self, position: float) -> 'ColorRampElement':
        ''' Add element to ColorRamp

        :param position: Position, Position to add element
        :type position: float
        :rtype: 'ColorRampElement'
        :return: New element
        '''
        pass

    def remove(self, element: 'ColorRampElement'):
        ''' Delete element from ColorRamp

        :param element: Element to remove
        :type element: 'ColorRampElement'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CompositorNodeOutputFileFileSlots(bpy_struct):
    ''' Collection of File Output node slots
    '''

    def new(self, name: str) -> 'NodeSocket':
        ''' Add a file slot to this node

        :param name: Name
        :type name: str
        :rtype: 'NodeSocket'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        ''' Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self):
        ''' Remove all file slots from this node

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CompositorNodeOutputFileLayerSlots(bpy_struct):
    ''' Collection of File Output node slots
    '''

    def new(self, name: str) -> 'NodeSocket':
        ''' Add a file slot to this node

        :param name: Name
        :type name: str
        :rtype: 'NodeSocket'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        ''' Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self):
        ''' Remove all file slots from this node

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ConsoleLine(bpy_struct):
    ''' Input line for the interactive console
    '''

    body: str = None
    ''' Text in the line

    :type: str
    '''

    current_character: int = None
    ''' 

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Console line type when used in scrollback

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Constraint(bpy_struct):
    ''' Constraint modifying the transformation of objects and bones
    '''

    active: bool = None
    ''' Constraint is the one being edited

    :type: bool
    '''

    error_location: float = None
    ''' Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    '''

    error_rotation: float = None
    ''' Amount of residual error in radians for constraints that work on orientation

    :type: float
    '''

    influence: float = None
    ''' Amount of influence constraint will have on the final solution

    :type: float
    '''

    is_proxy_local: bool = None
    ''' Constraint was added in this proxy instance (i.e. did not belong to source Armature)

    :type: bool
    '''

    is_valid: bool = None
    ''' Constraint has valid settings and can be evaluated

    :type: bool
    '''

    mute: bool = None
    ''' Enable/Disable Constraint

    :type: bool
    '''

    name: str = None
    ''' Constraint name

    :type: str
    '''

    owner_space: typing.Union[str, int] = None
    ''' Space that owner is evaluated in * WORLD World Space, The constraint is applied relative to the world coordinate system. * CUSTOM Custom Space, The constraint is applied in local space of a custom object/bone/vertex group. * POSE Pose Space, The constraint is applied in Pose Space, the object transformation is ignored. * LOCAL_WITH_PARENT Local With Parent, The constraint is applied relative to the rest pose local coordinate system of the bone, thus including the parent-induced transformation. * LOCAL Local Space, The constraint is applied relative to the local coordinate system of the object.

    :type: typing.Union[str, int]
    '''

    show_expanded: bool = None
    ''' Constraint's panel is expanded in UI

    :type: bool
    '''

    space_object: 'Object' = None
    ''' Object for Custom Space

    :type: 'Object'
    '''

    space_subtarget: str = None
    ''' Armature bone, mesh or lattice vertex group, ...

    :type: str
    '''

    target_space: typing.Union[str, int] = None
    ''' Space that target is evaluated in * WORLD World Space, The transformation of the target is evaluated relative to the world coordinate system. * CUSTOM Custom Space, The transformation of the target is evaluated relative to a custom object/bone/vertex group. * POSE Pose Space, The transformation of the target is only evaluated in the Pose Space, the target armature object transformation is ignored. * LOCAL_WITH_PARENT Local With Parent, The transformation of the target bone is evaluated relative to its rest pose local coordinate system, thus including the parent-induced transformation. * LOCAL Local Space, The transformation of the target is evaluated relative to its local coordinate system.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' * CAMERA_SOLVER Camera Solver. * FOLLOW_TRACK Follow Track. * OBJECT_SOLVER Object Solver. * COPY_LOCATION Copy Location, Copy the location of a target (with an optional offset), so that they move together. * COPY_ROTATION Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * COPY_SCALE Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * COPY_TRANSFORMS Copy Transforms, Copy all the transformations of a target, so that they move together. * LIMIT_DISTANCE Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * LIMIT_LOCATION Limit Location, Restrict movement along each axis within given ranges. * LIMIT_ROTATION Limit Rotation, Restrict rotation along each axis within given ranges. * LIMIT_SCALE Limit Scale, Restrict scaling along each axis with given ranges. * MAINTAIN_VOLUME Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * TRANSFORM Transformation, Use one transform property from target to control another (or same) property on owner. * TRANSFORM_CACHE Transform Cache, Look up the transformation matrix from an external file. * CLAMP_TO Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * DAMPED_TRACK Damped Track, Point towards a target by performing the smallest rotation necessary. * IK Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * LOCKED_TRACK Locked Track, Rotate around the specified ('locked') axis to point towards a target. * SPLINE_IK Spline IK, Align chain of bones along a curve (Bones only). * STRETCH_TO Stretch To, Stretch along Y-Axis to point towards a target. * TRACK_TO Track To, Legacy tracking constraint prone to twisting artifacts. * ACTION Action, Use transform property of target to look up pose for owner from an Action. * ARMATURE Armature, Apply weight-blended transformation from multiple bones like the Armature modifier. * CHILD_OF Child Of, Make target the 'detachable' parent of owner. * FLOOR Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * FOLLOW_PATH Follow Path, Use to animate an object/bone following a path. * PIVOT Pivot, Change pivot point for transforms (buggy). * SHRINKWRAP Shrinkwrap, Restrict movements to surface of target mesh.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ConstraintTarget(bpy_struct):
    ''' Target object for multi-target constraints
    '''

    subtarget: str = None
    ''' Armature bone, mesh or lattice vertex group, ...

    :type: str
    '''

    target: 'Object' = None
    ''' Target object

    :type: 'Object'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ConstraintTargetBone(bpy_struct):
    ''' Target bone for multi-target constraints
    '''

    subtarget: str = None
    ''' Target armature bone

    :type: str
    '''

    target: 'Object' = None
    ''' Target armature

    :type: 'Object'
    '''

    weight: float = None
    ''' Blending weight of this bone

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Context(bpy_struct):
    ''' Current windowmanager and data context
    '''

    area: 'Area' = None
    ''' 

    :type: 'Area'
    '''

    blend_data: 'BlendData' = None
    ''' 

    :type: 'BlendData'
    '''

    collection: 'Collection' = None
    ''' 

    :type: 'Collection'
    '''

    engine: str = None
    ''' 

    :type: str
    '''

    gizmo_group: 'GizmoGroup' = None
    ''' 

    :type: 'GizmoGroup'
    '''

    layer_collection: 'LayerCollection' = None
    ''' 

    :type: 'LayerCollection'
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    preferences: 'Preferences' = None
    ''' 

    :type: 'Preferences'
    '''

    region: 'Region' = None
    ''' 

    :type: 'Region'
    '''

    region_data: 'RegionView3D' = None
    ''' 

    :type: 'RegionView3D'
    '''

    scene: 'Scene' = None
    ''' 

    :type: 'Scene'
    '''

    screen: 'Screen' = None
    ''' 

    :type: 'Screen'
    '''

    space_data: 'Space' = None
    ''' 

    :type: 'Space'
    '''

    tool_settings: 'ToolSettings' = None
    ''' 

    :type: 'ToolSettings'
    '''

    view_layer: 'ViewLayer' = None
    ''' 

    :type: 'ViewLayer'
    '''

    window: 'Window' = None
    ''' 

    :type: 'Window'
    '''

    window_manager: 'WindowManager' = None
    ''' 

    :type: 'WindowManager'
    '''

    workspace: 'WorkSpace' = None
    ''' 

    :type: 'WorkSpace'
    '''

    def evaluated_depsgraph_get(self) -> 'Depsgraph':
        ''' Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph.

        :rtype: 'Depsgraph'
        :return: Evaluated dependency graph
        '''
        pass

    def copy(self):
        ''' 

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CryptomatteEntry(bpy_struct):
    encoded_hash: float = None
    ''' 

    :type: float
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveMap(bpy_struct):
    ''' Curve in a curve mapping
    '''

    points: typing.Union[typing.Dict[str, 'CurveMapPoint'], typing.
                         List['CurveMapPoint'], 'bpy_prop_collection',
                         'CurveMapPoints'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'CurveMapPoint'], typing.List['CurveMapPoint'], 'bpy_prop_collection', 'CurveMapPoints']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveMapPoint(bpy_struct):
    ''' Point of a curve used for a curve mapping
    '''

    handle_type: typing.Union[str, int] = None
    ''' Curve interpolation at this point: Bezier or vector

    :type: typing.Union[str, int]
    '''

    location: typing.List[float] = None
    ''' X/Y coordinates of the curve point

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Selection state of the curve point

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveMapPoints(bpy_struct):
    ''' Collection of Curve Map Points
    '''

    def new(self, position: float, value: float) -> 'CurveMapPoint':
        ''' Add point to CurveMap

        :param position: Position, Position to add point
        :type position: float
        :param value: Value, Value of point
        :type value: float
        :rtype: 'CurveMapPoint'
        :return: New point
        '''
        pass

    def remove(self, point: 'CurveMapPoint'):
        ''' Delete point from CurveMap

        :param point: PointElement to remove
        :type point: 'CurveMapPoint'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveMapping(bpy_struct):
    ''' Curve mapping to map color, vector and scalar values to other values using a user defined curve
    '''

    black_level: typing.List[float] = None
    ''' For RGB curves, the color that black is mapped to

    :type: typing.List[float]
    '''

    clip_max_x: float = None
    ''' 

    :type: float
    '''

    clip_max_y: float = None
    ''' 

    :type: float
    '''

    clip_min_x: float = None
    ''' 

    :type: float
    '''

    clip_min_y: float = None
    ''' 

    :type: float
    '''

    curves: typing.Union[typing.Dict[str, 'CurveMap'], typing.
                         List['CurveMap'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'CurveMap'], typing.List['CurveMap'], 'bpy_prop_collection']
    '''

    extend: typing.Union[str, int] = None
    ''' Extrapolate the curve or extend it horizontally

    :type: typing.Union[str, int]
    '''

    tone: typing.Union[str, int] = None
    ''' Tone of the curve

    :type: typing.Union[str, int]
    '''

    use_clip: bool = None
    ''' Force the curve view to fit a defined boundary

    :type: bool
    '''

    white_level: typing.List[float] = None
    ''' For RGB curves, the color that white is mapped to

    :type: typing.List[float]
    '''

    def update(self):
        ''' Update curve mapping after making changes

        '''
        pass

    def reset_view(self):
        ''' Reset the curve mapping grid to its clipping size

        '''
        pass

    def initialize(self):
        ''' Initialize curve

        '''
        pass

    def evaluate(self, curve: 'CurveMap', position: float) -> float:
        ''' Evaluate curve at given location

        :param curve: curve, Curve to evaluate
        :type curve: 'CurveMap'
        :param position: Position, Position to evaluate curve at
        :type position: float
        :rtype: float
        :return: Value, Value of curve at given location
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurvePaintSettings(bpy_struct):
    corner_angle: float = None
    ''' Angles above this are considered corners

    :type: float
    '''

    curve_type: typing.Union[str, int] = None
    ''' Type of curve to use for new strokes

    :type: typing.Union[str, int]
    '''

    depth_mode: typing.Union[str, int] = None
    ''' Method of projecting depth

    :type: typing.Union[str, int]
    '''

    error_threshold: int = None
    ''' Allow deviation for a smoother, less precise line

    :type: int
    '''

    fit_method: typing.Union[str, int] = None
    ''' Curve fitting method * REFIT Refit, Incrementally refit the curve (high quality). * SPLIT Split, Split the curve until the tolerance is met (fast).

    :type: typing.Union[str, int]
    '''

    radius_max: float = None
    ''' Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    '''

    radius_min: float = None
    ''' Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    '''

    radius_taper_end: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    radius_taper_start: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    surface_offset: float = None
    ''' Offset the stroke from the surface

    :type: float
    '''

    surface_plane: typing.Union[str, int] = None
    ''' Plane for projected stroke * NORMAL_VIEW Normal/View, Display perpendicular to the surface. * NORMAL_SURFACE Normal/Surface, Display aligned to the surface. * VIEW View, Display aligned to the viewport.

    :type: typing.Union[str, int]
    '''

    use_corners_detect: bool = None
    ''' Detect corners and use non-aligned handles

    :type: bool
    '''

    use_offset_absolute: bool = None
    ''' Apply a fixed offset (don't scale by the radius)

    :type: bool
    '''

    use_pressure_radius: bool = None
    ''' Map tablet pressure to curve radius

    :type: bool
    '''

    use_stroke_endpoints: bool = None
    ''' Use the start of the stroke for the depth

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveProfile(bpy_struct):
    ''' Profile Path editor used to build a profile path
    '''

    points: typing.Union[typing.Dict[str, 'CurveProfilePoint'], typing.
                         List['CurveProfilePoint'], 'bpy_prop_collection',
                         'CurveProfilePoints'] = None
    ''' Profile control points

    :type: typing.Union[typing.Dict[str, 'CurveProfilePoint'], typing.List['CurveProfilePoint'], 'bpy_prop_collection', 'CurveProfilePoints']
    '''

    preset: typing.Union[str, int] = None
    ''' * LINE Line, Default. * SUPPORTS Support Loops, Loops on each side of the profile. * CORNICE Cornice Molding. * CROWN Crown Molding. * STEPS Steps, A number of steps defined by the segments.

    :type: typing.Union[str, int]
    '''

    segments: typing.Union[typing.Dict[str, 'CurveProfilePoint'], typing.
                           List['CurveProfilePoint'],
                           'bpy_prop_collection'] = None
    ''' Segments sampled from control points

    :type: typing.Union[typing.Dict[str, 'CurveProfilePoint'], typing.List['CurveProfilePoint'], 'bpy_prop_collection']
    '''

    use_clip: bool = None
    ''' Force the path view to fit a defined boundary

    :type: bool
    '''

    use_sample_even_lengths: bool = None
    ''' Sample edges with even lengths

    :type: bool
    '''

    use_sample_straight_edges: bool = None
    ''' Sample edges with vector handles

    :type: bool
    '''

    def update(self):
        ''' Refresh internal data, remove doubles and clip points

        '''
        pass

    def reset_view(self):
        ''' Reset the curve profile grid to its clipping size

        '''
        pass

    def initialize(self, totsegments: int):
        ''' Set the number of display segments and fill tables

        :param totsegments: The number of segment values to initialize the segments table with
        :type totsegments: int
        '''
        pass

    def evaluate(self, length_portion: float) -> typing.List[float]:
        ''' Evaluate the at the given portion of the path length

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation
        :type length_portion: float
        :rtype: typing.List[float]
        :return: Location, The location at the given portion of the profile
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveProfilePoint(bpy_struct):
    ''' Point of a path used to define a profile
    '''

    handle_type_1: typing.Union[str, int] = None
    ''' Path interpolation at this point

    :type: typing.Union[str, int]
    '''

    handle_type_2: typing.Union[str, int] = None
    ''' Path interpolation at this point

    :type: typing.Union[str, int]
    '''

    location: typing.List[float] = None
    ''' X/Y coordinates of the path point

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Selection state of the path point

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveProfilePoints(bpy_struct):
    ''' Collection of Profile Points
    '''

    def add(self, x: float, y: float) -> 'CurveProfilePoint':
        ''' Add point to the profile

        :param x: X Position, X Position for new point
        :type x: float
        :param y: Y Position, Y Position for new point
        :type y: float
        :rtype: 'CurveProfilePoint'
        :return: New point
        '''
        pass

    def remove(self, point: 'CurveProfilePoint'):
        ''' Delete point from the profile

        :param point: Point to remove
        :type point: 'CurveProfilePoint'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class CurveSplines(bpy_struct):
    ''' Collection of curve splines
    '''

    active: 'Spline' = None
    ''' Active curve spline

    :type: 'Spline'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Spline':
        ''' Add a new spline to the curve

        :param type: type for the new spline
        :type type: typing.Union[str, int]
        :rtype: 'Spline'
        :return: The newly created spline
        '''
        pass

    def remove(self, spline: 'Spline'):
        ''' Remove a spline from a curve

        :param spline: The spline to remove
        :type spline: 'Spline'
        '''
        pass

    def clear(self):
        ''' Remove all splines from a curve

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Depsgraph(bpy_struct):
    ids: typing.Union[typing.Dict[str, 'ID'], typing.
                      List['ID'], 'bpy_prop_collection'] = None
    ''' All evaluated data-blocks

    :type: typing.Union[typing.Dict[str, 'ID'], typing.List['ID'], 'bpy_prop_collection']
    '''

    mode: typing.Union[str, int] = None
    ''' Evaluation mode * VIEWPORT Viewport, Viewport non-rendered mode. * RENDER Render, Render.

    :type: typing.Union[str, int]
    '''

    object_instances: typing.Union[
        typing.Dict[str, 'DepsgraphObjectInstance'], typing.
        List['DepsgraphObjectInstance'], 'bpy_prop_collection'] = None
    ''' All object instances to display or render (Warning: Only use this as an iterator, never as a sequence, and do not keep any references to its items)

    :type: typing.Union[typing.Dict[str, 'DepsgraphObjectInstance'], typing.List['DepsgraphObjectInstance'], 'bpy_prop_collection']
    '''

    objects: typing.Union[typing.Dict[str, 'Object'], typing.
                          List['Object'], 'bpy_prop_collection'] = None
    ''' Evaluated objects in the dependency graph

    :type: typing.Union[typing.Dict[str, 'Object'], typing.List['Object'], 'bpy_prop_collection']
    '''

    scene: 'Scene' = None
    ''' Original scene dependency graph is built for

    :type: 'Scene'
    '''

    scene_eval: 'Scene' = None
    ''' Original scene dependency graph is built for

    :type: 'Scene'
    '''

    updates: typing.Union[typing.Dict[str, 'DepsgraphUpdate'], typing.
                          List['DepsgraphUpdate'],
                          'bpy_prop_collection'] = None
    ''' Updates to data-blocks

    :type: typing.Union[typing.Dict[str, 'DepsgraphUpdate'], typing.List['DepsgraphUpdate'], 'bpy_prop_collection']
    '''

    view_layer: 'ViewLayer' = None
    ''' Original view layer dependency graph is built for

    :type: 'ViewLayer'
    '''

    view_layer_eval: 'ViewLayer' = None
    ''' Original view layer dependency graph is built for

    :type: 'ViewLayer'
    '''

    def debug_relations_graphviz(self, filename: str):
        ''' debug_relations_graphviz

        :param filename: File Name, Output path for the graphviz debug file
        :type filename: str
        '''
        pass

    def debug_stats_gnuplot(self, filename: str, output_filename: str):
        ''' debug_stats_gnuplot

        :param filename: File Name, Output path for the gnuplot debug file
        :type filename: str
        :param output_filename: Output File Name, File name where gnuplot script will save the result
        :type output_filename: str
        '''
        pass

    def debug_tag_update(self):
        ''' debug_tag_update

        '''
        pass

    def debug_stats(self) -> str:
        ''' Report the number of elements in the Dependency Graph

        :rtype: str
        :return: result
        '''
        pass

    def update(self):
        ''' Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph.

        '''
        pass

    def id_eval_get(self, id: 'ID') -> 'ID':
        ''' id_eval_get

        :param id: Original ID to get evaluated complementary part for
        :type id: 'ID'
        :rtype: 'ID'
        :return: Evaluated ID for the given original one
        '''
        pass

    def id_type_updated(self, id_type: typing.Union[str, int]) -> bool:
        ''' id_type_updated

        :param id_type: ID Type
        :type id_type: typing.Union[str, int]
        :rtype: bool
        :return: Updated, True if any datablock with this type was added, updated or removed
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DepsgraphObjectInstance(bpy_struct):
    ''' Extended information about dependency graph object iterator (Warning: All data here is 'evaluated' one, not original .blend IDs)
    '''

    instance_object: 'Object' = None
    ''' Evaluated object which is being instanced by this iterator

    :type: 'Object'
    '''

    is_instance: bool = None
    ''' Denotes if the object is generated by another object

    :type: bool
    '''

    matrix_world: typing.List[float] = None
    ''' Generated transform matrix in world space

    :type: typing.List[float]
    '''

    object: 'Object' = None
    ''' Evaluated object the iterator points to

    :type: 'Object'
    '''

    orco: typing.List[float] = None
    ''' Generated coordinates in parent object space

    :type: typing.List[float]
    '''

    parent: 'Object' = None
    ''' If the object is an instance, the parent object that generated it

    :type: 'Object'
    '''

    particle_system: 'ParticleSystem' = None
    ''' Evaluated particle system that this object was instanced from

    :type: 'ParticleSystem'
    '''

    persistent_id: typing.List[int] = None
    ''' Persistent identifier for inter-frame matching of objects with motion blur

    :type: typing.List[int]
    '''

    random_id: int = None
    ''' Random id for this instance, typically for randomized shading

    :type: int
    '''

    show_particles: bool = None
    ''' Particles part of the object should be visible in the render

    :type: bool
    '''

    show_self: bool = None
    ''' The object geometry itself should be visible in the render

    :type: bool
    '''

    uv: typing.List[float] = None
    ''' UV coordinates in parent object space

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DepsgraphUpdate(bpy_struct):
    ''' Information about ID that was updated
    '''

    id: 'ID' = None
    ''' Updated data-block

    :type: 'ID'
    '''

    is_updated_geometry: bool = None
    ''' Object geometry is updated

    :type: bool
    '''

    is_updated_shading: bool = None
    ''' Object shading is updated

    :type: bool
    '''

    is_updated_transform: bool = None
    ''' Object transformation is updated

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DisplaySafeAreas(bpy_struct):
    ''' Safe areas used in 3D view and the sequencer
    '''

    action: typing.List[float] = None
    ''' Safe area for general elements

    :type: typing.List[float]
    '''

    action_center: typing.List[float] = None
    ''' Safe area for general elements in a different aspect ratio

    :type: typing.List[float]
    '''

    title: typing.List[float] = None
    ''' Safe area for text and graphics

    :type: typing.List[float]
    '''

    title_center: typing.List[float] = None
    ''' Safe area for text and graphics in a different aspect ratio

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DopeSheet(bpy_struct):
    ''' Settings for filtering the channels shown in animation editors
    '''

    filter_collection: 'Collection' = None
    ''' Collection that included object should be a member of

    :type: 'Collection'
    '''

    filter_fcurve_name: str = None
    ''' F-Curve live filtering string

    :type: str
    '''

    filter_text: str = None
    ''' Live filtering string

    :type: str
    '''

    show_armatures: bool = None
    ''' Include visualization of armature related animation data

    :type: bool
    '''

    show_cache_files: bool = None
    ''' Include visualization of cache file related animation data

    :type: bool
    '''

    show_cameras: bool = None
    ''' Include visualization of camera related animation data

    :type: bool
    '''

    show_curves: bool = None
    ''' Include visualization of curve related animation data

    :type: bool
    '''

    show_datablock_filters: bool = None
    ''' Show options for whether channels related to certain types of data are included

    :type: bool
    '''

    show_expanded_summary: bool = None
    ''' Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    '''

    show_gpencil: bool = None
    ''' Include visualization of Grease Pencil related animation data and frames

    :type: bool
    '''

    show_hairs: bool = None
    ''' Include visualization of hair related animation data

    :type: bool
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that are not visible

    :type: bool
    '''

    show_lattices: bool = None
    ''' Include visualization of lattice related animation data

    :type: bool
    '''

    show_lights: bool = None
    ''' Include visualization of light related animation data

    :type: bool
    '''

    show_linestyles: bool = None
    ''' Include visualization of Line Style related Animation data

    :type: bool
    '''

    show_materials: bool = None
    ''' Include visualization of material related animation data

    :type: bool
    '''

    show_meshes: bool = None
    ''' Include visualization of mesh related animation data

    :type: bool
    '''

    show_metaballs: bool = None
    ''' Include visualization of metaball related animation data

    :type: bool
    '''

    show_missing_nla: bool = None
    ''' Include animation data-blocks with no NLA data (NLA editor only)

    :type: bool
    '''

    show_modifiers: bool = None
    ''' Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    '''

    show_movieclips: bool = None
    ''' Include visualization of movie clip related animation data

    :type: bool
    '''

    show_nodes: bool = None
    ''' Include visualization of node related animation data

    :type: bool
    '''

    show_only_errors: bool = None
    ''' Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    show_particles: bool = None
    ''' Include visualization of particle related animation data

    :type: bool
    '''

    show_pointclouds: bool = None
    ''' Include visualization of point cloud related animation data

    :type: bool
    '''

    show_scenes: bool = None
    ''' Include visualization of scene related animation data

    :type: bool
    '''

    show_shapekeys: bool = None
    ''' Include visualization of shape key related animation data

    :type: bool
    '''

    show_speakers: bool = None
    ''' Include visualization of speaker related animation data

    :type: bool
    '''

    show_summary: bool = None
    ''' Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    '''

    show_textures: bool = None
    ''' Include visualization of texture related animation data

    :type: bool
    '''

    show_transforms: bool = None
    ''' Include visualization of object-level animation data (mostly transforms)

    :type: bool
    '''

    show_volumes: bool = None
    ''' Include visualization of volume related animation data

    :type: bool
    '''

    show_worlds: bool = None
    ''' Include visualization of world related animation data

    :type: bool
    '''

    source: 'ID' = None
    ''' ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: 'ID'
    '''

    use_datablock_sort: bool = None
    ''' Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    '''

    use_filter_invert: bool = None
    ''' Invert filter search

    :type: bool
    '''

    use_multi_word_filter: bool = None
    ''' Perform fuzzy/multi-word matching. Warning: May be slow

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Driver(bpy_struct):
    ''' Driver for the value of a setting based on an external value
    '''

    expression: str = None
    ''' Expression to use for Scripted Expression

    :type: str
    '''

    is_simple_expression: bool = None
    ''' The scripted expression can be evaluated without using the full python interpreter

    :type: bool
    '''

    is_valid: bool = None
    ''' Driver could not be evaluated in past, so should be skipped

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Driver type

    :type: typing.Union[str, int]
    '''

    use_self: bool = None
    ''' Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    '''

    variables: typing.Union[typing.Dict[str, 'DriverVariable'], typing.
                            List['DriverVariable'], 'bpy_prop_collection',
                            'ChannelDriverVariables'] = None
    ''' Properties acting as inputs for this driver

    :type: typing.Union[typing.Dict[str, 'DriverVariable'], typing.List['DriverVariable'], 'bpy_prop_collection', 'ChannelDriverVariables']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DriverTarget(bpy_struct):
    ''' Source of input values for driver variables
    '''

    bone_target: str = None
    ''' Name of PoseBone to use as target

    :type: str
    '''

    data_path: str = None
    ''' RNA Path (from ID-block) to property used

    :type: str
    '''

    id: 'ID' = None
    ''' ID-block that the specific property used can be found from (id_type property must be set first)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' Mode for calculating rotation channel values * AUTO Auto Euler, Euler using the rotation order of the target. * XYZ XYZ Euler, Euler using the XYZ rotation order. * XZY XZY Euler, Euler using the XZY rotation order. * YXZ YXZ Euler, Euler using the YXZ rotation order. * YZX YZX Euler, Euler using the YZX rotation order. * ZXY ZXY Euler, Euler using the ZXY rotation order. * ZYX ZYX Euler, Euler using the ZYX rotation order. * QUATERNION Quaternion, Quaternion rotation. * SWING_TWIST_X Swing and X Twist, Decompose into a swing rotation to aim the X axis, followed by twist around it. * SWING_TWIST_Y Swing and Y Twist, Decompose into a swing rotation to aim the Y axis, followed by twist around it. * SWING_TWIST_Z Swing and Z Twist, Decompose into a swing rotation to aim the Z axis, followed by twist around it.

    :type: typing.Union[str, int]
    '''

    transform_space: typing.Union[str, int] = None
    ''' Space in which transforms are used * WORLD_SPACE World Space, Transforms include effects of parenting/restpose and constraints. * TRANSFORM_SPACE Transform Space, Transforms don't include parenting/restpose or constraints. * LOCAL_SPACE Local Space, Transforms include effects of constraints but not parenting/restpose.

    :type: typing.Union[str, int]
    '''

    transform_type: typing.Union[str, int] = None
    ''' Driver variable type

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DriverVariable(bpy_struct):
    ''' Variable from some source/target for driver relationship
    '''

    is_name_valid: bool = None
    ''' Is this a valid name for a driver variable

    :type: bool
    '''

    name: str = None
    ''' Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: str
    '''

    targets: typing.Union[typing.Dict[str, 'DriverTarget'], typing.
                          List['DriverTarget'], 'bpy_prop_collection'] = None
    ''' Sources of input data for evaluating this variable

    :type: typing.Union[typing.Dict[str, 'DriverTarget'], typing.List['DriverTarget'], 'bpy_prop_collection']
    '''

    type: typing.Union[str, int] = None
    ''' Driver variable type * SINGLE_PROP Single Property, Use the value from some RNA property (Default). * TRANSFORMS Transform Channel, Final transformation value of object or bone. * ROTATION_DIFF Rotational Difference, Use the angle between two bones. * LOC_DIFF Distance, Distance between two bones or objects.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintBrushSettings(bpy_struct):
    ''' Brush settings
    '''

    invert_proximity: bool = None
    ''' Proximity falloff is applied inside the volume

    :type: bool
    '''

    paint_alpha: float = None
    ''' Paint alpha

    :type: float
    '''

    paint_color: typing.List[float] = None
    ''' Color of the paint

    :type: typing.List[float]
    '''

    paint_distance: float = None
    ''' Maximum distance from brush to mesh surface to affect paint

    :type: float
    '''

    paint_ramp: 'ColorRamp' = None
    ''' Color ramp used to define proximity falloff

    :type: 'ColorRamp'
    '''

    paint_source: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    paint_wetness: float = None
    ''' Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' The particle system to paint with

    :type: 'ParticleSystem'
    '''

    proximity_falloff: typing.Union[str, int] = None
    ''' Proximity falloff type

    :type: typing.Union[str, int]
    '''

    ray_direction: typing.Union[str, int] = None
    ''' Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[str, int]
    '''

    smooth_radius: float = None
    ''' Smooth falloff added after solid radius

    :type: float
    '''

    smudge_strength: float = None
    ''' Smudge effect strength

    :type: float
    '''

    solid_radius: float = None
    ''' Radius that will be painted solid

    :type: float
    '''

    use_absolute_alpha: bool = None
    ''' Only increase alpha value if paint alpha is higher than existing

    :type: bool
    '''

    use_negative_volume: bool = None
    ''' Negate influence inside the volume

    :type: bool
    '''

    use_paint_erase: bool = None
    ''' Erase / remove paint instead of adding it

    :type: bool
    '''

    use_particle_radius: bool = None
    ''' Use radius from particle settings

    :type: bool
    '''

    use_proximity_project: bool = None
    ''' Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    '''

    use_proximity_ramp_alpha: bool = None
    ''' Only read color ramp alpha

    :type: bool
    '''

    use_smudge: bool = None
    ''' Make this brush to smudge existing paint as it moves

    :type: bool
    '''

    use_velocity_alpha: bool = None
    ''' Multiply brush influence by velocity color ramp alpha

    :type: bool
    '''

    use_velocity_color: bool = None
    ''' Replace brush color by velocity color ramp

    :type: bool
    '''

    use_velocity_depth: bool = None
    ''' Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    '''

    velocity_max: float = None
    ''' Velocity considered as maximum influence (Blender units per frame)

    :type: float
    '''

    velocity_ramp: 'ColorRamp' = None
    ''' Color ramp used to define brush velocity effect

    :type: 'ColorRamp'
    '''

    wave_clamp: float = None
    ''' Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    '''

    wave_factor: float = None
    ''' Multiplier for wave influence of this brush

    :type: float
    '''

    wave_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintCanvasSettings(bpy_struct):
    ''' Dynamic Paint canvas settings
    '''

    canvas_surfaces: typing.Union[
        typing.Dict[str, 'DynamicPaintSurface'], typing.
        List['DynamicPaintSurface'], 'bpy_prop_collection',
        'DynamicPaintSurfaces'] = None
    ''' Paint surface list

    :type: typing.Union[typing.Dict[str, 'DynamicPaintSurface'], typing.List['DynamicPaintSurface'], 'bpy_prop_collection', 'DynamicPaintSurfaces']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintSurface(bpy_struct):
    ''' A canvas surface layer
    '''

    brush_collection: 'Collection' = None
    ''' Only use brush objects from this collection

    :type: 'Collection'
    '''

    brush_influence_scale: float = None
    ''' Adjust influence brush objects have on this surface

    :type: float
    '''

    brush_radius_scale: float = None
    ''' Adjust radius of proximity brushes or particles for this surface

    :type: float
    '''

    color_dry_threshold: float = None
    ''' The wetness level when colors start to shift to the background

    :type: float
    '''

    color_spread_speed: float = None
    ''' How fast colors get mixed within wet paint

    :type: float
    '''

    depth_clamp: float = None
    ''' Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    '''

    displace_factor: float = None
    ''' Strength of displace when applied to the mesh

    :type: float
    '''

    displace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    dissolve_speed: int = None
    ''' Approximately in how many frames should dissolve happen

    :type: int
    '''

    drip_acceleration: float = None
    ''' How much surface acceleration affects dripping

    :type: float
    '''

    drip_velocity: float = None
    ''' How much surface velocity affects dripping

    :type: float
    '''

    dry_speed: int = None
    ''' Approximately in how many frames should drying happen

    :type: int
    '''

    effect_ui: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    frame_end: int = None
    ''' Simulation end frame

    :type: int
    '''

    frame_start: int = None
    ''' Simulation start frame

    :type: int
    '''

    frame_substeps: int = None
    ''' Do extra frames between scene frames to ensure smooth motion

    :type: int
    '''

    image_fileformat: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    image_output_path: str = None
    ''' Directory to save the textures

    :type: str
    '''

    image_resolution: int = None
    ''' Output image resolution

    :type: int
    '''

    init_color: typing.List[float] = None
    ''' Initial color of the surface

    :type: typing.List[float]
    '''

    init_color_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    init_layername: str = None
    ''' 

    :type: str
    '''

    init_texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    is_active: bool = None
    ''' Toggle whether surface is processed or ignored

    :type: bool
    '''

    is_cache_user: bool = None
    ''' 

    :type: bool
    '''

    name: str = None
    ''' Surface name

    :type: str
    '''

    output_name_a: str = None
    ''' Name used to save output from this surface

    :type: str
    '''

    output_name_b: str = None
    ''' Name used to save output from this surface

    :type: str
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    shrink_speed: float = None
    ''' How fast shrink effect moves on the canvas surface

    :type: float
    '''

    spread_speed: float = None
    ''' How fast spread effect moves on the canvas surface

    :type: float
    '''

    surface_format: typing.Union[str, int] = None
    ''' Surface Format

    :type: typing.Union[str, int]
    '''

    surface_type: typing.Union[str, int] = None
    ''' Surface Type

    :type: typing.Union[str, int]
    '''

    use_antialiasing: bool = None
    ''' Use 5x multisampling to smooth paint edges

    :type: bool
    '''

    use_dissolve: bool = None
    ''' Enable to make surface changes disappear over time

    :type: bool
    '''

    use_dissolve_log: bool = None
    ''' Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    '''

    use_drip: bool = None
    ''' Process drip effect (drip wet paint to gravity direction)

    :type: bool
    '''

    use_dry_log: bool = None
    ''' Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    '''

    use_drying: bool = None
    ''' Enable to make surface wetness dry over time

    :type: bool
    '''

    use_incremental_displace: bool = None
    ''' New displace is added cumulatively on top of existing

    :type: bool
    '''

    use_output_a: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_output_b: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_premultiply: bool = None
    ''' Multiply color by alpha (recommended for Blender input)

    :type: bool
    '''

    use_shrink: bool = None
    ''' Process shrink effect (shrink paint areas)

    :type: bool
    '''

    use_spread: bool = None
    ''' Process spread effect (spread wet paint around surface)

    :type: bool
    '''

    use_wave_open_border: bool = None
    ''' Pass waves through mesh edges

    :type: bool
    '''

    uv_layer: str = None
    ''' UV map name

    :type: str
    '''

    wave_damping: float = None
    ''' Wave damping factor

    :type: float
    '''

    wave_smoothness: float = None
    ''' Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    '''

    wave_speed: float = None
    ''' Wave propagation speed

    :type: float
    '''

    wave_spring: float = None
    ''' Spring force that pulls water level back to zero

    :type: float
    '''

    wave_timescale: float = None
    ''' Wave time scaling factor

    :type: float
    '''

    def output_exists(self, object: 'Object', index: int):
        ''' Checks if surface output layer of given name exists

        :param object: 
        :type object: 'Object'
        :param index: Index
        :type index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintSurfaces(bpy_struct):
    ''' Collection of Dynamic Paint Canvas surfaces
    '''

    active: 'DynamicPaintSurface' = None
    ''' Active Dynamic Paint surface being displayed

    :type: 'DynamicPaintSurface'
    '''

    active_index: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class EditBone(bpy_struct):
    ''' Edit mode bone in an armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'EditBone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'EditBone'
    '''

    bbone_custom_handle_start: 'EditBone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'EditBone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    ''' Selects how the end handle of the B-Bone is computed * AUTO Automatic, Use connected parent and children to compute the handle. * ABSOLUTE Absolute, Use the position of the specified bone to compute the handle. * RELATIVE Relative, Use the offset of the specified bone from rest pose to compute the handle. * TANGENT Tangent, Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    ''' Selects how the start handle of the B-Bone is computed * AUTO Automatic, Use connected parent and children to compute the handle. * ABSOLUTE Absolute, Use the position of the specified bone to compute the handle. * RELATIVE Relative, Use the offset of the specified bone from rest pose to compute the handle. * TANGENT Tangent, Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scaleinx: float = None
    ''' X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleiny: float = None
    ''' Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleoutx: float = None
    ''' X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleouty: float = None
    ''' Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: typing.List[float] = None
    ''' Location of head end of the bone

    :type: typing.List[float]
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when in Edit Mode

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    ''' Specifies how the bone inherits scaling from the parent bone * FULL Full, Inherit all effects of parent scaling. * FIX_SHEAR Fix Shear, Inherit scaling, but remove shearing of the child in the rest orientation. * ALIGNED Aligned, Rotate non-uniform parent scaling to align with the child, applying parent X scale to child X axis, and so forth. * AVERAGE Average, Inherit uniform scaling representing the overall change in the volume of the parent. * NONE None, Completely ignore parent scaling. * NONE_LEGACY None (Legacy), Ignore parent scaling without compensating for parent shear. Replicates the effect of disabling the original Inherit Scale checkbox.

    :type: typing.Union[str, int]
    '''

    layers: typing.List[bool] = None
    ''' Layers bone exists in

    :type: typing.List[bool]
    '''

    length: float = None
    ''' Length of the bone. Changing moves the tail end

    :type: float
    '''

    lock: bool = None
    ''' Bone is not able to be transformed when in Edit Mode

    :type: bool
    '''

    matrix: typing.List[float] = None
    ''' Matrix combining location and rotation of the bone (head position, direction and roll), in armature space (does not include/support bone's length/size)

    :type: typing.List[float]
    '''

    name: str = None
    ''' 

    :type: str
    '''

    parent: 'EditBone' = None
    ''' Parent edit bone (in same Armature)

    :type: 'EditBone'
    '''

    roll: float = None
    ''' Bone rotation around head-tail axis

    :type: float
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: typing.List[float] = None
    ''' Location of tail end of the bone

    :type: typing.List[float]
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: bool = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_inherit_scale: bool = None
    ''' DEPRECATED: Bone inherits scaling from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' A list of all the bones children. .. note:: Takes O(len(bones)) time. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes O(len(bones)**2) time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def align_roll(self, vector: typing.List[float]):
        ''' Align the bone to a localspace roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.List[float]
        '''
        pass

    def align_orientation(self, other):
        ''' Align this bone to another by moving its tail and settings its roll the length of the other bone is not used.

        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def transform(self,
                  matrix: 'mathutils.Matrix',
                  scale: bool = True,
                  roll: bool = True):
        ''' Transform the the bones head, tail, roll and envelope (when the matrix has a scale component).

        :param matrix: 3x3 or 4x4 transformation matrix.
        :type matrix: 'mathutils.Matrix'
        :param scale: Scale the bone envelope by the matrix.
        :type scale: bool
        :param roll: Correct the roll to point in the same relative direction to the head and tail.
        :type roll: bool
        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class EffectorWeights(bpy_struct):
    ''' Effector weights for physics simulation
    '''

    all: float = None
    ''' All effector's weight

    :type: float
    '''

    apply_to_hair_growing: bool = None
    ''' Use force fields when growing hair

    :type: bool
    '''

    boid: float = None
    ''' Boid effector weight

    :type: float
    '''

    charge: float = None
    ''' Charge effector weight

    :type: float
    '''

    collection: 'Collection' = None
    ''' Limit effectors to this collection

    :type: 'Collection'
    '''

    curve_guide: float = None
    ''' Curve guide effector weight

    :type: float
    '''

    drag: float = None
    ''' Drag effector weight

    :type: float
    '''

    force: float = None
    ''' Force effector weight

    :type: float
    '''

    gravity: float = None
    ''' Global gravity weight

    :type: float
    '''

    harmonic: float = None
    ''' Harmonic effector weight

    :type: float
    '''

    lennardjones: float = None
    ''' Lennard-Jones effector weight

    :type: float
    '''

    magnetic: float = None
    ''' Magnetic effector weight

    :type: float
    '''

    smokeflow: float = None
    ''' Fluid Flow effector weight

    :type: float
    '''

    texture: float = None
    ''' Texture effector weight

    :type: float
    '''

    turbulence: float = None
    ''' Turbulence effector weight

    :type: float
    '''

    vortex: float = None
    ''' Vortex effector weight

    :type: float
    '''

    wind: float = None
    ''' Wind effector weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class EnumPropertyItem(bpy_struct):
    ''' Definition of a choice in an RNA enum property
    '''

    description: str = None
    ''' Description of the item's purpose

    :type: str
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: str = None
    ''' Unique name used in the code and scripting

    :type: str
    '''

    name: str = None
    ''' Human readable name

    :type: str
    '''

    value: int = None
    ''' Value of the item

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Event(bpy_struct):
    ''' Window Manager Event
    '''

    alt: bool = None
    ''' True when the Alt/Option key is held

    :type: bool
    '''

    ascii: str = None
    ''' Single ASCII character for this event

    :type: str
    '''

    ctrl: bool = None
    ''' True when the Ctrl key is held

    :type: bool
    '''

    is_mouse_absolute: bool = None
    ''' The last motion event was an absolute input

    :type: bool
    '''

    is_repeat: bool = None
    ''' The event is generated by holding a key down

    :type: bool
    '''

    is_tablet: bool = None
    ''' The event has tablet data

    :type: bool
    '''

    mouse_prev_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_prev_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    mouse_region_x: int = None
    ''' The region relative horizontal location of the mouse

    :type: int
    '''

    mouse_region_y: int = None
    ''' The region relative vertical location of the mouse

    :type: int
    '''

    mouse_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    oskey: bool = None
    ''' True when the Cmd key is held

    :type: bool
    '''

    pressure: float = None
    ''' The pressure of the tablet or 1.0 if no tablet present

    :type: float
    '''

    shift: bool = None
    ''' True when the Shift key is held

    :type: bool
    '''

    tilt: typing.List[float] = None
    ''' The pressure of the tablet or zeroes if no tablet present

    :type: typing.List[float]
    '''

    type: typing.Union[str, int] = None
    ''' * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.

    :type: typing.Union[str, int]
    '''

    unicode: str = None
    ''' Single unicode character for this event

    :type: str
    '''

    value: typing.Union[str, int] = None
    ''' The type of event, only applies to some

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FCurve(bpy_struct):
    ''' F-Curve defining values of a period of time
    '''

    array_index: int = None
    ''' Index to the specific property affected by F-Curve if applicable

    :type: int
    '''

    auto_smoothing: typing.Union[str, int] = None
    ''' Algorithm used to compute automatic handles * NONE None, Automatic handles only take immediately adjacent keys into account. * CONT_ACCEL Continuous Acceleration, Automatic handles are adjusted to avoid jumps in acceleration, resulting in smoother curves. However, key changes may affect interpolation over a larger stretch of the curve.

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    ''' Color of the F-Curve in the Graph Editor

    :type: typing.List[float]
    '''

    color_mode: typing.Union[str, int] = None
    ''' Method used to determine color of F-Curve in Graph Editor * AUTO_RAINBOW Auto Rainbow, Cycle through the rainbow, trying to give each curve a unique color. * AUTO_RGB Auto XYZ to RGB, Use axis colors for transform and color properties, and auto-rainbow for the rest. * AUTO_YRGB Auto WXYZ to YRGB, Use axis colors for XYZ parts of transform, and yellow for the 'W' channel. * CUSTOM User Defined, Use custom hand-picked color for F-Curve.

    :type: typing.Union[str, int]
    '''

    data_path: str = None
    ''' RNA Path to property affected by F-Curve

    :type: str
    '''

    driver: 'Driver' = None
    ''' Channel Driver (only set for Driver F-Curves)

    :type: 'Driver'
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Method used for evaluating value of F-Curve outside first and last keyframes * CONSTANT Constant, Hold values of endpoint keyframes. * LINEAR Linear, Use slope of curve leading in/out of endpoint keyframes.

    :type: typing.Union[str, int]
    '''

    group: 'ActionGroup' = None
    ''' Action Group that this F-Curve belongs to

    :type: 'ActionGroup'
    '''

    hide: bool = None
    ''' F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    '''

    is_empty: bool = None
    ''' True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted

    :type: bool
    '''

    is_valid: bool = None
    ''' False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    '''

    keyframe_points: typing.Union[typing.Dict[str, 'Keyframe'], typing.
                                  List['Keyframe'], 'bpy_prop_collection',
                                  'FCurveKeyframePoints'] = None
    ''' User-editable keyframes

    :type: typing.Union[typing.Dict[str, 'Keyframe'], typing.List['Keyframe'], 'bpy_prop_collection', 'FCurveKeyframePoints']
    '''

    lock: bool = None
    ''' F-Curve's settings cannot be edited

    :type: bool
    '''

    modifiers: typing.Union[typing.Dict[str, 'FModifier'], typing.
                            List['FModifier'], 'bpy_prop_collection',
                            'FCurveModifiers'] = None
    ''' Modifiers affecting the shape of the F-Curve

    :type: typing.Union[typing.Dict[str, 'FModifier'], typing.List['FModifier'], 'bpy_prop_collection', 'FCurveModifiers']
    '''

    mute: bool = None
    ''' Disable F-Curve Modifier evaluation

    :type: bool
    '''

    sampled_points: typing.Union[typing.Dict[str, 'FCurveSample'], typing.
                                 List['FCurveSample'],
                                 'bpy_prop_collection'] = None
    ''' Sampled animation data

    :type: typing.Union[typing.Dict[str, 'FCurveSample'], typing.List['FCurveSample'], 'bpy_prop_collection']
    '''

    select: bool = None
    ''' F-Curve is selected for editing

    :type: bool
    '''

    def evaluate(self, frame: float) -> float:
        ''' Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: float
        :rtype: float
        :return: Value, Value of F-Curve specific frame
        '''
        pass

    def update(self):
        ''' Ensure keyframes are sorted in chronological order and handles are set correctly

        '''
        pass

    def range(self) -> typing.List[float]:
        ''' Get the time extents for F-Curve

        :rtype: typing.List[float]
        :return: Range, Min/Max values
        '''
        pass

    def update_autoflags(self, data: 'AnyType'):
        ''' Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: 'AnyType'
        '''
        pass

    def convert_to_samples(self, start: int, end: int):
        ''' Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: int
        :param end: End Frame
        :type end: int
        '''
        pass

    def convert_to_keyframes(self, start: int, end: int):
        ''' Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: int
        :param end: End Frame
        :type end: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FCurveKeyframePoints(bpy_struct):
    ''' Collection of keyframe points
    '''

    def insert(
            self,
            frame: float,
            value: float,
            options: typing.Union[typing.Set[str], typing.Set[int]] = {},
            keyframe_type: typing.Union[str, int] = 'KEYFRAME') -> 'Keyframe':
        ''' Add a keyframe point to a F-Curve

        :param frame: X Value of this keyframe point
        :type frame: float
        :param value: Y Value of this keyframe point
        :type value: float
        :param options: Keyframe options * REPLACE Replace, Don't add any new keyframes, but just replace existing ones. * NEEDED Needed, Only adds keyframes that are needed. * FAST Fast, Fast keyframe insertion to avoid recalculating the curve each time.
        :type options: typing.Union[typing.Set[str], typing.Set[int]]
        :param keyframe_type: Type of keyframe to insert * KEYFRAME Keyframe, Normal keyframe, e.g. for key poses. * BREAKDOWN Breakdown, A breakdown pose, e.g. for transitions between key poses. * MOVING_HOLD Moving Hold, A keyframe that is part of a moving hold. * EXTREME Extreme, An "extreme" pose, or some other purpose as needed. * JITTER Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.
        :type keyframe_type: typing.Union[str, int]
        :rtype: 'Keyframe'
        :return: Newly created keyframe
        '''
        pass

    def add(self, count: int):
        ''' Add a keyframe point to a F-Curve

        :param count: Number, Number of points to add to the spline
        :type count: int
        '''
        pass

    def remove(self, keyframe: 'Keyframe', fast: bool = False):
        ''' Remove keyframe from an F-Curve

        :param keyframe: Keyframe to remove
        :type keyframe: 'Keyframe'
        :param fast: Fast, Fast keyframe removal to avoid recalculating the curve each time
        :type fast: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FCurveModifiers(bpy_struct):
    ''' Collection of F-Curve Modifiers
    '''

    active: 'FModifier' = None
    ''' Active F-Curve Modifier

    :type: 'FModifier'
    '''

    def new(self, type: typing.Union[str, int]) -> 'FModifier':
        ''' Add a constraint to this object

        :param type: Constraint type to add * NULL Invalid. * GENERATOR Generator, Generate a curve using a factorized or expanded polynomial. * FNGENERATOR Built-In Function, Generate a curve using standard math functions such as sin and cos. * ENVELOPE Envelope, Reshape F-Curve values, e.g. change amplitude of movements. * CYCLES Cycles, Cyclic extend/repeat keyframe sequence. * NOISE Noise, Add pseudo-random noise on top of F-Curves. * LIMITS Limits, Restrict maximum and minimum values of F-Curve. * STEPPED Stepped Interpolation, Snap values to nearest grid step, e.g. for a stop-motion look.
        :type type: typing.Union[str, int]
        :rtype: 'FModifier'
        :return: New fmodifier
        '''
        pass

    def remove(self, modifier: 'FModifier'):
        ''' Remove a modifier from this F-Curve

        :param modifier: Removed modifier
        :type modifier: 'FModifier'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FCurveSample(bpy_struct):
    ''' Sample point for F-Curve
    '''

    co: typing.List[float] = None
    ''' Point coordinates

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FFmpegSettings(bpy_struct):
    ''' FFmpeg related settings for the scene
    '''

    audio_bitrate: int = None
    ''' Audio bitrate (kb/s)

    :type: int
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * MONO Mono, Set audio channels to mono. * STEREO Stereo, Set audio channels to stereo. * SURROUND4 4 Channels, Set audio channels to 4 channels. * SURROUND51 5.1 Surround, Set audio channels to 5.1 surround sound. * SURROUND71 7.1 Surround, Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_codec: typing.Union[str, int] = None
    ''' FFmpeg audio codec to use * NONE No Audio, Disables audio output, for video-only renders. * AAC AAC. * AC3 AC3. * FLAC FLAC. * MP2 MP2. * MP3 MP3. * OPUS Opus. * PCM PCM. * VORBIS Vorbis.

    :type: typing.Union[str, int]
    '''

    audio_mixrate: int = None
    ''' Audio samplerate(samples/s)

    :type: int
    '''

    audio_volume: float = None
    ''' Audio volume

    :type: float
    '''

    buffersize: int = None
    ''' Rate control: buffer size (kb)

    :type: int
    '''

    codec: typing.Union[str, int] = None
    ''' FFmpeg codec to use for video output * NONE No Video, Disables video output, for audio-only renders. * DNXHD DNxHD. * DV DV. * FFV1 FFmpeg video codec #1. * FLASH Flash Video. * H264 H.264. * HUFFYUV HuffYUV. * MPEG1 MPEG-1. * MPEG2 MPEG-2. * MPEG4 MPEG-4 (divx). * PNG PNG. * QTRLE QT rle / QT Animation. * THEORA Theora. * WEBM WEBM / VP9.

    :type: typing.Union[str, int]
    '''

    constant_rate_factor: typing.Union[str, int] = None
    ''' Constant Rate Factor (CRF); tradeoff between video quality and file size * NONE Constant Bitrate, Configure constant bit rate, rather than constant output quality. * LOSSLESS Lossless. * PERC_LOSSLESS Perceptually Lossless. * HIGH High Quality. * MEDIUM Medium Quality. * LOW Low Quality. * VERYLOW Very Low Quality. * LOWEST Lowest Quality.

    :type: typing.Union[str, int]
    '''

    ffmpeg_preset: typing.Union[str, int] = None
    ''' Tradeoff between encoding speed and compression ratio * BEST Slowest, Recommended if you have lots of time and want the best compression efficiency. * GOOD Good, The default and recommended for most applications. * REALTIME Realtime, Recommended for fast encoding.

    :type: typing.Union[str, int]
    '''

    format: typing.Union[str, int] = None
    ''' Output file container

    :type: typing.Union[str, int]
    '''

    gopsize: int = None
    ''' Distance between key frames, also known as GOP size; influences file size and seekability

    :type: int
    '''

    max_b_frames: int = None
    ''' Maximum number of B-frames between non-B-frames; influences file size and seekability

    :type: int
    '''

    maxrate: int = None
    ''' Rate control: max rate (kbit/s)

    :type: int
    '''

    minrate: int = None
    ''' Rate control: min rate (kbit/s)

    :type: int
    '''

    muxrate: int = None
    ''' Mux rate (bits/second)

    :type: int
    '''

    packetsize: int = None
    ''' Mux packet size (byte)

    :type: int
    '''

    use_autosplit: bool = None
    ''' Autosplit output at 2GB boundary

    :type: bool
    '''

    use_lossless_output: bool = None
    ''' Use lossless output for video streams

    :type: bool
    '''

    use_max_b_frames: bool = None
    ''' Set a maximum number of B-frames

    :type: bool
    '''

    video_bitrate: int = None
    ''' Video bitrate (kbit/s)

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FModifier(bpy_struct):
    ''' Modifier for values of F-Curve
    '''

    active: bool = None
    ''' F-Curve modifier will show settings in the editor

    :type: bool
    '''

    blend_in: float = None
    ''' Number of frames from start frame for influence to take effect

    :type: float
    '''

    blend_out: float = None
    ''' Number of frames from end frame for influence to fade out

    :type: float
    '''

    frame_end: float = None
    ''' Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    '''

    frame_start: float = None
    ''' Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    '''

    influence: float = None
    ''' Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    '''

    is_valid: bool = None
    ''' F-Curve Modifier has invalid settings and will not be evaluated

    :type: bool
    '''

    mute: bool = None
    ''' Enable F-Curve modifier evaluation

    :type: bool
    '''

    show_expanded: bool = None
    ''' F-Curve Modifier's panel is expanded in UI

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' F-Curve Modifier Type * NULL Invalid. * GENERATOR Generator, Generate a curve using a factorized or expanded polynomial. * FNGENERATOR Built-In Function, Generate a curve using standard math functions such as sin and cos. * ENVELOPE Envelope, Reshape F-Curve values, e.g. change amplitude of movements. * CYCLES Cycles, Cyclic extend/repeat keyframe sequence. * NOISE Noise, Add pseudo-random noise on top of F-Curves. * LIMITS Limits, Restrict maximum and minimum values of F-Curve. * STEPPED Stepped Interpolation, Snap values to nearest grid step, e.g. for a stop-motion look.

    :type: typing.Union[str, int]
    '''

    use_influence: bool = None
    ''' F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    '''

    use_restricted_range: bool = None
    ''' F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FModifierEnvelopeControlPoint(bpy_struct):
    ''' Control point for envelope F-Modifier
    '''

    frame: float = None
    ''' Frame this control-point occurs on

    :type: float
    '''

    max: float = None
    ''' Upper bound of envelope at this control-point

    :type: float
    '''

    min: float = None
    ''' Lower bound of envelope at this control-point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FModifierEnvelopeControlPoints(bpy_struct):
    ''' Control points defining the shape of the envelope
    '''

    def add(self, frame: float) -> 'FModifierEnvelopeControlPoint':
        ''' Add a control point to a FModifierEnvelope

        :param frame: Frame to add this control-point
        :type frame: float
        :rtype: 'FModifierEnvelopeControlPoint'
        :return: Newly created control-point
        '''
        pass

    def remove(self, point: 'FModifierEnvelopeControlPoint'):
        ''' Remove a control-point from an FModifierEnvelope

        :param point: Control-point to remove
        :type point: 'FModifierEnvelopeControlPoint'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FaceMap(bpy_struct):
    ''' Group of faces, each face can only be part of one map
    '''

    index: int = None
    ''' Index number of the face map

    :type: int
    '''

    name: str = None
    ''' Face map name

    :type: str
    '''

    select: bool = None
    ''' Face map selection state (for tools to use)

    :type: bool
    '''

    def add(self, index: typing.List[int]):
        ''' Add faces to the face-map

        :param index: List of indices
        :type index: typing.List[int]
        '''
        pass

    def remove(self, index: typing.List[int]):
        ''' Remove faces from the face-map

        :param index: List of indices
        :type index: typing.List[int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FaceMaps(bpy_struct):
    ''' Collection of face maps
    '''

    active: 'FaceMap' = None
    ''' Face maps of the object

    :type: 'FaceMap'
    '''

    active_index: int = None
    ''' Active index in face map array

    :type: int
    '''

    def new(self, name: str = "Map") -> 'FaceMap':
        ''' Add face map to object

        :param name: face map name
        :type name: str
        :rtype: 'FaceMap'
        :return: New face map
        '''
        pass

    def remove(self, group: 'FaceMap'):
        ''' Delete vertex group from object

        :param group: Face map to remove
        :type group: 'FaceMap'
        '''
        pass

    def clear(self):
        ''' Delete all vertex groups from object

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FieldSettings(bpy_struct):
    ''' Field settings for an object in physics simulation
    '''

    apply_to_location: bool = None
    ''' Affect particle's location

    :type: bool
    '''

    apply_to_rotation: bool = None
    ''' Affect particle's dynamic rotation

    :type: bool
    '''

    distance_max: float = None
    ''' Maximum distance for the field to work

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance for the field's fall-off

    :type: float
    '''

    falloff_power: float = None
    ''' How quickly strength falls off with distance from the force field

    :type: float
    '''

    falloff_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    flow: float = None
    ''' Convert effector force into air flow velocity

    :type: float
    '''

    guide_clump_amount: float = None
    ''' Amount of clumping

    :type: float
    '''

    guide_clump_shape: float = None
    ''' Shape of clumping

    :type: float
    '''

    guide_free: float = None
    ''' Guide-free time from particle life's end

    :type: float
    '''

    guide_kink_amplitude: float = None
    ''' The amplitude of the offset

    :type: float
    '''

    guide_kink_axis: typing.Union[str, int] = None
    ''' Which axis to use for offset

    :type: typing.Union[str, int]
    '''

    guide_kink_frequency: float = None
    ''' The frequency of the offset (1/total length)

    :type: float
    '''

    guide_kink_shape: float = None
    ''' Adjust the offset to the beginning/end

    :type: float
    '''

    guide_kink_type: typing.Union[str, int] = None
    ''' Type of periodic offset on the curve

    :type: typing.Union[str, int]
    '''

    guide_minimum: float = None
    ''' The distance from which particles are affected fully

    :type: float
    '''

    harmonic_damping: float = None
    ''' Damping of the harmonic force

    :type: float
    '''

    inflow: float = None
    ''' Inwards component of the vortex force

    :type: float
    '''

    linear_drag: float = None
    ''' Drag component proportional to velocity

    :type: float
    '''

    noise: float = None
    ''' Amount of noise for the force strength

    :type: float
    '''

    quadratic_drag: float = None
    ''' Drag component proportional to the square of velocity

    :type: float
    '''

    radial_falloff: float = None
    ''' Radial falloff power (real gravitational falloff = 2)

    :type: float
    '''

    radial_max: float = None
    ''' Maximum radial distance for the field to work

    :type: float
    '''

    radial_min: float = None
    ''' Minimum radial distance for the field's fall-off

    :type: float
    '''

    rest_length: float = None
    ''' Rest length of the harmonic force

    :type: float
    '''

    seed: int = None
    ''' Seed of the noise

    :type: int
    '''

    shape: typing.Union[str, int] = None
    ''' Which direction is used to calculate the effector force * POINT Point, Field originates from the object center. * LINE Line, Field originates from the local Z axis of the object. * PLANE Plane, Field originates from the local XY plane of the object. * SURFACE Surface, Field originates from the surface of the object. * POINTS Every Point, Field originates from all of the vertices of the object.

    :type: typing.Union[str, int]
    '''

    size: float = None
    ''' Size of the turbulence

    :type: float
    '''

    source_object: 'Object' = None
    ''' Select domain object of the smoke simulation

    :type: 'Object'
    '''

    strength: float = None
    ''' Strength of force field

    :type: float
    '''

    texture: 'Texture' = None
    ''' Texture to use as force

    :type: 'Texture'
    '''

    texture_mode: typing.Union[str, int] = None
    ''' How the texture effect is calculated (RGB and Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[str, int]
    '''

    texture_nabla: float = None
    ''' Defines size of derivative offset used for calculating gradient and curl

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of field * NONE None. * FORCE Force, Radial field toward the center of object. * WIND Wind, Constant force along the force object's local Z axis. * VORTEX Vortex, Spiraling force that twists the force object's local Z axis. * MAGNET Magnetic, Forcefield depends on the speed of the particles. * HARMONIC Harmonic, The source of this force field is the zero point of a harmonic oscillator. * CHARGE Charge, Spherical forcefield based on the charge of particles, only influences other charge force fields. * LENNARDJ Lennard-Jones, Forcefield based on the Lennard-Jones potential. * TEXTURE Texture, Force field based on a texture. * GUIDE Curve Guide, Create a force along a curve object. * BOID Boid, Create a force that acts as a boid's predators or target. * TURBULENCE Turbulence, Create turbulence with a noise field. * DRAG Drag, Create a force that dampens motion. * FLUID_FLOW Fluid Flow, Create a force based on fluid simulation velocities.

    :type: typing.Union[str, int]
    '''

    use_2d_force: bool = None
    ''' Apply force only in 2D

    :type: bool
    '''

    use_absorption: bool = None
    ''' Force gets absorbed by collision objects

    :type: bool
    '''

    use_global_coords: bool = None
    ''' Use effector/global coordinates for turbulence

    :type: bool
    '''

    use_gravity_falloff: bool = None
    ''' Multiply force by 1/distance²

    :type: bool
    '''

    use_guide_path_add: bool = None
    ''' Based on distance/falloff it adds a portion of the entire path

    :type: bool
    '''

    use_guide_path_weight: bool = None
    ''' Use curve weights to influence the particle influence along the curve

    :type: bool
    '''

    use_max_distance: bool = None
    ''' Use a maximum distance for the field to work

    :type: bool
    '''

    use_min_distance: bool = None
    ''' Use a minimum distance for the field's fall-off

    :type: bool
    '''

    use_multiple_springs: bool = None
    ''' Every point is effected by multiple springs

    :type: bool
    '''

    use_object_coords: bool = None
    ''' Use object/global coordinates for texture

    :type: bool
    '''

    use_radial_max: bool = None
    ''' Use a maximum radial distance for the field to work

    :type: bool
    '''

    use_radial_min: bool = None
    ''' Use a minimum radial distance for the field's fall-off

    :type: bool
    '''

    use_root_coords: bool = None
    ''' Texture coordinates from root particle locations

    :type: bool
    '''

    use_smoke_density: bool = None
    ''' Adjust force strength based on smoke density

    :type: bool
    '''

    wind_factor: float = None
    ''' How much the force is reduced when acting parallel to a surface, e.g. cloth

    :type: float
    '''

    z_direction: typing.Union[str, int] = None
    ''' Effect in full or only positive/negative Z direction

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FileBrowserFSMenuEntry(bpy_struct):
    ''' File Select Parameters
    '''

    icon: int = None
    ''' 

    :type: int
    '''

    is_valid: bool = None
    ''' Whether this path is currently reachable

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    path: str = None
    ''' 

    :type: str
    '''

    use_save: bool = None
    ''' Whether this path is saved in bookmarks, or generated from OS

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FileSelectEntry(bpy_struct):
    ''' A file viewable in the File Browser
    '''

    asset_data: 'AssetMetaData' = None
    ''' Asset data, valid if the file represents an asset

    :type: 'AssetMetaData'
    '''

    name: str = None
    ''' 

    :type: str
    '''

    preview_icon_id: int = None
    ''' Unique integer identifying the preview of this file as an icon (zero means invalid)

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FileSelectIDFilter(bpy_struct):
    ''' Which ID types to show/hide, when browsing a library
    '''

    category_animation: bool = None
    ''' Show animation data

    :type: bool
    '''

    category_environment: bool = None
    ''' Show worlds, lights, cameras and speakers

    :type: bool
    '''

    category_geometry: bool = None
    ''' Show meshes, curves, lattice, armatures and metaballs data

    :type: bool
    '''

    category_image: bool = None
    ''' Show images, movie clips, sounds and masks

    :type: bool
    '''

    category_misc: bool = None
    ''' Show other data types

    :type: bool
    '''

    category_object: bool = None
    ''' Show objects and collections

    :type: bool
    '''

    category_scene: bool = None
    ''' Show scenes

    :type: bool
    '''

    category_shading: bool = None
    ''' Show materials, nodetrees, textures and Freestyle's linestyles

    :type: bool
    '''

    filter_action: bool = None
    ''' Show Action data-blocks

    :type: bool
    '''

    filter_armature: bool = None
    ''' Show Armature data-blocks

    :type: bool
    '''

    filter_brush: bool = None
    ''' Show Brushes data-blocks

    :type: bool
    '''

    filter_cachefile: bool = None
    ''' Show Cache File data-blocks

    :type: bool
    '''

    filter_camera: bool = None
    ''' Show Camera data-blocks

    :type: bool
    '''

    filter_curve: bool = None
    ''' Show Curve data-blocks

    :type: bool
    '''

    filter_font: bool = None
    ''' Show Font data-blocks

    :type: bool
    '''

    filter_grease_pencil: bool = None
    ''' Show Grease pencil data-blocks

    :type: bool
    '''

    filter_group: bool = None
    ''' Show Collection data-blocks

    :type: bool
    '''

    filter_hair: bool = None
    ''' Show/hide Hair data-blocks

    :type: bool
    '''

    filter_image: bool = None
    ''' Show Image data-blocks

    :type: bool
    '''

    filter_lattice: bool = None
    ''' Show Lattice data-blocks

    :type: bool
    '''

    filter_light: bool = None
    ''' Show Light data-blocks

    :type: bool
    '''

    filter_light_probe: bool = None
    ''' Show Light Probe data-blocks

    :type: bool
    '''

    filter_linestyle: bool = None
    ''' Show Freestyle's Line Style data-blocks

    :type: bool
    '''

    filter_mask: bool = None
    ''' Show Mask data-blocks

    :type: bool
    '''

    filter_material: bool = None
    ''' Show Material data-blocks

    :type: bool
    '''

    filter_mesh: bool = None
    ''' Show Mesh data-blocks

    :type: bool
    '''

    filter_metaball: bool = None
    ''' Show Metaball data-blocks

    :type: bool
    '''

    filter_movie_clip: bool = None
    ''' Show Movie Clip data-blocks

    :type: bool
    '''

    filter_node_tree: bool = None
    ''' Show Node Tree data-blocks

    :type: bool
    '''

    filter_object: bool = None
    ''' Show Object data-blocks

    :type: bool
    '''

    filter_paint_curve: bool = None
    ''' Show Paint Curve data-blocks

    :type: bool
    '''

    filter_palette: bool = None
    ''' Show Palette data-blocks

    :type: bool
    '''

    filter_particle_settings: bool = None
    ''' Show Particle Settings data-blocks

    :type: bool
    '''

    filter_pointcloud: bool = None
    ''' Show/hide Point Cloud data-blocks

    :type: bool
    '''

    filter_scene: bool = None
    ''' Show Scene data-blocks

    :type: bool
    '''

    filter_simulation: bool = None
    ''' Show Simulation data-blocks

    :type: bool
    '''

    filter_sound: bool = None
    ''' Show Sound data-blocks

    :type: bool
    '''

    filter_speaker: bool = None
    ''' Show Speaker data-blocks

    :type: bool
    '''

    filter_text: bool = None
    ''' Show Text data-blocks

    :type: bool
    '''

    filter_texture: bool = None
    ''' Show Texture data-blocks

    :type: bool
    '''

    filter_volume: bool = None
    ''' Show/hide Volume data-blocks

    :type: bool
    '''

    filter_work_space: bool = None
    ''' Show workspace data-blocks

    :type: bool
    '''

    filter_world: bool = None
    ''' Show World data-blocks

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FileSelectParams(bpy_struct):
    ''' File Select Parameters
    '''

    directory: str = None
    ''' Directory displayed in the file browser

    :type: str
    '''

    display_size: typing.Union[str, int] = None
    ''' Change the size of the display (width of columns or thumbnails size)

    :type: typing.Union[str, int]
    '''

    display_type: typing.Union[str, int] = None
    ''' Display mode for the file list * LIST_VERTICAL Vertical List, Display files as a vertical list. * LIST_HORIZONTAL Horizontal List, Display files as a horizontal list. * THUMBNAIL Thumbnails, Display files as thumbnails.

    :type: typing.Union[str, int]
    '''

    filename: str = None
    ''' Active file in the file browser

    :type: str
    '''

    filter_glob: str = None
    ''' UNIX shell-like filename patterns matching, supports wildcards ('*') and list of patterns separated by ';'

    :type: str
    '''

    filter_id: 'FileSelectIDFilter' = None
    ''' Which ID types to show/hide, when browsing a library

    :type: 'FileSelectIDFilter'
    '''

    filter_search: str = None
    ''' Filter by name, supports '*' wildcard

    :type: str
    '''

    recursion_level: typing.Union[str, int] = None
    ''' Numbers of dirtree levels to show simultaneously * NONE None, Only list current directory's content, with no recursion. * BLEND Blend File, List .blend files' content. * ALL_1 One Level, List all sub-directories' content, one level of recursion. * ALL_2 Two Levels, List all sub-directories' content, two levels of recursion. * ALL_3 Three Levels, List all sub-directories' content, three levels of recursion.

    :type: typing.Union[str, int]
    '''

    show_details_datetime: bool = None
    ''' Show a column listing the date and time of modification for each file

    :type: bool
    '''

    show_details_size: bool = None
    ''' Show a column listing the size of each file

    :type: bool
    '''

    show_hidden: bool = None
    ''' Show hidden dot files

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' * FILE_SORT_ALPHA Name, Sort the file list alphabetically. * FILE_SORT_EXTENSION Extension, Sort the file list by extension/type. * FILE_SORT_TIME Modified Date, Sort files by modification time. * FILE_SORT_SIZE Size, Sort files by size.

    :type: typing.Union[str, int]
    '''

    title: str = None
    ''' Title for the file browser

    :type: str
    '''

    use_filter: bool = None
    ''' Enable filtering of files

    :type: bool
    '''

    use_filter_asset_only: bool = None
    ''' Hide .blend files items that are not data-blocks with asset metadata

    :type: bool
    '''

    use_filter_backup: bool = None
    ''' Show .blend1, .blend2, etc. files

    :type: bool
    '''

    use_filter_blender: bool = None
    ''' Show .blend files

    :type: bool
    '''

    use_filter_blendid: bool = None
    ''' Show .blend files items (objects, materials, etc.)

    :type: bool
    '''

    use_filter_folder: bool = None
    ''' Show folders

    :type: bool
    '''

    use_filter_font: bool = None
    ''' Show font files

    :type: bool
    '''

    use_filter_image: bool = None
    ''' Show image files

    :type: bool
    '''

    use_filter_movie: bool = None
    ''' Show movie files

    :type: bool
    '''

    use_filter_script: bool = None
    ''' Show script files

    :type: bool
    '''

    use_filter_sound: bool = None
    ''' Show sound files

    :type: bool
    '''

    use_filter_text: bool = None
    ''' Show text files

    :type: bool
    '''

    use_filter_volume: bool = None
    ''' Show 3D volume files

    :type: bool
    '''

    use_library_browsing: bool = None
    ''' Whether we may browse blender files' content or not

    :type: bool
    '''

    use_sort_invert: bool = None
    ''' Sort items descending, from highest value to lowest

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Float2AttributeValue(bpy_struct):
    ''' 2D Vector value in geometry attribute
    '''

    vector: typing.List[float] = None
    ''' 2D vector

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FloatAttributeValue(bpy_struct):
    ''' Floating-point value in geometry attribute
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FloatColorAttributeValue(bpy_struct):
    ''' Color value in geometry attribute
    '''

    color: typing.List[float] = None
    ''' RGBA color in scene linear color space

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FloatVectorAttributeValue(bpy_struct):
    ''' Vector value in geometry attribute
    '''

    vector: typing.List[float] = None
    ''' 3D vector

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FluidDomainSettings(bpy_struct):
    ''' Fluid domain settings
    '''

    adapt_margin: int = None
    ''' Margin added around fluid to minimize boundary interference

    :type: int
    '''

    adapt_threshold: float = None
    ''' Minimum amount of fluid a cell can contain before it is considered empty

    :type: float
    '''

    additional_res: int = None
    ''' Maximum number of additional cells

    :type: int
    '''

    alpha: float = None
    ''' Buoyant force based on smoke density (higher value results in faster rising smoke)

    :type: float
    '''

    beta: float = None
    ''' Buoyant force based on smoke heat (higher value results in faster rising smoke)

    :type: float
    '''

    burning_rate: float = None
    ''' Speed of the burning reaction (higher value results in smaller flames)

    :type: float
    '''

    cache_data_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching volumetric data

    :type: typing.Union[str, int]
    '''

    cache_directory: str = None
    ''' Directory that contains fluid cache files

    :type: str
    '''

    cache_frame_end: int = None
    ''' Frame on which the simulation stops. This is the last frame that will be baked

    :type: int
    '''

    cache_frame_offset: int = None
    ''' Frame offset that is used when loading the simulation from the cache. It is not considered when baking the simulation, only when loading it

    :type: int
    '''

    cache_frame_pause_data: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_guide: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_mesh: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_noise: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_particles: int = None
    ''' 

    :type: int
    '''

    cache_frame_start: int = None
    ''' Frame on which the simulation starts. This is the first frame that will be baked

    :type: int
    '''

    cache_mesh_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching surface data

    :type: typing.Union[str, int]
    '''

    cache_noise_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching noise data

    :type: typing.Union[str, int]
    '''

    cache_particle_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching particle data

    :type: typing.Union[str, int]
    '''

    cache_resumable: bool = None
    ''' Additional data will be saved so that the bake jobs can be resumed after pausing. Because more data will be written to disk it is recommended to avoid enabling this option when baking at high resolutions

    :type: bool
    '''

    cache_type: typing.Union[str, int] = None
    ''' Change the cache type of the simulation * REPLAY Replay, Use the timeline to bake the scene. * MODULAR Modular, Bake every stage of the simulation separately. * ALL All, Bake all simulation settings at once.

    :type: typing.Union[str, int]
    '''

    cell_size: typing.List[float] = None
    ''' Cell Size

    :type: typing.List[float]
    '''

    cfl_condition: float = None
    ''' Maximal velocity per cell (higher value results in greater timesteps)

    :type: float
    '''

    clipping: float = None
    ''' Value under which voxels are considered empty space to optimize rendering

    :type: float
    '''

    color_grid: typing.List[float] = None
    ''' Smoke color grid

    :type: typing.List[float]
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    color_ramp_field: typing.Union[str, int] = None
    ''' Simulation field to color map

    :type: typing.Union[str, int]
    '''

    color_ramp_field_scale: float = None
    ''' Multiplier for scaling the selected field to color map

    :type: float
    '''

    delete_in_obstacle: bool = None
    ''' Delete fluid inside obstacles

    :type: bool
    '''

    density_grid: typing.List[float] = None
    ''' Smoke density grid

    :type: typing.List[float]
    '''

    display_interpolation: typing.Union[str, int] = None
    ''' Interpolation method to use for smoke/fire volumes in solid mode * LINEAR Linear, Good smoothness and speed. * CUBIC Cubic, Smoothed high quality interpolation, but slower. * CLOSEST Closest, No interpolation.

    :type: typing.Union[str, int]
    '''

    display_thickness: float = None
    ''' Thickness of smoke display in the viewport

    :type: float
    '''

    dissolve_speed: int = None
    ''' Determine how quickly the smoke dissolves (lower value makes smoke disappear faster)

    :type: int
    '''

    domain_resolution: typing.List[int] = None
    ''' Smoke Grid Resolution

    :type: typing.List[int]
    '''

    domain_type: typing.Union[str, int] = None
    ''' Change domain type of the simulation * GAS Gas, Create domain for gases. * LIQUID Liquid, Create domain for liquids.

    :type: typing.Union[str, int]
    '''

    effector_group: 'Collection' = None
    ''' Limit effectors to this collection

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    export_manta_script: bool = None
    ''' Generate and export Mantaflow script from current domain settings during bake. This is only needed if you plan to analyze the cache (e.g. view grids, velocity vectors, particles) in Mantaflow directly (outside of Blender) after baking the simulation

    :type: bool
    '''

    flame_grid: typing.List[float] = None
    ''' Smoke flame grid

    :type: typing.List[float]
    '''

    flame_ignition: float = None
    ''' Minimum temperature of the flames (higher value results in faster rising flames)

    :type: float
    '''

    flame_max_temp: float = None
    ''' Maximum temperature of the flames (higher value results in faster rising flames)

    :type: float
    '''

    flame_smoke: float = None
    ''' Amount of smoke created by burning fuel

    :type: float
    '''

    flame_smoke_color: typing.List[float] = None
    ''' Color of smoke emitted from burning fuel

    :type: typing.List[float]
    '''

    flame_vorticity: float = None
    ''' Additional vorticity for the flames

    :type: float
    '''

    flip_ratio: float = None
    ''' PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes

    :type: float
    '''

    fluid_group: 'Collection' = None
    ''' Limit fluid objects to this collection

    :type: 'Collection'
    '''

    force_collection: 'Collection' = None
    ''' Limit forces to this collection

    :type: 'Collection'
    '''

    fractions_distance: float = None
    ''' Determines how far apart fluid and obstacle are (higher values will result in fluid being further away from obstacles, smaller values will let fluid move towards the inside of obstacles)

    :type: float
    '''

    fractions_threshold: float = None
    ''' Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect)

    :type: float
    '''

    gravity: typing.List[float] = None
    ''' Gravity in X, Y and Z direction

    :type: typing.List[float]
    '''

    gridlines_cell_filter: typing.Union[str, int] = None
    ''' Cell type to be highlighted * NONE None, Highlight the cells regardless of their type. * FLUID Fluid, Highlight only the cells of type Fluid. * OBSTACLE Obstacle, Highlight only the cells of type Obstacle. * EMPTY Empty, Highlight only the cells of type Empty. * INFLOW Inflow, Highlight only the cells of type Inflow. * OUTFLOW Outflow, Highlight only the cells of type Outflow.

    :type: typing.Union[str, int]
    '''

    gridlines_color_field: typing.Union[str, int] = None
    ''' Simulation field to color map onto gridlines * NONE None, None. * FLAGS Flags, Flag grid of the fluid domain. * RANGE Highlight Range, Highlight the voxels with values of the color mapped field within the range.

    :type: typing.Union[str, int]
    '''

    gridlines_lower_bound: float = None
    ''' Lower bound of the highlighting range

    :type: float
    '''

    gridlines_range_color: typing.List[float] = None
    ''' Color used to highlight the range

    :type: typing.List[float]
    '''

    gridlines_upper_bound: float = None
    ''' Upper bound of the highlighting range

    :type: float
    '''

    guide_alpha: float = None
    ''' Guiding weight (higher value results in greater lag)

    :type: float
    '''

    guide_beta: int = None
    ''' Guiding size (higher value results in larger vortices)

    :type: int
    '''

    guide_parent: 'Object' = None
    ''' Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain))

    :type: 'Object'
    '''

    guide_source: typing.Union[str, int] = None
    ''' Choose where to get guiding velocities from * DOMAIN Domain, Use a fluid domain for guiding (domain needs to be baked already so that velocities can be extracted). Guiding domain can be of any type (i.e. gas or liquid). * EFFECTOR Effector, Use guiding (effector) objects to create fluid guiding (guiding objects should be animated and baked once set up completely).

    :type: typing.Union[str, int]
    '''

    guide_vel_factor: float = None
    ''' Guiding velocity factor (higher value results in greater guiding velocities)

    :type: float
    '''

    has_cache_baked_any: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_data: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_guide: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_mesh: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_noise: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_particles: bool = None
    ''' 

    :type: bool
    '''

    heat_grid: typing.List[float] = None
    ''' Smoke heat grid

    :type: typing.List[float]
    '''

    highres_sampling: typing.Union[str, int] = None
    ''' Method for sampling the high resolution flow

    :type: typing.Union[str, int]
    '''

    is_cache_baking_any: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_data: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_guide: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_mesh: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_noise: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_particles: bool = None
    ''' 

    :type: bool
    '''

    mesh_concave_lower: float = None
    ''' Lower mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    '''

    mesh_concave_upper: float = None
    ''' Upper mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    '''

    mesh_generator: typing.Union[str, int] = None
    ''' Which particle level set generator to use * IMPROVED Final, Use improved particle level set (slower but more precise and with mesh smoothening options). * UNION Preview, Use union particle level set (faster but lower quality).

    :type: typing.Union[str, int]
    '''

    mesh_particle_radius: float = None
    ''' Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale

    :type: float
    '''

    mesh_scale: int = None
    ''' The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value

    :type: int
    '''

    mesh_smoothen_neg: int = None
    ''' Negative mesh smoothening

    :type: int
    '''

    mesh_smoothen_pos: int = None
    ''' Positive mesh smoothening

    :type: int
    '''

    mesh_vertices: typing.Union[
        typing.Dict[str, 'FluidDomainVertexVelocity'], typing.
        List['FluidDomainVertexVelocity'], 'bpy_prop_collection'] = None
    ''' Vertices of the fluid mesh generated by simulation

    :type: typing.Union[typing.Dict[str, 'FluidDomainVertexVelocity'], typing.List['FluidDomainVertexVelocity'], 'bpy_prop_collection']
    '''

    noise_pos_scale: float = None
    ''' Scale of noise (higher value results in larger vortices)

    :type: float
    '''

    noise_scale: int = None
    ''' The noise simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    '''

    noise_strength: float = None
    ''' Strength of noise

    :type: float
    '''

    noise_time_anim: float = None
    ''' Animation time of noise

    :type: float
    '''

    noise_type: typing.Union[str, int] = None
    ''' Noise method which is used during the high-res simulation

    :type: typing.Union[str, int]
    '''

    openvdb_cache_compress_type: typing.Union[str, int] = None
    ''' Compression method to be used * ZIP Zip, Effective but slow compression. * BLOSC Blosc, Multithreaded compression, similar in size and quality as 'Zip'. * NONE None, Do not use any compression.

    :type: typing.Union[str, int]
    '''

    openvdb_data_depth: typing.Union[str, int] = None
    ''' Bit depth for fluid particles and grids (lower bit values reduce file size)

    :type: typing.Union[str, int]
    '''

    particle_band_width: float = None
    ''' Particle (narrow) band width (higher value results in thicker band and more particles)

    :type: float
    '''

    particle_max: int = None
    ''' Maximum number of particles per cell (ensures that each cell has at most this amount of particles)

    :type: int
    '''

    particle_min: int = None
    ''' Minimum number of particles per cell (ensures that each cell has at least this amount of particles)

    :type: int
    '''

    particle_number: int = None
    ''' Particle number factor (higher value results in more particles)

    :type: int
    '''

    particle_radius: float = None
    ''' Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume

    :type: float
    '''

    particle_randomness: float = None
    ''' Randomness factor for particle sampling

    :type: float
    '''

    particle_scale: int = None
    ''' The particle simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    '''

    resolution_max: int = None
    ''' Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically)

    :type: int
    '''

    show_gridlines: bool = None
    ''' Show gridlines

    :type: bool
    '''

    show_velocity: bool = None
    ''' Visualize vector fields

    :type: bool
    '''

    simulation_method: typing.Union[str, int] = None
    ''' Change the underlying simulation method * FLIP FLIP, Use FLIP as the simulation method (more splashy behavior). * APIC APIC, Use APIC as the simulation method (more energetic and stable behavior).

    :type: typing.Union[str, int]
    '''

    slice_axis: typing.Union[str, int] = None
    ''' * AUTO Auto, Adjust slice direction according to the view direction. * X X, Slice along the X axis. * Y Y, Slice along the Y axis. * Z Z, Slice along the Z axis.

    :type: typing.Union[str, int]
    '''

    slice_depth: float = None
    ''' Position of the slice

    :type: float
    '''

    slice_per_voxel: float = None
    ''' How many slices per voxel should be generated

    :type: float
    '''

    sndparticle_boundary: typing.Union[str, int] = None
    ''' How particles that left the domain are treated * DELETE Delete, Delete secondary particles that are inside obstacles or left the domain. * PUSHOUT Push Out, Push secondary particles that left the domain back into the domain.

    :type: typing.Union[str, int]
    '''

    sndparticle_bubble_buoyancy: float = None
    ''' Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards)

    :type: float
    '''

    sndparticle_bubble_drag: float = None
    ''' Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid)

    :type: float
    '''

    sndparticle_combined_export: typing.Union[str, int] = None
    ''' Determines which particle systems are created from secondary particles * OFF Off, Create a separate particle system for every secondary particle type. * SPRAY_FOAM Spray + Foam, Spray and foam particles are saved in the same particle system. * SPRAY_BUBBLES Spray + Bubbles, Spray and bubble particles are saved in the same particle system. * FOAM_BUBBLES Foam + Bubbles, Foam and bubbles particles are saved in the same particle system. * SPRAY_FOAM_BUBBLES Spray + Foam + Bubbles, Create one particle system that contains all three secondary particle types.

    :type: typing.Union[str, int]
    '''

    sndparticle_life_max: float = None
    ''' Highest possible particle lifetime

    :type: float
    '''

    sndparticle_life_min: float = None
    ''' Lowest possible particle lifetime

    :type: float
    '''

    sndparticle_potential_max_energy: float = None
    ''' Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles)

    :type: float
    '''

    sndparticle_potential_max_trappedair: float = None
    ''' Upper clamping threshold for marking fluid cells where air is trapped (higher value results in less marked cells)

    :type: float
    '''

    sndparticle_potential_max_wavecrest: float = None
    ''' Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells)

    :type: float
    '''

    sndparticle_potential_min_energy: float = None
    ''' Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles)

    :type: float
    '''

    sndparticle_potential_min_trappedair: float = None
    ''' Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells)

    :type: float
    '''

    sndparticle_potential_min_wavecrest: float = None
    ''' Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells)

    :type: float
    '''

    sndparticle_potential_radius: int = None
    ''' Radius to compute potential for each cell (higher values are slower but create smoother potential grids)

    :type: int
    '''

    sndparticle_sampling_trappedair: int = None
    ''' Maximum number of particles generated per trapped air cell per frame

    :type: int
    '''

    sndparticle_sampling_wavecrest: int = None
    ''' Maximum number of particles generated per wave crest cell per frame

    :type: int
    '''

    sndparticle_update_radius: int = None
    ''' Radius to compute position update for each particle (higher values are slower but particles move less chaotic)

    :type: int
    '''

    start_point: typing.List[float] = None
    ''' Start point

    :type: typing.List[float]
    '''

    surface_tension: float = None
    ''' Surface tension of liquid (higher value results in greater hydrophobic behavior)

    :type: float
    '''

    sys_particle_maximum: int = None
    ''' Maximum number of fluid particles that are allowed in this simulation

    :type: int
    '''

    temperature_grid: typing.List[float] = None
    ''' Smoke temperature grid, range 0 to 1 represents 0 to 1000K

    :type: typing.List[float]
    '''

    time_scale: float = None
    ''' Adjust simulation speed

    :type: float
    '''

    timesteps_max: int = None
    ''' Maximum number of simulation steps to perform for one frame

    :type: int
    '''

    timesteps_min: int = None
    ''' Minimum number of simulation steps to perform for one frame

    :type: int
    '''

    use_adaptive_domain: bool = None
    ''' Adapt simulation resolution and size to fluid

    :type: bool
    '''

    use_adaptive_timesteps: bool = None
    ''' 

    :type: bool
    '''

    use_bubble_particles: bool = None
    ''' Create bubble particle system

    :type: bool
    '''

    use_collision_border_back: bool = None
    ''' Enable collisions with back domain border

    :type: bool
    '''

    use_collision_border_bottom: bool = None
    ''' Enable collisions with bottom domain border

    :type: bool
    '''

    use_collision_border_front: bool = None
    ''' Enable collisions with front domain border

    :type: bool
    '''

    use_collision_border_left: bool = None
    ''' Enable collisions with left domain border

    :type: bool
    '''

    use_collision_border_right: bool = None
    ''' Enable collisions with right domain border

    :type: bool
    '''

    use_collision_border_top: bool = None
    ''' Enable collisions with top domain border

    :type: bool
    '''

    use_color_ramp: bool = None
    ''' Render a simulation field while mapping its voxels values to the colors of a ramp or using a predefined color code

    :type: bool
    '''

    use_diffusion: bool = None
    ''' Enable fluid diffusion settings (e.g. viscosity, surface tension)

    :type: bool
    '''

    use_dissolve_smoke: bool = None
    ''' Let smoke disappear over time

    :type: bool
    '''

    use_dissolve_smoke_log: bool = None
    ''' Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer

    :type: bool
    '''

    use_flip_particles: bool = None
    ''' Create liquid particle system

    :type: bool
    '''

    use_foam_particles: bool = None
    ''' Create foam particle system

    :type: bool
    '''

    use_fractions: bool = None
    ''' Fractional obstacles improve and smoothen the fluid-obstacle boundary

    :type: bool
    '''

    use_guide: bool = None
    ''' Enable fluid guiding

    :type: bool
    '''

    use_mesh: bool = None
    ''' Enable fluid mesh (using amplification)

    :type: bool
    '''

    use_noise: bool = None
    ''' Enable fluid noise (using amplification)

    :type: bool
    '''

    use_slice: bool = None
    ''' Perform a single slice of the domain object

    :type: bool
    '''

    use_speed_vectors: bool = None
    ''' Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled

    :type: bool
    '''

    use_spray_particles: bool = None
    ''' Create spray particle system

    :type: bool
    '''

    use_tracer_particles: bool = None
    ''' Create tracer particle system

    :type: bool
    '''

    use_viscosity: bool = None
    ''' Enable fluid viscosity settings

    :type: bool
    '''

    vector_display_type: typing.Union[str, int] = None
    ''' * NEEDLE Needle, Display vectors as needles. * STREAMLINE Streamlines, Display vectors as streamlines. * MAC MAC Grid, Display vector field as MAC grid.

    :type: typing.Union[str, int]
    '''

    vector_field: typing.Union[str, int] = None
    ''' Vector field to be represented by the display vectors * FLUID_VELOCITY Fluid Velocity, Velocity field of the fluid domain. * GUIDE_VELOCITY Guide Velocity, Guide velocity field of the fluid domain. * FORCE Force, Force field of the fluid domain.

    :type: typing.Union[str, int]
    '''

    vector_scale: float = None
    ''' Multiplier for scaling the vectors

    :type: float
    '''

    vector_scale_with_magnitude: bool = None
    ''' Scale vectors with their magnitudes

    :type: bool
    '''

    vector_show_mac_x: bool = None
    ''' Show X-component of MAC Grid

    :type: bool
    '''

    vector_show_mac_y: bool = None
    ''' Show Y-component of MAC Grid

    :type: bool
    '''

    vector_show_mac_z: bool = None
    ''' Show Z-component of MAC Grid

    :type: bool
    '''

    velocity_grid: typing.List[float] = None
    ''' Smoke velocity grid

    :type: typing.List[float]
    '''

    viscosity_base: float = None
    ''' Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    '''

    viscosity_exponent: int = None
    ''' Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    '''

    viscosity_value: float = None
    ''' Viscosity of liquid (higher values result in more viscous fluids, a value of 0 will still apply some viscosity)

    :type: float
    '''

    vorticity: float = None
    ''' Amount of turbulence and rotation in smoke

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FluidDomainVertexVelocity(bpy_struct):
    ''' Velocity of a simulated fluid mesh
    '''

    velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FluidEffectorSettings(bpy_struct):
    ''' Smoke collision settings
    '''

    effector_type: typing.Union[str, int] = None
    ''' Change type of effector in the simulation * COLLISION Collision, Create collision object. * GUIDE Guide, Create guide object.

    :type: typing.Union[str, int]
    '''

    guide_mode: typing.Union[str, int] = None
    ''' How to create guiding velocities * MAXIMUM Maximize, Compare velocities from previous frame with new velocities from current frame and keep the maximum. * MINIMUM Minimize, Compare velocities from previous frame with new velocities from current frame and keep the minimum. * OVERRIDE Override, Always write new guide velocities for every frame (each frame only contains current velocities from guiding objects). * AVERAGED Averaged, Take average of velocities from previous frame and new velocities from current frame.

    :type: typing.Union[str, int]
    '''

    subframes: int = None
    ''' Number of additional samples to take between frames to improve quality of fast moving effector objects

    :type: int
    '''

    surface_distance: float = None
    ''' Additional distance around mesh surface to consider as effector

    :type: float
    '''

    use_effector: bool = None
    ''' Control when to apply the effector

    :type: bool
    '''

    use_plane_init: bool = None
    ''' Treat this object as a planar, unclosed mesh

    :type: bool
    '''

    velocity_factor: float = None
    ''' Multiplier of obstacle velocity

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FluidFlowSettings(bpy_struct):
    ''' Fluid flow settings
    '''

    density: float = None
    ''' 

    :type: float
    '''

    density_vertex_group: str = None
    ''' Name of vertex group which determines surface emission rate

    :type: str
    '''

    flow_behavior: typing.Union[str, int] = None
    ''' Change flow behavior in the simulation * INFLOW Inflow, Add fluid to simulation. * OUTFLOW Outflow, Delete fluid from simulation. * GEOMETRY Geometry, Only use given geometry for fluid.

    :type: typing.Union[str, int]
    '''

    flow_source: typing.Union[str, int] = None
    ''' Change how fluid is emitted

    :type: typing.Union[str, int]
    '''

    flow_type: typing.Union[str, int] = None
    ''' Change type of fluid in the simulation * SMOKE Smoke, Add smoke. * BOTH Fire + Smoke, Add fire and smoke. * FIRE Fire, Add fire. * LIQUID Liquid, Add liquid.

    :type: typing.Union[str, int]
    '''

    fuel_amount: float = None
    ''' 

    :type: float
    '''

    noise_texture: 'Texture' = None
    ''' Texture that controls emission strength

    :type: 'Texture'
    '''

    particle_size: float = None
    ''' Particle size in simulation cells

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' Particle systems emitted from the object

    :type: 'ParticleSystem'
    '''

    smoke_color: typing.List[float] = None
    ''' Color of smoke

    :type: typing.List[float]
    '''

    subframes: int = None
    ''' Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    '''

    surface_distance: float = None
    ''' Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface

    :type: float
    '''

    temperature: float = None
    ''' Temperature difference to ambient temperature

    :type: float
    '''

    texture_map_type: typing.Union[str, int] = None
    ''' Texture mapping type * AUTO Generated, Generated coordinates centered to flow object. * UV UV, Use UV layer for texture coordinates.

    :type: typing.Union[str, int]
    '''

    texture_offset: float = None
    ''' Z-offset of texture mapping

    :type: float
    '''

    texture_size: float = None
    ''' Size of texture mapping

    :type: float
    '''

    use_absolute: bool = None
    ''' Only allow given density value in emitter area and will not add up

    :type: bool
    '''

    use_inflow: bool = None
    ''' Control when to apply fluid flow

    :type: bool
    '''

    use_initial_velocity: bool = None
    ''' Fluid has some initial velocity when it is emitted

    :type: bool
    '''

    use_particle_size: bool = None
    ''' Set particle size in simulation cells or use nearest cell

    :type: bool
    '''

    use_plane_init: bool = None
    ''' Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value

    :type: bool
    '''

    use_texture: bool = None
    ''' Use a texture to control emission strength

    :type: bool
    '''

    uv_layer: str = None
    ''' UV map name

    :type: str
    '''

    velocity_coord: typing.List[float] = None
    ''' Additional initial velocity in X, Y and Z direction (added to source velocity)

    :type: typing.List[float]
    '''

    velocity_factor: float = None
    ''' Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving)

    :type: float
    '''

    velocity_normal: float = None
    ''' Amount of normal directional velocity

    :type: float
    '''

    velocity_random: float = None
    ''' Amount of random velocity

    :type: float
    '''

    volume_density: float = None
    ''' Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh)

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FreestyleLineSet(bpy_struct):
    ''' Line set for associating lines and style parameters
    '''

    collection: 'Collection' = None
    ''' A collection of objects based on which feature edges are selected

    :type: 'Collection'
    '''

    collection_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges belonging to a collection of objects * INCLUSIVE Inclusive, Select feature edges belonging to some object in the group. * EXCLUSIVE Exclusive, Select feature edges not belonging to any object in the group.

    :type: typing.Union[str, int]
    '''

    edge_type_combination: typing.Union[str, int] = None
    ''' Specify a logical combination of selection conditions on feature edge types * OR Logical OR, Select feature edges satisfying at least one of edge type conditions. * AND Logical AND, Select feature edges satisfying all edge type conditions.

    :type: typing.Union[str, int]
    '''

    edge_type_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by edge types * INCLUSIVE Inclusive, Select feature edges satisfying the given edge type conditions. * EXCLUSIVE Exclusive, Select feature edges not satisfying the given edge type conditions.

    :type: typing.Union[str, int]
    '''

    exclude_border: bool = None
    ''' Exclude border edges

    :type: bool
    '''

    exclude_contour: bool = None
    ''' Exclude contours

    :type: bool
    '''

    exclude_crease: bool = None
    ''' Exclude crease edges

    :type: bool
    '''

    exclude_edge_mark: bool = None
    ''' Exclude edge marks

    :type: bool
    '''

    exclude_external_contour: bool = None
    ''' Exclude external contours

    :type: bool
    '''

    exclude_material_boundary: bool = None
    ''' Exclude edges at material boundaries

    :type: bool
    '''

    exclude_ridge_valley: bool = None
    ''' Exclude ridges and valleys

    :type: bool
    '''

    exclude_silhouette: bool = None
    ''' Exclude silhouette edges

    :type: bool
    '''

    exclude_suggestive_contour: bool = None
    ''' Exclude suggestive contours

    :type: bool
    '''

    face_mark_condition: typing.Union[str, int] = None
    ''' Specify a feature edge selection condition based on face marks * ONE One Face, Select a feature edge if either of its adjacent faces is marked. * BOTH Both Faces, Select a feature edge if both of its adjacent faces are marked.

    :type: typing.Union[str, int]
    '''

    face_mark_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by face marks * INCLUSIVE Inclusive, Select feature edges satisfying the given face mark conditions. * EXCLUSIVE Exclusive, Select feature edges not satisfying the given face mark conditions.

    :type: typing.Union[str, int]
    '''

    linestyle: 'FreestyleLineStyle' = None
    ''' Line style settings

    :type: 'FreestyleLineStyle'
    '''

    name: str = None
    ''' Line set name

    :type: str
    '''

    qi_end: int = None
    ''' Last QI value of the QI range

    :type: int
    '''

    qi_start: int = None
    ''' First QI value of the QI range

    :type: int
    '''

    select_border: bool = None
    ''' Select border edges (open mesh edges)

    :type: bool
    '''

    select_by_collection: bool = None
    ''' Select feature edges based on a collection of objects

    :type: bool
    '''

    select_by_edge_types: bool = None
    ''' Select feature edges based on edge types

    :type: bool
    '''

    select_by_face_marks: bool = None
    ''' Select feature edges by face marks

    :type: bool
    '''

    select_by_image_border: bool = None
    ''' Select feature edges by image border (less memory consumption)

    :type: bool
    '''

    select_by_visibility: bool = None
    ''' Select feature edges based on visibility

    :type: bool
    '''

    select_contour: bool = None
    ''' Select contours (outer silhouettes of each object)

    :type: bool
    '''

    select_crease: bool = None
    ''' Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    '''

    select_edge_mark: bool = None
    ''' Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    '''

    select_external_contour: bool = None
    ''' Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    '''

    select_material_boundary: bool = None
    ''' Select edges at material boundaries

    :type: bool
    '''

    select_ridge_valley: bool = None
    ''' Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    '''

    select_silhouette: bool = None
    ''' Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    '''

    select_suggestive_contour: bool = None
    ''' Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    '''

    show_render: bool = None
    ''' Enable or disable this line set during stroke rendering

    :type: bool
    '''

    visibility: typing.Union[str, int] = None
    ''' Determine how to use visibility for feature edge selection * VISIBLE Visible, Select visible feature edges. * HIDDEN Hidden, Select hidden feature edges. * RANGE QI Range, Select feature edges within a range of quantitative invisibility (QI) values.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FreestyleModuleSettings(bpy_struct):
    ''' Style module configuration for specifying a style module
    '''

    script: 'Text' = None
    ''' Python script to define a style module

    :type: 'Text'
    '''

    use: bool = None
    ''' Enable or disable this style module during stroke rendering

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FreestyleModules(bpy_struct):
    ''' A list of style modules (to be applied from top to bottom)
    '''

    def new(self) -> 'FreestyleModuleSettings':
        ''' Add a style module to scene render layer Freestyle settings

        :rtype: 'FreestyleModuleSettings'
        :return: Newly created style module
        '''
        pass

    def remove(self, module: 'FreestyleModuleSettings'):
        ''' Remove a style module from scene render layer Freestyle settings

        :param module: Style module to remove
        :type module: 'FreestyleModuleSettings'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class FreestyleSettings(bpy_struct):
    ''' Freestyle settings for a ViewLayer data-block
    '''

    as_render_pass: bool = None
    ''' Renders Freestyle output to a separate pass instead of overlaying it on the Combined pass

    :type: bool
    '''

    crease_angle: float = None
    ''' Angular threshold for detecting crease edges

    :type: float
    '''

    kr_derivative_epsilon: float = None
    ''' Kr derivative epsilon for computing suggestive contours

    :type: float
    '''

    linesets: typing.Union[typing.Dict[str, 'FreestyleLineSet'], typing.
                           List['FreestyleLineSet'], 'bpy_prop_collection',
                           'Linesets'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'FreestyleLineSet'], typing.List['FreestyleLineSet'], 'bpy_prop_collection', 'Linesets']
    '''

    mode: typing.Union[str, int] = None
    ''' Select the Freestyle control mode * SCRIPT Python Scripting Mode, Advanced mode for using style modules written in Python. * EDITOR Parameter Editor Mode, Basic mode for interactive style parameter editing.

    :type: typing.Union[str, int]
    '''

    modules: typing.Union[typing.Dict[str, 'FreestyleModuleSettings'], typing.
                          List['FreestyleModuleSettings'],
                          'bpy_prop_collection', 'FreestyleModules'] = None
    ''' A list of style modules (to be applied from top to bottom)

    :type: typing.Union[typing.Dict[str, 'FreestyleModuleSettings'], typing.List['FreestyleModuleSettings'], 'bpy_prop_collection', 'FreestyleModules']
    '''

    sphere_radius: float = None
    ''' Sphere radius for computing curvatures

    :type: float
    '''

    use_advanced_options: bool = None
    ''' Enable advanced edge detection options (sphere radius and Kr derivative epsilon)

    :type: bool
    '''

    use_culling: bool = None
    ''' If enabled, out-of-view edges are ignored

    :type: bool
    '''

    use_material_boundaries: bool = None
    ''' Enable material boundaries

    :type: bool
    '''

    use_ridges_and_valleys: bool = None
    ''' Enable ridges and valleys

    :type: bool
    '''

    use_smoothness: bool = None
    ''' Take face smoothness into account in view map calculation

    :type: bool
    '''

    use_suggestive_contours: bool = None
    ''' Enable suggestive contours

    :type: bool
    '''

    use_view_map_cache: bool = None
    ''' Keep the computed view map and avoid recalculating it if mesh geometry is unchanged

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Function(bpy_struct):
    ''' RNA function definition
    '''

    description: str = None
    ''' Description of the Function's purpose

    :type: str
    '''

    identifier: str = None
    ''' Unique name used in the code and scripting

    :type: str
    '''

    is_registered: bool = None
    ''' Function is registered as callback as part of type registration

    :type: bool
    '''

    is_registered_optional: bool = None
    ''' Function is optionally registered as callback part of type registration

    :type: bool
    '''

    parameters: typing.Union[typing.Dict[str, 'Property'], typing.
                             List['Property'], 'bpy_prop_collection'] = None
    ''' Parameters for the function

    :type: typing.Union[typing.Dict[str, 'Property'], typing.List['Property'], 'bpy_prop_collection']
    '''

    use_self: bool = None
    ''' Function does not pass its self as an argument (becomes a static method in python)

    :type: bool
    '''

    use_self_type: bool = None
    ''' Function passes its self type as an argument (becomes a class method in python if use_self is false)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilEditCurve(bpy_struct):
    ''' Edition Curve
    '''

    curve_points: typing.Union[
        typing.Dict[str, 'GPencilEditCurvePoint'], typing.
        List['GPencilEditCurvePoint'], 'bpy_prop_collection'] = None
    ''' Curve data points

    :type: typing.Union[typing.Dict[str, 'GPencilEditCurvePoint'], typing.List['GPencilEditCurvePoint'], 'bpy_prop_collection']
    '''

    select: bool = None
    ''' Curve is selected for viewport editing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilEditCurvePoint(bpy_struct):
    ''' Bezier curve point with two handles
    '''

    co: typing.List[float] = None
    ''' Coordinates of the control point

    :type: typing.List[float]
    '''

    handle_left: typing.List[float] = None
    ''' Coordinates of the first handle

    :type: typing.List[float]
    '''

    handle_right: typing.List[float] = None
    ''' Coordinates of the second handle

    :type: typing.List[float]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    point_index: int = None
    ''' Index of the corresponding grease pencil stroke point

    :type: int
    '''

    pressure: float = None
    ''' Pressure of the grease pencil stroke point

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Handle 1 selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Handle 2 selection status

    :type: bool
    '''

    strength: float = None
    ''' Color intensity (alpha factor) of the grease pencil stroke point

    :type: float
    '''

    uv_factor: float = None
    ''' Internal UV factor

    :type: float
    '''

    uv_rotation: float = None
    ''' Internal UV factor for dot mode

    :type: float
    '''

    vertex_color: typing.List[float] = None
    ''' Vertex color of the grease pencil stroke point

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilFrame(bpy_struct):
    ''' Collection of related sketches on a particular frame
    '''

    frame_number: int = None
    ''' The frame on which this sketch appears

    :type: int
    '''

    is_edited: bool = None
    ''' Frame is being edited (painted on)

    :type: bool
    '''

    keyframe_type: typing.Union[str, int] = None
    ''' Type of keyframe * KEYFRAME Keyframe, Normal keyframe - e.g. for key poses. * BREAKDOWN Breakdown, A breakdown pose - e.g. for transitions between key poses. * MOVING_HOLD Moving Hold, A keyframe that is part of a moving hold. * EXTREME Extreme, An 'extreme' pose, or some other purpose as needed. * JITTER Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Frame is selected for editing in the Dope Sheet

    :type: bool
    '''

    strokes: typing.Union[typing.Dict[str, 'GPencilStroke'], typing.
                          List['GPencilStroke'], 'bpy_prop_collection',
                          'GPencilStrokes'] = None
    ''' Freehand curves defining the sketch on this frame

    :type: typing.Union[typing.Dict[str, 'GPencilStroke'], typing.List['GPencilStroke'], 'bpy_prop_collection', 'GPencilStrokes']
    '''

    def clear(self):
        ''' Remove all the grease pencil frame data

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilFrames(bpy_struct):
    ''' Collection of grease pencil frames
    '''

    def new(self, frame_number: int, active: bool = False) -> 'GPencilFrame':
        ''' Add a new grease pencil frame

        :param frame_number: Frame Number, The frame on which this sketch appears
        :type frame_number: int
        :param active: Active
        :type active: bool
        :rtype: 'GPencilFrame'
        :return: The newly created frame
        '''
        pass

    def remove(self, frame: 'GPencilFrame'):
        ''' Remove a grease pencil frame

        :param frame: Frame, The frame to remove
        :type frame: 'GPencilFrame'
        '''
        pass

    def copy(self, source: 'GPencilFrame') -> 'GPencilFrame':
        ''' Copy a grease pencil frame

        :param source: Source, The source frame
        :type source: 'GPencilFrame'
        :rtype: 'GPencilFrame'
        :return: The newly copied frame
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilInterpolateSettings(bpy_struct):
    ''' Settings for Grease Pencil interpolation tools
    '''

    interpolation_curve: 'CurveMapping' = None
    ''' Custom curve to control 'sequence' interpolation between Grease Pencil frames

    :type: 'CurveMapping'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilLayer(bpy_struct):
    ''' Collection of related sketches
    '''

    active_frame: 'GPencilFrame' = None
    ''' Frame currently being displayed for this layer

    :type: 'GPencilFrame'
    '''

    annotation_hide: bool = None
    ''' Set annotation Visibility

    :type: bool
    '''

    annotation_onion_after_color: typing.List[float] = None
    ''' Base color for ghosts after the active frame

    :type: typing.List[float]
    '''

    annotation_onion_after_range: int = None
    ''' Maximum number of frames to show after current frame

    :type: int
    '''

    annotation_onion_before_color: typing.List[float] = None
    ''' Base color for ghosts before the active frame

    :type: typing.List[float]
    '''

    annotation_onion_before_range: int = None
    ''' Maximum number of frames to show before current frame

    :type: int
    '''

    blend_mode: typing.Union[str, int] = None
    ''' Blend mode

    :type: typing.Union[str, int]
    '''

    channel_color: typing.List[float] = None
    ''' Custom color for animation channel in Dopesheet

    :type: typing.List[float]
    '''

    color: typing.List[float] = None
    ''' Color for all strokes in this layer

    :type: typing.List[float]
    '''

    frames: typing.Union[typing.Dict[str, 'GPencilFrame'], typing.
                         List['GPencilFrame'], 'bpy_prop_collection',
                         'GPencilFrames'] = None
    ''' Sketches for this layer on different frames

    :type: typing.Union[typing.Dict[str, 'GPencilFrame'], typing.List['GPencilFrame'], 'bpy_prop_collection', 'GPencilFrames']
    '''

    hide: bool = None
    ''' Set layer Visibility

    :type: bool
    '''

    info: str = None
    ''' Layer name

    :type: str
    '''

    is_parented: bool = None
    ''' True when the layer parent object is set

    :type: bool
    '''

    is_ruler: bool = None
    ''' This is a special ruler layer

    :type: bool
    '''

    line_change: int = None
    ''' Thickness change to apply to current strokes (in pixels)

    :type: int
    '''

    location: typing.List[float] = None
    ''' Values for change location

    :type: typing.List[float]
    '''

    lock: bool = None
    ''' Protect layer from further editing and/or frame changes

    :type: bool
    '''

    lock_frame: bool = None
    ''' Lock current frame displayed by layer

    :type: bool
    '''

    lock_material: bool = None
    ''' Avoids editing locked materials in the layer

    :type: bool
    '''

    mask_layers: typing.Union[typing.Dict[str, 'GPencilLayerMask'], typing.
                              List['GPencilLayerMask'], 'bpy_prop_collection',
                              'GreasePencilMaskLayers'] = None
    ''' List of Masking Layers

    :type: typing.Union[typing.Dict[str, 'GPencilLayerMask'], typing.List['GPencilLayerMask'], 'bpy_prop_collection', 'GreasePencilMaskLayers']
    '''

    matrix_inverse: typing.List[float] = None
    ''' Parent inverse transformation matrix

    :type: typing.List[float]
    '''

    matrix_inverse_layer: typing.List[float] = None
    ''' Local Layer transformation inverse matrix

    :type: typing.List[float]
    '''

    matrix_layer: typing.List[float] = None
    ''' Local Layer transformation matrix

    :type: typing.List[float]
    '''

    opacity: float = None
    ''' Layer Opacity

    :type: float
    '''

    parent: 'Object' = None
    ''' Parent object

    :type: 'Object'
    '''

    parent_bone: str = None
    ''' Name of parent bone in case of a bone parenting relation

    :type: str
    '''

    parent_type: typing.Union[str, int] = None
    ''' Type of parent relation * OBJECT Object, The layer is parented to an object. * ARMATURE Armature. * BONE Bone, The layer is parented to a bone.

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    ''' Index number for the "Layer Index" pass

    :type: int
    '''

    rotation: typing.List[float] = None
    ''' Values for changes in rotation

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    ''' Values for changes in scale

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    show_in_front: bool = None
    ''' Make the layer display in front of objects

    :type: bool
    '''

    show_points: bool = None
    ''' Show the points which make up the strokes (for debugging purposes)

    :type: bool
    '''

    thickness: int = None
    ''' Thickness of annotation strokes

    :type: int
    '''

    tint_color: typing.List[float] = None
    ''' Color for tinting stroke colors

    :type: typing.List[float]
    '''

    tint_factor: float = None
    ''' Factor of tinting color

    :type: float
    '''

    use_annotation_onion_skinning: bool = None
    ''' Display annotation onion skins before and after the current frame

    :type: bool
    '''

    use_lights: bool = None
    ''' Enable the use of lights on stroke and fill materials

    :type: bool
    '''

    use_mask_layer: bool = None
    ''' The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    '''

    use_onion_skinning: bool = None
    ''' Display onion skins before and after the current frame

    :type: bool
    '''

    use_solo_mode: bool = None
    ''' In Paint mode display only layers with keyframe in current frame

    :type: bool
    '''

    vertex_paint_opacity: float = None
    ''' Vertex Paint mix factor

    :type: float
    '''

    viewlayer_render: str = None
    ''' Only include Layer in this View Layer render output (leave blank to include always)

    :type: str
    '''

    def clear(self):
        ''' Remove all the grease pencil layer data

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilLayerMask(bpy_struct):
    ''' List of Mask Layers
    '''

    hide: bool = None
    ''' Set mask Visibility

    :type: bool
    '''

    invert: bool = None
    ''' Invert mask

    :type: bool
    '''

    name: str = None
    ''' Mask layer name

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilSculptGuide(bpy_struct):
    ''' Guides for drawing
    '''

    angle: float = None
    ''' Direction of lines

    :type: float
    '''

    angle_snap: float = None
    ''' Angle snapping

    :type: float
    '''

    location: typing.List[float] = None
    ''' Custom reference point for guides

    :type: typing.List[float]
    '''

    reference_object: 'Object' = None
    ''' Object used for reference point

    :type: 'Object'
    '''

    reference_point: typing.Union[str, int] = None
    ''' Type of speed guide * CURSOR Cursor, Use cursor as reference point. * CUSTOM Custom, Use custom reference point. * OBJECT Object, Use object as reference point.

    :type: typing.Union[str, int]
    '''

    spacing: float = None
    ''' Guide spacing

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of speed guide * CIRCULAR Circular, Use single point to create rings. * RADIAL Radial, Use single point as direction. * PARALLEL Parallel, Parallel lines. * GRID Grid, Grid allows horizontal and vertical lines. * ISO Isometric, Grid allows isometric and vertical lines.

    :type: typing.Union[str, int]
    '''

    use_guide: bool = None
    ''' Enable speed guides

    :type: bool
    '''

    use_snapping: bool = None
    ''' Enable snapping to guides angle or spacing options

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilSculptSettings(bpy_struct):
    ''' General properties for Grease Pencil stroke sculpting tools
    '''

    guide: 'GPencilSculptGuide' = None
    ''' 

    :type: 'GPencilSculptGuide'
    '''

    intersection_threshold: float = None
    ''' Threshold for stroke intersections

    :type: float
    '''

    lock_axis: typing.Union[str, int] = None
    ''' * VIEW View, Align strokes to current view plane. * AXIS_Y Front (X-Z), Project strokes to plane locked to Y. * AXIS_X Side (Y-Z), Project strokes to plane locked to X. * AXIS_Z Top (X-Y), Project strokes to plane locked to Z. * CURSOR Cursor, Align strokes to current 3D cursor orientation.

    :type: typing.Union[str, int]
    '''

    multiframe_falloff_curve: 'CurveMapping' = None
    ''' Custom curve to control falloff of brush effect by Grease Pencil frames

    :type: 'CurveMapping'
    '''

    thickness_primitive_curve: 'CurveMapping' = None
    ''' Custom curve to control primitive thickness

    :type: 'CurveMapping'
    '''

    use_multiframe_falloff: bool = None
    ''' Use falloff effect when edit in multiframe mode to compute brush effect by frame

    :type: bool
    '''

    use_scale_thickness: bool = None
    ''' Scale the stroke thickness when transforming strokes

    :type: bool
    '''

    use_thickness_curve: bool = None
    ''' Use curve to define primitive stroke thickness

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilStroke(bpy_struct):
    ''' Freehand curve defining part of a sketch
    '''

    aspect: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    bound_box_max: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    bound_box_min: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    display_mode: typing.Union[str, int] = None
    ''' Coordinate space that stroke is in * SCREEN Screen, Stroke is in screen-space. * 3DSPACE 3D Space, Stroke is in 3D-space. * 2DSPACE 2D Space, Stroke is in 2D-space. * 2DIMAGE 2D Image, Stroke is in 2D-space (but with special 'image' scaling).

    :type: typing.Union[str, int]
    '''

    edit_curve: 'GPencilEditCurve' = None
    ''' Temporary data for Edit Curve

    :type: 'GPencilEditCurve'
    '''

    end_cap_mode: typing.Union[str, int] = None
    ''' Stroke end extreme cap style

    :type: typing.Union[str, int]
    '''

    hardness: float = None
    ''' Amount of gradient along section of stroke

    :type: float
    '''

    has_edit_curve: bool = None
    ''' Stroke has Curve data to edit shape

    :type: bool
    '''

    is_nofill_stroke: bool = None
    ''' Special stroke to use as boundary for filling areas

    :type: bool
    '''

    line_width: int = None
    ''' Thickness of stroke (in pixels)

    :type: int
    '''

    material_index: int = None
    ''' Index of material used in this stroke

    :type: int
    '''

    points: typing.Union[typing.Dict[str, 'GPencilStrokePoint'], typing.
                         List['GPencilStrokePoint'], 'bpy_prop_collection',
                         'GPencilStrokePoints'] = None
    ''' Stroke data points

    :type: typing.Union[typing.Dict[str, 'GPencilStrokePoint'], typing.List['GPencilStrokePoint'], 'bpy_prop_collection', 'GPencilStrokePoints']
    '''

    select: bool = None
    ''' Stroke is selected for viewport editing

    :type: bool
    '''

    select_index: int = None
    ''' Index of selection used for interpolation

    :type: int
    '''

    start_cap_mode: typing.Union[str, int] = None
    ''' Stroke start extreme cap style

    :type: typing.Union[str, int]
    '''

    triangles: typing.Union[typing.Dict[str, 'GPencilTriangle'], typing.
                            List['GPencilTriangle'],
                            'bpy_prop_collection'] = None
    ''' Triangulation data for HQ fill

    :type: typing.Union[typing.Dict[str, 'GPencilTriangle'], typing.List['GPencilTriangle'], 'bpy_prop_collection']
    '''

    use_cyclic: bool = None
    ''' Enable cyclic drawing, closing the stroke

    :type: bool
    '''

    uv_rotation: float = None
    ''' Rotation of the UV

    :type: float
    '''

    uv_scale: float = None
    ''' Scale of the UV

    :type: float
    '''

    uv_translation: typing.List[float] = None
    ''' Translation of default UV position

    :type: typing.List[float]
    '''

    vertex_color_fill: typing.List[float] = None
    ''' Color used to mix with fill color to get final color

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilStrokePoint(bpy_struct):
    ''' Data point for freehand stroke curve
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    pressure: float = None
    ''' Pressure of tablet at point when drawing it

    :type: float
    '''

    select: bool = None
    ''' Point is selected for viewport editing

    :type: bool
    '''

    strength: float = None
    ''' Color intensity (alpha factor)

    :type: float
    '''

    uv_factor: float = None
    ''' Internal UV factor

    :type: float
    '''

    uv_fill: typing.List[float] = None
    ''' Internal UV factor for filling

    :type: typing.List[float]
    '''

    uv_rotation: float = None
    ''' Internal UV factor for dot mode

    :type: float
    '''

    vertex_color: typing.List[float] = None
    ''' Color used to mix with point color to get final color

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilStrokePoints(bpy_struct):
    ''' Collection of grease pencil stroke points
    '''

    def add(self, count: int, pressure: float = 1.0, strength: float = 1.0):
        ''' Add a new grease pencil stroke point

        :param count: Number, Number of points to add to the stroke
        :type count: int
        :param pressure: Pressure, Pressure for newly created points
        :type pressure: float
        :param strength: Strength, Color intensity (alpha factor) for newly created points
        :type strength: float
        '''
        pass

    def pop(self, index: int = -1):
        ''' Remove a grease pencil stroke point

        :param index: Index, point index
        :type index: int
        '''
        pass

    def update(self):
        ''' Recalculate internal triangulation data

        '''
        pass

    def weight_get(self, vertex_group_index: int = 0,
                   point_index: int = 0) -> float:
        ''' Get vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: int
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: int
        :rtype: float
        :return: Weight, Point Weight
        '''
        pass

    def weight_set(self,
                   vertex_group_index: int = 0,
                   point_index: int = 0,
                   weight: float = 0.0):
        ''' Set vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: int
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: int
        :param weight: Weight, Point Weight
        :type weight: float
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilStrokes(bpy_struct):
    ''' Collection of grease pencil stroke
    '''

    def new(self) -> 'GPencilStroke':
        ''' Add a new grease pencil stroke

        :rtype: 'GPencilStroke'
        :return: The newly created stroke
        '''
        pass

    def remove(self, stroke: 'GPencilStroke'):
        ''' Remove a grease pencil stroke

        :param stroke: Stroke, The stroke to remove
        :type stroke: 'GPencilStroke'
        '''
        pass

    def close(self, stroke: 'GPencilStroke'):
        ''' Close a grease pencil stroke adding geometry

        :param stroke: Stroke, The stroke to close
        :type stroke: 'GPencilStroke'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GPencilTriangle(bpy_struct):
    ''' Triangulation data for Grease Pencil fills
    '''

    v1: int = None
    ''' First triangle vertex index

    :type: int
    '''

    v2: int = None
    ''' Second triangle vertex index

    :type: int
    '''

    v3: int = None
    ''' Third triangle vertex index

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Gizmo(bpy_struct):
    ''' Collection of gizmos
    '''

    alpha: float = None
    ''' 

    :type: float
    '''

    alpha_highlight: float = None
    ''' 

    :type: float
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    color: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    color_highlight: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    group: 'GizmoGroup' = None
    ''' Gizmo group this gizmo is a member of

    :type: 'GizmoGroup'
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    hide_keymap: bool = None
    ''' Ignore the key-map for this gizmo

    :type: bool
    '''

    hide_select: bool = None
    ''' 

    :type: bool
    '''

    is_highlight: bool = None
    ''' 

    :type: bool
    '''

    is_modal: bool = None
    ''' 

    :type: bool
    '''

    line_width: float = None
    ''' 

    :type: float
    '''

    matrix_basis: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    matrix_offset: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    matrix_space: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    matrix_world: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    properties: 'GizmoProperties' = None
    ''' 

    :type: 'GizmoProperties'
    '''

    scale_basis: float = None
    ''' 

    :type: float
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_bias: float = None
    ''' Depth bias used for selection

    :type: float
    '''

    use_draw_hover: bool = None
    ''' 

    :type: bool
    '''

    use_draw_modal: bool = None
    ''' Show while dragging

    :type: bool
    '''

    use_draw_offset_scale: bool = None
    ''' Scale the offset matrix (use to apply screen-space offset)

    :type: bool
    '''

    use_draw_scale: bool = None
    ''' Use scale when calculating the matrix

    :type: bool
    '''

    use_draw_value: bool = None
    ''' Show an indicator for the current value while dragging

    :type: bool
    '''

    use_event_handle_all: bool = None
    ''' When highlighted, do not pass events through to be handled by other keymaps

    :type: bool
    '''

    use_grab_cursor: bool = None
    ''' 

    :type: bool
    '''

    use_operator_tool_properties: bool = None
    ''' Merge active tool properties on activation (does not overwrite existing)

    :type: bool
    '''

    use_select_background: bool = None
    ''' Don't write into the depth buffer

    :type: bool
    '''

    use_tooltip: bool = None
    ''' Use tooltips when hovering over this gizmo

    :type: bool
    '''

    def draw(self, context: 'Context'):
        ''' 

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_select(self, context: 'Context', select_id: int = 0):
        ''' 

        :param context: 
        :type context: 'Context'
        :param select_id: 
        :type select_id: int
        '''
        pass

    def test_select(self, context: 'Context',
                    location: typing.List[int]) -> int:
        ''' 

        :param context: 
        :type context: 'Context'
        :param location: Location, Region coordinates
        :type location: typing.List[int]
        :rtype: int
        :return: Use -1 to skip this gizmo
        '''
        pass

    def modal(self, context: 'Context', event: 'Event',
              tweak: typing.Union[typing.Set[str], typing.Set[int]]
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' 

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :param tweak: Tweak
        :type tweak: typing.Union[typing.Set[str], typing.Set[int]]
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * RUNNING_MODAL Running Modal, Keep the operator running with blender. * CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed. * FINISHED Finished, The operator exited after completing its action. * PASS_THROUGH Pass Through, Do nothing and pass the event on. * INTERFACE Interface, Handled but not executed (popup menus).
        '''
        pass

    def setup(self):
        ''' 

        '''
        pass

    def invoke(self, context: 'Context', event: 'Event'
               ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' 

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * RUNNING_MODAL Running Modal, Keep the operator running with blender. * CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed. * FINISHED Finished, The operator exited after completing its action. * PASS_THROUGH Pass Through, Do nothing and pass the event on. * INTERFACE Interface, Handled but not executed (popup menus).
        '''
        pass

    def exit(self, context: 'Context', cancel: bool):
        ''' 

        :param context: 
        :type context: 'Context'
        :param cancel: Cancel, otherwise confirm
        :type cancel: bool
        '''
        pass

    def select_refresh(self):
        ''' 

        '''
        pass

    def draw_preset_box(self, matrix: typing.List[float], select_id: int = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.List[float]
        :param select_id: Zero when not selecting
        :type select_id: int
        '''
        pass

    def draw_preset_arrow(self,
                          matrix: typing.List[float],
                          axis: typing.Union[str, int] = 'POS_Z',
                          select_id: int = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.List[float]
        :param axis: Arrow Orientation
        :type axis: typing.Union[str, int]
        :param select_id: Zero when not selecting
        :type select_id: int
        '''
        pass

    def draw_preset_circle(self,
                           matrix: typing.List[float],
                           axis: typing.Union[str, int] = 'POS_Z',
                           select_id: int = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.List[float]
        :param axis: Arrow Orientation
        :type axis: typing.Union[str, int]
        :param select_id: Zero when not selecting
        :type select_id: int
        '''
        pass

    def draw_preset_facemap(self,
                            object: 'Object',
                            face_map: int,
                            select_id: int = -1):
        ''' Draw the face-map of a mesh object

        :param object: Object
        :type object: 'Object'
        :param face_map: Face map index
        :type face_map: int
        :param select_id: Zero when not selecting
        :type select_id: int
        '''
        pass

    def target_set_prop(self,
                        target: str,
                        data: 'AnyType',
                        property: str,
                        index: int = -1):
        ''' 

        :param target: Target property
        :type target: str
        :param data: Data from which to take property
        :type data: 'AnyType'
        :param property: Identifier of property in data
        :type property: str
        :param index: 
        :type index: int
        '''
        pass

    def target_set_operator(self, operator: str,
                            index: int = 0) -> 'OperatorProperties':
        ''' Operator to run when activating the gizmo (overrides property targets)

        :param operator: Target operator
        :type operator: str
        :param index: Part index
        :type index: int
        :rtype: 'OperatorProperties'
        :return: Operator properties to fill in
        '''
        pass

    def target_is_valid(self, property: str):
        ''' 

        :param property: Property identifier
        :type property: str
        '''
        pass

    def draw_custom_shape(self,
                          shape,
                          *,
                          matrix: 'mathutils.Matrix' = None,
                          select_id=None):
        ''' Draw a shape created form bpy.types.Gizmo.draw_custom_shape .

        :param shape: The cached shape to draw.
        :type shape: 
        :param matrix: 4x4 matrix, when not given bpy.types.Gizmo.matrix_world is used.
        :type matrix: 'mathutils.Matrix'
        :param select_it: 
        :type select_it: int
        :param select_id: 
        :type select_id: 
        '''
        pass

    @staticmethod
    def new_custom_shape(type: str, verts: list):
        ''' Create a new shape that can be passed to bpy.types.Gizmo.draw_custom_shape .

        :param type: The type of shape to create in (POINTS, LINES, TRIS, LINE_STRIP).
        :type type: str
        :param verts: Coordinates.
        :type verts: list
        :param display_name: Optional callback that takes the full path, returns the name to display.
        :type display_name: str
        :return: The newly created shape.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass

    def target_get_range(self, target) -> tuple:
        ''' Get the range for this target property.

        :param target: 
        :type target: 
        :rtype: tuple
        :return: The range of this property (min, max).
        '''
        pass

    def target_get_value(self, target: str) -> list:
        ''' Get the value of this target property.

        :param target: Target property name.
        :type target: str
        :rtype: list
        :return: The value of the target property.
        '''
        pass

    def target_set_handler(self, target, get, set, range=None):
        ''' Assigns callbacks to a gizmos property.

        :param get: Function that returns the value for this property (single value or sequence).
        :type get: 
        :param set: Function that takes a single value argument and applies it.
        :type set: 
        :param range: Function that returns a (min, max) tuple for gizmos that use a range.
        :type range: 
        '''
        pass

    def target_set_value(self, target: str):
        ''' Set the value of this target property.

        :param target: Target property name.
        :type target: str
        '''
        pass


class GizmoGroup(bpy_struct):
    ''' Storage of an operator being executed, or registered after execution
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * 3D 3D, Use in 3D viewport. * SCALE Scale, Scale to respect zoom (otherwise zoom independent display size). * DEPTH_3D Depth 3D, Supports culled depth by other objects in the view. * SELECT Select, Supports selection. * PERSISTENT Persistent. * SHOW_MODAL_ALL Show Modal All, Show all while interacting. * TOOL_INIT Tool Init, Postpone running until tool operator run (when used with a tool). * VR_REDRAWS VR Redraws, The gizmos are made for use with virtual reality sessions and require special redraw management.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_owner_id: str = None
    ''' 

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the panel is going to be used in * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    gizmos: typing.Union[typing.Dict[str, 'Gizmo'], typing.
                         List['Gizmo'], 'bpy_prop_collection', 'Gizmos'] = None
    ''' List of gizmos in the Gizmo Map

    :type: typing.Union[typing.Dict[str, 'Gizmo'], typing.List['Gizmo'], 'bpy_prop_collection', 'Gizmos']
    '''

    has_reports: bool = None
    ''' GizmoGroup has a set of reports (warnings and errors) from last execution

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def poll(cls, context: 'Context'):
        ''' Test if the gizmo group can be called or not

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def setup_keymap(cls, keyconfig: 'KeyConfig'):
        ''' Initialize keymaps for this gizmo group, use fallback keymap when not present

        :param keyconfig: 
        :type keyconfig: 'KeyConfig'
        '''
        pass

    def setup(self, context: 'Context'):
        ''' Create gizmos function for the gizmo group

        :param context: 
        :type context: 'Context'
        '''
        pass

    def refresh(self, context: 'Context'):
        ''' Refresh data (called on common state changes such as selection)

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_prepare(self, context: 'Context'):
        ''' Run before each redraw

        :param context: 
        :type context: 'Context'
        '''
        pass

    def invoke_prepare(self, context: 'Context', gizmo: 'Gizmo'):
        ''' Run before invoke

        :param context: 
        :type context: 'Context'
        :param gizmo: 
        :type gizmo: 'Gizmo'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GizmoGroupProperties(bpy_struct):
    ''' Input properties of a Gizmo Group
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GizmoProperties(bpy_struct):
    ''' Input properties of an Gizmo
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Gizmos(bpy_struct):
    ''' Collection of gizmos
    '''

    def new(self, type: str) -> 'Gizmo':
        ''' Add gizmo

        :param type: Gizmo identifier
        :type type: str
        :rtype: 'Gizmo'
        :return: New gizmo
        '''
        pass

    def remove(self, gizmo: 'Gizmo'):
        ''' Delete gizmo

        :param gizmo: New gizmo
        :type gizmo: 'Gizmo'
        '''
        pass

    def clear(self):
        ''' Delete all gizmos

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GpencilModifier(bpy_struct):
    ''' Modifier affecting the grease pencil object
    '''

    name: str = None
    ''' Modifier name

    :type: str
    '''

    show_expanded: bool = None
    ''' Set modifier expanded in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display modifier in Edit mode

    :type: bool
    '''

    show_render: bool = None
    ''' Use modifier during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display modifier in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' * GP_ARRAY Array, Create array of duplicate instances. * GP_BUILD Build, Create duplication of strokes. * GP_LINEART Line Art, Generate line art strokes from selected source. * GP_MIRROR Mirror, Duplicate strokes like a mirror. * GP_MULTIPLY Multiple Strokes, Produce multiple strokes along one stroke. * GP_SIMPLIFY Simplify, Simplify stroke reducing number of points. * GP_SUBDIV Subdivide, Subdivide stroke adding more control points. * GP_ARMATURE Armature, Deform stroke points using armature object. * GP_HOOK Hook, Deform stroke points using objects. * GP_LATTICE Lattice, Deform strokes using lattice. * GP_NOISE Noise, Add noise to strokes. * GP_OFFSET Offset, Change stroke location, rotation or scale. * GP_SMOOTH Smooth, Smooth stroke. * GP_THICK Thickness, Change stroke thickness. * GP_TIME Time Offset, Offset keyframes. * GP_COLOR Hue/Saturation, Apply changes to stroke colors. * GP_OPACITY Opacity, Opacity of the strokes. * GP_TEXTURE Texture Mapping, Change stroke uv texture values. * GP_TINT Tint, Tint strokes with new color.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GpencilVertexGroupElement(bpy_struct):
    ''' Weight value of a vertex in a vertex group
    '''

    group: int = None
    ''' 

    :type: int
    '''

    weight: float = None
    ''' Vertex Weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GreasePencilGrid(bpy_struct):
    ''' Settings for grid and canvas in 3D viewport
    '''

    color: typing.List[float] = None
    ''' Color for grid lines

    :type: typing.List[float]
    '''

    lines: int = None
    ''' Number of subdivisions in each side of symmetry line

    :type: int
    '''

    offset: typing.List[float] = None
    ''' Offset of the canvas

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    ''' Grid scale

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GreasePencilLayers(bpy_struct):
    ''' Collection of grease pencil layers
    '''

    active: 'GPencilLayer' = None
    ''' Active grease pencil layer

    :type: 'GPencilLayer'
    '''

    active_index: int = None
    ''' Index of active grease pencil layer

    :type: int
    '''

    active_note: typing.Union[str, int] = None
    ''' Note/Layer to add annotation strokes to

    :type: typing.Union[str, int]
    '''

    def new(self, name: str, set_active: bool = True) -> 'GPencilLayer':
        ''' Add a new grease pencil layer

        :param name: Name, Name of the layer
        :type name: str
        :param set_active: Set Active, Set the newly created layer to the active layer
        :type set_active: bool
        :rtype: 'GPencilLayer'
        :return: The newly created layer
        '''
        pass

    def remove(self, layer: 'GPencilLayer'):
        ''' Remove a grease pencil layer

        :param layer: The layer to remove
        :type layer: 'GPencilLayer'
        '''
        pass

    def move(self, layer: 'GPencilLayer', type: typing.Union[str, int]):
        ''' Move a grease pencil layer in the layer stack

        :param layer: The layer to move
        :type layer: 'GPencilLayer'
        :param type: Direction of movement
        :type type: typing.Union[str, int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class GreasePencilMaskLayers(bpy_struct):
    ''' Collection of grease pencil masking layers
    '''

    active_mask_index: int = None
    ''' Active index in layer mask array

    :type: int
    '''

    def add(self, layer: 'GPencilLayer'):
        ''' Add a layer to mask list

        :param layer: Layer to add as mask
        :type layer: 'GPencilLayer'
        '''
        pass

    def remove(self, mask: 'GPencilLayerMask'):
        ''' Remove a layer from mask list

        :param mask: Mask to remove
        :type mask: 'GPencilLayerMask'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Header(bpy_struct):
    ''' Editor header containing UI elements
    '''

    bl_idname: str = None
    ''' If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the panel; for example, if the class name is "OBJECT_HT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_HT_hello"

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the header is going to be used in (defaults to header region)

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the header is going to be used in * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    layout: 'UILayout' = None
    ''' Structure of the header in the UI

    :type: 'UILayout'
    '''

    def draw(self, context: 'Context'):
        ''' Draw UI elements into the header UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Histogram(bpy_struct):
    ''' Statistical view of the levels of color in an image
    '''

    mode: typing.Union[str, int] = None
    ''' Channels to display in the histogram * LUMA Luma, Luma. * RGB RGB, Red Green Blue. * R R, Red. * G G, Green. * B B, Blue. * A A, Alpha.

    :type: typing.Union[str, int]
    '''

    show_line: bool = None
    ''' Display lines rather than filled shapes

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ID(bpy_struct):
    ''' Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection
    '''

    asset_data: 'AssetMetaData' = None
    ''' Additional data for an asset data-block

    :type: 'AssetMetaData'
    '''

    is_embedded_data: bool = None
    ''' This data-block is not an independent one, but is actually a sub-data of another ID (typical example: root node trees or master collections)

    :type: bool
    '''

    is_evaluated: bool = None
    ''' Whether this ID is runtime-only, evaluated data-block, or actual data from .blend file

    :type: bool
    '''

    is_library_indirect: bool = None
    ''' Is this ID block linked indirectly

    :type: bool
    '''

    library: 'Library' = None
    ''' Library file the data-block is linked from

    :type: 'Library'
    '''

    name: str = None
    ''' Unique data-block ID name

    :type: str
    '''

    name_full: str = None
    ''' Unique data-block ID name, including library one is any

    :type: str
    '''

    original: 'ID' = None
    ''' Actual data-block from .blend file (Main database) that generated that evaluated one

    :type: 'ID'
    '''

    override_library: 'IDOverrideLibrary' = None
    ''' Library override data

    :type: 'IDOverrideLibrary'
    '''

    preview: 'ImagePreview' = None
    ''' Preview image and icon of this data-block (None if not supported for this type of data)

    :type: 'ImagePreview'
    '''

    tag: bool = None
    ''' Tools can use this to tag data for their own purposes (initial state is undefined)

    :type: bool
    '''

    use_fake_user: bool = None
    ''' Save this data-block even if it has no users

    :type: bool
    '''

    users: int = None
    ''' Number of times this data-block is referenced

    :type: int
    '''

    def evaluated_get(self, depsgraph: 'Depsgraph') -> 'ID':
        ''' Get corresponding evaluated ID from the given dependency graph

        :param depsgraph: Dependency graph to perform lookup in
        :type depsgraph: 'Depsgraph'
        :rtype: 'ID'
        :return: New copy of the ID
        '''
        pass

    def copy(self) -> 'ID':
        ''' Create a copy of this data-block (not supported for all data-blocks)

        :rtype: 'ID'
        :return: New copy of the ID
        '''
        pass

    def override_create(self, remap_local_usages: bool = False) -> 'ID':
        ''' Create an overridden local copy of this linked data-block (not supported for all data-blocks)

        :param remap_local_usages: Whether local usages of the linked ID should be remapped to the new library override of it
        :type remap_local_usages: bool
        :rtype: 'ID'
        :return: New overridden local copy of the ID
        '''
        pass

    def override_template_create(self):
        ''' Create an override template for this ID

        '''
        pass

    def user_clear(self):
        ''' Clear the user count of a data-block so its not saved, on reload the data will be removed This function is for advanced use only, misuse can crash blender since the user count is used to prevent data being removed when it is used.

        '''
        pass

    def user_remap(self, new_id: 'ID'):
        ''' Replace all usage in the .blend file of this ID by new given one

        :param new_id: New ID to use
        :type new_id: 'ID'
        '''
        pass

    def make_local(self, clear_proxy: bool = True) -> 'ID':
        ''' Make this datablock local, return local one (may be a copy of the original, in case it is also indirectly used)

        :param clear_proxy: Whether to clear proxies (the default behavior, note that if object has to be duplicated to be made local, proxies are always cleared)
        :type clear_proxy: bool
        :rtype: 'ID'
        :return: This ID, or the new ID if it was copied
        '''
        pass

    def user_of_id(self, id: 'ID') -> int:
        ''' Count the number of times that ID uses/references given one

        :param id: ID to count usages
        :type id: 'ID'
        :rtype: int
        :return: Number of usages/references of given id by current data-block
        '''
        pass

    def animation_data_create(self) -> 'AnimData':
        ''' Create animation data to this ID, note that not all ID types support this

        :rtype: 'AnimData'
        :return: New animation data or NULL
        '''
        pass

    def animation_data_clear(self):
        ''' Clear animation on this this ID

        '''
        pass

    def update_tag(
            self,
            refresh: typing.Union[typing.Set[str], typing.Set[int]] = {}):
        ''' Tag the ID to update its display data, e.g. when calling bpy.types.Scene.update

        :param refresh: Type of updates to perform
        :type refresh: typing.Union[typing.Set[str], typing.Set[int]]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDMaterials(bpy_struct):
    ''' Collection of materials
    '''

    def append(self, material: 'Material'):
        ''' Add a new material to the data-block

        :param material: Material to add
        :type material: 'Material'
        '''
        pass

    def pop(self, index: int = -1) -> 'Material':
        ''' Remove a material from the data-block

        :param index: Index of material to remove
        :type index: int
        :rtype: 'Material'
        :return: Material to remove
        '''
        pass

    def clear(self):
        ''' Remove all materials from the data-block

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibrary(bpy_struct):
    ''' Struct gathering all data needed by overridden linked IDs
    '''

    properties: typing.Union[
        typing.Dict[str, 'IDOverrideLibraryProperty'], typing.
        List['IDOverrideLibraryProperty'], 'bpy_prop_collection',
        'IDOverrideLibraryProperties'] = None
    ''' List of overridden properties

    :type: typing.Union[typing.Dict[str, 'IDOverrideLibraryProperty'], typing.List['IDOverrideLibraryProperty'], 'bpy_prop_collection', 'IDOverrideLibraryProperties']
    '''

    reference: 'ID' = None
    ''' Linked ID used as reference by this override

    :type: 'ID'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryProperties(bpy_struct):
    ''' Collection of override properties
    '''

    def add(self, rna_path: str) -> 'IDOverrideLibraryProperty':
        ''' Add a property to the override library when it doesn't exist yet

        :param rna_path: RNA Path, RNA-Path of the property to add
        :type rna_path: str
        :rtype: 'IDOverrideLibraryProperty'
        :return: New Property, Newly created override property or existing one
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryProperty(bpy_struct):
    ''' Description of an overridden property
    '''

    operations: typing.Union[
        typing.Dict[str, 'IDOverrideLibraryPropertyOperation'], typing.
        List['IDOverrideLibraryPropertyOperation'], 'bpy_prop_collection',
        'IDOverrideLibraryPropertyOperations'] = None
    ''' List of overriding operations for a property

    :type: typing.Union[typing.Dict[str, 'IDOverrideLibraryPropertyOperation'], typing.List['IDOverrideLibraryPropertyOperation'], 'bpy_prop_collection', 'IDOverrideLibraryPropertyOperations']
    '''

    rna_path: str = None
    ''' RNA path leading to that property, from owning ID

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryPropertyOperation(bpy_struct):
    ''' Description of an override operation over an overridden property
    '''

    flag: typing.Union[str, int] = None
    ''' Optional flags (NOT USED) * MANDATORY Mandatory, For templates, prevents the user from removing predefined operation (NOT USED). * LOCKED Locked, Prevents the user from modifying that override operation (NOT USED).

    :type: typing.Union[str, int]
    '''

    operation: typing.Union[str, int] = None
    ''' What override operation is performed * NOOP No-Op, Does nothing, prevents adding actual overrides (NOT USED). * REPLACE Replace, Replace value of reference by overriding one. * DIFF_ADD Differential, Stores and apply difference between reference and local value (NOT USED). * DIFF_SUB Differential, Stores and apply difference between reference and local value (NOT USED). * FACT_MULTIPLY Factor, Stores and apply multiplication factor between reference and local value (NOT USED). * INSERT_AFTER Insert After, Insert a new item into collection after the one referenced in subitem_reference_name or _index. * INSERT_BEFORE Insert Before, Insert a new item into collection after the one referenced in subitem_reference_name or _index (NOT USED).

    :type: typing.Union[str, int]
    '''

    subitem_local_index: int = None
    ''' Used to handle insertions into collection

    :type: int
    '''

    subitem_local_name: str = None
    ''' Used to handle insertions into collection

    :type: str
    '''

    subitem_reference_index: int = None
    ''' Used to handle insertions into collection

    :type: int
    '''

    subitem_reference_name: str = None
    ''' Used to handle insertions into collection

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryPropertyOperations(bpy_struct):
    ''' Collection of override operations
    '''

    def add(self,
            operation: typing.Union[str, int],
            subitem_reference_name: str = "",
            subitem_local_name: str = "",
            subitem_reference_index: int = -1,
            subitem_local_index: int = -1
            ) -> 'IDOverrideLibraryPropertyOperation':
        ''' Add a new operation

        :param operation: Operation, What override operation is performed * NOOP No-Op, Does nothing, prevents adding actual overrides (NOT USED). * REPLACE Replace, Replace value of reference by overriding one. * DIFF_ADD Differential, Stores and apply difference between reference and local value (NOT USED). * DIFF_SUB Differential, Stores and apply difference between reference and local value (NOT USED). * FACT_MULTIPLY Factor, Stores and apply multiplication factor between reference and local value (NOT USED). * INSERT_AFTER Insert After, Insert a new item into collection after the one referenced in subitem_reference_name or _index. * INSERT_BEFORE Insert Before, Insert a new item into collection after the one referenced in subitem_reference_name or _index (NOT USED).
        :type operation: typing.Union[str, int]
        :param subitem_reference_name: Subitem Reference Name, Used to handle insertions into collection
        :type subitem_reference_name: str
        :param subitem_local_name: Subitem Local Name, Used to handle insertions into collection
        :type subitem_local_name: str
        :param subitem_reference_index: Subitem Reference Index, Used to handle insertions into collection
        :type subitem_reference_index: int
        :param subitem_local_index: Subitem Local Index, Used to handle insertions into collection
        :type subitem_local_index: int
        :rtype: 'IDOverrideLibraryPropertyOperation'
        :return: New Operation, Created operation
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IDPropertyWrapPtr(bpy_struct):
    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IKParam(bpy_struct):
    ''' Base type for IK solver parameters
    '''

    ik_solver: typing.Union[str, int] = None
    ''' IK solver for which these parameters are defined * LEGACY Standard, Original IK solver. * ITASC iTaSC, Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ImageFormatSettings(bpy_struct):
    ''' Settings for image formats
    '''

    cineon_black: int = None
    ''' Log conversion reference blackpoint

    :type: int
    '''

    cineon_gamma: float = None
    ''' Log conversion gamma

    :type: float
    '''

    cineon_white: int = None
    ''' Log conversion reference whitepoint

    :type: int
    '''

    color_depth: typing.Union[str, int] = None
    ''' Bit depth per channel * 8 8, 8-bit color channels. * 10 10, 10-bit color channels. * 12 12, 12-bit color channels. * 16 16, 16-bit color channels. * 32 32, 32-bit color channels.

    :type: typing.Union[str, int]
    '''

    color_mode: typing.Union[str, int] = None
    ''' Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels * BW BW, Images get saved in 8-bit grayscale (only PNG, JPEG, TGA, TIF). * RGB RGB, Images are saved with RGB (color) data. * RGBA RGBA, Images are saved with RGB and Alpha data (if supported).

    :type: typing.Union[str, int]
    '''

    compression: int = None
    ''' Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output

    :type: int
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    ''' Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    '''

    exr_codec: typing.Union[str, int] = None
    ''' Codec settings for OpenEXR

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    ''' File format to save the rendered images as * BMP BMP, Output image in bitmap format. * IRIS Iris, Output image in SGI IRIS format. * PNG PNG, Output image in PNG format. * JPEG JPEG, Output image in JPEG format. * JPEG2000 JPEG 2000, Output image in JPEG 2000 format. * TARGA Targa, Output image in Targa format. * TARGA_RAW Targa Raw, Output image in uncompressed Targa format. * CINEON Cineon, Output image in Cineon format. * DPX DPX, Output image in DPX format. * OPEN_EXR_MULTILAYER OpenEXR MultiLayer, Output image in multilayer OpenEXR format. * OPEN_EXR OpenEXR, Output image in OpenEXR format. * HDR Radiance HDR, Output image in Radiance HDR format. * TIFF TIFF, Output image in TIFF format. * AVI_JPEG AVI JPEG, Output video in AVI JPEG format. * AVI_RAW AVI Raw, Output video in AVI Raw format. * FFMPEG FFmpeg Video, The most versatile way to output video files.

    :type: typing.Union[str, int]
    '''

    jpeg2k_codec: typing.Union[str, int] = None
    ''' Codec settings for Jpeg2000

    :type: typing.Union[str, int]
    '''

    quality: int = None
    ''' Quality for image formats that support lossy compression

    :type: int
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    ''' Settings for stereo 3D

    :type: 'Stereo3dFormat'
    '''

    tiff_codec: typing.Union[str, int] = None
    ''' Compression mode for TIFF

    :type: typing.Union[str, int]
    '''

    use_cineon_log: bool = None
    ''' Convert to logarithmic color space

    :type: bool
    '''

    use_jpeg2k_cinema_48: bool = None
    ''' Use Openjpeg Cinema Preset (48fps)

    :type: bool
    '''

    use_jpeg2k_cinema_preset: bool = None
    ''' Use Openjpeg Cinema Preset

    :type: bool
    '''

    use_jpeg2k_ycc: bool = None
    ''' Save luminance-chrominance-chrominance channels instead of RGB colors

    :type: bool
    '''

    use_preview: bool = None
    ''' When rendering animations, save JPG preview images in same directory

    :type: bool
    '''

    use_zbuffer: bool = None
    ''' Save the z-depth per pixel (32-bit unsigned integer z-buffer)

    :type: bool
    '''

    view_settings: 'ColorManagedViewSettings' = None
    ''' Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    '''

    views_format: typing.Union[str, int] = None
    ''' Format of multiview media * INDIVIDUAL Individual, Individual files for each view with the prefix as defined by the scene views. * STEREO_3D Stereo 3D, Single file with an encoded stereo pair.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ImagePackedFile(bpy_struct):
    filepath: str = None
    ''' 

    :type: str
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    def save(self):
        ''' Save the packed file to its filepath

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ImagePreview(bpy_struct):
    ''' Preview image and icon
    '''

    icon_id: int = None
    ''' Unique integer identifying this preview as an icon (zero means invalid)

    :type: int
    '''

    icon_pixels: int = None
    ''' Icon pixels, as bytes (always 32-bit RGBA)

    :type: int
    '''

    icon_pixels_float: float = None
    ''' Icon pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    icon_size: typing.List[int] = None
    ''' Width and height in pixels

    :type: typing.List[int]
    '''

    image_pixels: int = None
    ''' Image pixels, as bytes (always 32-bit RGBA)

    :type: int
    '''

    image_pixels_float: float = None
    ''' Image pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    image_size: typing.List[int] = None
    ''' Width and height in pixels

    :type: typing.List[int]
    '''

    is_icon_custom: bool = None
    ''' True if this preview icon has been modified by py script,and is no more auto-generated by Blender

    :type: bool
    '''

    is_image_custom: bool = None
    ''' True if this preview image has been modified by py script,and is no more auto-generated by Blender

    :type: bool
    '''

    def reload(self):
        ''' Reload the preview from its source path

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ImageUser(bpy_struct):
    ''' Parameters defining how an Image data-block is used by another data-block
    '''

    frame_current: int = None
    ''' Current frame number in image sequence or movie

    :type: int
    '''

    frame_duration: int = None
    ''' Number of images of a movie to use

    :type: int
    '''

    frame_offset: int = None
    ''' Offset the number of the frame to use in the animation

    :type: int
    '''

    frame_start: int = None
    ''' Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    '''

    multilayer_layer: int = None
    ''' Layer in multilayer image

    :type: int
    '''

    multilayer_pass: int = None
    ''' Pass in multilayer image

    :type: int
    '''

    multilayer_view: int = None
    ''' View in multilayer image

    :type: int
    '''

    tile: int = None
    ''' Tile in tiled image

    :type: int
    '''

    use_auto_refresh: bool = None
    ''' Always refresh image on frame changes

    :type: bool
    '''

    use_cyclic: bool = None
    ''' Cycle the images in the movie

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class IntAttributeValue(bpy_struct):
    ''' Integer value in geometry attribute
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyConfig(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    is_user_defined: bool = None
    ''' Indicates that a keyconfig was defined by the user

    :type: bool
    '''

    keymaps: typing.Union[typing.Dict[str, 'KeyMap'], typing.List['KeyMap'],
                          'bpy_prop_collection', 'KeyMaps'] = None
    ''' Key maps configured as part of this configuration

    :type: typing.Union[typing.Dict[str, 'KeyMap'], typing.List['KeyMap'], 'bpy_prop_collection', 'KeyMaps']
    '''

    name: str = None
    ''' Name of the key configuration

    :type: str
    '''

    preferences: 'KeyConfigPreferences' = None
    ''' 

    :type: 'KeyConfigPreferences'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyConfigPreferences(bpy_struct):
    bl_idname: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyConfigurations(bpy_struct):
    ''' Collection of KeyConfigs
    '''

    active: 'KeyConfig' = None
    ''' Active key configuration (preset)

    :type: 'KeyConfig'
    '''

    addon: 'KeyConfig' = None
    ''' Key configuration that can be extended by add-ons, and is added to the active configuration when handling events

    :type: 'KeyConfig'
    '''

    default: 'KeyConfig' = None
    ''' Default builtin key configuration

    :type: 'KeyConfig'
    '''

    user: 'KeyConfig' = None
    ''' Final key configuration that combines keymaps from the active and add-on configurations, and can be edited by the user

    :type: 'KeyConfig'
    '''

    def new(self, name: str) -> 'KeyConfig':
        ''' new

        :param name: Name
        :type name: str
        :rtype: 'KeyConfig'
        :return: Key Configuration, Added key configuration
        '''
        pass

    def remove(self, keyconfig: 'KeyConfig'):
        ''' remove

        :param keyconfig: Key Configuration, Removed key configuration
        :type keyconfig: 'KeyConfig'
        '''
        pass

    def find_item_from_operator(
            self,
            idname: str,
            context: typing.Union[str, int] = 'INVOKE_DEFAULT',
            properties: 'OperatorProperties' = None,
            include: typing.Union[typing.Set[str], typing.Set[int]] = {
                'ACTIONZONE', 'KEYBOARD', 'MOUSE', 'NDOF', 'TWEAK'
            },
            exclude: typing.Union[typing.Set[str], typing.Set[int]] = {}):
        ''' find_item_from_operator

        :param idname: Operator Identifier
        :type idname: str
        :param context: context
        :type context: typing.Union[str, int]
        :param properties: 
        :type properties: 'OperatorProperties'
        :param include: Include
        :type include: typing.Union[typing.Set[str], typing.Set[int]]
        :param exclude: Exclude
        :type exclude: typing.Union[typing.Set[str], typing.Set[int]]
        '''
        pass

    def update(self):
        ''' update

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyMap(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    bl_owner_id: str = None
    ''' Internal owner

    :type: str
    '''

    is_modal: bool = None
    ''' Indicates that a keymap is used for translate modal events for an operator

    :type: bool
    '''

    is_user_modified: bool = None
    ''' Keymap is defined by the user

    :type: bool
    '''

    keymap_items: typing.Union[typing.Dict[str, 'KeyMapItem'], typing.
                               List['KeyMapItem'], 'bpy_prop_collection',
                               'KeyMapItems'] = None
    ''' Items in the keymap, linking an operator to an input event

    :type: typing.Union[typing.Dict[str, 'KeyMapItem'], typing.List['KeyMapItem'], 'bpy_prop_collection', 'KeyMapItems']
    '''

    name: str = None
    ''' Name of the key map

    :type: str
    '''

    region_type: typing.Union[str, int] = None
    ''' Optional region type keymap is associated with

    :type: typing.Union[str, int]
    '''

    show_expanded_children: bool = None
    ''' Children expanded in the user interface

    :type: bool
    '''

    show_expanded_items: bool = None
    ''' Expanded in the user interface

    :type: bool
    '''

    space_type: typing.Union[str, int] = None
    ''' Optional space type keymap is associated with * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    def active(self) -> 'KeyMap':
        ''' active

        :rtype: 'KeyMap'
        :return: Key Map, Active key map
        '''
        pass

    def restore_to_default(self):
        ''' restore_to_default

        '''
        pass

    def restore_item_to_default(self, item: 'KeyMapItem'):
        ''' restore_item_to_default

        :param item: Item
        :type item: 'KeyMapItem'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyMapItem(bpy_struct):
    ''' Item in a Key Map
    '''

    active: bool = None
    ''' Activate or deactivate item

    :type: bool
    '''

    alt: bool = None
    ''' Alt key pressed

    :type: bool
    '''

    any: bool = None
    ''' Any modifier keys pressed

    :type: bool
    '''

    ctrl: bool = None
    ''' Control key pressed

    :type: bool
    '''

    id: int = None
    ''' ID of the item

    :type: int
    '''

    idname: str = None
    ''' Identifier of operator to call on input event

    :type: str
    '''

    is_user_defined: bool = None
    ''' Is this keymap item user defined (doesn't just replace a builtin item)

    :type: bool
    '''

    is_user_modified: bool = None
    ''' Is this keymap item modified by the user

    :type: bool
    '''

    key_modifier: typing.Union[str, int] = None
    ''' Regular key pressed as a modifier * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.

    :type: typing.Union[str, int]
    '''

    map_type: typing.Union[str, int] = None
    ''' Type of event mapping

    :type: typing.Union[str, int]
    '''

    name: str = None
    ''' Name of operator (translated) to call on input event

    :type: str
    '''

    oskey: bool = None
    ''' Operating system key pressed

    :type: bool
    '''

    properties: 'OperatorProperties' = None
    ''' Properties to set when the operator is called

    :type: 'OperatorProperties'
    '''

    propvalue: typing.Union[str, int] = None
    ''' The value this event translates to in a modal keymap

    :type: typing.Union[str, int]
    '''

    repeat: bool = None
    ''' Active on key-repeat events (when a key is held)

    :type: bool
    '''

    shift: bool = None
    ''' Shift key pressed

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show key map event and property details in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of event * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.

    :type: typing.Union[str, int]
    '''

    value: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    def compare(self, item: 'KeyMapItem') -> bool:
        ''' compare

        :param item: Item
        :type item: 'KeyMapItem'
        :rtype: bool
        :return: Comparison result
        '''
        pass

    def to_string(self, compact: bool = False) -> str:
        ''' to_string

        :param compact: Compact
        :type compact: bool
        :rtype: str
        :return: result
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyMapItems(bpy_struct):
    ''' Collection of keymap items
    '''

    def new(self,
            idname: str,
            type: typing.Union[str, int],
            value: typing.Union[str, int],
            any: bool = False,
            shift: bool = False,
            ctrl: bool = False,
            alt: bool = False,
            oskey: bool = False,
            key_modifier: typing.Union[str, int] = 'NONE',
            repeat: bool = False,
            head: bool = False) -> 'KeyMapItem':
        ''' new

        :param idname: Operator Identifier
        :type idname: str
        :param type: Type * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.
        :type type: typing.Union[str, int]
        :param value: Value
        :type value: typing.Union[str, int]
        :param any: Any
        :type any: bool
        :param shift: Shift
        :type shift: bool
        :param ctrl: Ctrl
        :type ctrl: bool
        :param alt: Alt
        :type alt: bool
        :param oskey: OS Key
        :type oskey: bool
        :param key_modifier: Key Modifier * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.
        :type key_modifier: typing.Union[str, int]
        :param repeat: Repeat, When set, accept key-repeat events
        :type repeat: bool
        :param head: At Head, Force item to be added at start (not end) of key map so that it doesn't get blocked by an existing key map item
        :type head: bool
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        '''
        pass

    def new_modal(self,
                  propvalue: str,
                  type: typing.Union[str, int],
                  value: typing.Union[str, int],
                  any: bool = False,
                  shift: bool = False,
                  ctrl: bool = False,
                  alt: bool = False,
                  oskey: bool = False,
                  key_modifier: typing.Union[str, int] = 'NONE',
                  repeat: bool = False) -> 'KeyMapItem':
        ''' new_modal

        :param propvalue: Property Value
        :type propvalue: str
        :param type: Type * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.
        :type type: typing.Union[str, int]
        :param value: Value
        :type value: typing.Union[str, int]
        :param any: Any
        :type any: bool
        :param shift: Shift
        :type shift: bool
        :param ctrl: Ctrl
        :type ctrl: bool
        :param alt: Alt
        :type alt: bool
        :param oskey: OS Key
        :type oskey: bool
        :param key_modifier: Key Modifier * NONE Undocumented. * LEFTMOUSE Left Mouse, LMB. * MIDDLEMOUSE Middle Mouse, MMB. * RIGHTMOUSE Right Mouse, RMB. * BUTTON4MOUSE Button4 Mouse, MB4. * BUTTON5MOUSE Button5 Mouse, MB5. * BUTTON6MOUSE Button6 Mouse, MB6. * BUTTON7MOUSE Button7 Mouse, MB7. * PEN Pen. * ERASER Eraser. * MOUSEMOVE Mouse Move, MsMov. * INBETWEEN_MOUSEMOVE In-between Move, MsSubMov. * TRACKPADPAN Mouse/Trackpad Pan, MsPan. * TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom. * MOUSEROTATE Mouse/Trackpad Rotate, MsRot. * MOUSESMARTZOOM Mouse/Trackpad Smart Zoom, MsSmartZoom. * WHEELUPMOUSE Wheel Up, WhUp. * WHEELDOWNMOUSE Wheel Down, WhDown. * WHEELINMOUSE Wheel In, WhIn. * WHEELOUTMOUSE Wheel Out, WhOut. * EVT_TWEAK_L Tweak Left, TwkL. * EVT_TWEAK_M Tweak Middle, TwkM. * EVT_TWEAK_R Tweak Right, TwkR. * A A. * B B. * C C. * D D. * E E. * F F. * G G. * H H. * I I. * J J. * K K. * L L. * M M. * N N. * O O. * P P. * Q Q. * R R. * S S. * T T. * U U. * V V. * W W. * X X. * Y Y. * Z Z. * ZERO 0. * ONE 1. * TWO 2. * THREE 3. * FOUR 4. * FIVE 5. * SIX 6. * SEVEN 7. * EIGHT 8. * NINE 9. * LEFT_CTRL Left Ctrl, CtrlL. * LEFT_ALT Left Alt, AltL. * LEFT_SHIFT Left Shift, ShiftL. * RIGHT_ALT Right Alt, AltR. * RIGHT_CTRL Right Ctrl, CtrlR. * RIGHT_SHIFT Right Shift, ShiftR. * OSKEY OS Key, Cmd. * APP Application, App. * GRLESS Grless. * ESC Esc. * TAB Tab. * RET Return, Enter. * SPACE Spacebar, Space. * LINE_FEED Line Feed. * BACK_SPACE Backspace, BkSpace. * DEL Delete, Del. * SEMI_COLON ;. * PERIOD .. * COMMA ,. * QUOTE ". * ACCENT_GRAVE \ . * MINUS -. * PLUS +. * SLASH /. * BACK_SLASH \\. * EQUAL =. * LEFT_BRACKET [. * RIGHT_BRACKET ]. * LEFT_ARROW Left Arrow, ←. * DOWN_ARROW Down Arrow, ↓. * RIGHT_ARROW Right Arrow, →. * UP_ARROW Up Arrow, ↑. * NUMPAD_2 Numpad 2, Pad2. * NUMPAD_4 Numpad 4, Pad4. * NUMPAD_6 Numpad 6, Pad6. * NUMPAD_8 Numpad 8, Pad8. * NUMPAD_1 Numpad 1, Pad1. * NUMPAD_3 Numpad 3, Pad3. * NUMPAD_5 Numpad 5, Pad5. * NUMPAD_7 Numpad 7, Pad7. * NUMPAD_9 Numpad 9, Pad9. * NUMPAD_PERIOD Numpad ., Pad.. * NUMPAD_SLASH Numpad /, Pad/. * NUMPAD_ASTERIX Numpad \*, Pad\*. * NUMPAD_0 Numpad 0, Pad0. * NUMPAD_MINUS Numpad -, Pad-. * NUMPAD_ENTER Numpad Enter, PadEnter. * NUMPAD_PLUS Numpad +, Pad+. * F1 F1. * F2 F2. * F3 F3. * F4 F4. * F5 F5. * F6 F6. * F7 F7. * F8 F8. * F9 F9. * F10 F10. * F11 F11. * F12 F12. * F13 F13. * F14 F14. * F15 F15. * F16 F16. * F17 F17. * F18 F18. * F19 F19. * F20 F20. * F21 F21. * F22 F22. * F23 F23. * F24 F24. * PAUSE Pause. * INSERT Insert, Ins. * HOME Home. * PAGE_UP Page Up, PgUp. * PAGE_DOWN Page Down, PgDown. * END End. * MEDIA_PLAY Media Play/Pause, >/\|\|. * MEDIA_STOP Media Stop, Stop. * MEDIA_FIRST Media First, \|<<. * MEDIA_LAST Media Last, >>\|. * TEXTINPUT Text Input, TxtIn. * WINDOW_DEACTIVATE Window Deactivate. * TIMER Timer, Tmr. * TIMER0 Timer 0, Tmr0. * TIMER1 Timer 1, Tmr1. * TIMER2 Timer 2, Tmr2. * TIMER_JOBS Timer Jobs, TmrJob. * TIMER_AUTOSAVE Timer Autosave, TmrSave. * TIMER_REPORT Timer Report, TmrReport. * TIMERREGION Timer Region, TmrReg. * NDOF_MOTION NDOF Motion, NdofMov. * NDOF_BUTTON_MENU NDOF Menu, NdofMenu. * NDOF_BUTTON_FIT NDOF Fit, NdofFit. * NDOF_BUTTON_TOP NDOF Top, Ndof↑. * NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓. * NDOF_BUTTON_LEFT NDOF Left, Ndof←. * NDOF_BUTTON_RIGHT NDOF Right, Ndof→. * NDOF_BUTTON_FRONT NDOF Front, NdofFront. * NDOF_BUTTON_BACK NDOF Back, NdofBack. * NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1. * NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2. * NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW. * NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW. * NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW. * NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW. * NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW. * NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW. * NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot. * NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom. * NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom. * NDOF_BUTTON_PLUS NDOF Plus, Ndof+. * NDOF_BUTTON_MINUS NDOF Minus, Ndof-. * NDOF_BUTTON_ESC NDOF Esc, NdofEsc. * NDOF_BUTTON_ALT NDOF Alt, NdofAlt. * NDOF_BUTTON_SHIFT NDOF Shift, NdofShift. * NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl. * NDOF_BUTTON_1 NDOF Button 1, NdofB1. * NDOF_BUTTON_2 NDOF Button 2, NdofB2. * NDOF_BUTTON_3 NDOF Button 3, NdofB3. * NDOF_BUTTON_4 NDOF Button 4, NdofB4. * NDOF_BUTTON_5 NDOF Button 5, NdofB5. * NDOF_BUTTON_6 NDOF Button 6, NdofB6. * NDOF_BUTTON_7 NDOF Button 7, NdofB7. * NDOF_BUTTON_8 NDOF Button 8, NdofB8. * NDOF_BUTTON_9 NDOF Button 9, NdofB9. * NDOF_BUTTON_10 NDOF Button 10, NdofB10. * NDOF_BUTTON_A NDOF Button A, NdofBA. * NDOF_BUTTON_B NDOF Button B, NdofBB. * NDOF_BUTTON_C NDOF Button C, NdofBC. * ACTIONZONE_AREA ActionZone Area, AZone Area. * ACTIONZONE_REGION ActionZone Region, AZone Region. * ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr.
        :type key_modifier: typing.Union[str, int]
        :param repeat: Repeat, When set, accept key-repeat events
        :type repeat: bool
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        '''
        pass

    def new_from_item(self, item: 'KeyMapItem',
                      head: bool = False) -> 'KeyMapItem':
        ''' new_from_item

        :param item: Item, Item to use as a reference
        :type item: 'KeyMapItem'
        :param head: At Head
        :type head: bool
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        '''
        pass

    def remove(self, item: 'KeyMapItem'):
        ''' remove

        :param item: Item
        :type item: 'KeyMapItem'
        '''
        pass

    def from_id(self, id: int) -> 'KeyMapItem':
        ''' from_id

        :param id: id, ID of the item
        :type id: int
        :rtype: 'KeyMapItem'
        :return: Item
        '''
        pass

    def find_from_operator(
            self,
            idname: str,
            properties: 'OperatorProperties' = None,
            include: typing.Union[typing.Set[str], typing.Set[int]] = {
                'ACTIONZONE', 'KEYBOARD', 'MOUSE', 'NDOF', 'TWEAK'
            },
            exclude: typing.Union[typing.Set[str], typing.Set[int]] = {}):
        ''' find_from_operator

        :param idname: Operator Identifier
        :type idname: str
        :param properties: 
        :type properties: 'OperatorProperties'
        :param include: Include
        :type include: typing.Union[typing.Set[str], typing.Set[int]]
        :param exclude: Exclude
        :type exclude: typing.Union[typing.Set[str], typing.Set[int]]
        '''
        pass

    def match_event(self, event: 'Event'):
        ''' match_event

        :param event: 
        :type event: 'Event'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyMaps(bpy_struct):
    ''' Collection of keymaps
    '''

    def new(self,
            name: str,
            space_type: typing.Union[str, int] = 'EMPTY',
            region_type: typing.Union[str, int] = 'WINDOW',
            modal: bool = False,
            tool: bool = False) -> 'KeyMap':
        ''' Ensure the keymap exists. This will return the one with the given name/space type/region type, or create a new one if it does not exist yet.

        :param name: Name
        :type name: str
        :param space_type: Space Type * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.
        :type space_type: typing.Union[str, int]
        :param region_type: Region Type
        :type region_type: typing.Union[str, int]
        :param modal: Modal, Keymap for modal operators
        :type modal: bool
        :param tool: Tool, Keymap for active tools
        :type tool: bool
        :rtype: 'KeyMap'
        :return: Key Map, Added key map
        '''
        pass

    def remove(self, keymap: 'KeyMap'):
        ''' remove

        :param keymap: Key Map, Removed key map
        :type keymap: 'KeyMap'
        '''
        pass

    def find(self,
             name: str,
             space_type: typing.Union[str, int] = 'EMPTY',
             region_type: typing.Union[str, int] = 'WINDOW') -> 'KeyMap':
        ''' find

        :param name: Name
        :type name: str
        :param space_type: Space Type * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.
        :type space_type: typing.Union[str, int]
        :param region_type: Region Type
        :type region_type: typing.Union[str, int]
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        '''
        pass

    def find_modal(self, name: str) -> 'KeyMap':
        ''' find_modal

        :param name: Operator Name
        :type name: str
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Keyframe(bpy_struct):
    ''' Bezier curve point with two handles defining a Keyframe on an F-Curve
    '''

    amplitude: float = None
    ''' Amount to boost elastic bounces for 'elastic' easing

    :type: float
    '''

    back: float = None
    ''' Amount of overshoot for 'back' easing

    :type: float
    '''

    co: typing.List[float] = None
    ''' Coordinates of the control point

    :type: typing.List[float]
    '''

    co_ui: typing.List[float] = None
    ''' Coordinates of the control point. Note: Changing this value also updates the handles similar to using the graph editor transform operator

    :type: typing.List[float]
    '''

    easing: typing.Union[str, int] = None
    ''' Which ends of the segment between this and the next keyframe easing interpolation is applied to * AUTO Automatic Easing, Easing type is chosen automatically based on what the type of interpolation used (e.g. Ease In for transitional types, and Ease Out for dynamic effects). * EASE_IN Ease In, Only on the end closest to the next keyframe. * EASE_OUT Ease Out, Only on the end closest to the first keyframe. * EASE_IN_OUT Ease In and Out, Segment between both keyframes.

    :type: typing.Union[str, int]
    '''

    handle_left: typing.List[float] = None
    ''' Coordinates of the left handle (before the control point)

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types * FREE Free, Completely independent manually set handle. * ALIGNED Aligned, Manually set handle with rotation locked together with its pair. * VECTOR Vector, Automatic handles that create straight lines. * AUTO Automatic, Automatic handles that create smooth curves. * AUTO_CLAMPED Auto Clamped, Automatic handles that create smooth curves which only change direction at keyframes.

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    ''' Coordinates of the right handle (after the control point)

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types * FREE Free, Completely independent manually set handle. * ALIGNED Aligned, Manually set handle with rotation locked together with its pair. * VECTOR Vector, Automatic handles that create straight lines. * AUTO Automatic, Automatic handles that create smooth curves. * AUTO_CLAMPED Auto Clamped, Automatic handles that create smooth curves which only change direction at keyframes.

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe * CONSTANT Constant, No interpolation, value of A gets held until B is encountered. * LINEAR Linear, Straight-line interpolation between A and B (i.e. no ease in/out). * BEZIER Bezier, Smooth interpolation between A and B, with some control over curve shape. * SINE Sinusoidal, Sinusoidal easing (weakest, almost linear but with a slight curvature). * QUAD Quadratic, Quadratic easing. * CUBIC Cubic, Cubic easing. * QUART Quartic, Quartic easing. * QUINT Quintic, Quintic easing. * EXPO Exponential, Exponential easing (dramatic). * CIRC Circular, Circular easing (strongest and most dynamic). * BACK Back, Cubic easing with overshoot and settle. * BOUNCE Bounce, Exponentially decaying parabolic bounce, like when objects collide. * ELASTIC Elastic, Exponentially decaying sine wave, like an elastic band.

    :type: typing.Union[str, int]
    '''

    period: float = None
    ''' Time between bounces for elastic easing

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Left handle selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Right handle selection status

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of keyframe (for visual purposes only) * KEYFRAME Keyframe, Normal keyframe, e.g. for key poses. * BREAKDOWN Breakdown, A breakdown pose, e.g. for transitions between key poses. * MOVING_HOLD Moving Hold, A keyframe that is part of a moving hold. * EXTREME Extreme, An "extreme" pose, or some other purpose as needed. * JITTER Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSet(bpy_struct):
    ''' Settings that should be keyframed together
    '''

    bl_description: str = None
    ''' A short description of the keying set

    :type: str
    '''

    bl_idname: str = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    is_path_absolute: bool = None
    ''' Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info)

    :type: bool
    '''

    paths: typing.Union[typing.Dict[str, 'KeyingSetPath'], typing.
                        List['KeyingSetPath'], 'bpy_prop_collection',
                        'KeyingSetPaths'] = None
    ''' Keying Set Paths to define settings that get keyframed together

    :type: typing.Union[typing.Dict[str, 'KeyingSetPath'], typing.List['KeyingSetPath'], 'bpy_prop_collection', 'KeyingSetPaths']
    '''

    type_info: 'KeyingSetInfo' = None
    ''' Callback function defines for built-in Keying Sets

    :type: 'KeyingSetInfo'
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''

    def refresh(self):
        ''' Refresh Keying Set to ensure that it is valid for the current context (call before each use of one)

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSetInfo(bpy_struct):
    ''' Callback function defines for builtin Keying Sets
    '''

    bl_description: str = None
    ''' A short description of the keying set

    :type: str
    '''

    bl_idname: str = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Keying Set options to use when inserting keyframes * INSERTKEY_NEEDED Only Needed, Only insert keyframes where they're needed in the relevant F-Curves. * INSERTKEY_VISUAL Visual Keying, Insert keyframes based on 'visual transforms'. * INSERTKEY_XYZ_TO_RGB XYZ=RGB Colors, Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    def poll(self, context: 'Context'):
        ''' Test if Keying Set can be used or not

        :param context: 
        :type context: 'Context'
        '''
        pass

    def iterator(self, context: 'Context', ks: 'KeyingSet'):
        ''' Call generate() on the structs which have properties to be keyframed

        :param context: 
        :type context: 'Context'
        :param ks: 
        :type ks: 'KeyingSet'
        '''
        pass

    def generate(self, context: 'Context', ks: 'KeyingSet', data: 'AnyType'):
        ''' Add Paths to the Keying Set to keyframe the properties of the given data

        :param context: 
        :type context: 'Context'
        :param ks: 
        :type ks: 'KeyingSet'
        :param data: 
        :type data: 'AnyType'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSetPath(bpy_struct):
    ''' Path to a setting for use in a Keying Set
    '''

    array_index: int = None
    ''' Index to the specific setting if applicable

    :type: int
    '''

    data_path: str = None
    ''' Path to property setting

    :type: str
    '''

    group: str = None
    ''' Name of Action Group to assign setting(s) for this path to

    :type: str
    '''

    group_method: typing.Union[str, int] = None
    ''' Method used to define which Group-name to use

    :type: typing.Union[str, int]
    '''

    id: 'ID' = None
    ''' ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    use_entire_array: bool = None
    ''' When an 'array/vector' type is chosen (Location, Rotation, Color, etc.), entire array is to be used

    :type: bool
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSetPaths(bpy_struct):
    ''' Collection of keying set paths
    '''

    active: 'KeyingSetPath' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSetPath'
    '''

    active_index: int = None
    ''' Current Keying Set index

    :type: int
    '''

    def add(self,
            target_id: 'ID',
            data_path: str,
            index: int = -1,
            group_method: typing.Union[str, int] = 'KEYINGSET',
            group_name: str = "") -> 'KeyingSetPath':
        ''' Add a new path for the Keying Set

        :param target_id: Target ID, ID data-block for the destination
        :type target_id: 'ID'
        :param data_path: Data-Path, RNA-Path to destination property
        :type data_path: str
        :param index: Index, The index of the destination property (i.e. axis of Location/Rotation/etc.), or -1 for the entire array
        :type index: int
        :param group_method: Grouping Method, Method used to define which Group-name to use
        :type group_method: typing.Union[str, int]
        :param group_name: Group Name, Name of Action Group to assign destination to (only if grouping mode is to use this name)
        :type group_name: str
        :rtype: 'KeyingSetPath'
        :return: New Path, Path created and added to the Keying Set
        '''
        pass

    def remove(self, path: 'KeyingSetPath'):
        ''' Remove the given path from the Keying Set

        :param path: Path
        :type path: 'KeyingSetPath'
        '''
        pass

    def clear(self):
        ''' Remove all the paths from the Keying Set

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSets(bpy_struct):
    ''' Scene keying sets
    '''

    active: 'KeyingSet' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    '''

    active_index: int = None
    ''' Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    '''

    def new(self, idname: str = "KeyingSet",
            name: str = "KeyingSet") -> 'KeyingSet':
        ''' Add a new Keying Set to Scene

        :param idname: IDName, Internal identifier of Keying Set
        :type idname: str
        :param name: Name, User visible name of Keying Set
        :type name: str
        :rtype: 'KeyingSet'
        :return: Newly created Keying Set
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class KeyingSetsAll(bpy_struct):
    ''' All available keying sets
    '''

    active: 'KeyingSet' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    '''

    active_index: int = None
    ''' Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LatticePoint(bpy_struct):
    ''' Point in the lattice grid
    '''

    co: typing.List[float] = None
    ''' Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)

    :type: typing.List[float]
    '''

    co_deform: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.Dict[str, 'VertexGroupElement'], typing.
                         List['VertexGroupElement'],
                         'bpy_prop_collection'] = None
    ''' Weights for the vertex groups this point is member of

    :type: typing.Union[typing.Dict[str, 'VertexGroupElement'], typing.List['VertexGroupElement'], 'bpy_prop_collection']
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LayerCollection(bpy_struct):
    ''' Layer collection
    '''

    children: typing.Union[typing.Dict[str, 'LayerCollection'], typing.
                           List['LayerCollection'],
                           'bpy_prop_collection'] = None
    ''' Child layer collections

    :type: typing.Union[typing.Dict[str, 'LayerCollection'], typing.List['LayerCollection'], 'bpy_prop_collection']
    '''

    collection: 'Collection' = None
    ''' Collection this layer collection is wrapping

    :type: 'Collection'
    '''

    exclude: bool = None
    ''' Exclude from view layer

    :type: bool
    '''

    hide_viewport: bool = None
    ''' Temporarily hide in viewport

    :type: bool
    '''

    holdout: bool = None
    ''' Mask out objects in collection from view layer

    :type: bool
    '''

    indirect_only: bool = None
    ''' Objects in collection only contribute indirectly (through shadows and reflections) in the view layer

    :type: bool
    '''

    is_visible: bool = None
    ''' Whether this collection is visible for the view layer, take into account the collection parent

    :type: bool
    '''

    name: str = None
    ''' Name of this view layer (same as its collection one)

    :type: str
    '''

    def visible_get(self):
        ''' Whether this collection is visible, take into account the collection parent and the viewport

        '''
        pass

    def has_objects(self):
        ''' 

        '''
        pass

    def has_selected_objects(self, view_layer: 'ViewLayer'):
        ''' 

        :param view_layer: View layer the layer collection belongs to
        :type view_layer: 'ViewLayer'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LayerObjects(bpy_struct):
    ''' Collections of objects
    '''

    active: 'Object' = None
    ''' Active object for this layer

    :type: 'Object'
    '''

    selected: typing.Union[typing.Dict[str, 'Object'], typing.
                           List['Object'], 'bpy_prop_collection'] = None
    ''' All the selected objects of this layer

    :type: typing.Union[typing.Dict[str, 'Object'], typing.List['Object'], 'bpy_prop_collection']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleAlphaModifiers(bpy_struct):
    ''' Alpha modifiers for changing line alphas
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleAlphaModifier':
        ''' Add a alpha modifier to line style

        :param name: New name for the alpha modifier (not unique)
        :type name: str
        :param type: Alpha modifier type to add
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleAlphaModifier'
        :return: Newly added alpha modifier
        '''
        pass

    def remove(self, modifier: 'LineStyleAlphaModifier'):
        ''' Remove a alpha modifier from line style

        :param modifier: Alpha modifier to remove
        :type modifier: 'LineStyleAlphaModifier'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleColorModifiers(bpy_struct):
    ''' Color modifiers for changing line colors
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleColorModifier':
        ''' Add a color modifier to line style

        :param name: New name for the color modifier (not unique)
        :type name: str
        :param type: Color modifier type to add
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleColorModifier'
        :return: Newly added color modifier
        '''
        pass

    def remove(self, modifier: 'LineStyleColorModifier'):
        ''' Remove a color modifier from line style

        :param modifier: Color modifier to remove
        :type modifier: 'LineStyleColorModifier'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleGeometryModifiers(bpy_struct):
    ''' Geometry modifiers for changing line geometries
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleGeometryModifier':
        ''' Add a geometry modifier to line style

        :param name: New name for the geometry modifier (not unique)
        :type name: str
        :param type: Geometry modifier type to add
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleGeometryModifier'
        :return: Newly added geometry modifier
        '''
        pass

    def remove(self, modifier: 'LineStyleGeometryModifier'):
        ''' Remove a geometry modifier from line style

        :param modifier: Geometry modifier to remove
        :type modifier: 'LineStyleGeometryModifier'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleModifier(bpy_struct):
    ''' Base type to define modifiers
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleTextureSlots(bpy_struct):
    ''' Collection of texture slots
    '''

    @classmethod
    def add(cls) -> 'LineStyleTextureSlot':
        ''' add

        :rtype: 'LineStyleTextureSlot'
        :return: The newly initialized mtex
        '''
        pass

    @classmethod
    def create(cls, index: int) -> 'LineStyleTextureSlot':
        ''' create

        :param index: Index, Slot index to initialize
        :type index: int
        :rtype: 'LineStyleTextureSlot'
        :return: The newly initialized mtex
        '''
        pass

    @classmethod
    def clear(cls, index: int):
        ''' clear

        :param index: Index, Slot index to clear
        :type index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LineStyleThicknessModifiers(bpy_struct):
    ''' Thickness modifiers for changing line thickness
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleThicknessModifier':
        ''' Add a thickness modifier to line style

        :param name: New name for the thickness modifier (not unique)
        :type name: str
        :param type: Thickness modifier type to add
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleThicknessModifier'
        :return: Newly added thickness modifier
        '''
        pass

    def remove(self, modifier: 'LineStyleThicknessModifier'):
        ''' Remove a thickness modifier from line style

        :param modifier: Thickness modifier to remove
        :type modifier: 'LineStyleThicknessModifier'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Linesets(bpy_struct):
    ''' Line sets for associating lines and style parameters
    '''

    active: 'FreestyleLineSet' = None
    ''' Active line set being displayed

    :type: 'FreestyleLineSet'
    '''

    active_index: int = None
    ''' Index of active line set slot

    :type: int
    '''

    def new(self, name: str) -> 'FreestyleLineSet':
        ''' Add a line set to scene render layer Freestyle settings

        :param name: New name for the line set (not unique)
        :type name: str
        :rtype: 'FreestyleLineSet'
        :return: Newly created line set
        '''
        pass

    def remove(self, lineset: 'FreestyleLineSet'):
        ''' Remove a line set from scene render layer Freestyle settings

        :param lineset: Line set to remove
        :type lineset: 'FreestyleLineSet'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class LoopColors(bpy_struct):
    ''' Collection of vertex colors
    '''

    active: 'MeshLoopColorLayer' = None
    ''' Active vertex color layer

    :type: 'MeshLoopColorLayer'
    '''

    active_index: int = None
    ''' Active vertex color index

    :type: int
    '''

    def new(self, name: str = "Col",
            do_init: bool = True) -> 'MeshLoopColorLayer':
        ''' Add a vertex color layer to Mesh

        :param name: Vertex color name
        :type name: str
        :param do_init: Whether new layer's data should be initialized by copying current active one
        :type do_init: bool
        :rtype: 'MeshLoopColorLayer'
        :return: The newly created layer
        '''
        pass

    def remove(self, layer: 'MeshLoopColorLayer'):
        ''' Remove a vertex color layer

        :param layer: The layer to remove
        :type layer: 'MeshLoopColorLayer'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Macro(bpy_struct):
    ''' Storage of a macro operator being executed, or registered after execution
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * REGISTER Register, Display in the info window and support the redo toolbar panel. * UNDO Undo, Push an undo event (needed for operator redo). * UNDO_GROUPED Grouped Undo, Push a single undo event for repeated instances of this operator. * BLOCKING Blocking, Block anything else from using the cursor. * MACRO Macro, Use to check if an operator is a macro. * GRAB_CURSOR Grab Pointer, Use so the operator grabs the mouse focus, enables wrapping when continuous grab is enabled. * GRAB_CURSOR_X Grab Pointer X, Grab, only warping the X axis. * GRAB_CURSOR_Y Grab Pointer Y, Grab, only warping the Y axis. * PRESET Preset, Display a preset button with the operators settings. * INTERNAL Internal, Removes the operator from search results.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    bl_undo_group: str = None
    ''' 

    :type: str
    '''

    name: str = None
    ''' 

    :type: str
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        ''' report

        :param type: Type
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message
        :type message: str
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context'):
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskLayer(bpy_struct):
    ''' Single layer used for masking pixels
    '''

    alpha: float = None
    ''' Render Opacity

    :type: float
    '''

    blend: typing.Union[str, int] = None
    ''' Method of blending mask layers

    :type: typing.Union[str, int]
    '''

    falloff: typing.Union[str, int] = None
    ''' Falloff type the feather * SMOOTH Smooth, Smooth falloff. * SPHERE Sphere, Spherical falloff. * ROOT Root, Root falloff. * INVERSE_SQUARE Inverse Square, Inverse Square falloff. * SHARP Sharp, Sharp falloff. * LINEAR Linear, Linear falloff.

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Restrict visibility in the viewport

    :type: bool
    '''

    hide_render: bool = None
    ''' Restrict renderability

    :type: bool
    '''

    hide_select: bool = None
    ''' Restrict selection in the viewport

    :type: bool
    '''

    invert: bool = None
    ''' Invert the mask black/white

    :type: bool
    '''

    name: str = None
    ''' Unique name of layer

    :type: str
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    splines: typing.Union[typing.Dict[str, 'MaskSpline'], typing.
                          List['MaskSpline'], 'bpy_prop_collection',
                          'MaskSplines'] = None
    ''' Collection of splines which defines this layer

    :type: typing.Union[typing.Dict[str, 'MaskSpline'], typing.List['MaskSpline'], 'bpy_prop_collection', 'MaskSplines']
    '''

    use_fill_holes: bool = None
    ''' Calculate holes when filling overlapping curves

    :type: bool
    '''

    use_fill_overlap: bool = None
    ''' Calculate self intersections and overlap before filling

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskLayers(bpy_struct):
    ''' Collection of layers used by mask
    '''

    active: 'MaskLayer' = None
    ''' Active layer in this mask

    :type: 'MaskLayer'
    '''

    def new(self, name: str = "") -> 'MaskLayer':
        ''' Add layer to this mask

        :param name: Name, Name of new layer
        :type name: str
        :rtype: 'MaskLayer'
        :return: New mask layer
        '''
        pass

    def remove(self, layer: 'MaskLayer'):
        ''' Remove layer from this mask

        :param layer: Shape to be removed
        :type layer: 'MaskLayer'
        '''
        pass

    def clear(self):
        ''' Remove all mask layers

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskParent(bpy_struct):
    ''' Parenting settings for masking element
    '''

    id: 'ID' = None
    ''' ID-block to which masking element would be parented to or to its property

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    parent: str = None
    ''' Name of parent object in specified data-block to which parenting happens

    :type: str
    '''

    sub_parent: str = None
    ''' Name of parent sub-object in specified data-block to which parenting happens

    :type: str
    '''

    type: typing.Union[str, int] = None
    ''' Parent Type

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskSpline(bpy_struct):
    ''' Single spline used for defining mask shape
    '''

    offset_mode: typing.Union[str, int] = None
    ''' The method used for calculating the feather offset * EVEN Even, Calculate even feather offset. * SMOOTH Smooth, Calculate feather offset as a second curve.

    :type: typing.Union[str, int]
    '''

    points: typing.Union[typing.Dict[str, 'MaskSplinePoint'], typing.
                         List['MaskSplinePoint'], 'bpy_prop_collection',
                         'MaskSplinePoints'] = None
    ''' Collection of points

    :type: typing.Union[typing.Dict[str, 'MaskSplinePoint'], typing.List['MaskSplinePoint'], 'bpy_prop_collection', 'MaskSplinePoints']
    '''

    use_cyclic: bool = None
    ''' Make this spline a closed loop

    :type: bool
    '''

    use_fill: bool = None
    ''' Make this spline filled

    :type: bool
    '''

    use_self_intersection_check: bool = None
    ''' Prevent feather from self-intersections

    :type: bool
    '''

    weight_interpolation: typing.Union[str, int] = None
    ''' The type of weight interpolation for spline

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskSplinePoint(bpy_struct):
    ''' Single point in spline used for defining mask
    '''

    co: typing.List[float] = None
    ''' Coordinates of the control point

    :type: typing.List[float]
    '''

    feather_points: typing.Union[typing.Dict[str, 'MaskSplinePointUW'], typing.
                                 List['MaskSplinePointUW'],
                                 'bpy_prop_collection'] = None
    ''' Points defining feather

    :type: typing.Union[typing.Dict[str, 'MaskSplinePointUW'], typing.List['MaskSplinePointUW'], 'bpy_prop_collection']
    '''

    handle_left: typing.List[float] = None
    ''' Coordinates of the first handle

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    ''' Coordinates of the second handle

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    parent: 'MaskParent' = None
    ''' 

    :type: 'MaskParent'
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight: float = None
    ''' Weight of the point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskSplinePointUW(bpy_struct):
    ''' Single point in spline segment defining feather
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    u: float = None
    ''' U coordinate of point along spline segment

    :type: float
    '''

    weight: float = None
    ''' Weight of feather point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskSplinePoints(bpy_struct):
    ''' Collection of masking spline points
    '''

    def add(self, count: int):
        ''' Add a number of point to this spline

        :param count: Number, Number of points to add to the spline
        :type count: int
        '''
        pass

    def remove(self, point: 'MaskSplinePoint'):
        ''' Remove a point from a spline

        :param point: The point to remove
        :type point: 'MaskSplinePoint'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaskSplines(bpy_struct):
    ''' Collection of masking splines
    '''

    active: 'MaskSpline' = None
    ''' Active spline of masking layer

    :type: 'MaskSpline'
    '''

    active_point: 'MaskSplinePoint' = None
    ''' Active spline of masking layer

    :type: 'MaskSplinePoint'
    '''

    def new(self) -> 'MaskSpline':
        ''' Add a new spline to the layer

        :rtype: 'MaskSpline'
        :return: The newly created spline
        '''
        pass

    def remove(self, spline: 'MaskSpline'):
        ''' Remove a spline from a layer

        :param spline: The spline to remove
        :type spline: 'MaskSpline'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaterialGPencilStyle(bpy_struct):
    alignment_mode: typing.Union[str, int] = None
    ''' Defines how align Dots and Boxes with drawing path and object rotation * PATH Path, Follow stroke drawing path and object rotation. * OBJECT Object, Follow object rotation only. * FIXED Fixed, Do not follow drawing path or object rotation and keeps aligned with viewport.

    :type: typing.Union[str, int]
    '''

    alignment_rotation: float = None
    ''' Additional rotation applied to dots and square strokes

    :type: float
    '''

    color: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    fill_color: typing.List[float] = None
    ''' Color for filling region bounded by each stroke

    :type: typing.List[float]
    '''

    fill_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    fill_style: typing.Union[str, int] = None
    ''' Select style used to fill strokes * SOLID Solid, Fill area with solid color. * GRADIENT Gradient, Fill area with gradient color. * TEXTURE Texture, Fill area with image texture.

    :type: typing.Union[str, int]
    '''

    flip: bool = None
    ''' Flip filling colors

    :type: bool
    '''

    ghost: bool = None
    ''' Display strokes using this color when showing onion skins

    :type: bool
    '''

    gradient_type: typing.Union[str, int] = None
    ''' Select type of gradient used to fill strokes * LINEAR Linear, Fill area with gradient color. * RADIAL Radial, Fill area with radial gradient.

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Set color Visibility

    :type: bool
    '''

    is_fill_visible: bool = None
    ''' True when opacity of fill is set high enough to be visible

    :type: bool
    '''

    is_stroke_visible: bool = None
    ''' True when opacity of stroke is set high enough to be visible

    :type: bool
    '''

    lock: bool = None
    ''' Protect color from further editing and/or frame changes

    :type: bool
    '''

    mix_color: typing.List[float] = None
    ''' Color for mixing with primary filling color

    :type: typing.List[float]
    '''

    mix_factor: float = None
    ''' Mix Factor

    :type: float
    '''

    mix_stroke_factor: float = None
    ''' Mix Stroke Factor

    :type: float
    '''

    mode: typing.Union[str, int] = None
    ''' Select line type for strokes * LINE Line, Draw strokes using a continuous line. * DOTS Dots, Draw strokes using separated dots. * BOX Squares, Draw strokes using separated squares.

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    ''' Index number for the "Color Index" pass

    :type: int
    '''

    pixel_size: float = None
    ''' Texture Pixel Size factor along the stroke

    :type: float
    '''

    show_fill: bool = None
    ''' Show stroke fills of this material

    :type: bool
    '''

    show_stroke: bool = None
    ''' Show stroke lines of this material

    :type: bool
    '''

    stroke_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    stroke_style: typing.Union[str, int] = None
    ''' Select style used to draw strokes * SOLID Solid, Draw strokes with solid color. * TEXTURE Texture, Draw strokes using texture.

    :type: typing.Union[str, int]
    '''

    texture_angle: float = None
    ''' Texture Orientation Angle

    :type: float
    '''

    texture_clamp: bool = None
    ''' Do not repeat texture and clamp to one instance only

    :type: bool
    '''

    texture_offset: typing.List[float] = None
    ''' Shift Texture in 2d Space

    :type: typing.List[float]
    '''

    texture_scale: typing.List[float] = None
    ''' Scale Factor for Texture

    :type: typing.List[float]
    '''

    use_fill_holdout: bool = None
    ''' Remove the color from underneath this stroke by using it as a mask

    :type: bool
    '''

    use_overlap_strokes: bool = None
    ''' Disable stencil and overlap self intersections with alpha materials

    :type: bool
    '''

    use_stroke_holdout: bool = None
    ''' Remove the color from underneath this stroke by using it as a mask

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaterialLineArt(bpy_struct):
    use_transparency: bool = None
    ''' Use transparency mask from this material in line art

    :type: bool
    '''

    use_transparency_mask: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MaterialSlot(bpy_struct):
    ''' Material slot in an object
    '''

    link: typing.Union[str, int] = None
    ''' Link material to object or the object's data

    :type: typing.Union[str, int]
    '''

    material: 'Material' = None
    ''' Material data-block used by this material slot

    :type: 'Material'
    '''

    name: str = None
    ''' Material slot name

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Menu(bpy_struct):
    ''' Editor menu containing buttons
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: str = None
    ''' If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_MT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_MT_hello")

    :type: str
    '''

    bl_label: str = None
    ''' The menu label

    :type: str
    '''

    bl_owner_id: str = None
    ''' 

    :type: str
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the menu in the UI

    :type: 'UILayout'
    '''

    @classmethod
    def poll(cls, context: 'Context'):
        ''' If this method returns a non-null output, then the menu can be drawn

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw UI elements into the menu UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_preset(self, _context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_add_operator (string) - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths: list,
                  operator: str,
                  *,
                  props_default: dict = None,
                  prop_filepath: str = 'filepath',
                  filter_ext: str = None,
                  filter_path=None,
                  display_name: str = None,
                  add_operator=None):
        ''' Populate a menu from a list of paths.

        :param searchpaths: Paths to scan.
        :type searchpaths: list
        :param operator: The operator id to use with each file.
        :type operator: str
        :param prop_filepath: Optional operator filepath property (defaults to "filepath").
        :type prop_filepath: str
        :param props_default: Properties to assign to each operator.
        :type props_default: dict
        :param filter_ext: Optional callback that takes the file extensions. Returning false excludes the file from the list.
        :type filter_ext: str
        :param display_name: Optional callback that takes the full path, returns the name to display.
        :type display_name: str
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshCacheVertexVelocity(bpy_struct):
    ''' Velocity attribute of an Alembic mesh
    '''

    velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshEdge(bpy_struct):
    ''' Edge in a Mesh data-block
    '''

    bevel_weight: float = None
    ''' Weight used by the Bevel modifier

    :type: float
    '''

    crease: float = None
    ''' Weight used by the Subdivision Surface modifier for creasing

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this edge

    :type: int
    '''

    is_loose: bool = None
    ''' Loose edge

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_edge_sharp: bool = None
    ''' Sharp edge for the Edge Split modifier

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Edge mark for Freestyle line rendering

    :type: bool
    '''

    use_seam: bool = None
    ''' Seam edge for UV unwrapping

    :type: bool
    '''

    vertices: typing.List[int] = None
    ''' Vertex indices

    :type: typing.List[int]
    '''

    key = None
    ''' (readonly)'''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshEdges(bpy_struct):
    ''' Collection of mesh edges
    '''

    def add(self, count: int):
        ''' add

        :param count: Count, Number of edges to add
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshFaceMap(bpy_struct):
    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshFaceMapLayer(bpy_struct):
    ''' Per-face map index
    '''

    data: typing.Union[typing.Dict[str, 'MeshFaceMap'], typing.
                       List['MeshFaceMap'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshFaceMap'], typing.List['MeshFaceMap'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' Name of face map layer

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshFaceMapLayers(bpy_struct):
    ''' Collection of mesh face maps
    '''

    active: 'MeshFaceMapLayer' = None
    ''' 

    :type: 'MeshFaceMapLayer'
    '''

    def new(self, name: str = "Face Map") -> 'MeshFaceMapLayer':
        ''' Add a float property layer to Mesh

        :param name: Face map name
        :type name: str
        :rtype: 'MeshFaceMapLayer'
        :return: The newly created layer
        '''
        pass

    def remove(self, layer: 'MeshFaceMapLayer'):
        ''' Remove a face map layer

        :param layer: The layer to remove
        :type layer: 'MeshFaceMapLayer'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoop(bpy_struct):
    ''' Loop in a Mesh data-block
    '''

    bitangent: typing.List[float] = None
    ''' Bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, use it only if really needed, slower access than bitangent_sign)

    :type: typing.List[float]
    '''

    bitangent_sign: float = None
    ''' Sign of the bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent))

    :type: float
    '''

    edge_index: int = None
    ''' Edge index

    :type: int
    '''

    index: int = None
    ''' Index of this loop

    :type: int
    '''

    normal: typing.List[float] = None
    ''' Local space unit length split normal vector of this vertex for this polygon (must be computed beforehand using calc_normals_split or calc_tangents)

    :type: typing.List[float]
    '''

    tangent: typing.List[float] = None
    ''' Local space unit length tangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents)

    :type: typing.List[float]
    '''

    vertex_index: int = None
    ''' Vertex index

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoopColor(bpy_struct):
    ''' Vertex loop colors in a Mesh
    '''

    color: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoopColorLayer(bpy_struct):
    ''' Layer of vertex colors in a Mesh data-block
    '''

    active: bool = None
    ''' Sets the layer as active for display and editing

    :type: bool
    '''

    active_render: bool = None
    ''' Sets the layer as active for rendering

    :type: bool
    '''

    data: typing.Union[typing.Dict[str, 'MeshLoopColor'], typing.
                       List['MeshLoopColor'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshLoopColor'], typing.List['MeshLoopColor'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' Name of Vertex color layer

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoopTriangle(bpy_struct):
    ''' Tessellated triangle in a Mesh data-block
    '''

    area: float = None
    ''' Area of this triangle

    :type: float
    '''

    index: int = None
    ''' Index of this loop triangle

    :type: int
    '''

    loops: typing.List[int] = None
    ''' Indices of mesh loops that make up the triangle

    :type: typing.List[int]
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    normal: typing.List[float] = None
    ''' Local space unit length normal vector for this triangle

    :type: typing.List[float]
    '''

    polygon_index: int = None
    ''' Index of mesh polygon that the triangle is a part of

    :type: int
    '''

    split_normals: typing.List[float] = None
    ''' Local space unit length split normals vectors of the vertices of this triangle (must be computed beforehand using calc_normals_split or calc_tangents)

    :type: typing.List[float]
    '''

    use_smooth: bool = None
    ''' 

    :type: bool
    '''

    vertices: typing.List[int] = None
    ''' Indices of triangle vertices

    :type: typing.List[int]
    '''

    center = None
    ''' The midpoint of the face. (readonly)'''

    edge_keys = None
    ''' (readonly)'''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoopTriangles(bpy_struct):
    ''' Tessellation of mesh polygons into triangles
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshLoops(bpy_struct):
    ''' Collection of mesh loops
    '''

    def add(self, count: int):
        ''' add

        :param count: Count, Number of loops to add
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPaintMaskLayer(bpy_struct):
    ''' Per-vertex paint mask data
    '''

    data: typing.Union[typing.Dict[str, 'MeshPaintMaskProperty'], typing.
                       List['MeshPaintMaskProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshPaintMaskProperty'], typing.List['MeshPaintMaskProperty'], 'bpy_prop_collection']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPaintMaskProperty(bpy_struct):
    ''' Floating-point paint mask value
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygon(bpy_struct):
    ''' Polygon in a Mesh data-block
    '''

    area: float = None
    ''' Read only area of this polygon

    :type: float
    '''

    center: typing.List[float] = None
    ''' Center of this polygon

    :type: typing.List[float]
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this polygon

    :type: int
    '''

    loop_start: int = None
    ''' Index of the first loop of this polygon

    :type: int
    '''

    loop_total: int = None
    ''' Number of loops used by this polygon

    :type: int
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    normal: typing.List[float] = None
    ''' Local space unit length normal vector for this polygon

    :type: typing.List[float]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Face mark for Freestyle line rendering

    :type: bool
    '''

    use_smooth: bool = None
    ''' 

    :type: bool
    '''

    vertices: typing.List[int] = None
    ''' Vertex indices

    :type: typing.List[int]
    '''

    edge_keys = None
    ''' (readonly)'''

    loop_indices = None
    ''' (readonly)'''

    def flip(self):
        ''' Invert winding of this polygon (flip its normal)

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonFloatProperty(bpy_struct):
    ''' User defined floating-point number value in a float properties layer
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonFloatPropertyLayer(bpy_struct):
    ''' User defined layer of floating-point number values
    '''

    data: typing.Union[typing.Dict[str, 'MeshPolygonFloatProperty'], typing.
                       List['MeshPolygonFloatProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshPolygonFloatProperty'], typing.List['MeshPolygonFloatProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonIntProperty(bpy_struct):
    ''' User defined integer number value in an integer properties layer
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonIntPropertyLayer(bpy_struct):
    ''' User defined layer of integer number values
    '''

    data: typing.Union[typing.Dict[str, 'MeshPolygonIntProperty'], typing.
                       List['MeshPolygonIntProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshPolygonIntProperty'], typing.List['MeshPolygonIntProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonStringProperty(bpy_struct):
    ''' User defined string text value in a string properties layer
    '''

    value: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygonStringPropertyLayer(bpy_struct):
    ''' User defined layer of string text values
    '''

    data: typing.Union[typing.Dict[str, 'MeshPolygonStringProperty'], typing.
                       List['MeshPolygonStringProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshPolygonStringProperty'], typing.List['MeshPolygonStringProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshPolygons(bpy_struct):
    ''' Collection of mesh polygons
    '''

    active: int = None
    ''' The active polygon for this mesh

    :type: int
    '''

    def add(self, count: int):
        ''' add

        :param count: Count, Number of polygons to add
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshSkinVertex(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    radius: typing.List[float] = None
    ''' Radius of the skin

    :type: typing.List[float]
    '''

    use_loose: bool = None
    ''' If vertex has multiple adjacent edges, it is hulled to them directly

    :type: bool
    '''

    use_root: bool = None
    ''' Vertex is a root for rotation calculations and armature generation, setting this flag does not clear other roots in the same mesh island

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshSkinVertexLayer(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    data: typing.Union[typing.Dict[str, 'MeshSkinVertex'], typing.
                       List['MeshSkinVertex'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshSkinVertex'], typing.List['MeshSkinVertex'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' Name of skin layer

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshStatVis(bpy_struct):
    distort_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    distort_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    overhang_axis: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    overhang_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    overhang_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    sharp_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    sharp_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    thickness_max: float = None
    ''' Maximum for measuring thickness

    :type: float
    '''

    thickness_min: float = None
    ''' Minimum for measuring thickness

    :type: float
    '''

    thickness_samples: int = None
    ''' Number of samples to test per face

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of data to visualize/check

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshUVLoop(bpy_struct):
    pin_uv: bool = None
    ''' 

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    uv: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshUVLoopLayer(bpy_struct):
    active: bool = None
    ''' Set the map as active for display and editing

    :type: bool
    '''

    active_clone: bool = None
    ''' Set the map as active for cloning

    :type: bool
    '''

    active_render: bool = None
    ''' Set the map as active for rendering

    :type: bool
    '''

    data: typing.Union[typing.Dict[str, 'MeshUVLoop'], typing.
                       List['MeshUVLoop'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshUVLoop'], typing.List['MeshUVLoop'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' Name of UV map

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertColor(bpy_struct):
    ''' Vertex colors in a Mesh
    '''

    color: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertColorLayer(bpy_struct):
    ''' Layer of sculpt vertex colors in a Mesh data-block
    '''

    active: bool = None
    ''' Sets the sculpt vertex color layer as active for display and editing

    :type: bool
    '''

    active_render: bool = None
    ''' Sets the sculpt vertex color layer as active for rendering

    :type: bool
    '''

    data: typing.Union[typing.Dict[str, 'MeshVertColor'], typing.
                       List['MeshVertColor'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshVertColor'], typing.List['MeshVertColor'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' Name of Sculpt Vertex color layer

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertex(bpy_struct):
    ''' Vertex in a Mesh data-block
    '''

    bevel_weight: float = None
    ''' Weight used by the Bevel modifier 'Only Vertices' option

    :type: float
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.Dict[str, 'VertexGroupElement'], typing.
                         List['VertexGroupElement'],
                         'bpy_prop_collection'] = None
    ''' Weights for the vertex groups this vertex is member of

    :type: typing.Union[typing.Dict[str, 'VertexGroupElement'], typing.List['VertexGroupElement'], 'bpy_prop_collection']
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this vertex

    :type: int
    '''

    normal: typing.List[float] = None
    ''' Vertex Normal

    :type: typing.List[float]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    undeformed_co: typing.List[float] = None
    ''' For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexFloatProperty(bpy_struct):
    ''' User defined floating-point number value in a float properties layer
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexFloatPropertyLayer(bpy_struct):
    ''' User defined layer of floating-point number values
    '''

    data: typing.Union[typing.Dict[str, 'MeshVertexFloatProperty'], typing.
                       List['MeshVertexFloatProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshVertexFloatProperty'], typing.List['MeshVertexFloatProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexIntProperty(bpy_struct):
    ''' User defined integer number value in an integer properties layer
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexIntPropertyLayer(bpy_struct):
    ''' User defined layer of integer number values
    '''

    data: typing.Union[typing.Dict[str, 'MeshVertexIntProperty'], typing.
                       List['MeshVertexIntProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshVertexIntProperty'], typing.List['MeshVertexIntProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexStringProperty(bpy_struct):
    ''' User defined string text value in a string properties layer
    '''

    value: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertexStringPropertyLayer(bpy_struct):
    ''' User defined layer of string text values
    '''

    data: typing.Union[typing.Dict[str, 'MeshVertexStringProperty'], typing.
                       List['MeshVertexStringProperty'],
                       'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'MeshVertexStringProperty'], typing.List['MeshVertexStringProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MeshVertices(bpy_struct):
    ''' Collection of mesh vertices
    '''

    def add(self, count: int):
        ''' add

        :param count: Count, Number of vertices to add
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MetaBallElements(bpy_struct):
    ''' Collection of metaball elements
    '''

    active: 'MetaElement' = None
    ''' Last selected element

    :type: 'MetaElement'
    '''

    def new(self, type: typing.Union[str, int] = 'BALL') -> 'MetaElement':
        ''' Add a new element to the metaball

        :param type: Type for the new metaball element
        :type type: typing.Union[str, int]
        :rtype: 'MetaElement'
        :return: The newly created metaball element
        '''
        pass

    def remove(self, element: 'MetaElement'):
        ''' Remove an element from the metaball

        :param element: The element to remove
        :type element: 'MetaElement'
        '''
        pass

    def clear(self):
        ''' Remove all elements from the metaball

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MetaElement(bpy_struct):
    ''' Blobby element in a metaball data-block
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    hide: bool = None
    ''' Hide element

    :type: bool
    '''

    radius: float = None
    ''' 

    :type: float
    '''

    rotation: typing.List[float] = None
    ''' Normalized quaternion rotation

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Select element

    :type: bool
    '''

    size_x: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_y: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_z: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    stiffness: float = None
    ''' Stiffness defines how much of the element to fill

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Metaball types

    :type: typing.Union[str, int]
    '''

    use_negative: bool = None
    ''' Set metaball as negative one

    :type: bool
    '''

    use_scale_stiffness: bool = None
    ''' Scale stiffness instead of radius

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Modifier(bpy_struct):
    ''' Modifier affecting the geometry data of an object
    '''

    is_active: bool = None
    ''' The active modifier in the list

    :type: bool
    '''

    name: str = None
    ''' Modifier name

    :type: str
    '''

    show_expanded: bool = None
    ''' Set modifier expanded in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display modifier in Edit mode

    :type: bool
    '''

    show_on_cage: bool = None
    ''' Adjust edit cage to modifier result

    :type: bool
    '''

    show_render: bool = None
    ''' Use modifier during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display modifier in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' * DATA_TRANSFER Data Transfer, Transfer several types of data (vertex groups, UV maps, vertex colors, custom normals) from one mesh to another. * MESH_CACHE Mesh Cache, Deform the mesh using an external frame-by-frame vertex transform cache. * MESH_SEQUENCE_CACHE Mesh Sequence Cache, Deform the mesh or curve using an external mesh cache in Alembic format. * NORMAL_EDIT Normal Edit, Modify the direction of the surface normals. * WEIGHTED_NORMAL Weighted Normal, Modify the direction of the surface normals using a weighting method. * UV_PROJECT UV Project, Project the UV map coordinates from the negative Z axis of another object. * UV_WARP UV Warp, Transform the UV map using the difference between two objects. * VERTEX_WEIGHT_EDIT Vertex Weight Edit, Modify of the weights of a vertex group. * VERTEX_WEIGHT_MIX Vertex Weight Mix, Mix the weights of two vertex groups. * VERTEX_WEIGHT_PROXIMITY Vertex Weight Proximity, Set the vertex group weights based on the distance to another target object. * ARRAY Array, Create copies of the shape with offsets. * BEVEL Bevel, Generate sloped corners by adding geometry to the mesh's edges or vertices. * BOOLEAN Boolean, Use another shape to cut, combine or perform a difference operation. * BUILD Build, Cause the faces of the mesh object to appear or disappear one after the other over time. * DECIMATE Decimate, Reduce the geometry density. * EDGE_SPLIT Edge Split, Split away joined faces at the edges. * NODES Geometry Nodes. * MASK Mask, Dynamically hide vertices based on a vertex group or armature. * MIRROR Mirror, Mirror along the local X, Y and/or Z axes, over the object origin. * MESH_TO_VOLUME Mesh to Volume. * MULTIRES Multiresolution, Subdivide the mesh in a way that allows editing the higher subdivision levels. * REMESH Remesh, Generate new mesh topology based on the current shape. * SCREW Screw, Lathe around an axis, treating the input mesh as a profile. * SKIN Skin, Create a solid shape from vertices and edges, using the vertex radius to define the thickness. * SOLIDIFY Solidify, Make the surface thick. * SUBSURF Subdivision Surface, Split the faces into smaller parts, giving it a smoother appearance. * TRIANGULATE Triangulate, Convert all polygons to triangles. * VOLUME_TO_MESH Volume to Mesh. * WELD Weld, Find groups of vertices closer than dist and merge them together. * WIREFRAME Wireframe, Convert faces into thickened edges. * ARMATURE Armature, Deform the shape using an armature object. * CAST Cast, Shift the shape towards a predefined primitive. * CURVE Curve, Bend the mesh using a curve object. * DISPLACE Displace, Offset vertices based on a texture. * HOOK Hook, Deform specific points using another object. * LAPLACIANDEFORM Laplacian Deform, Deform based a series of anchor points. * LATTICE Lattice, Deform using the shape of a lattice object. * MESH_DEFORM Mesh Deform, Deform using a different mesh, which acts as a deformation cage. * SHRINKWRAP Shrinkwrap, Project the shape onto another object. * SIMPLE_DEFORM Simple Deform, Deform the shape by twisting, bending, tapering or stretching. * SMOOTH Smooth, Smooth the mesh by flattening the angles between adjacent faces. * CORRECTIVE_SMOOTH Smooth Corrective, Smooth the mesh while still preserving the volume. * LAPLACIANSMOOTH Smooth Laplacian, Reduce the noise on a mesh surface with minimal changes to its shape. * SURFACE_DEFORM Surface Deform, Transfer motion from another mesh. * WARP Warp, Warp parts of a mesh to a new location in a very flexible way thanks to 2 specified objects. * WAVE Wave, Adds a ripple-like motion to an object's geometry. * VOLUME_DISPLACE Volume Displace, Deform volume based on noise or other vector fields. * CLOTH Cloth. * COLLISION Collision. * DYNAMIC_PAINT Dynamic Paint. * EXPLODE Explode, Break apart the mesh faces and let them follow particles. * FLUID Fluid. * OCEAN Ocean, Generate a moving ocean surface. * PARTICLE_INSTANCE Particle Instance. * PARTICLE_SYSTEM Particle System, Spawn particles from the shape. * SOFT_BODY Soft Body. * SURFACE Surface.

    :type: typing.Union[str, int]
    '''

    use_apply_on_spline: bool = None
    ''' Apply this and all preceding deformation modifiers on splines' points rather than on filled curve/surface

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MotionPath(bpy_struct):
    ''' Cache of the worldspace positions of an element over a frame range
    '''

    color: typing.List[float] = None
    ''' Custom color for motion path

    :type: typing.List[float]
    '''

    frame_end: int = None
    ''' End frame of the stored range

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of the stored range

    :type: int
    '''

    is_modified: bool = None
    ''' Path is being edited

    :type: bool
    '''

    length: int = None
    ''' Number of frames cached

    :type: int
    '''

    line_thickness: int = None
    ''' Line thickness for motion path

    :type: int
    '''

    lines: bool = None
    ''' Use straight lines between keyframe points

    :type: bool
    '''

    points: typing.Union[typing.Dict[str, 'MotionPathVert'], typing.
                         List['MotionPathVert'], 'bpy_prop_collection'] = None
    ''' Cached positions per frame

    :type: typing.Union[typing.Dict[str, 'MotionPathVert'], typing.List['MotionPathVert'], 'bpy_prop_collection']
    '''

    use_bone_head: bool = None
    ''' For PoseBone paths, use the bone head location when calculating this path

    :type: bool
    '''

    use_custom_color: bool = None
    ''' Use custom color for this motion path

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MotionPathVert(bpy_struct):
    ''' Cached location on path
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    select: bool = None
    ''' Path point is selected for editing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieClipProxy(bpy_struct):
    ''' Proxy parameters for a movie clip
    '''

    build_100: bool = None
    ''' Build proxy resolution 100% of the original footage dimension

    :type: bool
    '''

    build_25: bool = None
    ''' Build proxy resolution 25% of the original footage dimension

    :type: bool
    '''

    build_50: bool = None
    ''' Build proxy resolution 50% of the original footage dimension

    :type: bool
    '''

    build_75: bool = None
    ''' Build proxy resolution 75% of the original footage dimension

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    build_undistorted_100: bool = None
    ''' Build proxy resolution 100% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_25: bool = None
    ''' Build proxy resolution 25% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_50: bool = None
    ''' Build proxy resolution 50% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_75: bool = None
    ''' Build proxy resolution 75% of the original undistorted footage dimension

    :type: bool
    '''

    directory: str = None
    ''' Location to store the proxy files

    :type: str
    '''

    quality: int = None
    ''' JPEG quality of proxy images

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' * NONE No TC in use. * RECORD_RUN Record Run, Use images in the order they are recorded. * FREE_RUN Free Run, Use global timestamp written by recording device. * FREE_RUN_REC_DATE Free Run (rec date), Interpolate a global timestamp using the record date and time written by recording device. * FREE_RUN_NO_GAPS Free Run No Gaps, Record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieClipScopes(bpy_struct):
    ''' Scopes for statistical view of a movie clip
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieClipUser(bpy_struct):
    ''' Parameters defining how a MovieClip data-block is used by another data-block
    '''

    frame_current: int = None
    ''' Current frame number in movie or image sequence

    :type: int
    '''

    proxy_render_size: typing.Union[str, int] = None
    ''' Display preview using full resolution or different proxy resolutions

    :type: typing.Union[str, int]
    '''

    use_render_undistorted: bool = None
    ''' Render preview using undistorted proxy

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieReconstructedCamera(bpy_struct):
    ''' Match-moving reconstructed camera data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    matrix: typing.List[float] = None
    ''' Worldspace transformation matrix

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTracking(bpy_struct):
    ''' Match-moving data for tracking
    '''

    active_object_index: int = None
    ''' Index of active object

    :type: int
    '''

    camera: 'MovieTrackingCamera' = None
    ''' 

    :type: 'MovieTrackingCamera'
    '''

    dopesheet: 'MovieTrackingDopesheet' = None
    ''' 

    :type: 'MovieTrackingDopesheet'
    '''

    objects: typing.Union[typing.Dict[str, 'MovieTrackingObject'], typing.
                          List['MovieTrackingObject'], 'bpy_prop_collection',
                          'MovieTrackingObjects'] = None
    ''' Collection of objects in this tracking data object

    :type: typing.Union[typing.Dict[str, 'MovieTrackingObject'], typing.List['MovieTrackingObject'], 'bpy_prop_collection', 'MovieTrackingObjects']
    '''

    plane_tracks: typing.Union[
        typing.Dict[str, 'MovieTrackingPlaneTrack'], typing.
        List['MovieTrackingPlaneTrack'], 'bpy_prop_collection',
        'MovieTrackingPlaneTracks'] = None
    ''' Collection of plane tracks in this tracking data object

    :type: typing.Union[typing.Dict[str, 'MovieTrackingPlaneTrack'], typing.List['MovieTrackingPlaneTrack'], 'bpy_prop_collection', 'MovieTrackingPlaneTracks']
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    settings: 'MovieTrackingSettings' = None
    ''' 

    :type: 'MovieTrackingSettings'
    '''

    stabilization: 'MovieTrackingStabilization' = None
    ''' 

    :type: 'MovieTrackingStabilization'
    '''

    tracks: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.
                         List['MovieTrackingTrack'], 'bpy_prop_collection',
                         'MovieTrackingTracks'] = None
    ''' Collection of tracks in this tracking data object

    :type: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.List['MovieTrackingTrack'], 'bpy_prop_collection', 'MovieTrackingTracks']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingCamera(bpy_struct):
    ''' Match-moving camera data for tracking
    '''

    brown_k1: float = None
    ''' First coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k2: float = None
    ''' Second coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k3: float = None
    ''' Third coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k4: float = None
    ''' Fourth coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_p1: float = None
    ''' First coefficient of second order Brown-Conrady tangential distortion

    :type: float
    '''

    brown_p2: float = None
    ''' Second coefficient of second order Brown-Conrady tangential distortion

    :type: float
    '''

    distortion_model: typing.Union[str, int] = None
    ''' Distortion model used for camera lenses * POLYNOMIAL Polynomial, Radial distortion model which fits common cameras. * DIVISION Divisions, Division distortion model which better represents wide-angle cameras. * NUKE Nuke, Nuke distortion model. * BROWN Brown, Brown-Conrady distortion model.

    :type: typing.Union[str, int]
    '''

    division_k1: float = None
    ''' First coefficient of second order division distortion

    :type: float
    '''

    division_k2: float = None
    ''' Second coefficient of second order division distortion

    :type: float
    '''

    focal_length: float = None
    ''' Camera's focal length

    :type: float
    '''

    focal_length_pixels: float = None
    ''' Camera's focal length

    :type: float
    '''

    k1: float = None
    ''' First coefficient of third order polynomial radial distortion

    :type: float
    '''

    k2: float = None
    ''' Second coefficient of third order polynomial radial distortion

    :type: float
    '''

    k3: float = None
    ''' Third coefficient of third order polynomial radial distortion

    :type: float
    '''

    nuke_k1: float = None
    ''' First coefficient of second order Nuke distortion

    :type: float
    '''

    nuke_k2: float = None
    ''' Second coefficient of second order Nuke distortion

    :type: float
    '''

    pixel_aspect: float = None
    ''' Pixel aspect ratio

    :type: float
    '''

    principal: typing.List[float] = None
    ''' Optical center of lens

    :type: typing.List[float]
    '''

    sensor_width: float = None
    ''' Width of CCD sensor in millimeters

    :type: float
    '''

    units: typing.Union[str, int] = None
    ''' Units used for camera focal length * PIXELS px, Use pixels for units of focal length. * MILLIMETERS mm, Use millimeters for units of focal length.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingDopesheet(bpy_struct):
    ''' Match-moving dopesheet data
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that aren't visible

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' Method to be used to sort channels in dopesheet view * NAME Name, Sort channels by their names. * LONGEST Longest, Sort channels by longest tracked segment. * TOTAL Total, Sort channels by overall amount of tracked segments. * AVERAGE_ERROR Average Error, Sort channels by average reprojection error of tracks after solve.

    :type: typing.Union[str, int]
    '''

    use_invert_sort: bool = None
    ''' Invert sort order of dopesheet channels

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingMarker(bpy_struct):
    ''' Match-moving marker data for tracking
    '''

    co: typing.List[float] = None
    ''' Marker position at frame in normalized coordinates

    :type: typing.List[float]
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    is_keyed: bool = None
    ''' Whether the position of the marker is keyframed or tracked

    :type: bool
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''

    pattern_bound_box: typing.List[float] = None
    ''' Pattern area bounding box in normalized coordinates

    :type: typing.List[float]
    '''

    pattern_corners: typing.List[float] = None
    ''' Array of coordinates which represents pattern's corners in normalized coordinates relative to marker position

    :type: typing.List[float]
    '''

    search_max: typing.List[float] = None
    ''' Right-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.List[float]
    '''

    search_min: typing.List[float] = None
    ''' Left-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingMarkers(bpy_struct):
    ''' Collection of markers for movie tracking track
    '''

    def find_frame(self, frame: int,
                   exact: bool = True) -> 'MovieTrackingMarker':
        ''' Get marker for specified frame

        :param frame: Frame, Frame number to find marker for
        :type frame: int
        :param exact: Exact, Get marker at exact frame number rather than get estimated marker
        :type exact: bool
        :rtype: 'MovieTrackingMarker'
        :return: Marker for specified frame
        '''
        pass

    def insert_frame(self, frame: int,
                     co: typing.List[float] = (0.0,
                                               0.0)) -> 'MovieTrackingMarker':
        ''' Insert a new marker at the specified frame

        :param frame: Frame, Frame number to insert marker to
        :type frame: int
        :param co: Coordinate, Place new marker at the given frame using specified in normalized space coordinates
        :type co: typing.List[float]
        :rtype: 'MovieTrackingMarker'
        :return: Newly created marker
        '''
        pass

    def delete_frame(self, frame: int):
        ''' Delete marker at specified frame

        :param frame: Frame, Frame number to delete marker from
        :type frame: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingObject(bpy_struct):
    ''' Match-moving object tracking and reconstruction data
    '''

    is_camera: bool = None
    ''' Object is used for camera tracking

    :type: bool
    '''

    keyframe_a: int = None
    ''' First keyframe used for reconstruction initialization

    :type: int
    '''

    keyframe_b: int = None
    ''' Second keyframe used for reconstruction initialization

    :type: int
    '''

    name: str = None
    ''' Unique name of object

    :type: str
    '''

    plane_tracks: typing.Union[
        typing.Dict[str, 'MovieTrackingPlaneTrack'], typing.
        List['MovieTrackingPlaneTrack'], 'bpy_prop_collection',
        'MovieTrackingObjectPlaneTracks'] = None
    ''' Collection of plane tracks in this tracking data object

    :type: typing.Union[typing.Dict[str, 'MovieTrackingPlaneTrack'], typing.List['MovieTrackingPlaneTrack'], 'bpy_prop_collection', 'MovieTrackingObjectPlaneTracks']
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    scale: float = None
    ''' Scale of object solution in camera space

    :type: float
    '''

    tracks: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.
                         List['MovieTrackingTrack'], 'bpy_prop_collection',
                         'MovieTrackingObjectTracks'] = None
    ''' Collection of tracks in this tracking data object

    :type: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.List['MovieTrackingTrack'], 'bpy_prop_collection', 'MovieTrackingObjectTracks']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingObjectPlaneTracks(bpy_struct):
    ''' Collection of tracking plane tracks
    '''

    active: 'MovieTrackingTrack' = None
    ''' Active track in this tracking data object

    :type: 'MovieTrackingTrack'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingObjectTracks(bpy_struct):
    ''' Collection of movie tracking tracks
    '''

    active: 'MovieTrackingTrack' = None
    ''' Active track in this tracking data object

    :type: 'MovieTrackingTrack'
    '''

    def new(self, name: str = "", frame: int = 1) -> 'MovieTrackingTrack':
        ''' create new motion track in this movie clip

        :param name: Name of new track
        :type name: str
        :param frame: Frame, Frame number to add tracks on
        :type frame: int
        :rtype: 'MovieTrackingTrack'
        :return: Newly created track
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingObjects(bpy_struct):
    ''' Collection of movie tracking objects
    '''

    active: 'MovieTrackingObject' = None
    ''' Active object in this tracking data object

    :type: 'MovieTrackingObject'
    '''

    def new(self, name: str) -> 'MovieTrackingObject':
        ''' Add tracking object to this movie clip

        :param name: Name of new object
        :type name: str
        :rtype: 'MovieTrackingObject'
        :return: New motion tracking object
        '''
        pass

    def remove(self, object: 'MovieTrackingObject'):
        ''' Remove tracking object from this movie clip

        :param object: Motion tracking object to be removed
        :type object: 'MovieTrackingObject'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneMarker(bpy_struct):
    ''' Match-moving plane marker data for tracking
    '''

    corners: typing.List[float] = None
    ''' Array of coordinates which represents UI rectangle corners in frame normalized coordinates

    :type: typing.List[float]
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneMarkers(bpy_struct):
    ''' Collection of markers for movie tracking plane track
    '''

    def find_frame(self, frame: int,
                   exact: bool = True) -> 'MovieTrackingPlaneMarker':
        ''' Get plane marker for specified frame

        :param frame: Frame, Frame number to find marker for
        :type frame: int
        :param exact: Exact, Get plane marker at exact frame number rather than get estimated marker
        :type exact: bool
        :rtype: 'MovieTrackingPlaneMarker'
        :return: Plane marker for specified frame
        '''
        pass

    def insert_frame(self, frame: int) -> 'MovieTrackingPlaneMarker':
        ''' Insert a new plane marker at the specified frame

        :param frame: Frame, Frame number to insert marker to
        :type frame: int
        :rtype: 'MovieTrackingPlaneMarker'
        :return: Newly created plane marker
        '''
        pass

    def delete_frame(self, frame: int):
        ''' Delete plane marker at specified frame

        :param frame: Frame, Frame number to delete plane marker from
        :type frame: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneTrack(bpy_struct):
    ''' Match-moving plane track data for tracking
    '''

    image: 'Image' = None
    ''' Image displayed in the track during editing in clip editor

    :type: 'Image'
    '''

    image_opacity: float = None
    ''' Opacity of the image

    :type: float
    '''

    markers: typing.Union[typing.Dict[str, 'MovieTrackingPlaneMarker'], typing.
                          List['MovieTrackingPlaneMarker'],
                          'bpy_prop_collection',
                          'MovieTrackingPlaneMarkers'] = None
    ''' Collection of markers in track

    :type: typing.Union[typing.Dict[str, 'MovieTrackingPlaneMarker'], typing.List['MovieTrackingPlaneMarker'], 'bpy_prop_collection', 'MovieTrackingPlaneMarkers']
    '''

    name: str = None
    ''' Unique name of track

    :type: str
    '''

    select: bool = None
    ''' Plane track is selected

    :type: bool
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion when moving plane corners

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneTracks(bpy_struct):
    ''' Collection of movie tracking plane tracks
    '''

    active: 'MovieTrackingPlaneTrack' = None
    ''' Active plane track in this tracking data object

    :type: 'MovieTrackingPlaneTrack'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingReconstructedCameras(bpy_struct):
    ''' Collection of solved cameras
    '''

    def find_frame(self, frame: int = 1) -> 'MovieReconstructedCamera':
        ''' Find a reconstructed camera for a give frame number

        :param frame: Frame, Frame number to find camera for
        :type frame: int
        :rtype: 'MovieReconstructedCamera'
        :return: Camera for a given frame
        '''
        pass

    def matrix_from_frame(self, frame: int = 1) -> typing.List[float]:
        ''' Return interpolated camera matrix for a given frame

        :param frame: Frame, Frame number to find camera for
        :type frame: int
        :rtype: typing.List[float]
        :return: Matrix, Interpolated camera matrix for a given frame
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingReconstruction(bpy_struct):
    ''' Match-moving reconstruction data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    cameras: typing.Union[typing.Dict[str, 'MovieReconstructedCamera'], typing.
                          List['MovieReconstructedCamera'],
                          'bpy_prop_collection',
                          'MovieTrackingReconstructedCameras'] = None
    ''' Collection of solved cameras

    :type: typing.Union[typing.Dict[str, 'MovieReconstructedCamera'], typing.List['MovieReconstructedCamera'], 'bpy_prop_collection', 'MovieTrackingReconstructedCameras']
    '''

    is_valid: bool = None
    ''' Is tracking data contains valid reconstruction information

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingSettings(bpy_struct):
    ''' Match moving settings
    '''

    clean_action: typing.Union[str, int] = None
    ''' Cleanup action to execute * SELECT Select, Select unclean tracks. * DELETE_TRACK Delete Track, Delete unclean tracks. * DELETE_SEGMENTS Delete Segments, Delete unclean segments of tracks.

    :type: typing.Union[str, int]
    '''

    clean_error: float = None
    ''' Effect on tracks which have a larger re-projection error

    :type: float
    '''

    clean_frames: int = None
    ''' Effect on tracks which are tracked less than the specified amount of frames

    :type: int
    '''

    default_correlation_min: float = None
    ''' Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    default_frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    default_margin: int = None
    ''' Default distance from image boundary at which marker stops tracking

    :type: int
    '''

    default_motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * Perspective Perspective, Search for markers that are perspectively deformed (homography) between frames. * Affine Affine, Search for markers that are affine-deformed (t, r, k, and skew) between frames. * LocRotScale Location, Rotation & Scale, Search for markers that are translated, rotated, and scaled between frames. * LocScale Location & Scale, Search for markers that are translated and scaled between frames. * LocRot Location & Rotation, Search for markers that are translated and rotated between frames. * Loc Location, Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    default_pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * KEYFRAME Keyframe, Track pattern from keyframe to next frame. * PREV_FRAME Previous frame, Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    default_pattern_size: int = None
    ''' Size of pattern area for newly created tracks

    :type: int
    '''

    default_search_size: int = None
    ''' Size of search area for newly created tracks

    :type: int
    '''

    default_weight: float = None
    ''' Influence of newly created track on a final solution

    :type: float
    '''

    distance: float = None
    ''' Distance between two bundles used for scene scaling

    :type: float
    '''

    object_distance: float = None
    ''' Distance between two bundles used for object scaling

    :type: float
    '''

    refine_intrinsics_focal_length: bool = None
    ''' Refine focal length during camera solving

    :type: bool
    '''

    refine_intrinsics_principal_point: bool = None
    ''' Refine principal point during camera solving

    :type: bool
    '''

    refine_intrinsics_radial_distortion: bool = None
    ''' Refine radial coefficients of distortion model during camera solving

    :type: bool
    '''

    refine_intrinsics_tangential_distortion: bool = None
    ''' Refine tangential coefficients of distortion model during camera solving

    :type: bool
    '''

    speed: typing.Union[str, int] = None
    ''' Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality) * FASTEST Fastest, Track as fast as it's possible. * DOUBLE Double, Track with double speed. * REALTIME Realtime, Track with realtime speed. * HALF Half, Track with half of realtime speed. * QUARTER Quarter, Track with quarter of realtime speed.

    :type: typing.Union[str, int]
    '''

    use_default_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_default_brute: bool = None
    ''' Use a brute-force translation-only initialization when tracking

    :type: bool
    '''

    use_default_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_default_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_default_normalization: bool = None
    ''' Normalize light intensities while tracking (slower)

    :type: bool
    '''

    use_default_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    use_keyframe_selection: bool = None
    ''' Automatically select keyframes when solving camera/object motion

    :type: bool
    '''

    use_tripod_solver: bool = None
    ''' Use special solver to track a stable camera position, such as a tripod

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingStabilization(bpy_struct):
    ''' 2D stabilization based on tracking markers
    '''

    active_rotation_track_index: int = None
    ''' Index of active track in rotation stabilization tracks list

    :type: int
    '''

    active_track_index: int = None
    ''' Index of active track in translation stabilization tracks list

    :type: int
    '''

    anchor_frame: int = None
    ''' Reference point to anchor stabilization (other frames will be adjusted relative to this frame's position)

    :type: int
    '''

    filter_type: typing.Union[str, int] = None
    ''' Interpolation to use for sub-pixel shifts and rotations due to stabilization * NEAREST Nearest, No interpolation, use nearest neighbor pixel. * BILINEAR Bilinear, Simple interpolation between adjacent pixels. * BICUBIC Bicubic, High quality pixel interpolation.

    :type: typing.Union[str, int]
    '''

    influence_location: float = None
    ''' Influence of stabilization algorithm on footage location

    :type: float
    '''

    influence_rotation: float = None
    ''' Influence of stabilization algorithm on footage rotation

    :type: float
    '''

    influence_scale: float = None
    ''' Influence of stabilization algorithm on footage scale

    :type: float
    '''

    rotation_tracks: typing.Union[
        typing.Dict[str, 'MovieTrackingTrack'], typing.
        List['MovieTrackingTrack'], 'bpy_prop_collection'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.List['MovieTrackingTrack'], 'bpy_prop_collection']
    '''

    scale_max: float = None
    ''' Limit the amount of automatic scaling

    :type: float
    '''

    show_tracks_expanded: bool = None
    ''' Show UI list of tracks participating in stabilization

    :type: bool
    '''

    target_position: typing.List[float] = None
    ''' Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated)

    :type: typing.List[float]
    '''

    target_rotation: float = None
    ''' Rotation present on original shot, will be compensated (e.g. for deliberate tilting)

    :type: float
    '''

    target_scale: float = None
    ''' Explicitly scale resulting frame to compensate zoom of original shot

    :type: float
    '''

    tracks: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.
                         List['MovieTrackingTrack'],
                         'bpy_prop_collection'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: typing.Union[typing.Dict[str, 'MovieTrackingTrack'], typing.List['MovieTrackingTrack'], 'bpy_prop_collection']
    '''

    use_2d_stabilization: bool = None
    ''' Use 2D stabilization for footage

    :type: bool
    '''

    use_autoscale: bool = None
    ''' Automatically scale footage to cover unfilled areas when stabilizing

    :type: bool
    '''

    use_stabilize_rotation: bool = None
    ''' Stabilize detected rotation around center of frame

    :type: bool
    '''

    use_stabilize_scale: bool = None
    ''' Compensate any scale changes relative to center of rotation

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingTrack(bpy_struct):
    ''' Match-moving track data for tracking
    '''

    average_error: float = None
    ''' Average error of re-projection

    :type: float
    '''

    bundle: typing.List[float] = None
    ''' Position of bundle reconstructed from this track

    :type: typing.List[float]
    '''

    color: typing.List[float] = None
    ''' Color of the track in the Movie Clip Editor and the 3D viewport after a solve

    :type: typing.List[float]
    '''

    correlation_min: float = None
    ''' Minimal value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease pencil data for this track

    :type: 'GreasePencil'
    '''

    has_bundle: bool = None
    ''' True if track has a valid bundle

    :type: bool
    '''

    hide: bool = None
    ''' Track is hidden

    :type: bool
    '''

    lock: bool = None
    ''' Track is locked and all changes to it are disabled

    :type: bool
    '''

    margin: int = None
    ''' Distance from image boundary at which marker stops tracking

    :type: int
    '''

    markers: typing.Union[typing.Dict[str, 'MovieTrackingMarker'], typing.
                          List['MovieTrackingMarker'], 'bpy_prop_collection',
                          'MovieTrackingMarkers'] = None
    ''' Collection of markers in track

    :type: typing.Union[typing.Dict[str, 'MovieTrackingMarker'], typing.List['MovieTrackingMarker'], 'bpy_prop_collection', 'MovieTrackingMarkers']
    '''

    motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * Perspective Perspective, Search for markers that are perspectively deformed (homography) between frames. * Affine Affine, Search for markers that are affine-deformed (t, r, k, and skew) between frames. * LocRotScale Location, Rotation & Scale, Search for markers that are translated, rotated, and scaled between frames. * LocScale Location & Scale, Search for markers that are translated and scaled between frames. * LocRot Location & Rotation, Search for markers that are translated and rotated between frames. * Loc Location, Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    name: str = None
    ''' Unique name of track

    :type: str
    '''

    offset: typing.List[float] = None
    ''' Offset of track from the parenting point

    :type: typing.List[float]
    '''

    pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * KEYFRAME Keyframe, Track pattern from keyframe to next frame. * PREV_FRAME Previous frame, Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Track is selected

    :type: bool
    '''

    select_anchor: bool = None
    ''' Track's anchor point is selected

    :type: bool
    '''

    select_pattern: bool = None
    ''' Track's pattern area is selected

    :type: bool
    '''

    select_search: bool = None
    ''' Track's search area is selected

    :type: bool
    '''

    use_alpha_preview: bool = None
    ''' Apply track's mask on displaying preview

    :type: bool
    '''

    use_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_brute: bool = None
    ''' Use a brute-force translation only pre-track before refinement

    :type: bool
    '''

    use_custom_color: bool = None
    ''' Use custom color instead of theme-defined

    :type: bool
    '''

    use_grayscale_preview: bool = None
    ''' Display what the tracking algorithm sees in the preview

    :type: bool
    '''

    use_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_normalization: bool = None
    ''' Normalize light intensities while tracking. Slower

    :type: bool
    '''

    use_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    weight: float = None
    ''' Influence of this track on a final solution

    :type: float
    '''

    weight_stab: float = None
    ''' Influence of this track on 2D stabilization

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingTracks(bpy_struct):
    ''' Collection of movie tracking tracks
    '''

    active: 'MovieTrackingTrack' = None
    ''' Active track in this tracking data object

    :type: 'MovieTrackingTrack'
    '''

    def new(self, name: str = "", frame: int = 1) -> 'MovieTrackingTrack':
        ''' Create new motion track in this movie clip

        :param name: Name of new track
        :type name: str
        :param frame: Frame, Frame number to add track on
        :type frame: int
        :rtype: 'MovieTrackingTrack'
        :return: Newly created track
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NlaStrip(bpy_struct):
    ''' A container referencing an existing Action
    '''

    action: 'Action' = None
    ''' Action referenced by this strip

    :type: 'Action'
    '''

    action_frame_end: float = None
    ''' Last frame from action to use

    :type: float
    '''

    action_frame_start: float = None
    ''' First frame from action to use

    :type: float
    '''

    active: bool = None
    ''' NLA Strip is active

    :type: bool
    '''

    blend_in: float = None
    ''' Number of frames at start of strip to fade in influence

    :type: float
    '''

    blend_out: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method used for combining strip's result with accumulated result * REPLACE Replace, The strip values replace the accumulated results by amount specified by influence. * COMBINE Combine, The strip values are combined with accumulated results by appropriately using addition, multiplication, or quaternion math, based on channel type. * ADD Add, Weighted result of strip is added to the accumulated results. * SUBTRACT Subtract, Weighted result of strip is removed from the accumulated results. * MULTIPLY Multiply, Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the strip extents * NOTHING Nothing, Strip has no influence past its extents. * HOLD Hold, Hold the first frame if no previous strips in track, and always hold last frame. * HOLD_FORWARD Hold Forward, Only hold last frame.

    :type: typing.Union[str, int]
    '''

    fcurves: typing.Union[typing.Dict[str, 'FCurve'], typing.List['FCurve'],
                          'bpy_prop_collection', 'NlaStripFCurves'] = None
    ''' F-Curves for controlling the strip's influence and timing

    :type: typing.Union[typing.Dict[str, 'FCurve'], typing.List['FCurve'], 'bpy_prop_collection', 'NlaStripFCurves']
    '''

    frame_end: float = None
    ''' 

    :type: float
    '''

    frame_start: float = None
    ''' 

    :type: float
    '''

    influence: float = None
    ''' Amount the strip contributes to the current result

    :type: float
    '''

    modifiers: typing.Union[typing.Dict[str, 'FModifier'], typing.
                            List['FModifier'], 'bpy_prop_collection'] = None
    ''' Modifiers affecting all the F-Curves in the referenced Action

    :type: typing.Union[typing.Dict[str, 'FModifier'], typing.List['FModifier'], 'bpy_prop_collection']
    '''

    mute: bool = None
    ''' Disable NLA Strip evaluation

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    repeat: float = None
    ''' Number of times to repeat the action range

    :type: float
    '''

    scale: float = None
    ''' Scaling factor for action

    :type: float
    '''

    select: bool = None
    ''' NLA Strip is selected

    :type: bool
    '''

    strip_time: float = None
    ''' Frame of referenced Action to evaluate

    :type: float
    '''

    strips: typing.Union[typing.Dict[str, 'NlaStrip'], typing.
                         List['NlaStrip'], 'bpy_prop_collection'] = None
    ''' NLA Strips that this strip acts as a container for (if it is of type Meta)

    :type: typing.Union[typing.Dict[str, 'NlaStrip'], typing.List['NlaStrip'], 'bpy_prop_collection']
    '''

    type: typing.Union[str, int] = None
    ''' Type of NLA Strip * CLIP Action Clip, NLA Strip references some Action. * TRANSITION Transition, NLA Strip 'transitions' between adjacent strips. * META Meta, NLA Strip acts as a container for adjacent strips. * SOUND Sound Clip, NLA Strip representing a sound event for speakers.

    :type: typing.Union[str, int]
    '''

    use_animated_influence: bool = None
    ''' Influence setting is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time: bool = None
    ''' Strip time is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time_cyclic: bool = None
    ''' Cycle the animated time within the action start and end

    :type: bool
    '''

    use_auto_blend: bool = None
    ''' Number of frames for Blending In/Out is automatically determined from overlapping strips

    :type: bool
    '''

    use_reverse: bool = None
    ''' NLA Strip is played back in reverse order (only when timing is automatically determined)

    :type: bool
    '''

    use_sync_length: bool = None
    ''' Update range of frames referenced from action after tweaking strip and its keyframes

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NlaStripFCurves(bpy_struct):
    ''' Collection of NLA strip F-Curves
    '''

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        ''' Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the NLA strip.

        :param data_path: Data Path, F-Curve data path
        :type data_path: str
        :param index: Index, Array index
        :type index: int
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NlaStrips(bpy_struct):
    ''' Collection of Nla Strips
    '''

    def new(self, name: str, start: int, action: 'Action') -> 'NlaStrip':
        ''' Add a new Action-Clip strip to the track

        :param name: Name for the NLA Strips
        :type name: str
        :param start: Start Frame, Start frame for this strip
        :type start: int
        :param action: Action to assign to this strip
        :type action: 'Action'
        :rtype: 'NlaStrip'
        :return: New NLA Strip
        '''
        pass

    def remove(self, strip: 'NlaStrip'):
        ''' Remove a NLA Strip

        :param strip: NLA Strip to remove
        :type strip: 'NlaStrip'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NlaTrack(bpy_struct):
    ''' A animation layer containing Actions referenced as NLA strips
    '''

    active: bool = None
    ''' NLA Track is active

    :type: bool
    '''

    is_solo: bool = None
    ''' NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled)

    :type: bool
    '''

    lock: bool = None
    ''' NLA Track is locked

    :type: bool
    '''

    mute: bool = None
    ''' Disable NLA Track evaluation

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    select: bool = None
    ''' NLA Track is selected

    :type: bool
    '''

    strips: typing.Union[typing.Dict[str, 'NlaStrip'], typing.List['NlaStrip'],
                         'bpy_prop_collection', 'NlaStrips'] = None
    ''' NLA Strips on this NLA-track

    :type: typing.Union[typing.Dict[str, 'NlaStrip'], typing.List['NlaStrip'], 'bpy_prop_collection', 'NlaStrips']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NlaTracks(bpy_struct):
    ''' Collection of NLA Tracks
    '''

    active: 'NlaTrack' = None
    ''' Active NLA Track

    :type: 'NlaTrack'
    '''

    def new(self, prev: 'NlaTrack' = None) -> 'NlaTrack':
        ''' Add a new NLA Track

        :param prev: NLA Track to add the new one after
        :type prev: 'NlaTrack'
        :rtype: 'NlaTrack'
        :return: New NLA Track
        '''
        pass

    def remove(self, track: 'NlaTrack'):
        ''' Remove a NLA Track

        :param track: NLA Track to remove
        :type track: 'NlaTrack'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Node(bpy_struct):
    ''' Node in a node tree
    '''

    active_preview: bool = None
    ''' Node is previewed in other editor

    :type: bool
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_height_default: float = None
    ''' 

    :type: float
    '''

    bl_height_max: float = None
    ''' 

    :type: float
    '''

    bl_height_min: float = None
    ''' 

    :type: float
    '''

    bl_icon: typing.Union[str, int] = None
    ''' The node icon

    :type: typing.Union[str, int]
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    bl_label: str = None
    ''' The node label

    :type: str
    '''

    bl_static_type: typing.Union[str, int] = None
    ''' Node type (deprecated, use with care) * CUSTOM Custom, Custom Node.

    :type: typing.Union[str, int]
    '''

    bl_width_default: float = None
    ''' 

    :type: float
    '''

    bl_width_max: float = None
    ''' 

    :type: float
    '''

    bl_width_min: float = None
    ''' 

    :type: float
    '''

    color: typing.List[float] = None
    ''' Custom color of the node body

    :type: typing.List[float]
    '''

    dimensions: typing.List[float] = None
    ''' Absolute bounding box dimensions of the node

    :type: typing.List[float]
    '''

    height: float = None
    ''' Height of the node

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    inputs: typing.Union[typing.Dict[str, 'NodeSocket'], typing.
                         List['NodeSocket'], 'bpy_prop_collection',
                         'NodeInputs'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'NodeSocket'], typing.List['NodeSocket'], 'bpy_prop_collection', 'NodeInputs']
    '''

    internal_links: typing.Union[typing.Dict[str, 'NodeLink'], typing.
                                 List['NodeLink'],
                                 'bpy_prop_collection'] = None
    ''' Internal input-to-output connections for muting

    :type: typing.Union[typing.Dict[str, 'NodeLink'], typing.List['NodeLink'], 'bpy_prop_collection']
    '''

    label: str = None
    ''' Optional custom node label

    :type: str
    '''

    location: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    mute: bool = None
    ''' 

    :type: bool
    '''

    name: str = None
    ''' Unique node identifier

    :type: str
    '''

    outputs: typing.Union[typing.Dict[str, 'NodeSocket'], typing.
                          List['NodeSocket'], 'bpy_prop_collection',
                          'NodeOutputs'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'NodeSocket'], typing.List['NodeSocket'], 'bpy_prop_collection', 'NodeOutputs']
    '''

    parent: 'Node' = None
    ''' Parent this node is attached to

    :type: 'Node'
    '''

    select: bool = None
    ''' Node selection state

    :type: bool
    '''

    show_options: bool = None
    ''' 

    :type: bool
    '''

    show_preview: bool = None
    ''' 

    :type: bool
    '''

    show_texture: bool = None
    ''' Display node in viewport textured shading mode

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string) * CUSTOM Custom, Custom Node.

    :type: typing.Union[str, int]
    '''

    use_custom_color: bool = None
    ''' Use custom color for the node

    :type: bool
    '''

    width: float = None
    ''' Width of the node

    :type: float
    '''

    width_hidden: float = None
    ''' Width of the node in hidden state

    :type: float
    '''

    def socket_value_update(self, context: 'Context'):
        ''' Update after property changes

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def is_registered_node_type(cls) -> bool:
        ''' True if a registered node type

        :rtype: bool
        :return: Result
        '''
        pass

    @classmethod
    def poll(cls, node_tree: 'NodeTree'):
        ''' If non-null output is returned, the node type can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: 'NodeTree'
        '''
        pass

    def poll_instance(self, node_tree: 'NodeTree'):
        ''' If non-null output is returned, the node can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: 'NodeTree'
        '''
        pass

    def update(self):
        ''' Update on node graph topology changes (adding or removing nodes and links)

        '''
        pass

    def insert_link(self, link: 'NodeLink'):
        ''' Handle creation of a link to or from the node

        :param link: Link, Node link that will be inserted
        :type link: 'NodeLink'
        '''
        pass

    def init(self, context: 'Context'):
        ''' Initialize a new instance of this node

        :param context: 
        :type context: 'Context'
        '''
        pass

    def copy(self, node: 'Node'):
        ''' Initialize a new instance of this node from an existing node

        :param node: Node, Existing node to copy
        :type node: 'Node'
        '''
        pass

    def free(self):
        ''' Clean up node on removal

        '''
        pass

    def draw_buttons(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_buttons_ext(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons in the sidebar

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_label(self) -> str:
        ''' Returns a dynamic label string

        :rtype: str
        :return: Label
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeInputs(bpy_struct):
    ''' Collection of Node Sockets
    '''

    def new(self, type: str, name: str, identifier: str = "") -> 'NodeSocket':
        ''' Add a socket to this node

        :param type: Type, Data type
        :type type: str
        :param name: Name
        :type name: str
        :param identifier: Identifier, Unique socket identifier
        :type identifier: str
        :rtype: 'NodeSocket'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        ''' Remove a socket from this node

        :param socket: The socket to remove
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self):
        ''' Remove all sockets from this node

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeInstanceHash(bpy_struct):
    ''' Hash table containing node instance data
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeInternalSocketTemplate(bpy_struct):
    ''' Type and default value of a node socket
    '''

    identifier: str = None
    ''' Identifier of the socket

    :type: str
    '''

    name: str = None
    ''' Name of the socket

    :type: str
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the socket

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeLink(bpy_struct):
    ''' Link is muted and can be ignored
    '''

    from_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    from_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''

    is_hidden: bool = None
    ''' Link is hidden due to invisible sockets

    :type: bool
    '''

    is_muted: bool = None
    ''' 

    :type: bool
    '''

    is_valid: bool = None
    ''' 

    :type: bool
    '''

    to_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    to_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeLinks(bpy_struct):
    ''' Collection of Node Links
    '''

    def new(self,
            input: 'NodeSocket',
            output: 'NodeSocket',
            verify_limits: bool = True) -> 'NodeLink':
        ''' Add a node link to this node tree

        :param input: The input socket
        :type input: 'NodeSocket'
        :param output: The output socket
        :type output: 'NodeSocket'
        :param verify_limits: Verify Limits, Remove existing links if connection limit is exceeded
        :type verify_limits: bool
        :rtype: 'NodeLink'
        :return: New node link
        '''
        pass

    def remove(self, link: 'NodeLink'):
        ''' remove a node link from the node tree

        :param link: The node link to remove
        :type link: 'NodeLink'
        '''
        pass

    def clear(self):
        ''' remove all node links from the node tree

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeOutputFileSlotFile(bpy_struct):
    ''' Single layer file slot of the file output node
    '''

    format: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    path: str = None
    ''' Subpath used for this slot

    :type: str
    '''

    save_as_render: bool = None
    ''' Apply render part of display transform when saving byte image

    :type: bool
    '''

    use_node_format: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeOutputFileSlotLayer(bpy_struct):
    ''' Multilayer slot of the file output node
    '''

    name: str = None
    ''' OpenEXR layer name used for this slot

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeOutputs(bpy_struct):
    ''' Collection of Node Sockets
    '''

    def new(self, type: str, name: str, identifier: str = "") -> 'NodeSocket':
        ''' Add a socket to this node

        :param type: Type, Data type
        :type type: str
        :param name: Name
        :type name: str
        :param identifier: Identifier, Unique socket identifier
        :type identifier: str
        :rtype: 'NodeSocket'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        ''' Remove a socket from this node

        :param socket: The socket to remove
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self):
        ''' Remove all sockets from this node

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeSocket(bpy_struct):
    ''' Input or output socket of a node
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    description: str = None
    ''' Socket tooltip

    :type: str
    '''

    display_shape: typing.Union[str, int] = None
    ''' Socket shape

    :type: typing.Union[str, int]
    '''

    enabled: bool = None
    ''' Enable the socket

    :type: bool
    '''

    hide: bool = None
    ''' Hide the socket

    :type: bool
    '''

    hide_value: bool = None
    ''' Hide the socket input value

    :type: bool
    '''

    identifier: str = None
    ''' Unique identifier for mapping sockets

    :type: str
    '''

    is_linked: bool = None
    ''' True if the socket is connected

    :type: bool
    '''

    is_multi_input: bool = None
    ''' True if the socket can accept multiple ordered input links

    :type: bool
    '''

    is_output: bool = None
    ''' True if the socket is an output, otherwise input

    :type: bool
    '''

    label: str = None
    ''' Custom dynamic defined socket label

    :type: str
    '''

    link_limit: int = None
    ''' Max number of links allowed for this socket

    :type: int
    '''

    name: str = None
    ''' Socket name

    :type: str
    '''

    node: 'Node' = None
    ''' Node owning this socket

    :type: 'Node'
    '''

    show_expanded: bool = None
    ''' Socket links are expanded in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Data type

    :type: typing.Union[str, int]
    '''

    links = None
    ''' List of node links from or to this socket. (readonly)'''

    def draw(self, context: 'Context', layout: 'UILayout', node: 'Node',
             text: str):
        ''' Draw socket

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties
        :type text: str
        '''
        pass

    def draw_color(self, context: 'Context',
                   node: 'Node') -> typing.List[float]:
        ''' Color of the socket icon

        :param context: 
        :type context: 'Context'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :rtype: typing.List[float]
        :return: Color
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeSocketInterface(bpy_struct):
    ''' Parameters to define node sockets
    '''

    bl_socket_idname: str = None
    ''' 

    :type: str
    '''

    description: str = None
    ''' Socket tooltip

    :type: str
    '''

    hide_value: bool = None
    ''' Hide the socket input value even when the socket is not connected

    :type: bool
    '''

    identifier: str = None
    ''' Unique identifier for mapping sockets

    :type: str
    '''

    is_output: bool = None
    ''' True if the socket is an output, otherwise input

    :type: bool
    '''

    name: str = None
    ''' Socket name

    :type: str
    '''

    def draw(self, context: 'Context', layout: 'UILayout'):
        ''' Draw template settings

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_color(self, context: 'Context') -> typing.List[float]:
        ''' Color of the socket icon

        :param context: 
        :type context: 'Context'
        :rtype: typing.List[float]
        :return: Color
        '''
        pass

    def register_properties(self, data_rna_type: 'Struct'):
        ''' Define RNA properties of a socket

        :param data_rna_type: Data RNA Type, RNA type for special socket properties
        :type data_rna_type: 'Struct'
        '''
        pass

    def init_socket(self, node: 'Node', socket: 'NodeSocket', data_path: str):
        ''' Initialize a node socket instance

        :param node: Node, Node of the socket to initialize
        :type node: 'Node'
        :param socket: Socket, Socket to initialize
        :type socket: 'NodeSocket'
        :param data_path: Data Path, Path to specialized socket data
        :type data_path: str
        '''
        pass

    def from_socket(self, node: 'Node', socket: 'NodeSocket'):
        ''' Setup template parameters from an existing socket

        :param node: Node, Node of the original socket
        :type node: 'Node'
        :param socket: Socket, Original socket
        :type socket: 'NodeSocket'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeTreeInputs(bpy_struct):
    ''' Collection of Node Tree Sockets
    '''

    def new(self, type: str, name: str) -> 'NodeSocketInterface':
        ''' Add a socket to this node tree

        :param type: Type, Data type
        :type type: str
        :param name: Name
        :type name: str
        :rtype: 'NodeSocketInterface'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocketInterface'):
        ''' Remove a socket from this node tree

        :param socket: The socket to remove
        :type socket: 'NodeSocketInterface'
        '''
        pass

    def clear(self):
        ''' Remove all sockets from this node tree

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeTreeOutputs(bpy_struct):
    ''' Collection of Node Tree Sockets
    '''

    def new(self, type: str, name: str) -> 'NodeSocketInterface':
        ''' Add a socket to this node tree

        :param type: Type, Data type
        :type type: str
        :param name: Name
        :type name: str
        :rtype: 'NodeSocketInterface'
        :return: New socket
        '''
        pass

    def remove(self, socket: 'NodeSocketInterface'):
        ''' Remove a socket from this node tree

        :param socket: The socket to remove
        :type socket: 'NodeSocketInterface'
        '''
        pass

    def clear(self):
        ''' Remove all sockets from this node tree

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class NodeTreePath(bpy_struct):
    ''' Element of the node space tree path
    '''

    node_tree: 'NodeTree' = None
    ''' Base node tree from context

    :type: 'NodeTree'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Nodes(bpy_struct):
    ''' Collection of Nodes
    '''

    active: 'Node' = None
    ''' Active node in this tree

    :type: 'Node'
    '''

    def new(self, type: str) -> 'Node':
        ''' Add a node to this node tree

        :param type: Type, Type of node to add (Warning: should be same as node.bl_idname, not node.type!)
        :type type: str
        :rtype: 'Node'
        :return: New node
        '''
        pass

    def remove(self, node: 'Node'):
        ''' Remove a node from this node tree

        :param node: The node to remove
        :type node: 'Node'
        '''
        pass

    def clear(self):
        ''' Remove all nodes from this node tree

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectBase(bpy_struct):
    ''' An object instance in a render layer
    '''

    hide_viewport: bool = None
    ''' Temporarily hide in viewport

    :type: bool
    '''

    object: 'Object' = None
    ''' Object this base links to

    :type: 'Object'
    '''

    select: bool = None
    ''' Object base selection state

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectConstraints(bpy_struct):
    ''' Collection of object constraints
    '''

    active: 'Constraint' = None
    ''' Active Object constraint

    :type: 'Constraint'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Constraint':
        ''' Add a new constraint to this object

        :param type: Constraint type to add * CAMERA_SOLVER Camera Solver. * FOLLOW_TRACK Follow Track. * OBJECT_SOLVER Object Solver. * COPY_LOCATION Copy Location, Copy the location of a target (with an optional offset), so that they move together. * COPY_ROTATION Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * COPY_SCALE Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * COPY_TRANSFORMS Copy Transforms, Copy all the transformations of a target, so that they move together. * LIMIT_DISTANCE Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * LIMIT_LOCATION Limit Location, Restrict movement along each axis within given ranges. * LIMIT_ROTATION Limit Rotation, Restrict rotation along each axis within given ranges. * LIMIT_SCALE Limit Scale, Restrict scaling along each axis with given ranges. * MAINTAIN_VOLUME Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * TRANSFORM Transformation, Use one transform property from target to control another (or same) property on owner. * TRANSFORM_CACHE Transform Cache, Look up the transformation matrix from an external file. * CLAMP_TO Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * DAMPED_TRACK Damped Track, Point towards a target by performing the smallest rotation necessary. * IK Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * LOCKED_TRACK Locked Track, Rotate around the specified ('locked') axis to point towards a target. * SPLINE_IK Spline IK, Align chain of bones along a curve (Bones only). * STRETCH_TO Stretch To, Stretch along Y-Axis to point towards a target. * TRACK_TO Track To, Legacy tracking constraint prone to twisting artifacts. * ACTION Action, Use transform property of target to look up pose for owner from an Action. * ARMATURE Armature, Apply weight-blended transformation from multiple bones like the Armature modifier. * CHILD_OF Child Of, Make target the 'detachable' parent of owner. * FLOOR Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * FOLLOW_PATH Follow Path, Use to animate an object/bone following a path. * PIVOT Pivot, Change pivot point for transforms (buggy). * SHRINKWRAP Shrinkwrap, Restrict movements to surface of target mesh.
        :type type: typing.Union[str, int]
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        ''' Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        '''
        pass

    def clear(self):
        ''' Remove all constraint from this object

        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a constraint to a different position

        :param from_index: From Index, Index to move
        :type from_index: int
        :param to_index: To Index, Target index
        :type to_index: int
        '''
        pass

    def copy(self, constraint: 'Constraint') -> 'Constraint':
        ''' Add a new constraint that is a copy of the given one

        :param constraint: Constraint to copy - may belong to a different object
        :type constraint: 'Constraint'
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectDisplay(bpy_struct):
    ''' Object display settings for 3D viewport
    '''

    show_shadows: bool = None
    ''' Object cast shadows in the 3D viewport

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectGpencilModifiers(bpy_struct):
    ''' Collection of object grease pencil modifiers
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'GpencilModifier':
        ''' Add a new greasepencil_modifier

        :param name: New name for the greasepencil_modifier
        :type name: str
        :param type: Modifier type to add * GP_ARRAY Array, Create array of duplicate instances. * GP_BUILD Build, Create duplication of strokes. * GP_LINEART Line Art, Generate line art strokes from selected source. * GP_MIRROR Mirror, Duplicate strokes like a mirror. * GP_MULTIPLY Multiple Strokes, Produce multiple strokes along one stroke. * GP_SIMPLIFY Simplify, Simplify stroke reducing number of points. * GP_SUBDIV Subdivide, Subdivide stroke adding more control points. * GP_ARMATURE Armature, Deform stroke points using armature object. * GP_HOOK Hook, Deform stroke points using objects. * GP_LATTICE Lattice, Deform strokes using lattice. * GP_NOISE Noise, Add noise to strokes. * GP_OFFSET Offset, Change stroke location, rotation or scale. * GP_SMOOTH Smooth, Smooth stroke. * GP_THICK Thickness, Change stroke thickness. * GP_TIME Time Offset, Offset keyframes. * GP_COLOR Hue/Saturation, Apply changes to stroke colors. * GP_OPACITY Opacity, Opacity of the strokes. * GP_TEXTURE Texture Mapping, Change stroke uv texture values. * GP_TINT Tint, Tint strokes with new color.
        :type type: typing.Union[str, int]
        :rtype: 'GpencilModifier'
        :return: Newly created modifier
        '''
        pass

    def remove(self, greasepencil_modifier: 'GpencilModifier'):
        ''' Remove an existing greasepencil_modifier from the object

        :param greasepencil_modifier: Modifier to remove
        :type greasepencil_modifier: 'GpencilModifier'
        '''
        pass

    def clear(self):
        ''' Remove all grease pencil modifiers from the object

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectLineArt(bpy_struct):
    ''' Object line art settings
    '''

    crease_threshold: float = None
    ''' Angles smaller than this will be treated as creases

    :type: float
    '''

    usage: typing.Union[str, int] = None
    ''' How to use this object in line art calculation * INHERIT Inherit, Use settings from the parent collection. * INCLUDE Include, Generate feature lines for this object's data. * OCCLUSION_ONLY Occlusion Only, Only use the object data to produce occlusion. * EXCLUDE Exclude, Don't use this object for Line Art rendering. * INTERSECTION_ONLY Intersection Only, Only generate intersection lines for this collection. * NO_INTERSECTION No Intersection, Include this object but do not generate intersection lines.

    :type: typing.Union[str, int]
    '''

    use_crease_override: bool = None
    ''' Use this object's crease setting to overwrite scene global

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectModifiers(bpy_struct):
    ''' Collection of object modifiers
    '''

    active: 'Modifier' = None
    ''' The active modifier in the list

    :type: 'Modifier'
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Modifier':
        ''' Add a new modifier

        :param name: New name for the modifier
        :type name: str
        :param type: Modifier type to add * DATA_TRANSFER Data Transfer, Transfer several types of data (vertex groups, UV maps, vertex colors, custom normals) from one mesh to another. * MESH_CACHE Mesh Cache, Deform the mesh using an external frame-by-frame vertex transform cache. * MESH_SEQUENCE_CACHE Mesh Sequence Cache, Deform the mesh or curve using an external mesh cache in Alembic format. * NORMAL_EDIT Normal Edit, Modify the direction of the surface normals. * WEIGHTED_NORMAL Weighted Normal, Modify the direction of the surface normals using a weighting method. * UV_PROJECT UV Project, Project the UV map coordinates from the negative Z axis of another object. * UV_WARP UV Warp, Transform the UV map using the difference between two objects. * VERTEX_WEIGHT_EDIT Vertex Weight Edit, Modify of the weights of a vertex group. * VERTEX_WEIGHT_MIX Vertex Weight Mix, Mix the weights of two vertex groups. * VERTEX_WEIGHT_PROXIMITY Vertex Weight Proximity, Set the vertex group weights based on the distance to another target object. * ARRAY Array, Create copies of the shape with offsets. * BEVEL Bevel, Generate sloped corners by adding geometry to the mesh's edges or vertices. * BOOLEAN Boolean, Use another shape to cut, combine or perform a difference operation. * BUILD Build, Cause the faces of the mesh object to appear or disappear one after the other over time. * DECIMATE Decimate, Reduce the geometry density. * EDGE_SPLIT Edge Split, Split away joined faces at the edges. * NODES Geometry Nodes. * MASK Mask, Dynamically hide vertices based on a vertex group or armature. * MIRROR Mirror, Mirror along the local X, Y and/or Z axes, over the object origin. * MESH_TO_VOLUME Mesh to Volume. * MULTIRES Multiresolution, Subdivide the mesh in a way that allows editing the higher subdivision levels. * REMESH Remesh, Generate new mesh topology based on the current shape. * SCREW Screw, Lathe around an axis, treating the input mesh as a profile. * SKIN Skin, Create a solid shape from vertices and edges, using the vertex radius to define the thickness. * SOLIDIFY Solidify, Make the surface thick. * SUBSURF Subdivision Surface, Split the faces into smaller parts, giving it a smoother appearance. * TRIANGULATE Triangulate, Convert all polygons to triangles. * VOLUME_TO_MESH Volume to Mesh. * WELD Weld, Find groups of vertices closer than dist and merge them together. * WIREFRAME Wireframe, Convert faces into thickened edges. * ARMATURE Armature, Deform the shape using an armature object. * CAST Cast, Shift the shape towards a predefined primitive. * CURVE Curve, Bend the mesh using a curve object. * DISPLACE Displace, Offset vertices based on a texture. * HOOK Hook, Deform specific points using another object. * LAPLACIANDEFORM Laplacian Deform, Deform based a series of anchor points. * LATTICE Lattice, Deform using the shape of a lattice object. * MESH_DEFORM Mesh Deform, Deform using a different mesh, which acts as a deformation cage. * SHRINKWRAP Shrinkwrap, Project the shape onto another object. * SIMPLE_DEFORM Simple Deform, Deform the shape by twisting, bending, tapering or stretching. * SMOOTH Smooth, Smooth the mesh by flattening the angles between adjacent faces. * CORRECTIVE_SMOOTH Smooth Corrective, Smooth the mesh while still preserving the volume. * LAPLACIANSMOOTH Smooth Laplacian, Reduce the noise on a mesh surface with minimal changes to its shape. * SURFACE_DEFORM Surface Deform, Transfer motion from another mesh. * WARP Warp, Warp parts of a mesh to a new location in a very flexible way thanks to 2 specified objects. * WAVE Wave, Adds a ripple-like motion to an object's geometry. * VOLUME_DISPLACE Volume Displace, Deform volume based on noise or other vector fields. * CLOTH Cloth. * COLLISION Collision. * DYNAMIC_PAINT Dynamic Paint. * EXPLODE Explode, Break apart the mesh faces and let them follow particles. * FLUID Fluid. * OCEAN Ocean, Generate a moving ocean surface. * PARTICLE_INSTANCE Particle Instance. * PARTICLE_SYSTEM Particle System, Spawn particles from the shape. * SOFT_BODY Soft Body. * SURFACE Surface.
        :type type: typing.Union[str, int]
        :rtype: 'Modifier'
        :return: Newly created modifier
        '''
        pass

    def remove(self, modifier: 'Modifier'):
        ''' Remove an existing modifier from the object

        :param modifier: Modifier to remove
        :type modifier: 'Modifier'
        '''
        pass

    def clear(self):
        ''' Remove all modifiers from the object

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ObjectShaderFx(bpy_struct):
    ''' Collection of object effects
    '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'ShaderFx':
        ''' Add a new shader fx

        :param name: New name for the effect
        :type name: str
        :param type: Effect type to add * FX_BLUR Blur, Apply Gaussian Blur to object. * FX_COLORIZE Colorize, Apply different tint effects. * FX_FLIP Flip, Flip image. * FX_GLOW Glow, Create a glow effect. * FX_PIXEL Pixelate, Pixelate image. * FX_RIM Rim, Add a rim to the image. * FX_SHADOW Shadow, Create a shadow effect. * FX_SWIRL Swirl, Create a rotation distortion. * FX_WAVE Wave Distortion, Apply sinusoidal deformation.
        :type type: typing.Union[str, int]
        :rtype: 'ShaderFx'
        :return: Newly created effect
        '''
        pass

    def remove(self, shader_fx: 'ShaderFx'):
        ''' Remove an existing effect from the object

        :param shader_fx: Effect to remove
        :type shader_fx: 'ShaderFx'
        '''
        pass

    def clear(self):
        ''' Remove all effects from the object

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Operator(bpy_struct):
    ''' Storage of an operator being executed, or registered after execution
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * REGISTER Register, Display in the info window and support the redo toolbar panel. * UNDO Undo, Push an undo event (needed for operator redo). * UNDO_GROUPED Grouped Undo, Push a single undo event for repeated instances of this operator. * BLOCKING Blocking, Block anything else from using the cursor. * MACRO Macro, Use to check if an operator is a macro. * GRAB_CURSOR Grab Pointer, Use so the operator grabs the mouse focus, enables wrapping when continuous grab is enabled. * GRAB_CURSOR_X Grab Pointer X, Grab, only warping the X axis. * GRAB_CURSOR_Y Grab Pointer Y, Grab, only warping the Y axis. * PRESET Preset, Display a preset button with the operators settings. * INTERNAL Internal, Removes the operator from search results.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    bl_undo_group: str = None
    ''' 

    :type: str
    '''

    has_reports: bool = None
    ''' Operator has a set of reports (warnings and errors) from last execution

    :type: bool
    '''

    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''

    macros: typing.Union[typing.Dict[str, 'Macro'], typing.
                         List['Macro'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'Macro'], typing.List['Macro'], 'bpy_prop_collection']
    '''

    name: str = None
    ''' 

    :type: str
    '''

    options: 'OperatorOptions' = None
    ''' Runtime options

    :type: 'OperatorOptions'
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    bl_property: str = None
    ''' The name of a property to use as this operators primary property. Currently this is only used to select the default property when expanding an operator into a menu.

    :type: str
    '''

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        ''' report

        :param type: Type
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message
        :type message: str
        '''
        pass

    def is_repeat(self) -> bool:
        ''' is_repeat

        :rtype: bool
        :return: result
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context'):
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        '''
        pass

    def execute(self, context: 'Context'
                ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Execute the operator

        :param context: 
        :type context: 'Context'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * RUNNING_MODAL Running Modal, Keep the operator running with blender. * CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed. * FINISHED Finished, The operator exited after completing its action. * PASS_THROUGH Pass Through, Do nothing and pass the event on. * INTERFACE Interface, Handled but not executed (popup menus).
        '''
        pass

    def check(self, context: 'Context') -> bool:
        ''' Check the operator settings, return True to signal a change to redraw

        :param context: 
        :type context: 'Context'
        :rtype: bool
        :return: result
        '''
        pass

    def invoke(self, context: 'Context', event: 'Event'
               ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Invoke the operator

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * RUNNING_MODAL Running Modal, Keep the operator running with blender. * CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed. * FINISHED Finished, The operator exited after completing its action. * PASS_THROUGH Pass Through, Do nothing and pass the event on. * INTERFACE Interface, Handled but not executed (popup menus).
        '''
        pass

    def modal(self, context: 'Context', event: 'Event'
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Modal operator function

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * RUNNING_MODAL Running Modal, Keep the operator running with blender. * CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed. * FINISHED Finished, The operator exited after completing its action. * PASS_THROUGH Pass Through, Do nothing and pass the event on. * INTERFACE Interface, Handled but not executed (popup menus).
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass

    def cancel(self, context: 'Context'):
        ''' Called when the operator is canceled

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def description(cls, context: 'Context',
                    properties: 'OperatorProperties') -> str:
        ''' Compute a description string that depends on parameters

        :param context: 
        :type context: 'Context'
        :param properties: 
        :type properties: 'OperatorProperties'
        :rtype: str
        :return: result
        '''
        pass

    def as_keywords(self, ignore=()):
        ''' Return a copy of the properties as a dictionary

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class OperatorMacro(bpy_struct):
    ''' Storage of a sub operator in a macro after it has been added
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class OperatorOptions(bpy_struct):
    ''' Runtime options
    '''

    is_grab_cursor: bool = None
    ''' True when the cursor is grabbed

    :type: bool
    '''

    is_invoke: bool = None
    ''' True when invoked (even if only the execute callbacks available)

    :type: bool
    '''

    is_repeat: bool = None
    ''' True when run from the 'Adjust Last Operation' panel

    :type: bool
    '''

    is_repeat_last: bool = None
    ''' True when run from the operator 'Repeat Last'

    :type: bool
    '''

    use_cursor_region: bool = None
    ''' Enable to use the region under the cursor for modal execution

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class OperatorProperties(bpy_struct):
    ''' Input properties of an operator
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PackedFile(bpy_struct):
    ''' External file packed into the .blend file
    '''

    data: str = None
    ''' Raw data (bytes, exact content of the embedded file)

    :type: str
    '''

    size: int = None
    ''' Size of packed file in bytes

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Paint(bpy_struct):
    brush: 'Brush' = None
    ''' Active Brush

    :type: 'Brush'
    '''

    cavity_curve: 'CurveMapping' = None
    ''' Editable cavity curve

    :type: 'CurveMapping'
    '''

    input_samples: int = None
    ''' Average multiple input samples together to smooth the brush stroke

    :type: int
    '''

    palette: 'Palette' = None
    ''' Active Palette

    :type: 'Palette'
    '''

    show_brush: bool = None
    ''' 

    :type: bool
    '''

    show_brush_on_surface: bool = None
    ''' 

    :type: bool
    '''

    show_low_resolution: bool = None
    ''' For multires, show low resolution while navigating the view

    :type: bool
    '''

    tile_offset: typing.List[float] = None
    ''' Stride at which tiled strokes are copied

    :type: typing.List[float]
    '''

    tile_x: bool = None
    ''' Tile along X axis

    :type: bool
    '''

    tile_y: bool = None
    ''' Tile along Y axis

    :type: bool
    '''

    tile_z: bool = None
    ''' Tile along Z axis

    :type: bool
    '''

    tool_slots: typing.Union[typing.Dict[str, 'PaintToolSlot'], typing.
                             List['PaintToolSlot'],
                             'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'PaintToolSlot'], typing.List['PaintToolSlot'], 'bpy_prop_collection']
    '''

    use_cavity: bool = None
    ''' Mask painting according to mesh geometry cavity

    :type: bool
    '''

    use_sculpt_delay_updates: bool = None
    ''' Update the geometry when it enters the view, providing faster view navigation

    :type: bool
    '''

    use_symmetry_feather: bool = None
    ''' Reduce the strength of the brush where it overlaps symmetrical daubs

    :type: bool
    '''

    use_symmetry_x: bool = None
    ''' Mirror brush across the X axis

    :type: bool
    '''

    use_symmetry_y: bool = None
    ''' Mirror brush across the Y axis

    :type: bool
    '''

    use_symmetry_z: bool = None
    ''' Mirror brush across the Z axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PaintToolSlot(bpy_struct):
    brush: 'Brush' = None
    ''' 

    :type: 'Brush'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PaletteColor(bpy_struct):
    color: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    strength: float = None
    ''' 

    :type: float
    '''

    weight: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PaletteColors(bpy_struct):
    ''' Collection of palette colors
    '''

    active: 'PaletteColor' = None
    ''' 

    :type: 'PaletteColor'
    '''

    def new(self) -> 'PaletteColor':
        ''' Add a new color to the palette

        :rtype: 'PaletteColor'
        :return: The newly created color
        '''
        pass

    def remove(self, color: 'PaletteColor'):
        ''' Remove a color from the palette

        :param color: The color to remove
        :type color: 'PaletteColor'
        '''
        pass

    def clear(self):
        ''' Remove all colors from the palette

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Panel(bpy_struct):
    ''' Panel containing UI elements
    '''

    bl_category: str = None
    ''' 

    :type: str
    '''

    bl_context: str = None
    ''' The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type)

    :type: str
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: str = None
    ''' If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is "OBJECT_PT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_PT_hello"

    :type: str
    '''

    bl_label: str = None
    ''' The panel label, shows up in the panel header at the right of the triangle used to collapse the panel

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this panel type * DEFAULT_CLOSED Default Closed, Defines if the panel has to be open or collapsed at the time of its creation. * HIDE_HEADER Hide Header, If set to False, the panel shows a header, which contains a clickable arrow to collapse the panel and the label (see bl_label). * INSTANCED Instanced Panel, Multiple panels with this type can be used as part of a list depending on data external to the UI. Used to create panels for the modifiers and other stacks. * HEADER_LAYOUT_EXPAND Expand Header Layout, Allow buttons in the header to stretch and shrink to fill the entire layout width. * DRAW_BOX Box Style, Display panel with the box widget theme.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_order: int = None
    ''' Panels with lower numbers are default ordered before panels with higher numbers

    :type: int
    '''

    bl_owner_id: str = None
    ''' 

    :type: str
    '''

    bl_parent_id: str = None
    ''' If this is set, the panel becomes a sub-panel

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the panel is going to be used in * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    bl_ui_units_x: int = None
    ''' When set, defines popup panel width

    :type: int
    '''

    custom_data: 'Constraint' = None
    ''' Panel data

    :type: 'Constraint'
    '''

    is_popover: bool = None
    ''' 

    :type: bool
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the panel in the UI

    :type: 'UILayout'
    '''

    text: str = None
    ''' XXX todo

    :type: str
    '''

    use_pin: bool = None
    ''' Show the panel on all tabs

    :type: bool
    '''

    @classmethod
    def poll(cls, context: 'Context'):
        ''' If this method returns a non-null output, then the panel can be drawn

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw UI elements into the panel UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_header(self, context: 'Context'):
        ''' Draw UI elements into the panel's header UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_header_preset(self, context: 'Context'):
        ''' Draw UI elements for presets in the panel's header

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Particle(bpy_struct):
    ''' Particle in a particle system
    '''

    alive_state: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    angular_velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    birth_time: float = None
    ''' 

    :type: float
    '''

    die_time: float = None
    ''' 

    :type: float
    '''

    hair_keys: typing.Union[typing.Dict[str, 'ParticleHairKey'], typing.
                            List['ParticleHairKey'],
                            'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ParticleHairKey'], typing.List['ParticleHairKey'], 'bpy_prop_collection']
    '''

    is_exist: bool = None
    ''' 

    :type: bool
    '''

    is_visible: bool = None
    ''' 

    :type: bool
    '''

    lifetime: float = None
    ''' 

    :type: float
    '''

    location: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    particle_keys: typing.Union[typing.Dict[str, 'ParticleKey'], typing.
                                List['ParticleKey'],
                                'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ParticleKey'], typing.List['ParticleKey'], 'bpy_prop_collection']
    '''

    prev_angular_velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    prev_location: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    prev_rotation: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    prev_velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    size: float = None
    ''' 

    :type: float
    '''

    velocity: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    def uv_on_emitter(
            self, modifier: 'ParticleSystemModifier') -> typing.List[float]:
        ''' Obtain UV coordinates for a particle on an evaluated mesh.

        :param modifier: Particle modifier from an evaluated object
        :type modifier: 'ParticleSystemModifier'
        :rtype: typing.List[float]
        :return: uv
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleBrush(bpy_struct):
    ''' Particle editing brush
    '''

    count: int = None
    ''' Particle count

    :type: int
    '''

    curve: 'CurveMapping' = None
    ''' 

    :type: 'CurveMapping'
    '''

    length_mode: typing.Union[str, int] = None
    ''' * GROW Grow, Make hairs longer. * SHRINK Shrink, Make hairs shorter.

    :type: typing.Union[str, int]
    '''

    puff_mode: typing.Union[str, int] = None
    ''' * ADD Add, Make hairs more puffy. * SUB Sub, Make hairs less puffy.

    :type: typing.Union[str, int]
    '''

    size: int = None
    ''' Radius of the brush in pixels

    :type: int
    '''

    steps: int = None
    ''' Brush steps

    :type: int
    '''

    strength: float = None
    ''' Brush strength

    :type: float
    '''

    use_puff_volume: bool = None
    ''' Apply puff to unselected end-points (helps maintain hair volume when puffing root)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleDupliWeight(bpy_struct):
    ''' Weight of a particle instance object in a collection
    '''

    count: int = None
    ''' The number of times this object is repeated with respect to other objects

    :type: int
    '''

    name: str = None
    ''' Particle instance object name

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleEdit(bpy_struct):
    ''' Properties of particle editing mode
    '''

    brush: 'ParticleBrush' = None
    ''' 

    :type: 'ParticleBrush'
    '''

    default_key_count: int = None
    ''' How many keys to make new particles with

    :type: int
    '''

    display_step: int = None
    ''' How many steps to display the path with

    :type: int
    '''

    emitter_distance: float = None
    ''' Distance to keep particles away from the emitter

    :type: float
    '''

    fade_frames: int = None
    ''' How many frames to fade

    :type: int
    '''

    is_editable: bool = None
    ''' A valid edit mode exists

    :type: bool
    '''

    is_hair: bool = None
    ''' Editing hair

    :type: bool
    '''

    object: 'Object' = None
    ''' The edited object

    :type: 'Object'
    '''

    select_mode: typing.Union[str, int] = None
    ''' Particle select and display mode * PATH Path, Path edit mode. * POINT Point, Point select mode. * TIP Tip, Tip select mode.

    :type: typing.Union[str, int]
    '''

    shape_object: 'Object' = None
    ''' Outer shape to use for tools

    :type: 'Object'
    '''

    show_particles: bool = None
    ''' Display actual particles

    :type: bool
    '''

    tool: typing.Union[str, int] = None
    ''' * COMB Comb, Comb hairs. * SMOOTH Smooth, Smooth hairs. * ADD Add, Add hairs. * LENGTH Length, Make hairs longer or shorter. * PUFF Puff, Make hairs stand up. * CUT Cut, Cut hairs. * WEIGHT Weight, Weight hair particles.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_auto_velocity: bool = None
    ''' Calculate point velocities automatically

    :type: bool
    '''

    use_default_interpolate: bool = None
    ''' Interpolate new particles from the existing ones

    :type: bool
    '''

    use_emitter_deflect: bool = None
    ''' Keep paths from intersecting the emitter

    :type: bool
    '''

    use_fade_time: bool = None
    ''' Fade paths and keys further away from current frame

    :type: bool
    '''

    use_preserve_length: bool = None
    ''' Keep path lengths constant

    :type: bool
    '''

    use_preserve_root: bool = None
    ''' Keep root keys unmodified

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleHairKey(bpy_struct):
    ''' Particle key for hair particle system
    '''

    co: typing.List[float] = None
    ''' Location of the hair key in object space

    :type: typing.List[float]
    '''

    co_local: typing.List[float] = None
    ''' Location of the hair key in its local coordinate system, relative to the emitting face

    :type: typing.List[float]
    '''

    time: float = None
    ''' Relative time of key over hair length

    :type: float
    '''

    weight: float = None
    ''' Weight for cloth simulation

    :type: float
    '''

    def co_object(self, object: 'Object', modifier: 'ParticleSystemModifier',
                  particle: 'Particle') -> typing.List[float]:
        ''' Obtain hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :rtype: typing.List[float]
        :return: Co, Exported hairkey location
        '''
        pass

    def co_object_set(self, object: 'Object',
                      modifier: 'ParticleSystemModifier', particle: 'Particle',
                      co: typing.List[float]):
        ''' Set hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :param co: Co, Specified hairkey location
        :type co: typing.List[float]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleKey(bpy_struct):
    ''' Key location for a particle over time
    '''

    angular_velocity: typing.List[float] = None
    ''' Key angular velocity

    :type: typing.List[float]
    '''

    location: typing.List[float] = None
    ''' Key location

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    ''' Key rotation quaternion

    :type: typing.List[float]
    '''

    time: float = None
    ''' Time of key over the simulation

    :type: float
    '''

    velocity: typing.List[float] = None
    ''' Key velocity

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleSettingsTextureSlots(bpy_struct):
    ''' Collection of texture slots
    '''

    @classmethod
    def add(cls) -> 'ParticleSettingsTextureSlot':
        ''' add

        :rtype: 'ParticleSettingsTextureSlot'
        :return: The newly initialized mtex
        '''
        pass

    @classmethod
    def create(cls, index: int) -> 'ParticleSettingsTextureSlot':
        ''' create

        :param index: Index, Slot index to initialize
        :type index: int
        :rtype: 'ParticleSettingsTextureSlot'
        :return: The newly initialized mtex
        '''
        pass

    @classmethod
    def clear(cls, index: int):
        ''' clear

        :param index: Index, Slot index to clear
        :type index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleSystem(bpy_struct):
    ''' Particle system in an object
    '''

    active_particle_target: 'ParticleTarget' = None
    ''' 

    :type: 'ParticleTarget'
    '''

    active_particle_target_index: int = None
    ''' 

    :type: int
    '''

    child_particles: typing.Union[typing.Dict[str, 'ChildParticle'], typing.
                                  List['ChildParticle'],
                                  'bpy_prop_collection'] = None
    ''' Child particles generated by the particle system

    :type: typing.Union[typing.Dict[str, 'ChildParticle'], typing.List['ChildParticle'], 'bpy_prop_collection']
    '''

    child_seed: int = None
    ''' Offset in the random number table for child particles, to get a different randomized result

    :type: int
    '''

    cloth: 'ClothModifier' = None
    ''' Cloth dynamics for hair

    :type: 'ClothModifier'
    '''

    dt_frac: float = None
    ''' The current simulation time step size, as a fraction of a frame

    :type: float
    '''

    has_multiple_caches: bool = None
    ''' Particle system has multiple point caches

    :type: bool
    '''

    invert_vertex_group_clump: bool = None
    ''' Negate the effect of the clump vertex group

    :type: bool
    '''

    invert_vertex_group_density: bool = None
    ''' Negate the effect of the density vertex group

    :type: bool
    '''

    invert_vertex_group_field: bool = None
    ''' Negate the effect of the field vertex group

    :type: bool
    '''

    invert_vertex_group_kink: bool = None
    ''' Negate the effect of the kink vertex group

    :type: bool
    '''

    invert_vertex_group_length: bool = None
    ''' Negate the effect of the length vertex group

    :type: bool
    '''

    invert_vertex_group_rotation: bool = None
    ''' Negate the effect of the rotation vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_1: bool = None
    ''' Negate the effect of the roughness 1 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_2: bool = None
    ''' Negate the effect of the roughness 2 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_end: bool = None
    ''' Negate the effect of the roughness end vertex group

    :type: bool
    '''

    invert_vertex_group_size: bool = None
    ''' Negate the effect of the size vertex group

    :type: bool
    '''

    invert_vertex_group_tangent: bool = None
    ''' Negate the effect of the tangent vertex group

    :type: bool
    '''

    invert_vertex_group_twist: bool = None
    ''' Negate the effect of the twist vertex group

    :type: bool
    '''

    invert_vertex_group_velocity: bool = None
    ''' Negate the effect of the velocity vertex group

    :type: bool
    '''

    is_editable: bool = None
    ''' Particle system can be edited in particle mode

    :type: bool
    '''

    is_edited: bool = None
    ''' Particle system has been edited in particle mode

    :type: bool
    '''

    is_global_hair: bool = None
    ''' Hair keys are in global coordinate space

    :type: bool
    '''

    name: str = None
    ''' Particle system name

    :type: str
    '''

    parent: 'Object' = None
    ''' Use this object's coordinate system instead of global coordinate system

    :type: 'Object'
    '''

    particles: typing.Union[typing.Dict[str, 'Particle'], typing.
                            List['Particle'], 'bpy_prop_collection'] = None
    ''' Particles generated by the particle system

    :type: typing.Union[typing.Dict[str, 'Particle'], typing.List['Particle'], 'bpy_prop_collection']
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    reactor_target_object: 'Object' = None
    ''' For reactor systems, the object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    reactor_target_particle_system: int = None
    ''' For reactor systems, index of particle system on the target object

    :type: int
    '''

    seed: int = None
    ''' Offset in the random number table, to get a different randomized result

    :type: int
    '''

    settings: 'ParticleSettings' = None
    ''' Particle system settings

    :type: 'ParticleSettings'
    '''

    targets: typing.Union[typing.Dict[str, 'ParticleTarget'], typing.
                          List['ParticleTarget'], 'bpy_prop_collection'] = None
    ''' Target particle systems

    :type: typing.Union[typing.Dict[str, 'ParticleTarget'], typing.List['ParticleTarget'], 'bpy_prop_collection']
    '''

    use_hair_dynamics: bool = None
    ''' Enable hair dynamics using cloth simulation

    :type: bool
    '''

    use_keyed_timing: bool = None
    ''' Use key times

    :type: bool
    '''

    vertex_group_clump: str = None
    ''' Vertex group to control clump

    :type: str
    '''

    vertex_group_density: str = None
    ''' Vertex group to control density

    :type: str
    '''

    vertex_group_field: str = None
    ''' Vertex group to control field

    :type: str
    '''

    vertex_group_kink: str = None
    ''' Vertex group to control kink

    :type: str
    '''

    vertex_group_length: str = None
    ''' Vertex group to control length

    :type: str
    '''

    vertex_group_rotation: str = None
    ''' Vertex group to control rotation

    :type: str
    '''

    vertex_group_roughness_1: str = None
    ''' Vertex group to control roughness 1

    :type: str
    '''

    vertex_group_roughness_2: str = None
    ''' Vertex group to control roughness 2

    :type: str
    '''

    vertex_group_roughness_end: str = None
    ''' Vertex group to control roughness end

    :type: str
    '''

    vertex_group_size: str = None
    ''' Vertex group to control size

    :type: str
    '''

    vertex_group_tangent: str = None
    ''' Vertex group to control tangent

    :type: str
    '''

    vertex_group_twist: str = None
    ''' Vertex group to control twist

    :type: str
    '''

    vertex_group_velocity: str = None
    ''' Vertex group to control velocity

    :type: str
    '''

    def co_hair(self, object: 'Object', particle_no: int = 0,
                step: int = 0) -> typing.List[float]:
        ''' Obtain cache hair data

        :param object: Object
        :type object: 'Object'
        :param particle_no: Particle no
        :type particle_no: int
        :param step: step no
        :type step: int
        :rtype: typing.List[float]
        :return: Co, Exported hairkey location
        '''
        pass

    def uv_on_emitter(self,
                      modifier: 'ParticleSystemModifier',
                      particle: 'Particle',
                      particle_no: int = 0,
                      uv_no: int = 0) -> typing.List[float]:
        ''' Obtain uv for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: int
        :param uv_no: UV no
        :type uv_no: int
        :rtype: typing.List[float]
        :return: uv
        '''
        pass

    def mcol_on_emitter(self,
                        modifier: 'ParticleSystemModifier',
                        particle: 'Particle',
                        particle_no: int = 0,
                        vcol_no: int = 0) -> typing.List[float]:
        ''' Obtain mcol for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: int
        :param vcol_no: vcol no
        :type vcol_no: int
        :rtype: typing.List[float]
        :return: mcol
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleSystems(bpy_struct):
    ''' Collection of particle systems
    '''

    active: 'ParticleSystem' = None
    ''' Active particle system being displayed

    :type: 'ParticleSystem'
    '''

    active_index: int = None
    ''' Index of active particle system slot

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ParticleTarget(bpy_struct):
    ''' Target particle system
    '''

    alliance: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    duration: float = None
    ''' 

    :type: float
    '''

    is_valid: bool = None
    ''' Keyed particles target is valid

    :type: bool
    '''

    name: str = None
    ''' Particle target name

    :type: str
    '''

    object: 'Object' = None
    ''' The object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    system: int = None
    ''' The index of particle system on the target object

    :type: int
    '''

    time: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PathCompare(bpy_struct):
    ''' Match paths against this value
    '''

    path: str = None
    ''' 

    :type: str
    '''

    use_glob: bool = None
    ''' Enable wildcard globbing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PathCompareCollection(bpy_struct):
    ''' Collection of paths
    '''

    @classmethod
    def new(cls):
        ''' Add a new path

        '''
        pass

    @classmethod
    def remove(cls, pathcmp: 'PathCompare'):
        ''' Remove path

        :param pathcmp: 
        :type pathcmp: 'PathCompare'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PointCache(bpy_struct):
    ''' Active point cache for physics simulations
    '''

    compression: typing.Union[str, int] = None
    ''' Compression method to be used * NO None, No compression. * LIGHT Lite, Fast but not so effective compression. * HEAVY Heavy, Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    filepath: str = None
    ''' Cache file path

    :type: str
    '''

    frame_end: int = None
    ''' Frame on which the simulation stops

    :type: int
    '''

    frame_start: int = None
    ''' Frame on which the simulation starts

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between cached frames

    :type: int
    '''

    index: int = None
    ''' Index number of cache files

    :type: int
    '''

    info: str = None
    ''' Info on current cache status

    :type: str
    '''

    is_baked: bool = None
    ''' 

    :type: bool
    '''

    is_baking: bool = None
    ''' 

    :type: bool
    '''

    is_frame_skip: bool = None
    ''' 

    :type: bool
    '''

    is_outdated: bool = None
    ''' 

    :type: bool
    '''

    name: str = None
    ''' Cache name

    :type: str
    '''

    point_caches: typing.Union[typing.Dict[str, 'PointCacheItem'], typing.
                               List['PointCacheItem'], 'bpy_prop_collection',
                               'PointCaches'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'PointCacheItem'], typing.List['PointCacheItem'], 'bpy_prop_collection', 'PointCaches']
    '''

    use_disk_cache: bool = None
    ''' Save cache files to disk (.blend file must be saved first)

    :type: bool
    '''

    use_external: bool = None
    ''' Read cache from an external location

    :type: bool
    '''

    use_library_path: bool = None
    ''' Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PointCacheItem(bpy_struct):
    ''' Point cache for physics simulations
    '''

    compression: typing.Union[str, int] = None
    ''' Compression method to be used * NO None, No compression. * LIGHT Lite, Fast but not so effective compression. * HEAVY Heavy, Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    filepath: str = None
    ''' Cache file path

    :type: str
    '''

    frame_end: int = None
    ''' Frame on which the simulation stops

    :type: int
    '''

    frame_start: int = None
    ''' Frame on which the simulation starts

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between cached frames

    :type: int
    '''

    index: int = None
    ''' Index number of cache files

    :type: int
    '''

    info: str = None
    ''' Info on current cache status

    :type: str
    '''

    is_baked: bool = None
    ''' 

    :type: bool
    '''

    is_baking: bool = None
    ''' 

    :type: bool
    '''

    is_frame_skip: bool = None
    ''' 

    :type: bool
    '''

    is_outdated: bool = None
    ''' 

    :type: bool
    '''

    name: str = None
    ''' Cache name

    :type: str
    '''

    use_disk_cache: bool = None
    ''' Save cache files to disk (.blend file must be saved first)

    :type: bool
    '''

    use_external: bool = None
    ''' Read cache from an external location

    :type: bool
    '''

    use_library_path: bool = None
    ''' Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PointCaches(bpy_struct):
    ''' Collection of point caches
    '''

    active_index: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PolygonFloatProperties(bpy_struct):
    ''' Collection of float properties
    '''

    def new(self, name: str = "Float Prop") -> 'MeshPolygonFloatPropertyLayer':
        ''' Add a float property layer to Mesh

        :param name: Float property name
        :type name: str
        :rtype: 'MeshPolygonFloatPropertyLayer'
        :return: The newly created layer
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PolygonIntProperties(bpy_struct):
    ''' Collection of int properties
    '''

    def new(self, name: str = "Int Prop") -> 'MeshPolygonIntPropertyLayer':
        ''' Add a integer property layer to Mesh

        :param name: Int property name
        :type name: str
        :rtype: 'MeshPolygonIntPropertyLayer'
        :return: The newly created layer
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PolygonStringProperties(bpy_struct):
    ''' Collection of string properties
    '''

    def new(self,
            name: str = "String Prop") -> 'MeshPolygonStringPropertyLayer':
        ''' Add a string property layer to Mesh

        :param name: String property name
        :type name: str
        :rtype: 'MeshPolygonStringPropertyLayer'
        :return: The newly created layer
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Pose(bpy_struct):
    ''' A collection of pose channels, including settings for animating bones
    '''

    animation_visualization: 'AnimViz' = None
    ''' Animation data for this data-block

    :type: 'AnimViz'
    '''

    bone_groups: typing.Union[typing.Dict[str, 'BoneGroup'], typing.
                              List['BoneGroup'], 'bpy_prop_collection',
                              'BoneGroups'] = None
    ''' Groups of the bones

    :type: typing.Union[typing.Dict[str, 'BoneGroup'], typing.List['BoneGroup'], 'bpy_prop_collection', 'BoneGroups']
    '''

    bones: typing.Union[typing.Dict[str, 'PoseBone'], typing.
                        List['PoseBone'], 'bpy_prop_collection'] = None
    ''' Individual pose bones for the armature

    :type: typing.Union[typing.Dict[str, 'PoseBone'], typing.List['PoseBone'], 'bpy_prop_collection']
    '''

    ik_param: 'IKParam' = None
    ''' Parameters for IK solver

    :type: 'IKParam'
    '''

    ik_solver: typing.Union[str, int] = None
    ''' Selection of IK solver for IK chain * LEGACY Standard, Original IK solver. * ITASC iTaSC, Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''

    use_auto_ik: bool = None
    ''' Add temporary IK constraints while grabbing bones in Pose Mode

    :type: bool
    '''

    use_mirror_relative: bool = None
    ''' Apply relative transformations in X-mirror mode (not supported with Auto IK)

    :type: bool
    '''

    use_mirror_x: bool = None
    ''' Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    '''

    @classmethod
    def apply_pose_from_action(cls,
                               action: 'Action',
                               evaluation_time: float = 0.0):
        ''' Apply the given action to this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: 'Action'
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: float
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PoseBone(bpy_struct):
    ''' Channel defining pose data for a bone in a Pose
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'PoseBone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_custom_handle_start: 'PoseBone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scaleinx: float = None
    ''' X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleiny: float = None
    ''' Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleoutx: float = None
    ''' X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleouty: float = None
    ''' Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bone: 'Bone' = None
    ''' Bone associated with this PoseBone

    :type: 'Bone'
    '''

    bone_group: 'BoneGroup' = None
    ''' Bone group this pose channel belongs to

    :type: 'BoneGroup'
    '''

    bone_group_index: int = None
    ''' Bone group this pose channel belongs to (0 means no group)

    :type: int
    '''

    child: 'PoseBone' = None
    ''' Child of this pose bone

    :type: 'PoseBone'
    '''

    constraints: typing.Union[typing.Dict[str, 'Constraint'], typing.
                              List['Constraint'], 'bpy_prop_collection',
                              'PoseBoneConstraints'] = None
    ''' Constraints that act on this pose channel

    :type: typing.Union[typing.Dict[str, 'Constraint'], typing.List['Constraint'], 'bpy_prop_collection', 'PoseBoneConstraints']
    '''

    custom_shape: 'Object' = None
    ''' Object that defines custom display shape for this bone

    :type: 'Object'
    '''

    custom_shape_scale: float = None
    ''' Adjust the size of the custom shape

    :type: float
    '''

    custom_shape_transform: 'PoseBone' = None
    ''' Bone that defines the display transform of this custom shape

    :type: 'PoseBone'
    '''

    head: typing.List[float] = None
    ''' Location of head of the channel's bone

    :type: typing.List[float]
    '''

    ik_linear_weight: float = None
    ''' Weight of scale constraint for IK

    :type: float
    '''

    ik_max_x: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_y: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_z: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_min_x: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_y: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_z: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_rotation_weight: float = None
    ''' Weight of rotation constraint for IK

    :type: float
    '''

    ik_stiffness_x: float = None
    ''' IK stiffness around the X axis

    :type: float
    '''

    ik_stiffness_y: float = None
    ''' IK stiffness around the Y axis

    :type: float
    '''

    ik_stiffness_z: float = None
    ''' IK stiffness around the Z axis

    :type: float
    '''

    ik_stretch: float = None
    ''' Allow scaling of the bone for IK

    :type: float
    '''

    is_in_ik_chain: bool = None
    ''' Is part of an IK chain

    :type: bool
    '''

    length: float = None
    ''' Length of the bone

    :type: float
    '''

    location: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    lock_ik_x: bool = None
    ''' Disallow movement around the X axis

    :type: bool
    '''

    lock_ik_y: bool = None
    ''' Disallow movement around the Y axis

    :type: bool
    '''

    lock_ik_z: bool = None
    ''' Disallow movement around the Z axis

    :type: bool
    '''

    lock_location: typing.List[bool] = None
    ''' Lock editing of location when transforming

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    ''' Lock editing of rotation when transforming

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    ''' Lock editing of 'angle' component of four-component rotations when transforming

    :type: bool
    '''

    lock_rotations_4d: bool = None
    ''' Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    ''' Lock editing of scale when transforming

    :type: typing.List[bool]
    '''

    matrix: typing.List[float] = None
    ''' Final 4x4 matrix after constraints and drivers are applied (object space)

    :type: typing.List[float]
    '''

    matrix_basis: typing.List[float] = None
    ''' Alternative access to location/scale/rotation relative to the parent and own rest bone

    :type: typing.List[float]
    '''

    matrix_channel: typing.List[float] = None
    ''' 4x4 matrix, before constraints

    :type: typing.List[float]
    '''

    motion_path: 'MotionPath' = None
    ''' Motion Path for this element

    :type: 'MotionPath'
    '''

    name: str = None
    ''' 

    :type: str
    '''

    parent: 'PoseBone' = None
    ''' Parent of this pose bone

    :type: 'PoseBone'
    '''

    rotation_axis_angle: typing.List[float] = None
    ''' Angle of Rotation for Axis-Angle rotation representation

    :type: typing.List[float]
    '''

    rotation_euler: typing.List[float] = None
    ''' Rotation in Eulers

    :type: typing.List[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' * QUATERNION Quaternion (WXYZ), No Gimbal Lock. * XYZ XYZ Euler, XYZ Rotation Order - prone to Gimbal Lock (default). * XZY XZY Euler, XZY Rotation Order - prone to Gimbal Lock. * YXZ YXZ Euler, YXZ Rotation Order - prone to Gimbal Lock. * YZX YZX Euler, YZX Rotation Order - prone to Gimbal Lock. * ZXY ZXY Euler, ZXY Rotation Order - prone to Gimbal Lock. * ZYX ZYX Euler, ZYX Rotation Order - prone to Gimbal Lock. * AXIS_ANGLE Axis Angle, Axis Angle (W+XYZ), defines a rotation around some axis defined by 3D-Vector.

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: typing.List[float] = None
    ''' Rotation in Quaternions

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    tail: typing.List[float] = None
    ''' Location of tail of the channel's bone

    :type: typing.List[float]
    '''

    use_custom_shape_bone_size: bool = None
    ''' Scale the custom object by the bone length

    :type: bool
    '''

    use_ik_limit_x: bool = None
    ''' Limit movement around the X axis

    :type: bool
    '''

    use_ik_limit_y: bool = None
    ''' Limit movement around the Y axis

    :type: bool
    '''

    use_ik_limit_z: bool = None
    ''' Limit movement around the Z axis

    :type: bool
    '''

    use_ik_linear_control: bool = None
    ''' Apply channel size as IK constraint if stretching is enabled

    :type: bool
    '''

    use_ik_rotation_control: bool = None
    ''' Apply channel rotation as IK constraint

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes O(len(bones)**2) time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(self, point: typing.List[float]) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.List[float]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def bbone_segment_matrix(self, index: int,
                             rest: bool = False) -> typing.List[float]:
        ''' Retrieve the matrix of the joint between B-Bone segments if available

        :param index: Index of the segment endpoint
        :type index: int
        :param rest: Return the rest pose matrix
        :type rest: bool
        :rtype: typing.List[float]
        :return: The resulting matrix in bone local space
        '''
        pass

    def compute_bbone_handles(self,
                              rest: bool = False,
                              ease: bool = False,
                              offsets: bool = False):
        ''' Retrieve the vectors and rolls coming from B-Bone custom handles

        :param rest: Return the rest pose state
        :type rest: bool
        :param ease: Apply scale from ease values
        :type ease: bool
        :param offsets: Apply roll and curve offsets from bone properties
        :type offsets: bool
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PoseBoneConstraints(bpy_struct):
    ''' Collection of pose bone constraints
    '''

    active: 'Constraint' = None
    ''' Active PoseChannel constraint

    :type: 'Constraint'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Constraint':
        ''' Add a constraint to this object

        :param type: Constraint type to add * CAMERA_SOLVER Camera Solver. * FOLLOW_TRACK Follow Track. * OBJECT_SOLVER Object Solver. * COPY_LOCATION Copy Location, Copy the location of a target (with an optional offset), so that they move together. * COPY_ROTATION Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * COPY_SCALE Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * COPY_TRANSFORMS Copy Transforms, Copy all the transformations of a target, so that they move together. * LIMIT_DISTANCE Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * LIMIT_LOCATION Limit Location, Restrict movement along each axis within given ranges. * LIMIT_ROTATION Limit Rotation, Restrict rotation along each axis within given ranges. * LIMIT_SCALE Limit Scale, Restrict scaling along each axis with given ranges. * MAINTAIN_VOLUME Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * TRANSFORM Transformation, Use one transform property from target to control another (or same) property on owner. * TRANSFORM_CACHE Transform Cache, Look up the transformation matrix from an external file. * CLAMP_TO Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * DAMPED_TRACK Damped Track, Point towards a target by performing the smallest rotation necessary. * IK Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * LOCKED_TRACK Locked Track, Rotate around the specified ('locked') axis to point towards a target. * SPLINE_IK Spline IK, Align chain of bones along a curve (Bones only). * STRETCH_TO Stretch To, Stretch along Y-Axis to point towards a target. * TRACK_TO Track To, Legacy tracking constraint prone to twisting artifacts. * ACTION Action, Use transform property of target to look up pose for owner from an Action. * ARMATURE Armature, Apply weight-blended transformation from multiple bones like the Armature modifier. * CHILD_OF Child Of, Make target the 'detachable' parent of owner. * FLOOR Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * FOLLOW_PATH Follow Path, Use to animate an object/bone following a path. * PIVOT Pivot, Change pivot point for transforms (buggy). * SHRINKWRAP Shrinkwrap, Restrict movements to surface of target mesh.
        :type type: typing.Union[str, int]
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        ''' Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        '''
        pass

    def move(self, from_index: int, to_index: int):
        ''' Move a constraint to a different position

        :param from_index: From Index, Index to move
        :type from_index: int
        :param to_index: To Index, Target index
        :type to_index: int
        '''
        pass

    def copy(self, constraint: 'Constraint') -> 'Constraint':
        ''' Add a new constraint that is a copy of the given one

        :param constraint: Constraint to copy - may belong to a different object
        :type constraint: 'Constraint'
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Preferences(bpy_struct):
    ''' Global preferences
    '''

    active_section: typing.Union[str, int] = None
    ''' Active section of the preferences shown in the user interface

    :type: typing.Union[str, int]
    '''

    addons: typing.Union[typing.Dict[str, 'Addon'], typing.
                         List['Addon'], 'bpy_prop_collection', 'Addons'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'Addon'], typing.List['Addon'], 'bpy_prop_collection', 'Addons']
    '''

    app_template: str = None
    ''' 

    :type: str
    '''

    autoexec_paths: typing.Union[typing.Dict[str, 'PathCompare'], typing.
                                 List['PathCompare'], 'bpy_prop_collection',
                                 'PathCompareCollection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'PathCompare'], typing.List['PathCompare'], 'bpy_prop_collection', 'PathCompareCollection']
    '''

    edit: 'PreferencesEdit' = None
    ''' Settings for interacting with Blender data

    :type: 'PreferencesEdit'
    '''

    experimental: 'PreferencesExperimental' = None
    ''' Settings for features that are still early in their development stage

    :type: 'PreferencesExperimental'
    '''

    filepaths: 'PreferencesFilePaths' = None
    ''' Default paths for external files

    :type: 'PreferencesFilePaths'
    '''

    inputs: 'PreferencesInput' = None
    ''' Settings for input devices

    :type: 'PreferencesInput'
    '''

    is_dirty: bool = None
    ''' Preferences have changed

    :type: bool
    '''

    keymap: 'PreferencesKeymap' = None
    ''' Shortcut setup for keyboards and other input devices

    :type: 'PreferencesKeymap'
    '''

    studio_lights: typing.Union[typing.Dict[str, 'StudioLight'], typing.
                                List['StudioLight'], 'bpy_prop_collection',
                                'StudioLights'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'StudioLight'], typing.List['StudioLight'], 'bpy_prop_collection', 'StudioLights']
    '''

    system: 'PreferencesSystem' = None
    ''' Graphics driver and operating system settings

    :type: 'PreferencesSystem'
    '''

    themes: typing.Union[typing.Dict[str, 'Theme'], typing.
                         List['Theme'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'Theme'], typing.List['Theme'], 'bpy_prop_collection']
    '''

    ui_styles: typing.Union[typing.Dict[str, 'ThemeStyle'], typing.
                            List['ThemeStyle'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ThemeStyle'], typing.List['ThemeStyle'], 'bpy_prop_collection']
    '''

    use_preferences_save: bool = None
    ''' Save preferences on exit when modified (unless factory settings have been loaded)

    :type: bool
    '''

    version: typing.List[int] = None
    ''' Version of Blender the userpref.blend was saved with

    :type: typing.List[int]
    '''

    view: 'PreferencesView' = None
    ''' Preferences related to viewing data

    :type: 'PreferencesView'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesEdit(bpy_struct):
    ''' Settings for interacting with Blender data
    '''

    auto_keying_mode: typing.Union[str, int] = None
    ''' Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: typing.Union[str, int]
    '''

    collection_instance_empty_size: float = None
    ''' Display size of the empty when new collection instances are created

    :type: float
    '''

    fcurve_new_auto_smoothing: typing.Union[str, int] = None
    ''' Auto Handle Smoothing mode used for newly added F-Curves * NONE None, Automatic handles only take immediately adjacent keys into account. * CONT_ACCEL Continuous Acceleration, Automatic handles are adjusted to avoid jumps in acceleration, resulting in smoother curves. However, key changes may affect interpolation over a larger stretch of the curve.

    :type: typing.Union[str, int]
    '''

    fcurve_unselected_alpha: float = None
    ''' The opacity of unselected F-Curves against the background of the Graph Editor

    :type: float
    '''

    grease_pencil_default_color: typing.List[float] = None
    ''' Color of new annotation layers

    :type: typing.List[float]
    '''

    grease_pencil_eraser_radius: int = None
    ''' Radius of eraser 'brush'

    :type: int
    '''

    grease_pencil_euclidean_distance: int = None
    ''' Distance moved by mouse when drawing stroke to include

    :type: int
    '''

    grease_pencil_manhattan_distance: int = None
    ''' Pixels moved by mouse per axis when drawing stroke

    :type: int
    '''

    keyframe_new_handle_type: typing.Union[str, int] = None
    ''' Handle type for handles of new keyframes * FREE Free, Completely independent manually set handle. * ALIGNED Aligned, Manually set handle with rotation locked together with its pair. * VECTOR Vector, Automatic handles that create straight lines. * AUTO Automatic, Automatic handles that create smooth curves. * AUTO_CLAMPED Auto Clamped, Automatic handles that create smooth curves which only change direction at keyframes.

    :type: typing.Union[str, int]
    '''

    keyframe_new_interpolation_type: typing.Union[str, int] = None
    ''' Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe) * CONSTANT Constant, No interpolation, value of A gets held until B is encountered. * LINEAR Linear, Straight-line interpolation between A and B (i.e. no ease in/out). * BEZIER Bezier, Smooth interpolation between A and B, with some control over curve shape. * SINE Sinusoidal, Sinusoidal easing (weakest, almost linear but with a slight curvature). * QUAD Quadratic, Quadratic easing. * CUBIC Cubic, Cubic easing. * QUART Quartic, Quartic easing. * QUINT Quintic, Quintic easing. * EXPO Exponential, Exponential easing (dramatic). * CIRC Circular, Circular easing (strongest and most dynamic). * BACK Back, Cubic easing with overshoot and settle. * BOUNCE Bounce, Exponentially decaying parabolic bounce, like when objects collide. * ELASTIC Elastic, Exponentially decaying sine wave, like an elastic band.

    :type: typing.Union[str, int]
    '''

    material_link: typing.Union[str, int] = None
    ''' Toggle whether the material is linked to object data or the object block * OBDATA Object Data, Toggle whether the material is linked to object data or the object block. * OBJECT Object, Toggle whether the material is linked to object data or the object block.

    :type: typing.Union[str, int]
    '''

    node_margin: int = None
    ''' Minimum distance between nodes for Auto-offsetting nodes

    :type: int
    '''

    object_align: typing.Union[str, int] = None
    ''' When adding objects from a 3D View menu, either align them with that view or with the world * WORLD World, Align newly added objects to the world coordinate system. * VIEW View, Align newly added objects to the active 3D View direction. * CURSOR 3D Cursor, Align newly added objects to the 3D Cursor's rotation.

    :type: typing.Union[str, int]
    '''

    sculpt_paint_overlay_color: typing.List[float] = None
    ''' Color of texture overlay

    :type: typing.List[float]
    '''

    undo_memory_limit: int = None
    ''' Maximum memory usage in megabytes (0 means unlimited)

    :type: int
    '''

    undo_steps: int = None
    ''' Number of undo steps available (smaller values conserve memory)

    :type: int
    '''

    use_anim_channel_group_colors: bool = None
    ''' Use animation channel group colors; generally this is used to show bone group colors

    :type: bool
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: bool
    '''

    use_auto_keying_warning: bool = None
    ''' Show warning indicators when transforming objects and bones if auto keying is enabled

    :type: bool
    '''

    use_cursor_lock_adjust: bool = None
    ''' Place the cursor without 'jumping' to the new location (when lock-to-cursor is used)

    :type: bool
    '''

    use_duplicate_action: bool = None
    ''' Causes actions to be duplicated with the data-blocks

    :type: bool
    '''

    use_duplicate_armature: bool = None
    ''' Causes armature data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_curve: bool = None
    ''' Causes curve data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_grease_pencil: bool = None
    ''' Causes grease pencil data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_hair: bool = None
    ''' Causes hair data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_light: bool = None
    ''' Causes light data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_lightprobe: bool = None
    ''' Causes light probe data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_material: bool = None
    ''' Causes material data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_mesh: bool = None
    ''' Causes mesh data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_metaball: bool = None
    ''' Causes metaball data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_particle: bool = None
    ''' Causes particle systems to be duplicated with the object

    :type: bool
    '''

    use_duplicate_pointcloud: bool = None
    ''' Causes point cloud data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_surface: bool = None
    ''' Causes surface data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_text: bool = None
    ''' Causes text data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_volume: bool = None
    ''' Causes volume data to be duplicated with the object

    :type: bool
    '''

    use_enter_edit_mode: bool = None
    ''' Enter Edit Mode automatically after adding a new object

    :type: bool
    '''

    use_global_undo: bool = None
    ''' Global undo works by keeping a full copy of the file itself in memory, so takes extra memory

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis

    :type: bool
    '''

    use_keyframe_insert_available: bool = None
    ''' Automatic keyframe insertion in available F-Curves

    :type: bool
    '''

    use_keyframe_insert_needed: bool = None
    ''' Keyframe insertion only when keyframe needed

    :type: bool
    '''

    use_mouse_depth_cursor: bool = None
    ''' Use the surface depth for cursor placement

    :type: bool
    '''

    use_negative_frames: bool = None
    ''' Current frame number can be manually set to a negative value

    :type: bool
    '''

    use_visual_keying: bool = None
    ''' Use Visual keying automatically for constrained objects

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesExperimental(bpy_struct):
    ''' Experimental features
    '''

    override_auto_resync: bool = None
    ''' Enable library overrides automatic resync detection and process on file load. Disable when dealing with older .blend files that need manual Resync (Enforce) handling

    :type: bool
    '''

    use_asset_browser: bool = None
    ''' Enable Asset Browser editor and operators to manage data-blocks as asset

    :type: bool
    '''

    use_cycles_debug: bool = None
    ''' Enable Cycles debugging options for developers

    :type: bool
    '''

    use_new_hair_type: bool = None
    ''' Enable the new hair type in the ui

    :type: bool
    '''

    use_new_point_cloud_type: bool = None
    ''' Enable the new point cloud type in the ui

    :type: bool
    '''

    use_override_templates: bool = None
    ''' Enable library override template in the python API

    :type: bool
    '''

    use_sculpt_tools_tilt: bool = None
    ''' Support for pen tablet tilt events in Sculpt Mode

    :type: bool
    '''

    use_sculpt_vertex_colors: bool = None
    ''' Use the new Vertex Painting system

    :type: bool
    '''

    use_undo_legacy: bool = None
    ''' Use legacy undo (slower than the new default one, but may be more stable in some cases)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesFilePaths(bpy_struct):
    ''' Default paths for external files
    '''

    animation_player: str = None
    ''' Path to a custom animation/frame sequence player

    :type: str
    '''

    animation_player_preset: typing.Union[str, int] = None
    ''' Preset configs for external animation players * INTERNAL Internal, Built-in animation player. * DJV DJV, Open source frame player. * FRAMECYCLER FrameCycler, Frame player from IRIDAS. * RV RV, Frame player from Tweak Software. * MPLAYER MPlayer, Media player for video and PNG/JPEG/SGI image sequences. * CUSTOM Custom, Custom animation player executable path.

    :type: typing.Union[str, int]
    '''

    asset_libraries: typing.Union[typing.Dict[str, 'UserAssetLibrary'], typing.
                                  List['UserAssetLibrary'],
                                  'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'UserAssetLibrary'], typing.List['UserAssetLibrary'], 'bpy_prop_collection']
    '''

    auto_save_time: int = None
    ''' The time (in minutes) to wait between automatic temporary saves

    :type: int
    '''

    font_directory: str = None
    ''' The default directory to search for loading fonts

    :type: str
    '''

    hide_recent_locations: bool = None
    ''' Hide recent locations in the file selector

    :type: bool
    '''

    hide_system_bookmarks: bool = None
    ''' Hide system bookmarks in the file selector

    :type: bool
    '''

    i18n_branches_directory: str = None
    ''' The path to the '/branches' directory of your local svn-translation copy, to allow translating from the UI

    :type: str
    '''

    image_editor: str = None
    ''' Path to an image editor

    :type: str
    '''

    recent_files: int = None
    ''' Maximum number of recently opened files to remember

    :type: int
    '''

    render_cache_directory: str = None
    ''' Where to cache raw render results

    :type: str
    '''

    render_output_directory: str = None
    ''' The default directory for rendering output, for new scenes

    :type: str
    '''

    save_version: int = None
    ''' The number of old versions to maintain in the current directory, when manually saving

    :type: int
    '''

    script_directory: str = None
    ''' Alternate script path, matching the default layout with subdirectories: startup, add-ons and modules (requires restart)

    :type: str
    '''

    show_hidden_files_datablocks: bool = None
    ''' Hide files and data-blocks if their name start with a dot (.*)

    :type: bool
    '''

    sound_directory: str = None
    ''' The default directory to search for sounds

    :type: str
    '''

    temporary_directory: str = None
    ''' The directory for storing temporary save files

    :type: str
    '''

    texture_directory: str = None
    ''' The default directory to search for textures

    :type: str
    '''

    use_auto_save_temporary_files: bool = None
    ''' Automatic saving of temporary files in temp directory, uses process ID. Warning: Sculpt and edit mode data won't be saved

    :type: bool
    '''

    use_file_compression: bool = None
    ''' Enable file compression when saving .blend files

    :type: bool
    '''

    use_filter_files: bool = None
    ''' Display only files with extensions in the image select window

    :type: bool
    '''

    use_load_ui: bool = None
    ''' Load user interface setup when loading .blend files

    :type: bool
    '''

    use_relative_paths: bool = None
    ''' Default relative path option for the file selector, when no path is defined yet

    :type: bool
    '''

    use_save_preview_images: bool = None
    ''' Enables automatic saving of preview images in the .blend file as well as a thumbnail of the .blend

    :type: bool
    '''

    use_scripts_auto_execute: bool = None
    ''' Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source)

    :type: bool
    '''

    use_tabs_as_spaces: bool = None
    ''' Automatically convert all new tabs into spaces for new and loaded text files

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesInput(bpy_struct):
    ''' Settings for input devices
    '''

    drag_threshold: int = None
    ''' Number of pixels to drag before a drag event is triggered for keyboard and other non mouse/tablet input (otherwise click events are detected)

    :type: int
    '''

    drag_threshold_mouse: int = None
    ''' Number of pixels to drag before a tweak/drag event is triggered for mouse/trackpad input (otherwise click events are detected)

    :type: int
    '''

    drag_threshold_tablet: int = None
    ''' Number of pixels to drag before a tweak/drag event is triggered for tablet input (otherwise click events are detected)

    :type: int
    '''

    invert_mouse_zoom: bool = None
    ''' Invert the axis of mouse movement for zooming

    :type: bool
    '''

    invert_zoom_wheel: bool = None
    ''' Swap the Mouse Wheel zoom direction

    :type: bool
    '''

    mouse_double_click_time: int = None
    ''' Time/delay (in ms) for a double click

    :type: int
    '''

    mouse_emulate_3_button_modifier: typing.Union[str, int] = None
    ''' Hold this modifier to emulate the middle mouse button

    :type: typing.Union[str, int]
    '''

    move_threshold: int = None
    ''' Number of pixels to before the cursor is considered to have moved (used for cycling selected items on successive clicks)

    :type: int
    '''

    navigation_mode: typing.Union[str, int] = None
    ''' Which method to use for viewport navigation * WALK Walk, Interactively walk or free navigate around the scene. * FLY Fly, Use fly dynamics to navigate the scene.

    :type: typing.Union[str, int]
    '''

    ndof_deadzone: float = None
    ''' Threshold of initial movement needed from the device's rest position

    :type: float
    '''

    ndof_fly_helicopter: bool = None
    ''' Device up/down directly controls the Z position of the 3D viewport

    :type: bool
    '''

    ndof_lock_horizon: bool = None
    ''' Keep horizon level while flying with 3D Mouse

    :type: bool
    '''

    ndof_orbit_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for orbiting

    :type: float
    '''

    ndof_pan_yz_swap_axis: bool = None
    ''' Pan using up/down on the device (otherwise forward/backward)

    :type: bool
    '''

    ndof_panx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_pany_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_panz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_roty_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for panning

    :type: float
    '''

    ndof_show_guide: bool = None
    ''' Display the center and axis during rotation

    :type: bool
    '''

    ndof_view_navigate_method: typing.Union[str, int] = None
    ''' Navigation style in the viewport * FREE Free, Use full 6 degrees of freedom by default. * ORBIT Orbit, Orbit about the view center by default.

    :type: typing.Union[str, int]
    '''

    ndof_view_rotate_method: typing.Union[str, int] = None
    ''' Rotation style in the viewport * TURNTABLE Turntable, Use turntable style rotation in the viewport. * TRACKBALL Trackball, Use trackball style rotation in the viewport.

    :type: typing.Union[str, int]
    '''

    ndof_zoom_invert: bool = None
    ''' Zoom using opposite direction

    :type: bool
    '''

    pressure_softness: float = None
    ''' Adjusts softness of the low pressure response onset using a gamma curve

    :type: float
    '''

    pressure_threshold_max: float = None
    ''' Raw input pressure value that is interpreted as 100% by Blender

    :type: float
    '''

    tablet_api: typing.Union[str, int] = None
    ''' Select the tablet API to use for pressure sensitivity (may require restarting Blender for changes to take effect) * AUTOMATIC Automatic, Automatically choose Wintab or Windows Ink depending on the device. * WINDOWS_INK Windows Ink, Use native Windows Ink API, for modern tablet and pen devices. Requires Windows 8 or newer. * WINTAB Wintab, Use Wintab driver for older tablets and Windows versions.

    :type: typing.Union[str, int]
    '''

    use_auto_perspective: bool = None
    ''' Automatically switch between orthographic and perspective when changing from top/front/side views

    :type: bool
    '''

    use_drag_immediately: bool = None
    ''' Moving things with a mouse drag confirms when releasing the button

    :type: bool
    '''

    use_emulate_numpad: bool = None
    ''' Main 1 to 0 keys act as the numpad ones (useful for laptops)

    :type: bool
    '''

    use_mouse_continuous: bool = None
    ''' Let the mouse wrap around the view boundaries so mouse movements are not limited by the screen size (used by transform, dragging of UI controls, etc.)

    :type: bool
    '''

    use_mouse_depth_navigate: bool = None
    ''' Use the depth under the mouse to improve view pan/rotate/zoom functionality

    :type: bool
    '''

    use_mouse_emulate_3_button: bool = None
    ''' Emulate Middle Mouse with Alt+Left Mouse

    :type: bool
    '''

    use_ndof: bool = None
    ''' 

    :type: bool
    '''

    use_numeric_input_advanced: bool = None
    ''' When entering numbers while transforming, default to advanced mode for full math expression evaluation

    :type: bool
    '''

    use_rotate_around_active: bool = None
    ''' Use selection as the pivot point

    :type: bool
    '''

    use_zoom_to_mouse: bool = None
    ''' Zoom in towards the mouse pointer's position in the 3D view, rather than the 2D window center

    :type: bool
    '''

    view_rotate_method: typing.Union[str, int] = None
    ''' Orbit method in the viewport * TURNTABLE Turntable, Turntable keeps the Z-axis upright while orbiting. * TRACKBALL Trackball, Trackball allows you to tumble your view at any angle.

    :type: typing.Union[str, int]
    '''

    view_rotate_sensitivity_trackball: float = None
    ''' Scale trackball orbit sensitivity

    :type: float
    '''

    view_rotate_sensitivity_turntable: float = None
    ''' Rotation amount per pixel to control how fast the viewport orbits

    :type: float
    '''

    view_zoom_axis: typing.Union[str, int] = None
    ''' Axis of mouse movement to zoom in or out on * VERTICAL Vertical, Zoom in and out based on vertical mouse movement. * HORIZONTAL Horizontal, Zoom in and out based on horizontal mouse movement.

    :type: typing.Union[str, int]
    '''

    view_zoom_method: typing.Union[str, int] = None
    ''' Which style to use for viewport scaling * CONTINUE Continue, Continuous zooming. The zoom direction and speed depends on how far along the set Zoom Axis the mouse has moved. * DOLLY Dolly, Zoom in and out based on mouse movement along the set Zoom Axis. * SCALE Scale, Zoom in and out as if you are scaling the view, mouse movements relative to center.

    :type: typing.Union[str, int]
    '''

    walk_navigation: 'WalkNavigation' = None
    ''' Settings for walk navigation mode

    :type: 'WalkNavigation'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesKeymap(bpy_struct):
    ''' Shortcut setup for keyboards and other input devices
    '''

    active_keyconfig: str = None
    ''' The name of the active key configuration

    :type: str
    '''

    show_ui_keyconfig: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesSystem(bpy_struct):
    ''' Graphics driver and operating system settings
    '''

    anisotropic_filter: typing.Union[str, int] = None
    ''' Quality of the anisotropic filtering (values greater than 1.0 enable anisotropic filtering)

    :type: typing.Union[str, int]
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * MONO Mono, Set audio channels to mono. * STEREO Stereo, Set audio channels to stereo. * SURROUND4 4 Channels, Set audio channels to 4 channels. * SURROUND51 5.1 Surround, Set audio channels to 5.1 surround sound. * SURROUND71 7.1 Surround, Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_device: typing.Union[str, int] = None
    ''' Audio output device * None None, No device - there will be no audio output.

    :type: typing.Union[str, int]
    '''

    audio_mixing_buffer: typing.Union[str, int] = None
    ''' Number of samples used by the audio mixing buffer * SAMPLES_256 256 Samples, Set audio mixing buffer size to 256 samples. * SAMPLES_512 512 Samples, Set audio mixing buffer size to 512 samples. * SAMPLES_1024 1024 Samples, Set audio mixing buffer size to 1024 samples. * SAMPLES_2048 2048 Samples, Set audio mixing buffer size to 2048 samples. * SAMPLES_4096 4096 Samples, Set audio mixing buffer size to 4096 samples. * SAMPLES_8192 8192 Samples, Set audio mixing buffer size to 8192 samples. * SAMPLES_16384 16384 Samples, Set audio mixing buffer size to 16384 samples. * SAMPLES_32768 32768 Samples, Set audio mixing buffer size to 32768 samples.

    :type: typing.Union[str, int]
    '''

    audio_sample_format: typing.Union[str, int] = None
    ''' Audio sample format * U8 8-bit Unsigned, Set audio sample format to 8-bit unsigned integer. * S16 16-bit Signed, Set audio sample format to 16-bit signed integer. * S24 24-bit Signed, Set audio sample format to 24-bit signed integer. * S32 32-bit Signed, Set audio sample format to 32-bit signed integer. * FLOAT 32-bit Float, Set audio sample format to 32-bit float. * DOUBLE 64-bit Float, Set audio sample format to 64-bit float.

    :type: typing.Union[str, int]
    '''

    audio_sample_rate: typing.Union[str, int] = None
    ''' Audio sample rate * RATE_44100 44.1 kHz, Set audio sampling rate to 44100 samples per second. * RATE_48000 48 kHz, Set audio sampling rate to 48000 samples per second. * RATE_96000 96 kHz, Set audio sampling rate to 96000 samples per second. * RATE_192000 192 kHz, Set audio sampling rate to 192000 samples per second.

    :type: typing.Union[str, int]
    '''

    dpi: int = None
    ''' 

    :type: int
    '''

    gl_clip_alpha: float = None
    ''' Clip alpha below this threshold in the 3D textured view

    :type: float
    '''

    gl_texture_limit: typing.Union[str, int] = None
    ''' Limit the texture size to save graphics memory

    :type: typing.Union[str, int]
    '''

    image_draw_method: typing.Union[str, int] = None
    ''' Method used for displaying images on the screen * AUTO Automatic, Automatically choose method based on GPU and image. * 2DTEXTURE 2D Texture, Use CPU for display transform and display image with 2D texture. * GLSL GLSL, Use GLSL shaders for display transform and display image with 2D texture.

    :type: typing.Union[str, int]
    '''

    legacy_compute_device_type: int = None
    ''' For backwards compatibility only

    :type: int
    '''

    light_ambient: typing.List[float] = None
    ''' Color of the ambient light that uniformly lit the scene

    :type: typing.List[float]
    '''

    memory_cache_limit: int = None
    ''' Memory cache limit (in megabytes)

    :type: int
    '''

    opensubdiv_compute_type: typing.Union[str, int] = None
    ''' Type of computer back-end used with OpenSubdiv

    :type: typing.Union[str, int]
    '''

    pixel_size: float = None
    ''' 

    :type: float
    '''

    scrollback: int = None
    ''' Maximum number of lines to store for the console buffer

    :type: int
    '''

    sequencer_disk_cache_compression: typing.Union[str, int] = None
    ''' Smaller compression will result in larger files, but less decoding overhead * NONE None, Requires fast storage, but uses minimum CPU resources. * LOW Low, Doesn't require fast storage and uses less CPU resources. * HIGH High, Works on slower storage devices and uses most CPU resources.

    :type: typing.Union[str, int]
    '''

    sequencer_disk_cache_dir: str = None
    ''' Override default directory

    :type: str
    '''

    sequencer_disk_cache_size_limit: int = None
    ''' Disk cache limit (in gigabytes)

    :type: int
    '''

    sequencer_proxy_setup: typing.Union[str, int] = None
    ''' When and how proxies are created * MANUAL Manual, Set up proxies manually. * AUTOMATIC Automatic, Build proxies for added movie and image strips in each preview size.

    :type: typing.Union[str, int]
    '''

    solid_lights: typing.Union[typing.Dict[str, 'UserSolidLight'], typing.
                               List['UserSolidLight'],
                               'bpy_prop_collection'] = None
    ''' Lights used to display objects in solid shading mode

    :type: typing.Union[typing.Dict[str, 'UserSolidLight'], typing.List['UserSolidLight'], 'bpy_prop_collection']
    '''

    texture_collection_rate: int = None
    ''' Number of seconds between each run of the GL texture garbage collector

    :type: int
    '''

    texture_time_out: int = None
    ''' Time since last access of a GL texture in seconds after which it is freed (set to 0 to keep textures allocated)

    :type: int
    '''

    ui_line_width: float = None
    ''' Suggested line thickness and point size in pixels, for add-ons displaying custom user interface elements, based on operating system settings and Blender UI scale

    :type: float
    '''

    ui_scale: float = None
    ''' Size multiplier to use when displaying custom user interface elements, so that they are scaled correctly on screens with different DPI. This value is based on operating system DPI settings and Blender display scale

    :type: float
    '''

    use_edit_mode_smooth_wire: bool = None
    ''' Enable Edit-Mode edge smoothing, reducing aliasing, requires restart

    :type: bool
    '''

    use_overlay_smooth_wire: bool = None
    ''' Enable overlay smooth wires, reducing aliasing

    :type: bool
    '''

    use_region_overlap: bool = None
    ''' Display tool/property regions over the main region

    :type: bool
    '''

    use_select_pick_depth: bool = None
    ''' Use the depth buffer for picking 3D View selection (without this the front most object may not be selected first)

    :type: bool
    '''

    use_sequencer_disk_cache: bool = None
    ''' Store cached images to disk

    :type: bool
    '''

    use_studio_light_edit: bool = None
    ''' View the result of the studio light editor in the viewport

    :type: bool
    '''

    vbo_collection_rate: int = None
    ''' Number of seconds between each run of the GL Vertex buffer object garbage collector

    :type: int
    '''

    vbo_time_out: int = None
    ''' Time since last access of a GL Vertex buffer object in seconds after which it is freed (set to 0 to keep vbo allocated)

    :type: int
    '''

    viewport_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing in 3d viewport * OFF No Anti-Aliasing, Scene will be rendering without any anti-aliasing. * FXAA Single Pass Anti-Aliasing, Scene will be rendered using a single pass anti-aliasing method (FXAA). * 5 5 Samples, Scene will be rendered using 5 anti-aliasing samples. * 8 8 Samples, Scene will be rendered using 8 anti-aliasing samples. * 11 11 Samples, Scene will be rendered using 11 anti-aliasing samples. * 16 16 Samples, Scene will be rendered using 16 anti-aliasing samples. * 32 32 Samples, Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PreferencesView(bpy_struct):
    ''' Preferences related to viewing data
    '''

    color_picker_type: typing.Union[str, int] = None
    ''' Different styles of displaying the color picker widget * CIRCLE_HSV Circle (HSV), A circular Hue/Saturation color wheel, with Value slider. * CIRCLE_HSL Circle (HSL), A circular Hue/Saturation color wheel, with Lightness slider. * SQUARE_SV Square (SV + H), A square showing Saturation/Value, with Hue slider. * SQUARE_HS Square (HS + V), A square showing Hue/Saturation, with Value slider. * SQUARE_HV Square (HV + S), A square showing Hue/Value, with Saturation slider.

    :type: typing.Union[str, int]
    '''

    factor_display_type: typing.Union[str, int] = None
    ''' How factor values are displayed * FACTOR Factor, Display factors as values between 0 and 1. * PERCENTAGE Percentage, Display factors as percentages.

    :type: typing.Union[str, int]
    '''

    filebrowser_display_type: typing.Union[str, int] = None
    ''' Default location where the File Editor will be displayed in * SCREEN Maximized Area, Open the temporary editor in a maximized screen. * WINDOW New Window, Open the temporary editor in a new window.

    :type: typing.Union[str, int]
    '''

    font_path_ui: str = None
    ''' Path to interface font

    :type: str
    '''

    font_path_ui_mono: str = None
    ''' Path to interface monospaced Font

    :type: str
    '''

    gizmo_size: int = None
    ''' Diameter of the gizmo

    :type: int
    '''

    gizmo_size_navigate_v3d: int = None
    ''' The Navigate Gizmo size

    :type: int
    '''

    header_align: typing.Union[str, int] = None
    ''' Default header position for new space-types * NONE Keep Existing, Keep existing header alignment. * TOP Top, Top aligned on load. * BOTTOM Bottom, Bottom align on load (except for property editors).

    :type: typing.Union[str, int]
    '''

    language: typing.Union[str, int] = None
    ''' Language used for translation * DEFAULT Automatic (Automatic), Automatically choose system's defined language if available, or fall-back to English.

    :type: typing.Union[str, int]
    '''

    lookdev_sphere_size: int = None
    ''' Diameter of the HDRI preview spheres

    :type: int
    '''

    mini_axis_brightness: int = None
    ''' Brightness of the icon

    :type: int
    '''

    mini_axis_size: int = None
    ''' The axes icon's size

    :type: int
    '''

    mini_axis_type: typing.Union[str, int] = None
    ''' Show a small rotating 3D axes in the top right corner of the 3D View

    :type: typing.Union[str, int]
    '''

    open_sublevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening sub level menus

    :type: int
    '''

    open_toplevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening top level menus

    :type: int
    '''

    pie_animation_timeout: int = None
    ''' Time needed to fully animate the pie to unfolded state (in 1/100ths of sec)

    :type: int
    '''

    pie_initial_timeout: int = None
    ''' Pie menus will use the initial mouse position as center for this amount of time (in 1/100ths of sec)

    :type: int
    '''

    pie_menu_confirm: int = None
    ''' Distance threshold after which selection is made (zero to disable)

    :type: int
    '''

    pie_menu_radius: int = None
    ''' Pie menu size in pixels

    :type: int
    '''

    pie_menu_threshold: int = None
    ''' Distance from center needed before a selection can be made

    :type: int
    '''

    pie_tap_timeout: int = None
    ''' Pie menu button held longer than this will dismiss menu on release.(in 1/100ths of sec)

    :type: int
    '''

    render_display_type: typing.Union[str, int] = None
    ''' Default location where rendered images will be displayed in * NONE Keep User Interface, Images are rendered without changing the user interface. * SCREEN Maximized Area, Images are rendered in a maximized Image Editor. * AREA Image Editor, Images are rendered in an Image Editor. * WINDOW New Window, Images are rendered in a new window.

    :type: typing.Union[str, int]
    '''

    rotation_angle: float = None
    ''' Rotation step for numerical pad keys (2 4 6 8)

    :type: float
    '''

    show_addons_enabled_only: bool = None
    ''' Only show enabled add-ons. Un-check to see all installed add-ons

    :type: bool
    '''

    show_column_layout: bool = None
    ''' Use a column layout for toolbox

    :type: bool
    '''

    show_developer_ui: bool = None
    ''' Show options for developers (edit source in context menu, geometry indices)

    :type: bool
    '''

    show_gizmo: bool = None
    ''' Use transform gizmos by default

    :type: bool
    '''

    show_layout_ui: bool = None
    ''' Split and join editors by dragging from corners

    :type: bool
    '''

    show_navigate_ui: bool = None
    ''' Show navigation controls in 2D and 3D views which do not have scroll bars

    :type: bool
    '''

    show_object_info: bool = None
    ''' Display objects name and frame number in 3D view

    :type: bool
    '''

    show_playback_fps: bool = None
    ''' Show the frames per second screen refresh rate, while animation is played back

    :type: bool
    '''

    show_splash: bool = None
    ''' Display splash screen on startup

    :type: bool
    '''

    show_statusbar_memory: bool = None
    ''' Show Blender memory usage

    :type: bool
    '''

    show_statusbar_stats: bool = None
    ''' Show scene statistics

    :type: bool
    '''

    show_statusbar_version: bool = None
    ''' Show Blender version string

    :type: bool
    '''

    show_statusbar_vram: bool = None
    ''' Show GPU video memory usage

    :type: bool
    '''

    show_tooltips: bool = None
    ''' Display tooltips (when off hold Alt to force display)

    :type: bool
    '''

    show_tooltips_python: bool = None
    ''' Show Python references in tooltips

    :type: bool
    '''

    show_view_name: bool = None
    ''' Show the name of the view's direction in each 3D View

    :type: bool
    '''

    smooth_view: int = None
    ''' Time to animate the view in milliseconds, zero to disable

    :type: int
    '''

    text_hinting: typing.Union[str, int] = None
    ''' Method for making user interface text render sharp

    :type: typing.Union[str, int]
    '''

    timecode_style: typing.Union[str, int] = None
    ''' Format of Time Codes displayed when not displaying timing in terms of frames * MINIMAL Minimal Info, Most compact representation, uses '+' as separator for sub-second frame numbers, with left and right truncation of the timecode as necessary. * SMPTE SMPTE (Full), Full SMPTE timecode (format is HH:MM:SS:FF). * SMPTE_COMPACT SMPTE (Compact), SMPTE timecode showing minutes, seconds, and frames only - hours are also shown if necessary, but not by default. * MILLISECONDS Compact with Milliseconds, Similar to SMPTE (Compact), except that instead of frames, milliseconds are shown instead. * SECONDS_ONLY Only Seconds, Direct conversion of frame numbers to seconds.

    :type: typing.Union[str, int]
    '''

    ui_line_width: typing.Union[str, int] = None
    ''' Changes the thickness of widget outlines, lines and dots in the interface * THIN Thin, Thinner lines than the default. * AUTO Default, Automatic line width based on UI scale. * THICK Thick, Thicker lines than the default.

    :type: typing.Union[str, int]
    '''

    ui_scale: float = None
    ''' Changes the size of the fonts and widgets in the interface

    :type: float
    '''

    use_directional_menus: bool = None
    ''' Otherwise menus, etc will always be top to bottom, left to right, no matter opening direction

    :type: bool
    '''

    use_mouse_over_open: bool = None
    ''' Open menu buttons and pulldowns automatically when the mouse is hovering

    :type: bool
    '''

    use_save_prompt: bool = None
    ''' Ask for confirmation when quitting with unsaved changes

    :type: bool
    '''

    use_text_antialiasing: bool = None
    ''' Smooth jagged edges of user interface text

    :type: bool
    '''

    use_translate_interface: bool = None
    ''' Translate all labels in menus, buttons and panels (note that this might make it hard to follow tutorials or the manual)

    :type: bool
    '''

    use_translate_new_dataname: bool = None
    ''' Translate the names of new data-blocks (objects, materials...)

    :type: bool
    '''

    use_translate_tooltips: bool = None
    ''' Translate the descriptions when hovering UI elements (recommended)

    :type: bool
    '''

    use_weight_color_range: bool = None
    ''' Enable color range used for weight visualization in weight painting mode

    :type: bool
    '''

    view2d_grid_spacing_min: int = None
    ''' Minimum number of pixels between each gridline in 2D Viewports

    :type: int
    '''

    view_frame_keyframes: int = None
    ''' Keyframes around cursor that we zoom around

    :type: int
    '''

    view_frame_seconds: float = None
    ''' Seconds around cursor that we zoom around

    :type: float
    '''

    view_frame_type: typing.Union[str, int] = None
    ''' How zooming to frame focuses around current frame

    :type: typing.Union[str, int]
    '''

    weight_color_range: 'ColorRamp' = None
    ''' Color range used for weight visualization in weight painting mode

    :type: 'ColorRamp'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Property(bpy_struct):
    ''' RNA property definition
    '''

    description: str = None
    ''' Description of the property for tooltips

    :type: str
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: str = None
    ''' Unique name used in the code and scripting

    :type: str
    '''

    is_animatable: bool = None
    ''' Property is animatable through RNA

    :type: bool
    '''

    is_argument_optional: bool = None
    ''' True when the property is optional in a Python function implementing an RNA function

    :type: bool
    '''

    is_enum_flag: bool = None
    ''' True when multiple enums

    :type: bool
    '''

    is_hidden: bool = None
    ''' True when the property is hidden

    :type: bool
    '''

    is_library_editable: bool = None
    ''' Property is editable from linked instances (changes not saved)

    :type: bool
    '''

    is_never_none: bool = None
    ''' True when this value can't be set to None

    :type: bool
    '''

    is_output: bool = None
    ''' True when this property is an output value from an RNA function

    :type: bool
    '''

    is_overridable: bool = None
    ''' Property is overridable through RNA

    :type: bool
    '''

    is_readonly: bool = None
    ''' Property is editable through RNA

    :type: bool
    '''

    is_registered: bool = None
    ''' Property is registered as part of type registration

    :type: bool
    '''

    is_registered_optional: bool = None
    ''' Property is optionally registered as part of type registration

    :type: bool
    '''

    is_required: bool = None
    ''' False when this property is an optional argument in an RNA function

    :type: bool
    '''

    is_runtime: bool = None
    ''' Property has been dynamically created at runtime

    :type: bool
    '''

    is_skip_save: bool = None
    ''' True when the property is not saved in presets

    :type: bool
    '''

    name: str = None
    ''' Human readable name

    :type: str
    '''

    srna: 'Struct' = None
    ''' Struct definition used for properties assigned to this item

    :type: 'Struct'
    '''

    subtype: typing.Union[str, int] = None
    ''' Semantic interpretation of the property * NONE None. * FILEPATH File Path. * DIRPATH Directory Path. * FILENAME File Name. * BYTESTRING Byte String. * PASSWORD Password, A string that is displayed hidden ('\*\*\*\*\*\*\*\*'). * PIXEL Pixel. * UNSIGNED Unsigned. * PERCENTAGE Percentage. * FACTOR Factor. * ANGLE Angle. * TIME Time. * DISTANCE Distance. * DISTANCE_CAMERA Camera Distance. * POWER Power. * TEMPERATURE Temperature. * COLOR Color. * TRANSLATION Translation. * DIRECTION Direction. * VELOCITY Velocity. * ACCELERATION Acceleration. * MATRIX Matrix. * EULER Euler Angles. * QUATERNION Quaternion. * AXISANGLE Axis-Angle. * XYZ XYZ. * XYZ_LENGTH XYZ Length. * COLOR_GAMMA Color. * COORDS Coordinates. * LAYER Layer. * LAYER_MEMBER Layer Member.

    :type: typing.Union[str, int]
    '''

    tags: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Subset of tags (defined in parent struct) that are set for this property

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    translation_context: str = None
    ''' Translation context of the property's name

    :type: str
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the property

    :type: typing.Union[str, int]
    '''

    unit: typing.Union[str, int] = None
    ''' Type of units for this property

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PropertyGroup(bpy_struct):
    ''' Group of ID properties
    '''

    name: str = None
    ''' Unique name used in the code and scripting

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class PropertyGroupItem(bpy_struct):
    ''' Property that stores arbitrary, user defined properties
    '''

    collection: typing.Union[typing.Dict[str, 'PropertyGroup'], typing.
                             List['PropertyGroup'],
                             'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'PropertyGroup'], typing.List['PropertyGroup'], 'bpy_prop_collection']
    '''

    double: float = None
    ''' 

    :type: float
    '''

    double_array: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    float: float = None
    ''' 

    :type: float
    '''

    float_array: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    group: 'PropertyGroup' = None
    ''' 

    :type: 'PropertyGroup'
    '''

    id: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    idp_array: typing.Union[typing.Dict[str, 'PropertyGroup'], typing.
                            List['PropertyGroup'],
                            'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'PropertyGroup'], typing.List['PropertyGroup'], 'bpy_prop_collection']
    '''

    int: int = None
    ''' 

    :type: int
    '''

    int_array: typing.List[int] = None
    ''' 

    :type: typing.List[int]
    '''

    string: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Region(bpy_struct):
    ''' Region in a subdivided screen area
    '''

    alignment: typing.Union[str, int] = None
    ''' Alignment of the region within the area * NONE None, Don't use any fixed alignment, fill available space. * TOP Top. * BOTTOM Bottom. * LEFT Left. * RIGHT Right. * HORIZONTAL_SPLIT Horizontal Split. * VERTICAL_SPLIT Vertical Split. * FLOAT Float, Region floats on screen, doesn't use any fixed alignment. * QUAD_SPLIT Quad Split, Region is split horizontally and vertically.

    :type: typing.Union[str, int]
    '''

    data: 'AnyType' = None
    ''' Region specific data (the type depends on the region type)

    :type: 'AnyType'
    '''

    height: int = None
    ''' Region height

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of this region

    :type: typing.Union[str, int]
    '''

    view2d: 'View2D' = None
    ''' 2D view of the region

    :type: 'View2D'
    '''

    width: int = None
    ''' Region width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the region

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the region

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RegionView3D(bpy_struct):
    ''' 3D View region data
    '''

    clip_planes: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    is_orthographic_side_view: bool = None
    ''' Is current view an orthographic side view

    :type: bool
    '''

    is_perspective: bool = None
    ''' 

    :type: bool
    '''

    lock_rotation: bool = None
    ''' Lock view rotation in side views

    :type: bool
    '''

    perspective_matrix: typing.List[float] = None
    ''' Current perspective matrix ( window_matrix * view_matrix )

    :type: typing.List[float]
    '''

    show_sync_view: bool = None
    ''' Sync view position between side views

    :type: bool
    '''

    use_box_clip: bool = None
    ''' Clip objects based on what's visible in other side views

    :type: bool
    '''

    use_clip_planes: bool = None
    ''' 

    :type: bool
    '''

    view_camera_offset: typing.List[float] = None
    ''' View shift in camera view

    :type: typing.List[float]
    '''

    view_camera_zoom: float = None
    ''' Zoom factor in camera view

    :type: float
    '''

    view_distance: float = None
    ''' Distance to the view location

    :type: float
    '''

    view_location: typing.List[float] = None
    ''' View pivot location

    :type: typing.List[float]
    '''

    view_matrix: typing.List[float] = None
    ''' Current view matrix

    :type: typing.List[float]
    '''

    view_perspective: typing.Union[str, int] = None
    ''' View Perspective

    :type: typing.Union[str, int]
    '''

    view_rotation: typing.List[float] = None
    ''' Rotation in quaternions (keep normalized)

    :type: typing.List[float]
    '''

    window_matrix: typing.List[float] = None
    ''' Current window matrix

    :type: typing.List[float]
    '''

    def update(self):
        ''' Recalculate the view matrices

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderEngine(bpy_struct):
    ''' Render engine
    '''

    bl_idname: str = None
    ''' 

    :type: str
    '''

    bl_label: str = None
    ''' 

    :type: str
    '''

    bl_use_custom_freestyle: bool = None
    ''' Handles freestyle rendering on its own, instead of delegating it to EEVEE

    :type: bool
    '''

    bl_use_eevee_viewport: bool = None
    ''' Uses Eevee for viewport shading in LookDev shading mode

    :type: bool
    '''

    bl_use_gpu_context: bool = None
    ''' Enable OpenGL context for the render method, for engines that render using OpenGL

    :type: bool
    '''

    bl_use_postprocess: bool = None
    ''' Apply compositing on render results

    :type: bool
    '''

    bl_use_preview: bool = None
    ''' Render engine supports being used for rendering previews of materials, lights and worlds

    :type: bool
    '''

    bl_use_save_buffers: bool = None
    ''' Support render to an on disk buffer during rendering

    :type: bool
    '''

    bl_use_shading_nodes_custom: bool = None
    ''' Don't expose Cycles and Eevee shading nodes in the node editor user interface, so own nodes can be used instead

    :type: bool
    '''

    bl_use_spherical_stereo: bool = None
    ''' Support spherical stereo camera models

    :type: bool
    '''

    bl_use_stereo_viewport: bool = None
    ''' Support rendering stereo 3D viewport

    :type: bool
    '''

    camera_override: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    is_animation: bool = None
    ''' 

    :type: bool
    '''

    is_preview: bool = None
    ''' 

    :type: bool
    '''

    layer_override: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    render: 'RenderSettings' = None
    ''' 

    :type: 'RenderSettings'
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    tile_x: int = None
    ''' 

    :type: int
    '''

    tile_y: int = None
    ''' 

    :type: int
    '''

    use_highlight_tiles: bool = None
    ''' 

    :type: bool
    '''

    def update(self, data: 'BlendData' = None, depsgraph: 'Depsgraph' = None):
        ''' Export scene data for render

        :param data: 
        :type data: 'BlendData'
        :param depsgraph: 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def render(self, depsgraph: 'Depsgraph'):
        ''' Render scene into an image

        :param depsgraph: 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def bake(self, depsgraph: 'Depsgraph', object: 'Object',
             pass_type: typing.Union[str, int], pass_filter: int, width: int,
             height: int):
        ''' Bake passes

        :param depsgraph: 
        :type depsgraph: 'Depsgraph'
        :param object: 
        :type object: 'Object'
        :param pass_type: Pass, Pass to bake
        :type pass_type: typing.Union[str, int]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy and transmission passes
        :type pass_filter: int
        :param width: Width, Image width
        :type width: int
        :param height: Height, Image height
        :type height: int
        '''
        pass

    def view_update(self, context: 'Context', depsgraph: 'Depsgraph'):
        ''' Update on data changes for viewport render

        :param context: 
        :type context: 'Context'
        :param depsgraph: 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def view_draw(self, context: 'Context', depsgraph: 'Depsgraph'):
        ''' Draw viewport render

        :param context: 
        :type context: 'Context'
        :param depsgraph: 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def update_script_node(self, node: 'Node' = None):
        ''' Compile shader script node

        :param node: 
        :type node: 'Node'
        '''
        pass

    def update_render_passes(self,
                             scene: 'Scene' = None,
                             renderlayer: 'ViewLayer' = None):
        ''' Update the render passes that will be generated

        :param scene: 
        :type scene: 'Scene'
        :param renderlayer: 
        :type renderlayer: 'ViewLayer'
        '''
        pass

    def tag_redraw(self):
        ''' Request redraw for viewport rendering

        '''
        pass

    def tag_update(self):
        ''' Request update call for viewport rendering

        '''
        pass

    def begin_result(self,
                     x: int,
                     y: int,
                     w: int,
                     h: int,
                     layer: str = "",
                     view: str = "") -> 'RenderResult':
        ''' Create render result to write linear floating-point render layers and passes

        :param x: X
        :type x: int
        :param y: Y
        :type y: int
        :param w: Width
        :type w: int
        :param h: Height
        :type h: int
        :param layer: Layer, Single layer to get render result for
        :type layer: str
        :param view: View, Single view to get render result for
        :type view: str
        :rtype: 'RenderResult'
        :return: Result
        '''
        pass

    def update_result(self, result: 'RenderResult'):
        ''' Signal that pixels have been updated and can be redrawn in the user interface

        :param result: Result
        :type result: 'RenderResult'
        '''
        pass

    def end_result(self,
                   result: 'RenderResult',
                   cancel: bool = False,
                   highlight: bool = False,
                   do_merge_results: bool = False):
        ''' All pixels in the render result have been set and are final

        :param result: Result
        :type result: 'RenderResult'
        :param cancel: Cancel, Don't mark tile as done, don't merge results unless forced
        :type cancel: bool
        :param highlight: Highlight, Don't mark tile as done yet
        :type highlight: bool
        :param do_merge_results: Merge Results, Merge results even if cancel=true
        :type do_merge_results: bool
        '''
        pass

    def add_pass(self, name: str, channels: int, chan_id: str,
                 layer: str = ""):
        ''' Add a pass to the render layer

        :param name: Name, Name of the Pass, without view or channel tag
        :type name: str
        :param channels: Channels
        :type channels: int
        :param chan_id: Channel IDs, Channel names, one character per channel
        :type chan_id: str
        :param layer: Layer, Single layer to add render pass to
        :type layer: str
        '''
        pass

    def get_result(self) -> 'RenderResult':
        ''' Get final result for non-pixel operations

        :rtype: 'RenderResult'
        :return: Result
        '''
        pass

    def test_break(self) -> bool:
        ''' Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness

        :rtype: bool
        :return: Break
        '''
        pass

    def active_view_get(self) -> str:
        ''' active_view_get

        :rtype: str
        :return: View, Single view active
        '''
        pass

    def active_view_set(self, view: str):
        ''' active_view_set

        :param view: View, Single view to set as active
        :type view: str
        '''
        pass

    def camera_shift_x(self,
                       camera: 'Object',
                       use_spherical_stereo: bool = False) -> float:
        ''' camera_shift_x

        :param camera: 
        :type camera: 'Object'
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: bool
        :rtype: float
        :return: Shift X
        '''
        pass

    def camera_model_matrix(self,
                            camera: 'Object',
                            use_spherical_stereo: bool = False
                            ) -> typing.List[float]:
        ''' camera_model_matrix

        :param camera: 
        :type camera: 'Object'
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: bool
        :rtype: typing.List[float]
        :return: Model Matrix, Normalized camera model matrix
        '''
        pass

    def use_spherical_stereo(self, camera: 'Object') -> bool:
        ''' use_spherical_stereo

        :param camera: 
        :type camera: 'Object'
        :rtype: bool
        :return: Spherical Stereo
        '''
        pass

    def update_stats(self, stats: str, info: str):
        ''' Update and signal to redraw render status text

        :param stats: Stats
        :type stats: str
        :param info: Info
        :type info: str
        '''
        pass

    def frame_set(self, frame: int, subframe: float):
        ''' Evaluate scene at a different frame (for motion blur)

        :param frame: Frame
        :type frame: int
        :param subframe: Subframe
        :type subframe: float
        '''
        pass

    def update_progress(self, progress: float):
        ''' Update progress percentage of render

        :param progress: Percentage of render that's done
        :type progress: float
        '''
        pass

    def update_memory_stats(self,
                            memory_used: float = 0.0,
                            memory_peak: float = 0.0):
        ''' Update memory usage statistics

        :param memory_used: Current memory usage in megabytes
        :type memory_used: float
        :param memory_peak: Peak memory usage in megabytes
        :type memory_peak: float
        '''
        pass

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        ''' Report info, warning or error messages

        :param type: Type
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message
        :type message: str
        '''
        pass

    def error_set(self, message: str):
        ''' Set error message displaying after the render is finished

        :param message: Report Message
        :type message: str
        '''
        pass

    def bind_display_space_shader(self, scene: 'Scene'):
        ''' Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings

        :param scene: 
        :type scene: 'Scene'
        '''
        pass

    def unbind_display_space_shader(self):
        ''' Unbind GLSL display space shader, must always be called after binding the shader

        '''
        pass

    def support_display_space_shader(self, scene: 'Scene') -> bool:
        ''' Test if GLSL display space shader is supported for the combination of graphics card and scene settings

        :param scene: 
        :type scene: 'Scene'
        :rtype: bool
        :return: Supported
        '''
        pass

    def get_preview_pixel_size(self, scene: 'Scene') -> int:
        ''' Get the pixel size that should be used for preview rendering

        :param scene: 
        :type scene: 'Scene'
        :rtype: int
        :return: Pixel Size
        '''
        pass

    def free_blender_memory(self):
        ''' Free Blender side memory of render engine

        '''
        pass

    def register_pass(self, scene: 'Scene', view_layer: 'ViewLayer', name: str,
                      channels: int, chanid: str,
                      type: typing.Union[str, int]):
        ''' Register a render pass that will be part of the render with the current settings

        :param scene: 
        :type scene: 'Scene'
        :param view_layer: 
        :type view_layer: 'ViewLayer'
        :param name: Name
        :type name: str
        :param channels: Channels
        :type channels: int
        :param chanid: Channel IDs
        :type chanid: str
        :param type: Type
        :type type: typing.Union[str, int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderLayer(bpy_struct):
    invert_zmask: bool = None
    ''' For Zmask, only render what is behind solid z values instead of in front

    :type: bool
    '''

    name: str = None
    ''' View layer name

    :type: str
    '''

    passes: typing.Union[typing.Dict[str, 'RenderPass'], typing.
                         List['RenderPass'], 'bpy_prop_collection',
                         'RenderPasses'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'RenderPass'], typing.List['RenderPass'], 'bpy_prop_collection', 'RenderPasses']
    '''

    use_all_z: bool = None
    ''' Fill in Z values for solid faces in invisible layers, for masking

    :type: bool
    '''

    use_ao: bool = None
    ''' Render Ambient Occlusion in this Layer

    :type: bool
    '''

    use_edge_enhance: bool = None
    ''' Render edge-enhance in this layer (only works for solid faces)

    :type: bool
    '''

    use_halo: bool = None
    ''' Render Halos in this Layer (on top of Solid)

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    ''' Deliver Ambient Occlusion pass

    :type: bool
    '''

    use_pass_combined: bool = None
    ''' Deliver full combined RGBA buffer

    :type: bool
    '''

    use_pass_diffuse_color: bool = None
    ''' Deliver diffuse color pass

    :type: bool
    '''

    use_pass_diffuse_direct: bool = None
    ''' Deliver diffuse direct pass

    :type: bool
    '''

    use_pass_diffuse_indirect: bool = None
    ''' Deliver diffuse indirect pass

    :type: bool
    '''

    use_pass_emit: bool = None
    ''' Deliver emission pass

    :type: bool
    '''

    use_pass_environment: bool = None
    ''' Deliver environment lighting pass

    :type: bool
    '''

    use_pass_glossy_color: bool = None
    ''' Deliver glossy color pass

    :type: bool
    '''

    use_pass_glossy_direct: bool = None
    ''' Deliver glossy direct pass

    :type: bool
    '''

    use_pass_glossy_indirect: bool = None
    ''' Deliver glossy indirect pass

    :type: bool
    '''

    use_pass_material_index: bool = None
    ''' Deliver material index pass

    :type: bool
    '''

    use_pass_mist: bool = None
    ''' Deliver mist factor pass (0.0 to 1.0)

    :type: bool
    '''

    use_pass_normal: bool = None
    ''' Deliver normal pass

    :type: bool
    '''

    use_pass_object_index: bool = None
    ''' Deliver object index pass

    :type: bool
    '''

    use_pass_shadow: bool = None
    ''' Deliver shadow pass

    :type: bool
    '''

    use_pass_subsurface_color: bool = None
    ''' Deliver subsurface color pass

    :type: bool
    '''

    use_pass_subsurface_direct: bool = None
    ''' Deliver subsurface direct pass

    :type: bool
    '''

    use_pass_subsurface_indirect: bool = None
    ''' Deliver subsurface indirect pass

    :type: bool
    '''

    use_pass_transmission_color: bool = None
    ''' Deliver transmission color pass

    :type: bool
    '''

    use_pass_transmission_direct: bool = None
    ''' Deliver transmission direct pass

    :type: bool
    '''

    use_pass_transmission_indirect: bool = None
    ''' Deliver transmission indirect pass

    :type: bool
    '''

    use_pass_uv: bool = None
    ''' Deliver texture UV pass

    :type: bool
    '''

    use_pass_vector: bool = None
    ''' Deliver speed vector pass

    :type: bool
    '''

    use_pass_z: bool = None
    ''' Deliver Z values pass

    :type: bool
    '''

    use_sky: bool = None
    ''' Render Sky in this Layer

    :type: bool
    '''

    use_solid: bool = None
    ''' Render Solid faces in this Layer

    :type: bool
    '''

    use_strand: bool = None
    ''' Render Strands in this Layer

    :type: bool
    '''

    use_volumes: bool = None
    ''' Render volumes in this Layer

    :type: bool
    '''

    use_zmask: bool = None
    ''' Only render what's in front of the solid z values

    :type: bool
    '''

    use_ztransp: bool = None
    ''' Render Z-transparent faces in this layer (on top of Solid and Halos)

    :type: bool
    '''

    def load_from_file(self, filename: str, x: int = 0, y: int = 0):
        ''' Copies the pixels of this renderlayer from an image file

        :param filename: Filename, Filename to load into this render tile, must be no smaller than the renderlayer
        :type filename: str
        :param x: Offset X, Offset the position to copy from if the image is larger than the render layer
        :type x: int
        :param y: Offset Y, Offset the position to copy from if the image is larger than the render layer
        :type y: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderPass(bpy_struct):
    channel_id: str = None
    ''' 

    :type: str
    '''

    channels: int = None
    ''' 

    :type: int
    '''

    fullname: str = None
    ''' 

    :type: str
    '''

    name: str = None
    ''' 

    :type: str
    '''

    rect: float = None
    ''' 

    :type: float
    '''

    view_id: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderPasses(bpy_struct):
    ''' Collection of render passes
    '''

    def find_by_type(self, pass_type: typing.Union[str, int],
                     view: str) -> 'RenderPass':
        ''' Get the render pass for a given type and view

        :param pass_type: Pass
        :type pass_type: typing.Union[str, int]
        :param view: View, Render view to get pass from
        :type view: str
        :rtype: 'RenderPass'
        :return: The matching render pass
        '''
        pass

    def find_by_name(self, name: str, view: str) -> 'RenderPass':
        ''' Get the render pass for a given name and view

        :param name: Pass
        :type name: str
        :param view: View, Render view to get pass from
        :type view: str
        :rtype: 'RenderPass'
        :return: The matching render pass
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderResult(bpy_struct):
    ''' Result of rendering, including all layers and passes
    '''

    layers: typing.Union[typing.Dict[str, 'RenderLayer'], typing.
                         List['RenderLayer'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'RenderLayer'], typing.List['RenderLayer'], 'bpy_prop_collection']
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    views: typing.Union[typing.Dict[str, 'RenderView'], typing.
                        List['RenderView'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'RenderView'], typing.List['RenderView'], 'bpy_prop_collection']
    '''

    def load_from_file(self, filename: str):
        ''' Copies the pixels of this render result from an image file

        :param filename: File Name, Filename to load into this render tile, must be no smaller than the render result
        :type filename: str
        '''
        pass

    def stamp_data_add_field(self, field: str, value: str):
        ''' Add engine-specific stamp data to the result

        :param field: Field, Name of the stamp field to add
        :type field: str
        :param value: Value, Value of the stamp data
        :type value: str
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderSettings(bpy_struct):
    ''' Rendering settings for a Scene data-block
    '''

    bake: 'BakeSettings' = None
    ''' 

    :type: 'BakeSettings'
    '''

    bake_bias: float = None
    ''' Bias towards faces further away from the object (in blender units)

    :type: float
    '''

    bake_margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    bake_samples: int = None
    ''' Number of samples used for ambient occlusion baking from multires

    :type: int
    '''

    bake_type: typing.Union[str, int] = None
    ''' Choose shading information to bake into the image * NORMALS Normals, Bake normals. * DISPLACEMENT Displacement, Bake displacement.

    :type: typing.Union[str, int]
    '''

    bake_user_scale: float = None
    ''' Instead of automatically normalizing to the range 0 to 1, apply a user scale to the derivative map

    :type: float
    '''

    border_max_x: float = None
    ''' Maximum X value for the render region

    :type: float
    '''

    border_max_y: float = None
    ''' Maximum Y value for the render region

    :type: float
    '''

    border_min_x: float = None
    ''' Minimum X value for the render region

    :type: float
    '''

    border_min_y: float = None
    ''' Minimum Y value for the render region

    :type: float
    '''

    dither_intensity: float = None
    ''' Amount of dithering noise added to the rendered image to break up banding

    :type: float
    '''

    engine: typing.Union[str, int] = None
    ''' Engine to use for rendering

    :type: typing.Union[str, int]
    '''

    ffmpeg: 'FFmpegSettings' = None
    ''' FFmpeg related settings for the scene

    :type: 'FFmpegSettings'
    '''

    file_extension: str = None
    ''' The file extension used for saving renders

    :type: str
    '''

    filepath: str = None
    ''' Directory/name to save animations, # characters defines the position and length of frame numbers

    :type: str
    '''

    film_transparent: bool = None
    ''' World background is transparent, for compositing the render over another background

    :type: bool
    '''

    filter_size: float = None
    ''' Width over which the reconstruction filter combines samples

    :type: float
    '''

    fps: int = None
    ''' Framerate, expressed in frames per second

    :type: int
    '''

    fps_base: float = None
    ''' Framerate base

    :type: float
    '''

    frame_map_new: int = None
    ''' How many frames the Map Old will last

    :type: int
    '''

    frame_map_old: int = None
    ''' Old mapping value in frames

    :type: int
    '''

    hair_subdiv: int = None
    ''' Additional subdivision along the hair

    :type: int
    '''

    hair_type: typing.Union[str, int] = None
    ''' Hair shape type

    :type: typing.Union[str, int]
    '''

    has_multiple_engines: bool = None
    ''' More than one rendering engine is available

    :type: bool
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    is_movie_format: bool = None
    ''' When true the format is a movie

    :type: bool
    '''

    line_thickness: float = None
    ''' Line thickness in pixels

    :type: float
    '''

    line_thickness_mode: typing.Union[str, int] = None
    ''' Line thickness mode for Freestyle line drawing * ABSOLUTE Absolute, Specify unit line thickness in pixels. * RELATIVE Relative, Unit line thickness is scaled by the proportion of the present vertical image resolution to 480 pixels.

    :type: typing.Union[str, int]
    '''

    metadata_input: typing.Union[str, int] = None
    ''' Where to take the metadata from * SCENE Scene, Use metadata from the current scene. * STRIPS Sequencer Strips, Use metadata from the strips in the sequencer.

    :type: typing.Union[str, int]
    '''

    motion_blur_shutter: float = None
    ''' Time taken in frames between shutter open and close

    :type: float
    '''

    motion_blur_shutter_curve: 'CurveMapping' = None
    ''' Curve defining the shutter's openness over time

    :type: 'CurveMapping'
    '''

    pixel_aspect_x: float = None
    ''' Horizontal aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    pixel_aspect_y: float = None
    ''' Vertical aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    preview_pixel_size: typing.Union[str, int] = None
    ''' Pixel size for viewport rendering * AUTO Automatic, Automatic pixel size, depends on the user interface scale. * 1 1x, Render at full resolution. * 2 2x, Render at 50% resolution. * 4 4x, Render at 25% resolution. * 8 8x, Render at 12.5% resolution.

    :type: typing.Union[str, int]
    '''

    preview_start_resolution: int = None
    ''' Resolution to start rendering preview at, progressively increasing it to the full viewport size

    :type: int
    '''

    resolution_percentage: int = None
    ''' Percentage scale for render resolution

    :type: int
    '''

    resolution_x: int = None
    ''' Number of horizontal pixels in the rendered image

    :type: int
    '''

    resolution_y: int = None
    ''' Number of vertical pixels in the rendered image

    :type: int
    '''

    sequencer_gl_preview: typing.Union[str, int] = None
    ''' Display method used in the sequencer view * WIREFRAME Wireframe, Display the object as wire edges. * SOLID Solid, Display in solid mode. * MATERIAL Material Preview, Display in Material Preview mode. * RENDERED Rendered, Display render preview.

    :type: typing.Union[str, int]
    '''

    simplify_child_particles: float = None
    ''' Global child particles percentage

    :type: float
    '''

    simplify_child_particles_render: float = None
    ''' Global child particles percentage during rendering

    :type: float
    '''

    simplify_gpencil: bool = None
    ''' Simplify Grease Pencil drawing

    :type: bool
    '''

    simplify_gpencil_antialiasing: bool = None
    ''' Use Antialiasing to smooth stroke edges

    :type: bool
    '''

    simplify_gpencil_modifier: bool = None
    ''' Display modifiers

    :type: bool
    '''

    simplify_gpencil_onplay: bool = None
    ''' Simplify Grease Pencil only during animation playback

    :type: bool
    '''

    simplify_gpencil_shader_fx: bool = None
    ''' Display Shader Effects

    :type: bool
    '''

    simplify_gpencil_tint: bool = None
    ''' Display layer tint

    :type: bool
    '''

    simplify_gpencil_view_fill: bool = None
    ''' Display fill strokes in the viewport

    :type: bool
    '''

    simplify_subdivision: int = None
    ''' Global maximum subdivision level

    :type: int
    '''

    simplify_subdivision_render: int = None
    ''' Global maximum subdivision level during rendering

    :type: int
    '''

    simplify_volumes: float = None
    ''' Resolution percentage of volume objects in viewport

    :type: float
    '''

    stamp_background: typing.List[float] = None
    ''' Color to use behind stamp text

    :type: typing.List[float]
    '''

    stamp_font_size: int = None
    ''' Size of the font used when rendering stamp text

    :type: int
    '''

    stamp_foreground: typing.List[float] = None
    ''' Color to use for stamp text

    :type: typing.List[float]
    '''

    stamp_note_text: str = None
    ''' Custom text to appear in the stamp note

    :type: str
    '''

    stereo_views: typing.Union[typing.Dict[str, 'SceneRenderView'], typing.
                               List['SceneRenderView'],
                               'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'SceneRenderView'], typing.List['SceneRenderView'], 'bpy_prop_collection']
    '''

    threads: int = None
    ''' Maximum number of CPU cores to use simultaneously while rendering (for multi-core/CPU systems)

    :type: int
    '''

    threads_mode: typing.Union[str, int] = None
    ''' Determine the amount of render threads used * AUTO Auto-Detect, Automatically determine the number of threads, based on CPUs. * FIXED Fixed, Manually determine the number of threads.

    :type: typing.Union[str, int]
    '''

    tile_x: int = None
    ''' Horizontal tile size to use while rendering

    :type: int
    '''

    tile_y: int = None
    ''' Vertical tile size to use while rendering

    :type: int
    '''

    use_bake_clear: bool = None
    ''' Clear Images before baking

    :type: bool
    '''

    use_bake_lores_mesh: bool = None
    ''' Calculate heights against unsubdivided low resolution mesh

    :type: bool
    '''

    use_bake_multires: bool = None
    ''' Bake directly from multires object

    :type: bool
    '''

    use_bake_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_bake_user_scale: bool = None
    ''' Use a user scale for the derivative map

    :type: bool
    '''

    use_border: bool = None
    ''' Render a user-defined render region, within the frame size

    :type: bool
    '''

    use_compositing: bool = None
    ''' Process the render result through the compositing pipeline, if compositing nodes are enabled

    :type: bool
    '''

    use_crop_to_border: bool = None
    ''' Crop the rendered frame to the defined render region size

    :type: bool
    '''

    use_file_extension: bool = None
    ''' Add the file format extensions to the rendered file name (eg: filename + .jpg)

    :type: bool
    '''

    use_freestyle: bool = None
    ''' Draw stylized strokes using Freestyle

    :type: bool
    '''

    use_full_sample: bool = None
    ''' Save for every anti-aliasing sample the entire RenderLayer results (this solves anti-aliasing issues with compositing)

    :type: bool
    '''

    use_high_quality_normals: bool = None
    ''' Use high quality tangent space at the cost of lower performance

    :type: bool
    '''

    use_lock_interface: bool = None
    ''' Lock interface during rendering in favor of giving more memory to the renderer

    :type: bool
    '''

    use_motion_blur: bool = None
    ''' Use multi-sampled 3D scene motion blur

    :type: bool
    '''

    use_multiview: bool = None
    ''' Use multiple views in the scene

    :type: bool
    '''

    use_overwrite: bool = None
    ''' Overwrite existing files while rendering

    :type: bool
    '''

    use_persistent_data: bool = None
    ''' Keep render data around for faster re-renders and animation renders, at the cost of increased memory usage

    :type: bool
    '''

    use_placeholder: bool = None
    ''' Create empty placeholder files while rendering frames (similar to Unix 'touch')

    :type: bool
    '''

    use_render_cache: bool = None
    ''' Save render cache to EXR files (useful for heavy compositing, Note: affects indirectly rendered scenes)

    :type: bool
    '''

    use_save_buffers: bool = None
    ''' Save tiles for all RenderLayers and SceneNodes to files in the temp directory (saves memory, required for Full Sample)

    :type: bool
    '''

    use_sequencer: bool = None
    ''' Process the render (and composited) result through the video sequence editor pipeline, if sequencer strips exist

    :type: bool
    '''

    use_sequencer_override_scene_strip: bool = None
    ''' Use workbench render settings from the sequencer scene, instead of each individual scene used in the strip

    :type: bool
    '''

    use_simplify: bool = None
    ''' Enable simplification of scene for quicker preview renders

    :type: bool
    '''

    use_single_layer: bool = None
    ''' Only render the active layer. Only affects rendering from the interface, ignored for rendering from command line

    :type: bool
    '''

    use_spherical_stereo: bool = None
    ''' Active render engine supports spherical stereo rendering

    :type: bool
    '''

    use_stamp: bool = None
    ''' Render the stamp info text in the rendered image

    :type: bool
    '''

    use_stamp_camera: bool = None
    ''' Include the name of the active camera in image metadata

    :type: bool
    '''

    use_stamp_date: bool = None
    ''' Include the current date in image/video metadata

    :type: bool
    '''

    use_stamp_filename: bool = None
    ''' Include the .blend filename in image/video metadata

    :type: bool
    '''

    use_stamp_frame: bool = None
    ''' Include the frame number in image metadata

    :type: bool
    '''

    use_stamp_frame_range: bool = None
    ''' Include the rendered frame range in image/video metadata

    :type: bool
    '''

    use_stamp_hostname: bool = None
    ''' Include the hostname of the machine that rendered the frame

    :type: bool
    '''

    use_stamp_labels: bool = None
    ''' Display stamp labels ("Camera" in front of camera name, etc.)

    :type: bool
    '''

    use_stamp_lens: bool = None
    ''' Include the active camera's lens in image metadata

    :type: bool
    '''

    use_stamp_marker: bool = None
    ''' Include the name of the last marker in image metadata

    :type: bool
    '''

    use_stamp_memory: bool = None
    ''' Include the peak memory usage in image metadata

    :type: bool
    '''

    use_stamp_note: bool = None
    ''' Include a custom note in image/video metadata

    :type: bool
    '''

    use_stamp_render_time: bool = None
    ''' Include the render time in image metadata

    :type: bool
    '''

    use_stamp_scene: bool = None
    ''' Include the name of the active scene in image/video metadata

    :type: bool
    '''

    use_stamp_sequencer_strip: bool = None
    ''' Include the name of the foreground sequence strip in image metadata

    :type: bool
    '''

    use_stamp_time: bool = None
    ''' Include the rendered frame timecode as HH:MM:SS.FF in image metadata

    :type: bool
    '''

    views: typing.Union[typing.Dict[str, 'SceneRenderView'], typing.
                        List['SceneRenderView'], 'bpy_prop_collection',
                        'RenderViews'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'SceneRenderView'], typing.List['SceneRenderView'], 'bpy_prop_collection', 'RenderViews']
    '''

    views_format: typing.Union[str, int] = None
    ''' * STEREO_3D Stereo 3D, Single stereo camera system, adjust the stereo settings in the camera panel. * MULTIVIEW Multi-View, Multi camera system, adjust the cameras individually.

    :type: typing.Union[str, int]
    '''

    def frame_path(self,
                   frame: int = -2147483648,
                   preview: bool = False,
                   view: str = "") -> str:
        ''' Return the absolute path to the filename to be written for a given frame

        :param frame: Frame number to use, if unset the current frame will be used
        :type frame: int
        :param preview: Preview, Use preview range
        :type preview: bool
        :param view: View, The name of the view to use to replace the "%" chars
        :type view: str
        :rtype: str
        :return: File Path, The resulting filepath from the scenes render settings
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderSlot(bpy_struct):
    ''' Parameters defining the render slot
    '''

    name: str = None
    ''' Render slot name

    :type: str
    '''

    def clear(self, iuser: 'ImageUser'):
        ''' Clear the render slot

        :param iuser: ImageUser
        :type iuser: 'ImageUser'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderSlots(bpy_struct):
    ''' Collection of render layers
    '''

    active: 'RenderSlot' = None
    ''' Active render slot of the image

    :type: 'RenderSlot'
    '''

    active_index: int = None
    ''' Active render slot of the image

    :type: int
    '''

    def new(self, name: str = "") -> 'RenderSlot':
        ''' Add a render slot to the image

        :param name: Name, New name for the render slot
        :type name: str
        :rtype: 'RenderSlot'
        :return: Newly created render layer
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderView(bpy_struct):
    name: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RenderViews(bpy_struct):
    ''' Collection of render views
    '''

    active: 'SceneRenderView' = None
    ''' Active Render View

    :type: 'SceneRenderView'
    '''

    active_index: int = None
    ''' Active index in render view array

    :type: int
    '''

    def new(self, name: str) -> 'SceneRenderView':
        ''' Add a render view to scene

        :param name: New name for the marker (not unique)
        :type name: str
        :rtype: 'SceneRenderView'
        :return: Newly created render view
        '''
        pass

    def remove(self, view: 'SceneRenderView'):
        ''' Remove a render view

        :param view: Render view to remove
        :type view: 'SceneRenderView'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RigidBodyConstraint(bpy_struct):
    ''' Constraint influencing Objects inside Rigid Body Simulation
    '''

    breaking_threshold: float = None
    ''' Impulse threshold that must be reached for the constraint to break

    :type: float
    '''

    disable_collisions: bool = None
    ''' Disable collisions between constrained rigid bodies

    :type: bool
    '''

    enabled: bool = None
    ''' Enable this constraint

    :type: bool
    '''

    limit_ang_x_lower: float = None
    ''' Lower limit of X axis rotation

    :type: float
    '''

    limit_ang_x_upper: float = None
    ''' Upper limit of X axis rotation

    :type: float
    '''

    limit_ang_y_lower: float = None
    ''' Lower limit of Y axis rotation

    :type: float
    '''

    limit_ang_y_upper: float = None
    ''' Upper limit of Y axis rotation

    :type: float
    '''

    limit_ang_z_lower: float = None
    ''' Lower limit of Z axis rotation

    :type: float
    '''

    limit_ang_z_upper: float = None
    ''' Upper limit of Z axis rotation

    :type: float
    '''

    limit_lin_x_lower: float = None
    ''' Lower limit of X axis translation

    :type: float
    '''

    limit_lin_x_upper: float = None
    ''' Upper limit of X axis translation

    :type: float
    '''

    limit_lin_y_lower: float = None
    ''' Lower limit of Y axis translation

    :type: float
    '''

    limit_lin_y_upper: float = None
    ''' Upper limit of Y axis translation

    :type: float
    '''

    limit_lin_z_lower: float = None
    ''' Lower limit of Z axis translation

    :type: float
    '''

    limit_lin_z_upper: float = None
    ''' Upper limit of Z axis translation

    :type: float
    '''

    motor_ang_max_impulse: float = None
    ''' Maximum angular motor impulse

    :type: float
    '''

    motor_ang_target_velocity: float = None
    ''' Target angular motor velocity

    :type: float
    '''

    motor_lin_max_impulse: float = None
    ''' Maximum linear motor impulse

    :type: float
    '''

    motor_lin_target_velocity: float = None
    ''' Target linear motor velocity

    :type: float
    '''

    object1: 'Object' = None
    ''' First Rigid Body Object to be constrained

    :type: 'Object'
    '''

    object2: 'Object' = None
    ''' Second Rigid Body Object to be constrained

    :type: 'Object'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    spring_damping_ang_x: float = None
    ''' Damping on the X rotational axis

    :type: float
    '''

    spring_damping_ang_y: float = None
    ''' Damping on the Y rotational axis

    :type: float
    '''

    spring_damping_ang_z: float = None
    ''' Damping on the Z rotational axis

    :type: float
    '''

    spring_damping_x: float = None
    ''' Damping on the X axis

    :type: float
    '''

    spring_damping_y: float = None
    ''' Damping on the Y axis

    :type: float
    '''

    spring_damping_z: float = None
    ''' Damping on the Z axis

    :type: float
    '''

    spring_stiffness_ang_x: float = None
    ''' Stiffness on the X rotational axis

    :type: float
    '''

    spring_stiffness_ang_y: float = None
    ''' Stiffness on the Y rotational axis

    :type: float
    '''

    spring_stiffness_ang_z: float = None
    ''' Stiffness on the Z rotational axis

    :type: float
    '''

    spring_stiffness_x: float = None
    ''' Stiffness on the X axis

    :type: float
    '''

    spring_stiffness_y: float = None
    ''' Stiffness on the Y axis

    :type: float
    '''

    spring_stiffness_z: float = None
    ''' Stiffness on the Z axis

    :type: float
    '''

    spring_type: typing.Union[str, int] = None
    ''' Which implementation of spring to use * SPRING1 Blender 2.7, Spring implementation used in blender 2.7. Damping is capped at 1.0. * SPRING2 Blender 2.8, New implementation available since 2.8.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' Type of Rigid Body Constraint * FIXED Fixed, Glue rigid bodies together. * POINT Point, Constrain rigid bodies to move around common pivot point. * HINGE Hinge, Restrict rigid body rotation to one axis. * SLIDER Slider, Restrict rigid body translation to one axis. * PISTON Piston, Restrict rigid body translation and rotation to one axis. * GENERIC Generic, Restrict translation and rotation to specified axes. * GENERIC_SPRING Generic Spring, Restrict translation and rotation to specified axes with springs. * MOTOR Motor, Drive rigid body around or along an axis.

    :type: typing.Union[str, int]
    '''

    use_breaking: bool = None
    ''' Constraint can be broken if it receives an impulse above the threshold

    :type: bool
    '''

    use_limit_ang_x: bool = None
    ''' Limit rotation around X axis

    :type: bool
    '''

    use_limit_ang_y: bool = None
    ''' Limit rotation around Y axis

    :type: bool
    '''

    use_limit_ang_z: bool = None
    ''' Limit rotation around Z axis

    :type: bool
    '''

    use_limit_lin_x: bool = None
    ''' Limit translation on X axis

    :type: bool
    '''

    use_limit_lin_y: bool = None
    ''' Limit translation on Y axis

    :type: bool
    '''

    use_limit_lin_z: bool = None
    ''' Limit translation on Z axis

    :type: bool
    '''

    use_motor_ang: bool = None
    ''' Enable angular motor

    :type: bool
    '''

    use_motor_lin: bool = None
    ''' Enable linear motor

    :type: bool
    '''

    use_override_solver_iterations: bool = None
    ''' Override the number of solver iterations for this constraint

    :type: bool
    '''

    use_spring_ang_x: bool = None
    ''' Enable spring on X rotational axis

    :type: bool
    '''

    use_spring_ang_y: bool = None
    ''' Enable spring on Y rotational axis

    :type: bool
    '''

    use_spring_ang_z: bool = None
    ''' Enable spring on Z rotational axis

    :type: bool
    '''

    use_spring_x: bool = None
    ''' Enable spring on X axis

    :type: bool
    '''

    use_spring_y: bool = None
    ''' Enable spring on Y axis

    :type: bool
    '''

    use_spring_z: bool = None
    ''' Enable spring on Z axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RigidBodyObject(bpy_struct):
    ''' Settings for object participating in Rigid Body Simulation
    '''

    angular_damping: float = None
    ''' Amount of angular velocity that is lost over time

    :type: float
    '''

    collision_collections: typing.List[bool] = None
    ''' Collision collections rigid body belongs to

    :type: typing.List[bool]
    '''

    collision_margin: float = None
    ''' Threshold of distance near surface where collisions are still considered (best results when non-zero)

    :type: float
    '''

    collision_shape: typing.Union[str, int] = None
    ''' Collision Shape of object in Rigid Body Simulations * BOX Box, Box-like shapes (i.e. cubes), including planes (i.e. ground planes). * SPHERE Sphere. * CAPSULE Capsule. * CYLINDER Cylinder. * CONE Cone. * CONVEX_HULL Convex Hull, A mesh-like surface encompassing (i.e. shrinkwrap over) all vertices (best results with fewer vertices). * MESH Mesh, Mesh consisting of triangles only, allowing for more detailed interactions than convex hulls. * COMPOUND Compound Parent, Combines all of its direct rigid body children into one rigid object.

    :type: typing.Union[str, int]
    '''

    deactivate_angular_velocity: float = None
    ''' Angular Velocity below which simulation stops simulating object

    :type: float
    '''

    deactivate_linear_velocity: float = None
    ''' Linear Velocity below which simulation stops simulating object

    :type: float
    '''

    enabled: bool = None
    ''' Rigid Body actively participates to the simulation

    :type: bool
    '''

    friction: float = None
    ''' Resistance of object to movement

    :type: float
    '''

    kinematic: bool = None
    ''' Allow rigid body to be controlled by the animation system

    :type: bool
    '''

    linear_damping: float = None
    ''' Amount of linear velocity that is lost over time

    :type: float
    '''

    mass: float = None
    ''' How much the object 'weighs' irrespective of gravity

    :type: float
    '''

    mesh_source: typing.Union[str, int] = None
    ''' Source of the mesh used to create collision shape * BASE Base, Base mesh. * DEFORM Deform, Deformations (shape keys, deform modifiers). * FINAL Final, All modifiers.

    :type: typing.Union[str, int]
    '''

    restitution: float = None
    ''' Tendency of object to bounce after colliding with another (0 = stays still, 1 = perfectly elastic)

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Role of object in Rigid Body Simulations * ACTIVE Active, Object is directly controlled by simulation results. * PASSIVE Passive, Object is directly controlled by animation system.

    :type: typing.Union[str, int]
    '''

    use_deactivation: bool = None
    ''' Enable deactivation of resting rigid bodies (increases performance and stability but can cause glitches)

    :type: bool
    '''

    use_deform: bool = None
    ''' Rigid body deforms during simulation

    :type: bool
    '''

    use_margin: bool = None
    ''' Use custom collision margin (some shapes will have a visible gap around them)

    :type: bool
    '''

    use_start_deactivated: bool = None
    ''' Deactivate rigid body at the start of the simulation

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class RigidBodyWorld(bpy_struct):
    ''' Self-contained rigid body simulation environment and settings
    '''

    collection: 'Collection' = None
    ''' Collection containing objects participating in this simulation

    :type: 'Collection'
    '''

    constraints: 'Collection' = None
    ''' Collection containing rigid body constraint objects

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    enabled: bool = None
    ''' Simulation will be evaluated

    :type: bool
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    substeps_per_frame: int = None
    ''' Number of simulation steps taken per frame (higher values are more accurate but slower)

    :type: int
    '''

    time_scale: float = None
    ''' Change the speed of the simulation

    :type: float
    '''

    use_split_impulse: bool = None
    ''' Reduce extra velocity that can build up when objects collide (lowers simulation stability a little so use only when necessary)

    :type: bool
    '''

    def convex_sweep_test(self, object: 'Object', start: typing.List[float],
                          end: typing.List[float]):
        ''' Sweep test convex rigidbody against the current rigidbody world

        :param object: Rigidbody object with a convex collision shape
        :type object: 'Object'
        :param start: 
        :type start: typing.List[float]
        :param end: 
        :type end: typing.List[float]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SPHFluidSettings(bpy_struct):
    ''' Settings for particle fluids physics
    '''

    buoyancy: float = None
    ''' Artificial buoyancy force in negative gravity direction based on pressure differences inside the fluid

    :type: float
    '''

    fluid_radius: float = None
    ''' Fluid interaction radius

    :type: float
    '''

    linear_viscosity: float = None
    ''' Linear viscosity

    :type: float
    '''

    plasticity: float = None
    ''' How much the spring rest length can change after the elastic limit is crossed

    :type: float
    '''

    repulsion: float = None
    ''' How strongly the fluid tries to keep from clustering (factor of stiffness)

    :type: float
    '''

    rest_density: float = None
    ''' Fluid rest density

    :type: float
    '''

    rest_length: float = None
    ''' Spring rest length (factor of particle radius)

    :type: float
    '''

    solver: typing.Union[str, int] = None
    ''' The code used to calculate internal forces on particles * DDR Double-Density, An artistic solver with strong surface tension effects (original). * CLASSICAL Classical, A more physically-accurate solver.

    :type: typing.Union[str, int]
    '''

    spring_force: float = None
    ''' Spring force

    :type: float
    '''

    spring_frames: int = None
    ''' Create springs for this number of frames since particles birth (0 is always)

    :type: int
    '''

    stiff_viscosity: float = None
    ''' Creates viscosity for expanding fluid

    :type: float
    '''

    stiffness: float = None
    ''' How incompressible the fluid is (speed of sound)

    :type: float
    '''

    use_factor_density: bool = None
    ''' Density is calculated as a factor of default density (depends on particle size)

    :type: bool
    '''

    use_factor_radius: bool = None
    ''' Interaction radius is a factor of 4 * particle size

    :type: bool
    '''

    use_factor_repulsion: bool = None
    ''' Repulsion is a factor of stiffness

    :type: bool
    '''

    use_factor_rest_length: bool = None
    ''' Spring rest length is a factor of 2 * particle size

    :type: bool
    '''

    use_factor_stiff_viscosity: bool = None
    ''' Stiff viscosity is a factor of normal viscosity

    :type: bool
    '''

    use_initial_rest_length: bool = None
    ''' Use the initial length as spring rest length instead of 2 * particle size

    :type: bool
    '''

    use_viscoelastic_springs: bool = None
    ''' Use viscoelastic springs instead of Hooke's springs

    :type: bool
    '''

    yield_ratio: float = None
    ''' How much the spring has to be stretched/compressed in order to change its rest length

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SceneDisplay(bpy_struct):
    ''' Scene display settings for 3D viewport
    '''

    light_direction: typing.List[float] = None
    ''' Direction of the light for shadows and highlights

    :type: typing.List[float]
    '''

    matcap_ssao_attenuation: float = None
    ''' Attenuation constant

    :type: float
    '''

    matcap_ssao_distance: float = None
    ''' Distance of object that contribute to the Cavity/Edge effect

    :type: float
    '''

    matcap_ssao_samples: int = None
    ''' Number of samples

    :type: int
    '''

    render_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing when rendering final image * OFF No Anti-Aliasing, Scene will be rendering without any anti-aliasing. * FXAA Single Pass Anti-Aliasing, Scene will be rendered using a single pass anti-aliasing method (FXAA). * 5 5 Samples, Scene will be rendered using 5 anti-aliasing samples. * 8 8 Samples, Scene will be rendered using 8 anti-aliasing samples. * 11 11 Samples, Scene will be rendered using 11 anti-aliasing samples. * 16 16 Samples, Scene will be rendered using 16 anti-aliasing samples. * 32 32 Samples, Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    shading: 'View3DShading' = None
    ''' Shading settings for OpenGL render engine

    :type: 'View3DShading'
    '''

    shadow_focus: float = None
    ''' Shadow factor hardness

    :type: float
    '''

    shadow_shift: float = None
    ''' Shadow termination angle

    :type: float
    '''

    viewport_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing when rendering 3d viewport * OFF No Anti-Aliasing, Scene will be rendering without any anti-aliasing. * FXAA Single Pass Anti-Aliasing, Scene will be rendered using a single pass anti-aliasing method (FXAA). * 5 5 Samples, Scene will be rendered using 5 anti-aliasing samples. * 8 8 Samples, Scene will be rendered using 8 anti-aliasing samples. * 11 11 Samples, Scene will be rendered using 11 anti-aliasing samples. * 16 16 Samples, Scene will be rendered using 16 anti-aliasing samples. * 32 32 Samples, Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SceneEEVEE(bpy_struct):
    ''' Scene display settings for 3D viewport
    '''

    bloom_clamp: float = None
    ''' Maximum intensity a bloom pixel can have (0 to disabled)

    :type: float
    '''

    bloom_color: typing.List[float] = None
    ''' Color applied to the bloom effect

    :type: typing.List[float]
    '''

    bloom_intensity: float = None
    ''' Blend factor

    :type: float
    '''

    bloom_knee: float = None
    ''' Makes transition between under/over-threshold gradual

    :type: float
    '''

    bloom_radius: float = None
    ''' Bloom spread distance

    :type: float
    '''

    bloom_threshold: float = None
    ''' Filters out pixels under this level of brightness

    :type: float
    '''

    bokeh_denoise_fac: float = None
    ''' Amount of flicker removal applied to bokeh highlights

    :type: float
    '''

    bokeh_max_size: float = None
    ''' Max size of the bokeh shape for the depth of field (lower is faster)

    :type: float
    '''

    bokeh_neighbor_max: float = None
    ''' Maximum brightness to consider when rejecting bokeh sprites based on neighborhood (lower is faster)

    :type: float
    '''

    bokeh_overblur: float = None
    ''' Apply blur to each jittered sample to reduce under-sampling artifacts

    :type: float
    '''

    bokeh_threshold: float = None
    ''' Brightness threshold for using sprite base depth of field

    :type: float
    '''

    gi_auto_bake: bool = None
    ''' Auto bake indirect lighting when editing probes

    :type: bool
    '''

    gi_cache_info: str = None
    ''' Info on current cache status

    :type: str
    '''

    gi_cubemap_display_size: float = None
    ''' Size of the cubemap spheres to debug captured light

    :type: float
    '''

    gi_cubemap_resolution: typing.Union[str, int] = None
    ''' Size of every cubemaps

    :type: typing.Union[str, int]
    '''

    gi_diffuse_bounces: int = None
    ''' Number of time the light is reinjected inside light grids, 0 disable indirect diffuse light

    :type: int
    '''

    gi_filter_quality: float = None
    ''' Take more samples during cubemap filtering to remove artifacts

    :type: float
    '''

    gi_glossy_clamp: float = None
    ''' Clamp pixel intensity to reduce noise inside glossy reflections from reflection cubemaps (0 to disabled)

    :type: float
    '''

    gi_irradiance_display_size: float = None
    ''' Size of the irradiance sample spheres to debug captured light

    :type: float
    '''

    gi_irradiance_smoothing: float = None
    ''' Smoother irradiance interpolation but introduce light bleeding

    :type: float
    '''

    gi_show_cubemaps: bool = None
    ''' Display captured cubemaps in the viewport

    :type: bool
    '''

    gi_show_irradiance: bool = None
    ''' Display irradiance samples in the viewport

    :type: bool
    '''

    gi_visibility_resolution: typing.Union[str, int] = None
    ''' Size of the shadow map applied to each irradiance sample

    :type: typing.Union[str, int]
    '''

    gtao_distance: float = None
    ''' Distance of object that contribute to the ambient occlusion effect

    :type: float
    '''

    gtao_factor: float = None
    ''' Factor for ambient occlusion blending

    :type: float
    '''

    gtao_quality: float = None
    ''' Precision of the horizon search

    :type: float
    '''

    light_threshold: float = None
    ''' Minimum light intensity for a light to contribute to the lighting

    :type: float
    '''

    motion_blur_depth_scale: float = None
    ''' Lower values will reduce background bleeding onto foreground elements

    :type: float
    '''

    motion_blur_max: int = None
    ''' Maximum blur distance a pixel can spread over

    :type: int
    '''

    motion_blur_position: typing.Union[str, int] = None
    ''' Offset for the shutter's time interval, allows to change the motion blur trails * START Start on Frame, The shutter opens at the current frame. * CENTER Center on Frame, The shutter is open during the current frame. * END End on Frame, The shutter closes at the current frame.

    :type: typing.Union[str, int]
    '''

    motion_blur_shutter: float = None
    ''' Time taken in frames between shutter open and close

    :type: float
    '''

    motion_blur_steps: int = None
    ''' Controls accuracy of motion blur, more steps means longer render time

    :type: int
    '''

    overscan_size: float = None
    ''' Percentage of render size to add as overscan to the internal render buffers

    :type: float
    '''

    shadow_cascade_size: typing.Union[str, int] = None
    ''' Size of sun light shadow maps

    :type: typing.Union[str, int]
    '''

    shadow_cube_size: typing.Union[str, int] = None
    ''' Size of point and area light shadow maps

    :type: typing.Union[str, int]
    '''

    ssr_border_fade: float = None
    ''' Screen percentage used to fade the SSR

    :type: float
    '''

    ssr_firefly_fac: float = None
    ''' Clamp pixel intensity to remove noise (0 to disabled)

    :type: float
    '''

    ssr_max_roughness: float = None
    ''' Do not raytrace reflections for roughness above this value

    :type: float
    '''

    ssr_quality: float = None
    ''' Precision of the screen space raytracing

    :type: float
    '''

    ssr_thickness: float = None
    ''' Pixel thickness used to detect intersection

    :type: float
    '''

    sss_jitter_threshold: float = None
    ''' Rotate samples that are below this threshold

    :type: float
    '''

    sss_samples: int = None
    ''' Number of samples to compute the scattering effect

    :type: int
    '''

    taa_render_samples: int = None
    ''' Number of samples per pixels for rendering

    :type: int
    '''

    taa_samples: int = None
    ''' Number of samples, unlimited if 0

    :type: int
    '''

    use_bloom: bool = None
    ''' High brightness pixels generate a glowing effect

    :type: bool
    '''

    use_bokeh_high_quality_slight_defocus: bool = None
    ''' Sample all pixels in almost in-focus regions to eliminate noise

    :type: bool
    '''

    use_bokeh_jittered: bool = None
    ''' Jitter camera position to create accurate blurring using render samples

    :type: bool
    '''

    use_gtao: bool = None
    ''' Enable ambient occlusion to simulate medium scale indirect shadowing

    :type: bool
    '''

    use_gtao_bent_normals: bool = None
    ''' Compute main non occluded direction to sample the environment

    :type: bool
    '''

    use_gtao_bounce: bool = None
    ''' An approximation to simulate light bounces giving less occlusion on brighter objects

    :type: bool
    '''

    use_motion_blur: bool = None
    ''' Enable motion blur effect (only in camera view)

    :type: bool
    '''

    use_overscan: bool = None
    ''' Internally render past the image border to avoid screen-space effects disappearing

    :type: bool
    '''

    use_shadow_high_bitdepth: bool = None
    ''' Use 32-bit shadows

    :type: bool
    '''

    use_soft_shadows: bool = None
    ''' Randomize shadowmaps origin to create soft shadows

    :type: bool
    '''

    use_ssr: bool = None
    ''' Enable screen space reflection

    :type: bool
    '''

    use_ssr_halfres: bool = None
    ''' Raytrace at a lower resolution

    :type: bool
    '''

    use_ssr_refraction: bool = None
    ''' Enable screen space Refractions

    :type: bool
    '''

    use_taa_reprojection: bool = None
    ''' Denoise image using temporal reprojection (can leave some ghosting)

    :type: bool
    '''

    use_volumetric_lights: bool = None
    ''' Enable scene light interactions with volumetrics

    :type: bool
    '''

    use_volumetric_shadows: bool = None
    ''' Generate shadows from volumetric material (Very expensive)

    :type: bool
    '''

    volumetric_end: float = None
    ''' End distance of the volumetric effect

    :type: float
    '''

    volumetric_light_clamp: float = None
    ''' Maximum light contribution, reducing noise

    :type: float
    '''

    volumetric_sample_distribution: float = None
    ''' Distribute more samples closer to the camera

    :type: float
    '''

    volumetric_samples: int = None
    ''' Number of samples to compute volumetric effects

    :type: int
    '''

    volumetric_shadow_samples: int = None
    ''' Number of samples to compute volumetric shadowing

    :type: int
    '''

    volumetric_start: float = None
    ''' Start distance of the volumetric effect

    :type: float
    '''

    volumetric_tile_size: typing.Union[str, int] = None
    ''' Control the quality of the volumetric effects (lower size increase vram usage and quality)

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SceneGpencil(bpy_struct):
    ''' Render settings
    '''

    antialias_threshold: float = None
    ''' Threshold for edge detection algorithm (higher values might over-blur some part of the image)

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SceneObjects(bpy_struct):
    ''' All of the scene objects
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SceneRenderView(bpy_struct):
    ''' Render viewpoint for 3D stereo and multiview rendering
    '''

    camera_suffix: str = None
    ''' Suffix to identify the cameras to use, and added to the render images for this view

    :type: str
    '''

    file_suffix: str = None
    ''' Suffix added to the render images for this view

    :type: str
    '''

    name: str = None
    ''' Render view name

    :type: str
    '''

    use: bool = None
    ''' Disable or enable the render view

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Scopes(bpy_struct):
    ''' Scopes for statistical view of an image
    '''

    accuracy: float = None
    ''' Proportion of original image source pixel lines to sample

    :type: float
    '''

    histogram: 'Histogram' = None
    ''' Histogram for viewing image statistics

    :type: 'Histogram'
    '''

    use_full_resolution: bool = None
    ''' Sample every pixel of the image

    :type: bool
    '''

    vectorscope_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Sequence(bpy_struct):
    ''' Sequence strip in the sequence editor
    '''

    blend_alpha: float = None
    ''' Percentage of how much the strip's colors affect other strips

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method for controlling how the strip combines with other strips

    :type: typing.Union[str, int]
    '''

    channel: int = None
    ''' Y position of the sequence strip

    :type: int
    '''

    effect_fader: float = None
    ''' Custom fade value

    :type: float
    '''

    frame_duration: int = None
    ''' The length of the contents of this strip before the handles are applied

    :type: int
    '''

    frame_final_duration: int = None
    ''' The length of the contents of this strip after the handles are applied

    :type: int
    '''

    frame_final_end: int = None
    ''' End frame displayed in the sequence editor after offsets are applied

    :type: int
    '''

    frame_final_start: int = None
    ''' Start frame displayed in the sequence editor after offsets are applied, setting this is equivalent to moving the handle, not the actual start frame

    :type: int
    '''

    frame_offset_end: int = None
    ''' 

    :type: int
    '''

    frame_offset_start: int = None
    ''' 

    :type: int
    '''

    frame_start: int = None
    ''' X position where the strip begins

    :type: int
    '''

    frame_still_end: int = None
    ''' 

    :type: int
    '''

    frame_still_start: int = None
    ''' 

    :type: int
    '''

    lock: bool = None
    ''' Lock strip so that it cannot be transformed

    :type: bool
    '''

    modifiers: typing.Union[typing.Dict[str, 'SequenceModifier'], typing.
                            List['SequenceModifier'], 'bpy_prop_collection',
                            'SequenceModifiers'] = None
    ''' Modifiers affecting this strip

    :type: typing.Union[typing.Dict[str, 'SequenceModifier'], typing.List['SequenceModifier'], 'bpy_prop_collection', 'SequenceModifiers']
    '''

    mute: bool = None
    ''' Disable strip so that it cannot be viewed in the output

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    override_cache_settings: bool = None
    ''' Override global cache settings

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_left_handle: bool = None
    ''' 

    :type: bool
    '''

    select_right_handle: bool = None
    ''' 

    :type: bool
    '''

    speed_factor: float = None
    ''' Multiply the current speed of the sequence with this number or remap current frame to this frame

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_cache_composite: bool = None
    ''' Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    ''' Cache preprocessed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    '''

    use_cache_raw: bool = None
    ''' Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    '''

    use_default_fade: bool = None
    ''' Fade effect using the built-in default (usually make transition as long as effect strip)

    :type: bool
    '''

    use_linear_modifiers: bool = None
    ''' Calculate modifiers in linear space instead of sequencer's space

    :type: bool
    '''

    def update(self, data: bool = False):
        ''' Update the strip dimensions

        :param data: Data, Update strip data
        :type data: bool
        '''
        pass

    def strip_elem_from_frame(self, frame: int) -> 'SequenceElement':
        ''' Return the strip element from a given frame or None

        :param frame: Frame, The frame to get the strip element from
        :type frame: int
        :rtype: 'SequenceElement'
        :return: strip element of the current frame
        '''
        pass

    def swap(self, other: 'Sequence'):
        ''' swap

        :param other: Other
        :type other: 'Sequence'
        '''
        pass

    def move_to_meta(self, meta_sequence: 'Sequence'):
        ''' move_to_meta

        :param meta_sequence: Destination Meta Sequence, Meta to move the strip into
        :type meta_sequence: 'Sequence'
        '''
        pass

    def invalidate_cache(self, type: typing.Union[str, int]):
        ''' Invalidate cached images for strip and all dependent strips

        :param type: Type, Cache Type
        :type type: typing.Union[str, int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceColorBalanceData(bpy_struct):
    ''' Color balance parameters for a sequence strip and its modifiers
    '''

    gain: typing.List[float] = None
    ''' Color balance gain (highlights)

    :type: typing.List[float]
    '''

    gamma: typing.List[float] = None
    ''' Color balance gamma (midtones)

    :type: typing.List[float]
    '''

    invert_gain: bool = None
    ''' Invert the gain color

    :type: bool
    '''

    invert_gamma: bool = None
    ''' Invert the gamma color

    :type: bool
    '''

    invert_lift: bool = None
    ''' Invert the lift color

    :type: bool
    '''

    lift: typing.List[float] = None
    ''' Color balance lift (shadows)

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceCrop(bpy_struct):
    ''' Cropping parameters for a sequence strip
    '''

    max_x: int = None
    ''' Number of pixels to crop from the right side

    :type: int
    '''

    max_y: int = None
    ''' Number of pixels to crop from the top

    :type: int
    '''

    min_x: int = None
    ''' Number of pixels to crop from the left side

    :type: int
    '''

    min_y: int = None
    ''' Number of pixels to crop from the bottom

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceEditor(bpy_struct):
    ''' Sequence editing data for a Scene data-block
    '''

    active_strip: 'Sequence' = None
    ''' Sequencer's active strip

    :type: 'Sequence'
    '''

    meta_stack: typing.Union[typing.Dict[str, 'Sequence'], typing.
                             List['Sequence'], 'bpy_prop_collection'] = None
    ''' Meta strip stack, last is currently edited meta strip

    :type: typing.Union[typing.Dict[str, 'Sequence'], typing.List['Sequence'], 'bpy_prop_collection']
    '''

    overlay_frame: int = None
    ''' Number of frames to offset

    :type: int
    '''

    proxy_dir: str = None
    ''' 

    :type: str
    '''

    proxy_storage: typing.Union[str, int] = None
    ''' How to store proxies for this project * PER_STRIP Per Strip, Store proxies using per strip settings. * PROJECT Project, Store proxies using project directory.

    :type: typing.Union[str, int]
    '''

    sequences: typing.Union[typing.Dict[str, 'Sequence'], typing.
                            List['Sequence'], 'bpy_prop_collection',
                            'SequencesTopLevel'] = None
    ''' Top-level strips only

    :type: typing.Union[typing.Dict[str, 'Sequence'], typing.List['Sequence'], 'bpy_prop_collection', 'SequencesTopLevel']
    '''

    sequences_all: typing.Union[typing.Dict[str, 'Sequence'], typing.
                                List['Sequence'], 'bpy_prop_collection'] = None
    ''' All strips, recursively including those inside metastrips

    :type: typing.Union[typing.Dict[str, 'Sequence'], typing.List['Sequence'], 'bpy_prop_collection']
    '''

    show_cache: bool = None
    ''' Visualize cached images on the timeline

    :type: bool
    '''

    show_cache_composite: bool = None
    ''' Visualize cached composite images

    :type: bool
    '''

    show_cache_final_out: bool = None
    ''' Visualize cached complete frames

    :type: bool
    '''

    show_cache_preprocessed: bool = None
    ''' Visualize cached pre-processed images

    :type: bool
    '''

    show_cache_raw: bool = None
    ''' Visualize cached raw images

    :type: bool
    '''

    show_overlay: bool = None
    ''' Partial overlay on top of the sequencer with a frame offset

    :type: bool
    '''

    use_cache_composite: bool = None
    ''' Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    '''

    use_cache_final: bool = None
    ''' Cache final image for each frame

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    ''' Cache pre-processed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    '''

    use_cache_raw: bool = None
    ''' Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    '''

    use_overlay_lock: bool = None
    ''' 

    :type: bool
    '''

    use_prefetch: bool = None
    ''' Render frames ahead of current frame in the background for faster playback

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceElement(bpy_struct):
    ''' Sequence strip data for a single frame
    '''

    filename: str = None
    ''' Name of the source file

    :type: str
    '''

    orig_height: int = None
    ''' Original image height

    :type: int
    '''

    orig_width: int = None
    ''' Original image width

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceElements(bpy_struct):
    ''' Collection of SequenceElement
    '''

    def append(self, filename: str) -> 'SequenceElement':
        ''' Push an image from ImageSequence.directory

        :param filename: Filepath to image
        :type filename: str
        :rtype: 'SequenceElement'
        :return: New SequenceElement
        '''
        pass

    def pop(self, index: int):
        ''' Pop an image off the collection

        :param index: Index of image to remove
        :type index: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceModifier(bpy_struct):
    ''' Modifier for sequence strip
    '''

    input_mask_id: 'Mask' = None
    ''' Mask ID used as mask input for the modifier

    :type: 'Mask'
    '''

    input_mask_strip: 'Sequence' = None
    ''' Strip used as mask input for the modifier

    :type: 'Sequence'
    '''

    input_mask_type: typing.Union[str, int] = None
    ''' Type of input data used for mask * STRIP Strip, Use sequencer strip as mask input. * ID Mask, Use mask ID as mask input.

    :type: typing.Union[str, int]
    '''

    mask_time: typing.Union[str, int] = None
    ''' Time to use for the Mask animation * RELATIVE Relative, Mask animation is offset to start of strip. * ABSOLUTE Absolute, Mask animation is in sync with scene frame.

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Mute this modifier

    :type: bool
    '''

    name: str = None
    ''' 

    :type: str
    '''

    show_expanded: bool = None
    ''' Mute expanded settings for the modifier

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceModifiers(bpy_struct):
    ''' Collection of strip modifiers
    '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'SequenceModifier':
        ''' Add a new modifier

        :param name: New name for the modifier
        :type name: str
        :param type: Modifier type to add
        :type type: typing.Union[str, int]
        :rtype: 'SequenceModifier'
        :return: Newly created modifier
        '''
        pass

    def remove(self, modifier: 'SequenceModifier'):
        ''' Remove an existing modifier from the sequence

        :param modifier: Modifier to remove
        :type modifier: 'SequenceModifier'
        '''
        pass

    def clear(self):
        ''' Remove all modifiers from the sequence

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceProxy(bpy_struct):
    ''' Proxy parameters for a sequence strip
    '''

    build_100: bool = None
    ''' Build 100% proxy resolution

    :type: bool
    '''

    build_25: bool = None
    ''' Build 25% proxy resolution

    :type: bool
    '''

    build_50: bool = None
    ''' Build 50% proxy resolution

    :type: bool
    '''

    build_75: bool = None
    ''' Build 75% proxy resolution

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    directory: str = None
    ''' Location to store the proxy files

    :type: str
    '''

    filepath: str = None
    ''' Location of custom proxy file

    :type: str
    '''

    quality: int = None
    ''' JPEG Quality of proxies to build

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' Method for reading the inputs timecode * NONE No TC in use. * RECORD_RUN Record Run, Use images in the order as they are recorded. * FREE_RUN Free Run, Use global timestamp written by recording device. * FREE_RUN_REC_DATE Free Run (rec date), Interpolate a global timestamp using the record date and time written by recording device. * RECORD_RUN_NO_GAPS Record Run No Gaps, Like record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''

    use_overwrite: bool = None
    ''' Overwrite existing proxy files when building

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    ''' Use a custom directory to store data

    :type: bool
    '''

    use_proxy_custom_file: bool = None
    ''' Use a custom file to read proxy data from

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequenceTransform(bpy_struct):
    ''' Transform parameters for a sequence strip
    '''

    offset_x: int = None
    ''' Move along X axis

    :type: int
    '''

    offset_y: int = None
    ''' Move along Y axis

    :type: int
    '''

    rotation: float = None
    ''' Rotate around image center

    :type: float
    '''

    scale_x: float = None
    ''' Scale along X axis

    :type: float
    '''

    scale_y: float = None
    ''' Scale along Y axis

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequencerToolSettings(bpy_struct):
    fit_method: typing.Union[str, int] = None
    ''' Scale fit method * FIT Scale to Fit, Scale image to fit within the canvas. * FILL Scale to Fill, Scale image to completely fill the canvas. * STRETCH Stretch to Fill, Stretch image to fill the canvas. * ORIGINAL Use Original Size, Keep image at its original size.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequencesMeta(bpy_struct):
    ''' Collection of Sequences
    '''

    def new_clip(self, name: str, clip: 'MovieClip', channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new movie clip sequence

        :param name: Name for the new sequence
        :type name: str
        :param clip: Movie clip to add
        :type clip: 'MovieClip'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_mask(self, name: str, mask: 'Mask', channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new mask sequence

        :param name: Name for the new sequence
        :type name: str
        :param mask: Mask to add
        :type mask: 'Mask'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_scene(self, name: str, scene: 'Scene', channel: int,
                  frame_start: int) -> 'Sequence':
        ''' Add a new scene sequence

        :param name: Name for the new sequence
        :type name: str
        :param scene: Scene to add
        :type scene: 'Scene'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_image(
            self,
            name: str,
            filepath: str,
            channel: int,
            frame_start: int,
            fit_method: typing.Union[str, int] = 'ORIGINAL') -> 'Sequence':
        ''' Add a new image sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to image
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param fit_method: Image Fit Method * FIT Scale to Fit, Scale image so fits in preview. * FILL Scale to Fill, Scale image so it fills preview completely. * STRETCH Stretch to Fill, Stretch image so it fills preview. * ORIGINAL Use Original Size, Don't scale the image.
        :type fit_method: typing.Union[str, int]
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_movie(
            self,
            name: str,
            filepath: str,
            channel: int,
            frame_start: int,
            fit_method: typing.Union[str, int] = 'ORIGINAL') -> 'Sequence':
        ''' Add a new movie sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to movie
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param fit_method: Image Fit Method * FIT Scale to Fit, Scale image so fits in preview. * FILL Scale to Fill, Scale image so it fills preview completely. * STRETCH Stretch to Fill, Stretch image so it fills preview. * ORIGINAL Use Original Size, Don't scale the image.
        :type fit_method: typing.Union[str, int]
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_sound(self, name: str, filepath: str, channel: int,
                  frame_start: int) -> 'Sequence':
        ''' Add a new sound sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to movie
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_meta(self, name: str, channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new meta sequence

        :param name: Name for the new sequence
        :type name: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_effect(self,
                   name: str,
                   type: typing.Union[str, int],
                   channel: int,
                   frame_start: int,
                   frame_end: int = 0,
                   seq1: 'Sequence' = None,
                   seq2: 'Sequence' = None,
                   seq3: 'Sequence' = None) -> 'Sequence':
        ''' Add a new effect sequence

        :param name: Name for the new sequence
        :type name: str
        :param type: Type, type for the new sequence
        :type type: typing.Union[str, int]
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param frame_end: The end frame for the new sequence
        :type frame_end: int
        :param seq1: Sequence 1 for effect
        :type seq1: 'Sequence'
        :param seq2: Sequence 2 for effect
        :type seq2: 'Sequence'
        :param seq3: Sequence 3 for effect
        :type seq3: 'Sequence'
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def remove(self, sequence: 'Sequence'):
        ''' Remove a Sequence

        :param sequence: Sequence to remove
        :type sequence: 'Sequence'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SequencesTopLevel(bpy_struct):
    ''' Collection of Sequences
    '''

    def new_clip(self, name: str, clip: 'MovieClip', channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new movie clip sequence

        :param name: Name for the new sequence
        :type name: str
        :param clip: Movie clip to add
        :type clip: 'MovieClip'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_mask(self, name: str, mask: 'Mask', channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new mask sequence

        :param name: Name for the new sequence
        :type name: str
        :param mask: Mask to add
        :type mask: 'Mask'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_scene(self, name: str, scene: 'Scene', channel: int,
                  frame_start: int) -> 'Sequence':
        ''' Add a new scene sequence

        :param name: Name for the new sequence
        :type name: str
        :param scene: Scene to add
        :type scene: 'Scene'
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_image(
            self,
            name: str,
            filepath: str,
            channel: int,
            frame_start: int,
            fit_method: typing.Union[str, int] = 'ORIGINAL') -> 'Sequence':
        ''' Add a new image sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to image
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param fit_method: Image Fit Method * FIT Scale to Fit, Scale image so fits in preview. * FILL Scale to Fill, Scale image so it fills preview completely. * STRETCH Stretch to Fill, Stretch image so it fills preview. * ORIGINAL Use Original Size, Don't scale the image.
        :type fit_method: typing.Union[str, int]
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_movie(
            self,
            name: str,
            filepath: str,
            channel: int,
            frame_start: int,
            fit_method: typing.Union[str, int] = 'ORIGINAL') -> 'Sequence':
        ''' Add a new movie sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to movie
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param fit_method: Image Fit Method * FIT Scale to Fit, Scale image so fits in preview. * FILL Scale to Fill, Scale image so it fills preview completely. * STRETCH Stretch to Fill, Stretch image so it fills preview. * ORIGINAL Use Original Size, Don't scale the image.
        :type fit_method: typing.Union[str, int]
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_sound(self, name: str, filepath: str, channel: int,
                  frame_start: int) -> 'Sequence':
        ''' Add a new sound sequence

        :param name: Name for the new sequence
        :type name: str
        :param filepath: Filepath to movie
        :type filepath: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_meta(self, name: str, channel: int,
                 frame_start: int) -> 'Sequence':
        ''' Add a new meta sequence

        :param name: Name for the new sequence
        :type name: str
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def new_effect(self,
                   name: str,
                   type: typing.Union[str, int],
                   channel: int,
                   frame_start: int,
                   frame_end: int = 0,
                   seq1: 'Sequence' = None,
                   seq2: 'Sequence' = None,
                   seq3: 'Sequence' = None) -> 'Sequence':
        ''' Add a new effect sequence

        :param name: Name for the new sequence
        :type name: str
        :param type: Type, type for the new sequence
        :type type: typing.Union[str, int]
        :param channel: Channel, The channel for the new sequence
        :type channel: int
        :param frame_start: The start frame for the new sequence
        :type frame_start: int
        :param frame_end: The end frame for the new sequence
        :type frame_end: int
        :param seq1: Sequence 1 for effect
        :type seq1: 'Sequence'
        :param seq2: Sequence 2 for effect
        :type seq2: 'Sequence'
        :param seq3: Sequence 3 for effect
        :type seq3: 'Sequence'
        :rtype: 'Sequence'
        :return: New Sequence
        '''
        pass

    def remove(self, sequence: 'Sequence'):
        ''' Remove a Sequence

        :param sequence: Sequence to remove
        :type sequence: 'Sequence'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ShaderFx(bpy_struct):
    ''' Effect affecting the grease pencil object
    '''

    name: str = None
    ''' Effect name

    :type: str
    '''

    show_expanded: bool = None
    ''' Set effect expansion in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display effect in Edit mode

    :type: bool
    '''

    show_render: bool = None
    ''' Use effect during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display effect in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' * FX_BLUR Blur, Apply Gaussian Blur to object. * FX_COLORIZE Colorize, Apply different tint effects. * FX_FLIP Flip, Flip image. * FX_GLOW Glow, Create a glow effect. * FX_PIXEL Pixelate, Pixelate image. * FX_RIM Rim, Add a rim to the image. * FX_SHADOW Shadow, Create a shadow effect. * FX_SWIRL Swirl, Create a rotation distortion. * FX_WAVE Wave Distortion, Apply sinusoidal deformation.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ShapeKey(bpy_struct):
    ''' Shape key in a shape keys data-block
    '''

    data: typing.Union[typing.Dict[str, 'UnknownType'], typing.
                       List['UnknownType'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'UnknownType'], typing.List['UnknownType'], 'bpy_prop_collection']
    '''

    frame: float = None
    ''' Frame for absolute keys

    :type: float
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation type for absolute shape keys

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Toggle this shape key

    :type: bool
    '''

    name: str = None
    ''' Name of Shape Key

    :type: str
    '''

    relative_key: 'ShapeKey' = None
    ''' Shape used as a relative key

    :type: 'ShapeKey'
    '''

    slider_max: float = None
    ''' Maximum for slider

    :type: float
    '''

    slider_min: float = None
    ''' Minimum for slider

    :type: float
    '''

    value: float = None
    ''' Value of shape key at the current frame

    :type: float
    '''

    vertex_group: str = None
    ''' Vertex weight group, to blend with basis shape

    :type: str
    '''

    def normals_vertex_get(self) -> float:
        ''' Compute local space vertices' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_polygon_get(self) -> float:
        ''' Compute local space faces' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_split_get(self) -> float:
        ''' Compute local space face corners' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyBezierPoint(bpy_struct):
    ''' Point in a shape key for Bezier curves
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_left: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_right: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyCurvePoint(bpy_struct):
    ''' Point in a shape key for curves
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyPoint(bpy_struct):
    ''' Point in a shape key
    '''

    co: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SoftBodySettings(bpy_struct):
    ''' Soft body simulation settings for an object
    '''

    aero: int = None
    ''' Make edges 'sail'

    :type: int
    '''

    aerodynamics_type: typing.Union[str, int] = None
    ''' Method of calculating aerodynamic interaction * SIMPLE Simple, Edges receive a drag force from surrounding media. * LIFT_FORCE Lift Force, Edges receive a lift force when passing through surrounding media.

    :type: typing.Union[str, int]
    '''

    ball_damp: float = None
    ''' Blending to inelastic collision

    :type: float
    '''

    ball_size: float = None
    ''' Absolute ball size or factor if not manually adjusted

    :type: float
    '''

    ball_stiff: float = None
    ''' Ball inflating pressure

    :type: float
    '''

    bend: float = None
    ''' Bending Stiffness

    :type: float
    '''

    choke: int = None
    ''' 'Viscosity' inside collision target

    :type: int
    '''

    collision_collection: 'Collection' = None
    ''' Limit colliders to this collection

    :type: 'Collection'
    '''

    collision_type: typing.Union[str, int] = None
    ''' Choose Collision Type * MANUAL Manual, Manual adjust. * AVERAGE Average, Average Spring length \* Ball Size. * MINIMAL Minimal, Minimal Spring length \* Ball Size. * MAXIMAL Maximal, Maximal Spring length \* Ball Size. * MINMAX AvMinMax, (Min+Max)/2 \* Ball Size.

    :type: typing.Union[str, int]
    '''

    damping: float = None
    ''' Edge spring friction

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    error_threshold: float = None
    ''' The Runge-Kutta ODE solver error limit, low value gives more precision, high values speed

    :type: float
    '''

    friction: float = None
    ''' General media friction for point movements

    :type: float
    '''

    fuzzy: int = None
    ''' Fuzziness while on collision, high values make collision handling faster but less stable

    :type: int
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: float = None
    ''' Apply gravitation to point movement

    :type: float
    '''

    location_mass_center: typing.List[float] = None
    ''' Location of center of mass

    :type: typing.List[float]
    '''

    mass: float = None
    ''' General Mass value

    :type: float
    '''

    plastic: int = None
    ''' Permanent deform

    :type: int
    '''

    pull: float = None
    ''' Edge spring stiffness when longer than rest length

    :type: float
    '''

    push: float = None
    ''' Edge spring stiffness when shorter than rest length

    :type: float
    '''

    rotation_estimate: typing.List[float] = None
    ''' Estimated rotation matrix

    :type: typing.List[float]
    '''

    scale_estimate: typing.List[float] = None
    ''' Estimated scale matrix

    :type: typing.List[float]
    '''

    shear: float = None
    ''' Shear Stiffness

    :type: float
    '''

    speed: float = None
    ''' Tweak timing for physics to control frequency and speed

    :type: float
    '''

    spring_length: int = None
    ''' Alter spring length to shrink/blow up (unit %) 0 to disable

    :type: int
    '''

    step_max: int = None
    ''' Maximal # solver steps/frame

    :type: int
    '''

    step_min: int = None
    ''' Minimal # solver steps/frame

    :type: int
    '''

    use_auto_step: bool = None
    ''' Use velocities for automagic step sizes

    :type: bool
    '''

    use_diagnose: bool = None
    ''' Turn on SB diagnose console prints

    :type: bool
    '''

    use_edge_collision: bool = None
    ''' Edges collide too

    :type: bool
    '''

    use_edges: bool = None
    ''' Use Edges as springs

    :type: bool
    '''

    use_estimate_matrix: bool = None
    ''' Store the estimated transforms in the soft body settings

    :type: bool
    '''

    use_face_collision: bool = None
    ''' Faces collide too, can be very slow

    :type: bool
    '''

    use_goal: bool = None
    ''' Define forces for vertices to stick to animated position

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable naive vertex ball self collision

    :type: bool
    '''

    use_stiff_quads: bool = None
    ''' Add diagonal springs on 4-gons

    :type: bool
    '''

    vertex_group_goal: str = None
    ''' Control point weight values

    :type: str
    '''

    vertex_group_mass: str = None
    ''' Control point mass values

    :type: str
    '''

    vertex_group_spring: str = None
    ''' Control point spring strength values

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Space(bpy_struct):
    ''' Space data for a screen area
    '''

    show_locked_time: bool = None
    ''' Synchronize the visible timeline range with other time-based editors

    :type: bool
    '''

    show_region_header: bool = None
    ''' 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Space data type * EMPTY Empty. * VIEW_3D 3D Viewport, Manipulate objects in a 3D environment. * IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps. * NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools. * SEQUENCE_EDITOR Video Sequencer, Video editing tools. * CLIP_EDITOR Movie Clip Editor, Motion tracking tools. * DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes. * GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation. * NLA_EDITOR Nonlinear Animation, Combine and layer Actions. * TEXT_EDITOR Text Editor, Edit scripts and in-file documentation. * CONSOLE Python Console, Interactive programmatic console for advanced editing and script development. * INFO Info, Log of operations, warnings and error messages. * TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings. * STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information. * OUTLINER Outliner, Overview of scene graph and all available data-blocks. * PROPERTIES Properties, Edit properties of active object and related data-blocks. * FILE_BROWSER File Browser, Browse for files and assets. * SPREADSHEET Spreadsheet, Explore geometry data in a table. * PREFERENCES Preferences, Edit persistent configuration settings.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass

    def draw_handler_add(self, callback, args: tuple, region_type: str,
                         draw_type: str) -> 'bpy.context.object':
        ''' Add a new draw handler to this space type. It will be called every time the specified region in the space type will be drawn. Note: All arguments are positional only for now.

        :param callback: A function that will be called when the region is drawn. It gets the specified arguments as input.
        :type callback: 
        :param args: Arguments that will be passed to the callback.
        :type args: tuple
        :param region_type: bpy.types.Region.type )
        :type region_type: str
        :param draw_type: Usually POST_PIXEL for 2D drawing and POST_VIEW for 3D drawing. In some cases PRE_VIEW can be used. BACKDROP can be used for backdrops in the node editor.
        :type draw_type: str
        :rtype: 'bpy.context.object'
        :return: Handler that can be removed later on.
        '''
        pass

    def draw_handler_remove(self, handler: 'bpy.context.object',
                            region_type: str):
        ''' Remove a draw handler that was added previously.

        :param handler: The draw handler that should be removed.
        :type handler: 'bpy.context.object'
        :param region_type: Region type the callback was added to.
        :type region_type: str
        '''
        pass


class SpaceImageOverlay(bpy_struct):
    ''' Settings for display of overlays in the UV/Image editor
    '''

    show_overlays: bool = None
    ''' Display overlays like UV Maps and Metadata

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SpaceNodeEditorPath(bpy_struct):
    ''' Get the node tree path as a string
    '''

    to_string: str = None
    ''' 

    :type: str
    '''

    def clear(self):
        ''' Reset the node tree path

        '''
        pass

    def start(self, node_tree: 'NodeTree'):
        ''' Set the root node tree

        :param node_tree: Node Tree
        :type node_tree: 'NodeTree'
        '''
        pass

    def append(self, node_tree: 'NodeTree', node: 'Node' = None):
        ''' Append a node group tree to the path

        :param node_tree: Node Tree, Node tree to append to the node editor path
        :type node_tree: 'NodeTree'
        :param node: Node, Group node linking to this node tree
        :type node: 'Node'
        '''
        pass

    def pop(self):
        ''' Remove the last node tree from the path

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SpaceUVEditor(bpy_struct):
    ''' UV editor data for the image editor space
    '''

    display_stretch_type: typing.Union[str, int] = None
    ''' Type of stretch to display * ANGLE Angle, Angular distortion between UV and 3D angles. * AREA Area, Area distortion between UV and 3D faces.

    :type: typing.Union[str, int]
    '''

    edge_display_type: typing.Union[str, int] = None
    ''' Display style for UV edges * OUTLINE Outline, Display white edges with black outline. * DASH Dash, Display dashed black-white edges. * BLACK Black, Display black edges. * WHITE White, Display white edges.

    :type: typing.Union[str, int]
    '''

    lock_bounds: bool = None
    ''' Constraint to stay within the image bounds while editing

    :type: bool
    '''

    pixel_snap_mode: typing.Union[str, int] = None
    ''' Snap UVs to pixels while editing * DISABLED Disabled, Don't snap to pixels. * CORNER Corner, Snap to pixel corners. * CENTER Center, Snap to pixel centers.

    :type: typing.Union[str, int]
    '''

    show_faces: bool = None
    ''' Display faces over the image

    :type: bool
    '''

    show_metadata: bool = None
    ''' Display metadata properties of the image

    :type: bool
    '''

    show_modified_edges: bool = None
    ''' Display edges after modifiers are applied

    :type: bool
    '''

    show_pixel_coords: bool = None
    ''' Display UV coordinates in pixels rather than from 0.0 to 1.0

    :type: bool
    '''

    show_stretch: bool = None
    ''' Display faces colored according to the difference in shape between UVs and their 3D coordinates (blue for low distortion, red for high distortion)

    :type: bool
    '''

    show_texpaint: bool = None
    ''' Display overlay of texture paint uv layer

    :type: bool
    '''

    sticky_select_mode: typing.Union[str, int] = None
    ''' Method for extending UV vertex selection * DISABLED Disabled, Sticky vertex selection disabled. * SHARED_LOCATION Shared Location, Select UVs that are at the same location and share a mesh vertex. * SHARED_VERTEX Shared Vertex, Select UVs that share a mesh vertex, whether or not they are at the same location.

    :type: typing.Union[str, int]
    '''

    tile_grid_shape: typing.List[int] = None
    ''' How many tiles will be shown in the background

    :type: typing.List[int]
    '''

    use_live_unwrap: bool = None
    ''' Continuously unwrap the selected UV island while transforming pinned vertices

    :type: bool
    '''

    uv_opacity: float = None
    ''' Opacity of UV overlays

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Spline(bpy_struct):
    ''' Element of a curve, either NURBS, Bezier or Polyline or a character with text objects
    '''

    bezier_points: typing.Union[typing.Dict[str, 'BezierSplinePoint'], typing.
                                List['BezierSplinePoint'],
                                'bpy_prop_collection',
                                'SplineBezierPoints'] = None
    ''' Collection of points for Bezier curves only

    :type: typing.Union[typing.Dict[str, 'BezierSplinePoint'], typing.List['BezierSplinePoint'], 'bpy_prop_collection', 'SplineBezierPoints']
    '''

    character_index: int = None
    ''' Location of this character in the text data (only for text curves)

    :type: int
    '''

    hide: bool = None
    ''' Hide this curve in Edit mode

    :type: bool
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    order_u: int = None
    ''' NURBS order in the U direction (for splines and surfaces, higher values let points influence a greater area)

    :type: int
    '''

    order_v: int = None
    ''' NURBS order in the V direction (for surfaces only, higher values let points influence a greater area)

    :type: int
    '''

    point_count_u: int = None
    ''' Total number points for the curve or surface in the U direction

    :type: int
    '''

    point_count_v: int = None
    ''' Total number points for the surface on the V direction

    :type: int
    '''

    points: typing.Union[typing.Dict[str, 'SplinePoint'], typing.
                         List['SplinePoint'], 'bpy_prop_collection',
                         'SplinePoints'] = None
    ''' Collection of points that make up this poly or nurbs spline

    :type: typing.Union[typing.Dict[str, 'SplinePoint'], typing.List['SplinePoint'], 'bpy_prop_collection', 'SplinePoints']
    '''

    radius_interpolation: typing.Union[str, int] = None
    ''' The type of radius interpolation for Bezier curves

    :type: typing.Union[str, int]
    '''

    resolution_u: int = None
    ''' Curve or Surface subdivisions per segment

    :type: int
    '''

    resolution_v: int = None
    ''' Surface subdivisions per segment

    :type: int
    '''

    tilt_interpolation: typing.Union[str, int] = None
    ''' The type of tilt interpolation for 3D, Bezier curves

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' The interpolation type for this curve element

    :type: typing.Union[str, int]
    '''

    use_bezier_u: bool = None
    ''' Make this nurbs curve or surface act like a Bezier spline in the U direction (Order U must be 3 or 4, Cyclic U must be disabled)

    :type: bool
    '''

    use_bezier_v: bool = None
    ''' Make this nurbs surface act like a Bezier spline in the V direction (Order V must be 3 or 4, Cyclic V must be disabled)

    :type: bool
    '''

    use_cyclic_u: bool = None
    ''' Make this curve or surface a closed loop in the U direction

    :type: bool
    '''

    use_cyclic_v: bool = None
    ''' Make this surface a closed loop in the V direction

    :type: bool
    '''

    use_endpoint_u: bool = None
    ''' Make this nurbs curve or surface meet the endpoints in the U direction (Cyclic U must be disabled)

    :type: bool
    '''

    use_endpoint_v: bool = None
    ''' Make this nurbs surface meet the endpoints in the V direction (Cyclic V must be disabled)

    :type: bool
    '''

    use_smooth: bool = None
    ''' Smooth the normals of the surface or beveled curve

    :type: bool
    '''

    def calc_length(self, resolution: int = 0) -> float:
        ''' Calculate spline length

        :param resolution: Resolution, Spline resolution to be used, 0 defaults to the resolution_u
        :type resolution: int
        :rtype: float
        :return: Length, Length of the polygonaly approximated spline
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SplineBezierPoints(bpy_struct):
    ''' Collection of spline Bezier points
    '''

    def add(self, count: int):
        ''' Add a number of points to this spline

        :param count: Number, Number of points to add to the spline
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SplinePoint(bpy_struct):
    ''' Spline point without handles
    '''

    co: typing.List[float] = None
    ''' Point coordinates

    :type: typing.List[float]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight: float = None
    ''' NURBS weight

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SplinePoints(bpy_struct):
    ''' Collection of spline points
    '''

    def add(self, count: int):
        ''' Add a number of points to this spline

        :param count: Number, Number of points to add to the spline
        :type count: int
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SpreadsheetContext(bpy_struct):
    ''' Element of spreadsheet context path
    '''

    type: typing.Union[str, int] = None
    ''' Type of the context

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class SpreadsheetContextPath(bpy_struct):
    def append(self, type: typing.Union[str, int]) -> 'SpreadsheetContext':
        ''' Append a context path element

        :param type: type
        :type type: typing.Union[str, int]
        :rtype: 'SpreadsheetContext'
        :return: Newly created context path element
        '''
        pass

    def clear(self):
        ''' Clear entire context path

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Stereo3dDisplay(bpy_struct):
    ''' Settings for stereo 3D display
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' * ANAGLYPH Anaglyph, Render views for left and right eyes as two differently filtered colors in a single image (anaglyph glasses are required). * INTERLACE Interlace, Render views for left and right eyes interlaced in a single image (3D-ready monitor is required). * TIMESEQUENTIAL Time Sequential, Render alternate eyes (also known as page flip, quad buffer support in the graphic card is required). * SIDEBYSIDE Side-by-Side, Render views for left and right eyes side-by-side. * TOPBOTTOM Top-Bottom, Render views for left and right eyes one above another.

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice versa

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Stereo3dFormat(bpy_struct):
    ''' Settings for stereo output
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' * ANAGLYPH Anaglyph, Render views for left and right eyes as two differently filtered colors in a single image (anaglyph glasses are required). * INTERLACE Interlace, Render views for left and right eyes interlaced in a single image (3D-ready monitor is required). * SIDEBYSIDE Side-by-Side, Render views for left and right eyes side-by-side. * TOPBOTTOM Top-Bottom, Render views for left and right eyes one above another.

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice versa

    :type: bool
    '''

    use_squeezed_frame: bool = None
    ''' Combine both views in a squeezed image

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class StringAttributeValue(bpy_struct):
    ''' String value in geometry attribute
    '''

    value: str = None
    ''' 

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Struct(bpy_struct):
    ''' RNA structure definition
    '''

    base: 'Struct' = None
    ''' Struct definition this is derived from

    :type: 'Struct'
    '''

    description: str = None
    ''' Description of the Struct's purpose

    :type: str
    '''

    functions: typing.Union[typing.Dict[str, 'Function'], typing.
                            List['Function'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'Function'], typing.List['Function'], 'bpy_prop_collection']
    '''

    identifier: str = None
    ''' Unique name used in the code and scripting

    :type: str
    '''

    name: str = None
    ''' Human readable name

    :type: str
    '''

    name_property: 'StringProperty' = None
    ''' Property that gives the name of the struct

    :type: 'StringProperty'
    '''

    nested: 'Struct' = None
    ''' Struct in which this struct is always nested, and to which it logically belongs

    :type: 'Struct'
    '''

    properties: typing.Union[typing.Dict[str, 'Property'], typing.
                             List['Property'], 'bpy_prop_collection'] = None
    ''' Properties in the struct

    :type: typing.Union[typing.Dict[str, 'Property'], typing.List['Property'], 'bpy_prop_collection']
    '''

    property_tags: typing.Union[typing.Dict[str, 'EnumPropertyItem'], typing.
                                List['EnumPropertyItem'],
                                'bpy_prop_collection'] = None
    ''' Tags that properties can use to influence behavior

    :type: typing.Union[typing.Dict[str, 'EnumPropertyItem'], typing.List['EnumPropertyItem'], 'bpy_prop_collection']
    '''

    translation_context: str = None
    ''' Translation context of the struct's name

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class StudioLight(bpy_struct):
    ''' Studio light
    '''

    has_specular_highlight_pass: bool = None
    ''' Studio light image file has separate "diffuse" and "specular" passes

    :type: bool
    '''

    index: int = None
    ''' 

    :type: int
    '''

    is_user_defined: bool = None
    ''' 

    :type: bool
    '''

    light_ambient: typing.List[float] = None
    ''' Color of the ambient light that uniformly lit the scene

    :type: typing.List[float]
    '''

    name: str = None
    ''' 

    :type: str
    '''

    path: str = None
    ''' 

    :type: str
    '''

    path_irr_cache: str = None
    ''' Path where the irradiance cache is stored

    :type: str
    '''

    path_sh_cache: str = None
    ''' Path where the spherical harmonics cache is stored

    :type: str
    '''

    solid_lights: typing.Union[typing.Dict[str, 'UserSolidLight'], typing.
                               List['UserSolidLight'],
                               'bpy_prop_collection'] = None
    ''' Lights user to display objects in solid draw mode

    :type: typing.Union[typing.Dict[str, 'UserSolidLight'], typing.List['UserSolidLight'], 'bpy_prop_collection']
    '''

    spherical_harmonics_coefficients: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class StudioLights(bpy_struct):
    ''' Collection of studio lights
    '''

    def load(self, path: str, type: typing.Union[str, int]) -> 'StudioLight':
        ''' Load studiolight from file

        :param path: File Path, File path where the studio light file can be found
        :type path: str
        :param type: Type, The type for the new studio light
        :type type: typing.Union[str, int]
        :rtype: 'StudioLight'
        :return: Newly created StudioLight
        '''
        pass

    def new(self, path: str) -> 'StudioLight':
        ''' Create studiolight from default lighting

        :param path: Path, Path to the file that will contain the lighting info (without extension)
        :type path: str
        :rtype: 'StudioLight'
        :return: Newly created StudioLight
        '''
        pass

    def remove(self, studio_light: 'StudioLight'):
        ''' Remove a studio light

        :param studio_light: The studio light to remove
        :type studio_light: 'StudioLight'
        '''
        pass

    def refresh(self):
        ''' Refresh Studio Lights from disk

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TexMapping(bpy_struct):
    ''' Texture coordinate mapping settings
    '''

    mapping: typing.Union[str, int] = None
    ''' * FLAT Flat, Map X and Y coordinates directly. * CUBE Cube, Map using the normal vector. * TUBE Tube, Map with Z as central axis. * SPHERE Sphere, Map with Z as central axis.

    :type: typing.Union[str, int]
    '''

    mapping_x: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_y: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_z: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    max: typing.List[float] = None
    ''' Maximum value for clipping

    :type: typing.List[float]
    '''

    min: typing.List[float] = None
    ''' Minimum value for clipping

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    translation: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    use_max: bool = None
    ''' Whether to use maximum clipping value

    :type: bool
    '''

    use_min: bool = None
    ''' Whether to use minimum clipping value

    :type: bool
    '''

    vector_type: typing.Union[str, int] = None
    ''' Type of vector that the mapping transforms * POINT Point, Transform a point. * TEXTURE Texture, Transform a texture by inverse mapping the texture coordinate. * VECTOR Vector, Transform a direction vector. Location is ignored. * NORMAL Normal, Transform a unit normal vector. Location is ignored.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TexPaintSlot(bpy_struct):
    ''' Slot that contains information about texture painting
    '''

    is_valid: bool = None
    ''' Slot has a valid image and UV map

    :type: bool
    '''

    uv_layer: str = None
    ''' Name of UV map

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TextBox(bpy_struct):
    ''' Text bounding box for layout
    '''

    height: float = None
    ''' 

    :type: float
    '''

    width: float = None
    ''' 

    :type: float
    '''

    x: float = None
    ''' 

    :type: float
    '''

    y: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TextCharacterFormat(bpy_struct):
    ''' Text character formatting settings
    '''

    kerning: int = None
    ''' Spacing between characters

    :type: int
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    use_bold: bool = None
    ''' 

    :type: bool
    '''

    use_italic: bool = None
    ''' 

    :type: bool
    '''

    use_small_caps: bool = None
    ''' 

    :type: bool
    '''

    use_underline: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TextLine(bpy_struct):
    ''' Line of text in a Text data-block
    '''

    body: str = None
    ''' Text in the line

    :type: str
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class TextureSlot(bpy_struct):
    ''' Texture slot defining the mapping and influence of a texture
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to apply the texture

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    ''' Default color for textures that don't return RGB or when RGB to intensity is enabled

    :type: typing.List[float]
    '''

    default_value: float = None
    ''' Value to use for Ref, Spec, Amb, Emit, Alpha, RayMir, TransLu and Hard

    :type: float
    '''

    name: str = None
    ''' Texture slot name

    :type: str
    '''

    offset: typing.List[float] = None
    ''' Fine tune of the texture mapping X, Y and Z locations

    :type: typing.List[float]
    '''

    output_node: typing.Union[str, int] = None
    ''' Which output node to use, for node-based textures

    :type: typing.Union[str, int]
    '''

    scale: typing.List[float] = None
    ''' Set scaling for the texture's X, Y and Z sizes

    :type: typing.List[float]
    '''

    texture: 'Texture' = None
    ''' Texture data-block used by this texture slot

    :type: 'Texture'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class Theme(bpy_struct):
    ''' User interface styling and color settings
    '''

    bone_color_sets: typing.Union[
        typing.Dict[str, 'ThemeBoneColorSet'], typing.
        List['ThemeBoneColorSet'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ThemeBoneColorSet'], typing.List['ThemeBoneColorSet'], 'bpy_prop_collection']
    '''

    clip_editor: 'ThemeClipEditor' = None
    ''' 

    :type: 'ThemeClipEditor'
    '''

    collection_color: typing.Union[
        typing.Dict[str, 'ThemeCollectionColor'], typing.
        List['ThemeCollectionColor'], 'bpy_prop_collection'] = None
    ''' 

    :type: typing.Union[typing.Dict[str, 'ThemeCollectionColor'], typing.List['ThemeCollectionColor'], 'bpy_prop_collection']
    '''

    console: 'ThemeConsole' = None
    ''' 

    :type: 'ThemeConsole'
    '''

    dopesheet_editor: 'ThemeDopeSheet' = None
    ''' 

    :type: 'ThemeDopeSheet'
    '''

    file_browser: 'ThemeFileBrowser' = None
    ''' 

    :type: 'ThemeFileBrowser'
    '''

    graph_editor: 'ThemeGraphEditor' = None
    ''' 

    :type: 'ThemeGraphEditor'
    '''

    image_editor: 'ThemeImageEditor' = None
    ''' 

    :type: 'ThemeImageEditor'
    '''

    info: 'ThemeInfo' = None
    ''' 

    :type: 'ThemeInfo'
    '''

    name: str = None
    ''' Name of the theme

    :type: str
    '''

    nla_editor: 'ThemeNLAEditor' = None
    ''' 

    :type: 'ThemeNLAEditor'
    '''

    node_editor: 'ThemeNodeEditor' = None
    ''' 

    :type: 'ThemeNodeEditor'
    '''

    outliner: 'ThemeOutliner' = None
    ''' 

    :type: 'ThemeOutliner'
    '''

    preferences: 'ThemePreferences' = None
    ''' 

    :type: 'ThemePreferences'
    '''

    properties: 'ThemeProperties' = None
    ''' 

    :type: 'ThemeProperties'
    '''

    sequence_editor: 'ThemeSequenceEditor' = None
    ''' 

    :type: 'ThemeSequenceEditor'
    '''

    spreadsheet: 'ThemeSpreadsheet' = None
    ''' 

    :type: 'ThemeSpreadsheet'
    '''

    statusbar: 'ThemeStatusBar' = None
    ''' 

    :type: 'ThemeStatusBar'
    '''

    text_editor: 'ThemeTextEditor' = None
    ''' 

    :type: 'ThemeTextEditor'
    '''

    theme_area: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    topbar: 'ThemeTopBar' = None
    ''' 

    :type: 'ThemeTopBar'
    '''

    user_interface: 'ThemeUserInterface' = None
    ''' 

    :type: 'ThemeUserInterface'
    '''

    view_3d: 'ThemeView3D' = None
    ''' 

    :type: 'ThemeView3D'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ThemeBoneColorSet(bpy_struct):
    ''' Theme settings for bone color sets
    '''

    active: typing.List[float] = None
    ''' Color used for active bones

    :type: typing.List[float]
    '''

    normal: typing.List[float] = None
    ''' Color used for the surface of bones

    :type: typing.List[float]
    '''

    select: typing.List[float] = None
    ''' Color used for selected bones

    :type: typing.List[float]
    '''

    show_colored_constraints: bool = None
    ''' Allow the use of colors indicating constraints/keyed status

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ThemeClipEditor(bpy_struct):
    ''' Theme settings for the Movie Clip Editor
    '''

    active_marker: typing.List[float] = None
    ''' Color of active marker

    :type: typing.List[float]
    '''

    disabled_marker: typing.List[float] = None
    ''' Color of disabled marker

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_align: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_auto: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_auto_clamped: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_free: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_sel_align: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_sel_auto: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_sel_auto_clamped: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_sel_free: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_vertex: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_vertex_select: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    locked_marker: typing.List[float] = None
    ''' Color of locked marker

    :type: typing.List[float]
    '''

    marker: typing.List[float] = None
    ''' Color of marker

    :type: typing.List[float]
    '''

    marker_outline: typing.List[float] = None
    ''' Color of marker's outline

    :type: typing.List[float]
    '''

    metadatabg: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    metadatatext: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    path_after: typing.List[float] = None
    ''' Color of path after current frame

    :type: typing.List[float]
    '''

    path_before: typing.List[float] = None
    ''' Color of path before current frame

    :type: typing.List[float]
    '''

    path_keyframe_after: typing.List[float] = None
    ''' Color of path after current frame

    :type: typing.List[float]
    '''

    path_keyframe_before: typing.List[float] = None
    ''' Color of path before current frame

    :type: typing.List[float]
    '''

    selected_marker: typing.List[float] = None
    ''' Color of selected marker

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    strips_selected: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    time_marker_line: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    time_marker_line_selected: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ThemeCollectionColor(bpy_struct):
    ''' Theme settings for collection colors
    '''

    color: typing.List[float] = None
    ''' Collection Color Tag

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ThemeConsole(bpy_struct):
    ''' Theme settings for the Console
    '''

    cursor: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    line_error: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    line_info: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    line_input: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    line_output: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    select: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :return: The class or default when not found.
        '''
        pass


class ThemeDopeSheet(bpy_struct):
    ''' Theme settings for the Dope Sheet
    '''

    active_channels_group: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    channel_group: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    channels: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    channels_selected: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    dopesheet_channel: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    dopesheet_subchannel: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    interpolation_line: typing.List[float] = None
    ''' Color of lines showing non-bezier interpolation modes

    :type: typing.List[float]
    '''

    keyframe: typing.List[float] = None
    ''' Color of Keyframe

    :type: typing.List[float]
    '''

    keyframe_border: typing.List[float] = None
    ''' Color of keyframe border

    :type: typing.List[float]
    '''

    keyframe_border_selected: typing.List[float] = None
    ''' Color of selected keyframe border

    :type: typing.List[float]
    '''

    keyframe_breakdown: typing.List[float] = None
    ''' Color of breakdown keyframe

    :type: typing.List[float]
    '''

    keyframe_breakdown_selected: typing.List[float] = None
    ''' Color of selected breakdown keyframe

    :type: typing.List[float]
    '''

    keyframe_extreme: typing.List[float] = None
    ''' Color of extreme keyframe

    :type: typing.List[float]
    '''

    keyframe_extreme_selected: typing.List[float] = None
    ''' Color of selected extreme keyframe

    :type: typing.List[float]
    '''

    keyframe_jitter: typing.List[float] = None
    ''' Color of jitter keyframe

    :type: typing.List[float]
    '''

    keyframe_jitter_selected: typing.List[float] = None
    ''' Color of selected jitter keyframe

    :type: typing.List[float]
    '''

    keyframe_movehold: typing.List[float] = None
    ''' Color of moving hold keyframe

    :type: typing.List[float]
    '''

    keyframe_movehold_selected: typing.List[float] = None
    ''' Color of selected moving hold keyframe

    :type: typing.List[float]
    '''

    keyframe_scale_factor: float = None
    ''' Scale factor for adjusting the height of keyframes

    :type: float
    '''

    keyframe_selected: typing.List[float] = None
    ''' Color of selected keyframe

    :type: typing.List[float]
    '''

    long_key: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    long_key_selected: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    preview_range: typing.List[float] = None
    ''' Color of preview range overlay

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    summary: typing.List[float] = None
    ''' Color of summary channel

    :type: typing.List[float]
    '''

    time_marker_line: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    time_marker_line_selected: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    value_sliders: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    view_sliders: typing.List[float] = None
    ''' 

    :type: typing.List[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: str
        :rtype: 'Struct'
        :return: The RNA type or defaul