try:
    from setuptools import setup
    from setuptools import Extension
except ImportError:
    from distutils.core import setup
    from distutils.extension import Extension

import numpy.distutils.misc_util as mu
import shutil
import os

# copy files to user directory
############################################################################################
usr_local_folder = os.path.join(os.path.expanduser("~"), ".local")
biosig_src_folder = os.path.split(os.path.dirname(os.path.abspath(__file__)))[0]

# /usr/local/lib/pkgconfig/
folder = os.path.join(usr_local_folder, "lib", "pkgconfig")

if not os.path.exists(folder):
    os.makedirs(folder)

shutil.copy(os.path.join(biosig_src_folder, "libbiosig.pc"), folder)

# /usr/local/lib
folder = os.path.join(usr_local_folder, "lib")

if not os.path.exists(folder):
    os.makedirs(folder)

shutil.copy(os.path.join(biosig_src_folder, "libbiosig.a"), folder)
shutil.copy(os.path.join(biosig_src_folder, "libphysicalunits.a"), folder)
shutil.copy(os.path.join(biosig_src_folder, "libbiosig.so.2"), folder)

try:
    os.symlink(os.path.join(folder, "libbiosig.so.2"), os.path.join(folder, "libbiosig2.so"))
    os.symlink(os.path.join(folder, "libbiosig.so.2"), os.path.join(folder, "libbiosig.so"))
except FileExistsError:
    pass

# /usr/local/include
folder = os.path.join(usr_local_folder, "include")

if not os.path.exists(folder):
    os.makedirs(folder)

shutil.copy(os.path.join(biosig_src_folder, "biosig-dev.h"), folder)
shutil.copy(os.path.join(biosig_src_folder, "biosig.h"), folder)
shutil.copy(os.path.join(biosig_src_folder, "biosig2.h"), folder)
shutil.copy(os.path.join(biosig_src_folder, "gdftime.h"), folder)
shutil.copy(os.path.join(biosig_src_folder, "physicalunits.h"), folder)

# /usr/local/bin
folder = os.path.join(usr_local_folder, "bin")

if not os.path.exists(folder):
    os.makedirs(folder)

shutil.copy(os.path.join(biosig_src_folder, "save2gdf"), folder)
shutil.copy(os.path.join(biosig_src_folder, "heka2itx"), folder)
shutil.copy(os.path.join(biosig_src_folder, "save2aecg"), folder)
shutil.copy(os.path.join(biosig_src_folder, "save2scp"), folder)
shutil.copy(os.path.join(biosig_src_folder, "physicalunits"), folder)

# set library paths
############################################################################################
CPATH = os.path.join(usr_local_folder, "include")
LIBS = ['biosig']
LIBDIR = [os.path.join(usr_local_folder, "lib")]

module_biosig = Extension('biosig',
        define_macros=[('MAJOR_VERSION', '1'), ('MINOR_VERSION', '9')],
        include_dirs=[CPATH, mu.get_numpy_include_dirs()[0]],
        libraries=LIBS,
        library_dirs=LIBDIR,
        sources=['biosigmodule.c'])

setup(name='Biosig',
      version='1.9',
      description='This is a biosig package',
      author='Alois Schloegl',
      author_email='alois.schloegl@ist.ac.at',
      license='GPL',
      url='https://biosig.sourceforge.io',
      long_description='''This is the biosig demo package.''',
      keywords='EEG ECG EKG EMG EOG Polysomnography ECoG biomedical signals SCP EDF GDF HEKA CFS ABF',
      install_requires=['numpy', 'pkgconfig', 'setuptools'],
      ext_modules=[module_biosig])
