
evpy is a pyhton library used to predict efficiency in electric power trains given high level component specifications. It can be used to predict motor performance, a motors torque/speed/efficeiency contour, motor size given aspect ratio and torque, losses in an ESC given motor performance, ESC size, a battery’s voltage given time under a load, and battery mass given duration and specific energy.

evpy Functions

evpy.batt_pred(I_load, t_hr, Q_Ah, R_int, n_ser=1, n_prll=1, pkrt=1.2)
predict voltage at a given time under a given load

predict the entire packs instantaneous terminal voltage under load uses empirical state-of-charge curve fit obtained from Chen and Mora https://doi.org/10.1109/TEC.2006.874229

INPUTS:

I_load : float, Amps
    the current draw at the battery terminals

t: float,hours
    the instant in time

Q_Ah: float, Amp*hr
    the rated capacity of the battery unit

R_int: float, Ohms
    the internal resistance of the battery unit in the tens of mili-Ohms range

n_ser: int, non-dim (optional)
    the number of battery units in series

n_prll: int, non-dim (optional)
    the number of battery units in parallel

pkrt: float, non-dim (optional)
    the Peukert constant of the battery

OUTPUTS:

V_term: float, Volts
    the output voltage of the battery

dod: float, non-dim
    the depth of discharge of the battery (percent depleted)

soc: float, non-dim
    the state of charge of the battery (percent remaining)

SPECIAL NOTES:

1. The applied current (I_load) and the time (t) can be vectors (ndarrays) to calculate the entire discharge curve of the battery. However, BOTH inputs must be vectors of the same length!

2. Ensure that the inputs have the correct units! Hobby batteries are rated in mili-Amp*hr This code requires you to enter the capacity in Amp*hr

3. Battery terminology is imprecise. A pack and module may mean different things to different people.

For example, the Thunder Power TP7700-6SR70 is a 7.7 Ah (Amp*hr) unit which consists of 6 cells in series. To model this battery unit, input 7.7 for Q_Ah and set n_ser = 6 If you had 4 of these units wired in series, set n_ser = 4*6 If you had 4 of these units wired in parallel, set n_prll = 4

4. Normally, you should not deplete a lithium-ion battery below 3.5 V In extreme circumstances, you can delpete a li-ion battery down to 3.3 V NEVER deplete a battery below 3 V

evpy.batt_size(t_hr, e, rho=2037.0)
predict battery mass, size for a given duration, specific energy

INPUTS:

t: float, hours
    time duration of mission or mission phase

e: float, Wh/kg
    specific energy (energy/mass) of mission or mission phase

rho: float, kg/m^3 (optional)
    the mass density (mass/volume) of a lipo battery

OUTPUTS:

m: float, kg
    mass of required battery pack

U: float, m^3
    volume of required battery pack

SPECIAL NOTES:

mass density (mass/volume) of typical lipo is ~2000 kg/m^3 or 2 g/cm^3

reasonable usable energy densities:
200 Wh/kg for an extremely well-optimized low-current application 170 Wh/kg for a low-current (fixed-wing) application 140 Wh/kg for a high-current (VTOL) application

evpy.esc_pred(Im, Pm, V, d, f_pwm=8000.0, Ron=0.01, Ton=1e-06)
predict ESC losses given specs and motor performance

INPUTS:

Imn: darray (float), Amps
    the current pulled by the motor

Pm: ndarray (float), Watts
    the power pulled by the motor

V: float, Volts
    the input (DC) voltage to the ESC

d: float, non-dim
    the non-dimensional throttle setting (duty ratio)

f_pwm: float, Hertz
    the switching frequency of the ESC, about 8-32 kHz

Ron: float, Ohms
    the R_ds_ON measure of the MOSFETs in the ESC, about 5-20 mOhms

Ton: float, s (seconds)
    the transition period of the MOSFETs, about 1 microsecond

OUTPUTS:

I_dc: ndarray (float), Amps
    the current draw of the ESC

P_dc:ndarray (float), Watts
    the power draw of the ESC

n: ndarray (float), non-dim
    the efficiency of the ESC

evpy.esc_size(P_req, sf=2.0)
predict esc size, mass given cont. power

predict the esc volume and mass using a purely empirical fit empirical data collected from 3 KDE, Castle, and HobbyWing data nearly uniform trends among all three datasets

P = 36.203m where [P] = Watts, [m] = grams P = 52.280U where [P] = Watts, [U] = cm^3

INPUTS:

P_req: float, Watts
    the required continuous power output of the ESC

sf: float, non-dim (optional)
    a safety factor for the prediction hobby rule of thumb is 2.0

OUTPUTS:

m:float, kg
    the mass of the ESC

U: float, m^3
    the volume of the ESC

evpy.motor_contour(N_rated, T_rated, kt, R, I0, num_pts=100)
roughly predict the motors torque/speed/efficiency contour

predicts motor efficiency within the motors rated operating window uses 3 high-level component parameters (Rm, kt, I0) applicable to sensorless, six-step commutation brushless DC motors DOES NOT factor in harmonics!

Note: kt = kv with SI units

INPUTS:

N_rated: float, rev/min
    rated motor speed

T_rated: float, N.m
    rated motor torque

kt: float, Newton-meter per Amp
    torque constant of motor

Rm: float, Ohms
    motor resistance (phase to phase)

I0: float, Amps
    no-load current of motor

num_pts:int, non-dim
    number of data points along each axis

OUTPUTS:

N: 2D ndarray (float), rev/min
    a 2D array of the motors speed up to N_rated

T: 2D ndarray (float), Newton-meter
    a 2D array of the motors torque up to T_rated

n: 2D ndarray (float), non-dim
    a 2D array of the motors non-dimensional motor efficiency grid is over the entire torque/speed window

evpy.motor_pred(w, V, d, kt, Rm, I0)
predict motor performance for given specs

predict torque, power, current, and efficiency over a range of speed uses 3 high-level component parameters (Rm, kt, I0) and throttle applicable to sensorless, six-step commutation brushless DC motors

Note: kt = kv with SI units

INPUTS:

w: ndarray (float), rads/sec
    range of motor speed

V: float, Volts
    voltage of the DC bus

d: float, non-dim
    non-dimensional throttle setting (duty ratio)

Rmf: loat, Ohms
    motor resistance (phase to phase)

kt: float, Newton-meter per Amp
    torque constant of motor

I0: float, Amps
    no-load current of motor

OUTPUTS:

T: ndarray (float), Newton-meter
    output torque of motor

P_out: ndarray (float), Watts
output power (mechanical)

I: ndarray (float), Amps
    input current to motor

P_in: ndarray (float), Watts
    input power (AC)

n: ndarray (float), non-dim
    non-dimensional motor efficiency

evpy.motor_size(T, x, shear=5500.0)
Size a motor for a given torque, aspect ratio

Predict mass, diameter, length, figure of merit for given torque, D/L Default shear stress is for sub-500 gram BLDC motors

INPUTS:

T: float, N.m
    continuous torque required of motor

x: float, non-dim
    stator aspect ratio (D/L)

shear: float, Pa (N/m^2) - OPTIONAL
    shear stress used to size the initial volume default value of 5.5 kPa is a conservative est.

OUTPUTS:

m_tot: float, kg
    total mass of the motor

U_tot: float, m^3
    total volume of the motor

Do: float, m
    outer motor diameter

Lo: float, m
    outer motor length

km: float, N.m/sqrt(Ohms)
    figure of merit (motor constant) of the motor