#!/usr/bin/python
#
# Copyright 2012 Martin Owens <doctormo@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""
Sample Application using pixmaps
"""

import os
import sys
import logging

sys.path.insert(1, '../../lib')
sys.path.insert(1, './lib')

# Load a Pixmap Manager as well as the normal classes
from gtkme import Window, GtkApp, PixmapManager
from gtkme.pixmap import SizeFilter

image1 = 'raster' # PNG images
image2 = 'vector' # SVG images
image3 = 'gtk-close' # Gnome images
image4 = '\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x01\x00Z\x00Z\x00\x00\xff\xdb\x00C\x00\x0e\t\n\x0c\n\t\x0e\x0c\x0b\x0c\x0f\x0f\x0e\x10\x15"\x16\x15\x13\x13\x15*\x1e \x19"2,441,0/7>OC7:K;/0E^FKRTYYY5Bah`VgOWYU\xff\xdb\x00C\x01\x0f\x0f\x0f\x15\x12\x15(\x16\x16(U909UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU\xff\xc2\x00\x11\x08\x00\x0b\x00\x10\x03\x01\x11\x00\x02\x11\x01\x03\x11\x01\xff\xc4\x00\x17\x00\x00\x03\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x05\xff\xc4\x00\x17\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x02\x00\x04\xff\xda\x00\x0c\x03\x01\x00\x02\x10\x03\x10\x00\x00\x01\xd5\x85JK\x97\x18\x1d\xff\xc4\x00\x19\x10\x01\x00\x03\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x01\x03\x12\x00\x04\xff\xda\x00\x08\x01\x01\x00\x01\x05\x02\xf4\xbe\xab[\xb6\xb2\x9c\x83\x0f\xff\xc4\x00\x1a\x11\x00\x02\x03\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x11\x12"\xff\xda\x00\x08\x01\x03\x01\x01?\x01\xa5\xc5?E\x9c\xe1$\x99\x87\xff\xc4\x00\x1d\x11\x00\x01\x04\x02\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x03\x11\x12!"12\xff\xda\x00\x08\x01\x02\x01\x01?\x01l\xac.\xc6\xd7\x91\xcc\xed\x18\xdb})\xc5\x15\xff\xc4\x00\x1b\x10\x00\x02\x02\x03\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x11!Aaq\xff\xda\x00\x08\x01\x01\x00\x06?\x02J/\xd3u\xd26\x8c#\xff\xc4\x00\x1a\x10\x01\x00\x03\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x11!1Aq\xff\xda\x00\x08\x01\x01\x00\x01?!J\xe5Z\xa3Q\x93\xa5t\xa6\xbb\xdb\xb2\xe4\x07\x93\xff\xda\x00\x0c\x03\x01\x00\x02\x00\x03\x00\x00\x00\x10\x95_\xff\xc4\x00\x19\x11\x00\x03\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x11!AQ\xff\xda\x00\x08\x01\x03\x01\x01?\x10\xf5\xaeQ\xf3r\xf0h\xa9\t\xe1\xff\xc4\x00\x1a\x11\x01\x00\x03\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x11!A\xa1\xf0\xff\xda\x00\x08\x01\x02\x01\x01?\x10\xab5\xd4\x04\xc0S\x94T\xabyC\x04\xf6O\xff\xc4\x00\x1c\x10\x01\x01\x00\x02\x02\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x11\x00!1aQq\xd1\xff\xda\x00\x08\x01\x01\x00\x01?\x10\xd2\xa5\x02\x8e\xb3\xc8q\xa6\xcfu\xc2\x80\r\xc9,:\xc5\x0fD\x9c&\x8f\x99\xff\xd9'

class TestImages(PixmapManager):
    # Where the images are located
    pixmap_dir = './images'
    # Global filters to apply to all images
    filters = [ SizeFilter ]


class PixmapWindow(Window):
    """Pixmap example window."""
    name = 'pixmapapp'

    def load_widgets(self):
        # Create a pixmap manager which controls where the images are
        # This can be made into an ineritied class where pixmap_dir is
        # set much like GtkApp and glade_dir or not.
        pix = TestImages('simple', size=128)

        # We can use the manager directly, or it can be used by lists
        # And other automatic features in gtkme.
        self.widget('image1').set_from_pixbuf(pix.get_pixmap(image1))
        self.widget('image2').set_from_pixbuf(pix.get_pixmap(image2))
        self.widget('image3').set_from_pixbuf(pix.get_pixmap(image3))
        self.widget('image4').set_from_pixbuf(pix.get_pixmap(image4))


class PixmapApp(GtkApp):
    """The application is in charge of loading the glade files, loads
    the windows"""
    glade_dir = './'
    app_name = 'pixmapapp'
    windows = [ PixmapWindow ]


if __name__ == '__main__':
    try:
        app = PixmapApp(start_loop=True)
    except KeyboardInterrupt:
        logging.info("User Interputed")
    logging.debug("Exiting Application")





