# Erutils

The Erutils package includes a collection of utilities and pre-built neural networks that I frequently use in my
personal projects. While this package is mainly for my personal use, others may find it useful as well.

# Installation

You can install Erutils using pip:

```shell
pip install Erutils
````

Open [erfan zare Github](https://github.com/erfanzar/)

Open [Package Github](https://github.com/erfanzar/Erutils)

## 🚀 APIs and Usages

```python
import Erutils
from Erutils.loggers import *
# Loggers contain Logging stuff
from Erutils.nn import *
# NN contain Nural networks built in Pytorch
# you can easily import Erutils.nn and use many prebuilt neurons in the project 
# if you thing any refrence should be added tell me in discussion 
from Erutils.lightning import *
# Lightning Contain Some CV Packages
from Erutils.utils import *
# Utils Contain Some Utils like reading files downloading and etc ...
```

# Neural Networks

Erutils includes a diverse collection of over 80 pre-built neural networks that cover a wide range of applications, such
as natural language processing, computer vision, and more. Some of the neural networks included are:

- Transformers: Customized transformer encoder and decoder layers for natural language processing tasks and a lot of
  customized Layers like RoEmbedding ...
- Feed-forward networks: Customized feed-forward layers for various applications
- Custom CNN backbones: A variety of pre-built CNN backbones for computer vision tasks, such as ResNet, VGG, and more
- Object Detection: Pre-built networks for object detection and localization, including YOLOv5, RetinaNet, and Faster
  R-CNN
- Custom CNN architectures: Custom CNN architectures designed for specific applications, such as image classification,
  segmentation, and more.

## 🚀 About Me

Hi there 👋
I like to train deep neural nets on large datasets 🧠.
Among other things in this world:)

## License

[MIT](https://choosealicense.com/licenses/mit/)

# Contributing

While this package is mainly for my personal use, contributions and suggestions are welcome. If you find a bug or have
an idea for a new feature, please open an issue on the GitHub repository.

## Used By

Private Project

## Author

- [@erfanzar](https://www.github.com/erfanzar)