# Generated by Django 1.9.5 on 2016-06-05 19:25

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("member", "0001_fix161f"),
        ("meal", "0001_fix161f"),
    ]

    operations = [
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("creation_date", models.DateField(verbose_name="creation date")),
                ("delivery_date", models.DateField(verbose_name="delivery date")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("", "Order status"),
                            ("O", "Ordered"),
                            ("D", "Delivered"),
                            ("B", "Billed"),
                            ("P", "Paid"),
                        ],
                        max_length=1,
                        verbose_name="order status",
                    ),
                ),
                (
                    "client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="member.Client",
                        verbose_name="client",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "orders",
            },
        ),
        migrations.CreateModel(
            name="Order_item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        decimal_places=2, max_digits=6, verbose_name="price"
                    ),
                ),
                ("billable_flag", models.BooleanField(verbose_name="billable flag")),
                (
                    "size",
                    models.CharField(
                        choices=[
                            ("", "Serving size"),
                            ("R", "Regular"),
                            ("L", "Large"),
                        ],
                        max_length=1,
                        null=True,
                        verbose_name="size",
                    ),
                ),
                (
                    "order_item_type",
                    models.CharField(
                        choices=[
                            ("", "Order item type"),
                            (
                                "B component",
                                "BILLABLE meal component (main dish, "
                                "vegetable, side dish, seasonal)",
                            ),
                            (
                                "B delivery",
                                "BILLABLE delivery (general store item, ...)",
                            ),
                            (
                                "N delivery",
                                "NON BILLABLE delivery (ex. invitation card, ...)",
                            ),
                            ("N pickup", "NON BILLABLE pickup (payment)"),
                        ],
                        max_length=20,
                        verbose_name="order item type",
                    ),
                ),
                ("remark", models.CharField(max_length=256, verbose_name="remark")),
                (
                    "component",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="meal.Component",
                        verbose_name="component",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="order.Order",
                        verbose_name="order",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "order items",
            },
        ),
    ]
