#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
   @project: HSPyLib
   @package: hspylib.main.hspylib.modules.cli.icons.font_awesome
      @file: form_icons.py
   @created: Tue, 4 May 2021
    @author: <B>H</B>ugo <B>S</B>aporetti <B>J</B>unior"
      @site: https://github.com/yorevs/hspylib
   @license: MIT - Please refer to <https://opensource.org/licenses/MIT>

   Copyright 2021, HSPyLib team
"""

from hspylib.modules.cli.icons.font_awesome.awesome import Awesome


class FormIcons(Awesome):
    """
        Form UI icons.
        Codes can be found here:
        - https://fontawesome.com/cheatsheet?from=io
    """

    # @formatter:off
    ARROW_LEFT = u'\uF060'     # 
    ARROW_RIGHT = u'\uF061'    # 
    ARROW_UP = u'\uF062'       # 
    ARROW_DOWN = u'\uF063'     # 
    SELECTOR = u'\uFC32'       # ﰲ

    CHECK = u'\uF00C'          # 
    ERROR = u'\uf057'          # 
    CHECK_CIRCLE = u'\uF058'   # 
    UNCHECK_CIRCLE = u'\uF111' # 
    CHECK_SQUARE = u'\uF14A'   # 
    UNCHECK_SQUARE = u'\uF0C8' # 
    ON = u'\uF205'             # 
    OFF = u'\uF204'            # 
    MARKED = u'\uF634'         # 
    UNMARKED = u'\uF630'       # 
    CLEAR = u'\uF5E1'          # 
    REFRESH = u'\uF01E'        # 

    HIDDEN = u'\uF070'         # 
    VISIBLE = u'\uF06E'        # 
    LOCKED = u'\uF023'         # 
    UNLOCKED = u'\uF09C'       # 
    EDITABLE = u'\uF044'       # 
    MASKED = u'\uF0CE'         # 
    SELECTABLE = u'\uF150'     # 
    DESELECT = u'\uF657'       # 
    DELETE = u'\uF014'         # 
    EDIT = u'\uF040'           # 
    PLUS = u'\uF067'           # 
    MINUS = u'\uF068'          # 
    # @formatter:on
