/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.1.1
 *
 *     
 */

#include "sipAPI_core.h"

        #include <wx/vscroll.h>

        #include <wx/window.h>


PyDoc_STRVAR(doc_wxVarScrollHelperBase_CalcScrolledPosition, "CalcScrolledPosition(coord) -> int\n"
"\n"
"Translates the logical coordinate given to the current device\n"
"coordinate.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_CalcScrolledPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_CalcScrolledPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CalcScrolledPosition(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_CalcScrolledPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_CalcUnscrolledPosition, "CalcUnscrolledPosition(coord) -> int\n"
"\n"
"Translates the device coordinate given to the corresponding logical\n"
"coordinate.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_CalcUnscrolledPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_CalcUnscrolledPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CalcUnscrolledPosition(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_CalcUnscrolledPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_EnablePhysicalScrolling, "EnablePhysicalScrolling(scrolling=True)\n"
"\n"
"With physical scrolling on (when this is true), the device origin is\n"
"changed properly when a wxPaintDC is prepared, children are actually\n"
"moved and laid out properly, and the contents of the window (pixels)\n"
"are actually moved.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_EnablePhysicalScrolling(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_EnablePhysicalScrolling(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool scrolling = 1;
         ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_scrolling,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &scrolling))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnablePhysicalScrolling(scrolling);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_EnablePhysicalScrolling, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetNonOrientationTargetSize, "GetNonOrientationTargetSize() -> int\n"
"\n"
"This function needs to be overridden in the in the derived class to\n"
"return the window size with respect to the opposing orientation.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetNonOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetNonOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetNonOrientationTargetSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNonOrientationTargetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetNonOrientationTargetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetOrientation, "GetOrientation() -> Orientation\n"
"\n"
"This function need to be overridden to return the orientation that\n"
"this helper is working with, either wxHORIZONTAL or wxVERTICAL.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::wxOrientation sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetOrientation);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOrientation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOrientation);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetOrientation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetOrientationTargetSize, "GetOrientationTargetSize() -> int\n"
"\n"
"This function needs to be overridden in the in the derived class to\n"
"return the window size with respect to the orientation this helper is\n"
"working with.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetOrientationTargetSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOrientationTargetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetOrientationTargetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetTargetWindow, "GetTargetWindow() -> Window\n"
"\n"
"This function will return the target window this helper class is\n"
"currently scrolling.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetTargetWindow(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetTargetWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTargetWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetTargetWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetVisibleBegin, "GetVisibleBegin() -> size_t\n"
"\n"
"Returns the index of the first visible unit based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetVisibleBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetVisibleBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleBegin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetVisibleBegin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetVisibleEnd, "GetVisibleEnd() -> size_t\n"
"\n"
"Returns the index of the last visible unit based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetVisibleEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetVisibleEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleEnd();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetVisibleEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_IsVisible, "IsVisible(unit) -> bool\n"
"\n"
"Returns true if the given scroll unit is currently visible (even if\n"
"only partially visible) or false otherwise.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_IsVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_IsVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t unit;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &unit))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsVisible(unit);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_IsVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_RefreshAll, "RefreshAll()\n"
"\n"
"Recalculate all parameters and repaint all units.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_RefreshAll(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_RefreshAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RefreshAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_RefreshAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_SetTargetWindow, "SetTargetWindow(target)\n"
"\n"
"Normally the window will scroll itself, but in some rare occasions you\n"
"might want it to scroll (part of) another window (e.g.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_SetTargetWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_SetTargetWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* target;
         ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_target,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, sipType_wxWindow, &target))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTargetWindow(target);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_SetTargetWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_UpdateScrollbar, "UpdateScrollbar()\n"
"\n"
"Update the thumb size shown by the scrollbar.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_UpdateScrollbar(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_UpdateScrollbar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UpdateScrollbar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_UpdateScrollbar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_VirtualHitTest, "VirtualHitTest(coord) -> int\n"
"\n"
"Returns the virtual scroll unit under the device unit given accounting\n"
"for scroll position or wxNOT_FOUND if none (i.e.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_VirtualHitTest(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_VirtualHitTest(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCoord coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->VirtualHitTest(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_VirtualHitTest, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarScrollHelperBase(void *, int);}
static void release_wxVarScrollHelperBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxVarScrollHelperBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarScrollHelperBase(sipSimpleWrapper *);}
static void dealloc_wxVarScrollHelperBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarScrollHelperBase(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxVarScrollHelperBase[] = {
    {sipName_CalcScrolledPosition, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_CalcScrolledPosition), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_CalcScrolledPosition},
    {sipName_CalcUnscrolledPosition, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_CalcUnscrolledPosition), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_CalcUnscrolledPosition},
    {sipName_EnablePhysicalScrolling, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_EnablePhysicalScrolling), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_EnablePhysicalScrolling},
    {sipName_GetNonOrientationTargetSize, meth_wxVarScrollHelperBase_GetNonOrientationTargetSize, METH_VARARGS, doc_wxVarScrollHelperBase_GetNonOrientationTargetSize},
    {sipName_GetOrientation, meth_wxVarScrollHelperBase_GetOrientation, METH_VARARGS, doc_wxVarScrollHelperBase_GetOrientation},
    {sipName_GetOrientationTargetSize, meth_wxVarScrollHelperBase_GetOrientationTargetSize, METH_VARARGS, doc_wxVarScrollHelperBase_GetOrientationTargetSize},
    {sipName_GetTargetWindow, meth_wxVarScrollHelperBase_GetTargetWindow, METH_VARARGS, doc_wxVarScrollHelperBase_GetTargetWindow},
    {sipName_GetVisibleBegin, meth_wxVarScrollHelperBase_GetVisibleBegin, METH_VARARGS, doc_wxVarScrollHelperBase_GetVisibleBegin},
    {sipName_GetVisibleEnd, meth_wxVarScrollHelperBase_GetVisibleEnd, METH_VARARGS, doc_wxVarScrollHelperBase_GetVisibleEnd},
    {sipName_IsVisible, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_IsVisible), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_IsVisible},
    {sipName_RefreshAll, meth_wxVarScrollHelperBase_RefreshAll, METH_VARARGS, doc_wxVarScrollHelperBase_RefreshAll},
    {sipName_SetTargetWindow, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_SetTargetWindow), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_SetTargetWindow},
    {sipName_UpdateScrollbar, meth_wxVarScrollHelperBase_UpdateScrollbar, METH_VARARGS, doc_wxVarScrollHelperBase_UpdateScrollbar},
    {sipName_VirtualHitTest, SIP_MLMETH_CAST(meth_wxVarScrollHelperBase_VirtualHitTest), METH_VARARGS|METH_KEYWORDS, doc_wxVarScrollHelperBase_VirtualHitTest}
};

sipVariableDef variables_wxVarScrollHelperBase[] = {
    {PropertyVariable, sipName_VisibleEnd, &methods_wxVarScrollHelperBase[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VisibleBegin, &methods_wxVarScrollHelperBase[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TargetWindow, &methods_wxVarScrollHelperBase[6], &methods_wxVarScrollHelperBase[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OrientationTargetSize, &methods_wxVarScrollHelperBase[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Orientation, &methods_wxVarScrollHelperBase[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NonOrientationTargetSize, &methods_wxVarScrollHelperBase[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVarScrollHelperBase, "VarScrollHelperBase(winToScroll)\n"
"\n"
"This class provides all common base functionality for scroll\n"
"calculations shared among all variable scrolled window implementations\n"
"as well as automatic scrollbar functionality, saved scroll positions,\n"
"controlling target windows to be scrolled, as well as defining all\n"
"required virtual functions that need to be implemented for any\n"
"orientation specific work.");


sipClassTypeDef sipTypeDef__core_wxVarScrollHelperBase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarScrollHelperBase,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_VarScrollHelperBase,
        {0, 0, 1},
        14, methods_wxVarScrollHelperBase,
        0, SIP_NULLPTR,
        6, variables_wxVarScrollHelperBase,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVarScrollHelperBase,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVarScrollHelperBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxVarScrollHelperBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
