import unittest
import timeout_decorator
from gradescope_utils.autograder_utils.decorators import weight
import pydrake.symbolic as ps
import numpy as np


class TestDifferentialIK(unittest.TestCase):

    def __init__(self, test_name, notebook_locals):
        super().__init__(test_name)
        self.notebook_locals = notebook_locals

    @weight(4)
    @timeout_decorator.timeout(1.)
    def test_diffik_qp(self):
        """Test DiffIKQP"""
        f = self.notebook_locals["DiffIKQP"]

        # Test 1. Test normal solutions for reasonable values of Jacobians

        V_G_desired = np.array([0., 0., 0., 0.1, 0., 0.])

        J_G_lst = np.array([  # noqa
            [[
                0.00000000e+00, 9.99999683e-01, 7.95000163e-05, -9.99999683e-01,
                7.67307120e-04, 9.99999683e-01, 1.90520631e-04
            ],
             [
                 0.00000000e+00, 7.96326711e-04, -9.98333850e-02,
                 -7.96326710e-04, -9.63557880e-01, 7.96326710e-04,
                 -2.39249253e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.95004165e-01, 8.20340237e-14,
                 2.67498829e-01, -3.28312328e-13, -9.70958165e-01
             ],
             [
                 4.71358790e-01, 2.51255875e-04, 4.37504671e-01, 6.52873081e-05,
                 1.94417004e-01, -1.50387385e-04, 1.38777878e-17
             ],
             [
                 3.75355714e-04, -3.15518483e-01, 3.48396766e-04,
                 -8.19855551e-02, 1.54819502e-04, 1.88851303e-01, 3.38813179e-21
             ],
             [
                 0.00000000e+00, -4.71358940e-01, -4.08400527e-14,
                 4.31475490e-01, -6.37160951e-14, -4.65339945e-02,
                 2.54109884e-21
             ]],
            [[
                0.00000000e+00, 4.97453357e-01, 7.37659375e-01, -4.08628916e-01,
                7.50527674e-01, 5.79061420e-01, 2.22131042e-02
            ],
             [
                 0.00000000e+00, 8.67490725e-01, -4.23002946e-01,
                 -9.00161261e-01, -4.25405400e-01, 7.92090785e-01,
                 -2.52066306e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 5.26238685e-01,
                 -1.50771726e-01, 5.05705899e-01, -1.93080452e-01,
                 -9.67454989e-01
             ],
             [
                 3.87966031e-01, 1.94397615e-01, 1.09371214e-01,
                 -4.54912382e-02, 1.04841723e-01, -1.58513855e-01,
                 3.46944695e-18
             ],
             [
                 5.98851175e-01, -1.11475251e-01, 1.49835189e-01,
                 -4.01947664e-02, 1.43411665e-01, 1.08127790e-01, 4.25007252e-17
             ],
             [
                 0.00000000e+00, -7.12492844e-01, -3.28709685e-02,
                 3.63269748e-01, -3.49581004e-02, -3.18117719e-02,
                 -1.10588622e-17
             ]],
            [[
                0.00000000e+00, 9.74782421e-01, 3.69240704e-02, -9.34937086e-01,
                3.34461505e-01, 9.42240299e-01, 3.35035233e-04
            ],
             [
                 0.00000000e+00, 2.23157415e-01, -1.61289441e-01,
                 -3.54073619e-01, -9.01018081e-01, 3.25266889e-01,
                 -2.39479392e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.86216168e-01,
                 -2.29023353e-02, 2.76228022e-01, -7.99041325e-02,
                 -9.70901390e-01
             ],
             [
                 4.70970597e-01, 7.04075330e-02, 4.13591009e-01, 1.84796445e-02,
                 1.83014897e-01, -6.51453375e-02, -3.12250226e-17
             ],
             [
                 1.48433702e-01, -3.07549832e-01, 1.34737946e-01,
                 -7.64422604e-02, 6.31778180e-02, 1.77927753e-01, 8.40256684e-19
             ],
             [
                 0.00000000e+00, -4.92217940e-01, 6.55063738e-03,
                 4.27418542e-01, -1.55200818e-02, -4.39095634e-02,
                 -2.18534500e-19
             ]],
            [[
                0.00000000e+00, 7.98446597e-01, 3.15321131e-01, -6.62661374e-01,
                6.45977678e-01, 7.45890228e-01, 2.74754034e-05
            ],
             [
                 0.00000000e+00, 6.02065637e-01, -4.18172153e-01,
                 -7.39600762e-01, -6.44033569e-01, 6.46713273e-01,
                 -2.39350814e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 8.51882994e-01,
                 -1.17773579e-01, 4.09797025e-01, -1.59404233e-01,
                 -9.70933153e-01
             ],
             [
                 4.70904919e-01, 1.89767879e-01, 2.69350259e-01,
                 -1.71968500e-02, 1.40701066e-01, -1.29550399e-01,
                 3.46944695e-17
             ],
             [
                 3.84044218e-01, -2.51666111e-01, 2.27773199e-01,
                 -4.70486255e-02, 1.21992812e-01, 1.40857906e-01, 2.53038387e-17
             ],
             [
                 0.00000000e+00, -6.07212257e-01, 1.21103260e-02,
                 3.92217743e-01, -3.00692309e-02, -3.47274308e-02,
                 -6.23691535e-18
             ]]
        ])

        f_target = np.array([  # noqa
            [
                1.47631586e-01, 2.06366540e-04, 1.00129570e-01, 2.30547165e-04,
                -6.88923065e-02, 2.48616643e-05, 2.35676793e-01
            ],
            [
                0.38596089, 1.53133723, -0.19923443, 3., -0.20405068,
                1.33040063, -0.55120997
            ],
            [
                0.15947483, 0.08994902, 0.08027644, 0.1029732, -0.07840078,
                0.03372544, 0.21828697
            ],
            [
                0.20038532, 0.26725546, -0.01429805, 0.42264376, -0.08539295,
                0.16939299, 0.07872099
            ]
        ])

        f_eval = []
        for i in range(4):
            f_eval.append(f(J_G_lst[i], V_G_desired, None, None, None))
        f_eval = np.array(f_eval).squeeze()

        self.assertLessEqual(np.linalg.norm(f_target - np.stack(f_eval)), 1e-3,
                             'DiffIKQP input-output response is not correct')

    @weight(6)
    @timeout_decorator.timeout(1.)
    def test_diffik_wall(self):
        """Test DiffIK_Wall"""
        f = self.notebook_locals["DiffIKQP_Wall"]

        # 1. First, test input-output responses

        V_G_desired = np.array([0., 0., 0., 0.1, 0.05, 0.])

        J_G_lst = np.array([  # noqa
            [[
                0.00000000e+00, 9.99999683e-01, 7.95000163e-05, -9.99999683e-01,
                7.67307120e-04, 9.99999683e-01, 1.90520631e-04
            ],
             [
                 0.00000000e+00, 7.96326711e-04, -9.98333850e-02,
                 -7.96326710e-04, -9.63557880e-01, 7.96326710e-04,
                 -2.39249253e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.95004165e-01, 8.20340237e-14,
                 2.67498829e-01, -3.28312328e-13, -9.70958165e-01
             ],
             [
                 4.71358790e-01, 2.51255875e-04, 4.37504671e-01, 6.52873081e-05,
                 1.94417004e-01, -1.50387385e-04, 1.38777878e-17
             ],
             [
                 3.75355714e-04, -3.15518483e-01, 3.48396766e-04,
                 -8.19855551e-02, 1.54819502e-04, 1.88851303e-01, 3.38813179e-21
             ],
             [
                 0.00000000e+00, -4.71358940e-01, -4.08400527e-14,
                 4.31475490e-01, -6.37160951e-14, -4.65339945e-02,
                 2.54109884e-21
             ]],
            [[
                0.00000000e+00, 9.99934201e-01, 1.03932848e-03, -9.99824180e-01,
                1.78851186e-02, 9.99839831e-01, 1.53754077e-04
            ],
             [
                 0.00000000e+00, 1.14714037e-02, -9.05957219e-02,
                 -1.87395783e-02, -9.63643428e-01, 1.74135560e-02,
                 -2.39271323e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.95887210e-01,
                 -6.61299658e-04, 2.66592321e-01, -4.13288412e-03,
                 -9.70952733e-01
             ],
             [
                 4.67706813e-01, 3.61934563e-03, 4.37199353e-01, 1.25778201e-03,
                 1.94391103e-01, -3.48089267e-03, 3.46944695e-18
             ],
             [
                 7.59022178e-03, -3.15489506e-01, 7.23108598e-03,
                 -8.23369412e-02, 3.38558262e-03, 1.88819935e-01,
                 -8.80914265e-20
             ],
             [
                 0.00000000e+00, -4.67763109e-01, 2.01540608e-04,
                 4.31572410e-01, -8.03524601e-04, -4.65313391e-02,
                 2.28698896e-20
             ]],
            [[
                0.00000000e+00, 9.39166194e-01, 2.92071720e-03, -7.74965588e-01,
                6.09266999e-01, 7.91606441e-01, 1.97485157e-04
            ],
             [
                 0.00000000e+00, 3.43463040e-01, -7.98641641e-03,
                 -6.31997299e-01, -7.48249748e-01, 5.93297111e-01,
                 -2.39422762e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.99963843e-01,
                 -2.78403895e-03, 2.62518645e-01, -1.46143015e-01,
                 -9.70915394e-01
             ],
             [
                 3.48684075e-01, 1.08369015e-01, 3.46151604e-01, 5.21049523e-02,
                 1.53526657e-01, -1.18845581e-01, -2.08166817e-17
             ],
             [
                 2.44607403e-01, -2.96324506e-01, 2.43677018e-01,
                 -6.57491639e-02, 1.15065918e-01, 1.49483756e-01, 1.18381325e-17
             ],
             [
                 0.00000000e+00, -4.11485898e-01, 9.35129006e-04,
                 4.21599362e-01, -2.83434385e-02, -3.68861019e-02,
                 -2.92226367e-18
             ]],
            [[
                0.00000000e+00, 9.99988912e-01, 1.81978750e-03, -6.60517282e-01,
                7.47740850e-01, 6.47526343e-01, 1.89385314e-03
            ],
             [
                 0.00000000e+00, -4.70908297e-03, 3.86437728e-01,
                 -6.92018888e-01, -5.71262736e-01, 7.40167706e-01,
                 -2.39445388e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.22313705e-01, 2.91250370e-01,
                 3.38441290e-01, -1.81277141e-01, -9.70907987e-01
             ],
             [
                 1.20409719e-01, -1.48256067e-03, 2.32717730e-01,
                 1.17149107e-01, 1.23640102e-01, -1.48216919e-01, 1.38777878e-17
             ],
             [
                 2.99817829e-01, -3.14826526e-01, 2.75953169e-01,
                 5.16839258e-02, 1.41329248e-01, 1.22213139e-01, -1.65340831e-17
             ],
             [
                 0.00000000e+00, -1.18996517e-01, -1.16080041e-01,
                 3.88481095e-01, -3.46134554e-02, -3.04293238e-02,
                 4.10641573e-18
             ]]
        ])

        p_now_lst = np.array([  # noqa
            [3.75355714e-04, -4.71358790e-01, 6.56018583e-01],
            [0.00759022, -0.46770681, 0.65601027],
            [0.2446074, -0.34868407, 0.65601871],
            [0.29981783, -0.12040972, 0.65533002]
        ])

        f_target = np.array([  # noqa
            [
                0.14768965, -0.12918498, 0.10016887, -0.14257137, -0.06892025,
                -0.01338681, 0.23576927
            ],
            [
                0.14671504, -0.1242132, 0.10333624, -0.1359548, -0.06797921,
                -0.01065627, 0.23856731
            ],
            [
                0.15763182, 0.06423543, 0.15208706, 0.06085556, -0.08078821,
                0.0449127, 0.29021263
            ],
            [
                -0.03471697, 0.0056838, 0.18962574, 0.06277342, 0.02132107,
                0.02960452, 0.1651197
            ]
        ])

        f_eval = []
        for i in range(4):
            f_eval.append(f(J_G_lst[i], V_G_desired, None, None, p_now_lst[i]))
        f_eval = np.array(f_eval).squeeze()

        self.assertLessEqual(np.linalg.norm(f_target - np.stack(f_eval)), 1e-3,
                             'DiffIKQP_Wall implementation is not correct.')

        # 2. Check that it cannot find solutions when it shouldn't.

        J_G_lst = np.array([  # noqa
            [[
                0.00000000e+00, 7.56140097e-01, 7.95003347e-02, -2.69315694e-01,
                9.22433312e-01, 3.40078094e-01, -1.92820603e-05
            ],
             [
                 0.00000000e+00, 6.54409775e-01, -9.18589440e-02,
                 -9.60694986e-01, -2.77417540e-01, 9.13139558e-01,
                 -2.39012765e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.92593387e-01,
                 -6.73364743e-02, 2.68619236e-01, -2.24773302e-01,
                 -9.71016425e-01
             ],
             [
                 1.94013938e-01, 2.06133679e-01, 1.63642143e-01, 6.77508889e-02,
                 6.48813906e-02, -1.82907255e-01, 6.93889390e-18
             ],
             [
                 4.00268741e-01, -2.38177891e-01, 3.72262156e-01,
                 -4.67765625e-02, 1.74212234e-01, 6.42289082e-02, 2.29588280e-18
             ],
             [
                 0.00000000e+00, -4.08641495e-01, 2.13440909e-02,
                 3.96391877e-01, -4.28831043e-02, -1.58061200e-02,
                 -5.65182734e-19
             ]],
            [[
                0.00000000e+00, 7.04496306e-01, 4.81943519e-02, -1.32316836e-01,
                9.54820295e-01, 2.02297436e-01, 1.58427835e-04
            ],
             [
                 0.00000000e+00, 7.09707654e-01, -4.78404632e-02,
                 -9.90355134e-01, -1.38480772e-01, 9.51023104e-01,
                 -2.38698757e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.97691633e-01,
                 -4.10969911e-02, 2.62947294e-01, -2.33732332e-01,
                 -9.71093651e-01
             ],
             [
                 1.20862242e-01, 2.23378736e-01, 1.05525579e-01, 7.88401213e-02,
                 3.83637616e-02, -1.90478540e-01, -6.93889390e-18
             ],
             [
                 4.00735166e-01, -2.21738477e-01, 3.84641068e-01,
                 -2.67698990e-02, 1.80352378e-01, 3.82022752e-02,
                 -1.35491390e-17
             ],
             [
                 0.00000000e+00, -3.69551817e-01, 1.33464785e-02,
                 3.91265419e-01, -4.43250870e-02, -9.42134952e-03,
                 3.32883948e-18
             ]],
            [[
                0.00000000e+00, 8.48951983e-01, 7.32092662e-02, -4.98413754e-01,
                8.24557735e-01, 5.52633268e-01, 3.41100634e-04
            ],
             [
                 0.00000000e+00, 5.28469991e-01, -1.17605830e-01,
                 -8.64437917e-01, -4.96124324e-01, 8.09261086e-01,
                 -2.39270556e-01
             ],
             [
                 1.00000000e+00, 1.29333461e-17, 9.90358153e-01,
                 -6.58089530e-02, 2.71965434e-01, -1.99230933e-01,
                 -9.70952874e-01
             ],
             [
                 2.91723319e-01, 1.66704769e-01, 2.51812051e-01, 5.32219754e-02,
                 1.06350005e-01, -1.62101060e-01, 1.73472348e-17
             ],
             [
                 3.58724261e-01, -2.67800153e-01, 3.32171785e-01,
                 -6.16554014e-02, 1.55736047e-01, 1.04351760e-01, 4.28259858e-18
             ],
             [
                 0.00000000e+00, -4.37234097e-01, 2.08312142e-02,
                 4.06794227e-01, -3.83404546e-02, -2.57722048e-02,
                 -1.05032085e-18
             ]]
        ])

        p_now_lst = np.array([[0.40026874, -0.19401394, 0.65549175],
                              [0.40073517, -0.12086224, 0.65524754],
                              [0.35872426, -0.29172332, 0.65594794]])

        for i in range(3):
            with self.assertRaises(ValueError):
                f(J_G_lst[i], V_G_desired, None, None, p_now_lst[i])
