"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""

try:
    import cStringIO.StringIO as BytesIO
except ImportError:
    from io import BytesIO
import struct

import drake.lcmt_header

class lcmt_image(object):
    __slots__ = ["header", "width", "height", "row_stride", "size", "data", "bigendian", "pixel_format", "channel_type", "compression_method"]

    __typenames__ = ["drake.lcmt_header", "int32_t", "int32_t", "int32_t", "int32_t", "byte", "boolean", "int8_t", "int8_t", "int8_t"]

    __dimensions__ = [None, None, None, None, None, ["size"], None, None, None, None]

    PIXEL_FORMAT_GRAY = 0
    PIXEL_FORMAT_RGB = 1
    PIXEL_FORMAT_BGR = 2
    PIXEL_FORMAT_RGBA = 3
    PIXEL_FORMAT_BGRA = 4
    PIXEL_FORMAT_DEPTH = 5
    PIXEL_FORMAT_LABEL = 6
    PIXEL_FORMAT_MASK = 7
    PIXEL_FORMAT_DISPARITY = 8
    PIXEL_FORMAT_BAYER_BGGR = 9
    PIXEL_FORMAT_BAYER_RGGB = 10
    PIXEL_FORMAT_BAYER_GBRG = 11
    PIXEL_FORMAT_BAYER_GRBG = 12
    PIXEL_FORMAT_INVALID = -1
    CHANNEL_TYPE_INT8 = 0
    CHANNEL_TYPE_UINT8 = 1
    CHANNEL_TYPE_INT16 = 2
    CHANNEL_TYPE_UINT16 = 3
    CHANNEL_TYPE_INT32 = 4
    CHANNEL_TYPE_UINT32 = 5
    CHANNEL_TYPE_FLOAT32 = 6
    CHANNEL_TYPE_FLOAT64 = 7
    CHANNEL_TYPE_INVALID = -1
    COMPRESSION_METHOD_NOT_COMPRESSED = 0
    COMPRESSION_METHOD_ZLIB = 1
    COMPRESSION_METHOD_JPEG = 2
    COMPRESSION_METHOD_PNG = 3
    COMPRESSION_METHOD_INVALID = -1

    def __init__(self):
        self.header = drake.lcmt_header()
        self.width = 0
        self.height = 0
        self.row_stride = 0
        self.size = 0
        self.data = b""
        self.bigendian = False
        self.pixel_format = 0
        self.channel_type = 0
        self.compression_method = 0

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_image._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        assert self.header._get_packed_fingerprint() == drake.lcmt_header._get_packed_fingerprint()
        self.header._encode_one(buf)
        buf.write(struct.pack(">iiii", self.width, self.height, self.row_stride, self.size))
        buf.write(bytearray(self.data[:self.size]))
        buf.write(struct.pack(">bbbb", self.bigendian, self.pixel_format, self.channel_type, self.compression_method))

    def decode(data):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_image._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_image._decode_one(buf)
    decode = staticmethod(decode)

    def _decode_one(buf):
        self = lcmt_image()
        self.header = drake.lcmt_header._decode_one(buf)
        self.width, self.height, self.row_stride, self.size = struct.unpack(">iiii", buf.read(16))
        self.data = buf.read(self.size)
        self.bigendian = bool(struct.unpack('b', buf.read(1))[0])
        self.pixel_format, self.channel_type, self.compression_method = struct.unpack(">bbb", buf.read(3))
        return self
    _decode_one = staticmethod(_decode_one)

    def _get_hash_recursive(parents):
        if lcmt_image in parents: return 0
        newparents = parents + [lcmt_image]
        tmphash = (0xcc69e8044fc49594+ drake.lcmt_header._get_hash_recursive(newparents)) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _get_hash_recursive = staticmethod(_get_hash_recursive)
    _packed_fingerprint = None

    def _get_packed_fingerprint():
        if lcmt_image._packed_fingerprint is None:
            lcmt_image._packed_fingerprint = struct.pack(">Q", lcmt_image._get_hash_recursive([]))
        return lcmt_image._packed_fingerprint
    _get_packed_fingerprint = staticmethod(_get_packed_fingerprint)

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_image._get_packed_fingerprint())[0]

