# pollination-sdk
Pollination Server OpenAPI Definition

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.13.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pollination.cloud](https://pollination.cloud)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pollination_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pollination_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pollination_sdk
from pollination_sdk.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Create an instance of the API class
api_instance = pollination_sdk.UsersApi(pollination_sdk.ApiClient(configuration))
search = 'search_example' # str | Search string to find users (optional)
page = 1 # int | Page number starting from 1 (optional) (default to 1)
per_page = 25 # int | Number of items per page (optional) (default to 25)

try:
    # List Users
    api_response = api_instance.list_users(search=search, page=page, per_page=per_page)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling UsersApi->list_users: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APITokensApi* | [**create_token**](https://github.com/pollination/python-sdk/blob/master/docs/APITokensApi.md#create_token) | **POST** /tokens | Create a new API token
*APITokensApi* | [**delete_token**](https://github.com/pollination/python-sdk/blob/master/docs/APITokensApi.md#delete_token) | **DELETE** /tokens/{token_id} | Delete an API Token
*APITokensApi* | [**list_tokens**](https://github.com/pollination/python-sdk/blob/master/docs/APITokensApi.md#list_tokens) | **GET** /tokens | List user API tokens
*APITokensApi* | [**regenerate_token**](https://github.com/pollination/python-sdk/blob/master/docs/APITokensApi.md#regenerate_token) | **PUT** /tokens/{token_id} | Regenerate an API token
*AccountsApi* | [**get_account**](https://github.com/pollination/python-sdk/blob/master/docs/AccountsApi.md#get_account) | **GET** /accounts/{name} | Get an account by name
*AccountsApi* | [**list_accounts**](https://github.com/pollination/python-sdk/blob/master/docs/AccountsApi.md#list_accounts) | **GET** /accounts | List Accounts on the Pollination platform
*ArtifactsApi* | [**create_artifact**](https://github.com/pollination/python-sdk/blob/master/docs/ArtifactsApi.md#create_artifact) | **POST** /projects/{owner}/{name}/artifacts | Get an Artifact upload link.
*ArtifactsApi* | [**delete_artifact**](https://github.com/pollination/python-sdk/blob/master/docs/ArtifactsApi.md#delete_artifact) | **DELETE** /projects/{owner}/{name}/artifacts | Delete one or many artifacts by key/prefix
*ArtifactsApi* | [**download_artifact**](https://github.com/pollination/python-sdk/blob/master/docs/ArtifactsApi.md#download_artifact) | **GET** /projects/{owner}/{name}/artifacts/download | Download an artifact from the project folder
*ArtifactsApi* | [**list_artifacts**](https://github.com/pollination/python-sdk/blob/master/docs/ArtifactsApi.md#list_artifacts) | **GET** /projects/{owner}/{name}/artifacts | List artifacts in a project folder
*JobsApi* | [**cancel_job**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#cancel_job) | **PUT** /projects/{owner}/{name}/jobs/{job_id}/cancel | Cancel a Job
*JobsApi* | [**create_job**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#create_job) | **POST** /projects/{owner}/{name}/jobs | Schedule a job
*JobsApi* | [**download_job_artifact**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#download_job_artifact) | **GET** /projects/{owner}/{name}/jobs/{job_id}/artifacts/download | Download an artifact from the job folder
*JobsApi* | [**get_job**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#get_job) | **GET** /projects/{owner}/{name}/jobs/{job_id} | Get a Job
*JobsApi* | [**list_jobs**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#list_jobs) | **GET** /projects/{owner}/{name}/jobs | List Jobs
*JobsApi* | [**search_job_folder**](https://github.com/pollination/python-sdk/blob/master/docs/JobsApi.md#search_job_folder) | **GET** /projects/{owner}/{name}/jobs/{job_id}/artifacts | List files/folders in a job folder
*OrgsApi* | [**create_org**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#create_org) | **POST** /orgs | Create an Org
*OrgsApi* | [**delete_org**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#delete_org) | **DELETE** /orgs/{name} | Delete an Org
*OrgsApi* | [**delete_org_member**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#delete_org_member) | **DELETE** /orgs/{name}/members/{username} | Remove an Org member
*OrgsApi* | [**get_org**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#get_org) | **GET** /orgs/{name} | Get an Org
*OrgsApi* | [**get_org_members**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#get_org_members) | **GET** /orgs/{name}/members | List organization members
*OrgsApi* | [**list_orgs**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#list_orgs) | **GET** /orgs | List Orgs
*OrgsApi* | [**update_org**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#update_org) | **PUT** /orgs/{name} | Update an Org
*OrgsApi* | [**upsert_org_member**](https://github.com/pollination/python-sdk/blob/master/docs/OrgsApi.md#upsert_org_member) | **PATCH** /orgs/{name}/members/{username}/{role} | Add or update the role of an Org Member
*PluginsApi* | [**create_plugin**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#create_plugin) | **POST** /plugins/{owner} | Create a Plugin
*PluginsApi* | [**create_plugin_package**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#create_plugin_package) | **POST** /plugins/{owner}/{name}/tags | Create a new Plugin package
*PluginsApi* | [**delete_plugin**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#delete_plugin) | **DELETE** /plugins/{owner}/{name} | Delete a Plugin
*PluginsApi* | [**delete_plugin_org_permission**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#delete_plugin_org_permission) | **DELETE** /plugins/{owner}/{name}/permissions | Remove a Repository permissions
*PluginsApi* | [**get_plugin**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#get_plugin) | **GET** /plugins/{owner}/{name} | Get a plugin
*PluginsApi* | [**get_plugin_access_permissions**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#get_plugin_access_permissions) | **GET** /plugins/{owner}/{name}/permissions | Get plugin access permissions
*PluginsApi* | [**get_plugin_by_tag**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#get_plugin_by_tag) | **GET** /plugins/{owner}/{name}/tags/{tag} | Get a plugin tag
*PluginsApi* | [**list_plugin_tags**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#list_plugin_tags) | **GET** /plugins/{owner}/{name}/tags | Get a plugin tags
*PluginsApi* | [**list_plugins**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#list_plugins) | **GET** /plugins | List plugins
*PluginsApi* | [**update_plugin**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#update_plugin) | **PUT** /plugins/{owner}/{name} | Update a Plugin
*PluginsApi* | [**upsert_plugin_permission**](https://github.com/pollination/python-sdk/blob/master/docs/PluginsApi.md#upsert_plugin_permission) | **PATCH** /plugins/{owner}/{name}/permissions | Upsert a new permission to a plugin
*ProjectsApi* | [**create_project**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#create_project) | **POST** /projects/{owner} | Create a Project
*ProjectsApi* | [**create_project_recipe_filter**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#create_project_recipe_filter) | **POST** /projects/{owner}/{name}/recipes/filters | Upsert a recipe filter to a project
*ProjectsApi* | [**delete_project**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#delete_project) | **DELETE** /projects/{owner}/{name} | Delete a Project
*ProjectsApi* | [**delete_project_org_permission**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#delete_project_org_permission) | **DELETE** /projects/{owner}/{name}/permissions | Remove a Project permissions
*ProjectsApi* | [**delete_project_recipe_filter**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#delete_project_recipe_filter) | **DELETE** /projects/{owner}/{name}/recipes/filters | Remove a Project recipe filter
*ProjectsApi* | [**get_project**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#get_project) | **GET** /projects/{owner}/{name} | Get a project
*ProjectsApi* | [**get_project_access_permissions**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#get_project_access_permissions) | **GET** /projects/{owner}/{name}/permissions | Get project access permissions
*ProjectsApi* | [**get_project_recipe_filters**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#get_project_recipe_filters) | **GET** /projects/{owner}/{name}/recipes/filters | Get project recipe filters
*ProjectsApi* | [**get_project_recipes**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#get_project_recipes) | **GET** /projects/{owner}/{name}/recipes | Get project recipes
*ProjectsApi* | [**list_projects**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#list_projects) | **GET** /projects | List Projects
*ProjectsApi* | [**update**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#update) | **PUT** /projects/{owner}/{name} | Update a Project
*ProjectsApi* | [**upsert_project_permission**](https://github.com/pollination/python-sdk/blob/master/docs/ProjectsApi.md#upsert_project_permission) | **PATCH** /projects/{owner}/{name}/permissions | Upsert a new permission to a project
*RecipesApi* | [**create_recipe**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#create_recipe) | **POST** /recipes/{owner} | Create a Recipe
*RecipesApi* | [**create_recipe_package**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#create_recipe_package) | **POST** /recipes/{owner}/{name}/tags | Create a new Recipe package
*RecipesApi* | [**delete_recipe**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#delete_recipe) | **DELETE** /recipes/{owner}/{name} | Delete a Recipe
*RecipesApi* | [**delete_recipe_org_permission**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#delete_recipe_org_permission) | **DELETE** /recipes/{owner}/{name}/permissions | Remove a Repository permissions
*RecipesApi* | [**get_recipe**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#get_recipe) | **GET** /recipes/{owner}/{name} | Get a recipe
*RecipesApi* | [**get_recipe_access_permissions**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#get_recipe_access_permissions) | **GET** /recipes/{owner}/{name}/permissions | Get recipe access permissions
*RecipesApi* | [**get_recipe_by_tag**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#get_recipe_by_tag) | **GET** /recipes/{owner}/{name}/tags/{tag} | Get a recipe tag
*RecipesApi* | [**list_recipe_tags**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#list_recipe_tags) | **GET** /recipes/{owner}/{name}/tags | Get a recipe tags
*RecipesApi* | [**list_recipes**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#list_recipes) | **GET** /recipes | List recipes
*RecipesApi* | [**update_recipe**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#update_recipe) | **PUT** /recipes/{owner}/{name} | Update a Recipe
*RecipesApi* | [**upsert_recipe_permission**](https://github.com/pollination/python-sdk/blob/master/docs/RecipesApi.md#upsert_recipe_permission) | **PATCH** /recipes/{owner}/{name}/permissions | Upsert a new permission to a recipe
*RegistriesApi* | [**get_package**](https://github.com/pollination/python-sdk/blob/master/docs/RegistriesApi.md#get_package) | **GET** /registries/{owner}/{type}/{name}/{digest} | Get Package
*RegistriesApi* | [**get_package_json**](https://github.com/pollination/python-sdk/blob/master/docs/RegistriesApi.md#get_package_json) | **GET** /registries/{owner}/{type}/{name}/{digest}/json | Get Package in JSON format
*RegistriesApi* | [**get_registry_index**](https://github.com/pollination/python-sdk/blob/master/docs/RegistriesApi.md#get_registry_index) | **GET** /registries/{owner}/index.json | Get Registry Index
*RegistriesApi* | [**post_plugin**](https://github.com/pollination/python-sdk/blob/master/docs/RegistriesApi.md#post_plugin) | **POST** /registries/{owner}/plugins | Push a plugin to the registry
*RegistriesApi* | [**post_recipe**](https://github.com/pollination/python-sdk/blob/master/docs/RegistriesApi.md#post_recipe) | **POST** /registries/{owner}/recipes | Push an Recipe to the registry
*RunsApi* | [**cancel_run**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#cancel_run) | **PUT** /projects/{owner}/{name}/runs/{run_id}/cancel | Cancel a run
*RunsApi* | [**download_run_artifact**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#download_run_artifact) | **GET** /projects/{owner}/{name}/runs/{run_id}/artifacts/download | Download an artifact from the run folder
*RunsApi* | [**get_run**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#get_run) | **GET** /projects/{owner}/{name}/runs/{run_id} | Get a Run
*RunsApi* | [**get_run_output**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#get_run_output) | **GET** /projects/{owner}/{name}/runs/{run_id}/outputs/{output_name} | Get run output by name
*RunsApi* | [**get_run_step_logs**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#get_run_step_logs) | **GET** /projects/{owner}/{name}/runs/{run_id}/steps/{step_id}/logs | Get the logs of a specific step of the run
*RunsApi* | [**get_run_steps**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#get_run_steps) | **GET** /projects/{owner}/{name}/runs/{run_id}/steps | Query the steps of a run
*RunsApi* | [**list_run_artifacts**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#list_run_artifacts) | **GET** /projects/{owner}/{name}/runs/{run_id}/artifacts | List artifacts in a run folder
*RunsApi* | [**list_runs**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#list_runs) | **GET** /projects/{owner}/{name}/runs | List runs
*RunsApi* | [**query_results**](https://github.com/pollination/python-sdk/blob/master/docs/RunsApi.md#query_results) | **GET** /projects/{owner}/{name}/results | Query run results
*TeamsApi* | [**create_team**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#create_team) | **POST** /orgs/{org_name}/teams | Create a Team
*TeamsApi* | [**delete_org_team_member**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#delete_org_team_member) | **DELETE** /orgs/{org_name}/teams/{team_slug}/members/{username} | Remove a team member
*TeamsApi* | [**delete_team**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#delete_team) | **DELETE** /orgs/{org_name}/teams/{team_slug} | Delete a Team
*TeamsApi* | [**get_org_team_members**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#get_org_team_members) | **GET** /orgs/{org_name}/teams/{team_slug}/members | List team members
*TeamsApi* | [**get_team**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#get_team) | **GET** /orgs/{org_name}/teams/{team_slug} | Get a Team
*TeamsApi* | [**list_org_teams**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#list_org_teams) | **GET** /orgs/{org_name}/teams | List Teams
*TeamsApi* | [**update_team**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#update_team) | **PUT** /orgs/{org_name}/teams/{team_slug} | Update a Team
*TeamsApi* | [**upsert_org_team_member**](https://github.com/pollination/python-sdk/blob/master/docs/TeamsApi.md#upsert_org_team_member) | **PATCH** /orgs/{org_name}/teams/{team_slug}/members/{username}/{role} | Add or update the role of an Team Member
*UserApi* | [**create_user**](https://github.com/pollination/python-sdk/blob/master/docs/UserApi.md#create_user) | **POST** /user | Register a new user
*UserApi* | [**get_me**](https://github.com/pollination/python-sdk/blob/master/docs/UserApi.md#get_me) | **GET** /user | Get authenticated user profile.
*UserApi* | [**get_roles**](https://github.com/pollination/python-sdk/blob/master/docs/UserApi.md#get_roles) | **GET** /user/roles | Get the authenticated user roles
*UserApi* | [**update_user_profile**](https://github.com/pollination/python-sdk/blob/master/docs/UserApi.md#update_user_profile) | **PUT** /user | Update the authenticated user
*UsersApi* | [**check_username**](https://github.com/pollination/python-sdk/blob/master/docs/UsersApi.md#check_username) | **GET** /users/check_username/{username} | Check if a username is already taken
*UsersApi* | [**get_one_user**](https://github.com/pollination/python-sdk/blob/master/docs/UsersApi.md#get_one_user) | **GET** /users/{name} | Get a specific user profile
*UsersApi* | [**list_users**](https://github.com/pollination/python-sdk/blob/master/docs/UsersApi.md#list_users) | **GET** /users | List Users


## Documentation For Models

 - [APIToken](https://github.com/pollination/python-sdk/blob/master/docs/APIToken.md)
 - [APITokenCreate](https://github.com/pollination/python-sdk/blob/master/docs/APITokenCreate.md)
 - [APITokenList](https://github.com/pollination/python-sdk/blob/master/docs/APITokenList.md)
 - [APITokenPrivate](https://github.com/pollination/python-sdk/blob/master/docs/APITokenPrivate.md)
 - [AccountPublic](https://github.com/pollination/python-sdk/blob/master/docs/AccountPublic.md)
 - [BodyPostPluginOwnerPluginsPost](https://github.com/pollination/python-sdk/blob/master/docs/BodyPostPluginOwnerPluginsPost.md)
 - [BodyPostRecipeOwnerRecipesPost](https://github.com/pollination/python-sdk/blob/master/docs/BodyPostRecipeOwnerRecipesPost.md)
 - [CloudJob](https://github.com/pollination/python-sdk/blob/master/docs/CloudJob.md)
 - [CloudJobList](https://github.com/pollination/python-sdk/blob/master/docs/CloudJobList.md)
 - [CreatedContent](https://github.com/pollination/python-sdk/blob/master/docs/CreatedContent.md)
 - [DAG](https://github.com/pollination/python-sdk/blob/master/docs/DAG.md)
 - [DAGArrayInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGArrayInput.md)
 - [DAGArrayInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGArrayInputAlias.md)
 - [DAGArrayOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGArrayOutput.md)
 - [DAGArrayOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGArrayOutputAlias.md)
 - [DAGBooleanInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGBooleanInput.md)
 - [DAGBooleanInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGBooleanInputAlias.md)
 - [DAGBooleanOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGBooleanOutput.md)
 - [DAGBooleanOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGBooleanOutputAlias.md)
 - [DAGFileInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGFileInput.md)
 - [DAGFileInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGFileInputAlias.md)
 - [DAGFileOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGFileOutput.md)
 - [DAGFileOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGFileOutputAlias.md)
 - [DAGFolderInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGFolderInput.md)
 - [DAGFolderInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGFolderInputAlias.md)
 - [DAGFolderOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGFolderOutput.md)
 - [DAGFolderOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGFolderOutputAlias.md)
 - [DAGGenericInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGGenericInput.md)
 - [DAGGenericInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGGenericInputAlias.md)
 - [DAGGenericOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGGenericOutput.md)
 - [DAGGenericOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGGenericOutputAlias.md)
 - [DAGIntegerInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGIntegerInput.md)
 - [DAGIntegerInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGIntegerInputAlias.md)
 - [DAGIntegerOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGIntegerOutput.md)
 - [DAGIntegerOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGIntegerOutputAlias.md)
 - [DAGJSONObjectInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGJSONObjectInput.md)
 - [DAGJSONObjectInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGJSONObjectInputAlias.md)
 - [DAGJSONObjectOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGJSONObjectOutput.md)
 - [DAGJSONObjectOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGJSONObjectOutputAlias.md)
 - [DAGLinkedInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGLinkedInputAlias.md)
 - [DAGLinkedOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGLinkedOutputAlias.md)
 - [DAGNumberInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGNumberInput.md)
 - [DAGNumberInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGNumberInputAlias.md)
 - [DAGNumberOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGNumberOutput.md)
 - [DAGNumberOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGNumberOutputAlias.md)
 - [DAGPathInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGPathInput.md)
 - [DAGPathInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGPathInputAlias.md)
 - [DAGPathOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGPathOutput.md)
 - [DAGPathOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGPathOutputAlias.md)
 - [DAGStringInput](https://github.com/pollination/python-sdk/blob/master/docs/DAGStringInput.md)
 - [DAGStringInputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGStringInputAlias.md)
 - [DAGStringOutput](https://github.com/pollination/python-sdk/blob/master/docs/DAGStringOutput.md)
 - [DAGStringOutputAlias](https://github.com/pollination/python-sdk/blob/master/docs/DAGStringOutputAlias.md)
 - [DAGTask](https://github.com/pollination/python-sdk/blob/master/docs/DAGTask.md)
 - [DAGTaskLoop](https://github.com/pollination/python-sdk/blob/master/docs/DAGTaskLoop.md)
 - [DailyUsage](https://github.com/pollination/python-sdk/blob/master/docs/DailyUsage.md)
 - [Dependency](https://github.com/pollination/python-sdk/blob/master/docs/Dependency.md)
 - [DependencyKind](https://github.com/pollination/python-sdk/blob/master/docs/DependencyKind.md)
 - [DockerConfig](https://github.com/pollination/python-sdk/blob/master/docs/DockerConfig.md)
 - [FileMeta](https://github.com/pollination/python-sdk/blob/master/docs/FileMeta.md)
 - [FileReference](https://github.com/pollination/python-sdk/blob/master/docs/FileReference.md)
 - [FolderReference](https://github.com/pollination/python-sdk/blob/master/docs/FolderReference.md)
 - [Function](https://github.com/pollination/python-sdk/blob/master/docs/Function.md)
 - [FunctionArrayInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionArrayInput.md)
 - [FunctionArrayOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionArrayOutput.md)
 - [FunctionBooleanInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionBooleanInput.md)
 - [FunctionBooleanOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionBooleanOutput.md)
 - [FunctionFileInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionFileInput.md)
 - [FunctionFileOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionFileOutput.md)
 - [FunctionFolderInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionFolderInput.md)
 - [FunctionFolderOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionFolderOutput.md)
 - [FunctionIntegerInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionIntegerInput.md)
 - [FunctionIntegerOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionIntegerOutput.md)
 - [FunctionJSONObjectInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionJSONObjectInput.md)
 - [FunctionJSONObjectOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionJSONObjectOutput.md)
 - [FunctionNumberInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionNumberInput.md)
 - [FunctionNumberOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionNumberOutput.md)
 - [FunctionPathInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionPathInput.md)
 - [FunctionPathOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionPathOutput.md)
 - [FunctionStringInput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionStringInput.md)
 - [FunctionStringOutput](https://github.com/pollination/python-sdk/blob/master/docs/FunctionStringOutput.md)
 - [HTTP](https://github.com/pollination/python-sdk/blob/master/docs/HTTP.md)
 - [HTTPValidationError](https://github.com/pollination/python-sdk/blob/master/docs/HTTPValidationError.md)
 - [IOAliasHandler](https://github.com/pollination/python-sdk/blob/master/docs/IOAliasHandler.md)
 - [InputFileReference](https://github.com/pollination/python-sdk/blob/master/docs/InputFileReference.md)
 - [InputFolderReference](https://github.com/pollination/python-sdk/blob/master/docs/InputFolderReference.md)
 - [InputPathReference](https://github.com/pollination/python-sdk/blob/master/docs/InputPathReference.md)
 - [InputReference](https://github.com/pollination/python-sdk/blob/master/docs/InputReference.md)
 - [ItemReference](https://github.com/pollination/python-sdk/blob/master/docs/ItemReference.md)
 - [ItemType](https://github.com/pollination/python-sdk/blob/master/docs/ItemType.md)
 - [Job](https://github.com/pollination/python-sdk/blob/master/docs/Job.md)
 - [JobArgument](https://github.com/pollination/python-sdk/blob/master/docs/JobArgument.md)
 - [JobPathArgument](https://github.com/pollination/python-sdk/blob/master/docs/JobPathArgument.md)
 - [JobStatus](https://github.com/pollination/python-sdk/blob/master/docs/JobStatus.md)
 - [JobStatusEnum](https://github.com/pollination/python-sdk/blob/master/docs/JobStatusEnum.md)
 - [KeyRequest](https://github.com/pollination/python-sdk/blob/master/docs/KeyRequest.md)
 - [License](https://github.com/pollination/python-sdk/blob/master/docs/License.md)
 - [LocalConfig](https://github.com/pollination/python-sdk/blob/master/docs/LocalConfig.md)
 - [Maintainer](https://github.com/pollination/python-sdk/blob/master/docs/Maintainer.md)
 - [MetaData](https://github.com/pollination/python-sdk/blob/master/docs/MetaData.md)
 - [NewPluginPackage](https://github.com/pollination/python-sdk/blob/master/docs/NewPluginPackage.md)
 - [NewRecipePackage](https://github.com/pollination/python-sdk/blob/master/docs/NewRecipePackage.md)
 - [Organization](https://github.com/pollination/python-sdk/blob/master/docs/Organization.md)
 - [OrganizationCreate](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationCreate.md)
 - [OrganizationList](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationList.md)
 - [OrganizationMember](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationMember.md)
 - [OrganizationMemberList](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationMemberList.md)
 - [OrganizationRoleEnum](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationRoleEnum.md)
 - [OrganizationUpdate](https://github.com/pollination/python-sdk/blob/master/docs/OrganizationUpdate.md)
 - [PackageVersion](https://github.com/pollination/python-sdk/blob/master/docs/PackageVersion.md)
 - [Permission](https://github.com/pollination/python-sdk/blob/master/docs/Permission.md)
 - [Plugin](https://github.com/pollination/python-sdk/blob/master/docs/Plugin.md)
 - [PluginConfig](https://github.com/pollination/python-sdk/blob/master/docs/PluginConfig.md)
 - [PluginPackage](https://github.com/pollination/python-sdk/blob/master/docs/PluginPackage.md)
 - [PluginPackageList](https://github.com/pollination/python-sdk/blob/master/docs/PluginPackageList.md)
 - [PolicySubject](https://github.com/pollination/python-sdk/blob/master/docs/PolicySubject.md)
 - [Project](https://github.com/pollination/python-sdk/blob/master/docs/Project.md)
 - [ProjectAccessPolicy](https://github.com/pollination/python-sdk/blob/master/docs/ProjectAccessPolicy.md)
 - [ProjectAccessPolicyList](https://github.com/pollination/python-sdk/blob/master/docs/ProjectAccessPolicyList.md)
 - [ProjectCreate](https://github.com/pollination/python-sdk/blob/master/docs/ProjectCreate.md)
 - [ProjectFolder](https://github.com/pollination/python-sdk/blob/master/docs/ProjectFolder.md)
 - [ProjectList](https://github.com/pollination/python-sdk/blob/master/docs/ProjectList.md)
 - [ProjectPolicySubject](https://github.com/pollination/python-sdk/blob/master/docs/ProjectPolicySubject.md)
 - [ProjectRecipeFilter](https://github.com/pollination/python-sdk/blob/master/docs/ProjectRecipeFilter.md)
 - [ProjectRecipeFilterList](https://github.com/pollination/python-sdk/blob/master/docs/ProjectRecipeFilterList.md)
 - [ProjectSortKey](https://github.com/pollination/python-sdk/blob/master/docs/ProjectSortKey.md)
 - [ProjectUpdate](https://github.com/pollination/python-sdk/blob/master/docs/ProjectUpdate.md)
 - [PublicAccountList](https://github.com/pollination/python-sdk/blob/master/docs/PublicAccountList.md)
 - [Recipe](https://github.com/pollination/python-sdk/blob/master/docs/Recipe.md)
 - [RecipeInterface](https://github.com/pollination/python-sdk/blob/master/docs/RecipeInterface.md)
 - [RecipeInterfaceList](https://github.com/pollination/python-sdk/blob/master/docs/RecipeInterfaceList.md)
 - [RecipePackage](https://github.com/pollination/python-sdk/blob/master/docs/RecipePackage.md)
 - [RecipePackageList](https://github.com/pollination/python-sdk/blob/master/docs/RecipePackageList.md)
 - [Repository](https://github.com/pollination/python-sdk/blob/master/docs/Repository.md)
 - [RepositoryAccessPolicy](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryAccessPolicy.md)
 - [RepositoryAccessPolicyList](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryAccessPolicyList.md)
 - [RepositoryCreate](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryCreate.md)
 - [RepositoryIndex](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryIndex.md)
 - [RepositoryList](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryList.md)
 - [RepositoryMetadata](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryMetadata.md)
 - [RepositoryPolicySubject](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryPolicySubject.md)
 - [RepositorySortKey](https://github.com/pollination/python-sdk/blob/master/docs/RepositorySortKey.md)
 - [RepositoryUpdate](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryUpdate.md)
 - [RepositoryUserPermissions](https://github.com/pollination/python-sdk/blob/master/docs/RepositoryUserPermissions.md)
 - [RoleEnum](https://github.com/pollination/python-sdk/blob/master/docs/RoleEnum.md)
 - [Run](https://github.com/pollination/python-sdk/blob/master/docs/Run.md)
 - [RunList](https://github.com/pollination/python-sdk/blob/master/docs/RunList.md)
 - [RunResultList](https://github.com/pollination/python-sdk/blob/master/docs/RunResultList.md)
 - [RunStatus](https://github.com/pollination/python-sdk/blob/master/docs/RunStatus.md)
 - [RunStatusEnum](https://github.com/pollination/python-sdk/blob/master/docs/RunStatusEnum.md)
 - [S3](https://github.com/pollination/python-sdk/blob/master/docs/S3.md)
 - [S3UploadRequest](https://github.com/pollination/python-sdk/blob/master/docs/S3UploadRequest.md)
 - [SortEnum](https://github.com/pollination/python-sdk/blob/master/docs/SortEnum.md)
 - [StatusType](https://github.com/pollination/python-sdk/blob/master/docs/StatusType.md)
 - [StepArrayInput](https://github.com/pollination/python-sdk/blob/master/docs/StepArrayInput.md)
 - [StepArrayOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepArrayOutput.md)
 - [StepBooleanInput](https://github.com/pollination/python-sdk/blob/master/docs/StepBooleanInput.md)
 - [StepBooleanOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepBooleanOutput.md)
 - [StepFileInput](https://github.com/pollination/python-sdk/blob/master/docs/StepFileInput.md)
 - [StepFileOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepFileOutput.md)
 - [StepFolderInput](https://github.com/pollination/python-sdk/blob/master/docs/StepFolderInput.md)
 - [StepFolderOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepFolderOutput.md)
 - [StepIntegerInput](https://github.com/pollination/python-sdk/blob/master/docs/StepIntegerInput.md)
 - [StepIntegerOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepIntegerOutput.md)
 - [StepJSONObjectInput](https://github.com/pollination/python-sdk/blob/master/docs/StepJSONObjectInput.md)
 - [StepJSONObjectOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepJSONObjectOutput.md)
 - [StepList](https://github.com/pollination/python-sdk/blob/master/docs/StepList.md)
 - [StepNumberInput](https://github.com/pollination/python-sdk/blob/master/docs/StepNumberInput.md)
 - [StepNumberOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepNumberOutput.md)
 - [StepPathInput](https://github.com/pollination/python-sdk/blob/master/docs/StepPathInput.md)
 - [StepPathOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepPathOutput.md)
 - [StepStatus](https://github.com/pollination/python-sdk/blob/master/docs/StepStatus.md)
 - [StepStatusEnum](https://github.com/pollination/python-sdk/blob/master/docs/StepStatusEnum.md)
 - [StepStringInput](https://github.com/pollination/python-sdk/blob/master/docs/StepStringInput.md)
 - [StepStringOutput](https://github.com/pollination/python-sdk/blob/master/docs/StepStringOutput.md)
 - [SubjectType](https://github.com/pollination/python-sdk/blob/master/docs/SubjectType.md)
 - [TaskArgument](https://github.com/pollination/python-sdk/blob/master/docs/TaskArgument.md)
 - [TaskFileReference](https://github.com/pollination/python-sdk/blob/master/docs/TaskFileReference.md)
 - [TaskFolderReference](https://github.com/pollination/python-sdk/blob/master/docs/TaskFolderReference.md)
 - [TaskPathArgument](https://github.com/pollination/python-sdk/blob/master/docs/TaskPathArgument.md)
 - [TaskPathReference](https://github.com/pollination/python-sdk/blob/master/docs/TaskPathReference.md)
 - [TaskPathReturn](https://github.com/pollination/python-sdk/blob/master/docs/TaskPathReturn.md)
 - [TaskReference](https://github.com/pollination/python-sdk/blob/master/docs/TaskReference.md)
 - [TaskReturn](https://github.com/pollination/python-sdk/blob/master/docs/TaskReturn.md)
 - [Team](https://github.com/pollination/python-sdk/blob/master/docs/Team.md)
 - [TeamCreate](https://github.com/pollination/python-sdk/blob/master/docs/TeamCreate.md)
 - [TeamList](https://github.com/pollination/python-sdk/blob/master/docs/TeamList.md)
 - [TeamMember](https://github.com/pollination/python-sdk/blob/master/docs/TeamMember.md)
 - [TeamMemberList](https://github.com/pollination/python-sdk/blob/master/docs/TeamMemberList.md)
 - [TeamRoleEnum](https://github.com/pollination/python-sdk/blob/master/docs/TeamRoleEnum.md)
 - [TeamUpdate](https://github.com/pollination/python-sdk/blob/master/docs/TeamUpdate.md)
 - [UpdateAccepted](https://github.com/pollination/python-sdk/blob/master/docs/UpdateAccepted.md)
 - [Usage](https://github.com/pollination/python-sdk/blob/master/docs/Usage.md)
 - [UserCreate](https://github.com/pollination/python-sdk/blob/master/docs/UserCreate.md)
 - [UserPermission](https://github.com/pollination/python-sdk/blob/master/docs/UserPermission.md)
 - [UserPrivate](https://github.com/pollination/python-sdk/blob/master/docs/UserPrivate.md)
 - [UserPublic](https://github.com/pollination/python-sdk/blob/master/docs/UserPublic.md)
 - [UserPublicList](https://github.com/pollination/python-sdk/blob/master/docs/UserPublicList.md)
 - [UserUpdate](https://github.com/pollination/python-sdk/blob/master/docs/UserUpdate.md)
 - [ValidationError](https://github.com/pollination/python-sdk/blob/master/docs/ValidationError.md)
 - [ValueFileReference](https://github.com/pollination/python-sdk/blob/master/docs/ValueFileReference.md)
 - [ValueFolderReference](https://github.com/pollination/python-sdk/blob/master/docs/ValueFolderReference.md)
 - [ValueListReference](https://github.com/pollination/python-sdk/blob/master/docs/ValueListReference.md)
 - [ValueReference](https://github.com/pollination/python-sdk/blob/master/docs/ValueReference.md)


## Documentation For Authorization


## APIKeyAuth

- **Type**: API key
- **API key parameter name**: x-pollination-token
- **Location**: HTTP header


## JWTAuth

- **Type**: Bearer authentication


## Author

info@pollination.cloud


