# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class UserCustomPassword(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'version': 'str',
        'seed': 'str',
        'override_accounts': 'list[OverrideAccounts]',
        'mfa': 'MFA',
        'recaptcha': 'str',
        'force_error': 'str'
    }

    attribute_map = {
        'version': 'version',
        'seed': 'seed',
        'override_accounts': 'override_accounts',
        'mfa': 'mfa',
        'recaptcha': 'recaptcha',
        'force_error': 'force_error'
    }

    def __init__(self, version=None, seed=None, override_accounts=None, mfa=None, recaptcha=None, force_error=None, local_vars_configuration=None):  # noqa: E501
        """UserCustomPassword - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._seed = None
        self._override_accounts = None
        self._mfa = None
        self._recaptcha = None
        self._force_error = None
        self.discriminator = None

        self.version = version
        if seed is not None:
            self.seed = seed
        if override_accounts is not None:
            self.override_accounts = override_accounts
        if mfa is not None:
            self.mfa = mfa
        if recaptcha is not None:
            self.recaptcha = recaptcha
        if force_error is not None:
            self.force_error = force_error

    @property
    def version(self):
        """Gets the version of this UserCustomPassword.  # noqa: E501

        The version of the password schema to use, possible values are 1 or 2. The default value is 2. You should only specify 1 if you know it is necessary for your test suite.  # noqa: E501

        :return: The version of this UserCustomPassword.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this UserCustomPassword.

        The version of the password schema to use, possible values are 1 or 2. The default value is 2. You should only specify 1 if you know it is necessary for your test suite.  # noqa: E501

        :param version: The version of this UserCustomPassword.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def seed(self):
        """Gets the seed of this UserCustomPassword.  # noqa: E501

        A seed, in the form of a string, that will be used to randomly generate account and transaction data, if this data is not specified using the `override_accounts` argument. If no seed is specified, the randomly generated data will be different each time.  Note that transactions data is generated relative to the Item's creation date. Different Items created on different dates with the same seed for transactions data will have different dates for the transactions. The number of days between each transaction and the Item creation will remain constant. For example, an Item created on December 15 might show a transaction on December 14. An Item created on December 20, using the same seed, would show that same transaction occurring on December 19.  # noqa: E501

        :return: The seed of this UserCustomPassword.  # noqa: E501
        :rtype: str
        """
        return self._seed

    @seed.setter
    def seed(self, seed):
        """Sets the seed of this UserCustomPassword.

        A seed, in the form of a string, that will be used to randomly generate account and transaction data, if this data is not specified using the `override_accounts` argument. If no seed is specified, the randomly generated data will be different each time.  Note that transactions data is generated relative to the Item's creation date. Different Items created on different dates with the same seed for transactions data will have different dates for the transactions. The number of days between each transaction and the Item creation will remain constant. For example, an Item created on December 15 might show a transaction on December 14. An Item created on December 20, using the same seed, would show that same transaction occurring on December 19.  # noqa: E501

        :param seed: The seed of this UserCustomPassword.  # noqa: E501
        :type seed: str
        """

        self._seed = seed

    @property
    def override_accounts(self):
        """Gets the override_accounts of this UserCustomPassword.  # noqa: E501

        An array of account overrides to configure the accounts for the Item. By default, if no override is specified, transactions and account data will be randomly generated based on the account type and subtype, and other products will have fixed or empty data.  # noqa: E501

        :return: The override_accounts of this UserCustomPassword.  # noqa: E501
        :rtype: list[OverrideAccounts]
        """
        return self._override_accounts

    @override_accounts.setter
    def override_accounts(self, override_accounts):
        """Sets the override_accounts of this UserCustomPassword.

        An array of account overrides to configure the accounts for the Item. By default, if no override is specified, transactions and account data will be randomly generated based on the account type and subtype, and other products will have fixed or empty data.  # noqa: E501

        :param override_accounts: The override_accounts of this UserCustomPassword.  # noqa: E501
        :type override_accounts: list[OverrideAccounts]
        """

        self._override_accounts = override_accounts

    @property
    def mfa(self):
        """Gets the mfa of this UserCustomPassword.  # noqa: E501


        :return: The mfa of this UserCustomPassword.  # noqa: E501
        :rtype: MFA
        """
        return self._mfa

    @mfa.setter
    def mfa(self, mfa):
        """Sets the mfa of this UserCustomPassword.


        :param mfa: The mfa of this UserCustomPassword.  # noqa: E501
        :type mfa: MFA
        """

        self._mfa = mfa

    @property
    def recaptcha(self):
        """Gets the recaptcha of this UserCustomPassword.  # noqa: E501

        You may trigger a reCAPTCHA in Plaid Link in the Sandbox environment by using the recaptcha field. Possible values are `good` or `bad`. A value of `good` will result in successful Item creation and `bad` will result in a `RECAPTCHA_BAD` error to simulate a failed reCAPTCHA. Both values require the reCAPTCHA to be manually solved within Plaid Link.  # noqa: E501

        :return: The recaptcha of this UserCustomPassword.  # noqa: E501
        :rtype: str
        """
        return self._recaptcha

    @recaptcha.setter
    def recaptcha(self, recaptcha):
        """Sets the recaptcha of this UserCustomPassword.

        You may trigger a reCAPTCHA in Plaid Link in the Sandbox environment by using the recaptcha field. Possible values are `good` or `bad`. A value of `good` will result in successful Item creation and `bad` will result in a `RECAPTCHA_BAD` error to simulate a failed reCAPTCHA. Both values require the reCAPTCHA to be manually solved within Plaid Link.  # noqa: E501

        :param recaptcha: The recaptcha of this UserCustomPassword.  # noqa: E501
        :type recaptcha: str
        """

        self._recaptcha = recaptcha

    @property
    def force_error(self):
        """Gets the force_error of this UserCustomPassword.  # noqa: E501

        An error code to force on Item creation. Possible values are:  `\"INSTITUTION_NOT_RESPONDING\"` `\"INSTITUTION_NO_LONGER_SUPPORTED\"` `\"INVALID_CREDENTIALS\"` `\"INVALID_MFA\"` `\"ITEM_LOCKED\"` `\"ITEM_LOGIN_REQUIRED\"` `\"ITEM_NOT_SUPPORTED\"` `\"INVALID_LINK_TOKEN\"` `\"MFA_NOT_SUPPORTED\"` `\"NO_ACCOUNTS\"` `\"PLAID_ERROR\"` `\"PRODUCTS_NOT_SUPPORTED\"` `\"USER_SETUP_REQUIRED\"`  # noqa: E501

        :return: The force_error of this UserCustomPassword.  # noqa: E501
        :rtype: str
        """
        return self._force_error

    @force_error.setter
    def force_error(self, force_error):
        """Sets the force_error of this UserCustomPassword.

        An error code to force on Item creation. Possible values are:  `\"INSTITUTION_NOT_RESPONDING\"` `\"INSTITUTION_NO_LONGER_SUPPORTED\"` `\"INVALID_CREDENTIALS\"` `\"INVALID_MFA\"` `\"ITEM_LOCKED\"` `\"ITEM_LOGIN_REQUIRED\"` `\"ITEM_NOT_SUPPORTED\"` `\"INVALID_LINK_TOKEN\"` `\"MFA_NOT_SUPPORTED\"` `\"NO_ACCOUNTS\"` `\"PLAID_ERROR\"` `\"PRODUCTS_NOT_SUPPORTED\"` `\"USER_SETUP_REQUIRED\"`  # noqa: E501

        :param force_error: The force_error of this UserCustomPassword.  # noqa: E501
        :type force_error: str
        """

        self._force_error = force_error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserCustomPassword):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserCustomPassword):
            return True

        return self.to_dict() != other.to_dict()
