# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class TransactionsGetResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accounts': 'list[AccountBase]',
        'transactions': 'list[Transaction]',
        'total_transactions': 'int',
        'item': 'Item',
        'request_id': 'str'
    }

    attribute_map = {
        'accounts': 'accounts',
        'transactions': 'transactions',
        'total_transactions': 'total_transactions',
        'item': 'item',
        'request_id': 'request_id'
    }

    def __init__(self, accounts=None, transactions=None, total_transactions=None, item=None, request_id=None, local_vars_configuration=None):  # noqa: E501
        """TransactionsGetResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accounts = None
        self._transactions = None
        self._total_transactions = None
        self._item = None
        self._request_id = None
        self.discriminator = None

        if accounts is not None:
            self.accounts = accounts
        if transactions is not None:
            self.transactions = transactions
        if total_transactions is not None:
            self.total_transactions = total_transactions
        if item is not None:
            self.item = item
        if request_id is not None:
            self.request_id = request_id

    @property
    def accounts(self):
        """Gets the accounts of this TransactionsGetResponse.  # noqa: E501

        An array containing the `accounts` associated with the Item for which transactions are being returned. Each transaction can be mapped to its corresponding account via the `account_id` field.  # noqa: E501

        :return: The accounts of this TransactionsGetResponse.  # noqa: E501
        :rtype: list[AccountBase]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """Sets the accounts of this TransactionsGetResponse.

        An array containing the `accounts` associated with the Item for which transactions are being returned. Each transaction can be mapped to its corresponding account via the `account_id` field.  # noqa: E501

        :param accounts: The accounts of this TransactionsGetResponse.  # noqa: E501
        :type accounts: list[AccountBase]
        """

        self._accounts = accounts

    @property
    def transactions(self):
        """Gets the transactions of this TransactionsGetResponse.  # noqa: E501

        An array containing transactions from the account. Transactions are returned in reverse chronological order, with the most recent at the beginning of the array. The maximum number of transactions returned is determined by the `count` parameter.  # noqa: E501

        :return: The transactions of this TransactionsGetResponse.  # noqa: E501
        :rtype: list[Transaction]
        """
        return self._transactions

    @transactions.setter
    def transactions(self, transactions):
        """Sets the transactions of this TransactionsGetResponse.

        An array containing transactions from the account. Transactions are returned in reverse chronological order, with the most recent at the beginning of the array. The maximum number of transactions returned is determined by the `count` parameter.  # noqa: E501

        :param transactions: The transactions of this TransactionsGetResponse.  # noqa: E501
        :type transactions: list[Transaction]
        """

        self._transactions = transactions

    @property
    def total_transactions(self):
        """Gets the total_transactions of this TransactionsGetResponse.  # noqa: E501

        The total number of transactions available within the date range specified. If `total_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.  # noqa: E501

        :return: The total_transactions of this TransactionsGetResponse.  # noqa: E501
        :rtype: int
        """
        return self._total_transactions

    @total_transactions.setter
    def total_transactions(self, total_transactions):
        """Sets the total_transactions of this TransactionsGetResponse.

        The total number of transactions available within the date range specified. If `total_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.  # noqa: E501

        :param total_transactions: The total_transactions of this TransactionsGetResponse.  # noqa: E501
        :type total_transactions: int
        """

        self._total_transactions = total_transactions

    @property
    def item(self):
        """Gets the item of this TransactionsGetResponse.  # noqa: E501


        :return: The item of this TransactionsGetResponse.  # noqa: E501
        :rtype: Item
        """
        return self._item

    @item.setter
    def item(self, item):
        """Sets the item of this TransactionsGetResponse.


        :param item: The item of this TransactionsGetResponse.  # noqa: E501
        :type item: Item
        """

        self._item = item

    @property
    def request_id(self):
        """Gets the request_id of this TransactionsGetResponse.  # noqa: E501

        A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.  # noqa: E501

        :return: The request_id of this TransactionsGetResponse.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this TransactionsGetResponse.

        A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.  # noqa: E501

        :param request_id: The request_id of this TransactionsGetResponse.  # noqa: E501
        :type request_id: str
        """

        self._request_id = request_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionsGetResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransactionsGetResponse):
            return True

        return self.to_dict() != other.to_dict()
