# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class TransactionOverride(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction_date': 'str',
        'posted_date': 'str',
        'amount': 'float',
        'description': 'str',
        'currency': 'str'
    }

    attribute_map = {
        'transaction_date': 'transaction_date',
        'posted_date': 'posted_date',
        'amount': 'amount',
        'description': 'description',
        'currency': 'currency'
    }

    def __init__(self, transaction_date=None, posted_date=None, amount=None, description=None, currency=None, local_vars_configuration=None):  # noqa: E501
        """TransactionOverride - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._transaction_date = None
        self._posted_date = None
        self._amount = None
        self._description = None
        self._currency = None
        self.discriminator = None

        self.transaction_date = transaction_date
        self.posted_date = posted_date
        self.amount = amount
        self.description = description
        if currency is not None:
            self.currency = currency

    @property
    def transaction_date(self):
        """Gets the transaction_date of this TransactionOverride.  # noqa: E501

        The date of the transaction, in ISO8601 (YYYY-MM-DD) format. Transaction dates in the past or present will result in posted transactions; transaction dates in the future will result in pending transactions. Transactions in Sandbox will move from pending to posted once their transaction date has been reached.  # noqa: E501

        :return: The transaction_date of this TransactionOverride.  # noqa: E501
        :rtype: str
        """
        return self._transaction_date

    @transaction_date.setter
    def transaction_date(self, transaction_date):
        """Sets the transaction_date of this TransactionOverride.

        The date of the transaction, in ISO8601 (YYYY-MM-DD) format. Transaction dates in the past or present will result in posted transactions; transaction dates in the future will result in pending transactions. Transactions in Sandbox will move from pending to posted once their transaction date has been reached.  # noqa: E501

        :param transaction_date: The transaction_date of this TransactionOverride.  # noqa: E501
        :type transaction_date: str
        """
        if self.local_vars_configuration.client_side_validation and transaction_date is None:  # noqa: E501
            raise ValueError("Invalid value for `transaction_date`, must not be `None`")  # noqa: E501

        self._transaction_date = transaction_date

    @property
    def posted_date(self):
        """Gets the posted_date of this TransactionOverride.  # noqa: E501

        The date the transaction posted, in ISO8601 (YYYY-MM-DD) format  # noqa: E501

        :return: The posted_date of this TransactionOverride.  # noqa: E501
        :rtype: str
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this TransactionOverride.

        The date the transaction posted, in ISO8601 (YYYY-MM-DD) format  # noqa: E501

        :param posted_date: The posted_date of this TransactionOverride.  # noqa: E501
        :type posted_date: str
        """
        if self.local_vars_configuration.client_side_validation and posted_date is None:  # noqa: E501
            raise ValueError("Invalid value for `posted_date`, must not be `None`")  # noqa: E501

        self._posted_date = posted_date

    @property
    def amount(self):
        """Gets the amount of this TransactionOverride.  # noqa: E501

        The transaction amount. Can be negative.  # noqa: E501

        :return: The amount of this TransactionOverride.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this TransactionOverride.

        The transaction amount. Can be negative.  # noqa: E501

        :param amount: The amount of this TransactionOverride.  # noqa: E501
        :type amount: float
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def description(self):
        """Gets the description of this TransactionOverride.  # noqa: E501

        The transaction description.  # noqa: E501

        :return: The description of this TransactionOverride.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TransactionOverride.

        The transaction description.  # noqa: E501

        :param description: The description of this TransactionOverride.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def currency(self):
        """Gets the currency of this TransactionOverride.  # noqa: E501

        The ISO-4217 format currency code for the transaction.  # noqa: E501

        :return: The currency of this TransactionOverride.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this TransactionOverride.

        The ISO-4217 format currency code for the transaction.  # noqa: E501

        :param currency: The currency of this TransactionOverride.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionOverride):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransactionOverride):
            return True

        return self.to_dict() != other.to_dict()
