# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class Security(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'security_id': 'str',
        'isin': 'str',
        'cusip': 'str',
        'sedol': 'str',
        'institution_security_id': 'str',
        'institution_id': 'str',
        'proxy_security_id': 'str',
        'name': 'str',
        'ticker_symbol': 'str',
        'is_cash_equivalent': 'bool',
        'type': 'str',
        'close_price': 'float',
        'close_price_as_of': 'str',
        'iso_currency_code': 'str',
        'unofficial_currency_code': 'str'
    }

    attribute_map = {
        'security_id': 'security_id',
        'isin': 'isin',
        'cusip': 'cusip',
        'sedol': 'sedol',
        'institution_security_id': 'institution_security_id',
        'institution_id': 'institution_id',
        'proxy_security_id': 'proxy_security_id',
        'name': 'name',
        'ticker_symbol': 'ticker_symbol',
        'is_cash_equivalent': 'is_cash_equivalent',
        'type': 'type',
        'close_price': 'close_price',
        'close_price_as_of': 'close_price_as_of',
        'iso_currency_code': 'iso_currency_code',
        'unofficial_currency_code': 'unofficial_currency_code'
    }

    def __init__(self, security_id=None, isin=None, cusip=None, sedol=None, institution_security_id=None, institution_id=None, proxy_security_id=None, name=None, ticker_symbol=None, is_cash_equivalent=None, type=None, close_price=None, close_price_as_of=None, iso_currency_code=None, unofficial_currency_code=None, local_vars_configuration=None):  # noqa: E501
        """Security - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._security_id = None
        self._isin = None
        self._cusip = None
        self._sedol = None
        self._institution_security_id = None
        self._institution_id = None
        self._proxy_security_id = None
        self._name = None
        self._ticker_symbol = None
        self._is_cash_equivalent = None
        self._type = None
        self._close_price = None
        self._close_price_as_of = None
        self._iso_currency_code = None
        self._unofficial_currency_code = None
        self.discriminator = None

        if security_id is not None:
            self.security_id = security_id
        self.isin = isin
        self.cusip = cusip
        self.sedol = sedol
        self.institution_security_id = institution_security_id
        self.institution_id = institution_id
        self.proxy_security_id = proxy_security_id
        self.name = name
        self.ticker_symbol = ticker_symbol
        if is_cash_equivalent is not None:
            self.is_cash_equivalent = is_cash_equivalent
        if type is not None:
            self.type = type
        self.close_price = close_price
        self.close_price_as_of = close_price_as_of
        self.iso_currency_code = iso_currency_code
        self.unofficial_currency_code = unofficial_currency_code

    @property
    def security_id(self):
        """Gets the security_id of this Security.  # noqa: E501

        A unique, Plaid-specific identifier for the security, used to associate securities with holdings. Like all Plaid identifiers, the `security_id` is case sensitive.  # noqa: E501

        :return: The security_id of this Security.  # noqa: E501
        :rtype: str
        """
        return self._security_id

    @security_id.setter
    def security_id(self, security_id):
        """Sets the security_id of this Security.

        A unique, Plaid-specific identifier for the security, used to associate securities with holdings. Like all Plaid identifiers, the `security_id` is case sensitive.  # noqa: E501

        :param security_id: The security_id of this Security.  # noqa: E501
        :type security_id: str
        """

        self._security_id = security_id

    @property
    def isin(self):
        """Gets the isin of this Security.  # noqa: E501

        12-character ISIN, a globally unique securities identifier.  # noqa: E501

        :return: The isin of this Security.  # noqa: E501
        :rtype: str
        """
        return self._isin

    @isin.setter
    def isin(self, isin):
        """Sets the isin of this Security.

        12-character ISIN, a globally unique securities identifier.  # noqa: E501

        :param isin: The isin of this Security.  # noqa: E501
        :type isin: str
        """

        self._isin = isin

    @property
    def cusip(self):
        """Gets the cusip of this Security.  # noqa: E501

        9-character CUSIP, an identifier assigned to North American securities.  # noqa: E501

        :return: The cusip of this Security.  # noqa: E501
        :rtype: str
        """
        return self._cusip

    @cusip.setter
    def cusip(self, cusip):
        """Sets the cusip of this Security.

        9-character CUSIP, an identifier assigned to North American securities.  # noqa: E501

        :param cusip: The cusip of this Security.  # noqa: E501
        :type cusip: str
        """

        self._cusip = cusip

    @property
    def sedol(self):
        """Gets the sedol of this Security.  # noqa: E501

        7-character SEDOL, an identifier assigned to securities in the UK.  # noqa: E501

        :return: The sedol of this Security.  # noqa: E501
        :rtype: str
        """
        return self._sedol

    @sedol.setter
    def sedol(self, sedol):
        """Sets the sedol of this Security.

        7-character SEDOL, an identifier assigned to securities in the UK.  # noqa: E501

        :param sedol: The sedol of this Security.  # noqa: E501
        :type sedol: str
        """

        self._sedol = sedol

    @property
    def institution_security_id(self):
        """Gets the institution_security_id of this Security.  # noqa: E501

        An identifier given to the security by the institution  # noqa: E501

        :return: The institution_security_id of this Security.  # noqa: E501
        :rtype: str
        """
        return self._institution_security_id

    @institution_security_id.setter
    def institution_security_id(self, institution_security_id):
        """Sets the institution_security_id of this Security.

        An identifier given to the security by the institution  # noqa: E501

        :param institution_security_id: The institution_security_id of this Security.  # noqa: E501
        :type institution_security_id: str
        """

        self._institution_security_id = institution_security_id

    @property
    def institution_id(self):
        """Gets the institution_id of this Security.  # noqa: E501

        If `institution_security_id` is present, this field indicates the Plaid `institution_id` of the institution to whom the identifier belongs.  # noqa: E501

        :return: The institution_id of this Security.  # noqa: E501
        :rtype: str
        """
        return self._institution_id

    @institution_id.setter
    def institution_id(self, institution_id):
        """Sets the institution_id of this Security.

        If `institution_security_id` is present, this field indicates the Plaid `institution_id` of the institution to whom the identifier belongs.  # noqa: E501

        :param institution_id: The institution_id of this Security.  # noqa: E501
        :type institution_id: str
        """

        self._institution_id = institution_id

    @property
    def proxy_security_id(self):
        """Gets the proxy_security_id of this Security.  # noqa: E501

        In certain cases, Plaid will provide the ID of another security whose performance resembles this security, typically when the original security has low volume, or when a private security can be modeled with a publicly traded security.  # noqa: E501

        :return: The proxy_security_id of this Security.  # noqa: E501
        :rtype: str
        """
        return self._proxy_security_id

    @proxy_security_id.setter
    def proxy_security_id(self, proxy_security_id):
        """Sets the proxy_security_id of this Security.

        In certain cases, Plaid will provide the ID of another security whose performance resembles this security, typically when the original security has low volume, or when a private security can be modeled with a publicly traded security.  # noqa: E501

        :param proxy_security_id: The proxy_security_id of this Security.  # noqa: E501
        :type proxy_security_id: str
        """

        self._proxy_security_id = proxy_security_id

    @property
    def name(self):
        """Gets the name of this Security.  # noqa: E501

        A descriptive name for the security, suitable for display.  # noqa: E501

        :return: The name of this Security.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Security.

        A descriptive name for the security, suitable for display.  # noqa: E501

        :param name: The name of this Security.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def ticker_symbol(self):
        """Gets the ticker_symbol of this Security.  # noqa: E501

        The security’s trading symbol for publicly traded securities, and otherwise a short identifier if available.  # noqa: E501

        :return: The ticker_symbol of this Security.  # noqa: E501
        :rtype: str
        """
        return self._ticker_symbol

    @ticker_symbol.setter
    def ticker_symbol(self, ticker_symbol):
        """Sets the ticker_symbol of this Security.

        The security’s trading symbol for publicly traded securities, and otherwise a short identifier if available.  # noqa: E501

        :param ticker_symbol: The ticker_symbol of this Security.  # noqa: E501
        :type ticker_symbol: str
        """

        self._ticker_symbol = ticker_symbol

    @property
    def is_cash_equivalent(self):
        """Gets the is_cash_equivalent of this Security.  # noqa: E501

        Indicates that a security is a highly liquid asset and can be treated like cash.  # noqa: E501

        :return: The is_cash_equivalent of this Security.  # noqa: E501
        :rtype: bool
        """
        return self._is_cash_equivalent

    @is_cash_equivalent.setter
    def is_cash_equivalent(self, is_cash_equivalent):
        """Sets the is_cash_equivalent of this Security.

        Indicates that a security is a highly liquid asset and can be treated like cash.  # noqa: E501

        :param is_cash_equivalent: The is_cash_equivalent of this Security.  # noqa: E501
        :type is_cash_equivalent: bool
        """

        self._is_cash_equivalent = is_cash_equivalent

    @property
    def type(self):
        """Gets the type of this Security.  # noqa: E501

        The security type of the holding. Valid security types are:  `cash`: Cash, currency, and money market funds  `derivative`: Options, warrants, and other derivative instruments  `equity`: Domestic and foreign equities  `etf`: Multi-asset exchange-traded investment funds  `fixed income`: Bonds and certificates of deposit (CDs)  `loan`: Loans and loan receivables.  `mutual fund`: Open- and closed-end vehicles pooling funds of multiple investors.  `other`: Unknown or other investment types  # noqa: E501

        :return: The type of this Security.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Security.

        The security type of the holding. Valid security types are:  `cash`: Cash, currency, and money market funds  `derivative`: Options, warrants, and other derivative instruments  `equity`: Domestic and foreign equities  `etf`: Multi-asset exchange-traded investment funds  `fixed income`: Bonds and certificates of deposit (CDs)  `loan`: Loans and loan receivables.  `mutual fund`: Open- and closed-end vehicles pooling funds of multiple investors.  `other`: Unknown or other investment types  # noqa: E501

        :param type: The type of this Security.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def close_price(self):
        """Gets the close_price of this Security.  # noqa: E501

        Price of the security at the close of the previous trading session. `null` for non-public securities.  # noqa: E501

        :return: The close_price of this Security.  # noqa: E501
        :rtype: float
        """
        return self._close_price

    @close_price.setter
    def close_price(self, close_price):
        """Sets the close_price of this Security.

        Price of the security at the close of the previous trading session. `null` for non-public securities.  # noqa: E501

        :param close_price: The close_price of this Security.  # noqa: E501
        :type close_price: float
        """

        self._close_price = close_price

    @property
    def close_price_as_of(self):
        """Gets the close_price_as_of of this Security.  # noqa: E501

        Date for which `close_price` is accurate. Always `null` if `close_price` is `null`.  # noqa: E501

        :return: The close_price_as_of of this Security.  # noqa: E501
        :rtype: str
        """
        return self._close_price_as_of

    @close_price_as_of.setter
    def close_price_as_of(self, close_price_as_of):
        """Sets the close_price_as_of of this Security.

        Date for which `close_price` is accurate. Always `null` if `close_price` is `null`.  # noqa: E501

        :param close_price_as_of: The close_price_as_of of this Security.  # noqa: E501
        :type close_price_as_of: str
        """

        self._close_price_as_of = close_price_as_of

    @property
    def iso_currency_code(self):
        """Gets the iso_currency_code of this Security.  # noqa: E501

        The ISO-4217 currency code of the price given. Always `null` if `unofficial_currency_code` is non-`null`.  # noqa: E501

        :return: The iso_currency_code of this Security.  # noqa: E501
        :rtype: str
        """
        return self._iso_currency_code

    @iso_currency_code.setter
    def iso_currency_code(self, iso_currency_code):
        """Sets the iso_currency_code of this Security.

        The ISO-4217 currency code of the price given. Always `null` if `unofficial_currency_code` is non-`null`.  # noqa: E501

        :param iso_currency_code: The iso_currency_code of this Security.  # noqa: E501
        :type iso_currency_code: str
        """

        self._iso_currency_code = iso_currency_code

    @property
    def unofficial_currency_code(self):
        """Gets the unofficial_currency_code of this Security.  # noqa: E501

        The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.  # noqa: E501

        :return: The unofficial_currency_code of this Security.  # noqa: E501
        :rtype: str
        """
        return self._unofficial_currency_code

    @unofficial_currency_code.setter
    def unofficial_currency_code(self, unofficial_currency_code):
        """Sets the unofficial_currency_code of this Security.

        The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.  # noqa: E501

        :param unofficial_currency_code: The unofficial_currency_code of this Security.  # noqa: E501
        :type unofficial_currency_code: str
        """

        self._unofficial_currency_code = unofficial_currency_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Security):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Security):
            return True

        return self.to_dict() != other.to_dict()
