>>> from nessvec.files import load_embeddings
>>> df = load_embeddings('word2vec')
>>> small = df.iloc[:500_000]
>>> index = Index(small)
>>> from nessvec.indexers import Index
... import pandas as pd
... from nessvec.files import load_embeddings
...
>>> index = Index(small)
>>> me = df.T['reckless_abandon']
>>> aggro = df.T['aggressive'] + df.T['altruism']
>>> (me + aggro) / 3
0      0.284785
1      0.058746
2     -0.078939
3      0.365885
4     -0.141927
         ...   
295   -0.104818
296    0.179850
297    0.091797
298   -0.021810
299    0.095540
Length: 300, dtype: float64
>>> aggro_me = _
>>> index.get_nearest_word(aggro_me.values)
>>> index.get_nearest_popular_word(aggro_me.values)
>>> index.get_nearest(aggro_me.values)
reckless_abandon     0.264099
aggressive           0.335180
aggressiveness       0.383244
overly_aggressive    0.453890
single_mindedness    0.460235
instinctual          0.464985
fearlessness         0.474743
agressive            0.487131
zeal                 0.489496
instinct             0.493743
dtype: float64
>>> fearless = df.T['fearless'] / 2 + df.T['altruism'] / 2
>>> index.get_nearest(fearless)
altruism             0.205529
fearless             0.256799
selfless             0.367123
fearlessness         0.370358
altruistic           0.382768
instinct             0.420273
selflessness         0.428261
single_mindedness    0.431704
admirable_trait      0.443434
altruist             0.448418
dtype: float64
>>> index.get_doc_vector("fearless altruism agressive good kindness")
array([ 0.21826172,  0.06601562, -0.02285156,  0.24931641, -0.02926025,
       -0.03839111,  0.12058105,  0.03120117,  0.05964356,  0.13588867,
        0.09560547, -0.05400391,  0.04013672,  0.11309814, -0.20566407,
        0.07404785,  0.06416015,  0.16845703, -0.12697753, -0.03583984,
        0.12314453, -0.08408203,  0.0864502 ,  0.08969726,  0.11168213,
        0.01015625, -0.07060547,  0.05517578,  0.1864502 , -0.05855713,
       -0.06123047, -0.0310791 , -0.02197266, -0.00541992, -0.00310059,
        0.09135742,  0.04414063,  0.13095704,  0.11782227, -0.00874634,
        0.32670897, -0.04511719,  0.01289062,  0.05535889, -0.0798706 ,
       -0.05083008, -0.07832031, -0.08720703,  0.07407226, -0.0177002 ,
       -0.00712891,  0.17436524, -0.08973388,  0.01915894,  0.03808594,
        0.15205078, -0.15351562, -0.09833984, -0.15410157,  0.07866211,
       -0.10185547,  0.05585938, -0.128125  ,  0.02241211, -0.04501953,
       -0.00869141,  0.07275391, -0.01103516, -0.18709716,  0.1885254 ,
        0.0934082 , -0.15795898,  0.01412353,  0.05778809, -0.0987793 ,
       -0.18598633,  0.02421875,  0.06435547,  0.17817383,  0.0489502 ,
       -0.16459961,  0.17376709, -0.07702637, -0.0284668 , -0.10932617,
       -0.02701416, -0.11409302,  0.18349609,  0.15040283, -0.0527832 ,
       -0.05231629,  0.08135986, -0.12640381, -0.00052338,  0.1283203 ,
       -0.03825684, -0.03642578,  0.19042969, -0.00866699, -0.24572754,
       -0.03714599,  0.0418457 ,  0.0951416 , -0.00397949,  0.04780274,
        0.00180664, -0.07687988, -0.10810547,  0.01651611, -0.15654297,
       -0.07075195, -0.03955078, -0.17041016,  0.07861328,  0.09238281,
       -0.0734375 ,  0.04462891, -0.20371094,  0.07099609,  0.07460938,
       -0.10849609, -0.0230957 , -0.05466308,  0.16357422, -0.20253906,
        0.06660156,  0.04968262, -0.02539062,  0.0373291 , -0.03839951,
       -0.30976564, -0.28847656, -0.04199219,  0.10966797, -0.07961426,
       -0.03796387,  0.08106689,  0.06102524, -0.00063782,  0.20195313,
       -0.00651855,  0.0277832 , -0.09573974,  0.02119141, -0.1607666 ,
        0.10839844, -0.05447998,  0.07392578,  0.07191162, -0.3388672 ,
        0.09760742,  0.09487305, -0.09101562,  0.17524414, -0.07119141,
       -0.05239258,  0.12704468, -0.09248047,  0.08859863, -0.05004883,
        0.01269531,  0.09042969, -0.01181641,  0.06298828,  0.0213623 ,
       -0.18398437,  0.06923828, -0.07078858, -0.05498047,  0.02005615,
       -0.009375  , -0.08331299, -0.00913086, -0.06903076, -0.08814697,
        0.16088867,  0.0350586 , -0.00991211,  0.02454834, -0.1465332 ,
       -0.16066894, -0.19123535,  0.01120606, -0.01571045, -0.17690429,
       -0.01196289, -0.11630859, -0.03115234, -0.04404297,  0.05361328,
       -0.10629883,  0.28046876,  0.12250976, -0.04462891, -0.11538086,
       -0.13300781,  0.01455078, -0.06129456, -0.10848389,  0.07275391,
       -0.04414063,  0.15566406,  0.01088867, -0.12263183, -0.12216797,
       -0.10966797, -0.09106445, -0.05810394, -0.05810547, -0.11030273,
       -0.23476562,  0.03398437, -0.06295166,  0.11733399, -0.03879394,
       -0.00908203,  0.11591797,  0.01872559, -0.17666015,  0.08203125,
       -0.09423828,  0.03596191,  0.10498047, -0.04951172, -0.05126953,
        0.01906128,  0.27401122, -0.01787109,  0.00258789,  0.02020264,
       -0.0892334 ,  0.0980957 ,  0.12836914,  0.05029297,  0.1772461 ,
       -0.0340683 ,  0.03920899, -0.18149415,  0.03457031,  0.01398926,
        0.1866211 ,  0.07236328, -0.12557372,  0.0055191 ,  0.18076172,
        0.14819336, -0.01124268, -0.12661132,  0.01020508, -0.14228821,
        0.12653808,  0.09414063,  0.07744446,  0.15126953,  0.04904785,
       -0.2546875 ,  0.10488281,  0.01171875, -0.13604736, -0.03144531,
       -0.02119141, -0.00644531, -0.19238281,  0.08229981,  0.02758789,
        0.01503906,  0.03933106, -0.11894532, -0.09123535,  0.04190674,
       -0.0489502 ,  0.08164062,  0.01972351,  0.07940674,  0.15507813,
       -0.01972656, -0.05050812,  0.10996094, -0.01210937,  0.25214845,
        0.11586914, -0.06149902,  0.06665192, -0.03759766,  0.07851563,
       -0.03729858, -0.0972168 ,  0.03572388,  0.08223877,  0.11791992,
       -0.03429566, -0.0130127 , -0.1631836 , -0.1283081 , -0.1796875 ,
       -0.0659668 ,  0.0954834 , -0.00327148, -0.00442352,  0.08408203],
      dtype=float32)
>>> index.get_nearest(index.get_doc_vector("fearless altruism agressive good kindness"))
kindness               0.309091
selfless               0.313015
altruism               0.330650
fearless               0.341888
unselfish              0.363928
compassion             0.371141
altruistic             0.386749
selflessness           0.406427
tenacity               0.417120
kindness_generosity    0.420620
dtype: float64
>>> index.get_nearest(index.get_doc_vector("fearless altruism agressive good"))
fearless       0.277715
agressive      0.336955
aggressive     0.378605
altruism       0.397235
altruistic     0.412378
tenacious      0.413423
unselfish      0.414425
instinctive    0.418533
selfless       0.429888
hardnosed      0.438300
dtype: float64
>>> hist -o -p
>>> hist -o -p -f ch06_fearless_altruism_word2vec_reckless_abandon.md
