# What's in a name

Mob programming session for Manning Publications on twitch.tv

```python
>>> from tqdm import tqdm
... import pandas as pd
... import numpy as np
... from sklearn.feature_extraction.text import TfidfVectorizer
... from sklearn.linear_model import LogisticRegression
... 
... istrain = np.random.rand(len(df)) < .9
... vectorizer = TfidfVectorizer(analyzer='char', ngram_range=(1, 3))
... vectorizer.fit(tqdm(df['name'][istrain]))
... vecs = vectorizer.transform(tqdm(df['name']))
...
>>> model = LogisticRegression(max_iter=2000, class_weight='balanced')
... model.fit(vecs[istrain], df['sex'][istrain], sample_weight=df['freq'][istrain])
...
LogisticRegression(class_weight='balanced', max_iter=2000)
>>> pd.Series(model.predict(vectorizer.transform(names)), index=names)
>>> names = ['Maria', 'Aditi', 'Jessica', 'Olessya', 'Una', 'Hanna', 'Winnie', 'Olessya',
...          'Sylvia', 'Vish', 'Mohammed', 'Jon', 'John', 'Ted', 'Kazuma', 'Meijke', 'Kemal']
...
>>> pd.Series(model.predict(vectorizer.transform(names)), index=names)
Maria       F
Aditi       M
Jessica     M
Olessya     M
Una         M
Hanna       F
Winnie      M
Olessya     M
Sylvia      M
Vish        M
Mohammed    M
Jon         M
John        M
Ted         M
Kazuma      M
Meijke      M
Kemal       M
dtype: object
>>> model = LogisticRegression(max_iter=10000)
... model.fit(vecs[istrain], df['sex'][istrain], sample_weight=df['freq'][istrain])
...
LogisticRegression(max_iter=10000)
>>> pd.Series(model.predict(vectorizer.transform(names)), index=names)
Maria       F
Aditi       F
Jessica     F
Olessya     F
Una         F
Hanna       F
Winnie      F
... df = pd.read_csv('.nlpia2-data/baby-names-region.csv.gz')
Olessya     F
Sylvia      F
Vish        M
Mohammed    M
Jon         M
John        M
Ted         M
Kazuma      F
Meijke      M
Kemal       F
dtype: object
>>> (df['name'] == 'Kazuma').sum()
0
>>> (df['name'] == 'Kaz').sum()
1
>>> df[df['name'] == 'Kaz']
        region sex  year name  count      freq
2424961     LA   M  2015  Kaz      5  0.000002
>>> model.coef_
array([[-5.56584447e-01,  5.14287250e-02,  2.69276390e-06, ...,
        -1.39283459e-04, -1.21600561e-04, -9.11513939e-05]])
>>> pd.Series(model.coef_, index=vectorizer.get_feature_names())
>>> pd.Series(model.coef_, index=vectorizer.get_feature_names()[0])
>>> index=vectorizer.get_feature_names()
>>> index
['a',
 'aa',
 'aab',
 'aac',
 'aad',
 'aaf',
 'aah',
 'aai',
 'aaj',
 'aak',
 'aal',
 'aam',
 'aan',
 'aar',
 'aas',
 'aat',
 'aav',
 'aay',
 'aaz',
 'ab',
 'aba',
 'abb',
 'abc',
 'abd',
 'abe',
 'abh',
 'abi',
 'abl',
 'abn',
 'abo',
 'abr',
 'abs',
 'abu',
 'aby',
 'ac',
 'aca',
 'acc',
 'ace',
 'ach',
 'aci',
 'ack',
 'acl',
 'aco',
 'acp',
 'acq',
 'acr',
 'acs',
 'acu',
 'acx',
 'acy',
 'ad',
 'ada',
 'adb',
 'add',
 'ade',
 'adf',
 'adg',
 'adh',
 'adi',
 'adj',
 'adk',
 'adl',
 'adm',
 'adn',
 'ado',
 'adq',
 'adr',
 'ads',
 'adu',
 'adv',
 'adw',
 'adx',
 'ady',
 'adz',
 'ae',
 'aea',
 'aeb',
 'aec',
 'aed',
 'aee',
 'aef',
 'aeg',
 'aeh',
 'aei',
 'aej',
 'aek',
 'ael',
 'aem',
 'aen',
 'aeo',
 'aeq',
 'aer',
 'aes',
 'aet',
 'aeu',
 'aev',
 'aey',
 'aez',
 'af',
 'afa',
 'afe',
 'aff',
 'afi',
 'afn',
 'afo',
 'afr',
 'afs',
 'aft',
 'afu',
 'afw',
 'ag',
 'aga',
 'agd',
 'age',
 'agg',
 'agh',
 'agi',
 'agl',
 'agm',
 'agn',
 'ago',
 'agr',
 'agu',
 'agy',
 'ah',
 'aha',
 'ahc',
 'ahd',
 'ahe',
 'ahf',
 'ahg',
 'ahi',
 'ahj',
 'ahk',
 'ahl',
 'ahm',
 'ahn',
 'aho',
 'ahp',
 'ahq',
 'ahr',
 'ahs',
 'aht',
 'ahu',
 'ahv',
 'ahw',
 'ahy',
 'ahz',
 'ai',
 'aia',
 'aib',
 'aic',
 'aid',
 'aie',
 'aif',
 'aig',
 'aih',
 'aii',
 'aij',
 'aik',
 'ail',
 'aim',
 'ain',
 'aio',
 'aip',
 'aiq',
 'air',
 'ais',
 'ait',
 'aiu',
 'aiv',
 'aiw',
 'aix',
 'aiy',
 'aiz',
 'aj',
 'aja',
 'ajd',
 'aje',
 'ajh',
 'aji',
 'ajj',
 'ajl',
 'ajm',
 'ajn',
 'ajo',
 'ajr',
 'ajt',
 'aju',
 'ajv',
 'ajw',
 'ak',
 'aka',
 'akb',
 'ake',
 'akh',
 'aki',
 'akk',
 'akl',
 'ako',
 'akr',
 'aks',
 'akt',
 'aku',
 'akw',
 'aky',
 'al',
 'ala',
 'alb',
 'alc',
 'ald',
 'ale',
 'alf',
 'alg',
 'alh',
 'ali',
 'alj',
 'alk',
 'all',
 'alm',
 'aln',
 'alo',
 'alp',
 'alq',
 'alr',
 'als',
 'alt',
 'alu',
 'alv',
 'alw',
 'aly',
 'alz',
 'am',
 'ama',
 'amb',
 'amc',
 'amd',
 'ame',
 'amh',
 'ami',
 'amj',
 'aml',
 'amm',
 'amn',
 'amo',
 'amp',
 'amr',
 'ams',
 'amt',
 'amu',
 'amv',
 'amy',
 'amz',
 'an',
 'ana',
 'anb',
 'anc',
 'and',
 'ane',
 'anf',
 'ang',
 'anh',
 'ani',
 'anj',
 'ank',
 'anl',
 'anm',
 'ann',
 'ano',
 'anp',
 'anq',
 'anr',
 'ans',
 'ant',
 'anu',
 'anv',
 'anw',
 'anx',
 'any',
 'anz',
 'ao',
 'aod',
 'aoh',
 'aoi',
 'aok',
 'aol',
 'aom',
 'aop',
 'aor',
 'aos',
 'aou',
 'aov',
 'ap',
 'apa',
 'ape',
 'aph',
 'api',
 'apj',
 'apl',
 'apm',
 'apn',
 'apo',
 'app',
 'apr',
 'apt',
 'apu',
 'aq',
 'aqa',
 'aqi',
 'aqs',
 'aqu',
 'aqw',
 'ar',
 'ara',
 'arb',
 'arc',
 'ard',
 'are',
 'arf',
 'arg',
 'arh',
 'ari',
 'arj',
 'ark',
 'arl',
 'arm',
 'arn',
 'aro',
 'arp',
 'arq',
 'arr',
 'ars',
 'art',
 'aru',
 'arv',
 'arw',
 'arx',
 'ary',
 'arz',
 'as',
 'asa',
 'asb',
 'asc',
 'asd',
 'ase',
 'asf',
 'ash',
 'asi',
 'ask',
 'asl',
 'asm',
 'asn',
 'aso',
 'asp',
 'asq',
 'asr',
 'ass',
 'ast',
 'asu',
 'asv',
 'asw',
 'asy',
 'asz',
 'at',
 'ata',
 'atc',
 'ate',
 'ath',
 'ati',
 'atj',
 'atl',
 'atm',
 'atn',
 'ato',
 'atr',
 'ats',
 'att',
 'atu',
 'atv',
 'atw',
 'aty',
 'atz',
 'au',
 'aua',
 'aub',
 'aud',
 'aue',
 'auf',
 'aug',
 'auh',
 'aui',
 'auj',
 'auk',
 'aul',
 'aum',
 'aun',
 'aur',
 'aus',
 'aut',
 'aux',
 'auy',
 'av',
 'ava',
 'avd',
 'ave',
 'avh',
 'avi',
 'avj',
 'avl',
 'avn',
 'avo',
 'avp',
 'avr',
 'avu',
 'avv',
 'avy',
 'aw',
 'awa',
 'awe',
 'awf',
 'awh',
 'awi',
 'awk',
 'awl',
 'awn',
 'awo',
 'awr',
 'aws',
 'awt',
 'awu',
 'awy',
 'ax',
 'axa',
 'axc',
 'axe',
 'axf',
 'axi',
 'axl',
 'axm',
 'axo',
 'axs',
 'axt',
 'axw',
 'axx',
 'axy',
 'axz',
 'ay',
 'aya',
 'ayb',
 'ayc',
 'ayd',
 'aye',
 'ayf',
 'ayg',
 'ayh',
 'ayi',
 'ayj',
 'ayk',
 'ayl',
 'aym',
 'ayn',
 'ayo',
 'ayq',
 'ayr',
 'ays',
 'ayt',
 'ayu',
 'ayv',
 'ayw',
 'ayy',
 'ayz',
 'az',
 'aza',
 'azb',
 'aze',
 'azh',
 'azi',
 'azk',
 'azl',
 'azm',
 'azn',
 'azo',
 'azr',
 'azs',
 'azu',
 'azy',
 'azz',
 'b',
 'ba',
 'baa',
 'bab',
 'bac',
 'bad',
 'bae',
 'bag',
 'bah',
 'bai',
 'bak',
 'bal',
 'bam',
 'ban',
 'bao',
 'bar',
 'bas',
 'bat',
 'bau',
 'baw',
 'bax',
 'bay',
 'baz',
 'bb',
 'bba',
 'bbe',
 'bbi',
 'bbl',
 'bbo',
 'bbr',
 'bby',
 'bc',
 'bcd',
 'bd',
 'bda',
 'bde',
 'bdi',
 'bdo',
 'bdr',
 'bdu',
 'be',
 'bea',
 'beb',
 'bec',
 'bed',
 'bee',
 'beg',
 'beh',
 'bei',
 'bej',
 'bek',
 'bel',
 'bem',
 'ben',
 'ber',
 'bes',
 'bet',
 'beu',
 'bev',
 'bex',
 'bey',
 'bez',
 'bg',
 'bh',
 'bha',
 'bhi',
 'bhj',
 'bhl',
 'bho',
 'bi',
 'bia',
 'bib',
 'bic',
 'bid',
 'bie',
 'bif',
 'big',
 'bih',
 'bij',
 'bik',
 'bil',
 'bim',
 'bin',
 'bio',
 'bir',
 'bis',
 'bit',
 'biv',
 'bix',
 'biy',
 'bj',
 'bjo',
 'bl',
 'bla',
 'ble',
 'bli',
 'blo',
 'blu',
 'bly',
 'bn',
 'bna',
 'bne',
 'bni',
 'bo',
 'boa',
 'bob',
 'bod',
 'boe',
 'bog',
 'boh',
 'bol',
 'bon',
 'boo',
 'bor',
 'bos',
 'bot',
 'bou',
 'bov',
 'bow',
 'boy',
 'br',
 'bra',
 'bre',
 'brh',
 'bri',
 'bro',
 'bru',
 'bry',
 'bs',
 'bsi',
 'bso',
 'bst',
 'bt',
 'bti',
 'bu',
 'bub',
 'buc',
 'bud',
 'bue',
 'buf',
 'bui',
 'buk',
 'bul',
 'bun',
 'buo',
 'bur',
 'bus',
 'but',
 'buy',
 'by',
 'bya',
 'byb',
 'bye',
 'byf',
 'byg',
 'byj',
 'byl',
 'byn',
 'byr',
 'byt',
 'c',
 'ca',
 'caa',
 'cab',
 'cac',
 'cad',
 'cae',
 'cag',
 'cah',
 'cai',
 'cal',
 'cam',
 'can',
 'cao',
 'cap',
 'car',
 'cas',
 'cat',
 'cau',
 'cav',
 'cay',
 'cb',
 'cbe',
 'cc',
 'cca',
 'cce',
 'cch',
 'cci',
 'ccl',
 'cco',
 'ccr',
 'cd',
 'cde',
 'cdi',
 'cdo',
 'ce',
 'cea',
 'ceb',
 'cec',
 'ced',
 'cee',
 'cef',
 'cei',
 'cek',
 'cel',
 'cem',
 'cen',
 'ceo',
 'cep',
 'cer',
 'ces',
 'cet',
 'cey',
 'cez',
 'cg',
 'cgw',
 'ch',
 'cha',
 'che',
 'chi',
 'chl',
 'chm',
 'chn',
 'cho',
 'chr',
 'chu',
 'chw',
 'chy',
 'ci',
 'cia',
 'cic',
 'cid',
 'cie',
 'cif',
 'cig',
 'cij',
 'cil',
 'cin',
 'cio',
 'cip',
 'cir',
 'cis',
 'cit',
 'ciu',
 'civ',
 'cj',
 'cja',
 'ck',
 'cka',
 'ckd',
 'cke',
 'ckh',
 'cki',
 'ckl',
 'ckn',
 'cko',
 'ckq',
 'ckr',
 'cks',
 'ckt',
 'ckw',
 'ckx',
 'cky',
 'cl',
 'cla',
 'cle',
 'cli',
 'clo',
 'clu',
 'cly',
 'cm',
 'cma',
 'cn',
 'cne',
 'cni',
 'co',
 'coa',
 'cob',
 'coc',
 'cod',
 'coe',
 'coh',
 'coi',
 'coj',
 'col',
 'com',
 'con',
 'coo',
 'cop',
 'cor',
 'cos',
 'cot',
 'cou',
 'cov',
 'coy',
 'coz',
 'cp',
 'cpe',
 'cq',
 'cql',
 'cqu',
 'cr',
 'cra',
 'cre',
 'cri',
 'cro',
 'cru',
 'cry',
 'cs',
 'csa',
 'cse',
 'csi',
 'cso',
 'ct',
 'cta',
 'cto',
 'ctr',
 'cu',
 'cua',
 'cub',
 'cuc',
 'cui',
 'cul',
 'cum',
 'cun',
 'cuo',
 'cur',
 'cus',
 'cut',
 'cuz',
 'cx',
 'cxe',
 'cxi',
 'cy',
 'cya',
 'cyb',
 'cyd',
 'cye',
 'cyl',
 'cym',
 'cyn',
 'cyp',
 'cyr',
 'cys',
 'cyt',
 'cz',
 'cza',
 'cze',
 'czy',
 'd',
 'da',
 'daa',
 'dab',
 'dac',
 'dad',
 'dae',
 'daf',
 'dag',
 'dah',
 'dai',
 'daj',
 'dak',
 'dal',
 'dam',
 'dan',
 'dao',
 'dap',
 'daq',
 'dar',
 'das',
 'dat',
 'dau',
 'dav',
 'daw',
 'dax',
 'day',
 'daz',
 'db',
 'dbe',
 'dc',
 'dch',
 'dd',
 'dda',
 'dde',
 'ddh',
 'ddi',
 'ddo',
 'ddr',
 'ddu',
 'ddy',
 'de',
 'dea',
 'deb',
 'dec',
 'ded',
 'dee',
 'def',
 'deg',
 'deh',
 'dei',
 'dej',
 'dek',
 'del',
 'dem',
 'den',
 'deo',
 'deq',
 'der',
 'des',
 'det',
 'deu',
 'dev',
 'dew',
 'dex',
 'dey',
 'dez',
 'df',
 'dfo',
 'dfr',
 'dg',
 'dga',
 'dge',
 'dgi',
 'dh',
 'dha',
 'dhe',
 'dhg',
 'dhi',
 'dhr',
 'dhu',
 'dhv',
 'dhw',
 'dhy',
 'di',
 'dia',
 'dib',
 'dic',
 'did',
 'die',
 'dif',
 'dig',
 'dih',
 'dii',
 'dij',
 'dik',
 'dil',
 'dim',
 'din',
 'dio',
 'diq',
 'dir',
 'dis',
 'dit',
 'diu',
 'div',
 'dix',
 'diy',
 'dj',
 'dja',
 'dje',
 'dji',
 'djo',
 'dju',
 'dk',
 'dki',
 'dl',
 'dla',
 'dle',
 'dli',
 'dlu',
 'dly',
 'dm',
 'dma',
 'dme',
 'dmi',
 'dmo',
 'dmu',
 'dn',
 'dna',
 'dne',
 'dni',
 'dno',
 'dny',
 'do',
 'doa',
 'dob',
 'doc',
 'dod',
 'doe',
 'doh',
 'doi',
 'doj',
 'dok',
 'dol',
 'dom',
 'don',
 'doo',
 'dor',
 'dos',
 'dot',
 'dou',
 'dov',
 'dow',
 'dox',
 'doy',
 'doz',
 'dq',
 'dqu',
 'dr',
 'dra',
 'dre',
 'dri',
 'dro',
 ...]
>>> index.shape
>>> type(index)
list
>>> pd.Series(model.coef_[0], index=vectorizer.get_feature_names())
a     -0.556584
aa     0.051429
aab    0.000003
aac    0.021992
aad    0.000415
         ...   
zze   -0.000103
zzi   -0.001919
zzl   -0.000139
zzm   -0.000122
zzy   -0.000091
Length: 5986, dtype: float64
>>> coef = pd.Series(model.coef_[0], index=vectorizer.get_feature_names())
>>> coef['Kaz']
>>> coef['az']
-0.02216603297465453
>>> coef['azu']
-0.0003656728319935028
>>> coef['zu']
-0.0016125466401391323
>>> coef['zum']
5.621315934940933e-06
>>> coef['uma']
0.0007642577222082215
>>> coef['ma']
-0.2804809937613128
>>> model.intercept_
array([0.08277136])
>>> coef['z']
-0.06687313431457634
>>> coef['u']
0.02968187895127858
>>> coef['m']
-0.03181555148151521
>>> coef['a']
-0.556584447334144
>>> coef['Ka']
>>> coef['K']
>>> coef.index
Index(['a', 'aa', 'aab', 'aac', 'aad', 'aaf', 'aah', 'aai', 'aaj', 'aak',
       ...
       'zyq', 'zyr', 'zys', 'zz', 'zza', 'zze', 'zzi', 'zzl', 'zzm', 'zzy'],
      dtype='object', length=5986)
>>> coef['k']
0.06634704179666573
>>> coef['ka']
-0.18216581846670435
>>> coef['kaz']
3.0355019959739112e-05
>>> kazvec = vectorizer.transform('Kazuma')
>>> kazvec = vectorizer.transform(['Kazuma'])
>>> coef[kazvec != 0]
>>> kazvec[kazvec != 0]
matrix([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
         0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
         0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> coef[kazvec != 0]
>>> kazvec[kazvec != 0]
matrix([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
         0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
         0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> kazvec[kazvec != 0].reshape()
>>> kazvec[kazvec != 0].reshape(kazvec.shape[1])
>>> kazvec[kazvec != 0].reshape((kazvec.shape[1],))
>>> kazvec[kazvec != 0].reshape((14,))
matrix([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
         0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
         0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> kazvec[kazvec != 0].flatten()
matrix([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
         0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
         0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> kazvec[kazvec != 0].ravel()
matrix([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
         0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
         0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> kazvec[kazvec != 0].astype(np.array)
>>> np.array(kazvec[kazvec != 0])
array([[0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
        0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
        0.32475817, 0.17116995, 0.31639993, 0.49863121]])
>>> np.array(kazvec[kazvec != 0])[0]
array([0.10064136, 0.24160243, 0.36640437, 0.11589853, 0.1563424 ,
       0.40920386, 0.09844366, 0.12768782, 0.12058102, 0.26053805,
       0.32475817, 0.17116995, 0.31639993, 0.49863121])
>>> coef
a     -0.556584
aa     0.051429
aab    0.000003
aac    0.021992
aad    0.000415
         ...   
zze   -0.000103
zzi   -0.001919
zzl   -0.000139
zzm   -0.000122
zzy   -0.000091
Length: 5986, dtype: float64
>>> coef.values[np.array(kazvec[kazvec != 0])[0] > 0]
>>> coef.values[kazvec != 0]
>>> type(kazvec != 0)
scipy.sparse.csr.csr_matrix
>>> (kazvec != 0).todense()
matrix([[ True, False, False, ..., False, False, False]])
>>> np.array((kazvec != 0).todense())[0]
array([ True, False, False, ..., False, False, False])
>>> coef[np.array((kazvec != 0).todense())[0] != 0]
a     -0.556584
az    -0.022166
azu   -0.000366
k      0.066347
ka    -0.182166
kaz    0.000030
m     -0.031816
ma    -0.280481
u      0.029682
um    -0.008430
uma    0.000764
z     -0.066873
zu    -0.001613
zum    0.000006
dtype: float64
>>> model.predict(kazvec)
array(['F'], dtype=object)
>>> model.predict_proba(kazvec)
array([[0.51219282, 0.48780718]])
>>> pd.Series(model.predict_proba(vectorizer.transform(names))[:,1], index=names)
Maria       0.381240
Aditi       0.477269
Jessica     0.483249
Olessya     0.499430
Una         0.481148
Hanna       0.426783
Winnie      0.484074
Olessya     0.499430
Sylvia      0.484732
Vish        0.516631
Mohammed    0.569390
Jon         0.619116
John        0.678048
Ted         0.546004
Kazuma      0.487807
Meijke      0.528277
Kemal       0.494326
dtype: float64
>>> model.classes_
array(['F', 'M'], dtype=object)
>>> hist
>>> hist -o -p -f kemal_kazuma_labeled_female.md
```