# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ContactChannelTargetInfo',
    'ContactStage',
    'ContactTargetInfo',
    'ContactTargets',
    'PlanChannelTargetInfo',
    'PlanContactTargetInfo',
    'PlanStage',
    'PlanTargets',
    'RotationCoverageTime',
    'RotationMonthlySetting',
    'RotationRecurrenceSettings',
    'RotationShiftCoverage',
    'RotationTag',
    'RotationWeeklySetting',
]

@pulumi.output_type
class ContactChannelTargetInfo(dict):
    """
    Information about the contact channel that SSM Incident Manager uses to engage the contact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"
        elif key == "retryIntervalInMinutes":
            suggest = "retry_interval_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactChannelTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactChannelTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactChannelTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: str,
                 retry_interval_in_minutes: int):
        """
        Information about the contact channel that SSM Incident Manager uses to engage the contact.
        :param str channel_id: The Amazon Resource Name (ARN) of the contact channel.
        :param int retry_interval_in_minutes: The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact channel.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> int:
        """
        The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        return pulumi.get(self, "retry_interval_in_minutes")


@pulumi.output_type
class ContactStage(dict):
    """
    A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMinutes":
            suggest = "duration_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_minutes: int,
                 targets: Optional[Sequence['outputs.ContactTargets']] = None):
        """
        A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
        :param int duration_in_minutes: The time to wait until beginning the next stage.
        :param Sequence['ContactTargets'] targets: The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> int:
        """
        The time to wait until beginning the next stage.
        """
        return pulumi.get(self, "duration_in_minutes")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.ContactTargets']]:
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class ContactTargetInfo(dict):
    """
    The contact that SSM Incident Manager is engaging during an incident.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactId":
            suggest = "contact_id"
        elif key == "isEssential":
            suggest = "is_essential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_id: str,
                 is_essential: bool):
        """
        The contact that SSM Incident Manager is engaging during an incident.
        :param str contact_id: The Amazon Resource Name (ARN) of the contact.
        :param bool is_essential: A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "is_essential", is_essential)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "contact_id")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        """
        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        return pulumi.get(self, "is_essential")


@pulumi.output_type
class ContactTargets(dict):
    """
    The contacts or contact methods that the escalation plan or engagement plan is engaging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTargetInfo":
            suggest = "channel_target_info"
        elif key == "contactTargetInfo":
            suggest = "contact_target_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_target_info: Optional['outputs.ContactChannelTargetInfo'] = None,
                 contact_target_info: Optional['outputs.ContactTargetInfo'] = None):
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        if channel_target_info is not None:
            pulumi.set(__self__, "channel_target_info", channel_target_info)
        if contact_target_info is not None:
            pulumi.set(__self__, "contact_target_info", contact_target_info)

    @property
    @pulumi.getter(name="channelTargetInfo")
    def channel_target_info(self) -> Optional['outputs.ContactChannelTargetInfo']:
        return pulumi.get(self, "channel_target_info")

    @property
    @pulumi.getter(name="contactTargetInfo")
    def contact_target_info(self) -> Optional['outputs.ContactTargetInfo']:
        return pulumi.get(self, "contact_target_info")


@pulumi.output_type
class PlanChannelTargetInfo(dict):
    """
    Information about the contact channel that SSM Incident Manager uses to engage the contact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"
        elif key == "retryIntervalInMinutes":
            suggest = "retry_interval_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanChannelTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanChannelTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanChannelTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: str,
                 retry_interval_in_minutes: int):
        """
        Information about the contact channel that SSM Incident Manager uses to engage the contact.
        :param str channel_id: The Amazon Resource Name (ARN) of the contact channel.
        :param int retry_interval_in_minutes: The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact channel.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> int:
        """
        The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        return pulumi.get(self, "retry_interval_in_minutes")


@pulumi.output_type
class PlanContactTargetInfo(dict):
    """
    The contact that SSM Incident Manager is engaging during an incident.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactId":
            suggest = "contact_id"
        elif key == "isEssential":
            suggest = "is_essential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanContactTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanContactTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanContactTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_id: str,
                 is_essential: bool):
        """
        The contact that SSM Incident Manager is engaging during an incident.
        :param str contact_id: The Amazon Resource Name (ARN) of the contact.
        :param bool is_essential: A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "is_essential", is_essential)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "contact_id")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        """
        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        return pulumi.get(self, "is_essential")


@pulumi.output_type
class PlanStage(dict):
    """
    A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMinutes":
            suggest = "duration_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_minutes: int,
                 targets: Optional[Sequence['outputs.PlanTargets']] = None):
        """
        A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
        :param int duration_in_minutes: The time to wait until beginning the next stage.
        :param Sequence['PlanTargets'] targets: The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> int:
        """
        The time to wait until beginning the next stage.
        """
        return pulumi.get(self, "duration_in_minutes")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.PlanTargets']]:
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class PlanTargets(dict):
    """
    The contacts or contact methods that the escalation plan or engagement plan is engaging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTargetInfo":
            suggest = "channel_target_info"
        elif key == "contactTargetInfo":
            suggest = "contact_target_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_target_info: Optional['outputs.PlanChannelTargetInfo'] = None,
                 contact_target_info: Optional['outputs.PlanContactTargetInfo'] = None):
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        if channel_target_info is not None:
            pulumi.set(__self__, "channel_target_info", channel_target_info)
        if contact_target_info is not None:
            pulumi.set(__self__, "contact_target_info", contact_target_info)

    @property
    @pulumi.getter(name="channelTargetInfo")
    def channel_target_info(self) -> Optional['outputs.PlanChannelTargetInfo']:
        return pulumi.get(self, "channel_target_info")

    @property
    @pulumi.getter(name="contactTargetInfo")
    def contact_target_info(self) -> Optional['outputs.PlanContactTargetInfo']:
        return pulumi.get(self, "contact_target_info")


@pulumi.output_type
class RotationCoverageTime(dict):
    """
    StartTime and EndTime for the Shift
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RotationCoverageTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RotationCoverageTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RotationCoverageTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        StartTime and EndTime for the Shift
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class RotationMonthlySetting(dict):
    """
    DayOfWeek for Month and HandOff Time for Monthly Recurring Rotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonth":
            suggest = "day_of_month"
        elif key == "handOffTime":
            suggest = "hand_off_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RotationMonthlySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RotationMonthlySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RotationMonthlySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_month: int,
                 hand_off_time: str):
        """
        DayOfWeek for Month and HandOff Time for Monthly Recurring Rotation.
        :param int day_of_month: The day of the month when monthly recurring on-call rotations begin.
        """
        pulumi.set(__self__, "day_of_month", day_of_month)
        pulumi.set(__self__, "hand_off_time", hand_off_time)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> int:
        """
        The day of the month when monthly recurring on-call rotations begin.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="handOffTime")
    def hand_off_time(self) -> str:
        return pulumi.get(self, "hand_off_time")


@pulumi.output_type
class RotationRecurrenceSettings(dict):
    """
    Information about when an on-call rotation is in effect and how long the rotation period lasts.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySettings":
            suggest = "daily_settings"
        elif key == "monthlySettings":
            suggest = "monthly_settings"
        elif key == "numberOfOnCalls":
            suggest = "number_of_on_calls"
        elif key == "recurrenceMultiplier":
            suggest = "recurrence_multiplier"
        elif key == "shiftCoverages":
            suggest = "shift_coverages"
        elif key == "weeklySettings":
            suggest = "weekly_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RotationRecurrenceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RotationRecurrenceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RotationRecurrenceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_settings: Optional[Sequence[str]] = None,
                 monthly_settings: Optional[Sequence['outputs.RotationMonthlySetting']] = None,
                 number_of_on_calls: Optional[int] = None,
                 recurrence_multiplier: Optional[int] = None,
                 shift_coverages: Optional[Sequence['outputs.RotationShiftCoverage']] = None,
                 weekly_settings: Optional[Sequence['outputs.RotationWeeklySetting']] = None):
        """
        Information about when an on-call rotation is in effect and how long the rotation period lasts.
        :param Sequence[str] daily_settings: Information about on-call rotations that recur daily.
        :param Sequence['RotationMonthlySetting'] monthly_settings: Information about on-call rotations that recur monthly.
        :param int number_of_on_calls: Number of Oncalls per shift.
        :param int recurrence_multiplier: The number of days, weeks, or months a single rotation lasts.
        :param Sequence['RotationShiftCoverage'] shift_coverages: Information about the days of the week included in on-call rotation coverage.
        :param Sequence['RotationWeeklySetting'] weekly_settings: Information about on-call rotations that recur weekly.
        """
        if daily_settings is not None:
            pulumi.set(__self__, "daily_settings", daily_settings)
        if monthly_settings is not None:
            pulumi.set(__self__, "monthly_settings", monthly_settings)
        if number_of_on_calls is not None:
            pulumi.set(__self__, "number_of_on_calls", number_of_on_calls)
        if recurrence_multiplier is not None:
            pulumi.set(__self__, "recurrence_multiplier", recurrence_multiplier)
        if shift_coverages is not None:
            pulumi.set(__self__, "shift_coverages", shift_coverages)
        if weekly_settings is not None:
            pulumi.set(__self__, "weekly_settings", weekly_settings)

    @property
    @pulumi.getter(name="dailySettings")
    def daily_settings(self) -> Optional[Sequence[str]]:
        """
        Information about on-call rotations that recur daily.
        """
        return pulumi.get(self, "daily_settings")

    @property
    @pulumi.getter(name="monthlySettings")
    def monthly_settings(self) -> Optional[Sequence['outputs.RotationMonthlySetting']]:
        """
        Information about on-call rotations that recur monthly.
        """
        return pulumi.get(self, "monthly_settings")

    @property
    @pulumi.getter(name="numberOfOnCalls")
    def number_of_on_calls(self) -> Optional[int]:
        """
        Number of Oncalls per shift.
        """
        return pulumi.get(self, "number_of_on_calls")

    @property
    @pulumi.getter(name="recurrenceMultiplier")
    def recurrence_multiplier(self) -> Optional[int]:
        """
        The number of days, weeks, or months a single rotation lasts.
        """
        return pulumi.get(self, "recurrence_multiplier")

    @property
    @pulumi.getter(name="shiftCoverages")
    def shift_coverages(self) -> Optional[Sequence['outputs.RotationShiftCoverage']]:
        """
        Information about the days of the week included in on-call rotation coverage.
        """
        return pulumi.get(self, "shift_coverages")

    @property
    @pulumi.getter(name="weeklySettings")
    def weekly_settings(self) -> Optional[Sequence['outputs.RotationWeeklySetting']]:
        """
        Information about on-call rotations that recur weekly.
        """
        return pulumi.get(self, "weekly_settings")


@pulumi.output_type
class RotationShiftCoverage(dict):
    """
    Information about the days of the week included in on-call rotation coverage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coverageTimes":
            suggest = "coverage_times"
        elif key == "dayOfWeek":
            suggest = "day_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RotationShiftCoverage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RotationShiftCoverage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RotationShiftCoverage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 coverage_times: Sequence['outputs.RotationCoverageTime'],
                 day_of_week: 'RotationDayOfWeek'):
        """
        Information about the days of the week included in on-call rotation coverage.
        :param Sequence['RotationCoverageTime'] coverage_times: Information about when an on-call shift begins and ends.
        """
        pulumi.set(__self__, "coverage_times", coverage_times)
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="coverageTimes")
    def coverage_times(self) -> Sequence['outputs.RotationCoverageTime']:
        """
        Information about when an on-call shift begins and ends.
        """
        return pulumi.get(self, "coverage_times")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> 'RotationDayOfWeek':
        return pulumi.get(self, "day_of_week")


@pulumi.output_type
class RotationTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag
        :param str value: The value for the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RotationWeeklySetting(dict):
    """
    DayOfWeek for Rotation and HandOff Time for Weekly Recurring Rotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "handOffTime":
            suggest = "hand_off_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RotationWeeklySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RotationWeeklySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RotationWeeklySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: 'RotationDayOfWeek',
                 hand_off_time: str):
        """
        DayOfWeek for Rotation and HandOff Time for Weekly Recurring Rotation.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hand_off_time", hand_off_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> 'RotationDayOfWeek':
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="handOffTime")
    def hand_off_time(self) -> str:
        return pulumi.get(self, "hand_off_time")


