# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetDashboardResult',
    'AwaitableGetDashboardResult',
    'get_dashboard',
    'get_dashboard_output',
]

@pulumi.output_type
class GetDashboardResult:
    def __init__(__self__, arn=None, last_published_time=None, name=None, permissions=None, tags=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if last_published_time and not isinstance(last_published_time, str):
            raise TypeError("Expected argument 'last_published_time' to be a str")
        pulumi.set(__self__, "last_published_time", last_published_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, dict):
            raise TypeError("Expected argument 'version' to be a dict")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="lastPublishedTime")
    def last_published_time(self) -> Optional[str]:
        return pulumi.get(self, "last_published_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['outputs.DashboardResourcePermission']]:
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DashboardTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> Optional['outputs.DashboardVersion']:
        return pulumi.get(self, "version")


class AwaitableGetDashboardResult(GetDashboardResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDashboardResult(
            arn=self.arn,
            last_published_time=self.last_published_time,
            name=self.name,
            permissions=self.permissions,
            tags=self.tags,
            version=self.version)


def get_dashboard(aws_account_id: Optional[str] = None,
                  dashboard_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDashboardResult:
    """
    Definition of the AWS::QuickSight::Dashboard Resource Type.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['dashboardId'] = dashboard_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:quicksight:getDashboard', __args__, opts=opts, typ=GetDashboardResult).value

    return AwaitableGetDashboardResult(
        arn=__ret__.arn,
        last_published_time=__ret__.last_published_time,
        name=__ret__.name,
        permissions=__ret__.permissions,
        tags=__ret__.tags,
        version=__ret__.version)


@_utilities.lift_output_func(get_dashboard)
def get_dashboard_output(aws_account_id: Optional[pulumi.Input[str]] = None,
                         dashboard_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDashboardResult]:
    """
    Definition of the AWS::QuickSight::Dashboard Resource Type.
    """
    ...
