# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetReferenceStoreResult',
    'AwaitableGetReferenceStoreResult',
    'get_reference_store',
    'get_reference_store_output',
]

@pulumi.output_type
class GetReferenceStoreResult:
    def __init__(__self__, arn=None, creation_time=None, reference_store_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if reference_store_id and not isinstance(reference_store_id, str):
            raise TypeError("Expected argument 'reference_store_id' to be a str")
        pulumi.set(__self__, "reference_store_id", reference_store_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The store's ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        When the store was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="referenceStoreId")
    def reference_store_id(self) -> Optional[str]:
        return pulumi.get(self, "reference_store_id")


class AwaitableGetReferenceStoreResult(GetReferenceStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReferenceStoreResult(
            arn=self.arn,
            creation_time=self.creation_time,
            reference_store_id=self.reference_store_id)


def get_reference_store(reference_store_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReferenceStoreResult:
    """
    Definition of AWS::Omics::ReferenceStore Resource Type
    """
    __args__ = dict()
    __args__['referenceStoreId'] = reference_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:omics:getReferenceStore', __args__, opts=opts, typ=GetReferenceStoreResult).value

    return AwaitableGetReferenceStoreResult(
        arn=__ret__.arn,
        creation_time=__ret__.creation_time,
        reference_store_id=__ret__.reference_store_id)


@_utilities.lift_output_func(get_reference_store)
def get_reference_store_output(reference_store_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReferenceStoreResult]:
    """
    Definition of AWS::Omics::ReferenceStore Resource Type
    """
    ...
