# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['WirelessDeviceImportTaskArgs', 'WirelessDeviceImportTask']

@pulumi.input_type
class WirelessDeviceImportTaskArgs:
    def __init__(__self__, *,
                 destination_name: pulumi.Input[str],
                 sidewalk: pulumi.Input['SidewalkPropertiesArgs'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceImportTaskTagArgs']]]] = None):
        """
        The set of arguments for constructing a WirelessDeviceImportTask resource.
        :param pulumi.Input[str] destination_name: Destination Name for import task
        :param pulumi.Input['SidewalkPropertiesArgs'] sidewalk: sidewalk contain file for created device and role
        :param pulumi.Input[Sequence[pulumi.Input['WirelessDeviceImportTaskTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "destination_name", destination_name)
        pulumi.set(__self__, "sidewalk", sidewalk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Input[str]:
        """
        Destination Name for import task
        """
        return pulumi.get(self, "destination_name")

    @destination_name.setter
    def destination_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_name", value)

    @property
    @pulumi.getter
    def sidewalk(self) -> pulumi.Input['SidewalkPropertiesArgs']:
        """
        sidewalk contain file for created device and role
        """
        return pulumi.get(self, "sidewalk")

    @sidewalk.setter
    def sidewalk(self, value: pulumi.Input['SidewalkPropertiesArgs']):
        pulumi.set(self, "sidewalk", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceImportTaskTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceImportTaskTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""WirelessDeviceImportTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class WirelessDeviceImportTask(pulumi.CustomResource):
    warnings.warn("""WirelessDeviceImportTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 sidewalk: Optional[pulumi.Input[pulumi.InputType['SidewalkPropertiesArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceImportTaskTagArgs']]]]] = None,
                 __props__=None):
        """
        Wireless Device Import Tasks

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_name: Destination Name for import task
        :param pulumi.Input[pulumi.InputType['SidewalkPropertiesArgs']] sidewalk: sidewalk contain file for created device and role
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceImportTaskTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessDeviceImportTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Wireless Device Import Tasks

        :param str resource_name: The name of the resource.
        :param WirelessDeviceImportTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessDeviceImportTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 sidewalk: Optional[pulumi.Input[pulumi.InputType['SidewalkPropertiesArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceImportTaskTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""WirelessDeviceImportTask is deprecated: WirelessDeviceImportTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessDeviceImportTaskArgs.__new__(WirelessDeviceImportTaskArgs)

            if destination_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_name'")
            __props__.__dict__["destination_name"] = destination_name
            if sidewalk is None and not opts.urn:
                raise TypeError("Missing required property 'sidewalk'")
            __props__.__dict__["sidewalk"] = sidewalk
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["failed_imported_devices_count"] = None
            __props__.__dict__["initialized_imported_devices_count"] = None
            __props__.__dict__["onboarded_imported_devices_count"] = None
            __props__.__dict__["pending_imported_devices_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
        super(WirelessDeviceImportTask, __self__).__init__(
            'aws-native:iotwireless:WirelessDeviceImportTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WirelessDeviceImportTask':
        """
        Get an existing WirelessDeviceImportTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WirelessDeviceImportTaskArgs.__new__(WirelessDeviceImportTaskArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["creation_date"] = None
        __props__.__dict__["destination_name"] = None
        __props__.__dict__["failed_imported_devices_count"] = None
        __props__.__dict__["initialized_imported_devices_count"] = None
        __props__.__dict__["onboarded_imported_devices_count"] = None
        __props__.__dict__["pending_imported_devices_count"] = None
        __props__.__dict__["sidewalk"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_reason"] = None
        __props__.__dict__["tags"] = None
        return WirelessDeviceImportTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Arn for Wireless Device Import Task, Returned upon successful start.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        """
        CreationDate for import task
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Output[str]:
        """
        Destination Name for import task
        """
        return pulumi.get(self, "destination_name")

    @property
    @pulumi.getter(name="failedImportedDevicesCount")
    def failed_imported_devices_count(self) -> pulumi.Output[int]:
        """
        Failed Imported Devices Count
        """
        return pulumi.get(self, "failed_imported_devices_count")

    @property
    @pulumi.getter(name="initializedImportedDevicesCount")
    def initialized_imported_devices_count(self) -> pulumi.Output[int]:
        """
        Initialized Imported Devices Count
        """
        return pulumi.get(self, "initialized_imported_devices_count")

    @property
    @pulumi.getter(name="onboardedImportedDevicesCount")
    def onboarded_imported_devices_count(self) -> pulumi.Output[int]:
        """
        Onboarded Imported Devices Count
        """
        return pulumi.get(self, "onboarded_imported_devices_count")

    @property
    @pulumi.getter(name="pendingImportedDevicesCount")
    def pending_imported_devices_count(self) -> pulumi.Output[int]:
        """
        Pending Imported Devices Count
        """
        return pulumi.get(self, "pending_imported_devices_count")

    @property
    @pulumi.getter
    def sidewalk(self) -> pulumi.Output['outputs.SidewalkProperties']:
        """
        sidewalk contain file for created device and role
        """
        return pulumi.get(self, "sidewalk")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['WirelessDeviceImportTaskStatus']:
        """
        Status for import task
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[str]:
        """
        StatusReason for import task
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.WirelessDeviceImportTaskTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

