# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory
try:
    from typing import Literal
except Exception:
    from typing_extensions import Literal


class Market(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    def add(self, owner_id: int, name: str, description: str, category_id: int, main_photo_id: int, price: Optional[float] = None, old_price: Optional[float] = None, deleted: Optional[bool] = None, photo_ids: Optional[List[int]] = None, url: Optional[str] = None, dimension_width: Optional[int] = None, dimension_height: Optional[int] = None, dimension_length: Optional[int] = None, weight: Optional[int] = None) -> responses.MarketAdd:
        """
        Ads a new item to the market.
        
        :param owner_id: ID of an item owner community.
        :param name: Item name.
        :param description: Item description.
        :param category_id: Item category ID.
        :param main_photo_id: Cover photo ID.
        :param price: Item price.
        :param old_price:
        :param deleted: Item status ('1' — deleted, '0' — not deleted).
        :param photo_ids: IDs of additional photos.
        :param url: Url for button in market item.
        :param dimension_width:
        :param dimension_height:
        :param dimension_length:
        :param weight:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.add'
        response_type = responses.MarketAdd
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def add_album(self, owner_id: int, title: str, photo_id: Optional[int] = None, main_album: Optional[bool] = None) -> responses.MarketAddAlbum:
        """
        Creates new collection of items
        
        :param owner_id: ID of an item owner community.
        :param title: Collection title.
        :param photo_id: Cover photo ID.
        :param main_album: Set as main ('1' – set, '0' – no).
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.addAlbum'
        response_type = responses.MarketAddAlbum
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def add_to_album(self, owner_id: int, item_id: int, album_ids: List[int]) -> responses.BaseOk:
        """
        Adds an item to one or multiple collections.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param album_ids: Collections IDs to add item to.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.addToAlbum'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def create_comment(self, owner_id: int, item_id: int, message: Optional[str] = None, attachments: Optional[List[str]] = None, from_group: Optional[bool] = None, reply_to_comment: Optional[int] = None, sticker_id: Optional[int] = None, guid: Optional[str] = None) -> responses.MarketCreateComment:
        """
        Creates a new comment for an item.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param message: Comment text (required if 'attachments' parameter is not specified)
        :param attachments: Comma-separated list of objects attached to a comment. The field is submitted the following way: , "'<owner_id>_<media_id>,<owner_id>_<media_id>'", , '' - media attachment type: "'photo' - photo, 'video' - video, 'audio' - audio, 'doc' - document", , '<owner_id>' - media owner id, '<media_id>' - media attachment id, , For example: "photo100172_166443618,photo66748_265827614",
        :param from_group: '1' - comment will be published on behalf of a community, '0' - on behalf of a user (by default).
        :param reply_to_comment: ID of a comment to reply with current comment to.
        :param sticker_id: Sticker ID.
        :param guid: Random value to avoid resending one comment.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.createComment'
        response_type = responses.MarketCreateComment
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def delete(self, owner_id: int, item_id: int) -> responses.BaseOk:
        """
        Deletes an item.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.delete'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def delete_album(self, owner_id: int, album_id: int) -> responses.BaseOk:
        """
        Deletes a collection of items.
        
        :param owner_id: ID of an collection owner community.
        :param album_id: Collection ID.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.deleteAlbum'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def delete_comment(self, owner_id: int, comment_id: int) -> responses.MarketDeleteComment:
        """
        Deletes an item's comment
        
        :param owner_id: identifier of an item owner community, "Note that community id in the 'owner_id' parameter should be negative number. For example 'owner_id'=-1 matches the [vk.com/apiclub|VK API] community "
        :param comment_id: comment id
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.deleteComment'
        response_type = responses.MarketDeleteComment
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def edit(self, owner_id: int, item_id: int, name: str, description: str, category_id: int, price: float, main_photo_id: int, deleted: Optional[bool] = None, photo_ids: Optional[List[int]] = None, url: Optional[str] = None) -> responses.BaseOk:
        """
        Edits an item.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param name: Item name.
        :param description: Item description.
        :param category_id: Item category ID.
        :param price: Item price.
        :param main_photo_id: Cover photo ID.
        :param deleted: Item status ('1' — deleted, '0' — not deleted).
        :param photo_ids: IDs of additional photos.
        :param url: Url for button in market item.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.edit'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def edit_album(self, owner_id: int, album_id: int, title: str, photo_id: Optional[int] = None, main_album: Optional[bool] = None) -> responses.BaseOk:
        """
        Edits a collection of items
        
        :param owner_id: ID of an collection owner community.
        :param album_id: Collection ID.
        :param title: Collection title.
        :param photo_id: Cover photo id
        :param main_album: Set as main ('1' – set, '0' – no).
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.editAlbum'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def edit_comment(self, owner_id: int, comment_id: int, message: Optional[str] = None, attachments: Optional[List[str]] = None) -> responses.BaseOk:
        """
        Chages item comment's text
        
        :param owner_id: ID of an item owner community.
        :param comment_id: Comment ID.
        :param message: New comment text (required if 'attachments' are not specified), , 2048 symbols maximum.
        :param attachments: Comma-separated list of objects attached to a comment. The field is submitted the following way: , "'<owner_id>_<media_id>,<owner_id>_<media_id>'", , '' - media attachment type: "'photo' - photo, 'video' - video, 'audio' - audio, 'doc' - document", , '<owner_id>' - media owner id, '<media_id>' - media attachment id, , For example: "photo100172_166443618,photo66748_265827614",
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.editComment'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    @overload
    def get(self, owner_id: int, album_id: Optional[int] = None, count: Optional[int] = None, offset: Optional[int] = None, extended: None = None) -> responses.MarketGet: ...
    @overload
    def get(self, owner_id: int, extended: bool, album_id: Optional[int] = None, count: Optional[int] = None, offset: Optional[int] = None) -> responses.MarketGetExtended: ...
    def get(self, owner_id: int, album_id: Optional[int] = None, count: Optional[int] = None, offset: Optional[int] = None, extended: Optional[bool] = None):
        """
        Returns items list for a community.
        
        :param owner_id: ID of an item owner community, "Note that community id in the 'owner_id' parameter should be negative number. For example 'owner_id'=-1 matches the [vk.com/apiclub|VK API] community "
        :param album_id:
        :param count: Number of items to return.
        :param offset: Offset needed to return a specific subset of results.
        :param extended: '1' – method will return additional fields: 'likes, can_comment, car_repost, photos'. These parameters are not returned by default.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.get'
        if not extended:
            response_type = responses.MarketGet
        if extended:
            response_type = responses.MarketGetExtended
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_album_by_id(self, owner_id: int, album_ids: List[int]) -> responses.MarketGetAlbumById:
        """
        Returns items album's data
        
        :param owner_id: identifier of an album owner community, "Note that community id in the 'owner_id' parameter should be negative number. For example 'owner_id'=-1 matches the [vk.com/apiclub|VK API] community "
        :param album_ids: collections identifiers to obtain data from
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.getAlbumById'
        response_type = responses.MarketGetAlbumById
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_albums(self, owner_id: int, offset: Optional[int] = None, count: Optional[int] = None) -> responses.MarketGetAlbums:
        """
        Returns community's collections list.
        
        :param owner_id: ID of an items owner community.
        :param offset: Offset needed to return a specific subset of results.
        :param count: Number of items to return.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.getAlbums'
        response_type = responses.MarketGetAlbums
        return self._call(method_name, method_parameters, param_aliases, response_type)

    @overload
    def get_by_id(self, item_ids: List[str], extended: None = None) -> responses.MarketGetById: ...
    @overload
    def get_by_id(self, item_ids: List[str], extended: bool) -> responses.MarketGetByIdExtended: ...
    def get_by_id(self, item_ids: List[str], extended: Optional[bool] = None):
        """
        Returns information about market items by their ids.
        
        :param item_ids: Comma-separated ids list: {user id}_{item id}. If an item belongs to a community -{community id} is used. " 'Videos' value example: , '-4363_136089719,13245770_137352259'"
        :param extended: '1' – to return additional fields: 'likes, can_comment, car_repost, photos'. By default: '0'.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.getById'
        if not extended:
            response_type = responses.MarketGetById
        if extended:
            response_type = responses.MarketGetByIdExtended
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_categories(self, count: Optional[int] = None, offset: Optional[int] = None) -> responses.MarketGetCategories:
        """
        Returns a list of market categories.
        
        :param count: Number of results to return.
        :param offset: Offset needed to return a specific subset of results.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.getCategories'
        response_type = responses.MarketGetCategories
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_comments(self, owner_id: int, item_id: int, need_likes: Optional[bool] = None, start_comment_id: Optional[int] = None, offset: Optional[int] = None, count: Optional[int] = None, sort: Optional[str] = None, extended: Optional[bool] = None, fields: Optional[List[Union[objects.UsersFields, str]]] = None) -> responses.MarketGetComments:
        """
        Returns comments list for an item.
        
        :param owner_id: ID of an item owner community
        :param item_id: Item ID.
        :param need_likes: '1' — to return likes info.
        :param start_comment_id: ID of a comment to start a list from (details below).
        :param offset:
        :param count: Number of results to return.
        :param sort: Sort order ('asc' — from old to new, 'desc' — from new to old)
        :param extended: '1' — comments will be returned as numbered objects, in addition lists of 'profiles' and 'groups' objects will be returned.
        :param fields: List of additional profile fields to return. See the [vk.com/dev/fields|details]
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.getComments'
        response_type = responses.MarketGetComments
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def remove_from_album(self, owner_id: int, item_id: int, album_ids: List[int]) -> responses.BaseOk:
        """
        Removes an item from one or multiple collections.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param album_ids: Collections IDs to remove item from.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.removeFromAlbum'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def reorder_albums(self, owner_id: int, album_id: int, before: Optional[int] = None, after: Optional[int] = None) -> responses.BaseOk:
        """
        Reorders the collections list.
        
        :param owner_id: ID of an item owner community.
        :param album_id: Collection ID.
        :param before: ID of a collection to place current collection before it.
        :param after: ID of a collection to place current collection after it.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.reorderAlbums'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def reorder_items(self, owner_id: int, item_id: int, album_id: Optional[int] = None, before: Optional[int] = None, after: Optional[int] = None) -> responses.BaseOk:
        """
        Changes item place in a collection.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param album_id: ID of a collection to reorder items in. Set 0 to reorder full items list.
        :param before: ID of an item to place current item before it.
        :param after: ID of an item to place current item after it.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.reorderItems'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def report(self, owner_id: int, item_id: int, reason: Optional[int] = None) -> responses.BaseOk:
        """
        Sends a complaint to the item.
        
        :param owner_id: ID of an item owner community.
        :param item_id: Item ID.
        :param reason: Complaint reason. Possible values: *'0' — spam,, *'1' — child porn,, *'2' — extremism,, *'3' — violence,, *'4' — drugs propaganda,, *'5' — adult materials,, *'6' — insult.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.report'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def report_comment(self, owner_id: int, comment_id: int, reason: int) -> responses.BaseOk:
        """
        Sends a complaint to the item's comment.
        
        :param owner_id: ID of an item owner community.
        :param comment_id: Comment ID.
        :param reason: Complaint reason. Possible values: *'0' — spam,, *'1' — child porn,, *'2' — extremism,, *'3' — violence,, *'4' — drugs propaganda,, *'5' — adult materials,, *'6' — insult.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.reportComment'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def restore(self, owner_id: int, item_id: int) -> responses.BaseOk:
        """
        Restores recently deleted item
        
        :param owner_id: ID of an item owner community.
        :param item_id: Deleted item ID.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.restore'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def restore_comment(self, owner_id: int, comment_id: int) -> responses.MarketRestoreComment:
        """
        Restores a recently deleted comment
        
        :param owner_id: identifier of an item owner community, "Note that community id in the 'owner_id' parameter should be negative number. For example 'owner_id'=-1 matches the [vk.com/apiclub|VK API] community "
        :param comment_id: deleted comment id
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.restoreComment'
        response_type = responses.MarketRestoreComment
        return self._call(method_name, method_parameters, param_aliases, response_type)

    @overload
    def search(self, owner_id: int, album_id: Optional[int] = None, q: Optional[str] = None, price_from: Optional[int] = None, price_to: Optional[int] = None, sort: Optional[int] = None, rev: Optional[int] = None, offset: Optional[int] = None, count: Optional[int] = None, extended: None = None, status: Optional[int] = None) -> responses.MarketSearch: ...
    @overload
    def search(self, owner_id: int, extended: bool, album_id: Optional[int] = None, q: Optional[str] = None, price_from: Optional[int] = None, price_to: Optional[int] = None, sort: Optional[int] = None, rev: Optional[int] = None, offset: Optional[int] = None, count: Optional[int] = None, status: Optional[int] = None) -> responses.MarketSearchExtended: ...
    def search(self, owner_id: int, album_id: Optional[int] = None, q: Optional[str] = None, price_from: Optional[int] = None, price_to: Optional[int] = None, sort: Optional[int] = None, rev: Optional[int] = None, offset: Optional[int] = None, count: Optional[int] = None, extended: Optional[bool] = None, status: Optional[int] = None):
        """
        Searches market items in a community's catalog
        
        :param owner_id: ID of an items owner community.
        :param album_id:
        :param q: Search query, for example "pink slippers".
        :param price_from: Minimum item price value.
        :param price_to: Maximum item price value.
        :param sort:
        :param rev: '0' — do not use reverse order, '1' — use reverse order
        :param offset: Offset needed to return a specific subset of results.
        :param count: Number of items to return.
        :param extended: '1' – to return additional fields: 'likes, can_comment, car_repost, photos'. By default: '0'.
        :param status:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'market.search'
        if not extended:
            response_type = responses.MarketSearch
        if extended:
            response_type = responses.MarketSearchExtended
        return self._call(method_name, method_parameters, param_aliases, response_type)
