# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataSourceMetadata(Model):
    """Represents metadata for a Customer Insights data source.

    :param kind: Possible values include: 'salesforce', 'dynamics365',
     'powerQuery', 'attachCdm', 'attachSynapse', 'attachCds', 'powerPlatform',
     'datahub', 'firstParty'
    :type kind: str or ~dynamics.customerinsights.api.models.enum
    :param is_active: Represents if still in active state
    :type is_active: bool
    :param entity_names: List of all Entity Names
    :type entity_names: list[str]
    :param entities_count:
    :type entities_count: int
    :param data_source_id: Unique identity for this object.
    :type data_source_id: str
    :param name: Unique name of the dataSource.
    :type name: str
    :param friendly_name: FriendlyName of the dataSource.
    :type friendly_name: str
    :param entity_information: Entity information, by entity name.
    :type entity_information:
     list[~dynamics.customerinsights.api.models.DatasourceEntityInformation]
    :param provisioning_state: Possible values include: 'new', 'creating',
     'active', 'createFailed', 'updateFailed', 'deleting',
     'refreshCredentials', 'resetInstanceInProgress', 'updating',
     'quickUpdate', 'deactivated'
    :type provisioning_state: str or
     ~dynamics.customerinsights.api.models.enum
    :param last_refresh: Represents the time datasource was last refreshed.
    :type last_refresh: datetime
    :param refresh_state: Possible values include: 'notUpdated', 'updated',
     'updating', 'updateFailed', 'updateCancelled'
    :type refresh_state: str or ~dynamics.customerinsights.api.models.enum
    :param incremental_refresh_properties: Incremental refresh properties for
     entities.
    :type incremental_refresh_properties:
     list[~dynamics.customerinsights.api.models.IncrementalRefreshProperties]
    :param model_json_path: Model path for CDM data source.
    :type model_json_path: str
    :param version: Version number of this object.
    :type version: long
    :param updated_by: UPN of the user who last updated this record.
    :type updated_by: str
    :param updated_utc: Time this object was last updated.
    :type updated_utc: datetime
    :param created_by: Email address of the user who created this record.
    :type created_by: str
    :param created_utc: Time this object was initially created.
    :type created_utc: datetime
    :param instance_id: Customer Insights instance id associated with this
     object.
    :type instance_id: str
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'entity_names': {'key': 'entityNames', 'type': '[str]'},
        'entities_count': {'key': 'entitiesCount', 'type': 'int'},
        'data_source_id': {'key': 'dataSourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'entity_information': {'key': 'entityInformation', 'type': '[DatasourceEntityInformation]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'last_refresh': {'key': 'lastRefresh', 'type': 'iso-8601'},
        'refresh_state': {'key': 'refreshState', 'type': 'str'},
        'incremental_refresh_properties': {'key': 'incrementalRefreshProperties', 'type': '[IncrementalRefreshProperties]'},
        'model_json_path': {'key': 'modelJsonPath', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'updated_utc': {'key': 'updatedUtc', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_utc': {'key': 'createdUtc', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataSourceMetadata, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.is_active = kwargs.get('is_active', None)
        self.entity_names = kwargs.get('entity_names', None)
        self.entities_count = kwargs.get('entities_count', None)
        self.data_source_id = kwargs.get('data_source_id', None)
        self.name = kwargs.get('name', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.entity_information = kwargs.get('entity_information', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.last_refresh = kwargs.get('last_refresh', None)
        self.refresh_state = kwargs.get('refresh_state', None)
        self.incremental_refresh_properties = kwargs.get('incremental_refresh_properties', None)
        self.model_json_path = kwargs.get('model_json_path', None)
        self.version = kwargs.get('version', None)
        self.updated_by = kwargs.get('updated_by', None)
        self.updated_utc = kwargs.get('updated_utc', None)
        self.created_by = kwargs.get('created_by', None)
        self.created_utc = kwargs.get('created_utc', None)
        self.instance_id = kwargs.get('instance_id', None)
