# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

import setuptools_scm
from numpy.typing import DTypeLike

sys.path.insert(0, os.path.abspath("../"))


# -- Project information -----------------------------------------------------

project = "pytest-grunnur"
copyright = "2023–now, Bogdan Opanchuk"
author = "Bogdan Opanchuk"

# The full version, including alpha/beta/rc tags
release = setuptools_scm.get_version(relative_to=os.path.abspath("../pyproject.toml"))


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.viewcode",
]

autoclass_content = "both"
autodoc_member_order = "groupwise"
autodoc_type_aliases = dict(DTypeLike="DTypeLike")

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# Note: set to the lower bound of `numpy` version in the dependencies;
# must be kept synchronized.
intersphinx_mapping = {
    "numpy": ("https://numpy.org/doc/1.22", None),
    "python": ("https://docs.python.org/3", None),
    "grunnur": ("https://grunnur.readthedocs.io/en/v0.3.0/", None),
}

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

nitpick_ignore = [
    # Unfortunately, these are currently not picked up by ``intersphinx``
    # (because of some import magic pytest does) so we have to ignore them.
    ("py:class", "_pytest.config.Config"),
    ("py:class", "_pytest.config.argparsing.Parser"),
    ("py:class", "_pytest.python.Metafunc"),
    ("py:class", "_pytest.fixtures.FixtureRequest"),
]
