"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const datahub_generated_1 = require("./datahub.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return datahub_generated_1.RosTopic; } });
/**
 * A ROS resource type:  `ALIYUN::DATAHUB::Topic`
 */
class Topic extends ros.Resource {
    /**
     * Create a new `ALIYUN::DATAHUB::Topic`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTopic = new datahub_generated_1.RosTopic(this, id, {
            comment: props.comment,
            recordType: props.recordType,
            projectName: props.projectName,
            lifecycle: props.lifecycle === undefined || props.lifecycle === null ? 3 : props.lifecycle,
            recordSchema: props.recordSchema,
            shardCount: props.shardCount === undefined || props.shardCount === null ? 1 : props.shardCount,
            topicName: props.topicName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrProjectName = rosTopic.attrProjectName;
        this.attrTopicName = rosTopic.attrTopicName;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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