/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.rulefit;

import hex.genmodel.MojoModel;
import hex.genmodel.algos.rulefit.MojoRuleEnsemble;
import java.util.Arrays;
import java.util.List;

public class RuleFitMojoModel
extends MojoModel {
    MojoModel _linearModel;
    MojoRuleEnsemble _ruleEnsemble;
    int _depth;
    int _ntrees;
    ModelType _modelType;
    String[] _dataFromRulesCodes;
    String _weightsColumn;
    String[] _linearNames;

    RuleFitMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        double[] linearFromRules = null;
        int testsize = 0;
        if (!this._modelType.equals((Object)ModelType.LINEAR)) {
            linearFromRules = this._ruleEnsemble.transformRow(row, this._depth, this._ntrees, this._linearModel._names, this._linearModel._domains);
            testsize += linearFromRules.length;
            if (this._modelType.equals((Object)ModelType.RULES_AND_LINEAR)) {
                testsize += row.length;
            }
        }
        double[] test = new double[testsize];
        if (this._modelType.equals((Object)ModelType.RULES_AND_LINEAR) || this._modelType.equals((Object)ModelType.RULES)) {
            System.arraycopy(linearFromRules, 0, test, 0, linearFromRules.length);
        }
        if (this._modelType.equals((Object)ModelType.RULES_AND_LINEAR)) {
            System.arraycopy(row, 0, test, linearFromRules.length, row.length);
        }
        if (this._modelType.equals((Object)ModelType.LINEAR)) {
            test = row;
        }
        double[] linearModelInput = this.map(test);
        this._linearModel.score0(linearModelInput, preds);
        return preds;
    }

    double[] map(double[] test) {
        double[] newtest = new double[this._linearModel.nfeatures()];
        List<String> list = Arrays.asList(this._linearModel._names);
        for (int i2 = 0; i2 < this._linearModel.nfeatures(); ++i2) {
            int id = list.indexOf(this._linearNames[i2]);
            newtest[id] = test[i2];
        }
        return newtest;
    }

    public static enum ModelType {
        LINEAR,
        RULES_AND_LINEAR,
        RULES;

    }
}

