# coding: utf-8

"""
    Fincura API

    This [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer) allows you to interact with the Fincura processing and insights engine.   # Authentication  This API uses API keys generated from a Fincura User account. To get access to your User account, speak with you Fincura account manager.  # Accepted Media Types  | File&nbsp;Type&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | Extension(s)     | Content-Type(s) | | -------------------------------- |-------------- | ------------ | | PDF File | .pdf | `application/pdf` , `application/x-pdf` | | Excel File | .xls | `application/vnd.ms-excel`  | | Excel File | .xlsx | `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`  | | Excel File | .xlsm | `application/vnd.ms-excel.sheet.macroEnabled.12`  | | PNG Image | .png | `image/png`  | | GIF Image | .gif | `image/gif`  | | JPG Image | .jpg, .jpeg | `image/jpeg`  | | GIF Image | .gif | `image/gif`  |   # Getting Started  1. [Create a Borrower](#operation/createBorrower)  2. [Add a file](#operation/createDocumentFile) for that Borrower. 3. Analyze in the Fincura App  ****  # noqa: E501

    The version of the OpenAPI document: 1.2.6
    Contact: support@fincura.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

import nulltype  # noqa: F401

from fincura.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from fincura.model.loan_borrower_info import LoanBorrowerInfo
    from fincura.model.loan_compliance_info import LoanComplianceInfo
    from fincura.model.loan_documents import LoanDocuments
    from fincura.model.loan_financials import LoanFinancials
    from fincura.model.loan_guarantors import LoanGuarantors
    from fincura.model.loan_periods import LoanPeriods
    from fincura.model.loan_prior_year_financials import LoanPriorYearFinancials
    globals()['LoanBorrowerInfo'] = LoanBorrowerInfo
    globals()['LoanComplianceInfo'] = LoanComplianceInfo
    globals()['LoanDocuments'] = LoanDocuments
    globals()['LoanFinancials'] = LoanFinancials
    globals()['LoanGuarantors'] = LoanGuarantors
    globals()['LoanPeriods'] = LoanPeriods
    globals()['LoanPriorYearFinancials'] = LoanPriorYearFinancials


class Loan(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('contract_type',): {
            'LEASE': "LEASE",
            'LOAN': "LOAN",
            'NOT_APPLICABLE': "NOT_APPLICABLE",
        },
        ('interest_type',): {
            'FIXED': "FIXED",
            'ADJUSTABLE': "ADJUSTABLE",
        },
        ('payment_type',): {
            'PRINCIPAL_AND_INTEREST': "PRINCIPAL_AND_INTEREST",
            'PRINCIPAL_PLUS_INTEREST': "PRINCIPAL_PLUS_INTEREST",
            'IO_PERIOD': "IO_PERIOD",
            'BALLON': "BALLON",
        },
        ('state',): {
            'PROPOSED': "PROPOSED",
            'APPROVED': "APPROVED",
            'DECLINED': "DECLINED",
            'ACTIVE': "ACTIVE",
            'PAID_OFF': "PAID_OFF",
            'DESISTED': "DESISTED",
        },
        ('payment_status',): {
            'CURRENT': "CURRENT",
            'GRACE_PERIOD': "GRACE_PERIOD",
            'DELINQUENT': "DELINQUENT",
        },
        ('scorecard',): {
            'None': None,
            'PASSED': "PASSED",
            'FAILED': "FAILED",
            'NOT_APPLICABLE': "NOT_APPLICABLE",
        },
        ('collateral_type',): {
            'NONE': "NONE",
            'CASH': "CASH",
            'AR': "AR",
            'IP': "IP",
            'REAL_ESTATE': "REAL_ESTATE",
            'EQUIPMENT': "EQUIPMENT",
        },
    }

    validations = {
        ('title',): {
            'max_length': 200,
        },
        ('principal',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': 0,
            'multiple_of': 0.01,
        },
        ('external_id',): {
            'max_length': 250,
        },
        ('loan_id',): {
            'max_length': 250,
        },
        ('interest_rate',): {
            'inclusive_maximum': 100,
            'inclusive_minimum': 0,
            'multiple_of': 0.00010,
        },
        ('monthly_payment',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': -1000000000000000000,
            'multiple_of': 0.01,
        },
        ('outstanding_principal',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': -1000000000000000000,
            'multiple_of': 0.01,
        },
        ('interest_accrued',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': -1000000000000000000,
            'multiple_of': 0.01,
        },
        ('loan_to_value',): {
            'inclusive_maximum': 10000,
            'inclusive_minimum': -10000,
            'multiple_of': 0.01,
        },
        ('collateral_value',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': 0,
            'multiple_of': 0.01,
        },
        ('residual_value',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': 0,
            'multiple_of': 0.01,
        },
        ('balloon_payment',): {
            'inclusive_maximum': 1000000000000000000,
            'inclusive_minimum': 0,
            'multiple_of': 0.01,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'title': (str,),  # noqa: E501
            'borrower_uuid': (str,),  # noqa: E501
            'borrower_info': (LoanBorrowerInfo,),  # noqa: E501
            'principal': (float,),  # noqa: E501
            'term_months': (int,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'description': (str, none_type,),  # noqa: E501
            'created_date': (datetime,),  # noqa: E501
            'external_id': (str, none_type,),  # noqa: E501
            'loan_id': (str, none_type,),  # noqa: E501
            'contract_type': (str,),  # noqa: E501
            'interest_rate': (float,),  # noqa: E501
            'interest_type': (str,),  # noqa: E501
            'payment_type': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'payment_status': (str,),  # noqa: E501
            'start_date': (date, none_type,),  # noqa: E501
            'end_date': (date,),  # noqa: E501
            'monthly_payment': (float,),  # noqa: E501
            'payments_remaining': (int,),  # noqa: E501
            'outstanding_principal': (float,),  # noqa: E501
            'interest_accrued': (float,),  # noqa: E501
            'loan_to_value': (float,),  # noqa: E501
            'scorecard': (str, none_type,),  # noqa: E501
            'collateral_type': (str,),  # noqa: E501
            'collateral_value': (float, none_type,),  # noqa: E501
            'collateral_life_months': (int,),  # noqa: E501
            'residual_value': (float, none_type,),  # noqa: E501
            'balloon_payment': (float, none_type,),  # noqa: E501
            'last_payment_date': (date, none_type,),  # noqa: E501
            'compliance_info': (LoanComplianceInfo,),  # noqa: E501
            'template_uuid': (str,),  # noqa: E501
            'periods': ([LoanPeriods],),  # noqa: E501
            'documents': ([LoanDocuments],),  # noqa: E501
            'financials': (LoanFinancials,),  # noqa: E501
            'analysis_commentary': (str, none_type,),  # noqa: E501
            'guarantors': ([LoanGuarantors],),  # noqa: E501
            'prior_year_financials': (LoanPriorYearFinancials,),  # noqa: E501
            'custom_attributes': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'title': 'title',  # noqa: E501
        'borrower_uuid': 'borrower_uuid',  # noqa: E501
        'borrower_info': 'borrower_info',  # noqa: E501
        'principal': 'principal',  # noqa: E501
        'term_months': 'term_months',  # noqa: E501
        'uuid': 'uuid',  # noqa: E501
        'description': 'description',  # noqa: E501
        'created_date': 'created_date',  # noqa: E501
        'external_id': 'external_id',  # noqa: E501
        'loan_id': 'loan_id',  # noqa: E501
        'contract_type': 'contract_type',  # noqa: E501
        'interest_rate': 'interest_rate',  # noqa: E501
        'interest_type': 'interest_type',  # noqa: E501
        'payment_type': 'payment_type',  # noqa: E501
        'state': 'state',  # noqa: E501
        'payment_status': 'payment_status',  # noqa: E501
        'start_date': 'start_date',  # noqa: E501
        'end_date': 'end_date',  # noqa: E501
        'monthly_payment': 'monthly_payment',  # noqa: E501
        'payments_remaining': 'payments_remaining',  # noqa: E501
        'outstanding_principal': 'outstanding_principal',  # noqa: E501
        'interest_accrued': 'interest_accrued',  # noqa: E501
        'loan_to_value': 'loan_to_value',  # noqa: E501
        'scorecard': 'scorecard',  # noqa: E501
        'collateral_type': 'collateral_type',  # noqa: E501
        'collateral_value': 'collateral_value',  # noqa: E501
        'collateral_life_months': 'collateral_life_months',  # noqa: E501
        'residual_value': 'residual_value',  # noqa: E501
        'balloon_payment': 'balloon_payment',  # noqa: E501
        'last_payment_date': 'last_payment_date',  # noqa: E501
        'compliance_info': 'compliance_info',  # noqa: E501
        'template_uuid': 'template_uuid',  # noqa: E501
        'periods': 'periods',  # noqa: E501
        'documents': 'documents',  # noqa: E501
        'financials': 'financials',  # noqa: E501
        'analysis_commentary': 'analysis_commentary',  # noqa: E501
        'guarantors': 'guarantors',  # noqa: E501
        'prior_year_financials': 'prior_year_financials',  # noqa: E501
        'custom_attributes': 'custom_attributes',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, title, borrower_uuid, borrower_info, principal, term_months, *args, **kwargs):  # noqa: E501
        """Loan - a model defined in OpenAPI

        Args:
            title (str): Title of the Loan. Must be unique for the Borrower
            borrower_uuid (str): UUID of the borrower for this loan. (see [Borrowers](#tag/Borrowers))
            borrower_info (LoanBorrowerInfo):
            principal (float): Original principal value
            term_months (int):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            uuid (str): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            created_date (datetime): [optional]  # noqa: E501
            external_id (str, none_type): External ID is used to uniquely identify a record from your system in our system. Must be unique across records.. [optional]  # noqa: E501
            loan_id (str, none_type): [optional]  # noqa: E501
            contract_type (str): [optional]  # noqa: E501
            interest_rate (float): [optional]  # noqa: E501
            interest_type (str): [optional]  # noqa: E501
            payment_type (str): [optional]  # noqa: E501
            state (str): [optional]  # noqa: E501
            payment_status (str): [optional]  # noqa: E501
            start_date (date, none_type): [optional]  # noqa: E501
            end_date (date): Loan end date. Calculated field. [optional]  # noqa: E501
            monthly_payment (float): calculated field. [optional]  # noqa: E501
            payments_remaining (int): Calculated field. [optional]  # noqa: E501
            outstanding_principal (float): calculated field. [optional]  # noqa: E501
            interest_accrued (float): calculated field. [optional]  # noqa: E501
            loan_to_value (float): calculated field. [optional]  # noqa: E501
            scorecard (str, none_type): [optional]  # noqa: E501
            collateral_type (str): [optional]  # noqa: E501
            collateral_value (float, none_type): [optional]  # noqa: E501
            collateral_life_months (int): The life of the collateral in months. [optional]  # noqa: E501
            residual_value (float, none_type): [optional]  # noqa: E501
            balloon_payment (float, none_type): [optional]  # noqa: E501
            last_payment_date (date, none_type): [optional]  # noqa: E501
            compliance_info (LoanComplianceInfo): [optional]  # noqa: E501
            template_uuid (str): DSRC template to use for finanical information. [optional]  # noqa: E501
            periods ([LoanPeriods]): ReportingPeriod&#39;s to include in the loan financial information. [optional]  # noqa: E501
            documents ([LoanDocuments]): Additional DocumentFile&#39;s to be included with loan information. [optional]  # noqa: E501
            financials (LoanFinancials): [optional]  # noqa: E501
            analysis_commentary (str, none_type): [optional]  # noqa: E501
            guarantors ([LoanGuarantors]): [optional]  # noqa: E501
            prior_year_financials (LoanPriorYearFinancials): [optional]  # noqa: E501
            custom_attributes ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.title = title
        self.borrower_uuid = borrower_uuid
        self.borrower_info = borrower_info
        self.principal = principal
        self.term_months = term_months
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
