# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rockset', 'rockset.api', 'rockset.apis', 'rockset.model', 'rockset.models']

package_data = \
{'': ['*']}

install_requires = \
['geojson>=2.5.0,<3.0.0',
 'python_dateutil>=2.5.3,<3.0.0',
 'urllib3>=1.25.3,<2.0.0']

setup_kwargs = {
    'name': 'rockset-v2-alpha',
    'version': '0.0.2',
    'description': 'The python client for the Rockset API.',
    'long_description': '## In progress\n- README postprocessing\n- polishing\n- QA\n- complete last part of async support\n\n# rockset\nRockset\'s REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.\n\nAll requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example:\n```\nAuthorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT\n```\n\nAll endpoints are only accessible via https.\n\nBuild something awesome!\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: v1\n- Package version: 1.0.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython >=3.6\n\n## Installation & Usage\n### pip install\n\nUntil the library is actually published in Pypi, you can install this client by running:\n```sh\npip install ./dist/rockset-1.0.0-py3-none-any.whl\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\nThen import the package:\n```python\nimport rockset\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nimport rockset\nfrom pprint import pprint\nfrom rockset.api import api_keys_api\nfrom rockset.model.create_api_key_request import CreateApiKeyRequest\nfrom rockset.model.create_api_key_response import CreateApiKeyResponse\nfrom rockset.model.delete_api_key_response import DeleteApiKeyResponse\nfrom rockset.model.error_model import ErrorModel\nfrom rockset.model.get_api_key_response import GetApiKeyResponse\nfrom rockset.model.list_api_keys_response import ListApiKeysResponse\nfrom rockset.model.update_api_key_request import UpdateApiKeyRequest\nfrom rockset.model.update_api_key_response import UpdateApiKeyResponse\n\n# Enter a context with an instance of the API client\n# Defining the host is optional and defaults to https://api.rs2.usw2.rockset.com\nwith rockset.RocksetClient(host="https://api.rs2.usw2.rockset.com", apikey="APIKEY") as rs:\n    try:\n        rs.APIKeysApi.create_api_key(name="api-key-name", role="member")\n    except rockset.ApiException as e:\n        print("Exception when calling ApiKey->create_api_key: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://api.rs2.usw2.rockset.com*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*APIKeysApi* | [**create_api_key**](docs/APIKeysApi.md#create_api_key) | **POST** /v1/orgs/self/users/self/apikeys | Create API Key\n*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /v1/orgs/self/users/{user}/apikeys/{name} | Delete API Key\n*APIKeysApi* | [**get_api_key**](docs/APIKeysApi.md#get_api_key) | **GET** /v1/orgs/self/users/{user}/apikeys/{name} | Retrieve API Key\n*APIKeysApi* | [**list_api_keys**](docs/APIKeysApi.md#list_api_keys) | **GET** /v1/orgs/self/users/{user}/apikeys | List API Keys\n*APIKeysApi* | [**update_api_key**](docs/APIKeysApi.md#update_api_key) | **POST** /v1/orgs/self/users/{user}/apikeys/{name} | Update API Key State\n*AliasesApi* | [**create_alias**](docs/AliasesApi.md#create_alias) | **POST** /v1/orgs/self/ws/{workspace}/aliases | Create Alias\n*AliasesApi* | [**delete_alias**](docs/AliasesApi.md#delete_alias) | **DELETE** /v1/orgs/self/ws/{workspace}/aliases/{alias} | Delete Alias\n*AliasesApi* | [**get_alias**](docs/AliasesApi.md#get_alias) | **GET** /v1/orgs/self/ws/{workspace}/aliases/{alias} | Retrieve Alias\n*AliasesApi* | [**list_aliases**](docs/AliasesApi.md#list_aliases) | **GET** /v1/orgs/self/aliases | List Aliases\n*AliasesApi* | [**update_alias**](docs/AliasesApi.md#update_alias) | **POST** /v1/orgs/self/ws/{workspace}/aliases/{alias} | Update Alias\n*AliasesApi* | [**workspace_aliases**](docs/AliasesApi.md#workspace_aliases) | **GET** /v1/orgs/self/ws/{workspace}/aliases | List Aliases in Workspace\n*CollectionsApi* | [**create_azure_blob_storage_collection**](docs/CollectionsApi.md#create_azure_blob_storage_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#AzureBlobStorage | Create azure blob storage collection\n*CollectionsApi* | [**create_azure_event_hubs_collection**](docs/CollectionsApi.md#create_azure_event_hubs_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#AzureEventHubs | Create azure event hubs collection\n*CollectionsApi* | [**create_azure_service_bus_collection**](docs/CollectionsApi.md#create_azure_service_bus_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#AzureServiceBus | Create azure service bus collection\n*CollectionsApi* | [**create_dynamodb_collection**](docs/CollectionsApi.md#create_dynamodb_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#Dynamodb | Create dynamodb collection\n*CollectionsApi* | [**create_file_upload_collection**](docs/CollectionsApi.md#create_file_upload_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#FileUpload | Create file upload collection\n*CollectionsApi* | [**create_gcs_collection**](docs/CollectionsApi.md#create_gcs_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#Gcs | Create gcs collection\n*CollectionsApi* | [**create_kafka_collection**](docs/CollectionsApi.md#create_kafka_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#Kafka | Create kafka collection\n*CollectionsApi* | [**create_kinesis_collection**](docs/CollectionsApi.md#create_kinesis_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#Kinesis | Create kinesis collection\n*CollectionsApi* | [**create_mongodb_collection**](docs/CollectionsApi.md#create_mongodb_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#Mongodb | Create mongodb collection\n*CollectionsApi* | [**create_s3_collection**](docs/CollectionsApi.md#create_s3_collection) | **POST** /v1/orgs/self/ws/{workspace}/collections#S3 | Create s3 collection\n*CollectionsApi* | [**delete_collection**](docs/CollectionsApi.md#delete_collection) | **DELETE** /v1/orgs/self/ws/{workspace}/collections/{collection} | Delete Collection\n*CollectionsApi* | [**get_collection**](docs/CollectionsApi.md#get_collection) | **GET** /v1/orgs/self/ws/{workspace}/collections/{collection} | Retrieve Collection\n*CollectionsApi* | [**list_collections**](docs/CollectionsApi.md#list_collections) | **GET** /v1/orgs/self/collections | List Collections\n*CollectionsApi* | [**workspace_collections**](docs/CollectionsApi.md#workspace_collections) | **GET** /v1/orgs/self/ws/{workspace}/collections | List Collections in Workspace\n*CustomRolesBetaApi* | [**create_role**](docs/CustomRolesBetaApi.md#create_role) | **POST** /v1/orgs/self/roles | Create a Role\n*CustomRolesBetaApi* | [**delete_role**](docs/CustomRolesBetaApi.md#delete_role) | **DELETE** /v1/orgs/self/roles/{roleName} | Delete a Role\n*CustomRolesBetaApi* | [**list_roles**](docs/CustomRolesBetaApi.md#list_roles) | **GET** /v1/orgs/self/roles | List Roles\n*CustomRolesBetaApi* | [**update_role**](docs/CustomRolesBetaApi.md#update_role) | **POST** /v1/orgs/self/roles/{roleName} | Update a Role\n*DocumentsApi* | [**add_documents**](docs/DocumentsApi.md#add_documents) | **POST** /v1/orgs/self/ws/{workspace}/collections/{collection}/docs | Add Documents\n*DocumentsApi* | [**delete_documents**](docs/DocumentsApi.md#delete_documents) | **DELETE** /v1/orgs/self/ws/{workspace}/collections/{collection}/docs | Delete Documents\n*DocumentsApi* | [**patch_documents**](docs/DocumentsApi.md#patch_documents) | **PATCH** /v1/orgs/self/ws/{workspace}/collections/{collection}/docs | Patch Documents\n*IntegrationsApi* | [**create_azure_blob_storage_integration**](docs/IntegrationsApi.md#create_azure_blob_storage_integration) | **POST** /v1/orgs/self/integrations#AzureBlobStorage | Create azure blob storage integration\n*IntegrationsApi* | [**create_azure_event_hubs_integration**](docs/IntegrationsApi.md#create_azure_event_hubs_integration) | **POST** /v1/orgs/self/integrations#AzureEventHubs | Create azure event hubs integration\n*IntegrationsApi* | [**create_dynamodb_integration**](docs/IntegrationsApi.md#create_dynamodb_integration) | **POST** /v1/orgs/self/integrations#Dynamodb | Create dynamodb integration\n*IntegrationsApi* | [**create_gcs_integration**](docs/IntegrationsApi.md#create_gcs_integration) | **POST** /v1/orgs/self/integrations#Gcs | Create gcs integration\n*IntegrationsApi* | [**create_kafka_integration**](docs/IntegrationsApi.md#create_kafka_integration) | **POST** /v1/orgs/self/integrations#Kafka | Create kafka integration\n*IntegrationsApi* | [**create_kinesis_integration**](docs/IntegrationsApi.md#create_kinesis_integration) | **POST** /v1/orgs/self/integrations#Kinesis | Create kinesis integration\n*IntegrationsApi* | [**create_mongodb_integration**](docs/IntegrationsApi.md#create_mongodb_integration) | **POST** /v1/orgs/self/integrations#Mongodb | Create mongodb integration\n*IntegrationsApi* | [**create_s3_integration**](docs/IntegrationsApi.md#create_s3_integration) | **POST** /v1/orgs/self/integrations#S3 | Create s3 integration\n*IntegrationsApi* | [**create_segment_integration**](docs/IntegrationsApi.md#create_segment_integration) | **POST** /v1/orgs/self/integrations#Segment | Create segment integration\n*IntegrationsApi* | [**delete_integration**](docs/IntegrationsApi.md#delete_integration) | **DELETE** /v1/orgs/self/integrations/{integration} | Delete Integration\n*IntegrationsApi* | [**get_integration**](docs/IntegrationsApi.md#get_integration) | **GET** /v1/orgs/self/integrations/{integration} | Retrieve Integration\n*IntegrationsApi* | [**list_integrations**](docs/IntegrationsApi.md#list_integrations) | **GET** /v1/orgs/self/integrations | List Integrations\n*OrganizationsApi* | [**get_organization**](docs/OrganizationsApi.md#get_organization) | **GET** /v1/orgs/self | Get Organization\n*QueriesApi* | [**query**](docs/QueriesApi.md#query) | **POST** /v1/orgs/self/queries | Query\n*QueriesApi* | [**validate**](docs/QueriesApi.md#validate) | **POST** /v1/orgs/self/queries/validations | Validate Query\n*QueryLambdasApi* | [**create_query_lambda**](docs/QueryLambdasApi.md#create_query_lambda) | **POST** /v1/orgs/self/ws/{workspace}/lambdas | Create Query Lambda\n*QueryLambdasApi* | [**create_query_lambda_tag**](docs/QueryLambdasApi.md#create_query_lambda_tag) | **POST** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags | Create Query Lambda Tag\n*QueryLambdasApi* | [**delete_query_lambda**](docs/QueryLambdasApi.md#delete_query_lambda) | **DELETE** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda} | Delete Query Lambda\n*QueryLambdasApi* | [**delete_query_lambda_tag**](docs/QueryLambdasApi.md#delete_query_lambda_tag) | **DELETE** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag} | Delete Query Lambda Tag Version\n*QueryLambdasApi* | [**delete_query_lambda_version**](docs/QueryLambdasApi.md#delete_query_lambda_version) | **DELETE** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/version/{version} | Delete Query Lambda Version\n*QueryLambdasApi* | [**execute_query_lambda**](docs/QueryLambdasApi.md#execute_query_lambda) | **POST** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version} | Execute Query Lambda By Version\n*QueryLambdasApi* | [**execute_query_lambda_by_tag**](docs/QueryLambdasApi.md#execute_query_lambda_by_tag) | **POST** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag} | Execute Query Lambda By Tag\n*QueryLambdasApi* | [**get_query_lambda_tag_version**](docs/QueryLambdasApi.md#get_query_lambda_tag_version) | **GET** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag} | Retrieve Query Lambda Tag\n*QueryLambdasApi* | [**get_query_lambda_version**](docs/QueryLambdasApi.md#get_query_lambda_version) | **GET** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version} | Retrieve Query Lambda Version\n*QueryLambdasApi* | [**list_all_query_lambdas**](docs/QueryLambdasApi.md#list_all_query_lambdas) | **GET** /v1/orgs/self/lambdas | List Query Lambdas\n*QueryLambdasApi* | [**list_query_lambda_tags**](docs/QueryLambdasApi.md#list_query_lambda_tags) | **GET** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags | List Query Lambda Tags\n*QueryLambdasApi* | [**list_query_lambda_versions**](docs/QueryLambdasApi.md#list_query_lambda_versions) | **GET** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions | List Query Lambda Versions\n*QueryLambdasApi* | [**list_query_lambdas_in_workspace**](docs/QueryLambdasApi.md#list_query_lambdas_in_workspace) | **GET** /v1/orgs/self/ws/{workspace}/lambdas | List Query Lambdas in Workspace\n*QueryLambdasApi* | [**update_query_lambda**](docs/QueryLambdasApi.md#update_query_lambda) | **POST** /v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions | Update Query Lambda\n*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /v1/orgs/self/users | Create User\n*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /v1/orgs/self/users/{user} | Delete User\n*UsersApi* | [**get_current_user**](docs/UsersApi.md#get_current_user) | **GET** /v1/orgs/self/users/self | Retrieve Current User\n*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /v1/orgs/self/users/{user} | Retrieve User\n*UsersApi* | [**list_unsubscribe_preferences**](docs/UsersApi.md#list_unsubscribe_preferences) | **GET** /v1/orgs/self/users/self/preferences | Retrieve Notification Preferences\n*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /v1/orgs/self/users | List Users\n*UsersApi* | [**update_unsubscribe_preferences**](docs/UsersApi.md#update_unsubscribe_preferences) | **POST** /v1/orgs/self/users/self/preferences | Update Notification Preferences\n*ViewsApi* | [**create_view**](docs/ViewsApi.md#create_view) | **POST** /v1/orgs/self/ws/{workspace}/views | Create View\n*ViewsApi* | [**delete_view**](docs/ViewsApi.md#delete_view) | **DELETE** /v1/orgs/self/ws/{workspace}/views/{view} | Delete View\n*ViewsApi* | [**get_view**](docs/ViewsApi.md#get_view) | **GET** /v1/orgs/self/ws/{workspace}/views/{view} | Retrieve View\n*ViewsApi* | [**list_views**](docs/ViewsApi.md#list_views) | **GET** /v1/orgs/self/views | List Views\n*ViewsApi* | [**update_view**](docs/ViewsApi.md#update_view) | **POST** /v1/orgs/self/ws/{workspace}/views/{view} | Update View\n*ViewsApi* | [**workspace_views**](docs/ViewsApi.md#workspace_views) | **GET** /v1/orgs/self/ws/{workspace}/views | List Views in Workspace\n*VirtualInstancesApi* | [**get_virtual_instance**](docs/VirtualInstancesApi.md#get_virtual_instance) | **GET** /v1/orgs/self/virtualinstances/{virtualInstanceId} | Retrieve Virtual Instance\n*VirtualInstancesApi* | [**list_virtual_instances**](docs/VirtualInstancesApi.md#list_virtual_instances) | **GET** /v1/orgs/self/virtualinstances | List Virtual Instances\n*VirtualInstancesApi* | [**set_virtual_instance**](docs/VirtualInstancesApi.md#set_virtual_instance) | **POST** /v1/orgs/self/virtualinstances/{virtualInstanceId} | Update Virtual Instance\n*WorkspacesApi* | [**child_workspaces**](docs/WorkspacesApi.md#child_workspaces) | **GET** /v1/orgs/self/ws/{workspace}/ws | List Workspaces in Workspace\n*WorkspacesApi* | [**create_workspace**](docs/WorkspacesApi.md#create_workspace) | **POST** /v1/orgs/self/ws | Create Workspace\n*WorkspacesApi* | [**delete_workspace**](docs/WorkspacesApi.md#delete_workspace) | **DELETE** /v1/orgs/self/ws/{workspace} | Delete Workspace\n*WorkspacesApi* | [**get_workspace**](docs/WorkspacesApi.md#get_workspace) | **GET** /v1/orgs/self/ws/{workspace} | Retrieve Workspace\n*WorkspacesApi* | [**list_workspaces**](docs/WorkspacesApi.md#list_workspaces) | **GET** /v1/orgs/self/ws | List Workspaces\n\n\n## Documentation For Models\n\n - [AddDocumentsRequest](docs/AddDocumentsRequest.md)\n - [AddDocumentsResponse](docs/AddDocumentsResponse.md)\n - [Alias](docs/Alias.md)\n - [ApiKey](docs/ApiKey.md)\n - [AwsAccessKey](docs/AwsAccessKey.md)\n - [AwsRole](docs/AwsRole.md)\n - [AzureBlobStorageCollectionCreationRequest](docs/AzureBlobStorageCollectionCreationRequest.md)\n - [AzureBlobStorageIntegration](docs/AzureBlobStorageIntegration.md)\n - [AzureBlobStorageIntegrationCreationRequest](docs/AzureBlobStorageIntegrationCreationRequest.md)\n - [AzureBlobStorageSourceWrapper](docs/AzureBlobStorageSourceWrapper.md)\n - [AzureEventHubsCollectionCreationRequest](docs/AzureEventHubsCollectionCreationRequest.md)\n - [AzureEventHubsIntegration](docs/AzureEventHubsIntegration.md)\n - [AzureEventHubsIntegrationCreationRequest](docs/AzureEventHubsIntegrationCreationRequest.md)\n - [AzureEventHubsSourceWrapper](docs/AzureEventHubsSourceWrapper.md)\n - [AzureServiceBusCollectionCreationRequest](docs/AzureServiceBusCollectionCreationRequest.md)\n - [AzureServiceBusIntegration](docs/AzureServiceBusIntegration.md)\n - [AzureServiceBusSourceWrapper](docs/AzureServiceBusSourceWrapper.md)\n - [Cluster](docs/Cluster.md)\n - [Collection](docs/Collection.md)\n - [CollectionStats](docs/CollectionStats.md)\n - [CreateAliasRequest](docs/CreateAliasRequest.md)\n - [CreateAliasResponse](docs/CreateAliasResponse.md)\n - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)\n - [CreateApiKeyResponse](docs/CreateApiKeyResponse.md)\n - [CreateCollectionRequest](docs/CreateCollectionRequest.md)\n - [CreateCollectionResponse](docs/CreateCollectionResponse.md)\n - [CreateIntegrationRequest](docs/CreateIntegrationRequest.md)\n - [CreateIntegrationResponse](docs/CreateIntegrationResponse.md)\n - [CreateQueryLambdaRequest](docs/CreateQueryLambdaRequest.md)\n - [CreateQueryLambdaTagRequest](docs/CreateQueryLambdaTagRequest.md)\n - [CreateRoleRequest](docs/CreateRoleRequest.md)\n - [CreateUserRequest](docs/CreateUserRequest.md)\n - [CreateUserResponse](docs/CreateUserResponse.md)\n - [CreateViewRequest](docs/CreateViewRequest.md)\n - [CreateViewResponse](docs/CreateViewResponse.md)\n - [CreateWorkspaceRequest](docs/CreateWorkspaceRequest.md)\n - [CreateWorkspaceResponse](docs/CreateWorkspaceResponse.md)\n - [CsvParams](docs/CsvParams.md)\n - [DeleteAliasResponse](docs/DeleteAliasResponse.md)\n - [DeleteApiKeyResponse](docs/DeleteApiKeyResponse.md)\n - [DeleteCollectionResponse](docs/DeleteCollectionResponse.md)\n - [DeleteDocumentsRequest](docs/DeleteDocumentsRequest.md)\n - [DeleteDocumentsRequestData](docs/DeleteDocumentsRequestData.md)\n - [DeleteDocumentsResponse](docs/DeleteDocumentsResponse.md)\n - [DeleteIntegrationResponse](docs/DeleteIntegrationResponse.md)\n - [DeleteQueryLambdaResponse](docs/DeleteQueryLambdaResponse.md)\n - [DeleteUserResponse](docs/DeleteUserResponse.md)\n - [DeleteViewResponse](docs/DeleteViewResponse.md)\n - [DeleteWorkspaceResponse](docs/DeleteWorkspaceResponse.md)\n - [DocumentStatus](docs/DocumentStatus.md)\n - [DynamodbCollectionCreationRequest](docs/DynamodbCollectionCreationRequest.md)\n - [DynamodbIntegration](docs/DynamodbIntegration.md)\n - [DynamodbIntegrationCreationRequest](docs/DynamodbIntegrationCreationRequest.md)\n - [DynamodbSourceWrapper](docs/DynamodbSourceWrapper.md)\n - [ErrorModel](docs/ErrorModel.md)\n - [EventTimeInfo](docs/EventTimeInfo.md)\n - [ExecuteQueryLambdaRequest](docs/ExecuteQueryLambdaRequest.md)\n - [FieldMappingQuery](docs/FieldMappingQuery.md)\n - [FieldMappingV2](docs/FieldMappingV2.md)\n - [FieldMask](docs/FieldMask.md)\n - [FieldMaskMask](docs/FieldMaskMask.md)\n - [FieldOptions](docs/FieldOptions.md)\n - [FieldPartition](docs/FieldPartition.md)\n - [FieldSchema](docs/FieldSchema.md)\n - [FileUploadCollectionCreationRequest](docs/FileUploadCollectionCreationRequest.md)\n - [FileUploadSourceWrapper](docs/FileUploadSourceWrapper.md)\n - [FormatParams](docs/FormatParams.md)\n - [GcpServiceAccount](docs/GcpServiceAccount.md)\n - [GcsCollectionCreationRequest](docs/GcsCollectionCreationRequest.md)\n - [GcsIntegration](docs/GcsIntegration.md)\n - [GcsIntegrationCreationRequest](docs/GcsIntegrationCreationRequest.md)\n - [GcsSourceWrapper](docs/GcsSourceWrapper.md)\n - [GetAliasResponse](docs/GetAliasResponse.md)\n - [GetApiKeyResponse](docs/GetApiKeyResponse.md)\n - [GetCollectionResponse](docs/GetCollectionResponse.md)\n - [GetIntegrationResponse](docs/GetIntegrationResponse.md)\n - [GetViewResponse](docs/GetViewResponse.md)\n - [GetVirtualInstanceResponse](docs/GetVirtualInstanceResponse.md)\n - [GetWorkspaceResponse](docs/GetWorkspaceResponse.md)\n - [InputField](docs/InputField.md)\n - [Integration](docs/Integration.md)\n - [InvertedIndexGroupEncodingOptions](docs/InvertedIndexGroupEncodingOptions.md)\n - [KafkaCollectionCreationRequest](docs/KafkaCollectionCreationRequest.md)\n - [KafkaIntegration](docs/KafkaIntegration.md)\n - [KafkaIntegrationCreationRequest](docs/KafkaIntegrationCreationRequest.md)\n - [KafkaSourceWrapper](docs/KafkaSourceWrapper.md)\n - [KafkaV3SecurityConfig](docs/KafkaV3SecurityConfig.md)\n - [KinesisCollectionCreationRequest](docs/KinesisCollectionCreationRequest.md)\n - [KinesisIntegration](docs/KinesisIntegration.md)\n - [KinesisIntegrationCreationRequest](docs/KinesisIntegrationCreationRequest.md)\n - [KinesisStorageSourceWrapper](docs/KinesisStorageSourceWrapper.md)\n - [ListAliasesResponse](docs/ListAliasesResponse.md)\n - [ListApiKeysResponse](docs/ListApiKeysResponse.md)\n - [ListCollectionsResponse](docs/ListCollectionsResponse.md)\n - [ListIntegrationsResponse](docs/ListIntegrationsResponse.md)\n - [ListQueryLambdaTagsResponse](docs/ListQueryLambdaTagsResponse.md)\n - [ListQueryLambdaVersionsResponse](docs/ListQueryLambdaVersionsResponse.md)\n - [ListQueryLambdasResponse](docs/ListQueryLambdasResponse.md)\n - [ListRolesResponse](docs/ListRolesResponse.md)\n - [ListUnsubscribePreferencesResponse](docs/ListUnsubscribePreferencesResponse.md)\n - [ListUsersResponse](docs/ListUsersResponse.md)\n - [ListViewsResponse](docs/ListViewsResponse.md)\n - [ListVirtualInstancesResponse](docs/ListVirtualInstancesResponse.md)\n - [ListWorkspacesResponse](docs/ListWorkspacesResponse.md)\n - [MongoDbIntegration](docs/MongoDbIntegration.md)\n - [MongodbCollectionCreationRequest](docs/MongodbCollectionCreationRequest.md)\n - [MongodbIntegrationCreationRequest](docs/MongodbIntegrationCreationRequest.md)\n - [MongodbSourceWrapper](docs/MongodbSourceWrapper.md)\n - [Organization](docs/Organization.md)\n - [OrganizationResponse](docs/OrganizationResponse.md)\n - [OutputField](docs/OutputField.md)\n - [PaginationInfo](docs/PaginationInfo.md)\n - [PatchDocument](docs/PatchDocument.md)\n - [PatchDocumentsRequest](docs/PatchDocumentsRequest.md)\n - [PatchDocumentsResponse](docs/PatchDocumentsResponse.md)\n - [PatchOperation](docs/PatchOperation.md)\n - [Privilege](docs/Privilege.md)\n - [QueryError](docs/QueryError.md)\n - [QueryFieldType](docs/QueryFieldType.md)\n - [QueryLambda](docs/QueryLambda.md)\n - [QueryLambdaSql](docs/QueryLambdaSql.md)\n - [QueryLambdaStats](docs/QueryLambdaStats.md)\n - [QueryLambdaTag](docs/QueryLambdaTag.md)\n - [QueryLambdaTagResponse](docs/QueryLambdaTagResponse.md)\n - [QueryLambdaVersion](docs/QueryLambdaVersion.md)\n - [QueryLambdaVersionResponse](docs/QueryLambdaVersionResponse.md)\n - [QueryParameter](docs/QueryParameter.md)\n - [QueryRequest](docs/QueryRequest.md)\n - [QueryRequestSql](docs/QueryRequestSql.md)\n - [QueryResponse](docs/QueryResponse.md)\n - [QueryResponseStats](docs/QueryResponseStats.md)\n - [Role](docs/Role.md)\n - [RoleResponse](docs/RoleResponse.md)\n - [S3CollectionCreationRequest](docs/S3CollectionCreationRequest.md)\n - [S3Integration](docs/S3Integration.md)\n - [S3IntegrationCreationRequest](docs/S3IntegrationCreationRequest.md)\n - [S3SourceWrapper](docs/S3SourceWrapper.md)\n - [SegmentIntegration](docs/SegmentIntegration.md)\n - [SegmentIntegrationCreationRequest](docs/SegmentIntegrationCreationRequest.md)\n - [Source](docs/Source.md)\n - [SourceAzureBlobStorage](docs/SourceAzureBlobStorage.md)\n - [SourceAzureEventHubs](docs/SourceAzureEventHubs.md)\n - [SourceAzureServiceBus](docs/SourceAzureServiceBus.md)\n - [SourceDynamoDb](docs/SourceDynamoDb.md)\n - [SourceFileUpload](docs/SourceFileUpload.md)\n - [SourceGcs](docs/SourceGcs.md)\n - [SourceKafka](docs/SourceKafka.md)\n - [SourceKinesis](docs/SourceKinesis.md)\n - [SourceMongoDb](docs/SourceMongoDb.md)\n - [SourceS3](docs/SourceS3.md)\n - [SqlExpression](docs/SqlExpression.md)\n - [Status](docs/Status.md)\n - [StatusAzureEventHubs](docs/StatusAzureEventHubs.md)\n - [StatusAzureEventHubsPartition](docs/StatusAzureEventHubsPartition.md)\n - [StatusAzureServiceBus](docs/StatusAzureServiceBus.md)\n - [StatusAzureServiceBusSession](docs/StatusAzureServiceBusSession.md)\n - [StatusDynamoDb](docs/StatusDynamoDb.md)\n - [StatusDynamoDbV2](docs/StatusDynamoDbV2.md)\n - [StatusKafka](docs/StatusKafka.md)\n - [StatusKafkaPartition](docs/StatusKafkaPartition.md)\n - [StatusMongoDb](docs/StatusMongoDb.md)\n - [UnsubscribePreference](docs/UnsubscribePreference.md)\n - [UpdateAliasRequest](docs/UpdateAliasRequest.md)\n - [UpdateApiKeyRequest](docs/UpdateApiKeyRequest.md)\n - [UpdateApiKeyResponse](docs/UpdateApiKeyResponse.md)\n - [UpdateQueryLambdaRequest](docs/UpdateQueryLambdaRequest.md)\n - [UpdateRoleRequest](docs/UpdateRoleRequest.md)\n - [UpdateUnsubscribePreferencesRequest](docs/UpdateUnsubscribePreferencesRequest.md)\n - [UpdateUnsubscribePreferencesResponse](docs/UpdateUnsubscribePreferencesResponse.md)\n - [UpdateViewRequest](docs/UpdateViewRequest.md)\n - [UpdateViewResponse](docs/UpdateViewResponse.md)\n - [UpdateVirtualInstanceRequest](docs/UpdateVirtualInstanceRequest.md)\n - [UpdateVirtualInstanceResponse](docs/UpdateVirtualInstanceResponse.md)\n - [User](docs/User.md)\n - [ValidateQueryResponse](docs/ValidateQueryResponse.md)\n - [View](docs/View.md)\n - [VirtualInstance](docs/VirtualInstance.md)\n - [Workspace](docs/Workspace.md)\n - [XmlParams](docs/XmlParams.md)\n\n\n## Documentation For Authorization\n\nThe RocksetClient object must be instantiated with an apikey. You can create your first apikey in the [Rockset console](https://console.rockset.com/apikeys). The provided apikey will be used for all requests that are made using the instance of the client.\n\n## Author\n\nRockset\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in rockset.apis and rockset.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from rockset.api.default_api import DefaultApi`\n- `from rockset.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nimport rockset\nfrom rockset.apis import *\nfrom rockset.models import *\n```\n\n',
    'author': 'Rockset',
    'author_email': 'support@rockset.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rockset/rockset-python-client',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
