# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class XmlParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attribute_prefix': 'str',
        'doc_tag': 'str',
        'encoding': 'str',
        'root_tag': 'str',
        'value_tag': 'str'
    }

    attribute_map = {
        'attribute_prefix': 'attribute_prefix',
        'doc_tag': 'doc_tag',
        'encoding': 'encoding',
        'root_tag': 'root_tag',
        'value_tag': 'value_tag'
    }

    def __init__(self, attribute_prefix=None, doc_tag=None, encoding=None, root_tag=None, value_tag=None, local_vars_configuration=None):  # noqa: E501
        """XmlParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._attribute_prefix = None
        self._doc_tag = None
        self._encoding = None
        self._root_tag = None
        self._value_tag = None
        self.discriminator = None

        if attribute_prefix is not None:
            self.attribute_prefix = attribute_prefix
        if doc_tag is not None:
            self.doc_tag = doc_tag
        if encoding is not None:
            self.encoding = encoding
        if root_tag is not None:
            self.root_tag = root_tag
        if value_tag is not None:
            self.value_tag = value_tag

    @property
    def attribute_prefix(self):
        """Gets the attribute_prefix of this XmlParams.  # noqa: E501

        tag to differentiate between attributes and elements  # noqa: E501

        :return: The attribute_prefix of this XmlParams.  # noqa: E501
        :rtype: str
        """
        return self._attribute_prefix

    @attribute_prefix.setter
    def attribute_prefix(self, attribute_prefix):
        """Sets the attribute_prefix of this XmlParams.

        tag to differentiate between attributes and elements  # noqa: E501

        :param attribute_prefix: The attribute_prefix of this XmlParams.  # noqa: E501
        :type attribute_prefix: str
        """

        self._attribute_prefix = attribute_prefix

    @property
    def doc_tag(self):
        """Gets the doc_tag of this XmlParams.  # noqa: E501

        tags with which documents are identified  # noqa: E501

        :return: The doc_tag of this XmlParams.  # noqa: E501
        :rtype: str
        """
        return self._doc_tag

    @doc_tag.setter
    def doc_tag(self, doc_tag):
        """Sets the doc_tag of this XmlParams.

        tags with which documents are identified  # noqa: E501

        :param doc_tag: The doc_tag of this XmlParams.  # noqa: E501
        :type doc_tag: str
        """

        self._doc_tag = doc_tag

    @property
    def encoding(self):
        """Gets the encoding of this XmlParams.  # noqa: E501

        encoding in which data source is encoded  # noqa: E501

        :return: The encoding of this XmlParams.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this XmlParams.

        encoding in which data source is encoded  # noqa: E501

        :param encoding: The encoding of this XmlParams.  # noqa: E501
        :type encoding: str
        """

        self._encoding = encoding

    @property
    def root_tag(self):
        """Gets the root_tag of this XmlParams.  # noqa: E501

        tag until which xml is ignored  # noqa: E501

        :return: The root_tag of this XmlParams.  # noqa: E501
        :rtype: str
        """
        return self._root_tag

    @root_tag.setter
    def root_tag(self, root_tag):
        """Sets the root_tag of this XmlParams.

        tag until which xml is ignored  # noqa: E501

        :param root_tag: The root_tag of this XmlParams.  # noqa: E501
        :type root_tag: str
        """

        self._root_tag = root_tag

    @property
    def value_tag(self):
        """Gets the value_tag of this XmlParams.  # noqa: E501

        tag used for the value when there are attributes in the element having no child  # noqa: E501

        :return: The value_tag of this XmlParams.  # noqa: E501
        :rtype: str
        """
        return self._value_tag

    @value_tag.setter
    def value_tag(self, value_tag):
        """Sets the value_tag of this XmlParams.

        tag used for the value when there are attributes in the element having no child  # noqa: E501

        :param value_tag: The value_tag of this XmlParams.  # noqa: E501
        :type value_tag: str
        """

        self._value_tag = value_tag

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, XmlParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, XmlParams):
            return True

        return self.to_dict() != other.to_dict()
