# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class UpdateVirtualInstanceRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'monitoring_enabled': 'bool',
        'new_size': 'str',
        'new_type': 'str'
    }

    attribute_map = {
        'monitoring_enabled': 'monitoring_enabled',
        'new_size': 'new_size',
        'new_type': 'new_type'
    }

    def __init__(self, monitoring_enabled=None, new_size=None, new_type=None, local_vars_configuration=None):  # noqa: E501
        """UpdateVirtualInstanceRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._monitoring_enabled = None
        self._new_size = None
        self._new_type = None
        self.discriminator = None

        if monitoring_enabled is not None:
            self.monitoring_enabled = monitoring_enabled
        if new_size is not None:
            self.new_size = new_size
        if new_type is not None:
            self.new_type = new_type

    @property
    def monitoring_enabled(self):
        """Gets the monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501


        :return: The monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: bool
        """
        return self._monitoring_enabled

    @monitoring_enabled.setter
    def monitoring_enabled(self, monitoring_enabled):
        """Sets the monitoring_enabled of this UpdateVirtualInstanceRequest.


        :param monitoring_enabled: The monitoring_enabled of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type monitoring_enabled: bool
        """

        self._monitoring_enabled = monitoring_enabled

    @property
    def new_size(self):
        """Gets the new_size of this UpdateVirtualInstanceRequest.  # noqa: E501

        requested virtual instance size  # noqa: E501

        :return: The new_size of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: str
        """
        return self._new_size

    @new_size.setter
    def new_size(self, new_size):
        """Sets the new_size of this UpdateVirtualInstanceRequest.

        requested virtual instance size  # noqa: E501

        :param new_size: The new_size of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type new_size: str
        """
        allowed_values = ["FREE", "SHARED", "SMALL", "MEDIUM", "LARGE", "XLARGE", "XLARGE2", "XLARGE4", "XLARGE8", "XLARGE16"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and new_size not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `new_size` ({0}), must be one of {1}"  # noqa: E501
                .format(new_size, allowed_values)
            )

        self._new_size = new_size

    @property
    def new_type(self):
        """Gets the new_type of this UpdateVirtualInstanceRequest.  # noqa: E501


        :return: The new_type of this UpdateVirtualInstanceRequest.  # noqa: E501
        :rtype: str
        """
        return self._new_type

    @new_type.setter
    def new_type(self, new_type):
        """Sets the new_type of this UpdateVirtualInstanceRequest.


        :param new_type: The new_type of this UpdateVirtualInstanceRequest.  # noqa: E501
        :type new_type: str
        """
        allowed_values = ["FREE", "SHARED", "SMALL", "MEDIUM", "LARGE", "XLARGE", "XLARGE2", "XLARGE4", "XLARGE8", "XLARGE16"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and new_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `new_type` ({0}), must be one of {1}"  # noqa: E501
                .format(new_type, allowed_values)
            )

        self._new_type = new_type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateVirtualInstanceRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateVirtualInstanceRequest):
            return True

        return self.to_dict() != other.to_dict()
