# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class StatusKafka(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'kafka_partitions': 'list[StatusKafkaPartition]',
        'last_consumed_time': 'str',
        'num_documents_processed': 'int',
        'state': 'str'
    }

    attribute_map = {
        'kafka_partitions': 'kafka_partitions',
        'last_consumed_time': 'last_consumed_time',
        'num_documents_processed': 'num_documents_processed',
        'state': 'state'
    }

    def __init__(self, kafka_partitions=None, last_consumed_time=None, num_documents_processed=None, state=None, local_vars_configuration=None):  # noqa: E501
        """StatusKafka - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._kafka_partitions = None
        self._last_consumed_time = None
        self._num_documents_processed = None
        self._state = None
        self.discriminator = None

        if kafka_partitions is not None:
            self.kafka_partitions = kafka_partitions
        if last_consumed_time is not None:
            self.last_consumed_time = last_consumed_time
        if num_documents_processed is not None:
            self.num_documents_processed = num_documents_processed
        if state is not None:
            self.state = state

    @property
    def kafka_partitions(self):
        """Gets the kafka_partitions of this StatusKafka.  # noqa: E501

        Status info per partition  # noqa: E501

        :return: The kafka_partitions of this StatusKafka.  # noqa: E501
        :rtype: list[StatusKafkaPartition]
        """
        return self._kafka_partitions

    @kafka_partitions.setter
    def kafka_partitions(self, kafka_partitions):
        """Sets the kafka_partitions of this StatusKafka.

        Status info per partition  # noqa: E501

        :param kafka_partitions: The kafka_partitions of this StatusKafka.  # noqa: E501
        :type kafka_partitions: list[StatusKafkaPartition]
        """

        self._kafka_partitions = kafka_partitions

    @property
    def last_consumed_time(self):
        """Gets the last_consumed_time of this StatusKafka.  # noqa: E501

        Time at which the last document was consumed from Kafka  # noqa: E501

        :return: The last_consumed_time of this StatusKafka.  # noqa: E501
        :rtype: str
        """
        return self._last_consumed_time

    @last_consumed_time.setter
    def last_consumed_time(self, last_consumed_time):
        """Sets the last_consumed_time of this StatusKafka.

        Time at which the last document was consumed from Kafka  # noqa: E501

        :param last_consumed_time: The last_consumed_time of this StatusKafka.  # noqa: E501
        :type last_consumed_time: str
        """

        self._last_consumed_time = last_consumed_time

    @property
    def num_documents_processed(self):
        """Gets the num_documents_processed of this StatusKafka.  # noqa: E501

        Number of documents consumed by this Kafka topic  # noqa: E501

        :return: The num_documents_processed of this StatusKafka.  # noqa: E501
        :rtype: int
        """
        return self._num_documents_processed

    @num_documents_processed.setter
    def num_documents_processed(self, num_documents_processed):
        """Sets the num_documents_processed of this StatusKafka.

        Number of documents consumed by this Kafka topic  # noqa: E501

        :param num_documents_processed: The num_documents_processed of this StatusKafka.  # noqa: E501
        :type num_documents_processed: int
        """

        self._num_documents_processed = num_documents_processed

    @property
    def state(self):
        """Gets the state of this StatusKafka.  # noqa: E501

        State of the Kafka source  # noqa: E501

        :return: The state of this StatusKafka.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this StatusKafka.

        State of the Kafka source  # noqa: E501

        :param state: The state of this StatusKafka.  # noqa: E501
        :type state: str
        """
        allowed_values = ["NO_DOCS_YET", "ACTIVE", "DORMANT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusKafka):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatusKafka):
            return True

        return self.to_dict() != other.to_dict()
