# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class Status(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'last_processed_at': 'str',
        'last_processed_item': 'str',
        'message': 'str',
        'state': 'str',
        'total_processed_items': 'int'
    }

    attribute_map = {
        'last_processed_at': 'last_processed_at',
        'last_processed_item': 'last_processed_item',
        'message': 'message',
        'state': 'state',
        'total_processed_items': 'total_processed_items'
    }

    def __init__(self, last_processed_at=None, last_processed_item=None, message=None, state=None, total_processed_items=None, local_vars_configuration=None):  # noqa: E501
        """Status - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._last_processed_at = None
        self._last_processed_item = None
        self._message = None
        self._state = None
        self._total_processed_items = None
        self.discriminator = None

        if last_processed_at is not None:
            self.last_processed_at = last_processed_at
        if last_processed_item is not None:
            self.last_processed_item = last_processed_item
        if message is not None:
            self.message = message
        if state is not None:
            self.state = state
        if total_processed_items is not None:
            self.total_processed_items = total_processed_items

    @property
    def last_processed_at(self):
        """Gets the last_processed_at of this Status.  # noqa: E501

        ISO-8601 date when source was last processed  # noqa: E501

        :return: The last_processed_at of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_processed_at

    @last_processed_at.setter
    def last_processed_at(self, last_processed_at):
        """Sets the last_processed_at of this Status.

        ISO-8601 date when source was last processed  # noqa: E501

        :param last_processed_at: The last_processed_at of this Status.  # noqa: E501
        :type last_processed_at: str
        """

        self._last_processed_at = last_processed_at

    @property
    def last_processed_item(self):
        """Gets the last_processed_item of this Status.  # noqa: E501

        last source item processed by ingester  # noqa: E501

        :return: The last_processed_item of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_processed_item

    @last_processed_item.setter
    def last_processed_item(self, last_processed_item):
        """Sets the last_processed_item of this Status.

        last source item processed by ingester  # noqa: E501

        :param last_processed_item: The last_processed_item of this Status.  # noqa: E501
        :type last_processed_item: str
        """

        self._last_processed_item = last_processed_item

    @property
    def message(self):
        """Gets the message of this Status.  # noqa: E501

        state message  # noqa: E501

        :return: The message of this Status.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Status.

        state message  # noqa: E501

        :param message: The message of this Status.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def state(self):
        """Gets the state of this Status.  # noqa: E501

        Status of the Source's ingestion, one of: INITIALIZING, WATCHING, PROCESSING, COMPLETED, ERROR  # noqa: E501

        :return: The state of this Status.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Status.

        Status of the Source's ingestion, one of: INITIALIZING, WATCHING, PROCESSING, COMPLETED, ERROR  # noqa: E501

        :param state: The state of this Status.  # noqa: E501
        :type state: str
        """
        allowed_values = ["INITIALIZING", "WATCHING", "PROCESSING", "COMPLETED", "ERROR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def total_processed_items(self):
        """Gets the total_processed_items of this Status.  # noqa: E501

        Total items processed of source  # noqa: E501

        :return: The total_processed_items of this Status.  # noqa: E501
        :rtype: int
        """
        return self._total_processed_items

    @total_processed_items.setter
    def total_processed_items(self, total_processed_items):
        """Sets the total_processed_items of this Status.

        Total items processed of source  # noqa: E501

        :param total_processed_items: The total_processed_items of this Status.  # noqa: E501
        :type total_processed_items: int
        """

        self._total_processed_items = total_processed_items

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Status):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Status):
            return True

        return self.to_dict() != other.to_dict()
