# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class SourceFileUpload(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file_name': 'str',
        'file_size': 'int',
        'file_upload_time': 'str'
    }

    attribute_map = {
        'file_name': 'file_name',
        'file_size': 'file_size',
        'file_upload_time': 'file_upload_time'
    }

    def __init__(self, file_name=None, file_size=None, file_upload_time=None, local_vars_configuration=None):  # noqa: E501
        """SourceFileUpload - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._file_name = None
        self._file_size = None
        self._file_upload_time = None
        self.discriminator = None

        self.file_name = file_name
        self.file_size = file_size
        self.file_upload_time = file_upload_time

    @property
    def file_name(self):
        """Gets the file_name of this SourceFileUpload.  # noqa: E501

        name of the file  # noqa: E501

        :return: The file_name of this SourceFileUpload.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this SourceFileUpload.

        name of the file  # noqa: E501

        :param file_name: The file_name of this SourceFileUpload.  # noqa: E501
        :type file_name: str
        """
        if self.local_vars_configuration.client_side_validation and file_name is None:  # noqa: E501
            raise ValueError("Invalid value for `file_name`, must not be `None`")  # noqa: E501

        self._file_name = file_name

    @property
    def file_size(self):
        """Gets the file_size of this SourceFileUpload.  # noqa: E501

        size of the file in bytes  # noqa: E501

        :return: The file_size of this SourceFileUpload.  # noqa: E501
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this SourceFileUpload.

        size of the file in bytes  # noqa: E501

        :param file_size: The file_size of this SourceFileUpload.  # noqa: E501
        :type file_size: int
        """
        if self.local_vars_configuration.client_side_validation and file_size is None:  # noqa: E501
            raise ValueError("Invalid value for `file_size`, must not be `None`")  # noqa: E501

        self._file_size = file_size

    @property
    def file_upload_time(self):
        """Gets the file_upload_time of this SourceFileUpload.  # noqa: E501

        time of file upload  # noqa: E501

        :return: The file_upload_time of this SourceFileUpload.  # noqa: E501
        :rtype: str
        """
        return self._file_upload_time

    @file_upload_time.setter
    def file_upload_time(self, file_upload_time):
        """Sets the file_upload_time of this SourceFileUpload.

        time of file upload  # noqa: E501

        :param file_upload_time: The file_upload_time of this SourceFileUpload.  # noqa: E501
        :type file_upload_time: str
        """
        if self.local_vars_configuration.client_side_validation and file_upload_time is None:  # noqa: E501
            raise ValueError("Invalid value for `file_upload_time`, must not be `None`")  # noqa: E501

        self._file_upload_time = file_upload_time

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceFileUpload):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceFileUpload):
            return True

        return self.to_dict() != other.to_dict()
