# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class EventTimeInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field': 'str',
        'format': 'str',
        'time_zone': 'str'
    }

    attribute_map = {
        'field': 'field',
        'format': 'format',
        'time_zone': 'time_zone'
    }

    def __init__(self, field=None, format=None, time_zone=None, local_vars_configuration=None):  # noqa: E501
        """EventTimeInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._field = None
        self._format = None
        self._time_zone = None
        self.discriminator = None

        self.field = field
        if format is not None:
            self.format = format
        if time_zone is not None:
            self.time_zone = time_zone

    @property
    def field(self):
        """Gets the field of this EventTimeInfo.  # noqa: E501

        name of the field containing event time  # noqa: E501

        :return: The field of this EventTimeInfo.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this EventTimeInfo.

        name of the field containing event time  # noqa: E501

        :param field: The field of this EventTimeInfo.  # noqa: E501
        :type field: str
        """
        if self.local_vars_configuration.client_side_validation and field is None:  # noqa: E501
            raise ValueError("Invalid value for `field`, must not be `None`")  # noqa: E501

        self._field = field

    @property
    def format(self):
        """Gets the format of this EventTimeInfo.  # noqa: E501

        format of time field, can be one of: milliseconds_since_epoch, seconds_since_epoch  # noqa: E501

        :return: The format of this EventTimeInfo.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this EventTimeInfo.

        format of time field, can be one of: milliseconds_since_epoch, seconds_since_epoch  # noqa: E501

        :param format: The format of this EventTimeInfo.  # noqa: E501
        :type format: str
        """

        self._format = format

    @property
    def time_zone(self):
        """Gets the time_zone of this EventTimeInfo.  # noqa: E501

        default time zone, in standard IANA format  # noqa: E501

        :return: The time_zone of this EventTimeInfo.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this EventTimeInfo.

        default time zone, in standard IANA format  # noqa: E501

        :param time_zone: The time_zone of this EventTimeInfo.  # noqa: E501
        :type time_zone: str
        """

        self._time_zone = time_zone

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventTimeInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EventTimeInfo):
            return True

        return self.to_dict() != other.to_dict()
