# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class DynamodbIntegration(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aws_access_key': 'AwsAccessKey',
        'aws_role': 'AwsRole',
        's3_export_bucket_name': 'str'
    }

    attribute_map = {
        'aws_access_key': 'aws_access_key',
        'aws_role': 'aws_role',
        's3_export_bucket_name': 's3_export_bucket_name'
    }

    def __init__(self, aws_access_key=None, aws_role=None, s3_export_bucket_name=None, local_vars_configuration=None):  # noqa: E501
        """DynamodbIntegration - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._aws_access_key = None
        self._aws_role = None
        self._s3_export_bucket_name = None
        self.discriminator = None

        if aws_access_key is not None:
            self.aws_access_key = aws_access_key
        if aws_role is not None:
            self.aws_role = aws_role
        if s3_export_bucket_name is not None:
            self.s3_export_bucket_name = s3_export_bucket_name

    @property
    def aws_access_key(self):
        """Gets the aws_access_key of this DynamodbIntegration.  # noqa: E501


        :return: The aws_access_key of this DynamodbIntegration.  # noqa: E501
        :rtype: AwsAccessKey
        """
        return self._aws_access_key

    @aws_access_key.setter
    def aws_access_key(self, aws_access_key):
        """Sets the aws_access_key of this DynamodbIntegration.


        :param aws_access_key: The aws_access_key of this DynamodbIntegration.  # noqa: E501
        :type aws_access_key: AwsAccessKey
        """

        self._aws_access_key = aws_access_key

    @property
    def aws_role(self):
        """Gets the aws_role of this DynamodbIntegration.  # noqa: E501


        :return: The aws_role of this DynamodbIntegration.  # noqa: E501
        :rtype: AwsRole
        """
        return self._aws_role

    @aws_role.setter
    def aws_role(self, aws_role):
        """Sets the aws_role of this DynamodbIntegration.


        :param aws_role: The aws_role of this DynamodbIntegration.  # noqa: E501
        :type aws_role: AwsRole
        """

        self._aws_role = aws_role

    @property
    def s3_export_bucket_name(self):
        """Gets the s3_export_bucket_name of this DynamodbIntegration.  # noqa: E501


        :return: The s3_export_bucket_name of this DynamodbIntegration.  # noqa: E501
        :rtype: str
        """
        return self._s3_export_bucket_name

    @s3_export_bucket_name.setter
    def s3_export_bucket_name(self, s3_export_bucket_name):
        """Sets the s3_export_bucket_name of this DynamodbIntegration.


        :param s3_export_bucket_name: The s3_export_bucket_name of this DynamodbIntegration.  # noqa: E501
        :type s3_export_bucket_name: str
        """

        self._s3_export_bucket_name = s3_export_bucket_name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DynamodbIntegration):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DynamodbIntegration):
            return True

        return self.to_dict() != other.to_dict()
