# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class DocumentStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collection': 'str',
        'id': 'str',
        'error': 'ErrorModel',
        'patch_id': 'str',
        'status': 'str'
    }

    attribute_map = {
        'collection': '_collection',
        'id': '_id',
        'error': 'error',
        'patch_id': 'patch_id',
        'status': 'status'
    }

    def __init__(self, collection=None, id=None, error=None, patch_id=None, status=None, local_vars_configuration=None):  # noqa: E501
        """DocumentStatus - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._collection = None
        self._id = None
        self._error = None
        self._patch_id = None
        self._status = None
        self.discriminator = None

        if collection is not None:
            self.collection = collection
        if id is not None:
            self.id = id
        if error is not None:
            self.error = error
        if patch_id is not None:
            self.patch_id = patch_id
        if status is not None:
            self.status = status

    @property
    def collection(self):
        """Gets the collection of this DocumentStatus.  # noqa: E501

        collection name  # noqa: E501

        :return: The collection of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._collection

    @collection.setter
    def collection(self, collection):
        """Sets the collection of this DocumentStatus.

        collection name  # noqa: E501

        :param collection: The collection of this DocumentStatus.  # noqa: E501
        :type collection: str
        """

        self._collection = collection

    @property
    def id(self):
        """Gets the id of this DocumentStatus.  # noqa: E501

        unique document ID  # noqa: E501

        :return: The id of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DocumentStatus.

        unique document ID  # noqa: E501

        :param id: The id of this DocumentStatus.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def error(self):
        """Gets the error of this DocumentStatus.  # noqa: E501


        :return: The error of this DocumentStatus.  # noqa: E501
        :rtype: ErrorModel
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this DocumentStatus.


        :param error: The error of this DocumentStatus.  # noqa: E501
        :type error: ErrorModel
        """

        self._error = error

    @property
    def patch_id(self):
        """Gets the patch_id of this DocumentStatus.  # noqa: E501

        unique id used to represent each patch request  # noqa: E501

        :return: The patch_id of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._patch_id

    @patch_id.setter
    def patch_id(self, patch_id):
        """Sets the patch_id of this DocumentStatus.

        unique id used to represent each patch request  # noqa: E501

        :param patch_id: The patch_id of this DocumentStatus.  # noqa: E501
        :type patch_id: str
        """

        self._patch_id = patch_id

    @property
    def status(self):
        """Gets the status of this DocumentStatus.  # noqa: E501

        status, one of ADDED, REPLACED, DELETED, ERROR  # noqa: E501

        :return: The status of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DocumentStatus.

        status, one of ADDED, REPLACED, DELETED, ERROR  # noqa: E501

        :param status: The status of this DocumentStatus.  # noqa: E501
        :type status: str
        """
        allowed_values = ["ADDED", "REPLACED", "DELETED", "PATCHED", "ERROR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DocumentStatus):
            return True

        return self.to_dict() != other.to_dict()
