# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class CollectionStats(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bulk_bytes_inserted': 'int',
        'bulk_bytes_overwritten': 'int',
        'bytes_inserted': 'int',
        'bytes_overwritten': 'int',
        'column_index_size': 'int',
        'doc_count': 'int',
        'fill_progress': 'float',
        'inverted_index_size': 'int',
        'last_queried_ms': 'int',
        'last_updated_ms': 'int',
        'purged_doc_count': 'int',
        'purged_doc_size': 'int',
        'range_index_size': 'int',
        'row_index_size': 'int',
        'total_index_size': 'int',
        'total_size': 'int'
    }

    attribute_map = {
        'bulk_bytes_inserted': 'bulk_bytes_inserted',
        'bulk_bytes_overwritten': 'bulk_bytes_overwritten',
        'bytes_inserted': 'bytes_inserted',
        'bytes_overwritten': 'bytes_overwritten',
        'column_index_size': 'column_index_size',
        'doc_count': 'doc_count',
        'fill_progress': 'fill_progress',
        'inverted_index_size': 'inverted_index_size',
        'last_queried_ms': 'last_queried_ms',
        'last_updated_ms': 'last_updated_ms',
        'purged_doc_count': 'purged_doc_count',
        'purged_doc_size': 'purged_doc_size',
        'range_index_size': 'range_index_size',
        'row_index_size': 'row_index_size',
        'total_index_size': 'total_index_size',
        'total_size': 'total_size'
    }

    def __init__(self, bulk_bytes_inserted=None, bulk_bytes_overwritten=None, bytes_inserted=None, bytes_overwritten=None, column_index_size=None, doc_count=None, fill_progress=None, inverted_index_size=None, last_queried_ms=None, last_updated_ms=None, purged_doc_count=None, purged_doc_size=None, range_index_size=None, row_index_size=None, total_index_size=None, total_size=None, local_vars_configuration=None):  # noqa: E501
        """CollectionStats - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._bulk_bytes_inserted = None
        self._bulk_bytes_overwritten = None
        self._bytes_inserted = None
        self._bytes_overwritten = None
        self._column_index_size = None
        self._doc_count = None
        self._fill_progress = None
        self._inverted_index_size = None
        self._last_queried_ms = None
        self._last_updated_ms = None
        self._purged_doc_count = None
        self._purged_doc_size = None
        self._range_index_size = None
        self._row_index_size = None
        self._total_index_size = None
        self._total_size = None
        self.discriminator = None

        if bulk_bytes_inserted is not None:
            self.bulk_bytes_inserted = bulk_bytes_inserted
        if bulk_bytes_overwritten is not None:
            self.bulk_bytes_overwritten = bulk_bytes_overwritten
        if bytes_inserted is not None:
            self.bytes_inserted = bytes_inserted
        if bytes_overwritten is not None:
            self.bytes_overwritten = bytes_overwritten
        if column_index_size is not None:
            self.column_index_size = column_index_size
        if doc_count is not None:
            self.doc_count = doc_count
        if fill_progress is not None:
            self.fill_progress = fill_progress
        if inverted_index_size is not None:
            self.inverted_index_size = inverted_index_size
        if last_queried_ms is not None:
            self.last_queried_ms = last_queried_ms
        if last_updated_ms is not None:
            self.last_updated_ms = last_updated_ms
        if purged_doc_count is not None:
            self.purged_doc_count = purged_doc_count
        if purged_doc_size is not None:
            self.purged_doc_size = purged_doc_size
        if range_index_size is not None:
            self.range_index_size = range_index_size
        if row_index_size is not None:
            self.row_index_size = row_index_size
        if total_index_size is not None:
            self.total_index_size = total_index_size
        if total_size is not None:
            self.total_size = total_size

    @property
    def bulk_bytes_inserted(self):
        """Gets the bulk_bytes_inserted of this CollectionStats.  # noqa: E501

        total number of bytes inserted into the collection during bulk  # noqa: E501

        :return: The bulk_bytes_inserted of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._bulk_bytes_inserted

    @bulk_bytes_inserted.setter
    def bulk_bytes_inserted(self, bulk_bytes_inserted):
        """Sets the bulk_bytes_inserted of this CollectionStats.

        total number of bytes inserted into the collection during bulk  # noqa: E501

        :param bulk_bytes_inserted: The bulk_bytes_inserted of this CollectionStats.  # noqa: E501
        :type bulk_bytes_inserted: int
        """

        self._bulk_bytes_inserted = bulk_bytes_inserted

    @property
    def bulk_bytes_overwritten(self):
        """Gets the bulk_bytes_overwritten of this CollectionStats.  # noqa: E501

        total number of bytes overwritten in writing into the collection during bulk  # noqa: E501

        :return: The bulk_bytes_overwritten of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._bulk_bytes_overwritten

    @bulk_bytes_overwritten.setter
    def bulk_bytes_overwritten(self, bulk_bytes_overwritten):
        """Sets the bulk_bytes_overwritten of this CollectionStats.

        total number of bytes overwritten in writing into the collection during bulk  # noqa: E501

        :param bulk_bytes_overwritten: The bulk_bytes_overwritten of this CollectionStats.  # noqa: E501
        :type bulk_bytes_overwritten: int
        """

        self._bulk_bytes_overwritten = bulk_bytes_overwritten

    @property
    def bytes_inserted(self):
        """Gets the bytes_inserted of this CollectionStats.  # noqa: E501

        total number of bytes inserted into the collection  # noqa: E501

        :return: The bytes_inserted of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._bytes_inserted

    @bytes_inserted.setter
    def bytes_inserted(self, bytes_inserted):
        """Sets the bytes_inserted of this CollectionStats.

        total number of bytes inserted into the collection  # noqa: E501

        :param bytes_inserted: The bytes_inserted of this CollectionStats.  # noqa: E501
        :type bytes_inserted: int
        """

        self._bytes_inserted = bytes_inserted

    @property
    def bytes_overwritten(self):
        """Gets the bytes_overwritten of this CollectionStats.  # noqa: E501

        total number of bytes overwritten in writing into the collection  # noqa: E501

        :return: The bytes_overwritten of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._bytes_overwritten

    @bytes_overwritten.setter
    def bytes_overwritten(self, bytes_overwritten):
        """Sets the bytes_overwritten of this CollectionStats.

        total number of bytes overwritten in writing into the collection  # noqa: E501

        :param bytes_overwritten: The bytes_overwritten of this CollectionStats.  # noqa: E501
        :type bytes_overwritten: int
        """

        self._bytes_overwritten = bytes_overwritten

    @property
    def column_index_size(self):
        """Gets the column_index_size of this CollectionStats.  # noqa: E501

        total collection column index size in bytes  # noqa: E501

        :return: The column_index_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._column_index_size

    @column_index_size.setter
    def column_index_size(self, column_index_size):
        """Sets the column_index_size of this CollectionStats.

        total collection column index size in bytes  # noqa: E501

        :param column_index_size: The column_index_size of this CollectionStats.  # noqa: E501
        :type column_index_size: int
        """

        self._column_index_size = column_index_size

    @property
    def doc_count(self):
        """Gets the doc_count of this CollectionStats.  # noqa: E501

        number of documents in the collection  # noqa: E501

        :return: The doc_count of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._doc_count

    @doc_count.setter
    def doc_count(self, doc_count):
        """Sets the doc_count of this CollectionStats.

        number of documents in the collection  # noqa: E501

        :param doc_count: The doc_count of this CollectionStats.  # noqa: E501
        :type doc_count: int
        """

        self._doc_count = doc_count

    @property
    def fill_progress(self):
        """Gets the fill_progress of this CollectionStats.  # noqa: E501

        number between 0 and 1 that indicates progress of collection creation  # noqa: E501

        :return: The fill_progress of this CollectionStats.  # noqa: E501
        :rtype: float
        """
        return self._fill_progress

    @fill_progress.setter
    def fill_progress(self, fill_progress):
        """Sets the fill_progress of this CollectionStats.

        number between 0 and 1 that indicates progress of collection creation  # noqa: E501

        :param fill_progress: The fill_progress of this CollectionStats.  # noqa: E501
        :type fill_progress: float
        """

        self._fill_progress = fill_progress

    @property
    def inverted_index_size(self):
        """Gets the inverted_index_size of this CollectionStats.  # noqa: E501

        total collection inverted index size in bytes  # noqa: E501

        :return: The inverted_index_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._inverted_index_size

    @inverted_index_size.setter
    def inverted_index_size(self, inverted_index_size):
        """Sets the inverted_index_size of this CollectionStats.

        total collection inverted index size in bytes  # noqa: E501

        :param inverted_index_size: The inverted_index_size of this CollectionStats.  # noqa: E501
        :type inverted_index_size: int
        """

        self._inverted_index_size = inverted_index_size

    @property
    def last_queried_ms(self):
        """Gets the last_queried_ms of this CollectionStats.  # noqa: E501

        milliseconds since Unix epoch Jan 1, 1970  # noqa: E501

        :return: The last_queried_ms of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._last_queried_ms

    @last_queried_ms.setter
    def last_queried_ms(self, last_queried_ms):
        """Sets the last_queried_ms of this CollectionStats.

        milliseconds since Unix epoch Jan 1, 1970  # noqa: E501

        :param last_queried_ms: The last_queried_ms of this CollectionStats.  # noqa: E501
        :type last_queried_ms: int
        """

        self._last_queried_ms = last_queried_ms

    @property
    def last_updated_ms(self):
        """Gets the last_updated_ms of this CollectionStats.  # noqa: E501

        milliseconds since Unix epoch Jan 1, 1970  # noqa: E501

        :return: The last_updated_ms of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_ms

    @last_updated_ms.setter
    def last_updated_ms(self, last_updated_ms):
        """Sets the last_updated_ms of this CollectionStats.

        milliseconds since Unix epoch Jan 1, 1970  # noqa: E501

        :param last_updated_ms: The last_updated_ms of this CollectionStats.  # noqa: E501
        :type last_updated_ms: int
        """

        self._last_updated_ms = last_updated_ms

    @property
    def purged_doc_count(self):
        """Gets the purged_doc_count of this CollectionStats.  # noqa: E501

        number of documents purged from the collection  # noqa: E501

        :return: The purged_doc_count of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._purged_doc_count

    @purged_doc_count.setter
    def purged_doc_count(self, purged_doc_count):
        """Sets the purged_doc_count of this CollectionStats.

        number of documents purged from the collection  # noqa: E501

        :param purged_doc_count: The purged_doc_count of this CollectionStats.  # noqa: E501
        :type purged_doc_count: int
        """

        self._purged_doc_count = purged_doc_count

    @property
    def purged_doc_size(self):
        """Gets the purged_doc_size of this CollectionStats.  # noqa: E501

        total size of bytes purged in bytes  # noqa: E501

        :return: The purged_doc_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._purged_doc_size

    @purged_doc_size.setter
    def purged_doc_size(self, purged_doc_size):
        """Sets the purged_doc_size of this CollectionStats.

        total size of bytes purged in bytes  # noqa: E501

        :param purged_doc_size: The purged_doc_size of this CollectionStats.  # noqa: E501
        :type purged_doc_size: int
        """

        self._purged_doc_size = purged_doc_size

    @property
    def range_index_size(self):
        """Gets the range_index_size of this CollectionStats.  # noqa: E501

        total collection range index size in bytes  # noqa: E501

        :return: The range_index_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._range_index_size

    @range_index_size.setter
    def range_index_size(self, range_index_size):
        """Sets the range_index_size of this CollectionStats.

        total collection range index size in bytes  # noqa: E501

        :param range_index_size: The range_index_size of this CollectionStats.  # noqa: E501
        :type range_index_size: int
        """

        self._range_index_size = range_index_size

    @property
    def row_index_size(self):
        """Gets the row_index_size of this CollectionStats.  # noqa: E501

        total collection row index size in bytes  # noqa: E501

        :return: The row_index_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._row_index_size

    @row_index_size.setter
    def row_index_size(self, row_index_size):
        """Sets the row_index_size of this CollectionStats.

        total collection row index size in bytes  # noqa: E501

        :param row_index_size: The row_index_size of this CollectionStats.  # noqa: E501
        :type row_index_size: int
        """

        self._row_index_size = row_index_size

    @property
    def total_index_size(self):
        """Gets the total_index_size of this CollectionStats.  # noqa: E501

        total collection index size in bytes  # noqa: E501

        :return: The total_index_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._total_index_size

    @total_index_size.setter
    def total_index_size(self, total_index_size):
        """Sets the total_index_size of this CollectionStats.

        total collection index size in bytes  # noqa: E501

        :param total_index_size: The total_index_size of this CollectionStats.  # noqa: E501
        :type total_index_size: int
        """

        self._total_index_size = total_index_size

    @property
    def total_size(self):
        """Gets the total_size of this CollectionStats.  # noqa: E501

        total collection size in bytes  # noqa: E501

        :return: The total_size of this CollectionStats.  # noqa: E501
        :rtype: int
        """
        return self._total_size

    @total_size.setter
    def total_size(self, total_size):
        """Sets the total_size of this CollectionStats.

        total collection size in bytes  # noqa: E501

        :param total_size: The total_size of this CollectionStats.  # noqa: E501
        :type total_size: int
        """

        self._total_size = total_size

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectionStats):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollectionStats):
            return True

        return self.to_dict() != other.to_dict()
