# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class Alias(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collections': 'list[str]',
        'created_at': 'str',
        'creator_email': 'str',
        'description': 'str',
        'modified_at': 'str',
        'name': 'str',
        'state': 'str',
        'workspace': 'str'
    }

    attribute_map = {
        'collections': 'collections',
        'created_at': 'created_at',
        'creator_email': 'creator_email',
        'description': 'description',
        'modified_at': 'modified_at',
        'name': 'name',
        'state': 'state',
        'workspace': 'workspace'
    }

    def __init__(self, collections=None, created_at=None, creator_email=None, description=None, modified_at=None, name=None, state=None, workspace=None, local_vars_configuration=None):  # noqa: E501
        """Alias - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._collections = None
        self._created_at = None
        self._creator_email = None
        self._description = None
        self._modified_at = None
        self._name = None
        self._state = None
        self._workspace = None
        self.discriminator = None

        if collections is not None:
            self.collections = collections
        if created_at is not None:
            self.created_at = created_at
        if creator_email is not None:
            self.creator_email = creator_email
        if description is not None:
            self.description = description
        if modified_at is not None:
            self.modified_at = modified_at
        if name is not None:
            self.name = name
        if state is not None:
            self.state = state
        if workspace is not None:
            self.workspace = workspace

    @property
    def collections(self):
        """Gets the collections of this Alias.  # noqa: E501

        list of fully qualified collection names referenced by alias  # noqa: E501

        :return: The collections of this Alias.  # noqa: E501
        :rtype: list[str]
        """
        return self._collections

    @collections.setter
    def collections(self, collections):
        """Sets the collections of this Alias.

        list of fully qualified collection names referenced by alias  # noqa: E501

        :param collections: The collections of this Alias.  # noqa: E501
        :type collections: list[str]
        """

        self._collections = collections

    @property
    def created_at(self):
        """Gets the created_at of this Alias.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The created_at of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Alias.

        ISO-8601 date  # noqa: E501

        :param created_at: The created_at of this Alias.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def creator_email(self):
        """Gets the creator_email of this Alias.  # noqa: E501

        email of the creator  # noqa: E501

        :return: The creator_email of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._creator_email

    @creator_email.setter
    def creator_email(self, creator_email):
        """Sets the creator_email of this Alias.

        email of the creator  # noqa: E501

        :param creator_email: The creator_email of this Alias.  # noqa: E501
        :type creator_email: str
        """

        self._creator_email = creator_email

    @property
    def description(self):
        """Gets the description of this Alias.  # noqa: E501

        alias description  # noqa: E501

        :return: The description of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Alias.

        alias description  # noqa: E501

        :param description: The description of this Alias.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def modified_at(self):
        """Gets the modified_at of this Alias.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The modified_at of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this Alias.

        ISO-8601 date  # noqa: E501

        :param modified_at: The modified_at of this Alias.  # noqa: E501
        :type modified_at: str
        """

        self._modified_at = modified_at

    @property
    def name(self):
        """Gets the name of this Alias.  # noqa: E501

        name of the alias  # noqa: E501

        :return: The name of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Alias.

        name of the alias  # noqa: E501

        :param name: The name of this Alias.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def state(self):
        """Gets the state of this Alias.  # noqa: E501

        state of the alias  # noqa: E501

        :return: The state of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Alias.

        state of the alias  # noqa: E501

        :param state: The state of this Alias.  # noqa: E501
        :type state: str
        """
        allowed_values = ["CREATED", "DELETED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def workspace(self):
        """Gets the workspace of this Alias.  # noqa: E501

        name of the workspace  # noqa: E501

        :return: The workspace of this Alias.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this Alias.

        name of the workspace  # noqa: E501

        :param workspace: The workspace of this Alias.  # noqa: E501
        :type workspace: str
        """

        self._workspace = workspace

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Alias):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Alias):
            return True

        return self.to_dict() != other.to_dict()
