# denver
Denver API for Python

This API is specifically designed for python developers who want to use
advanced utilities but without coding much. The API requires you to
have minimum Python 3.6.

## tools
this is a new package built into denver and now you can use every module inside it as a command line
tool. You can type the following command `python denverapi.tools` to get a list of available tools.

## Features

There are a lot of modules and libraries in denverapi and [here](https://xcodz-dot.github.io/denver) is a good list of them.

## Installation
The package can be installed by
```commandline
pip install denver-api
```
and upgraded by
```commandline
pip install --upgrade denver-api
```

## Documentation
Documentation for denver can be found out at [this page](https://xcodz-dot.github.io/denver).
Also Documentation can be generated by the following command

```commandline
pip install pdoc3
```
or if you already have then you can upgrade it by following command

```commandline
pip install --upgrade pdoc3
```

After installation cd to root of this repository and run this command
 `pdoc denverapi -o docs --html --config show_source_code=False --template-dir pdoc`.
This will generate documentation and save it under the folder `docs`.

## Community
This is a community driven project and accepts pull requests
of any kind (read [CONTRIBUTING.md](https://github.com/xcodz-dot/denver/blob/master/.github/CONTRIBUTING.md)), 
Thanks to all the contributors. Contributions are appreciated.
It will be really helpful if you raise a issue on finding bugs, documentation issues and typos.

Please do not use forums such as StackOverflow for asking questions related to this repository because
this repository is not popular enough to be heard on forums. Please use this repositories GitHub issues.

## Fixed Bugs
### 3.0.0
Untracked :(

### 2.5.2, 2.5.3, 2.5.4
* `denverapi.function_logger` fixed wrapped function not returning anything.
* `denverapi.autopyb` fixes
### 2.5.1
* `denverapi.autopyb` minimum version fix
### 2.4.1
* `denverapi.bdtpfserv.post` function is now fixes to work without pausing and making troubles
* `denverapi.tools.bdtpserver` tool fixed for the post argument
* `denverapi.tools.cpic_editor` tool fixes which produced file system errors on linux
### 2.1.0
* `denverapi.pysetup.find_package_data` function is now fixed, so it can include files at root level of a module

## What's New
### 3.0.0
* removed `pyelib` because I realised how useless it it.
* added documentation for major part of codebase
* added `denverapi.tools.cryptify` to encrypt files and decrypt files
* added `encryption` to encrypt and decrypt data
* removed `cpic` due to complexity and incompatibility with existing modules.
* removed the documentation (that was a lot of work, now use the python documentation generated by pdoc3) 
* better cli for `denverapi.autopyb`
* added support for Python 3.6
* added new command line utilities.
* added `entrypoints` to all tools as scripts.
* added ability to `denverapi.autopyb.commands.pip` to be able to detect dependencies and do not run pip for no reason
* added ability to `denverapi.tools.cpic_editor` to save cpic images to file.
### 2.5.0
* autopyb is added as a new auto building manager
### 2.4.1
* Thread control
* Split up the pygame into a separate section (denverapi is sometimes required without pygame)
### 2.2.0
* new indev tools
* renamed to a new project
### 2.1.0
* `denver.tools` package is now added as a standard interface to many modules (Many tools are still work in progress)
