"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    Autogenerated on: 2020-11-19 12:03:50
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyopencga.rest_clients._parent_rest_clients import _ParentRestClient


class Clinical(_ParentRestClient):
    """
    This class contains methods for the 'Analysis - Clinical' webservices
    Client version: 2.0.0
    PATH: /{apiVersion}/analysis/clinical
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Clinical, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def update_acl(self, members, action, data=None, **options):
        """
        Update the set of permissions granted for the member.
        PATH: /{apiVersion}/analysis/clinical/acl/{members}/update

        :param dict data: JSON containing the parameters to add ACLs.
            (REQUIRED)
        :param str action: Action to be performed [ADD, SET, REMOVE or RESET].
            (REQUIRED)
        :param str members: Comma separated list of user or group IDs.
            (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param bool propagate: Propagate permissions to related families,
            individuals, samples and files.
        """

        options['action'] = action
        return self._post(category='analysis', resource='update', subcategory='clinical/acl', second_query_id=members, data=data, **options)

    def create(self, data=None, **options):
        """
        Create a new clinical analysis.
        PATH: /{apiVersion}/analysis/clinical/create

        :param dict data: JSON containing clinical analysis information.
            (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param bool create_default_interpretation: Flag to create and
            initialise a default primary interpretation (Id will be
            '{clinicalAnalysisId}.1').
        """

        return self._post(category='analysis', resource='create', subcategory='clinical', data=data, **options)

    def distinct(self, field, **options):
        """
        Clinical Analysis distinct method.
        PATH: /{apiVersion}/analysis/clinical/distinct

        :param str field: Field for which to obtain the distinct values.
            (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str id: Clinical analysis ID.
        :param str type: Clinical analysis type.
        :param str priority: Priority.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str internal_status: Filter by internal status.
        :param str status: Filter by status.
        :param str due_date: Due date (Format: yyyyMMddHHmmss. Examples:
            >2018, 2017-2018, <201805...).
        :param str description: Description.
        :param str family: Family id.
        :param str proband: Proband id.
        :param str sample: Sample id associated to the proband or any member
            of a family.
        :param str individual: Proband id or any member id of a family.
        :param str analyst_assignee: Clinical analyst assignee.
        :param str disorder: Disorder ID or name.
        :param str flags: Flags.
        :param str release: Release value.
        :param str attributes: Text attributes (Format: sex=male,age>20 ...).
        """

        options['field'] = field
        return self._get(category='analysis', resource='distinct', subcategory='clinical', **options)

    def distinct_interpretation(self, field, **options):
        """
        Interpretation distinct method.
        PATH: /{apiVersion}/analysis/clinical/interpretation/distinct

        :param str field: Field for which to obtain the distinct values.
            (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str id: Interpretation ID.
        :param str clinical_analysis_id: Clinical Analysis ID.
        :param str analyst: Clinical analyst ID.
        :param str methods: Interpretation method name.
        :param str primary_findings: Primary finding IDs.
        :param str secondary_findings: Secondary finding IDs.
        :param str status: Interpretation status.
        :param str creation_date: Creation date.
        :param str modification_date: Modification date.
        """

        options['field'] = field
        return self._get(category='analysis', resource='distinct', subcategory='clinical/interpretation', **options)

    def search_interpretation(self, **options):
        """
        Search clinical interpretations.
        PATH: /{apiVersion}/analysis/clinical/interpretation/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool sort: Sort the results.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str id: Interpretation ID.
        :param str clinical_analysis_id: Clinical Analysis ID.
        :param str analyst: Clinical analyst ID.
        :param str methods: Interpretation method name.
        :param str primary_findings: Primary finding IDs.
        :param str secondary_findings: Secondary finding IDs.
        :param str status: Interpretation status.
        :param str creation_date: Creation date.
        :param str modification_date: Modification date.
        """

        return self._get(category='analysis', resource='search', subcategory='clinical/interpretation', **options)

    def info_interpretation(self, interpretations, **options):
        """
        Clinical interpretation information.
        PATH: /{apiVersion}/analysis/clinical/interpretation/{interpretations}/info

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str interpretations: Comma separated list of clinical
            interpretation IDs  up to a maximum of 100.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str version: Comma separated list of interpretation versions.
            'all' to get all the interpretation versions. Not supported if
            multiple interpretation ids are provided.
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='analysis', resource='info', subcategory='clinical/interpretation', second_query_id=interpretations, **options)

    def run_interpreter_cancer_tiering(self, data=None, **options):
        """
        Run cancer tiering interpretation analysis.
        PATH: /{apiVersion}/analysis/clinical/interpreter/cancerTiering/run

        :param dict data: Cancer tiering interpretation analysis params.
            (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='clinical/interpreter/cancerTiering', data=data, **options)

    def run_interpreter_team(self, data=None, **options):
        """
        Run TEAM interpretation analysis.
        PATH: /{apiVersion}/analysis/clinical/interpreter/team/run

        :param dict data: TEAM interpretation analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='clinical/interpreter/team', data=data, **options)

    def run_interpreter_tiering(self, data=None, **options):
        """
        Run tiering interpretation analysis.
        PATH: /{apiVersion}/analysis/clinical/interpreter/tiering/run

        :param dict data: Tiering interpretation analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='clinical/interpreter/tiering', data=data, **options)

    def run_interpreter_zetta(self, data=None, **options):
        """
        Run Zetta interpretation analysis.
        PATH: /{apiVersion}/analysis/clinical/interpreter/zetta/run

        :param dict data: Zetta interpretation analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='clinical/interpreter/zetta', data=data, **options)

    def search(self, **options):
        """
        Clinical analysis search.
        PATH: /{apiVersion}/analysis/clinical/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str id: Clinical analysis ID.
        :param str type: Clinical analysis type.
        :param str priority: Priority.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str internal_status: Filter by internal status.
        :param str status: Filter by status.
        :param str due_date: Due date (Format: yyyyMMddHHmmss. Examples:
            >2018, 2017-2018, <201805...).
        :param str description: Description.
        :param str family: Family id.
        :param str proband: Proband id.
        :param str sample: Sample id associated to the proband or any member
            of a family.
        :param str individual: Proband id or any member id of a family.
        :param str analyst_assignee: Clinical analyst assignee.
        :param str disorder: Disorder ID or name.
        :param str flags: Flags.
        :param bool deleted: Boolean to retrieve deleted entries.
        :param str release: Release value.
        :param str attributes: Text attributes (Format: sex=male,age>20 ...).
        """

        return self._get(category='analysis', resource='search', subcategory='clinical', **options)

    def actionable_variant(self, **options):
        """
        Fetch actionable clinical variants.
        PATH: /{apiVersion}/analysis/clinical/variant/actionable

        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str sample: Sample ID.
        """

        return self._get(category='analysis', resource='actionable', subcategory='clinical/variant', **options)

    def query_variant(self, **options):
        """
        Fetch clinical variants.
        PATH: /{apiVersion}/analysis/clinical/variant/query

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param bool approximate_count: Get an approximate count, instead of an
            exact total count. Reduces execution time.
        :param int approximate_count_sampling_size: Sampling size to get the
            approximate count. Larger values increase accuracy but also
            increase execution time.
        :param str saved_filter: Use a saved filter at User level.
        :param str id: List of IDs, these can be rs IDs (dbSNP) or variants in
            the format chrom:start:ref:alt, e.g. rs116600158,19:7177679:C:T.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str type: List of types, accepted values are SNV, MNV, INDEL,
            SV, CNV, INSERTION, DELETION, e.g. SNV,INDEL.
        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str file: Filter variants from the files specified. This will
            set includeFile parameter when not provided.
        :param str filter: Specify the FILTER for any of the files. If 'file'
            filter is provided, will match the file and the filter. e.g.:
            PASS,LowGQX.
        :param str qual: Specify the QUAL for any of the files. If 'file'
            filter is provided, will match the file and the qual. e.g.: >123.4.
        :param str file_data: Filter by file data (i.e. FILTER, QUAL and INFO
            columns from VCF file). [{file}:]{key}{op}{value}[,;]* . If no file
            is specified, will use all files from 'file' filter. e.g. AN>200 or
            file_1.vcf:AN>200;file_2.vcf:AN<10 . Many fields can be combined.
            e.g. file_1.vcf:AN>200;DB=true;file_2.vcf:AN<10,FILTER=PASS,LowDP.
        :param str sample: Filter variants by sample genotype. This will
            automatically set 'includeSample' parameter when not provided. This
            filter accepts multiple 3 forms: 1) List of samples: Samples that
            contain the main variant. Accepts AND (;) and OR (,) operators. 
            e.g. HG0097,HG0098 . 2) List of samples with genotypes:
            {sample}:{gt1},{gt2}. Accepts AND (;) and OR (,) operators.  e.g.
            HG0097:0/0;HG0098:0/1,1/1 . Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT . 3) Sample with segregation
            mode: {sample}:{segregation}. Only one sample accepted.Accepted
            segregation modes: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ]. Value is case insensitive.
            e.g. HG0097:DeNovo Sample must have parents defined and indexed. .
        :param str sample_data: Filter by any SampleData field from samples.
            [{sample}:]{key}{op}{value}[,;]* . If no sample is specified, will
            use all samples from 'sample' or 'genotype' filter. e.g. DP>200 or
            HG0097:DP>200,HG0098:DP<10 . Many FORMAT fields can be combined.
            e.g. HG0097:DP>200;GT=1/1,0/1,HG0098:DP<10.
        :param str sample_annotation: Selects some samples using metadata
            information from Catalog. e.g.
            age>20;phenotype=hpo:123,hpo:456;name=smith.
        :param str cohort: Select variants with calculated stats for the
            selected cohorts.
        :param str cohort_stats_ref: Reference Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_alt: Alternate Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_maf: Minor Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_mgf: Minor Genotype Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_pass: Filter PASS frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str missing_alleles: Number of missing alleles:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str missing_genotypes: Number of missing genotypes:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str score: Filter by variant score:
            [{study:}]{score}[<|>|<=|>=]{number}.
        :param str family: Filter variants where any of the samples from the
            given family contains the variant (HET or HOM_ALT).
        :param str family_disorder: Specify the disorder to use for the family
            segregation.
        :param str family_segregation: Filter by segregation mode from a given
            family. Accepted values: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ].
        :param str family_members: Sub set of the members of a given family.
        :param str family_proband: Specify the proband child to use for the
            family segregation.
        :param str gene: List of genes, most gene IDs are accepted (HGNC,
            Ensembl gene, ...). This is an alias to 'xref' parameter.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578.
        :param str xref: List of any external reference, these can be genes,
            proteins or variants. Accepted IDs include HGNC, Ensembl genes,
            dbSNP, ClinVar, HPO, Cosmic, ...
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str protein_substitution: Protein substitution scores include
            SIFT and PolyPhen. You can query using the score
            {protein_score}[<|>|<=|>=]{number} or the description
            {protein_score}[~=|=]{description} e.g. polyphen>0.1,sift=tolerant.
        :param str conservation: Filter by conservation score:
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str population_frequency_alt: Alternate Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_ref: Reference Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_maf: Population minor allele
            frequency: {study}:{population}[<|>|<=|>=]{number}. e.g.
            1kG_phase3:ALL<0.01.
        :param str transcript_flag: List of transcript annotation flags. e.g.
            CCDS, basic, cds_end_NF, mRNA_end_NF, cds_start_NF, mRNA_start_NF,
            seleno.
        :param str gene_trait_id: List of gene trait association id. e.g.
            'umls:C0007222' , 'OMIM:269600'.
        :param str go: List of GO (Gene Ontology) terms. e.g. 'GO:0002020'.
        :param str expression: List of tissues of interest. e.g. 'lung'.
        :param str protein_keyword: List of Uniprot protein variant annotation
            keywords.
        :param str drug: List of drug names.
        :param str functional_score: Functional score:
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str clinical_significance: Clinical significance: benign,
            likely_benign, likely_pathogenic, pathogenic.
        :param str custom_annotation: Custom annotation:
            {key}[<|>|<=|>=]{number} or {key}[~=|=]{text}.
        :param str panel: Filter by genes from the given disease panel.
        :param str trait: List of traits, based on ClinVar, HPO, COSMIC, i.e.:
            IDs, histologies, descriptions,...
        """

        return self._get(category='analysis', resource='query', subcategory='clinical/variant', **options)

    def acl(self, clinical_analyses, **options):
        """
        Returns the acl of the clinical analyses. If member is provided, it
            will only return the acl for the member.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalyses}/acl

        :param str clinical_analyses: Comma separated list of clinical
            analysis IDs or names up to a maximum of 100. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str member: User or group ID.
        :param bool silent: Boolean to retrieve all possible entries that are
            queried for, false to raise an exception whenever one of the
            entries looked for cannot be shown for whichever reason.
        """

        return self._get(category='analysis', resource='acl', subcategory='clinical', second_query_id=clinical_analyses, **options)

    def delete(self, clinical_analyses, **options):
        """
        Delete clinical analyses.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalyses}/delete

        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param bool force: Force deletion if the ClinicalAnalysis contains
            interpretations or is locked.
        :param str clinical_analyses: Comma separated list of clinical
            analysis IDs or names up to a maximum of 100.
        """

        return self._delete(category='analysis', resource='delete', subcategory='clinical', second_query_id=clinical_analyses, **options)

    def update(self, clinical_analyses, data=None, **options):
        """
        Update clinical analysis attributes.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalyses}/update

        :param dict data: JSON containing clinical analysis information.
            (REQUIRED)
        :param str clinical_analyses: Comma separated list of clinical
            analysis IDs.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str comments_action: Action to be performed if the array of
            comments is being updated. Allowed values: ['ADD', 'REMOVE',
            'REPLACE']
        :param str flags_action: Action to be performed if the array of flags
            is being updated. Allowed values: ['ADD', 'SET', 'REMOVE']
        :param str files_action: Action to be performed if the array of files
            is being updated. Allowed values: ['ADD', 'SET', 'REMOVE']
        """

        return self._post(category='analysis', resource='update', subcategory='clinical', second_query_id=clinical_analyses, data=data, **options)

    def info(self, clinical_analysis, **options):
        """
        Clinical analysis info.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/info

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str clinical_analysis: Comma separated list of clinical
            analysis IDs or names up to a maximum of 100.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='analysis', resource='info', subcategory='clinical', second_query_id=clinical_analysis, **options)

    def create_interpretation(self, clinical_analysis, data=None, **options):
        """
        Create a new Interpretation.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/create

        :param dict data: JSON containing clinical interpretation information.
            (REQUIRED)
        :param str clinical_analysis: Clinical analysis ID.
        :param str study: [[user@]project:]study id.
        :param str set_as: Set interpretation as. Allowed values: ['PRIMARY',
            'SECONDARY']
        """

        return self._post(category='analysis/clinical', resource='create', query_id=clinical_analysis, subcategory='interpretation', data=data, **options)

    def clear_interpretation(self, clinical_analysis, interpretations, **options):
        """
        Clear the fields of the main interpretation of the Clinical Analysis.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/{interpretations}/clear

        :param str study: [[user@]project:]study ID.
        :param str interpretations: Interpretation IDs of the Clinical
            Analysis.
        :param str clinical_analysis: Clinical analysis ID.
        """

        return self._post(category='analysis/clinical', resource='clear', query_id=clinical_analysis, subcategory='interpretation', second_query_id=interpretations, **options)

    def delete_interpretation(self, clinical_analysis, interpretations, **options):
        """
        Delete interpretation.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/{interpretations}/delete

        :param str study: [[user@]project:]study ID.
        :param str clinical_analysis: Clinical analysis ID.
        :param str interpretations: Interpretation IDs of the Clinical
            Analysis.
        :param str set_as_primary: Interpretation id to set as primary from
            the list of secondaries in case of deleting the actual primary one.
        """

        return self._delete(category='analysis/clinical', resource='delete', query_id=clinical_analysis, subcategory='interpretation', second_query_id=interpretations, **options)

    def merge_interpretation(self, clinical_analysis, interpretation, data=None, **options):
        """
        Merge interpretation.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/{interpretation}/merge

        :param str study: [[user@]project:]study ID.
        :param str clinical_analysis: Clinical analysis ID.
        :param str interpretation: Interpretation ID where it will be merged.
        :param str secondary_interpretation_id: Secondary Interpretation ID to
            merge from.
        :param str findings: Comma separated list of findings to merge. If not
            provided, all findings will be merged.
        :param dict data: JSON containing clinical interpretation to merge
            from.
        """

        return self._post(category='analysis/clinical', resource='merge', query_id=clinical_analysis, subcategory='interpretation', second_query_id=interpretation, data=data, **options)

    def revert_interpretation(self, clinical_analysis, interpretation, version, **options):
        """
        Revert to a previous interpretation version.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/{interpretation}/revert

        :param int version: Version to revert to. (REQUIRED)
        :param str study: [[user@]project:]study ID.
        :param str clinical_analysis: Clinical analysis ID.
        :param str interpretation: Interpretation ID.
        """

        options['version'] = version
        return self._post(category='analysis/clinical', resource='revert', query_id=clinical_analysis, subcategory='interpretation', second_query_id=interpretation, **options)

    def update_interpretation(self, clinical_analysis, interpretation, data=None, **options):
        """
        Update interpretation fields.
        PATH: /{apiVersion}/analysis/clinical/{clinicalAnalysis}/interpretation/{interpretation}/update

        :param dict data: JSON containing clinical interpretation information.
            (REQUIRED)
        :param str study: [[user@]project:]study ID.
        :param str primary_findings_action: Action to be performed if the
            array of primary findings is being updated. Allowed values: ['ADD',
            'SET', 'REMOVE', 'REPLACE']
        :param str methods_action: Action to be performed if the array of
            methods is being updated. Allowed values: ['ADD', 'SET', 'REMOVE']
        :param str secondary_findings_action: Action to be performed if the
            array of secondary findings is being updated. Allowed values:
            ['ADD', 'SET', 'REMOVE', 'REPLACE']
        :param str comments_action: Action to be performed if the array of
            comments is being updated. To REMOVE or REPLACE, the date will need
            to be provided to identify the comment. Allowed values: ['ADD',
            'REMOVE', 'REPLACE']
        :param str set_as: Set interpretation as. Allowed values: ['PRIMARY',
            'SECONDARY']
        :param str clinical_analysis: Clinical analysis ID.
        :param str interpretation: Interpretation ID.
        """

        return self._post(category='analysis/clinical', resource='update', query_id=clinical_analysis, subcategory='interpretation', second_query_id=interpretation, data=data, **options)

