# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Feb 16 18:22:37 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

class tColKey(mettle.io.ISerializable):

    def __init__(self,
                 aud_id: int = 0,
                 name: str = ''):
        """
        Constructor.

        :param aud_id: int
        :param name: str
        """
        self.aud_id = aud_id
        self.name = name

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.aud_id = 0
        self.name = ''

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tColKey'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("aud_id", self.aud_id)
        _w.write_string("name", self.name)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.aud_id = _r.read_int64("aud_id")
        self.name = _r.read_string("name")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tColKey"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.aud_id = rec.aud_id
        self.name = rec.name

    @staticmethod
    def _cache_davs(dvc=None):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("aud_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("name", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("name", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))

        return dvc

    def _get_davs(self, dvc=None):
        tColKey._cache_davs(dvc)

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.aud_id - y.aud_id

        if rc != 0:
            return rc

        rc = (x.name > y.name) - (x.name < y.name)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Col [aud_id:%r, name:%.32s]>' % (
            self.aud_id, self.name)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tColKey.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tColKey()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tColKey.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None):
            return tColKey._cache_davs(dvc)

