# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Feb 16 18:22:37 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.aud import tAud

class dAudInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tAud()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        tran_id: int,
                        action: str,
                        tbl_id: str,
                        tbl_key: str,
                        par_tbl_id: str,
                        par_tbl_key: str) -> "dAudInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param tran_id: int
        :param action: str
        :param tbl_id: str
        :param tbl_key: str
        :param par_tbl_id: str
        :param par_tbl_key: str
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.tran_id = tran_id
        self.irec.action = action
        self.irec.tbl_id = tbl_id
        self.irec.tbl_key = tbl_key
        self.irec.par_tbl_id = par_tbl_id
        self.irec.par_tbl_key = par_tbl_key

        return await self.exec()

    async def exec(self, irec: tAud = None) -> "dAudInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("AudInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into audit.Aud (
  tran_id,
  action,
  tbl_id,
  tbl_key,
  par_tbl_id,
  par_tbl_key
) values (
  :tran_id,
  :action,
  :tbl_id,
  :tbl_key,
  :par_tbl_id,
  :par_tbl_key
)""")

        self._dbstmnt.bind_in("tran_id", self.irec.tran_id, int, 8)
        self._dbstmnt.bind_in("action", self.irec.action, str, 1)
        self._dbstmnt.bind_in("tbl_id", self.irec.tbl_id, str, 64)
        self._dbstmnt.bind_in("tbl_key", self.irec.tbl_key, str, 128)
        self._dbstmnt.bind_in("par_tbl_id", self.irec.par_tbl_id, str, 64)
        self._dbstmnt.bind_in("par_tbl_key", self.irec.par_tbl_key, str, 128)

        await self._dbcon.execute(self._dbstmnt)

        self.irec.id = await self._dbcon.post_get_sequence(self._dbstmnt, "audit.Aud", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

