"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const database_secret_1 = require("./database-secret");
const database_query_1 = require("./private/database-query");
const handler_name_1 = require("./private/database-query-provider/handler-name");
const privileges_1 = require("./private/privileges");
class UserBase extends constructs_1.Construct {
    addTablePrivileges(table, ...actions) {
        if (!this.privileges) {
            this.privileges = new privileges_1.UserTablePrivileges(this, 'TablePrivileges', {
                ...this.databaseProps,
                user: this,
            });
        }
        this.privileges.addPrivileges(table, ...actions);
    }
}
/**
 * A user in a Redshift cluster.
 */
class User extends UserBase {
    /**
     * Specify a Redshift user using credentials that already exist.
     */
    static fromUserAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUserAttributes);
            }
            throw error;
        }
        return new class extends UserBase {
            constructor() {
                super(...arguments);
                this.username = attrs.username;
                this.password = attrs.password;
                this.cluster = attrs.cluster;
                this.databaseName = attrs.databaseName;
                this.databaseProps = attrs;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, User);
            }
            throw error;
        }
        this.databaseProps = props;
        this.cluster = props.cluster;
        this.databaseName = props.databaseName;
        const username = props.username ?? cdk.Names.uniqueId(this).toLowerCase();
        const secret = new database_secret_1.DatabaseSecret(this, 'Secret', {
            username,
            encryptionKey: props.encryptionKey,
        });
        const attachedSecret = secret.attach(props.cluster);
        this.password = attachedSecret.secretValueFromJson('password');
        this.resource = new database_query_1.DatabaseQuery(this, 'Resource', {
            ...this.databaseProps,
            handler: handler_name_1.HandlerName.User,
            properties: {
                username,
                passwordSecretArn: attachedSecret.secretArn,
            },
        });
        attachedSecret.grantRead(this.resource);
        this.username = this.resource.getAttString('username');
        this.secret = secret;
    }
    /**
     * Apply the given removal policy to this resource
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     */
    applyRemovalPolicy(policy) {
        this.resource.applyRemovalPolicy(policy);
    }
}
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.User", version: "2.75.1-alpha.0" };
exports.User = User;
//# sourceMappingURL=data:application/json;base64,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