# pyspray
 CLI interface to streamline the process of making TF2 sprays.

## Installation

In order to use `pyspray`, you must have python installed on your system.

`pyspray` can be installed via `pip` with `py -m pip install pyspray` or `python -m pip install pyspray` via the command line, depending on your platform. For simplicity, all commands will be given using `py` (which is the default alias on some Windows systems).

## Usage And CLI Help
`pyspray` should be run as a module using `py -m pyspray <args>`. In order to see a list of available commands, run `py -m pyspray --help`.

To get further information about any of these commands, run `py -m pyspray <command_name> --help`.

## Commands and Basic Usage Examples
Before creating any sprays, `pyspray` needs to know where your `Team Fortress 2` directory is. These files can be found by right clicking on Team Fortress 2 in your Steam games menu, mousing over the `Manage` tab, and then clicking `Browse Local Files`.

Once you have the file path of the `Team Fortress 2` directory, run `py -m pyspray set-directory <file_path>`
#### Static Sprays

A static spray is simply a single image. To create one, run `py -m pyspray static <filepath_or_url_of_image> --name <name_of_spray>`. The name can be omitted, but the autogenerated names are simply the timestamps of creation, and are easy to mix up.

#### Faded Sprays

A faded spray is a spray that changes as you move closer or further away from it. To create a faded spray, run `py -m pyspray fade <url_or_filepath_of_image> <url_or_filepath_of_image>... --name <name_of_spray>`. The images should be listed such that the first image is the one you want shown from furthest away, and the last image is the one you want shown from nearest.

#### Animated Sprays

An animated spray is a spray that moves, and can be made from filetypes like gifs, webms, and mp4s. To create an animated spray, run `py -m pyspray anim <path_or_url_to_animated_file> --name <name_of_spray>`. Note that this works best with short animations, as sprays have a filesize limit of 512 KB. 