"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderAmazon = void 0;
const cognito_generated_1 = require("../cognito.generated");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
/**
 * Represents a identity provider that integrates with 'Login with Amazon'.
 *
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderAmazon extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'LoginWithAmazon',
            providerType: 'LoginWithAmazon',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderAmazon = UserPoolIdentityProviderAmazon;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW1hem9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYW1hem9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDREQUFtRTtBQUVuRSxxRUFBNEU7Ozs7OztBQTRCNUUsTUFBYSw4QkFBK0IsU0FBUSxpREFBNEI7Ozs7SUFHOUUsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQzs7UUFDbEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsTUFBTSxNQUFNLFNBQUcsS0FBSyxDQUFDLE1BQU0sbUNBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUUzQyxNQUFNLFFBQVEsR0FBRyxJQUFJLCtDQUEyQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDakUsVUFBVSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsVUFBVTtZQUNyQyxZQUFZLEVBQUUsaUJBQWlCO1lBQy9CLFlBQVksRUFBRSxpQkFBaUI7WUFDL0IsZUFBZSxFQUFFO2dCQUNmLFNBQVMsRUFBRSxLQUFLLENBQUMsUUFBUTtnQkFDekIsYUFBYSxFQUFFLEtBQUssQ0FBQyxZQUFZO2dCQUNqQyxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQzthQUNuQztZQUNELGdCQUFnQixFQUFFLEtBQUssQ0FBQyx5QkFBeUIsRUFBRTtTQUNwRCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDbkUsQ0FBQztDQUNGO0FBdEJELHdFQXNCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyIH0gZnJvbSAnLi4vY29nbml0by5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyUHJvcHMgfSBmcm9tICcuL2Jhc2UnO1xuaW1wb3J0IHsgVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyQmFzZSB9IGZyb20gJy4vcHJpdmF0ZS91c2VyLXBvb2wtaWRwLWJhc2UnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyQW1hem9uUHJvcHMgZXh0ZW5kcyBVc2VyUG9vbElkZW50aXR5UHJvdmlkZXJQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsaWVudElkOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2xpZW50U2VjcmV0OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY29wZXM/OiBzdHJpbmdbXTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBVc2VyUG9vbElkZW50aXR5UHJvdmlkZXJBbWF6b24gZXh0ZW5kcyBVc2VyUG9vbElkZW50aXR5UHJvdmlkZXJCYXNlIHtcbiAgcHVibGljIHJlYWRvbmx5IHByb3ZpZGVyTmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBVc2VyUG9vbElkZW50aXR5UHJvdmlkZXJBbWF6b25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3Qgc2NvcGVzID0gcHJvcHMuc2NvcGVzID8/IFsncHJvZmlsZSddO1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHVzZXJQb29sSWQ6IHByb3BzLnVzZXJQb29sLnVzZXJQb29sSWQsXG4gICAgICBwcm92aWRlck5hbWU6ICdMb2dpbldpdGhBbWF6b24nLCAvLyBtdXN0IGJlICdMb2dpbldpdGhBbWF6b24nIHdoZW4gdGhlIHR5cGUgaXMgJ0xvZ2luV2l0aEFtYXpvbidcbiAgICAgIHByb3ZpZGVyVHlwZTogJ0xvZ2luV2l0aEFtYXpvbicsXG4gICAgICBwcm92aWRlckRldGFpbHM6IHtcbiAgICAgICAgY2xpZW50X2lkOiBwcm9wcy5jbGllbnRJZCxcbiAgICAgICAgY2xpZW50X3NlY3JldDogcHJvcHMuY2xpZW50U2VjcmV0LFxuICAgICAgICBhdXRob3JpemVfc2NvcGVzOiBzY29wZXMuam9pbignICcpLFxuICAgICAgfSxcbiAgICAgIGF0dHJpYnV0ZU1hcHBpbmc6IHN1cGVyLmNvbmZpZ3VyZUF0dHJpYnV0ZU1hcHBpbmcoKSxcbiAgICB9KTtcblxuICAgIHRoaXMucHJvdmlkZXJOYW1lID0gc3VwZXIuZ2V0UmVzb3VyY2VOYW1lQXR0cmlidXRlKHJlc291cmNlLnJlZik7XG4gIH1cbn0iXX0=