# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ward']

package_data = \
{'': ['*']}

install_requires = \
['click-completion>=0.5.2,<0.6.0',
 'click-default-group>=1.2.2,<2.0.0',
 'click>=7.0,<8.0',
 'colorama>=0.4.0,<0.5.0',
 'cucumber-tag-expressions>=2.0.0,<3.0.0',
 'pprintpp>=0.4.0,<0.5.0',
 'pygments>=2.4.2,<3.0.0',
 'rich>=9.1.0,<10.0.0',
 'termcolor>=1.1.0,<2.0.0',
 'toml>=0.10.1,<0.11.0']

extras_require = \
{':python_version == "3.6"': ['dataclasses>=0.7,<0.8']}

entry_points = \
{'console_scripts': ['ward = ward.run:run']}

setup_kwargs = {
    'name': 'ward',
    'version': '0.51.1b0',
    'description': 'A modern Python testing framework',
    'long_description': '# Ward\n![Build](https://github.com/darrenburns/ward/workflows/Build/badge.svg)\n[![Codecov](https://codecov.io/gh/darrenburns/ward/branch/master/graph/badge.svg)](https://codecov.io/gh/darrenburns/ward)\n[![PyPI version](https://badge.fury.io/py/ward.svg)](https://badge.fury.io/py/ward)\n<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->\n[![All Contributors](https://img.shields.io/badge/all_contributors-14-orange.svg?style=flat-square)](#contributors-)\n<!-- ALL-CONTRIBUTORS-BADGE:END -->\n\nSee the full documentation and feature set [here](https://wardpy.com).\n\nA modern Python test framework designed to help you find and fix flaws faster.\n\n<img width="567" alt="image" src="https://user-images.githubusercontent.com/5740731/111796103-bfa00b00-88bf-11eb-91a5-63622b2426c1.png">\n\n## Features\n\n**Descriptive test names:** describe what your tests do using strings, not function names.\n```python\n@test("1 + 2 == 3")\ndef _():\n    assert 1 + 2 == 3\n```\n\n**Modular test dependencies:** manage test setup/teardown code using fixtures that rely on Python\'s import system, not\nname matching.\n```python\n@fixture\ndef user():\n    return User(name="darren")\n    \n@test("the user is called darren")\ndef _(u=user):\n    assert u.name == "darren"\n```\n\n**Support for asyncio**: define your tests and fixtures with `async def` and call asynchronous code within them.\n\n```python\n@fixture\nasync def user():\n    u = await create_user()\n    return await u.login()\n\n@test("the logged in user has a last session date")\nasync def _(user=user):\n    last_session = await get_last_session_date(user.id)\n    assert is_recent(last_session, get_last_session_date)\n```\n\n**Powerful test selection:** limit your test run not only by matching test names/descriptions, but also on the code \ncontained in the body of the test.\n```\nward --search "Database.get_all_users"\n```\nOr use tag expressions for more powerful filtering.\n```\nward --tags "(unit or integration) and not slow"\n```\n\n**Parameterised testing:** write a test once, and call it multiple times with different inputs\n```python\n@test("truncate(\'{text}\', num_chars={num_chars}) returns \'{expected}\'")\ndef _(\n    text=s,\n    num_chars=each(20, 11, 10, 5),\n    expected=each(s, s, "hello w...", "he..."),\n):\n    result = truncate(text, num_chars)\n    assert result == expected\n```\n\n**Cross platform:** Tested on Mac OS, Linux, and Windows.\n\n**Zero config:** Sensible defaults mean running `ward` with no arguments is enough to get started. Can be configured using `pyproject.toml` or the command line if required.\n\n**Colourful, human readable output:** quickly pinpoint and fix issues with detailed output for failing tests.\n\nThis project is currently in beta.\n\nPlanned features:\n\n* Smart test execution order designed to surface failures faster (using various heuristics)\n* Multi-process mode to improve performance\n* Code coverage with `--coverage` flag\n* Handling flaky tests with test-specific retries, timeouts\n* Plugin system\n\nLet me know if you\'d like to help out with any of these features!\n\n## Getting Started\n\n[Take a look at the "Getting Started" tutorial.](https://wardpy.com/guide/tutorial)\n\n## How to Contribute\n\nContributions are very welcome and encouraged!\n\nSee the [contributing guide](.github/CONTRIBUTING.md) for information on how you can take part in the development of Ward.\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://darrenburns.net"><img src="https://avatars0.githubusercontent.com/u/5740731?v=4" width="60px;" alt=""/><br /><sub><b>Darren Burns</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=darrenburns" title="Code">💻</a> <a href="https://github.com/darrenburns/ward/commits?author=darrenburns" title="Documentation">📖</a> <a href="#ideas-darrenburns" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/darrenburns/ward/pulls?q=is%3Apr+reviewed-by%3Adarrenburns" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/darrenburns/ward/issues?q=author%3Adarrenburns" title="Bug reports">🐛</a> <a href="#example-darrenburns" title="Examples">💡</a></td>\n    <td align="center"><a href="https://github.com/khusrokarim"><img src="https://avatars0.githubusercontent.com/u/1615476?v=4" width="60px;" alt=""/><br /><sub><b>khusrokarim</b></sub></a><br /><a href="#ideas-khusrokarim" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/darrenburns/ward/commits?author=khusrokarim" title="Code">💻</a> <a href="https://github.com/darrenburns/ward/issues?q=author%3Akhusrokarim" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/AlecJ"><img src="https://avatars2.githubusercontent.com/u/5054790?v=4" width="60px;" alt=""/><br /><sub><b>Alec Jordan</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=AlecJ" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.indeliblebluepen.com"><img src="https://avatars2.githubusercontent.com/u/7471402?v=4" width="60px;" alt=""/><br /><sub><b>Jason C. McDonald</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=CodeMouse92" title="Code">💻</a> <a href="#ideas-CodeMouse92" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/AndydeCleyre"><img src="https://avatars3.githubusercontent.com/u/1787385?v=4" width="60px;" alt=""/><br /><sub><b>Andy Kluger</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=AndydeCleyre" title="Code">💻</a> <a href="#ideas-AndydeCleyre" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://forum.thebigmunch.me"><img src="https://avatars0.githubusercontent.com/u/118418?v=4" width="60px;" alt=""/><br /><sub><b>thebigmunch</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=thebigmunch" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/onlyanegg"><img src="https://avatars0.githubusercontent.com/u/7731128?v=4" width="60px;" alt=""/><br /><sub><b>Tyler Couto</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=onlyanegg" title="Code">💻</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/thilp"><img src="https://avatars2.githubusercontent.com/u/968838?v=4" width="60px;" alt=""/><br /><sub><b>Thibaut Le Page</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=thilp" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/DorianCzichotzki"><img src="https://avatars1.githubusercontent.com/u/10177001?v=4" width="60px;" alt=""/><br /><sub><b>Dorian Czichotzki</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=DorianCzichotzki" title="Code">💻</a> <a href="#ideas-DorianCzichotzki" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/jayeshathila"><img src="https://avatars0.githubusercontent.com/u/1469191?v=4" width="60px;" alt=""/><br /><sub><b>jayesh hathila</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=jayeshathila" title="Code">💻</a></td>\n    <td align="center"><a href="https://mandarvaze.bitbucket.io/"><img src="https://avatars1.githubusercontent.com/u/46438?v=4" width="60px;" alt=""/><br /><sub><b>Mandar Vaze</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=mandarvaze" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.jtk.dev"><img src="https://avatars2.githubusercontent.com/u/7133863?v=4" width="60px;" alt=""/><br /><sub><b>Josh Karpel</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=JoshKarpel" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.lutro.me"><img src="https://avatars0.githubusercontent.com/u/163093?v=4" width="60px;" alt=""/><br /><sub><b>Andreas Lutro</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=anlutro" title="Code">💻</a></td>\n    <td align="center"><a href="https://hoefling.io"><img src="https://avatars1.githubusercontent.com/u/4455652?v=4" width="60px;" alt=""/><br /><sub><b>Oleg Höfling</b></sub></a><br /><a href="https://github.com/darrenburns/ward/commits?author=hoefling" title="Code">💻</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-enable -->\n<!-- prettier-ignore-end -->\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n',
    'author': 'Darren Burns',
    'author_email': 'darrenb900@gmail.com',
    'maintainer': 'Darren Burns',
    'maintainer_email': 'darrenb900@gmail.com',
    'url': 'https://wardpy.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
