# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SlackRecipientArgs', 'SlackRecipient']

@pulumi.input_type
class SlackRecipientArgs:
    def __init__(__self__, *,
                 channel: pulumi.Input[str]):
        """
        The set of arguments for constructing a SlackRecipient resource.
        :param pulumi.Input[str] channel: The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Input[str]:
        """
        The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel", value)


@pulumi.input_type
class _SlackRecipientState:
    def __init__(__self__, *,
                 channel: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SlackRecipient resources.
        :param pulumi.Input[str] channel: The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel", value)


class SlackRecipient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: SlackRecipient

        `SlackRecipient` allows you to define and manage a Slack channel or user recipient that can be used by Triggers or BurnAlerts notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        alerts = honeycomb.SlackRecipient("alerts", channel="#alerts")
        ```

        ## Import

        Slack Recipients can be imported by their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/slackRecipient:SlackRecipient my_recipient nx2zsegA0dZ
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel: The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SlackRecipientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: SlackRecipient

        `SlackRecipient` allows you to define and manage a Slack channel or user recipient that can be used by Triggers or BurnAlerts notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        alerts = honeycomb.SlackRecipient("alerts", channel="#alerts")
        ```

        ## Import

        Slack Recipients can be imported by their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/slackRecipient:SlackRecipient my_recipient nx2zsegA0dZ
        ```

        :param str resource_name: The name of the resource.
        :param SlackRecipientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SlackRecipientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SlackRecipientArgs.__new__(SlackRecipientArgs)

            if channel is None and not opts.urn:
                raise TypeError("Missing required property 'channel'")
            __props__.__dict__["channel"] = channel
        super(SlackRecipient, __self__).__init__(
            'honeycomb:index/slackRecipient:SlackRecipient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel: Optional[pulumi.Input[str]] = None) -> 'SlackRecipient':
        """
        Get an existing SlackRecipient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel: The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SlackRecipientState.__new__(_SlackRecipientState)

        __props__.__dict__["channel"] = channel
        return SlackRecipient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[str]:
        """
        The Slack channel or username to send the notification to. Must begin with `#` or `@`.
        """
        return pulumi.get(self, "channel")

